(function(global) { "use strict";
var __defProp2 = Object.defineProperty;
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __defNormalProp2 = (obj, key2, value) => key2 in obj ? __defProp2(obj, key2, { enumerable: true, configurable: true, writable: true, value }) : obj[key2] = value;
var __publicField2 = (obj, key2, value) => __defNormalProp2(obj, typeof key2 !== "symbol" ? key2 + "" : key2, value);
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, "write to private field"), setter ? setter.call(obj, value) : member.set(obj, value), value);
var __privateMethod = (obj, member, method) => (__accessCheck(obj, member, "access private method"), method);
var __privateWrapper = (obj, member, setter, getter) => ({
  set _(value) {
    __privateSet(obj, member, value, setter);
  },
  get _() {
    return __privateGet(obj, member, getter);
  }
});
var _a2, _b, _provider, _providerCalled, _c, _focused, _cleanup, _setup, _d, _online, _cleanup2, _setup2, _e, _gcTimeout, _f, _initialState, _revertState, _cache, _client, _retryer, _defaultOptions, _abortSignalConsumed, _Query_instances, dispatch_fn, _g, _client2, _currentQuery, _currentQueryInitialState, _currentResult, _currentResultState, _currentResultOptions, _currentThenable, _selectError, _selectFn, _selectResult, _lastQueryWithDefinedData, _staleTimeoutId, _refetchIntervalId, _currentRefetchInterval, _trackedProps, _QueryObserver_instances, executeFetch_fn, updateStaleTimeout_fn, computeRefetchInterval_fn, updateRefetchInterval_fn, updateTimers_fn, clearStaleTimeout_fn, clearRefetchInterval_fn, updateQuery_fn, notify_fn, _h, _client3, _observers, _mutationCache, _retryer2, _Mutation_instances, dispatch_fn2, _i, _mutations, _scopes, _mutationId, _j, _client4, _currentResult2, _currentMutation, _mutateOptions, _MutationObserver_instances, updateResult_fn, notify_fn2, _k, _queries, _l, _queryCache, _mutationCache2, _defaultOptions2, _queryDefaults, _mutationDefaults, _mountCount, _unsubscribeFocus, _unsubscribeOnline, _m;
const uxp = require("uxp");
const photoshop = require("photoshop");
var commonjsGlobal$1 = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getDefaultExportFromCjs$1(x2) {
  return x2 && x2.__esModule && Object.prototype.hasOwnProperty.call(x2, "default") ? x2["default"] : x2;
}
function getAugmentedNamespace$1(n2) {
  if (Object.prototype.hasOwnProperty.call(n2, "__esModule")) return n2;
  var f2 = n2.default;
  if (typeof f2 == "function") {
    var a2 = function a3() {
      if (this instanceof a3) {
        return Reflect.construct(f2, arguments, this.constructor);
      }
      return f2.apply(this, arguments);
    };
    a2.prototype = f2.prototype;
  } else a2 = {};
  Object.defineProperty(a2, "__esModule", { value: true });
  Object.keys(n2).forEach(function(k2) {
    var d = Object.getOwnPropertyDescriptor(n2, k2);
    Object.defineProperty(a2, k2, d.get ? d : {
      enumerable: true,
      get: function() {
        return n2[k2];
      }
    });
  });
  return a2;
}
var buffer$1 = {};
var base64Js = {};
var hasRequiredBase64Js;
function requireBase64Js() {
  if (hasRequiredBase64Js) return base64Js;
  hasRequiredBase64Js = 1;
  base64Js.byteLength = byteLength2;
  base64Js.toByteArray = toByteArray2;
  base64Js.fromByteArray = fromByteArray2;
  var lookup2 = [];
  var revLookup2 = [];
  var Arr2 = typeof Uint8Array !== "undefined" ? Uint8Array : Array;
  var code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  for (var i2 = 0, len = code.length; i2 < len; ++i2) {
    lookup2[i2] = code[i2];
    revLookup2[code.charCodeAt(i2)] = i2;
  }
  revLookup2["-".charCodeAt(0)] = 62;
  revLookup2["_".charCodeAt(0)] = 63;
  function getLens(b64) {
    var len2 = b64.length;
    if (len2 % 4 > 0) {
      throw new Error("Invalid string. Length must be a multiple of 4");
    }
    var validLen = b64.indexOf("=");
    if (validLen === -1) validLen = len2;
    var placeHoldersLen = validLen === len2 ? 0 : 4 - validLen % 4;
    return [validLen, placeHoldersLen];
  }
  function byteLength2(b64) {
    var lens = getLens(b64);
    var validLen = lens[0];
    var placeHoldersLen = lens[1];
    return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
  }
  function _byteLength(b64, validLen, placeHoldersLen) {
    return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
  }
  function toByteArray2(b64) {
    var tmp;
    var lens = getLens(b64);
    var validLen = lens[0];
    var placeHoldersLen = lens[1];
    var arr = new Arr2(_byteLength(b64, validLen, placeHoldersLen));
    var curByte = 0;
    var len2 = placeHoldersLen > 0 ? validLen - 4 : validLen;
    var i3;
    for (i3 = 0; i3 < len2; i3 += 4) {
      tmp = revLookup2[b64.charCodeAt(i3)] << 18 | revLookup2[b64.charCodeAt(i3 + 1)] << 12 | revLookup2[b64.charCodeAt(i3 + 2)] << 6 | revLookup2[b64.charCodeAt(i3 + 3)];
      arr[curByte++] = tmp >> 16 & 255;
      arr[curByte++] = tmp >> 8 & 255;
      arr[curByte++] = tmp & 255;
    }
    if (placeHoldersLen === 2) {
      tmp = revLookup2[b64.charCodeAt(i3)] << 2 | revLookup2[b64.charCodeAt(i3 + 1)] >> 4;
      arr[curByte++] = tmp & 255;
    }
    if (placeHoldersLen === 1) {
      tmp = revLookup2[b64.charCodeAt(i3)] << 10 | revLookup2[b64.charCodeAt(i3 + 1)] << 4 | revLookup2[b64.charCodeAt(i3 + 2)] >> 2;
      arr[curByte++] = tmp >> 8 & 255;
      arr[curByte++] = tmp & 255;
    }
    return arr;
  }
  function tripletToBase642(num) {
    return lookup2[num >> 18 & 63] + lookup2[num >> 12 & 63] + lookup2[num >> 6 & 63] + lookup2[num & 63];
  }
  function encodeChunk2(uint8, start, end) {
    var tmp;
    var output = [];
    for (var i3 = start; i3 < end; i3 += 3) {
      tmp = (uint8[i3] << 16 & 16711680) + (uint8[i3 + 1] << 8 & 65280) + (uint8[i3 + 2] & 255);
      output.push(tripletToBase642(tmp));
    }
    return output.join("");
  }
  function fromByteArray2(uint8) {
    var tmp;
    var len2 = uint8.length;
    var extraBytes = len2 % 3;
    var parts = [];
    var maxChunkLength = 16383;
    for (var i3 = 0, len22 = len2 - extraBytes; i3 < len22; i3 += maxChunkLength) {
      parts.push(encodeChunk2(uint8, i3, i3 + maxChunkLength > len22 ? len22 : i3 + maxChunkLength));
    }
    if (extraBytes === 1) {
      tmp = uint8[len2 - 1];
      parts.push(
        lookup2[tmp >> 2] + lookup2[tmp << 4 & 63] + "=="
      );
    } else if (extraBytes === 2) {
      tmp = (uint8[len2 - 2] << 8) + uint8[len2 - 1];
      parts.push(
        lookup2[tmp >> 10] + lookup2[tmp >> 4 & 63] + lookup2[tmp << 2 & 63] + "="
      );
    }
    return parts.join("");
  }
  return base64Js;
}
var ieee754$1 = {};
/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */
var hasRequiredIeee754;
function requireIeee754() {
  if (hasRequiredIeee754) return ieee754$1;
  hasRequiredIeee754 = 1;
  ieee754$1.read = function(buffer2, offset, isLE, mLen, nBytes) {
    var e4, m;
    var eLen = nBytes * 8 - mLen - 1;
    var eMax = (1 << eLen) - 1;
    var eBias = eMax >> 1;
    var nBits = -7;
    var i2 = isLE ? nBytes - 1 : 0;
    var d = isLE ? -1 : 1;
    var s2 = buffer2[offset + i2];
    i2 += d;
    e4 = s2 & (1 << -nBits) - 1;
    s2 >>= -nBits;
    nBits += eLen;
    for (; nBits > 0; e4 = e4 * 256 + buffer2[offset + i2], i2 += d, nBits -= 8) {
    }
    m = e4 & (1 << -nBits) - 1;
    e4 >>= -nBits;
    nBits += mLen;
    for (; nBits > 0; m = m * 256 + buffer2[offset + i2], i2 += d, nBits -= 8) {
    }
    if (e4 === 0) {
      e4 = 1 - eBias;
    } else if (e4 === eMax) {
      return m ? NaN : (s2 ? -1 : 1) * Infinity;
    } else {
      m = m + Math.pow(2, mLen);
      e4 = e4 - eBias;
    }
    return (s2 ? -1 : 1) * m * Math.pow(2, e4 - mLen);
  };
  ieee754$1.write = function(buffer2, value, offset, isLE, mLen, nBytes) {
    var e4, m, c2;
    var eLen = nBytes * 8 - mLen - 1;
    var eMax = (1 << eLen) - 1;
    var eBias = eMax >> 1;
    var rt = mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0;
    var i2 = isLE ? 0 : nBytes - 1;
    var d = isLE ? 1 : -1;
    var s2 = value < 0 || value === 0 && 1 / value < 0 ? 1 : 0;
    value = Math.abs(value);
    if (isNaN(value) || value === Infinity) {
      m = isNaN(value) ? 1 : 0;
      e4 = eMax;
    } else {
      e4 = Math.floor(Math.log(value) / Math.LN2);
      if (value * (c2 = Math.pow(2, -e4)) < 1) {
        e4--;
        c2 *= 2;
      }
      if (e4 + eBias >= 1) {
        value += rt / c2;
      } else {
        value += rt * Math.pow(2, 1 - eBias);
      }
      if (value * c2 >= 2) {
        e4++;
        c2 /= 2;
      }
      if (e4 + eBias >= eMax) {
        m = 0;
        e4 = eMax;
      } else if (e4 + eBias >= 1) {
        m = (value * c2 - 1) * Math.pow(2, mLen);
        e4 = e4 + eBias;
      } else {
        m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
        e4 = 0;
      }
    }
    for (; mLen >= 8; buffer2[offset + i2] = m & 255, i2 += d, m /= 256, mLen -= 8) {
    }
    e4 = e4 << mLen | m;
    eLen += mLen;
    for (; eLen > 0; buffer2[offset + i2] = e4 & 255, i2 += d, e4 /= 256, eLen -= 8) {
    }
    buffer2[offset + i2 - d] |= s2 * 128;
  };
  return ieee754$1;
}
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
var hasRequiredBuffer$1;
function requireBuffer$1() {
  if (hasRequiredBuffer$1) return buffer$1;
  hasRequiredBuffer$1 = 1;
  (function(exports) {
    const base64 = requireBase64Js();
    const ieee7542 = requireIeee754();
    const customInspectSymbol = typeof Symbol === "function" && typeof Symbol["for"] === "function" ? Symbol["for"]("nodejs.util.inspect.custom") : null;
    exports.Buffer = Buffer2;
    exports.SlowBuffer = SlowBuffer;
    exports.INSPECT_MAX_BYTES = 50;
    const K_MAX_LENGTH = 2147483647;
    exports.kMaxLength = K_MAX_LENGTH;
    Buffer2.TYPED_ARRAY_SUPPORT = typedArraySupport();
    if (!Buffer2.TYPED_ARRAY_SUPPORT && typeof console !== "undefined" && typeof console.error === "function") {
      console.error(
        "This browser lacks typed array (Uint8Array) support which is required by `buffer` v5.x. Use `buffer` v4.x if you require old browser support."
      );
    }
    function typedArraySupport() {
      try {
        const arr = new Uint8Array(1);
        const proto = { foo: function() {
          return 42;
        } };
        Object.setPrototypeOf(proto, Uint8Array.prototype);
        Object.setPrototypeOf(arr, proto);
        return arr.foo() === 42;
      } catch (e4) {
        return false;
      }
    }
    Object.defineProperty(Buffer2.prototype, "parent", {
      enumerable: true,
      get: function() {
        if (!Buffer2.isBuffer(this)) return void 0;
        return this.buffer;
      }
    });
    Object.defineProperty(Buffer2.prototype, "offset", {
      enumerable: true,
      get: function() {
        if (!Buffer2.isBuffer(this)) return void 0;
        return this.byteOffset;
      }
    });
    function createBuffer2(length) {
      if (length > K_MAX_LENGTH) {
        throw new RangeError('The value "' + length + '" is invalid for option "size"');
      }
      const buf = new Uint8Array(length);
      Object.setPrototypeOf(buf, Buffer2.prototype);
      return buf;
    }
    function Buffer2(arg, encodingOrOffset, length) {
      if (typeof arg === "number") {
        if (typeof encodingOrOffset === "string") {
          throw new TypeError(
            'The "string" argument must be of type string. Received type number'
          );
        }
        return allocUnsafe2(arg);
      }
      return from2(arg, encodingOrOffset, length);
    }
    Buffer2.poolSize = 8192;
    function from2(value, encodingOrOffset, length) {
      if (typeof value === "string") {
        return fromString2(value, encodingOrOffset);
      }
      if (ArrayBuffer.isView(value)) {
        return fromArrayView(value);
      }
      if (value == null) {
        throw new TypeError(
          "The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type " + typeof value
        );
      }
      if (isInstance(value, ArrayBuffer) || value && isInstance(value.buffer, ArrayBuffer)) {
        return fromArrayBuffer2(value, encodingOrOffset, length);
      }
      if (typeof SharedArrayBuffer !== "undefined" && (isInstance(value, SharedArrayBuffer) || value && isInstance(value.buffer, SharedArrayBuffer))) {
        return fromArrayBuffer2(value, encodingOrOffset, length);
      }
      if (typeof value === "number") {
        throw new TypeError(
          'The "value" argument must not be of type number. Received type number'
        );
      }
      const valueOf = value.valueOf && value.valueOf();
      if (valueOf != null && valueOf !== value) {
        return Buffer2.from(valueOf, encodingOrOffset, length);
      }
      const b2 = fromObject2(value);
      if (b2) return b2;
      if (typeof Symbol !== "undefined" && Symbol.toPrimitive != null && typeof value[Symbol.toPrimitive] === "function") {
        return Buffer2.from(value[Symbol.toPrimitive]("string"), encodingOrOffset, length);
      }
      throw new TypeError(
        "The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type " + typeof value
      );
    }
    Buffer2.from = function(value, encodingOrOffset, length) {
      return from2(value, encodingOrOffset, length);
    };
    Object.setPrototypeOf(Buffer2.prototype, Uint8Array.prototype);
    Object.setPrototypeOf(Buffer2, Uint8Array);
    function assertSize2(size) {
      if (typeof size !== "number") {
        throw new TypeError('"size" argument must be of type number');
      } else if (size < 0) {
        throw new RangeError('The value "' + size + '" is invalid for option "size"');
      }
    }
    function alloc2(size, fill, encoding) {
      assertSize2(size);
      if (size <= 0) {
        return createBuffer2(size);
      }
      if (fill !== void 0) {
        return typeof encoding === "string" ? createBuffer2(size).fill(fill, encoding) : createBuffer2(size).fill(fill);
      }
      return createBuffer2(size);
    }
    Buffer2.alloc = function(size, fill, encoding) {
      return alloc2(size, fill, encoding);
    };
    function allocUnsafe2(size) {
      assertSize2(size);
      return createBuffer2(size < 0 ? 0 : checked2(size) | 0);
    }
    Buffer2.allocUnsafe = function(size) {
      return allocUnsafe2(size);
    };
    Buffer2.allocUnsafeSlow = function(size) {
      return allocUnsafe2(size);
    };
    function fromString2(string, encoding) {
      if (typeof encoding !== "string" || encoding === "") {
        encoding = "utf8";
      }
      if (!Buffer2.isEncoding(encoding)) {
        throw new TypeError("Unknown encoding: " + encoding);
      }
      const length = byteLength2(string, encoding) | 0;
      let buf = createBuffer2(length);
      const actual = buf.write(string, encoding);
      if (actual !== length) {
        buf = buf.slice(0, actual);
      }
      return buf;
    }
    function fromArrayLike2(array) {
      const length = array.length < 0 ? 0 : checked2(array.length) | 0;
      const buf = createBuffer2(length);
      for (let i2 = 0; i2 < length; i2 += 1) {
        buf[i2] = array[i2] & 255;
      }
      return buf;
    }
    function fromArrayView(arrayView) {
      if (isInstance(arrayView, Uint8Array)) {
        const copy2 = new Uint8Array(arrayView);
        return fromArrayBuffer2(copy2.buffer, copy2.byteOffset, copy2.byteLength);
      }
      return fromArrayLike2(arrayView);
    }
    function fromArrayBuffer2(array, byteOffset, length) {
      if (byteOffset < 0 || array.byteLength < byteOffset) {
        throw new RangeError('"offset" is outside of buffer bounds');
      }
      if (array.byteLength < byteOffset + (length || 0)) {
        throw new RangeError('"length" is outside of buffer bounds');
      }
      let buf;
      if (byteOffset === void 0 && length === void 0) {
        buf = new Uint8Array(array);
      } else if (length === void 0) {
        buf = new Uint8Array(array, byteOffset);
      } else {
        buf = new Uint8Array(array, byteOffset, length);
      }
      Object.setPrototypeOf(buf, Buffer2.prototype);
      return buf;
    }
    function fromObject2(obj) {
      if (Buffer2.isBuffer(obj)) {
        const len = checked2(obj.length) | 0;
        const buf = createBuffer2(len);
        if (buf.length === 0) {
          return buf;
        }
        obj.copy(buf, 0, 0, len);
        return buf;
      }
      if (obj.length !== void 0) {
        if (typeof obj.length !== "number" || numberIsNaN(obj.length)) {
          return createBuffer2(0);
        }
        return fromArrayLike2(obj);
      }
      if (obj.type === "Buffer" && Array.isArray(obj.data)) {
        return fromArrayLike2(obj.data);
      }
    }
    function checked2(length) {
      if (length >= K_MAX_LENGTH) {
        throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x" + K_MAX_LENGTH.toString(16) + " bytes");
      }
      return length | 0;
    }
    function SlowBuffer(length) {
      if (+length != length) {
        length = 0;
      }
      return Buffer2.alloc(+length);
    }
    Buffer2.isBuffer = function isBuffer2(b2) {
      return b2 != null && b2._isBuffer === true && b2 !== Buffer2.prototype;
    };
    Buffer2.compare = function compare(a2, b2) {
      if (isInstance(a2, Uint8Array)) a2 = Buffer2.from(a2, a2.offset, a2.byteLength);
      if (isInstance(b2, Uint8Array)) b2 = Buffer2.from(b2, b2.offset, b2.byteLength);
      if (!Buffer2.isBuffer(a2) || !Buffer2.isBuffer(b2)) {
        throw new TypeError(
          'The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array'
        );
      }
      if (a2 === b2) return 0;
      let x2 = a2.length;
      let y2 = b2.length;
      for (let i2 = 0, len = Math.min(x2, y2); i2 < len; ++i2) {
        if (a2[i2] !== b2[i2]) {
          x2 = a2[i2];
          y2 = b2[i2];
          break;
        }
      }
      if (x2 < y2) return -1;
      if (y2 < x2) return 1;
      return 0;
    };
    Buffer2.isEncoding = function isEncoding(encoding) {
      switch (String(encoding).toLowerCase()) {
        case "hex":
        case "utf8":
        case "utf-8":
        case "ascii":
        case "latin1":
        case "binary":
        case "base64":
        case "ucs2":
        case "ucs-2":
        case "utf16le":
        case "utf-16le":
          return true;
        default:
          return false;
      }
    };
    Buffer2.concat = function concat(list, length) {
      if (!Array.isArray(list)) {
        throw new TypeError('"list" argument must be an Array of Buffers');
      }
      if (list.length === 0) {
        return Buffer2.alloc(0);
      }
      let i2;
      if (length === void 0) {
        length = 0;
        for (i2 = 0; i2 < list.length; ++i2) {
          length += list[i2].length;
        }
      }
      const buffer2 = Buffer2.allocUnsafe(length);
      let pos = 0;
      for (i2 = 0; i2 < list.length; ++i2) {
        let buf = list[i2];
        if (isInstance(buf, Uint8Array)) {
          if (pos + buf.length > buffer2.length) {
            if (!Buffer2.isBuffer(buf)) buf = Buffer2.from(buf);
            buf.copy(buffer2, pos);
          } else {
            Uint8Array.prototype.set.call(
              buffer2,
              buf,
              pos
            );
          }
        } else if (!Buffer2.isBuffer(buf)) {
          throw new TypeError('"list" argument must be an Array of Buffers');
        } else {
          buf.copy(buffer2, pos);
        }
        pos += buf.length;
      }
      return buffer2;
    };
    function byteLength2(string, encoding) {
      if (Buffer2.isBuffer(string)) {
        return string.length;
      }
      if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) {
        return string.byteLength;
      }
      if (typeof string !== "string") {
        throw new TypeError(
          'The "string" argument must be one of type string, Buffer, or ArrayBuffer. Received type ' + typeof string
        );
      }
      const len = string.length;
      const mustMatch = arguments.length > 2 && arguments[2] === true;
      if (!mustMatch && len === 0) return 0;
      let loweredCase = false;
      for (; ; ) {
        switch (encoding) {
          case "ascii":
          case "latin1":
          case "binary":
            return len;
          case "utf8":
          case "utf-8":
            return utf8ToBytes2(string).length;
          case "ucs2":
          case "ucs-2":
          case "utf16le":
          case "utf-16le":
            return len * 2;
          case "hex":
            return len >>> 1;
          case "base64":
            return base64ToBytes2(string).length;
          default:
            if (loweredCase) {
              return mustMatch ? -1 : utf8ToBytes2(string).length;
            }
            encoding = ("" + encoding).toLowerCase();
            loweredCase = true;
        }
      }
    }
    Buffer2.byteLength = byteLength2;
    function slowToString2(encoding, start, end) {
      let loweredCase = false;
      if (start === void 0 || start < 0) {
        start = 0;
      }
      if (start > this.length) {
        return "";
      }
      if (end === void 0 || end > this.length) {
        end = this.length;
      }
      if (end <= 0) {
        return "";
      }
      end >>>= 0;
      start >>>= 0;
      if (end <= start) {
        return "";
      }
      if (!encoding) encoding = "utf8";
      while (true) {
        switch (encoding) {
          case "hex":
            return hexSlice2(this, start, end);
          case "utf8":
          case "utf-8":
            return utf8Slice2(this, start, end);
          case "ascii":
            return asciiSlice2(this, start, end);
          case "latin1":
          case "binary":
            return latin1Slice2(this, start, end);
          case "base64":
            return base64Slice2(this, start, end);
          case "ucs2":
          case "ucs-2":
          case "utf16le":
          case "utf-16le":
            return utf16leSlice2(this, start, end);
          default:
            if (loweredCase) throw new TypeError("Unknown encoding: " + encoding);
            encoding = (encoding + "").toLowerCase();
            loweredCase = true;
        }
      }
    }
    Buffer2.prototype._isBuffer = true;
    function swap2(b2, n2, m) {
      const i2 = b2[n2];
      b2[n2] = b2[m];
      b2[m] = i2;
    }
    Buffer2.prototype.swap16 = function swap16() {
      const len = this.length;
      if (len % 2 !== 0) {
        throw new RangeError("Buffer size must be a multiple of 16-bits");
      }
      for (let i2 = 0; i2 < len; i2 += 2) {
        swap2(this, i2, i2 + 1);
      }
      return this;
    };
    Buffer2.prototype.swap32 = function swap32() {
      const len = this.length;
      if (len % 4 !== 0) {
        throw new RangeError("Buffer size must be a multiple of 32-bits");
      }
      for (let i2 = 0; i2 < len; i2 += 4) {
        swap2(this, i2, i2 + 3);
        swap2(this, i2 + 1, i2 + 2);
      }
      return this;
    };
    Buffer2.prototype.swap64 = function swap64() {
      const len = this.length;
      if (len % 8 !== 0) {
        throw new RangeError("Buffer size must be a multiple of 64-bits");
      }
      for (let i2 = 0; i2 < len; i2 += 8) {
        swap2(this, i2, i2 + 7);
        swap2(this, i2 + 1, i2 + 6);
        swap2(this, i2 + 2, i2 + 5);
        swap2(this, i2 + 3, i2 + 4);
      }
      return this;
    };
    Buffer2.prototype.toString = function toString2() {
      const length = this.length;
      if (length === 0) return "";
      if (arguments.length === 0) return utf8Slice2(this, 0, length);
      return slowToString2.apply(this, arguments);
    };
    Buffer2.prototype.toLocaleString = Buffer2.prototype.toString;
    Buffer2.prototype.equals = function equals(b2) {
      if (!Buffer2.isBuffer(b2)) throw new TypeError("Argument must be a Buffer");
      if (this === b2) return true;
      return Buffer2.compare(this, b2) === 0;
    };
    Buffer2.prototype.inspect = function inspect() {
      let str = "";
      const max2 = exports.INSPECT_MAX_BYTES;
      str = this.toString("hex", 0, max2).replace(/(.{2})/g, "$1 ").trim();
      if (this.length > max2) str += " ... ";
      return "<Buffer " + str + ">";
    };
    if (customInspectSymbol) {
      Buffer2.prototype[customInspectSymbol] = Buffer2.prototype.inspect;
    }
    Buffer2.prototype.compare = function compare(target, start, end, thisStart, thisEnd) {
      if (isInstance(target, Uint8Array)) {
        target = Buffer2.from(target, target.offset, target.byteLength);
      }
      if (!Buffer2.isBuffer(target)) {
        throw new TypeError(
          'The "target" argument must be one of type Buffer or Uint8Array. Received type ' + typeof target
        );
      }
      if (start === void 0) {
        start = 0;
      }
      if (end === void 0) {
        end = target ? target.length : 0;
      }
      if (thisStart === void 0) {
        thisStart = 0;
      }
      if (thisEnd === void 0) {
        thisEnd = this.length;
      }
      if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
        throw new RangeError("out of range index");
      }
      if (thisStart >= thisEnd && start >= end) {
        return 0;
      }
      if (thisStart >= thisEnd) {
        return -1;
      }
      if (start >= end) {
        return 1;
      }
      start >>>= 0;
      end >>>= 0;
      thisStart >>>= 0;
      thisEnd >>>= 0;
      if (this === target) return 0;
      let x2 = thisEnd - thisStart;
      let y2 = end - start;
      const len = Math.min(x2, y2);
      const thisCopy = this.slice(thisStart, thisEnd);
      const targetCopy = target.slice(start, end);
      for (let i2 = 0; i2 < len; ++i2) {
        if (thisCopy[i2] !== targetCopy[i2]) {
          x2 = thisCopy[i2];
          y2 = targetCopy[i2];
          break;
        }
      }
      if (x2 < y2) return -1;
      if (y2 < x2) return 1;
      return 0;
    };
    function bidirectionalIndexOf2(buffer2, val, byteOffset, encoding, dir) {
      if (buffer2.length === 0) return -1;
      if (typeof byteOffset === "string") {
        encoding = byteOffset;
        byteOffset = 0;
      } else if (byteOffset > 2147483647) {
        byteOffset = 2147483647;
      } else if (byteOffset < -2147483648) {
        byteOffset = -2147483648;
      }
      byteOffset = +byteOffset;
      if (numberIsNaN(byteOffset)) {
        byteOffset = dir ? 0 : buffer2.length - 1;
      }
      if (byteOffset < 0) byteOffset = buffer2.length + byteOffset;
      if (byteOffset >= buffer2.length) {
        if (dir) return -1;
        else byteOffset = buffer2.length - 1;
      } else if (byteOffset < 0) {
        if (dir) byteOffset = 0;
        else return -1;
      }
      if (typeof val === "string") {
        val = Buffer2.from(val, encoding);
      }
      if (Buffer2.isBuffer(val)) {
        if (val.length === 0) {
          return -1;
        }
        return arrayIndexOf2(buffer2, val, byteOffset, encoding, dir);
      } else if (typeof val === "number") {
        val = val & 255;
        if (typeof Uint8Array.prototype.indexOf === "function") {
          if (dir) {
            return Uint8Array.prototype.indexOf.call(buffer2, val, byteOffset);
          } else {
            return Uint8Array.prototype.lastIndexOf.call(buffer2, val, byteOffset);
          }
        }
        return arrayIndexOf2(buffer2, [val], byteOffset, encoding, dir);
      }
      throw new TypeError("val must be string, number or Buffer");
    }
    function arrayIndexOf2(arr, val, byteOffset, encoding, dir) {
      let indexSize = 1;
      let arrLength = arr.length;
      let valLength = val.length;
      if (encoding !== void 0) {
        encoding = String(encoding).toLowerCase();
        if (encoding === "ucs2" || encoding === "ucs-2" || encoding === "utf16le" || encoding === "utf-16le") {
          if (arr.length < 2 || val.length < 2) {
            return -1;
          }
          indexSize = 2;
          arrLength /= 2;
          valLength /= 2;
          byteOffset /= 2;
        }
      }
      function read2(buf, i3) {
        if (indexSize === 1) {
          return buf[i3];
        } else {
          return buf.readUInt16BE(i3 * indexSize);
        }
      }
      let i2;
      if (dir) {
        let foundIndex = -1;
        for (i2 = byteOffset; i2 < arrLength; i2++) {
          if (read2(arr, i2) === read2(val, foundIndex === -1 ? 0 : i2 - foundIndex)) {
            if (foundIndex === -1) foundIndex = i2;
            if (i2 - foundIndex + 1 === valLength) return foundIndex * indexSize;
          } else {
            if (foundIndex !== -1) i2 -= i2 - foundIndex;
            foundIndex = -1;
          }
        }
      } else {
        if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
        for (i2 = byteOffset; i2 >= 0; i2--) {
          let found = true;
          for (let j = 0; j < valLength; j++) {
            if (read2(arr, i2 + j) !== read2(val, j)) {
              found = false;
              break;
            }
          }
          if (found) return i2;
        }
      }
      return -1;
    }
    Buffer2.prototype.includes = function includes2(val, byteOffset, encoding) {
      return this.indexOf(val, byteOffset, encoding) !== -1;
    };
    Buffer2.prototype.indexOf = function indexOf(val, byteOffset, encoding) {
      return bidirectionalIndexOf2(this, val, byteOffset, encoding, true);
    };
    Buffer2.prototype.lastIndexOf = function lastIndexOf(val, byteOffset, encoding) {
      return bidirectionalIndexOf2(this, val, byteOffset, encoding, false);
    };
    function hexWrite2(buf, string, offset, length) {
      offset = Number(offset) || 0;
      const remaining = buf.length - offset;
      if (!length) {
        length = remaining;
      } else {
        length = Number(length);
        if (length > remaining) {
          length = remaining;
        }
      }
      const strLen = string.length;
      if (length > strLen / 2) {
        length = strLen / 2;
      }
      let i2;
      for (i2 = 0; i2 < length; ++i2) {
        const parsed = parseInt(string.substr(i2 * 2, 2), 16);
        if (numberIsNaN(parsed)) return i2;
        buf[offset + i2] = parsed;
      }
      return i2;
    }
    function utf8Write2(buf, string, offset, length) {
      return blitBuffer2(utf8ToBytes2(string, buf.length - offset), buf, offset, length);
    }
    function asciiWrite2(buf, string, offset, length) {
      return blitBuffer2(asciiToBytes2(string), buf, offset, length);
    }
    function base64Write2(buf, string, offset, length) {
      return blitBuffer2(base64ToBytes2(string), buf, offset, length);
    }
    function ucs2Write2(buf, string, offset, length) {
      return blitBuffer2(utf16leToBytes2(string, buf.length - offset), buf, offset, length);
    }
    Buffer2.prototype.write = function write2(string, offset, length, encoding) {
      if (offset === void 0) {
        encoding = "utf8";
        length = this.length;
        offset = 0;
      } else if (length === void 0 && typeof offset === "string") {
        encoding = offset;
        length = this.length;
        offset = 0;
      } else if (isFinite(offset)) {
        offset = offset >>> 0;
        if (isFinite(length)) {
          length = length >>> 0;
          if (encoding === void 0) encoding = "utf8";
        } else {
          encoding = length;
          length = void 0;
        }
      } else {
        throw new Error(
          "Buffer.write(string, encoding, offset[, length]) is no longer supported"
        );
      }
      const remaining = this.length - offset;
      if (length === void 0 || length > remaining) length = remaining;
      if (string.length > 0 && (length < 0 || offset < 0) || offset > this.length) {
        throw new RangeError("Attempt to write outside buffer bounds");
      }
      if (!encoding) encoding = "utf8";
      let loweredCase = false;
      for (; ; ) {
        switch (encoding) {
          case "hex":
            return hexWrite2(this, string, offset, length);
          case "utf8":
          case "utf-8":
            return utf8Write2(this, string, offset, length);
          case "ascii":
          case "latin1":
          case "binary":
            return asciiWrite2(this, string, offset, length);
          case "base64":
            return base64Write2(this, string, offset, length);
          case "ucs2":
          case "ucs-2":
          case "utf16le":
          case "utf-16le":
            return ucs2Write2(this, string, offset, length);
          default:
            if (loweredCase) throw new TypeError("Unknown encoding: " + encoding);
            encoding = ("" + encoding).toLowerCase();
            loweredCase = true;
        }
      }
    };
    Buffer2.prototype.toJSON = function toJSON() {
      return {
        type: "Buffer",
        data: Array.prototype.slice.call(this._arr || this, 0)
      };
    };
    function base64Slice2(buf, start, end) {
      if (start === 0 && end === buf.length) {
        return base64.fromByteArray(buf);
      } else {
        return base64.fromByteArray(buf.slice(start, end));
      }
    }
    function utf8Slice2(buf, start, end) {
      end = Math.min(buf.length, end);
      const res = [];
      let i2 = start;
      while (i2 < end) {
        const firstByte = buf[i2];
        let codePoint = null;
        let bytesPerSequence = firstByte > 239 ? 4 : firstByte > 223 ? 3 : firstByte > 191 ? 2 : 1;
        if (i2 + bytesPerSequence <= end) {
          let secondByte, thirdByte, fourthByte, tempCodePoint;
          switch (bytesPerSequence) {
            case 1:
              if (firstByte < 128) {
                codePoint = firstByte;
              }
              break;
            case 2:
              secondByte = buf[i2 + 1];
              if ((secondByte & 192) === 128) {
                tempCodePoint = (firstByte & 31) << 6 | secondByte & 63;
                if (tempCodePoint > 127) {
                  codePoint = tempCodePoint;
                }
              }
              break;
            case 3:
              secondByte = buf[i2 + 1];
              thirdByte = buf[i2 + 2];
              if ((secondByte & 192) === 128 && (thirdByte & 192) === 128) {
                tempCodePoint = (firstByte & 15) << 12 | (secondByte & 63) << 6 | thirdByte & 63;
                if (tempCodePoint > 2047 && (tempCodePoint < 55296 || tempCodePoint > 57343)) {
                  codePoint = tempCodePoint;
                }
              }
              break;
            case 4:
              secondByte = buf[i2 + 1];
              thirdByte = buf[i2 + 2];
              fourthByte = buf[i2 + 3];
              if ((secondByte & 192) === 128 && (thirdByte & 192) === 128 && (fourthByte & 192) === 128) {
                tempCodePoint = (firstByte & 15) << 18 | (secondByte & 63) << 12 | (thirdByte & 63) << 6 | fourthByte & 63;
                if (tempCodePoint > 65535 && tempCodePoint < 1114112) {
                  codePoint = tempCodePoint;
                }
              }
          }
        }
        if (codePoint === null) {
          codePoint = 65533;
          bytesPerSequence = 1;
        } else if (codePoint > 65535) {
          codePoint -= 65536;
          res.push(codePoint >>> 10 & 1023 | 55296);
          codePoint = 56320 | codePoint & 1023;
        }
        res.push(codePoint);
        i2 += bytesPerSequence;
      }
      return decodeCodePointsArray2(res);
    }
    const MAX_ARGUMENTS_LENGTH2 = 4096;
    function decodeCodePointsArray2(codePoints) {
      const len = codePoints.length;
      if (len <= MAX_ARGUMENTS_LENGTH2) {
        return String.fromCharCode.apply(String, codePoints);
      }
      let res = "";
      let i2 = 0;
      while (i2 < len) {
        res += String.fromCharCode.apply(
          String,
          codePoints.slice(i2, i2 += MAX_ARGUMENTS_LENGTH2)
        );
      }
      return res;
    }
    function asciiSlice2(buf, start, end) {
      let ret = "";
      end = Math.min(buf.length, end);
      for (let i2 = start; i2 < end; ++i2) {
        ret += String.fromCharCode(buf[i2] & 127);
      }
      return ret;
    }
    function latin1Slice2(buf, start, end) {
      let ret = "";
      end = Math.min(buf.length, end);
      for (let i2 = start; i2 < end; ++i2) {
        ret += String.fromCharCode(buf[i2]);
      }
      return ret;
    }
    function hexSlice2(buf, start, end) {
      const len = buf.length;
      if (!start || start < 0) start = 0;
      if (!end || end < 0 || end > len) end = len;
      let out = "";
      for (let i2 = start; i2 < end; ++i2) {
        out += hexSliceLookupTable[buf[i2]];
      }
      return out;
    }
    function utf16leSlice2(buf, start, end) {
      const bytes = buf.slice(start, end);
      let res = "";
      for (let i2 = 0; i2 < bytes.length - 1; i2 += 2) {
        res += String.fromCharCode(bytes[i2] + bytes[i2 + 1] * 256);
      }
      return res;
    }
    Buffer2.prototype.slice = function slice(start, end) {
      const len = this.length;
      start = ~~start;
      end = end === void 0 ? len : ~~end;
      if (start < 0) {
        start += len;
        if (start < 0) start = 0;
      } else if (start > len) {
        start = len;
      }
      if (end < 0) {
        end += len;
        if (end < 0) end = 0;
      } else if (end > len) {
        end = len;
      }
      if (end < start) end = start;
      const newBuf = this.subarray(start, end);
      Object.setPrototypeOf(newBuf, Buffer2.prototype);
      return newBuf;
    };
    function checkOffset2(offset, ext, length) {
      if (offset % 1 !== 0 || offset < 0) throw new RangeError("offset is not uint");
      if (offset + ext > length) throw new RangeError("Trying to access beyond buffer length");
    }
    Buffer2.prototype.readUintLE = Buffer2.prototype.readUIntLE = function readUIntLE(offset, byteLength3, noAssert) {
      offset = offset >>> 0;
      byteLength3 = byteLength3 >>> 0;
      if (!noAssert) checkOffset2(offset, byteLength3, this.length);
      let val = this[offset];
      let mul = 1;
      let i2 = 0;
      while (++i2 < byteLength3 && (mul *= 256)) {
        val += this[offset + i2] * mul;
      }
      return val;
    };
    Buffer2.prototype.readUintBE = Buffer2.prototype.readUIntBE = function readUIntBE(offset, byteLength3, noAssert) {
      offset = offset >>> 0;
      byteLength3 = byteLength3 >>> 0;
      if (!noAssert) {
        checkOffset2(offset, byteLength3, this.length);
      }
      let val = this[offset + --byteLength3];
      let mul = 1;
      while (byteLength3 > 0 && (mul *= 256)) {
        val += this[offset + --byteLength3] * mul;
      }
      return val;
    };
    Buffer2.prototype.readUint8 = Buffer2.prototype.readUInt8 = function readUInt8(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset2(offset, 1, this.length);
      return this[offset];
    };
    Buffer2.prototype.readUint16LE = Buffer2.prototype.readUInt16LE = function readUInt16LE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset2(offset, 2, this.length);
      return this[offset] | this[offset + 1] << 8;
    };
    Buffer2.prototype.readUint16BE = Buffer2.prototype.readUInt16BE = function readUInt16BE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset2(offset, 2, this.length);
      return this[offset] << 8 | this[offset + 1];
    };
    Buffer2.prototype.readUint32LE = Buffer2.prototype.readUInt32LE = function readUInt32LE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset2(offset, 4, this.length);
      return (this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16) + this[offset + 3] * 16777216;
    };
    Buffer2.prototype.readUint32BE = Buffer2.prototype.readUInt32BE = function readUInt32BE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset2(offset, 4, this.length);
      return this[offset] * 16777216 + (this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3]);
    };
    Buffer2.prototype.readBigUInt64LE = defineBigIntMethod(function readBigUInt64LE(offset) {
      offset = offset >>> 0;
      validateNumber(offset, "offset");
      const first = this[offset];
      const last = this[offset + 7];
      if (first === void 0 || last === void 0) {
        boundsError(offset, this.length - 8);
      }
      const lo = first + this[++offset] * 2 ** 8 + this[++offset] * 2 ** 16 + this[++offset] * 2 ** 24;
      const hi = this[++offset] + this[++offset] * 2 ** 8 + this[++offset] * 2 ** 16 + last * 2 ** 24;
      return BigInt(lo) + (BigInt(hi) << BigInt(32));
    });
    Buffer2.prototype.readBigUInt64BE = defineBigIntMethod(function readBigUInt64BE(offset) {
      offset = offset >>> 0;
      validateNumber(offset, "offset");
      const first = this[offset];
      const last = this[offset + 7];
      if (first === void 0 || last === void 0) {
        boundsError(offset, this.length - 8);
      }
      const hi = first * 2 ** 24 + this[++offset] * 2 ** 16 + this[++offset] * 2 ** 8 + this[++offset];
      const lo = this[++offset] * 2 ** 24 + this[++offset] * 2 ** 16 + this[++offset] * 2 ** 8 + last;
      return (BigInt(hi) << BigInt(32)) + BigInt(lo);
    });
    Buffer2.prototype.readIntLE = function readIntLE(offset, byteLength3, noAssert) {
      offset = offset >>> 0;
      byteLength3 = byteLength3 >>> 0;
      if (!noAssert) checkOffset2(offset, byteLength3, this.length);
      let val = this[offset];
      let mul = 1;
      let i2 = 0;
      while (++i2 < byteLength3 && (mul *= 256)) {
        val += this[offset + i2] * mul;
      }
      mul *= 128;
      if (val >= mul) val -= Math.pow(2, 8 * byteLength3);
      return val;
    };
    Buffer2.prototype.readIntBE = function readIntBE(offset, byteLength3, noAssert) {
      offset = offset >>> 0;
      byteLength3 = byteLength3 >>> 0;
      if (!noAssert) checkOffset2(offset, byteLength3, this.length);
      let i2 = byteLength3;
      let mul = 1;
      let val = this[offset + --i2];
      while (i2 > 0 && (mul *= 256)) {
        val += this[offset + --i2] * mul;
      }
      mul *= 128;
      if (val >= mul) val -= Math.pow(2, 8 * byteLength3);
      return val;
    };
    Buffer2.prototype.readInt8 = function readInt8(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset2(offset, 1, this.length);
      if (!(this[offset] & 128)) return this[offset];
      return (255 - this[offset] + 1) * -1;
    };
    Buffer2.prototype.readInt16LE = function readInt16LE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset2(offset, 2, this.length);
      const val = this[offset] | this[offset + 1] << 8;
      return val & 32768 ? val | 4294901760 : val;
    };
    Buffer2.prototype.readInt16BE = function readInt16BE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset2(offset, 2, this.length);
      const val = this[offset + 1] | this[offset] << 8;
      return val & 32768 ? val | 4294901760 : val;
    };
    Buffer2.prototype.readInt32LE = function readInt32LE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset2(offset, 4, this.length);
      return this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16 | this[offset + 3] << 24;
    };
    Buffer2.prototype.readInt32BE = function readInt32BE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset2(offset, 4, this.length);
      return this[offset] << 24 | this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3];
    };
    Buffer2.prototype.readBigInt64LE = defineBigIntMethod(function readBigInt64LE(offset) {
      offset = offset >>> 0;
      validateNumber(offset, "offset");
      const first = this[offset];
      const last = this[offset + 7];
      if (first === void 0 || last === void 0) {
        boundsError(offset, this.length - 8);
      }
      const val = this[offset + 4] + this[offset + 5] * 2 ** 8 + this[offset + 6] * 2 ** 16 + (last << 24);
      return (BigInt(val) << BigInt(32)) + BigInt(first + this[++offset] * 2 ** 8 + this[++offset] * 2 ** 16 + this[++offset] * 2 ** 24);
    });
    Buffer2.prototype.readBigInt64BE = defineBigIntMethod(function readBigInt64BE(offset) {
      offset = offset >>> 0;
      validateNumber(offset, "offset");
      const first = this[offset];
      const last = this[offset + 7];
      if (first === void 0 || last === void 0) {
        boundsError(offset, this.length - 8);
      }
      const val = (first << 24) + // Overflow
      this[++offset] * 2 ** 16 + this[++offset] * 2 ** 8 + this[++offset];
      return (BigInt(val) << BigInt(32)) + BigInt(this[++offset] * 2 ** 24 + this[++offset] * 2 ** 16 + this[++offset] * 2 ** 8 + last);
    });
    Buffer2.prototype.readFloatLE = function readFloatLE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset2(offset, 4, this.length);
      return ieee7542.read(this, offset, true, 23, 4);
    };
    Buffer2.prototype.readFloatBE = function readFloatBE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset2(offset, 4, this.length);
      return ieee7542.read(this, offset, false, 23, 4);
    };
    Buffer2.prototype.readDoubleLE = function readDoubleLE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset2(offset, 8, this.length);
      return ieee7542.read(this, offset, true, 52, 8);
    };
    Buffer2.prototype.readDoubleBE = function readDoubleBE(offset, noAssert) {
      offset = offset >>> 0;
      if (!noAssert) checkOffset2(offset, 8, this.length);
      return ieee7542.read(this, offset, false, 52, 8);
    };
    function checkInt2(buf, value, offset, ext, max2, min2) {
      if (!Buffer2.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance');
      if (value > max2 || value < min2) throw new RangeError('"value" argument is out of bounds');
      if (offset + ext > buf.length) throw new RangeError("Index out of range");
    }
    Buffer2.prototype.writeUintLE = Buffer2.prototype.writeUIntLE = function writeUIntLE(value, offset, byteLength3, noAssert) {
      value = +value;
      offset = offset >>> 0;
      byteLength3 = byteLength3 >>> 0;
      if (!noAssert) {
        const maxBytes = Math.pow(2, 8 * byteLength3) - 1;
        checkInt2(this, value, offset, byteLength3, maxBytes, 0);
      }
      let mul = 1;
      let i2 = 0;
      this[offset] = value & 255;
      while (++i2 < byteLength3 && (mul *= 256)) {
        this[offset + i2] = value / mul & 255;
      }
      return offset + byteLength3;
    };
    Buffer2.prototype.writeUintBE = Buffer2.prototype.writeUIntBE = function writeUIntBE(value, offset, byteLength3, noAssert) {
      value = +value;
      offset = offset >>> 0;
      byteLength3 = byteLength3 >>> 0;
      if (!noAssert) {
        const maxBytes = Math.pow(2, 8 * byteLength3) - 1;
        checkInt2(this, value, offset, byteLength3, maxBytes, 0);
      }
      let i2 = byteLength3 - 1;
      let mul = 1;
      this[offset + i2] = value & 255;
      while (--i2 >= 0 && (mul *= 256)) {
        this[offset + i2] = value / mul & 255;
      }
      return offset + byteLength3;
    };
    Buffer2.prototype.writeUint8 = Buffer2.prototype.writeUInt8 = function writeUInt8(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt2(this, value, offset, 1, 255, 0);
      this[offset] = value & 255;
      return offset + 1;
    };
    Buffer2.prototype.writeUint16LE = Buffer2.prototype.writeUInt16LE = function writeUInt16LE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt2(this, value, offset, 2, 65535, 0);
      this[offset] = value & 255;
      this[offset + 1] = value >>> 8;
      return offset + 2;
    };
    Buffer2.prototype.writeUint16BE = Buffer2.prototype.writeUInt16BE = function writeUInt16BE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt2(this, value, offset, 2, 65535, 0);
      this[offset] = value >>> 8;
      this[offset + 1] = value & 255;
      return offset + 2;
    };
    Buffer2.prototype.writeUint32LE = Buffer2.prototype.writeUInt32LE = function writeUInt32LE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt2(this, value, offset, 4, 4294967295, 0);
      this[offset + 3] = value >>> 24;
      this[offset + 2] = value >>> 16;
      this[offset + 1] = value >>> 8;
      this[offset] = value & 255;
      return offset + 4;
    };
    Buffer2.prototype.writeUint32BE = Buffer2.prototype.writeUInt32BE = function writeUInt32BE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt2(this, value, offset, 4, 4294967295, 0);
      this[offset] = value >>> 24;
      this[offset + 1] = value >>> 16;
      this[offset + 2] = value >>> 8;
      this[offset + 3] = value & 255;
      return offset + 4;
    };
    function wrtBigUInt64LE(buf, value, offset, min2, max2) {
      checkIntBI(value, min2, max2, buf, offset, 7);
      let lo = Number(value & BigInt(4294967295));
      buf[offset++] = lo;
      lo = lo >> 8;
      buf[offset++] = lo;
      lo = lo >> 8;
      buf[offset++] = lo;
      lo = lo >> 8;
      buf[offset++] = lo;
      let hi = Number(value >> BigInt(32) & BigInt(4294967295));
      buf[offset++] = hi;
      hi = hi >> 8;
      buf[offset++] = hi;
      hi = hi >> 8;
      buf[offset++] = hi;
      hi = hi >> 8;
      buf[offset++] = hi;
      return offset;
    }
    function wrtBigUInt64BE(buf, value, offset, min2, max2) {
      checkIntBI(value, min2, max2, buf, offset, 7);
      let lo = Number(value & BigInt(4294967295));
      buf[offset + 7] = lo;
      lo = lo >> 8;
      buf[offset + 6] = lo;
      lo = lo >> 8;
      buf[offset + 5] = lo;
      lo = lo >> 8;
      buf[offset + 4] = lo;
      let hi = Number(value >> BigInt(32) & BigInt(4294967295));
      buf[offset + 3] = hi;
      hi = hi >> 8;
      buf[offset + 2] = hi;
      hi = hi >> 8;
      buf[offset + 1] = hi;
      hi = hi >> 8;
      buf[offset] = hi;
      return offset + 8;
    }
    Buffer2.prototype.writeBigUInt64LE = defineBigIntMethod(function writeBigUInt64LE(value, offset = 0) {
      return wrtBigUInt64LE(this, value, offset, BigInt(0), BigInt("0xffffffffffffffff"));
    });
    Buffer2.prototype.writeBigUInt64BE = defineBigIntMethod(function writeBigUInt64BE(value, offset = 0) {
      return wrtBigUInt64BE(this, value, offset, BigInt(0), BigInt("0xffffffffffffffff"));
    });
    Buffer2.prototype.writeIntLE = function writeIntLE(value, offset, byteLength3, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) {
        const limit = Math.pow(2, 8 * byteLength3 - 1);
        checkInt2(this, value, offset, byteLength3, limit - 1, -limit);
      }
      let i2 = 0;
      let mul = 1;
      let sub = 0;
      this[offset] = value & 255;
      while (++i2 < byteLength3 && (mul *= 256)) {
        if (value < 0 && sub === 0 && this[offset + i2 - 1] !== 0) {
          sub = 1;
        }
        this[offset + i2] = (value / mul >> 0) - sub & 255;
      }
      return offset + byteLength3;
    };
    Buffer2.prototype.writeIntBE = function writeIntBE(value, offset, byteLength3, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) {
        const limit = Math.pow(2, 8 * byteLength3 - 1);
        checkInt2(this, value, offset, byteLength3, limit - 1, -limit);
      }
      let i2 = byteLength3 - 1;
      let mul = 1;
      let sub = 0;
      this[offset + i2] = value & 255;
      while (--i2 >= 0 && (mul *= 256)) {
        if (value < 0 && sub === 0 && this[offset + i2 + 1] !== 0) {
          sub = 1;
        }
        this[offset + i2] = (value / mul >> 0) - sub & 255;
      }
      return offset + byteLength3;
    };
    Buffer2.prototype.writeInt8 = function writeInt8(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt2(this, value, offset, 1, 127, -128);
      if (value < 0) value = 255 + value + 1;
      this[offset] = value & 255;
      return offset + 1;
    };
    Buffer2.prototype.writeInt16LE = function writeInt16LE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt2(this, value, offset, 2, 32767, -32768);
      this[offset] = value & 255;
      this[offset + 1] = value >>> 8;
      return offset + 2;
    };
    Buffer2.prototype.writeInt16BE = function writeInt16BE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt2(this, value, offset, 2, 32767, -32768);
      this[offset] = value >>> 8;
      this[offset + 1] = value & 255;
      return offset + 2;
    };
    Buffer2.prototype.writeInt32LE = function writeInt32LE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt2(this, value, offset, 4, 2147483647, -2147483648);
      this[offset] = value & 255;
      this[offset + 1] = value >>> 8;
      this[offset + 2] = value >>> 16;
      this[offset + 3] = value >>> 24;
      return offset + 4;
    };
    Buffer2.prototype.writeInt32BE = function writeInt32BE(value, offset, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) checkInt2(this, value, offset, 4, 2147483647, -2147483648);
      if (value < 0) value = 4294967295 + value + 1;
      this[offset] = value >>> 24;
      this[offset + 1] = value >>> 16;
      this[offset + 2] = value >>> 8;
      this[offset + 3] = value & 255;
      return offset + 4;
    };
    Buffer2.prototype.writeBigInt64LE = defineBigIntMethod(function writeBigInt64LE(value, offset = 0) {
      return wrtBigUInt64LE(this, value, offset, -BigInt("0x8000000000000000"), BigInt("0x7fffffffffffffff"));
    });
    Buffer2.prototype.writeBigInt64BE = defineBigIntMethod(function writeBigInt64BE(value, offset = 0) {
      return wrtBigUInt64BE(this, value, offset, -BigInt("0x8000000000000000"), BigInt("0x7fffffffffffffff"));
    });
    function checkIEEE7542(buf, value, offset, ext, max2, min2) {
      if (offset + ext > buf.length) throw new RangeError("Index out of range");
      if (offset < 0) throw new RangeError("Index out of range");
    }
    function writeFloat2(buf, value, offset, littleEndian, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) {
        checkIEEE7542(buf, value, offset, 4);
      }
      ieee7542.write(buf, value, offset, littleEndian, 23, 4);
      return offset + 4;
    }
    Buffer2.prototype.writeFloatLE = function writeFloatLE(value, offset, noAssert) {
      return writeFloat2(this, value, offset, true, noAssert);
    };
    Buffer2.prototype.writeFloatBE = function writeFloatBE(value, offset, noAssert) {
      return writeFloat2(this, value, offset, false, noAssert);
    };
    function writeDouble2(buf, value, offset, littleEndian, noAssert) {
      value = +value;
      offset = offset >>> 0;
      if (!noAssert) {
        checkIEEE7542(buf, value, offset, 8);
      }
      ieee7542.write(buf, value, offset, littleEndian, 52, 8);
      return offset + 8;
    }
    Buffer2.prototype.writeDoubleLE = function writeDoubleLE(value, offset, noAssert) {
      return writeDouble2(this, value, offset, true, noAssert);
    };
    Buffer2.prototype.writeDoubleBE = function writeDoubleBE(value, offset, noAssert) {
      return writeDouble2(this, value, offset, false, noAssert);
    };
    Buffer2.prototype.copy = function copy2(target, targetStart, start, end) {
      if (!Buffer2.isBuffer(target)) throw new TypeError("argument should be a Buffer");
      if (!start) start = 0;
      if (!end && end !== 0) end = this.length;
      if (targetStart >= target.length) targetStart = target.length;
      if (!targetStart) targetStart = 0;
      if (end > 0 && end < start) end = start;
      if (end === start) return 0;
      if (target.length === 0 || this.length === 0) return 0;
      if (targetStart < 0) {
        throw new RangeError("targetStart out of bounds");
      }
      if (start < 0 || start >= this.length) throw new RangeError("Index out of range");
      if (end < 0) throw new RangeError("sourceEnd out of bounds");
      if (end > this.length) end = this.length;
      if (target.length - targetStart < end - start) {
        end = target.length - targetStart + start;
      }
      const len = end - start;
      if (this === target && typeof Uint8Array.prototype.copyWithin === "function") {
        this.copyWithin(targetStart, start, end);
      } else {
        Uint8Array.prototype.set.call(
          target,
          this.subarray(start, end),
          targetStart
        );
      }
      return len;
    };
    Buffer2.prototype.fill = function fill(val, start, end, encoding) {
      if (typeof val === "string") {
        if (typeof start === "string") {
          encoding = start;
          start = 0;
          end = this.length;
        } else if (typeof end === "string") {
          encoding = end;
          end = this.length;
        }
        if (encoding !== void 0 && typeof encoding !== "string") {
          throw new TypeError("encoding must be a string");
        }
        if (typeof encoding === "string" && !Buffer2.isEncoding(encoding)) {
          throw new TypeError("Unknown encoding: " + encoding);
        }
        if (val.length === 1) {
          const code = val.charCodeAt(0);
          if (encoding === "utf8" && code < 128 || encoding === "latin1") {
            val = code;
          }
        }
      } else if (typeof val === "number") {
        val = val & 255;
      } else if (typeof val === "boolean") {
        val = Number(val);
      }
      if (start < 0 || this.length < start || this.length < end) {
        throw new RangeError("Out of range index");
      }
      if (end <= start) {
        return this;
      }
      start = start >>> 0;
      end = end === void 0 ? this.length : end >>> 0;
      if (!val) val = 0;
      let i2;
      if (typeof val === "number") {
        for (i2 = start; i2 < end; ++i2) {
          this[i2] = val;
        }
      } else {
        const bytes = Buffer2.isBuffer(val) ? val : Buffer2.from(val, encoding);
        const len = bytes.length;
        if (len === 0) {
          throw new TypeError('The value "' + val + '" is invalid for argument "value"');
        }
        for (i2 = 0; i2 < end - start; ++i2) {
          this[i2 + start] = bytes[i2 % len];
        }
      }
      return this;
    };
    const errors = {};
    function E2(sym, getMessage, Base) {
      errors[sym] = class NodeError extends Base {
        constructor() {
          super();
          Object.defineProperty(this, "message", {
            value: getMessage.apply(this, arguments),
            writable: true,
            configurable: true
          });
          this.name = `${this.name} [${sym}]`;
          this.stack;
          delete this.name;
        }
        get code() {
          return sym;
        }
        set code(value) {
          Object.defineProperty(this, "code", {
            configurable: true,
            enumerable: true,
            value,
            writable: true
          });
        }
        toString() {
          return `${this.name} [${sym}]: ${this.message}`;
        }
      };
    }
    E2(
      "ERR_BUFFER_OUT_OF_BOUNDS",
      function(name) {
        if (name) {
          return `${name} is outside of buffer bounds`;
        }
        return "Attempt to access memory outside buffer bounds";
      },
      RangeError
    );
    E2(
      "ERR_INVALID_ARG_TYPE",
      function(name, actual) {
        return `The "${name}" argument must be of type number. Received type ${typeof actual}`;
      },
      TypeError
    );
    E2(
      "ERR_OUT_OF_RANGE",
      function(str, range2, input) {
        let msg = `The value of "${str}" is out of range.`;
        let received = input;
        if (Number.isInteger(input) && Math.abs(input) > 2 ** 32) {
          received = addNumericalSeparator(String(input));
        } else if (typeof input === "bigint") {
          received = String(input);
          if (input > BigInt(2) ** BigInt(32) || input < -(BigInt(2) ** BigInt(32))) {
            received = addNumericalSeparator(received);
          }
          received += "n";
        }
        msg += ` It must be ${range2}. Received ${received}`;
        return msg;
      },
      RangeError
    );
    function addNumericalSeparator(val) {
      let res = "";
      let i2 = val.length;
      const start = val[0] === "-" ? 1 : 0;
      for (; i2 >= start + 4; i2 -= 3) {
        res = `_${val.slice(i2 - 3, i2)}${res}`;
      }
      return `${val.slice(0, i2)}${res}`;
    }
    function checkBounds(buf, offset, byteLength3) {
      validateNumber(offset, "offset");
      if (buf[offset] === void 0 || buf[offset + byteLength3] === void 0) {
        boundsError(offset, buf.length - (byteLength3 + 1));
      }
    }
    function checkIntBI(value, min2, max2, buf, offset, byteLength3) {
      if (value > max2 || value < min2) {
        const n2 = typeof min2 === "bigint" ? "n" : "";
        let range2;
        {
          if (min2 === 0 || min2 === BigInt(0)) {
            range2 = `>= 0${n2} and < 2${n2} ** ${(byteLength3 + 1) * 8}${n2}`;
          } else {
            range2 = `>= -(2${n2} ** ${(byteLength3 + 1) * 8 - 1}${n2}) and < 2 ** ${(byteLength3 + 1) * 8 - 1}${n2}`;
          }
        }
        throw new errors.ERR_OUT_OF_RANGE("value", range2, value);
      }
      checkBounds(buf, offset, byteLength3);
    }
    function validateNumber(value, name) {
      if (typeof value !== "number") {
        throw new errors.ERR_INVALID_ARG_TYPE(name, "number", value);
      }
    }
    function boundsError(value, length, type2) {
      if (Math.floor(value) !== value) {
        validateNumber(value, type2);
        throw new errors.ERR_OUT_OF_RANGE("offset", "an integer", value);
      }
      if (length < 0) {
        throw new errors.ERR_BUFFER_OUT_OF_BOUNDS();
      }
      throw new errors.ERR_OUT_OF_RANGE(
        "offset",
        `>= ${0} and <= ${length}`,
        value
      );
    }
    const INVALID_BASE64_RE2 = /[^+/0-9A-Za-z-_]/g;
    function base64clean2(str) {
      str = str.split("=")[0];
      str = str.trim().replace(INVALID_BASE64_RE2, "");
      if (str.length < 2) return "";
      while (str.length % 4 !== 0) {
        str = str + "=";
      }
      return str;
    }
    function utf8ToBytes2(string, units) {
      units = units || Infinity;
      let codePoint;
      const length = string.length;
      let leadSurrogate = null;
      const bytes = [];
      for (let i2 = 0; i2 < length; ++i2) {
        codePoint = string.charCodeAt(i2);
        if (codePoint > 55295 && codePoint < 57344) {
          if (!leadSurrogate) {
            if (codePoint > 56319) {
              if ((units -= 3) > -1) bytes.push(239, 191, 189);
              continue;
            } else if (i2 + 1 === length) {
              if ((units -= 3) > -1) bytes.push(239, 191, 189);
              continue;
            }
            leadSurrogate = codePoint;
            continue;
          }
          if (codePoint < 56320) {
            if ((units -= 3) > -1) bytes.push(239, 191, 189);
            leadSurrogate = codePoint;
            continue;
          }
          codePoint = (leadSurrogate - 55296 << 10 | codePoint - 56320) + 65536;
        } else if (leadSurrogate) {
          if ((units -= 3) > -1) bytes.push(239, 191, 189);
        }
        leadSurrogate = null;
        if (codePoint < 128) {
          if ((units -= 1) < 0) break;
          bytes.push(codePoint);
        } else if (codePoint < 2048) {
          if ((units -= 2) < 0) break;
          bytes.push(
            codePoint >> 6 | 192,
            codePoint & 63 | 128
          );
        } else if (codePoint < 65536) {
          if ((units -= 3) < 0) break;
          bytes.push(
            codePoint >> 12 | 224,
            codePoint >> 6 & 63 | 128,
            codePoint & 63 | 128
          );
        } else if (codePoint < 1114112) {
          if ((units -= 4) < 0) break;
          bytes.push(
            codePoint >> 18 | 240,
            codePoint >> 12 & 63 | 128,
            codePoint >> 6 & 63 | 128,
            codePoint & 63 | 128
          );
        } else {
          throw new Error("Invalid code point");
        }
      }
      return bytes;
    }
    function asciiToBytes2(str) {
      const byteArray = [];
      for (let i2 = 0; i2 < str.length; ++i2) {
        byteArray.push(str.charCodeAt(i2) & 255);
      }
      return byteArray;
    }
    function utf16leToBytes2(str, units) {
      let c2, hi, lo;
      const byteArray = [];
      for (let i2 = 0; i2 < str.length; ++i2) {
        if ((units -= 2) < 0) break;
        c2 = str.charCodeAt(i2);
        hi = c2 >> 8;
        lo = c2 % 256;
        byteArray.push(lo);
        byteArray.push(hi);
      }
      return byteArray;
    }
    function base64ToBytes2(str) {
      return base64.toByteArray(base64clean2(str));
    }
    function blitBuffer2(src2, dst, offset, length) {
      let i2;
      for (i2 = 0; i2 < length; ++i2) {
        if (i2 + offset >= dst.length || i2 >= src2.length) break;
        dst[i2 + offset] = src2[i2];
      }
      return i2;
    }
    function isInstance(obj, type2) {
      return obj instanceof type2 || obj != null && obj.constructor != null && obj.constructor.name != null && obj.constructor.name === type2.name;
    }
    function numberIsNaN(obj) {
      return obj !== obj;
    }
    const hexSliceLookupTable = function() {
      const alphabet2 = "0123456789abcdef";
      const table = new Array(256);
      for (let i2 = 0; i2 < 16; ++i2) {
        const i16 = i2 * 16;
        for (let j = 0; j < 16; ++j) {
          table[i16 + j] = alphabet2[i2] + alphabet2[j];
        }
      }
      return table;
    }();
    function defineBigIntMethod(fn) {
      return typeof BigInt === "undefined" ? BufferBigIntNotDefined : fn;
    }
    function BufferBigIntNotDefined() {
      throw new Error("BigInt not supported");
    }
  })(buffer$1);
  return buffer$1;
}
var bufferExports = requireBuffer$1();
globalThis.Buffer = bufferExports.Buffer;
var ResourceType;
(function(ResourceType2) {
  ResourceType2["Data"] = "DATA";
  ResourceType2["Api"] = "API";
  ResourceType2["Menu"] = "MENU";
  ResourceType2["Ui"] = "UI";
  ResourceType2["Button"] = "BUTTON";
})(ResourceType || (ResourceType = {}));
var PolicyAssignmentTargetType;
(function(PolicyAssignmentTargetType2) {
  PolicyAssignmentTargetType2["User"] = "USER";
  PolicyAssignmentTargetType2["Role"] = "ROLE";
  PolicyAssignmentTargetType2["Group"] = "GROUP";
  PolicyAssignmentTargetType2["Org"] = "ORG";
  PolicyAssignmentTargetType2["AkSk"] = "AK_SK";
})(PolicyAssignmentTargetType || (PolicyAssignmentTargetType = {}));
var Operator;
(function(Operator2) {
  Operator2["And"] = "AND";
  Operator2["Or"] = "OR";
})(Operator || (Operator = {}));
var EmailTemplateType;
(function(EmailTemplateType2) {
  EmailTemplateType2["ResetPassword"] = "RESET_PASSWORD";
  EmailTemplateType2["PasswordResetedNotification"] = "PASSWORD_RESETED_NOTIFICATION";
  EmailTemplateType2["ChangePassword"] = "CHANGE_PASSWORD";
  EmailTemplateType2["Welcome"] = "WELCOME";
  EmailTemplateType2["VerifyEmail"] = "VERIFY_EMAIL";
  EmailTemplateType2["ChangeEmail"] = "CHANGE_EMAIL";
})(EmailTemplateType || (EmailTemplateType = {}));
var SortByEnum;
(function(SortByEnum2) {
  SortByEnum2["CreatedatDesc"] = "CREATEDAT_DESC";
  SortByEnum2["CreatedatAsc"] = "CREATEDAT_ASC";
  SortByEnum2["UpdatedatDesc"] = "UPDATEDAT_DESC";
  SortByEnum2["UpdatedatAsc"] = "UPDATEDAT_ASC";
})(SortByEnum || (SortByEnum = {}));
var UserStatus;
(function(UserStatus2) {
  UserStatus2["Suspended"] = "Suspended";
  UserStatus2["Resigned"] = "Resigned";
  UserStatus2["Activated"] = "Activated";
  UserStatus2["Archived"] = "Archived";
})(UserStatus || (UserStatus = {}));
var UdfDataType;
(function(UdfDataType2) {
  UdfDataType2["String"] = "STRING";
  UdfDataType2["Number"] = "NUMBER";
  UdfDataType2["Datetime"] = "DATETIME";
  UdfDataType2["Boolean"] = "BOOLEAN";
  UdfDataType2["Object"] = "OBJECT";
  UdfDataType2["Select"] = "SELECT";
})(UdfDataType || (UdfDataType = {}));
var PolicyEffect;
(function(PolicyEffect2) {
  PolicyEffect2["Allow"] = "ALLOW";
  PolicyEffect2["Deny"] = "DENY";
})(PolicyEffect || (PolicyEffect = {}));
var UdfTargetType;
(function(UdfTargetType2) {
  UdfTargetType2["Node"] = "NODE";
  UdfTargetType2["Org"] = "ORG";
  UdfTargetType2["User"] = "USER";
  UdfTargetType2["Userpool"] = "USERPOOL";
  UdfTargetType2["Role"] = "ROLE";
  UdfTargetType2["Permission"] = "PERMISSION";
  UdfTargetType2["Application"] = "APPLICATION";
})(UdfTargetType || (UdfTargetType = {}));
var WhitelistType;
(function(WhitelistType2) {
  WhitelistType2["Username"] = "USERNAME";
  WhitelistType2["Email"] = "EMAIL";
  WhitelistType2["Phone"] = "PHONE";
})(WhitelistType || (WhitelistType = {}));
var EmailScene;
(function(EmailScene2) {
  EmailScene2["ResetPassword"] = "RESET_PASSWORD";
  EmailScene2["RESET_PASSWORD_VERIFY_CODE"] = "RESET_PASSWORD_VERIFY_CODE";
  EmailScene2["VerifyEmail"] = "VERIFY_EMAIL";
  EmailScene2["FIRST_EMAIL_LOGIN_VERIFY"] = "FIRST_EMAIL_LOGIN_VERIFY";
  EmailScene2["CONSOLE_CONDUCTED_VERIFY"] = "CONSOLE_CONDUCTED_VERIFY";
  EmailScene2["ChangeEmail"] = "CHANGE_EMAIL";
  EmailScene2["EMAIL_BIND_VERIFY_CODE"] = "EMAIL_BIND_VERIFY_CODE";
  EmailScene2["EMAIL_UNBIND_VERIFY_CODE"] = "EMAIL_UNBIND_VERIFY_CODE";
  EmailScene2["MfaVerify"] = "MFA_VERIFY";
  EmailScene2["VerifyCode"] = "VERIFY_CODE";
  EmailScene2["REGISTER_VERIFY_CODE"] = "REGISTER_VERIFY_CODE";
  EmailScene2["LOGIN_VERIFY_CODE"] = "LOGIN_VERIFY_CODE";
  EmailScene2["MFA_VERIFY_CODE"] = "MFA_VERIFY_CODE";
  EmailScene2["INFORMATION_COMPLETION_VERIFY_CODE"] = "INFORMATION_COMPLETION_VERIFY_CODE";
})(EmailScene || (EmailScene = {}));
var BindEmailDocument = "\n    mutation bindEmail($email: String!, $emailCode: String!) {\n  bindEmail(email: $email, emailCode: $emailCode) {\n    id\n    arn\n    userPoolId\n    status\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    phoneCountryCode\n  }\n}\n    ";
var BindPhoneDocument = "\n    mutation bindPhone($phone: String!, $phoneCode: String!, $phoneCountryCode: String) {\n  bindPhone(phone: $phone, phoneCode: $phoneCode, phoneCountryCode: $phoneCountryCode) {\n    id\n    arn\n    userPoolId\n    status\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    phoneCountryCode\n  }\n}\n    ";
var LoginByEmailDocument = "\n    mutation loginByEmail($input: LoginByEmailInput!) {\n  loginByEmail(input: $input) {\n    id\n    arn\n    status\n    userPoolId\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    externalId\n    phoneCountryCode\n    newlyCreated\n    phoneCountryCode\n    customData {\n      key\n      value\n      dataType\n      label\n    }\n  }\n}\n    ";
var LoginByPhoneCodeDocument = "\n    mutation loginByPhoneCode($input: LoginByPhoneCodeInput!) {\n  loginByPhoneCode(input: $input) {\n    id\n    arn\n    userPoolId\n    status\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    externalId\n    phoneCountryCode\n    newlyCreated\n    phoneCountryCode\n    customData {\n      key\n      value\n      dataType\n      label\n    }\n  }\n}\n    ";
var LoginByPhonePasswordDocument = "\n    mutation loginByPhonePassword($input: LoginByPhonePasswordInput!) {\n  loginByPhonePassword(input: $input) {\n    id\n    arn\n    userPoolId\n    status\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    externalId\n    phoneCountryCode\n    newlyCreated\n    phoneCountryCode\n    customData {\n      key\n      value\n      dataType\n      label\n    }\n  }\n}\n    ";
var LoginBySubAccountDocument = "\n    mutation loginBySubAccount($account: String!, $password: String!, $captchaCode: String, $clientIp: String) {\n  loginBySubAccount(account: $account, password: $password, captchaCode: $captchaCode, clientIp: $clientIp) {\n    id\n    arn\n    status\n    userPoolId\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    externalId\n    phoneCountryCode\n    newlyCreated\n    phoneCountryCode\n    customData {\n      key\n      value\n      dataType\n      label\n    }\n  }\n}\n    ";
var LoginByUsernameDocument = "\n    mutation loginByUsername($input: LoginByUsernameInput!) {\n  loginByUsername(input: $input) {\n    id\n    arn\n    userPoolId\n    status\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    externalId\n    phoneCountryCode\n    newlyCreated\n    phoneCountryCode\n    customData {\n      key\n      value\n      dataType\n      label\n    }\n  }\n}\n    ";
var RefreshTokenDocument = "\n    mutation refreshToken($id: String) {\n  refreshToken(id: $id) {\n    token\n    iat\n    exp\n  }\n}\n    ";
var RegisterByEmailDocument = "\n    mutation registerByEmail($input: RegisterByEmailInput!) {\n  registerByEmail(input: $input) {\n    id\n    arn\n    userPoolId\n    status\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    externalId\n    phoneCountryCode\n  }\n}\n    ";
var RegisterByPhoneCodeDocument = "\n    mutation registerByPhoneCode($input: RegisterByPhoneCodeInput!) {\n  registerByPhoneCode(input: $input) {\n    id\n    arn\n    userPoolId\n    status\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    externalId\n    phoneCountryCode\n  }\n}\n    ";
var RegisterByUsernameDocument = "\n    mutation registerByUsername($input: RegisterByUsernameInput!) {\n  registerByUsername(input: $input) {\n    id\n    arn\n    userPoolId\n    status\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    externalId\n    phoneCountryCode\n  }\n}\n    ";
var RemoveUdvDocument = "\n    mutation removeUdv($targetType: UDFTargetType!, $targetId: String!, $key: String!) {\n  removeUdv(targetType: $targetType, targetId: $targetId, key: $key) {\n    key\n    dataType\n    value\n    label\n  }\n}\n    ";
var ResetPasswordDocument = "\n    mutation resetPassword($phone: String, $phoneCountryCode: String, $email: String, $code: String!, $newPassword: String!) {\n  resetPassword(phone: $phone, phoneCountryCode: $phoneCountryCode, email: $email, code: $code, newPassword: $newPassword) {\n    message\n    code\n  }\n}\n    ";
var ResetPasswordByFirstLoginTokenDocument = "\n    mutation resetPasswordByFirstLoginToken($token: String!, $password: String!) {\n  resetPasswordByFirstLoginToken(token: $token, password: $password) {\n    message\n    code\n  }\n}\n    ";
var ResetPasswordByForceResetTokenDocument = "\n    mutation resetPasswordByForceResetToken($token: String!, $oldPassword: String!, $newPassword: String!) {\n  resetPasswordByForceResetToken(token: $token, oldPassword: $oldPassword, newPassword: $newPassword) {\n    message\n    code\n  }\n}\n    ";
var SendEmailDocument = "\n    mutation sendEmail($email: String!, $scene: EmailScene!) {\n  sendEmail(email: $email, scene: $scene) {\n    message\n    code\n  }\n}\n    ";
var SetUdvDocument = "\n    mutation setUdv($targetType: UDFTargetType!, $targetId: String!, $key: String!, $value: String!) {\n  setUdv(targetType: $targetType, targetId: $targetId, key: $key, value: $value) {\n    key\n    dataType\n    value\n    label\n  }\n}\n    ";
var SetUdvBatchDocument = "\n    mutation setUdvBatch($targetType: UDFTargetType!, $targetId: String!, $udvList: [UserDefinedDataInput!]) {\n  setUdvBatch(targetType: $targetType, targetId: $targetId, udvList: $udvList) {\n    key\n    dataType\n    value\n    label\n  }\n}\n    ";
var UnbindEmailDocument = "\n    mutation unbindEmail {\n  unbindEmail {\n    id\n    arn\n    userPoolId\n    status\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    phoneCountryCode\n  }\n}\n    ";
var UnbindPhoneDocument = "\n    mutation unbindPhone {\n  unbindPhone {\n    id\n    arn\n    userPoolId\n    status\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    phoneCountryCode\n  }\n}\n    ";
var UpdateEmailDocument = "\n    mutation updateEmail($email: String!, $emailCode: String!, $oldEmail: String, $oldEmailCode: String) {\n  updateEmail(email: $email, emailCode: $emailCode, oldEmail: $oldEmail, oldEmailCode: $oldEmailCode) {\n    id\n    arn\n    userPoolId\n    status\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    phoneCountryCode\n  }\n}\n    ";
var UpdatePasswordDocument = "\n    mutation updatePassword($newPassword: String!, $oldPassword: String) {\n  updatePassword(newPassword: $newPassword, oldPassword: $oldPassword) {\n    id\n    arn\n    userPoolId\n    status\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    phoneCountryCode\n  }\n}\n    ";
var UpdatePhoneDocument = "\n    mutation updatePhone($phone: String!, $phoneCode: String!, $oldPhone: String, $oldPhoneCode: String, $phoneCountryCode: String, $oldPhoneCountryCode: String) {\n  updatePhone(phone: $phone, phoneCode: $phoneCode, oldPhone: $oldPhone, oldPhoneCode: $oldPhoneCode, phoneCountryCode: $phoneCountryCode, oldPhoneCountryCode: $oldPhoneCountryCode) {\n    id\n    arn\n    userPoolId\n    status\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    phoneCountryCode\n  }\n}\n    ";
var UpdateUserDocument = "\n    mutation updateUser($id: String, $input: UpdateUserInput!, $emailToken: String, $phoneToken: String) {\n  updateUser(id: $id, input: $input, emailToken: $emailToken, phoneToken: $phoneToken) {\n    id\n    arn\n    userPoolId\n    status\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    externalId\n    phoneCountryCode\n    expiredAt\n    directManagement\n  }\n}\n    ";
var CheckLoginStatusDocument = "\n    query checkLoginStatus($token: String) {\n  checkLoginStatus(token: $token) {\n    code\n    message\n    status\n    exp\n    iat\n    data {\n      id\n      userPoolId\n      arn\n    }\n  }\n}\n    ";
var CheckPasswordStrengthDocument = "\n    query checkPasswordStrength($password: String!) {\n  checkPasswordStrength(password: $password) {\n    valid\n    message\n  }\n}\n    ";
var GetUserDepartmentsDocument = "\n    query getUserDepartments($id: String!, $orgId: String) {\n  user(id: $id) {\n    departments(orgId: $orgId) {\n      totalCount\n      list {\n        department {\n          id\n          orgId\n          name\n          nameI18n\n          description\n          descriptionI18n\n          order\n          code\n          root\n          depth\n          path\n          codePath\n          namePath\n          createdAt\n          updatedAt\n          children\n          isVirtualNode\n        }\n        isMainDepartment\n        joinedAt\n      }\n    }\n  }\n}\n    ";
var GetUserRolesDocument = "\n    query getUserRoles($id: String!, $namespace: String) {\n  user(id: $id) {\n    roles(namespace: $namespace) {\n      totalCount\n      list {\n        id\n        code\n        namespace\n        arn\n        description\n        createdAt\n        updatedAt\n        parent {\n          code\n          namespace\n          arn\n          description\n          createdAt\n          updatedAt\n        }\n      }\n    }\n  }\n}\n    ";
var IsUserExistsDocument = "\n    query isUserExists($email: String, $phone: String, $username: String, $externalId: String) {\n  isUserExists(email: $email, phone: $phone, username: $username, externalId: $externalId)\n}\n    ";
var ListUserAuthorizedResourcesDocument = "\n    query listUserAuthorizedResources($id: String!, $namespace: String, $resourceType: String) {\n  user(id: $id) {\n    authorizedResources(namespace: $namespace, resourceType: $resourceType) {\n      totalCount\n      list {\n        code\n        type\n        actions\n        apiIdentifier\n      }\n    }\n  }\n}\n    ";
var UdvDocument = "\n    query udv($targetType: UDFTargetType!, $targetId: String!) {\n  udv(targetType: $targetType, targetId: $targetId) {\n    key\n    dataType\n    value\n    label\n  }\n}\n    ";
var UserDocument = "\n    query user($id: String) {\n  user(id: $id) {\n    id\n    arn\n    userPoolId\n    status\n    username\n    email\n    emailVerified\n    phone\n    phoneVerified\n    identities {\n      openid\n      userIdInIdp\n      userId\n      connectionId\n      isSocial\n      provider\n      type\n      userPoolId\n      extIdpId\n    }\n    unionid\n    openid\n    nickname\n    registerSource\n    photo\n    password\n    oauth\n    token\n    tokenExpiredAt\n    loginsCount\n    lastLogin\n    lastIP\n    signedUp\n    blocked\n    isDeleted\n    device\n    browser\n    company\n    name\n    givenName\n    familyName\n    middleName\n    profile\n    preferredUsername\n    website\n    gender\n    birthdate\n    zoneinfo\n    locale\n    address\n    formatted\n    streetAddress\n    locality\n    region\n    postalCode\n    city\n    province\n    country\n    createdAt\n    updatedAt\n    externalId\n    phoneCountryCode\n    customData {\n      key\n      value\n      dataType\n      label\n    }\n  }\n}\n    ";
var cryptoJs$1 = { exports: {} };
function commonjsRequire$1(path) {
  throw new Error('Could not dynamically require "' + path + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');
}
var core$3 = { exports: {} };
var cryptoBrowserify = {};
var browser$g = { exports: {} };
var safeBuffer$1 = { exports: {} };
/*! safe-buffer. MIT License. Feross Aboukhadijeh <https://feross.org/opensource> */
var hasRequiredSafeBuffer$1;
function requireSafeBuffer$1() {
  if (hasRequiredSafeBuffer$1) return safeBuffer$1.exports;
  hasRequiredSafeBuffer$1 = 1;
  (function(module2, exports) {
    var buffer2 = requireBuffer$1();
    var Buffer2 = buffer2.Buffer;
    function copyProps(src2, dst) {
      for (var key2 in src2) {
        dst[key2] = src2[key2];
      }
    }
    if (Buffer2.from && Buffer2.alloc && Buffer2.allocUnsafe && Buffer2.allocUnsafeSlow) {
      module2.exports = buffer2;
    } else {
      copyProps(buffer2, exports);
      exports.Buffer = SafeBuffer;
    }
    function SafeBuffer(arg, encodingOrOffset, length) {
      return Buffer2(arg, encodingOrOffset, length);
    }
    SafeBuffer.prototype = Object.create(Buffer2.prototype);
    copyProps(Buffer2, SafeBuffer);
    SafeBuffer.from = function(arg, encodingOrOffset, length) {
      if (typeof arg === "number") {
        throw new TypeError("Argument must not be a number");
      }
      return Buffer2(arg, encodingOrOffset, length);
    };
    SafeBuffer.alloc = function(size, fill, encoding) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      var buf = Buffer2(size);
      if (fill !== void 0) {
        if (typeof encoding === "string") {
          buf.fill(fill, encoding);
        } else {
          buf.fill(fill);
        }
      } else {
        buf.fill(0);
      }
      return buf;
    };
    SafeBuffer.allocUnsafe = function(size) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      return Buffer2(size);
    };
    SafeBuffer.allocUnsafeSlow = function(size) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      return buffer2.SlowBuffer(size);
    };
  })(safeBuffer$1, safeBuffer$1.exports);
  return safeBuffer$1.exports;
}
var hasRequiredBrowser$e;
function requireBrowser$e() {
  if (hasRequiredBrowser$e) return browser$g.exports;
  hasRequiredBrowser$e = 1;
  var MAX_BYTES = 65536;
  var MAX_UINT32 = 4294967295;
  function oldBrowser() {
    throw new Error("Secure random number generation is not supported by this browser.\nUse Chrome, Firefox or Internet Explorer 11");
  }
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var crypto2 = commonjsGlobal$1.crypto || commonjsGlobal$1.msCrypto;
  if (crypto2 && crypto2.getRandomValues) {
    browser$g.exports = randomBytes;
  } else {
    browser$g.exports = oldBrowser;
  }
  function randomBytes(size, cb) {
    if (size > MAX_UINT32) throw new RangeError("requested too many random bytes");
    var bytes = Buffer2.allocUnsafe(size);
    if (size > 0) {
      if (size > MAX_BYTES) {
        for (var generated = 0; generated < size; generated += MAX_BYTES) {
          crypto2.getRandomValues(bytes.slice(generated, generated + MAX_BYTES));
        }
      } else {
        crypto2.getRandomValues(bytes);
      }
    }
    if (typeof cb === "function") {
      return process.nextTick(function() {
        cb(null, bytes);
      });
    }
    return bytes;
  }
  return browser$g.exports;
}
var inherits_browser = { exports: {} };
var hasRequiredInherits_browser;
function requireInherits_browser() {
  if (hasRequiredInherits_browser) return inherits_browser.exports;
  hasRequiredInherits_browser = 1;
  if (typeof Object.create === "function") {
    inherits_browser.exports = function inherits(ctor, superCtor) {
      if (superCtor) {
        ctor.super_ = superCtor;
        ctor.prototype = Object.create(superCtor.prototype, {
          constructor: {
            value: ctor,
            enumerable: false,
            writable: true,
            configurable: true
          }
        });
      }
    };
  } else {
    inherits_browser.exports = function inherits(ctor, superCtor) {
      if (superCtor) {
        ctor.super_ = superCtor;
        var TempCtor = function() {
        };
        TempCtor.prototype = superCtor.prototype;
        ctor.prototype = new TempCtor();
        ctor.prototype.constructor = ctor;
      }
    };
  }
  return inherits_browser.exports;
}
var componentEmitter = { exports: {} };
var hasRequiredComponentEmitter;
function requireComponentEmitter() {
  if (hasRequiredComponentEmitter) return componentEmitter.exports;
  hasRequiredComponentEmitter = 1;
  (function(module2) {
    function Emitter(object) {
      if (object) {
        return mixin(object);
      }
      this._callbacks = /* @__PURE__ */ new Map();
    }
    function mixin(object) {
      Object.assign(object, Emitter.prototype);
      object._callbacks = /* @__PURE__ */ new Map();
      return object;
    }
    Emitter.prototype.on = function(event, listener) {
      const callbacks = this._callbacks.get(event) ?? [];
      callbacks.push(listener);
      this._callbacks.set(event, callbacks);
      return this;
    };
    Emitter.prototype.once = function(event, listener) {
      const on = (...arguments_) => {
        this.off(event, on);
        listener.apply(this, arguments_);
      };
      on.fn = listener;
      this.on(event, on);
      return this;
    };
    Emitter.prototype.off = function(event, listener) {
      if (event === void 0 && listener === void 0) {
        this._callbacks.clear();
        return this;
      }
      if (listener === void 0) {
        this._callbacks.delete(event);
        return this;
      }
      const callbacks = this._callbacks.get(event);
      if (callbacks) {
        for (const [index2, callback] of callbacks.entries()) {
          if (callback === listener || callback.fn === listener) {
            callbacks.splice(index2, 1);
            break;
          }
        }
        if (callbacks.length === 0) {
          this._callbacks.delete(event);
        } else {
          this._callbacks.set(event, callbacks);
        }
      }
      return this;
    };
    Emitter.prototype.emit = function(event, ...arguments_) {
      const callbacks = this._callbacks.get(event);
      if (callbacks) {
        const callbacksCopy = [...callbacks];
        for (const callback of callbacksCopy) {
          callback.apply(this, arguments_);
        }
      }
      return this;
    };
    Emitter.prototype.listeners = function(event) {
      return this._callbacks.get(event) ?? [];
    };
    Emitter.prototype.listenerCount = function(event) {
      if (event) {
        return this.listeners(event).length;
      }
      let totalCount = 0;
      for (const callbacks of this._callbacks.values()) {
        totalCount += callbacks.length;
      }
      return totalCount;
    };
    Emitter.prototype.hasListeners = function(event) {
      return this.listenerCount(event) > 0;
    };
    Emitter.prototype.addEventListener = Emitter.prototype.on;
    Emitter.prototype.removeListener = Emitter.prototype.off;
    Emitter.prototype.removeEventListener = Emitter.prototype.off;
    Emitter.prototype.removeAllListeners = Emitter.prototype.off;
    {
      module2.exports = Emitter;
    }
  })(componentEmitter);
  return componentEmitter.exports;
}
var stream$1;
var hasRequiredStream;
function requireStream() {
  if (hasRequiredStream) return stream$1;
  hasRequiredStream = 1;
  var Emitter = /* @__PURE__ */ requireComponentEmitter();
  function Stream2() {
    Emitter.call(this);
  }
  Stream2.prototype = new Emitter();
  stream$1 = Stream2;
  Stream2.Stream = Stream2;
  Stream2.prototype.pipe = function(dest, options2) {
    var source = this;
    function ondata(chunk) {
      if (dest.writable) {
        if (false === dest.write(chunk) && source.pause) {
          source.pause();
        }
      }
    }
    source.on("data", ondata);
    function ondrain() {
      if (source.readable && source.resume) {
        source.resume();
      }
    }
    dest.on("drain", ondrain);
    if (!dest._isStdio && (!options2 || options2.end !== false)) {
      source.on("end", onend);
      source.on("close", onclose);
    }
    var didOnEnd = false;
    function onend() {
      if (didOnEnd) return;
      didOnEnd = true;
      dest.end();
    }
    function onclose() {
      if (didOnEnd) return;
      didOnEnd = true;
      if (typeof dest.destroy === "function") dest.destroy();
    }
    function onerror(er) {
      cleanup();
      if (!this.hasListeners("error")) {
        throw er;
      }
    }
    source.on("error", onerror);
    dest.on("error", onerror);
    function cleanup() {
      source.off("data", ondata);
      dest.off("drain", ondrain);
      source.off("end", onend);
      source.off("close", onclose);
      source.off("error", onerror);
      dest.off("error", onerror);
      source.off("end", cleanup);
      source.off("close", cleanup);
      dest.off("end", cleanup);
      dest.off("close", cleanup);
    }
    source.on("end", cleanup);
    source.on("close", cleanup);
    dest.on("end", cleanup);
    dest.on("close", cleanup);
    dest.emit("pipe", source);
    return dest;
  };
  return stream$1;
}
var hashBase$1;
var hasRequiredHashBase$1;
function requireHashBase$1() {
  if (hasRequiredHashBase$1) return hashBase$1;
  hasRequiredHashBase$1 = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var Transform = requireStream().Transform;
  var inherits = requireInherits_browser();
  function HashBase(blockSize) {
    Transform.call(this);
    this._block = Buffer2.allocUnsafe(blockSize);
    this._blockSize = blockSize;
    this._blockOffset = 0;
    this._length = [0, 0, 0, 0];
    this._finalized = false;
  }
  inherits(HashBase, Transform);
  HashBase.prototype._transform = function(chunk, encoding, callback) {
    var error = null;
    try {
      this.update(chunk, encoding);
    } catch (err) {
      error = err;
    }
    callback(error);
  };
  HashBase.prototype._flush = function(callback) {
    var error = null;
    try {
      this.push(this.digest());
    } catch (err) {
      error = err;
    }
    callback(error);
  };
  var useUint8Array = typeof Uint8Array !== "undefined";
  var useArrayBuffer = typeof ArrayBuffer !== "undefined" && typeof Uint8Array !== "undefined" && ArrayBuffer.isView && (Buffer2.prototype instanceof Uint8Array || Buffer2.TYPED_ARRAY_SUPPORT);
  function toBuffer2(data2, encoding) {
    if (data2 instanceof Buffer2) return data2;
    if (typeof data2 === "string") return Buffer2.from(data2, encoding);
    if (useArrayBuffer && ArrayBuffer.isView(data2)) {
      if (data2.byteLength === 0) return Buffer2.alloc(0);
      var res = Buffer2.from(data2.buffer, data2.byteOffset, data2.byteLength);
      if (res.byteLength === data2.byteLength) return res;
    }
    if (useUint8Array && data2 instanceof Uint8Array) return Buffer2.from(data2);
    if (Buffer2.isBuffer(data2) && data2.constructor && typeof data2.constructor.isBuffer === "function" && data2.constructor.isBuffer(data2)) {
      return Buffer2.from(data2);
    }
    throw new TypeError('The "data" argument must be of type string or an instance of Buffer, TypedArray, or DataView.');
  }
  HashBase.prototype.update = function(data2, encoding) {
    if (this._finalized) throw new Error("Digest already called");
    data2 = toBuffer2(data2, encoding);
    var block = this._block;
    var offset = 0;
    while (this._blockOffset + data2.length - offset >= this._blockSize) {
      for (var i2 = this._blockOffset; i2 < this._blockSize; ) block[i2++] = data2[offset++];
      this._update();
      this._blockOffset = 0;
    }
    while (offset < data2.length) block[this._blockOffset++] = data2[offset++];
    for (var j = 0, carry = data2.length * 8; carry > 0; ++j) {
      this._length[j] += carry;
      carry = this._length[j] / 4294967296 | 0;
      if (carry > 0) this._length[j] -= 4294967296 * carry;
    }
    return this;
  };
  HashBase.prototype._update = function() {
    throw new Error("_update is not implemented");
  };
  HashBase.prototype.digest = function(encoding) {
    if (this._finalized) throw new Error("Digest already called");
    this._finalized = true;
    var digest = this._digest();
    if (encoding !== void 0) digest = digest.toString(encoding);
    this._block.fill(0);
    this._blockOffset = 0;
    for (var i2 = 0; i2 < 4; ++i2) this._length[i2] = 0;
    return digest;
  };
  HashBase.prototype._digest = function() {
    throw new Error("_digest is not implemented");
  };
  hashBase$1 = HashBase;
  return hashBase$1;
}
var md5_js;
var hasRequiredMd5_js;
function requireMd5_js() {
  if (hasRequiredMd5_js) return md5_js;
  hasRequiredMd5_js = 1;
  var inherits = requireInherits_browser();
  var HashBase = requireHashBase$1();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var ARRAY16 = new Array(16);
  function MD5() {
    HashBase.call(this, 64);
    this._a = 1732584193;
    this._b = 4023233417;
    this._c = 2562383102;
    this._d = 271733878;
  }
  inherits(MD5, HashBase);
  MD5.prototype._update = function() {
    var M2 = ARRAY16;
    for (var i2 = 0; i2 < 16; ++i2) M2[i2] = this._block.readInt32LE(i2 * 4);
    var a2 = this._a;
    var b2 = this._b;
    var c2 = this._c;
    var d = this._d;
    a2 = fnF(a2, b2, c2, d, M2[0], 3614090360, 7);
    d = fnF(d, a2, b2, c2, M2[1], 3905402710, 12);
    c2 = fnF(c2, d, a2, b2, M2[2], 606105819, 17);
    b2 = fnF(b2, c2, d, a2, M2[3], 3250441966, 22);
    a2 = fnF(a2, b2, c2, d, M2[4], 4118548399, 7);
    d = fnF(d, a2, b2, c2, M2[5], 1200080426, 12);
    c2 = fnF(c2, d, a2, b2, M2[6], 2821735955, 17);
    b2 = fnF(b2, c2, d, a2, M2[7], 4249261313, 22);
    a2 = fnF(a2, b2, c2, d, M2[8], 1770035416, 7);
    d = fnF(d, a2, b2, c2, M2[9], 2336552879, 12);
    c2 = fnF(c2, d, a2, b2, M2[10], 4294925233, 17);
    b2 = fnF(b2, c2, d, a2, M2[11], 2304563134, 22);
    a2 = fnF(a2, b2, c2, d, M2[12], 1804603682, 7);
    d = fnF(d, a2, b2, c2, M2[13], 4254626195, 12);
    c2 = fnF(c2, d, a2, b2, M2[14], 2792965006, 17);
    b2 = fnF(b2, c2, d, a2, M2[15], 1236535329, 22);
    a2 = fnG(a2, b2, c2, d, M2[1], 4129170786, 5);
    d = fnG(d, a2, b2, c2, M2[6], 3225465664, 9);
    c2 = fnG(c2, d, a2, b2, M2[11], 643717713, 14);
    b2 = fnG(b2, c2, d, a2, M2[0], 3921069994, 20);
    a2 = fnG(a2, b2, c2, d, M2[5], 3593408605, 5);
    d = fnG(d, a2, b2, c2, M2[10], 38016083, 9);
    c2 = fnG(c2, d, a2, b2, M2[15], 3634488961, 14);
    b2 = fnG(b2, c2, d, a2, M2[4], 3889429448, 20);
    a2 = fnG(a2, b2, c2, d, M2[9], 568446438, 5);
    d = fnG(d, a2, b2, c2, M2[14], 3275163606, 9);
    c2 = fnG(c2, d, a2, b2, M2[3], 4107603335, 14);
    b2 = fnG(b2, c2, d, a2, M2[8], 1163531501, 20);
    a2 = fnG(a2, b2, c2, d, M2[13], 2850285829, 5);
    d = fnG(d, a2, b2, c2, M2[2], 4243563512, 9);
    c2 = fnG(c2, d, a2, b2, M2[7], 1735328473, 14);
    b2 = fnG(b2, c2, d, a2, M2[12], 2368359562, 20);
    a2 = fnH(a2, b2, c2, d, M2[5], 4294588738, 4);
    d = fnH(d, a2, b2, c2, M2[8], 2272392833, 11);
    c2 = fnH(c2, d, a2, b2, M2[11], 1839030562, 16);
    b2 = fnH(b2, c2, d, a2, M2[14], 4259657740, 23);
    a2 = fnH(a2, b2, c2, d, M2[1], 2763975236, 4);
    d = fnH(d, a2, b2, c2, M2[4], 1272893353, 11);
    c2 = fnH(c2, d, a2, b2, M2[7], 4139469664, 16);
    b2 = fnH(b2, c2, d, a2, M2[10], 3200236656, 23);
    a2 = fnH(a2, b2, c2, d, M2[13], 681279174, 4);
    d = fnH(d, a2, b2, c2, M2[0], 3936430074, 11);
    c2 = fnH(c2, d, a2, b2, M2[3], 3572445317, 16);
    b2 = fnH(b2, c2, d, a2, M2[6], 76029189, 23);
    a2 = fnH(a2, b2, c2, d, M2[9], 3654602809, 4);
    d = fnH(d, a2, b2, c2, M2[12], 3873151461, 11);
    c2 = fnH(c2, d, a2, b2, M2[15], 530742520, 16);
    b2 = fnH(b2, c2, d, a2, M2[2], 3299628645, 23);
    a2 = fnI(a2, b2, c2, d, M2[0], 4096336452, 6);
    d = fnI(d, a2, b2, c2, M2[7], 1126891415, 10);
    c2 = fnI(c2, d, a2, b2, M2[14], 2878612391, 15);
    b2 = fnI(b2, c2, d, a2, M2[5], 4237533241, 21);
    a2 = fnI(a2, b2, c2, d, M2[12], 1700485571, 6);
    d = fnI(d, a2, b2, c2, M2[3], 2399980690, 10);
    c2 = fnI(c2, d, a2, b2, M2[10], 4293915773, 15);
    b2 = fnI(b2, c2, d, a2, M2[1], 2240044497, 21);
    a2 = fnI(a2, b2, c2, d, M2[8], 1873313359, 6);
    d = fnI(d, a2, b2, c2, M2[15], 4264355552, 10);
    c2 = fnI(c2, d, a2, b2, M2[6], 2734768916, 15);
    b2 = fnI(b2, c2, d, a2, M2[13], 1309151649, 21);
    a2 = fnI(a2, b2, c2, d, M2[4], 4149444226, 6);
    d = fnI(d, a2, b2, c2, M2[11], 3174756917, 10);
    c2 = fnI(c2, d, a2, b2, M2[2], 718787259, 15);
    b2 = fnI(b2, c2, d, a2, M2[9], 3951481745, 21);
    this._a = this._a + a2 | 0;
    this._b = this._b + b2 | 0;
    this._c = this._c + c2 | 0;
    this._d = this._d + d | 0;
  };
  MD5.prototype._digest = function() {
    this._block[this._blockOffset++] = 128;
    if (this._blockOffset > 56) {
      this._block.fill(0, this._blockOffset, 64);
      this._update();
      this._blockOffset = 0;
    }
    this._block.fill(0, this._blockOffset, 56);
    this._block.writeUInt32LE(this._length[0], 56);
    this._block.writeUInt32LE(this._length[1], 60);
    this._update();
    var buffer2 = Buffer2.allocUnsafe(16);
    buffer2.writeInt32LE(this._a, 0);
    buffer2.writeInt32LE(this._b, 4);
    buffer2.writeInt32LE(this._c, 8);
    buffer2.writeInt32LE(this._d, 12);
    return buffer2;
  };
  function rotl2(x2, n2) {
    return x2 << n2 | x2 >>> 32 - n2;
  }
  function fnF(a2, b2, c2, d, m, k2, s2) {
    return rotl2(a2 + (b2 & c2 | ~b2 & d) + m + k2 | 0, s2) + b2 | 0;
  }
  function fnG(a2, b2, c2, d, m, k2, s2) {
    return rotl2(a2 + (b2 & d | c2 & ~d) + m + k2 | 0, s2) + b2 | 0;
  }
  function fnH(a2, b2, c2, d, m, k2, s2) {
    return rotl2(a2 + (b2 ^ c2 ^ d) + m + k2 | 0, s2) + b2 | 0;
  }
  function fnI(a2, b2, c2, d, m, k2, s2) {
    return rotl2(a2 + (c2 ^ (b2 | ~d)) + m + k2 | 0, s2) + b2 | 0;
  }
  md5_js = MD5;
  return md5_js;
}
var isarray$1;
var hasRequiredIsarray$1;
function requireIsarray$1() {
  if (hasRequiredIsarray$1) return isarray$1;
  hasRequiredIsarray$1 = 1;
  var toString2 = {}.toString;
  isarray$1 = Array.isArray || function(arr) {
    return toString2.call(arr) == "[object Array]";
  };
  return isarray$1;
}
var type$2;
var hasRequiredType;
function requireType() {
  if (hasRequiredType) return type$2;
  hasRequiredType = 1;
  type$2 = TypeError;
  return type$2;
}
var esObjectAtoms;
var hasRequiredEsObjectAtoms;
function requireEsObjectAtoms() {
  if (hasRequiredEsObjectAtoms) return esObjectAtoms;
  hasRequiredEsObjectAtoms = 1;
  esObjectAtoms = Object;
  return esObjectAtoms;
}
var esErrors;
var hasRequiredEsErrors;
function requireEsErrors() {
  if (hasRequiredEsErrors) return esErrors;
  hasRequiredEsErrors = 1;
  esErrors = Error;
  return esErrors;
}
var _eval;
var hasRequired_eval;
function require_eval() {
  if (hasRequired_eval) return _eval;
  hasRequired_eval = 1;
  _eval = EvalError;
  return _eval;
}
var range;
var hasRequiredRange;
function requireRange() {
  if (hasRequiredRange) return range;
  hasRequiredRange = 1;
  range = RangeError;
  return range;
}
var ref$1;
var hasRequiredRef$1;
function requireRef$1() {
  if (hasRequiredRef$1) return ref$1;
  hasRequiredRef$1 = 1;
  ref$1 = ReferenceError;
  return ref$1;
}
var syntax;
var hasRequiredSyntax;
function requireSyntax() {
  if (hasRequiredSyntax) return syntax;
  hasRequiredSyntax = 1;
  syntax = SyntaxError;
  return syntax;
}
var uri;
var hasRequiredUri;
function requireUri() {
  if (hasRequiredUri) return uri;
  hasRequiredUri = 1;
  uri = URIError;
  return uri;
}
var abs;
var hasRequiredAbs;
function requireAbs() {
  if (hasRequiredAbs) return abs;
  hasRequiredAbs = 1;
  abs = Math.abs;
  return abs;
}
var floor;
var hasRequiredFloor;
function requireFloor() {
  if (hasRequiredFloor) return floor;
  hasRequiredFloor = 1;
  floor = Math.floor;
  return floor;
}
var max$1;
var hasRequiredMax;
function requireMax() {
  if (hasRequiredMax) return max$1;
  hasRequiredMax = 1;
  max$1 = Math.max;
  return max$1;
}
var min;
var hasRequiredMin;
function requireMin() {
  if (hasRequiredMin) return min;
  hasRequiredMin = 1;
  min = Math.min;
  return min;
}
var pow;
var hasRequiredPow;
function requirePow() {
  if (hasRequiredPow) return pow;
  hasRequiredPow = 1;
  pow = Math.pow;
  return pow;
}
var round$1;
var hasRequiredRound;
function requireRound() {
  if (hasRequiredRound) return round$1;
  hasRequiredRound = 1;
  round$1 = Math.round;
  return round$1;
}
var _isNaN;
var hasRequired_isNaN;
function require_isNaN() {
  if (hasRequired_isNaN) return _isNaN;
  hasRequired_isNaN = 1;
  _isNaN = Number.isNaN || function isNaN2(a2) {
    return a2 !== a2;
  };
  return _isNaN;
}
var sign$1;
var hasRequiredSign$1;
function requireSign$1() {
  if (hasRequiredSign$1) return sign$1;
  hasRequiredSign$1 = 1;
  var $isNaN = /* @__PURE__ */ require_isNaN();
  sign$1 = function sign2(number) {
    if ($isNaN(number) || number === 0) {
      return number;
    }
    return number < 0 ? -1 : 1;
  };
  return sign$1;
}
var gOPD;
var hasRequiredGOPD;
function requireGOPD() {
  if (hasRequiredGOPD) return gOPD;
  hasRequiredGOPD = 1;
  gOPD = Object.getOwnPropertyDescriptor;
  return gOPD;
}
var gopd;
var hasRequiredGopd;
function requireGopd() {
  if (hasRequiredGopd) return gopd;
  hasRequiredGopd = 1;
  var $gOPD = /* @__PURE__ */ requireGOPD();
  if ($gOPD) {
    try {
      $gOPD([], "length");
    } catch (e4) {
      $gOPD = null;
    }
  }
  gopd = $gOPD;
  return gopd;
}
var esDefineProperty;
var hasRequiredEsDefineProperty;
function requireEsDefineProperty() {
  if (hasRequiredEsDefineProperty) return esDefineProperty;
  hasRequiredEsDefineProperty = 1;
  var $defineProperty = Object.defineProperty || false;
  if ($defineProperty) {
    try {
      $defineProperty({}, "a", { value: 1 });
    } catch (e4) {
      $defineProperty = false;
    }
  }
  esDefineProperty = $defineProperty;
  return esDefineProperty;
}
var shams$1;
var hasRequiredShams$1;
function requireShams$1() {
  if (hasRequiredShams$1) return shams$1;
  hasRequiredShams$1 = 1;
  shams$1 = function hasSymbols2() {
    if (typeof Symbol !== "function" || typeof Object.getOwnPropertySymbols !== "function") {
      return false;
    }
    if (typeof Symbol.iterator === "symbol") {
      return true;
    }
    var obj = {};
    var sym = Symbol("test");
    var symObj = Object(sym);
    if (typeof sym === "string") {
      return false;
    }
    if (Object.prototype.toString.call(sym) !== "[object Symbol]") {
      return false;
    }
    if (Object.prototype.toString.call(symObj) !== "[object Symbol]") {
      return false;
    }
    var symVal = 42;
    obj[sym] = symVal;
    for (var _2 in obj) {
      return false;
    }
    if (typeof Object.keys === "function" && Object.keys(obj).length !== 0) {
      return false;
    }
    if (typeof Object.getOwnPropertyNames === "function" && Object.getOwnPropertyNames(obj).length !== 0) {
      return false;
    }
    var syms = Object.getOwnPropertySymbols(obj);
    if (syms.length !== 1 || syms[0] !== sym) {
      return false;
    }
    if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) {
      return false;
    }
    if (typeof Object.getOwnPropertyDescriptor === "function") {
      var descriptor = (
        /** @type {PropertyDescriptor} */
        Object.getOwnPropertyDescriptor(obj, sym)
      );
      if (descriptor.value !== symVal || descriptor.enumerable !== true) {
        return false;
      }
    }
    return true;
  };
  return shams$1;
}
var hasSymbols;
var hasRequiredHasSymbols;
function requireHasSymbols() {
  if (hasRequiredHasSymbols) return hasSymbols;
  hasRequiredHasSymbols = 1;
  var origSymbol = typeof Symbol !== "undefined" && Symbol;
  var hasSymbolSham = requireShams$1();
  hasSymbols = function hasNativeSymbols() {
    if (typeof origSymbol !== "function") {
      return false;
    }
    if (typeof Symbol !== "function") {
      return false;
    }
    if (typeof origSymbol("foo") !== "symbol") {
      return false;
    }
    if (typeof Symbol("bar") !== "symbol") {
      return false;
    }
    return hasSymbolSham();
  };
  return hasSymbols;
}
var Reflect_getPrototypeOf;
var hasRequiredReflect_getPrototypeOf;
function requireReflect_getPrototypeOf() {
  if (hasRequiredReflect_getPrototypeOf) return Reflect_getPrototypeOf;
  hasRequiredReflect_getPrototypeOf = 1;
  Reflect_getPrototypeOf = typeof Reflect !== "undefined" && Reflect.getPrototypeOf || null;
  return Reflect_getPrototypeOf;
}
var Object_getPrototypeOf;
var hasRequiredObject_getPrototypeOf;
function requireObject_getPrototypeOf() {
  if (hasRequiredObject_getPrototypeOf) return Object_getPrototypeOf;
  hasRequiredObject_getPrototypeOf = 1;
  var $Object = /* @__PURE__ */ requireEsObjectAtoms();
  Object_getPrototypeOf = $Object.getPrototypeOf || null;
  return Object_getPrototypeOf;
}
var implementation;
var hasRequiredImplementation;
function requireImplementation() {
  if (hasRequiredImplementation) return implementation;
  hasRequiredImplementation = 1;
  var ERROR_MESSAGE = "Function.prototype.bind called on incompatible ";
  var toStr = Object.prototype.toString;
  var max2 = Math.max;
  var funcType = "[object Function]";
  var concatty = function concatty2(a2, b2) {
    var arr = [];
    for (var i2 = 0; i2 < a2.length; i2 += 1) {
      arr[i2] = a2[i2];
    }
    for (var j = 0; j < b2.length; j += 1) {
      arr[j + a2.length] = b2[j];
    }
    return arr;
  };
  var slicy = function slicy2(arrLike, offset) {
    var arr = [];
    for (var i2 = offset, j = 0; i2 < arrLike.length; i2 += 1, j += 1) {
      arr[j] = arrLike[i2];
    }
    return arr;
  };
  var joiny = function(arr, joiner) {
    var str = "";
    for (var i2 = 0; i2 < arr.length; i2 += 1) {
      str += arr[i2];
      if (i2 + 1 < arr.length) {
        str += joiner;
      }
    }
    return str;
  };
  implementation = function bind2(that) {
    var target = this;
    if (typeof target !== "function" || toStr.apply(target) !== funcType) {
      throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slicy(arguments, 1);
    var bound;
    var binder = function() {
      if (this instanceof bound) {
        var result = target.apply(
          this,
          concatty(args, arguments)
        );
        if (Object(result) === result) {
          return result;
        }
        return this;
      }
      return target.apply(
        that,
        concatty(args, arguments)
      );
    };
    var boundLength = max2(0, target.length - args.length);
    var boundArgs = [];
    for (var i2 = 0; i2 < boundLength; i2++) {
      boundArgs[i2] = "$" + i2;
    }
    bound = Function("binder", "return function (" + joiny(boundArgs, ",") + "){ return binder.apply(this,arguments); }")(binder);
    if (target.prototype) {
      var Empty = function Empty2() {
      };
      Empty.prototype = target.prototype;
      bound.prototype = new Empty();
      Empty.prototype = null;
    }
    return bound;
  };
  return implementation;
}
var functionBind;
var hasRequiredFunctionBind;
function requireFunctionBind() {
  if (hasRequiredFunctionBind) return functionBind;
  hasRequiredFunctionBind = 1;
  var implementation2 = requireImplementation();
  functionBind = Function.prototype.bind || implementation2;
  return functionBind;
}
var functionCall;
var hasRequiredFunctionCall;
function requireFunctionCall() {
  if (hasRequiredFunctionCall) return functionCall;
  hasRequiredFunctionCall = 1;
  functionCall = Function.prototype.call;
  return functionCall;
}
var functionApply;
var hasRequiredFunctionApply;
function requireFunctionApply() {
  if (hasRequiredFunctionApply) return functionApply;
  hasRequiredFunctionApply = 1;
  functionApply = Function.prototype.apply;
  return functionApply;
}
var reflectApply;
var hasRequiredReflectApply;
function requireReflectApply() {
  if (hasRequiredReflectApply) return reflectApply;
  hasRequiredReflectApply = 1;
  reflectApply = typeof Reflect !== "undefined" && Reflect && Reflect.apply;
  return reflectApply;
}
var actualApply;
var hasRequiredActualApply;
function requireActualApply() {
  if (hasRequiredActualApply) return actualApply;
  hasRequiredActualApply = 1;
  var bind2 = requireFunctionBind();
  var $apply = requireFunctionApply();
  var $call = requireFunctionCall();
  var $reflectApply = requireReflectApply();
  actualApply = $reflectApply || bind2.call($call, $apply);
  return actualApply;
}
var callBindApplyHelpers;
var hasRequiredCallBindApplyHelpers;
function requireCallBindApplyHelpers() {
  if (hasRequiredCallBindApplyHelpers) return callBindApplyHelpers;
  hasRequiredCallBindApplyHelpers = 1;
  var bind2 = requireFunctionBind();
  var $TypeError = /* @__PURE__ */ requireType();
  var $call = requireFunctionCall();
  var $actualApply = requireActualApply();
  callBindApplyHelpers = function callBindBasic(args) {
    if (args.length < 1 || typeof args[0] !== "function") {
      throw new $TypeError("a function is required");
    }
    return $actualApply(bind2, $call, args);
  };
  return callBindApplyHelpers;
}
var get$1;
var hasRequiredGet;
function requireGet() {
  if (hasRequiredGet) return get$1;
  hasRequiredGet = 1;
  var callBind2 = requireCallBindApplyHelpers();
  var gOPD2 = /* @__PURE__ */ requireGopd();
  var hasProtoAccessor;
  try {
    hasProtoAccessor = /** @type {{ __proto__?: typeof Array.prototype }} */
    [].__proto__ === Array.prototype;
  } catch (e4) {
    if (!e4 || typeof e4 !== "object" || !("code" in e4) || e4.code !== "ERR_PROTO_ACCESS") {
      throw e4;
    }
  }
  var desc = !!hasProtoAccessor && gOPD2 && gOPD2(
    Object.prototype,
    /** @type {keyof typeof Object.prototype} */
    "__proto__"
  );
  var $Object = Object;
  var $getPrototypeOf = $Object.getPrototypeOf;
  get$1 = desc && typeof desc.get === "function" ? callBind2([desc.get]) : typeof $getPrototypeOf === "function" ? (
    /** @type {import('./get')} */
    function getDunder(value) {
      return $getPrototypeOf(value == null ? value : $Object(value));
    }
  ) : false;
  return get$1;
}
var getProto;
var hasRequiredGetProto;
function requireGetProto() {
  if (hasRequiredGetProto) return getProto;
  hasRequiredGetProto = 1;
  var reflectGetProto = requireReflect_getPrototypeOf();
  var originalGetProto = requireObject_getPrototypeOf();
  var getDunderProto = /* @__PURE__ */ requireGet();
  getProto = reflectGetProto ? function getProto2(O2) {
    return reflectGetProto(O2);
  } : originalGetProto ? function getProto2(O2) {
    if (!O2 || typeof O2 !== "object" && typeof O2 !== "function") {
      throw new TypeError("getProto: not an object");
    }
    return originalGetProto(O2);
  } : getDunderProto ? function getProto2(O2) {
    return getDunderProto(O2);
  } : null;
  return getProto;
}
var hasown;
var hasRequiredHasown;
function requireHasown() {
  if (hasRequiredHasown) return hasown;
  hasRequiredHasown = 1;
  var call = Function.prototype.call;
  var $hasOwn = Object.prototype.hasOwnProperty;
  var bind2 = requireFunctionBind();
  hasown = bind2.call(call, $hasOwn);
  return hasown;
}
var getIntrinsic;
var hasRequiredGetIntrinsic;
function requireGetIntrinsic() {
  if (hasRequiredGetIntrinsic) return getIntrinsic;
  hasRequiredGetIntrinsic = 1;
  var undefined$1;
  var $Object = /* @__PURE__ */ requireEsObjectAtoms();
  var $Error = /* @__PURE__ */ requireEsErrors();
  var $EvalError = /* @__PURE__ */ require_eval();
  var $RangeError = /* @__PURE__ */ requireRange();
  var $ReferenceError = /* @__PURE__ */ requireRef$1();
  var $SyntaxError = /* @__PURE__ */ requireSyntax();
  var $TypeError = /* @__PURE__ */ requireType();
  var $URIError = /* @__PURE__ */ requireUri();
  var abs2 = /* @__PURE__ */ requireAbs();
  var floor2 = /* @__PURE__ */ requireFloor();
  var max2 = /* @__PURE__ */ requireMax();
  var min2 = /* @__PURE__ */ requireMin();
  var pow2 = /* @__PURE__ */ requirePow();
  var round2 = /* @__PURE__ */ requireRound();
  var sign2 = /* @__PURE__ */ requireSign$1();
  var $Function = Function;
  var getEvalledConstructor = function(expressionSyntax) {
    try {
      return $Function('"use strict"; return (' + expressionSyntax + ").constructor;")();
    } catch (e4) {
    }
  };
  var $gOPD = /* @__PURE__ */ requireGopd();
  var $defineProperty = /* @__PURE__ */ requireEsDefineProperty();
  var throwTypeError = function() {
    throw new $TypeError();
  };
  var ThrowTypeError = $gOPD ? function() {
    try {
      arguments.callee;
      return throwTypeError;
    } catch (calleeThrows) {
      try {
        return $gOPD(arguments, "callee").get;
      } catch (gOPDthrows) {
        return throwTypeError;
      }
    }
  }() : throwTypeError;
  var hasSymbols2 = requireHasSymbols()();
  var getProto2 = requireGetProto();
  var $ObjectGPO = requireObject_getPrototypeOf();
  var $ReflectGPO = requireReflect_getPrototypeOf();
  var $apply = requireFunctionApply();
  var $call = requireFunctionCall();
  var needsEval = {};
  var TypedArray = typeof Uint8Array === "undefined" || !getProto2 ? undefined$1 : getProto2(Uint8Array);
  var INTRINSICS = {
    __proto__: null,
    "%AggregateError%": typeof AggregateError === "undefined" ? undefined$1 : AggregateError,
    "%Array%": Array,
    "%ArrayBuffer%": typeof ArrayBuffer === "undefined" ? undefined$1 : ArrayBuffer,
    "%ArrayIteratorPrototype%": hasSymbols2 && getProto2 ? getProto2([][Symbol.iterator]()) : undefined$1,
    "%AsyncFromSyncIteratorPrototype%": undefined$1,
    "%AsyncFunction%": needsEval,
    "%AsyncGenerator%": needsEval,
    "%AsyncGeneratorFunction%": needsEval,
    "%AsyncIteratorPrototype%": needsEval,
    "%Atomics%": typeof Atomics === "undefined" ? undefined$1 : Atomics,
    "%BigInt%": typeof BigInt === "undefined" ? undefined$1 : BigInt,
    "%BigInt64Array%": typeof BigInt64Array === "undefined" ? undefined$1 : BigInt64Array,
    "%BigUint64Array%": typeof BigUint64Array === "undefined" ? undefined$1 : BigUint64Array,
    "%Boolean%": Boolean,
    "%DataView%": typeof DataView === "undefined" ? undefined$1 : DataView,
    "%Date%": Date,
    "%decodeURI%": decodeURI,
    "%decodeURIComponent%": decodeURIComponent,
    "%encodeURI%": encodeURI,
    "%encodeURIComponent%": encodeURIComponent,
    "%Error%": $Error,
    "%eval%": eval,
    // eslint-disable-line no-eval
    "%EvalError%": $EvalError,
    "%Float16Array%": typeof Float16Array === "undefined" ? undefined$1 : Float16Array,
    "%Float32Array%": typeof Float32Array === "undefined" ? undefined$1 : Float32Array,
    "%Float64Array%": typeof Float64Array === "undefined" ? undefined$1 : Float64Array,
    "%FinalizationRegistry%": typeof FinalizationRegistry === "undefined" ? undefined$1 : FinalizationRegistry,
    "%Function%": $Function,
    "%GeneratorFunction%": needsEval,
    "%Int8Array%": typeof Int8Array === "undefined" ? undefined$1 : Int8Array,
    "%Int16Array%": typeof Int16Array === "undefined" ? undefined$1 : Int16Array,
    "%Int32Array%": typeof Int32Array === "undefined" ? undefined$1 : Int32Array,
    "%isFinite%": isFinite,
    "%isNaN%": isNaN,
    "%IteratorPrototype%": hasSymbols2 && getProto2 ? getProto2(getProto2([][Symbol.iterator]())) : undefined$1,
    "%JSON%": typeof JSON === "object" ? JSON : undefined$1,
    "%Map%": typeof Map === "undefined" ? undefined$1 : Map,
    "%MapIteratorPrototype%": typeof Map === "undefined" || !hasSymbols2 || !getProto2 ? undefined$1 : getProto2((/* @__PURE__ */ new Map())[Symbol.iterator]()),
    "%Math%": Math,
    "%Number%": Number,
    "%Object%": $Object,
    "%Object.getOwnPropertyDescriptor%": $gOPD,
    "%parseFloat%": parseFloat,
    "%parseInt%": parseInt,
    "%Promise%": typeof Promise === "undefined" ? undefined$1 : Promise,
    "%Proxy%": typeof Proxy === "undefined" ? undefined$1 : Proxy,
    "%RangeError%": $RangeError,
    "%ReferenceError%": $ReferenceError,
    "%Reflect%": typeof Reflect === "undefined" ? undefined$1 : Reflect,
    "%RegExp%": RegExp,
    "%Set%": typeof Set === "undefined" ? undefined$1 : Set,
    "%SetIteratorPrototype%": typeof Set === "undefined" || !hasSymbols2 || !getProto2 ? undefined$1 : getProto2((/* @__PURE__ */ new Set())[Symbol.iterator]()),
    "%SharedArrayBuffer%": typeof SharedArrayBuffer === "undefined" ? undefined$1 : SharedArrayBuffer,
    "%String%": String,
    "%StringIteratorPrototype%": hasSymbols2 && getProto2 ? getProto2(""[Symbol.iterator]()) : undefined$1,
    "%Symbol%": hasSymbols2 ? Symbol : undefined$1,
    "%SyntaxError%": $SyntaxError,
    "%ThrowTypeError%": ThrowTypeError,
    "%TypedArray%": TypedArray,
    "%TypeError%": $TypeError,
    "%Uint8Array%": typeof Uint8Array === "undefined" ? undefined$1 : Uint8Array,
    "%Uint8ClampedArray%": typeof Uint8ClampedArray === "undefined" ? undefined$1 : Uint8ClampedArray,
    "%Uint16Array%": typeof Uint16Array === "undefined" ? undefined$1 : Uint16Array,
    "%Uint32Array%": typeof Uint32Array === "undefined" ? undefined$1 : Uint32Array,
    "%URIError%": $URIError,
    "%WeakMap%": typeof WeakMap === "undefined" ? undefined$1 : WeakMap,
    "%WeakRef%": typeof WeakRef === "undefined" ? undefined$1 : WeakRef,
    "%WeakSet%": typeof WeakSet === "undefined" ? undefined$1 : WeakSet,
    "%Function.prototype.call%": $call,
    "%Function.prototype.apply%": $apply,
    "%Object.defineProperty%": $defineProperty,
    "%Object.getPrototypeOf%": $ObjectGPO,
    "%Math.abs%": abs2,
    "%Math.floor%": floor2,
    "%Math.max%": max2,
    "%Math.min%": min2,
    "%Math.pow%": pow2,
    "%Math.round%": round2,
    "%Math.sign%": sign2,
    "%Reflect.getPrototypeOf%": $ReflectGPO
  };
  if (getProto2) {
    try {
      null.error;
    } catch (e4) {
      var errorProto = getProto2(getProto2(e4));
      INTRINSICS["%Error.prototype%"] = errorProto;
    }
  }
  var doEval = function doEval2(name) {
    var value;
    if (name === "%AsyncFunction%") {
      value = getEvalledConstructor("async function () {}");
    } else if (name === "%GeneratorFunction%") {
      value = getEvalledConstructor("function* () {}");
    } else if (name === "%AsyncGeneratorFunction%") {
      value = getEvalledConstructor("async function* () {}");
    } else if (name === "%AsyncGenerator%") {
      var fn = doEval2("%AsyncGeneratorFunction%");
      if (fn) {
        value = fn.prototype;
      }
    } else if (name === "%AsyncIteratorPrototype%") {
      var gen = doEval2("%AsyncGenerator%");
      if (gen && getProto2) {
        value = getProto2(gen.prototype);
      }
    }
    INTRINSICS[name] = value;
    return value;
  };
  var LEGACY_ALIASES = {
    __proto__: null,
    "%ArrayBufferPrototype%": ["ArrayBuffer", "prototype"],
    "%ArrayPrototype%": ["Array", "prototype"],
    "%ArrayProto_entries%": ["Array", "prototype", "entries"],
    "%ArrayProto_forEach%": ["Array", "prototype", "forEach"],
    "%ArrayProto_keys%": ["Array", "prototype", "keys"],
    "%ArrayProto_values%": ["Array", "prototype", "values"],
    "%AsyncFunctionPrototype%": ["AsyncFunction", "prototype"],
    "%AsyncGenerator%": ["AsyncGeneratorFunction", "prototype"],
    "%AsyncGeneratorPrototype%": ["AsyncGeneratorFunction", "prototype", "prototype"],
    "%BooleanPrototype%": ["Boolean", "prototype"],
    "%DataViewPrototype%": ["DataView", "prototype"],
    "%DatePrototype%": ["Date", "prototype"],
    "%ErrorPrototype%": ["Error", "prototype"],
    "%EvalErrorPrototype%": ["EvalError", "prototype"],
    "%Float32ArrayPrototype%": ["Float32Array", "prototype"],
    "%Float64ArrayPrototype%": ["Float64Array", "prototype"],
    "%FunctionPrototype%": ["Function", "prototype"],
    "%Generator%": ["GeneratorFunction", "prototype"],
    "%GeneratorPrototype%": ["GeneratorFunction", "prototype", "prototype"],
    "%Int8ArrayPrototype%": ["Int8Array", "prototype"],
    "%Int16ArrayPrototype%": ["Int16Array", "prototype"],
    "%Int32ArrayPrototype%": ["Int32Array", "prototype"],
    "%JSONParse%": ["JSON", "parse"],
    "%JSONStringify%": ["JSON", "stringify"],
    "%MapPrototype%": ["Map", "prototype"],
    "%NumberPrototype%": ["Number", "prototype"],
    "%ObjectPrototype%": ["Object", "prototype"],
    "%ObjProto_toString%": ["Object", "prototype", "toString"],
    "%ObjProto_valueOf%": ["Object", "prototype", "valueOf"],
    "%PromisePrototype%": ["Promise", "prototype"],
    "%PromiseProto_then%": ["Promise", "prototype", "then"],
    "%Promise_all%": ["Promise", "all"],
    "%Promise_reject%": ["Promise", "reject"],
    "%Promise_resolve%": ["Promise", "resolve"],
    "%RangeErrorPrototype%": ["RangeError", "prototype"],
    "%ReferenceErrorPrototype%": ["ReferenceError", "prototype"],
    "%RegExpPrototype%": ["RegExp", "prototype"],
    "%SetPrototype%": ["Set", "prototype"],
    "%SharedArrayBufferPrototype%": ["SharedArrayBuffer", "prototype"],
    "%StringPrototype%": ["String", "prototype"],
    "%SymbolPrototype%": ["Symbol", "prototype"],
    "%SyntaxErrorPrototype%": ["SyntaxError", "prototype"],
    "%TypedArrayPrototype%": ["TypedArray", "prototype"],
    "%TypeErrorPrototype%": ["TypeError", "prototype"],
    "%Uint8ArrayPrototype%": ["Uint8Array", "prototype"],
    "%Uint8ClampedArrayPrototype%": ["Uint8ClampedArray", "prototype"],
    "%Uint16ArrayPrototype%": ["Uint16Array", "prototype"],
    "%Uint32ArrayPrototype%": ["Uint32Array", "prototype"],
    "%URIErrorPrototype%": ["URIError", "prototype"],
    "%WeakMapPrototype%": ["WeakMap", "prototype"],
    "%WeakSetPrototype%": ["WeakSet", "prototype"]
  };
  var bind2 = requireFunctionBind();
  var hasOwn2 = /* @__PURE__ */ requireHasown();
  var $concat = bind2.call($call, Array.prototype.concat);
  var $spliceApply = bind2.call($apply, Array.prototype.splice);
  var $replace = bind2.call($call, String.prototype.replace);
  var $strSlice = bind2.call($call, String.prototype.slice);
  var $exec = bind2.call($call, RegExp.prototype.exec);
  var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
  var reEscapeChar = /\\(\\)?/g;
  var stringToPath = function stringToPath2(string) {
    var first = $strSlice(string, 0, 1);
    var last = $strSlice(string, -1);
    if (first === "%" && last !== "%") {
      throw new $SyntaxError("invalid intrinsic syntax, expected closing `%`");
    } else if (last === "%" && first !== "%") {
      throw new $SyntaxError("invalid intrinsic syntax, expected opening `%`");
    }
    var result = [];
    $replace(string, rePropName, function(match, number, quote, subString) {
      result[result.length] = quote ? $replace(subString, reEscapeChar, "$1") : number || match;
    });
    return result;
  };
  var getBaseIntrinsic = function getBaseIntrinsic2(name, allowMissing) {
    var intrinsicName = name;
    var alias;
    if (hasOwn2(LEGACY_ALIASES, intrinsicName)) {
      alias = LEGACY_ALIASES[intrinsicName];
      intrinsicName = "%" + alias[0] + "%";
    }
    if (hasOwn2(INTRINSICS, intrinsicName)) {
      var value = INTRINSICS[intrinsicName];
      if (value === needsEval) {
        value = doEval(intrinsicName);
      }
      if (typeof value === "undefined" && !allowMissing) {
        throw new $TypeError("intrinsic " + name + " exists, but is not available. Please file an issue!");
      }
      return {
        alias,
        name: intrinsicName,
        value
      };
    }
    throw new $SyntaxError("intrinsic " + name + " does not exist!");
  };
  getIntrinsic = function GetIntrinsic(name, allowMissing) {
    if (typeof name !== "string" || name.length === 0) {
      throw new $TypeError("intrinsic name must be a non-empty string");
    }
    if (arguments.length > 1 && typeof allowMissing !== "boolean") {
      throw new $TypeError('"allowMissing" argument must be a boolean');
    }
    if ($exec(/^%?[^%]*%?$/, name) === null) {
      throw new $SyntaxError("`%` may not be present anywhere but at the beginning and end of the intrinsic name");
    }
    var parts = stringToPath(name);
    var intrinsicBaseName = parts.length > 0 ? parts[0] : "";
    var intrinsic = getBaseIntrinsic("%" + intrinsicBaseName + "%", allowMissing);
    var intrinsicRealName = intrinsic.name;
    var value = intrinsic.value;
    var skipFurtherCaching = false;
    var alias = intrinsic.alias;
    if (alias) {
      intrinsicBaseName = alias[0];
      $spliceApply(parts, $concat([0, 1], alias));
    }
    for (var i2 = 1, isOwn = true; i2 < parts.length; i2 += 1) {
      var part = parts[i2];
      var first = $strSlice(part, 0, 1);
      var last = $strSlice(part, -1);
      if ((first === '"' || first === "'" || first === "`" || (last === '"' || last === "'" || last === "`")) && first !== last) {
        throw new $SyntaxError("property names with quotes must have matching quotes");
      }
      if (part === "constructor" || !isOwn) {
        skipFurtherCaching = true;
      }
      intrinsicBaseName += "." + part;
      intrinsicRealName = "%" + intrinsicBaseName + "%";
      if (hasOwn2(INTRINSICS, intrinsicRealName)) {
        value = INTRINSICS[intrinsicRealName];
      } else if (value != null) {
        if (!(part in value)) {
          if (!allowMissing) {
            throw new $TypeError("base intrinsic for " + name + " exists, but the property is not available.");
          }
          return void 0;
        }
        if ($gOPD && i2 + 1 >= parts.length) {
          var desc = $gOPD(value, part);
          isOwn = !!desc;
          if (isOwn && "get" in desc && !("originalValue" in desc.get)) {
            value = desc.get;
          } else {
            value = value[part];
          }
        } else {
          isOwn = hasOwn2(value, part);
          value = value[part];
        }
        if (isOwn && !skipFurtherCaching) {
          INTRINSICS[intrinsicRealName] = value;
        }
      }
    }
    return value;
  };
  return getIntrinsic;
}
var callBound;
var hasRequiredCallBound;
function requireCallBound() {
  if (hasRequiredCallBound) return callBound;
  hasRequiredCallBound = 1;
  var GetIntrinsic = /* @__PURE__ */ requireGetIntrinsic();
  var callBindBasic = requireCallBindApplyHelpers();
  var $indexOf = callBindBasic([GetIntrinsic("%String.prototype.indexOf%")]);
  callBound = function callBoundIntrinsic(name, allowMissing) {
    var intrinsic = (
      /** @type {(this: unknown, ...args: unknown[]) => unknown} */
      GetIntrinsic(name, !!allowMissing)
    );
    if (typeof intrinsic === "function" && $indexOf(name, ".prototype.") > -1) {
      return callBindBasic(
        /** @type {const} */
        [intrinsic]
      );
    }
    return intrinsic;
  };
  return callBound;
}
var isCallable;
var hasRequiredIsCallable;
function requireIsCallable() {
  if (hasRequiredIsCallable) return isCallable;
  hasRequiredIsCallable = 1;
  var fnToStr = Function.prototype.toString;
  var reflectApply2 = typeof Reflect === "object" && Reflect !== null && Reflect.apply;
  var badArrayLike;
  var isCallableMarker;
  if (typeof reflectApply2 === "function" && typeof Object.defineProperty === "function") {
    try {
      badArrayLike = Object.defineProperty({}, "length", {
        get: function() {
          throw isCallableMarker;
        }
      });
      isCallableMarker = {};
      reflectApply2(function() {
        throw 42;
      }, null, badArrayLike);
    } catch (_2) {
      if (_2 !== isCallableMarker) {
        reflectApply2 = null;
      }
    }
  } else {
    reflectApply2 = null;
  }
  var constructorRegex = /^\s*class\b/;
  var isES6ClassFn = function isES6ClassFunction(value) {
    try {
      var fnStr = fnToStr.call(value);
      return constructorRegex.test(fnStr);
    } catch (e4) {
      return false;
    }
  };
  var tryFunctionObject = function tryFunctionToStr(value) {
    try {
      if (isES6ClassFn(value)) {
        return false;
      }
      fnToStr.call(value);
      return true;
    } catch (e4) {
      return false;
    }
  };
  var toStr = Object.prototype.toString;
  var objectClass = "[object Object]";
  var fnClass = "[object Function]";
  var genClass = "[object GeneratorFunction]";
  var ddaClass = "[object HTMLAllCollection]";
  var ddaClass2 = "[object HTML document.all class]";
  var ddaClass3 = "[object HTMLCollection]";
  var hasToStringTag = typeof Symbol === "function" && !!Symbol.toStringTag;
  var isIE68 = !(0 in [,]);
  var isDDA = function isDocumentDotAll() {
    return false;
  };
  if (typeof document === "object") {
    var all = document.all;
    if (toStr.call(all) === toStr.call(document.all)) {
      isDDA = function isDocumentDotAll(value) {
        if ((isIE68 || !value) && (typeof value === "undefined" || typeof value === "object")) {
          try {
            var str = toStr.call(value);
            return (str === ddaClass || str === ddaClass2 || str === ddaClass3 || str === objectClass) && value("") == null;
          } catch (e4) {
          }
        }
        return false;
      };
    }
  }
  isCallable = reflectApply2 ? function isCallable2(value) {
    if (isDDA(value)) {
      return true;
    }
    if (!value) {
      return false;
    }
    if (typeof value !== "function" && typeof value !== "object") {
      return false;
    }
    try {
      reflectApply2(value, null, badArrayLike);
    } catch (e4) {
      if (e4 !== isCallableMarker) {
        return false;
      }
    }
    return !isES6ClassFn(value) && tryFunctionObject(value);
  } : function isCallable2(value) {
    if (isDDA(value)) {
      return true;
    }
    if (!value) {
      return false;
    }
    if (typeof value !== "function" && typeof value !== "object") {
      return false;
    }
    if (hasToStringTag) {
      return tryFunctionObject(value);
    }
    if (isES6ClassFn(value)) {
      return false;
    }
    var strClass = toStr.call(value);
    if (strClass !== fnClass && strClass !== genClass && !/^\[object HTML/.test(strClass)) {
      return false;
    }
    return tryFunctionObject(value);
  };
  return isCallable;
}
var forEach;
var hasRequiredForEach;
function requireForEach() {
  if (hasRequiredForEach) return forEach;
  hasRequiredForEach = 1;
  var isCallable2 = requireIsCallable();
  var toStr = Object.prototype.toString;
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var forEachArray = function forEachArray2(array, iterator, receiver) {
    for (var i2 = 0, len = array.length; i2 < len; i2++) {
      if (hasOwnProperty.call(array, i2)) {
        if (receiver == null) {
          iterator(array[i2], i2, array);
        } else {
          iterator.call(receiver, array[i2], i2, array);
        }
      }
    }
  };
  var forEachString = function forEachString2(string, iterator, receiver) {
    for (var i2 = 0, len = string.length; i2 < len; i2++) {
      if (receiver == null) {
        iterator(string.charAt(i2), i2, string);
      } else {
        iterator.call(receiver, string.charAt(i2), i2, string);
      }
    }
  };
  var forEachObject = function forEachObject2(object, iterator, receiver) {
    for (var k2 in object) {
      if (hasOwnProperty.call(object, k2)) {
        if (receiver == null) {
          iterator(object[k2], k2, object);
        } else {
          iterator.call(receiver, object[k2], k2, object);
        }
      }
    }
  };
  function isArray2(x2) {
    return toStr.call(x2) === "[object Array]";
  }
  forEach = function forEach2(list, iterator, thisArg) {
    if (!isCallable2(iterator)) {
      throw new TypeError("iterator must be a function");
    }
    var receiver;
    if (arguments.length >= 3) {
      receiver = thisArg;
    }
    if (isArray2(list)) {
      forEachArray(list, iterator, receiver);
    } else if (typeof list === "string") {
      forEachString(list, iterator, receiver);
    } else {
      forEachObject(list, iterator, receiver);
    }
  };
  return forEach;
}
var possibleTypedArrayNames;
var hasRequiredPossibleTypedArrayNames;
function requirePossibleTypedArrayNames() {
  if (hasRequiredPossibleTypedArrayNames) return possibleTypedArrayNames;
  hasRequiredPossibleTypedArrayNames = 1;
  possibleTypedArrayNames = [
    "Float16Array",
    "Float32Array",
    "Float64Array",
    "Int8Array",
    "Int16Array",
    "Int32Array",
    "Uint8Array",
    "Uint8ClampedArray",
    "Uint16Array",
    "Uint32Array",
    "BigInt64Array",
    "BigUint64Array"
  ];
  return possibleTypedArrayNames;
}
var availableTypedArrays;
var hasRequiredAvailableTypedArrays;
function requireAvailableTypedArrays() {
  if (hasRequiredAvailableTypedArrays) return availableTypedArrays;
  hasRequiredAvailableTypedArrays = 1;
  var possibleNames = /* @__PURE__ */ requirePossibleTypedArrayNames();
  var g = typeof globalThis === "undefined" ? commonjsGlobal$1 : globalThis;
  availableTypedArrays = function availableTypedArrays2() {
    var out = [];
    for (var i2 = 0; i2 < possibleNames.length; i2++) {
      if (typeof g[possibleNames[i2]] === "function") {
        out[out.length] = possibleNames[i2];
      }
    }
    return out;
  };
  return availableTypedArrays;
}
var callBind = { exports: {} };
var defineDataProperty;
var hasRequiredDefineDataProperty;
function requireDefineDataProperty() {
  if (hasRequiredDefineDataProperty) return defineDataProperty;
  hasRequiredDefineDataProperty = 1;
  var $defineProperty = /* @__PURE__ */ requireEsDefineProperty();
  var $SyntaxError = /* @__PURE__ */ requireSyntax();
  var $TypeError = /* @__PURE__ */ requireType();
  var gopd2 = /* @__PURE__ */ requireGopd();
  defineDataProperty = function defineDataProperty2(obj, property, value) {
    if (!obj || typeof obj !== "object" && typeof obj !== "function") {
      throw new $TypeError("`obj` must be an object or a function`");
    }
    if (typeof property !== "string" && typeof property !== "symbol") {
      throw new $TypeError("`property` must be a string or a symbol`");
    }
    if (arguments.length > 3 && typeof arguments[3] !== "boolean" && arguments[3] !== null) {
      throw new $TypeError("`nonEnumerable`, if provided, must be a boolean or null");
    }
    if (arguments.length > 4 && typeof arguments[4] !== "boolean" && arguments[4] !== null) {
      throw new $TypeError("`nonWritable`, if provided, must be a boolean or null");
    }
    if (arguments.length > 5 && typeof arguments[5] !== "boolean" && arguments[5] !== null) {
      throw new $TypeError("`nonConfigurable`, if provided, must be a boolean or null");
    }
    if (arguments.length > 6 && typeof arguments[6] !== "boolean") {
      throw new $TypeError("`loose`, if provided, must be a boolean");
    }
    var nonEnumerable = arguments.length > 3 ? arguments[3] : null;
    var nonWritable = arguments.length > 4 ? arguments[4] : null;
    var nonConfigurable = arguments.length > 5 ? arguments[5] : null;
    var loose = arguments.length > 6 ? arguments[6] : false;
    var desc = !!gopd2 && gopd2(obj, property);
    if ($defineProperty) {
      $defineProperty(obj, property, {
        configurable: nonConfigurable === null && desc ? desc.configurable : !nonConfigurable,
        enumerable: nonEnumerable === null && desc ? desc.enumerable : !nonEnumerable,
        value,
        writable: nonWritable === null && desc ? desc.writable : !nonWritable
      });
    } else if (loose || !nonEnumerable && !nonWritable && !nonConfigurable) {
      obj[property] = value;
    } else {
      throw new $SyntaxError("This environment does not support defining a property as non-configurable, non-writable, or non-enumerable.");
    }
  };
  return defineDataProperty;
}
var hasPropertyDescriptors_1;
var hasRequiredHasPropertyDescriptors;
function requireHasPropertyDescriptors() {
  if (hasRequiredHasPropertyDescriptors) return hasPropertyDescriptors_1;
  hasRequiredHasPropertyDescriptors = 1;
  var $defineProperty = /* @__PURE__ */ requireEsDefineProperty();
  var hasPropertyDescriptors = function hasPropertyDescriptors2() {
    return !!$defineProperty;
  };
  hasPropertyDescriptors.hasArrayLengthDefineBug = function hasArrayLengthDefineBug() {
    if (!$defineProperty) {
      return null;
    }
    try {
      return $defineProperty([], "length", { value: 1 }).length !== 1;
    } catch (e4) {
      return true;
    }
  };
  hasPropertyDescriptors_1 = hasPropertyDescriptors;
  return hasPropertyDescriptors_1;
}
var setFunctionLength;
var hasRequiredSetFunctionLength;
function requireSetFunctionLength() {
  if (hasRequiredSetFunctionLength) return setFunctionLength;
  hasRequiredSetFunctionLength = 1;
  var GetIntrinsic = /* @__PURE__ */ requireGetIntrinsic();
  var define = /* @__PURE__ */ requireDefineDataProperty();
  var hasDescriptors = /* @__PURE__ */ requireHasPropertyDescriptors()();
  var gOPD2 = /* @__PURE__ */ requireGopd();
  var $TypeError = /* @__PURE__ */ requireType();
  var $floor = GetIntrinsic("%Math.floor%");
  setFunctionLength = function setFunctionLength2(fn, length) {
    if (typeof fn !== "function") {
      throw new $TypeError("`fn` is not a function");
    }
    if (typeof length !== "number" || length < 0 || length > 4294967295 || $floor(length) !== length) {
      throw new $TypeError("`length` must be a positive 32-bit integer");
    }
    var loose = arguments.length > 2 && !!arguments[2];
    var functionLengthIsConfigurable = true;
    var functionLengthIsWritable = true;
    if ("length" in fn && gOPD2) {
      var desc = gOPD2(fn, "length");
      if (desc && !desc.configurable) {
        functionLengthIsConfigurable = false;
      }
      if (desc && !desc.writable) {
        functionLengthIsWritable = false;
      }
    }
    if (functionLengthIsConfigurable || functionLengthIsWritable || !loose) {
      if (hasDescriptors) {
        define(
          /** @type {Parameters<define>[0]} */
          fn,
          "length",
          length,
          true,
          true
        );
      } else {
        define(
          /** @type {Parameters<define>[0]} */
          fn,
          "length",
          length
        );
      }
    }
    return fn;
  };
  return setFunctionLength;
}
var applyBind;
var hasRequiredApplyBind;
function requireApplyBind() {
  if (hasRequiredApplyBind) return applyBind;
  hasRequiredApplyBind = 1;
  var bind2 = requireFunctionBind();
  var $apply = requireFunctionApply();
  var actualApply2 = requireActualApply();
  applyBind = function applyBind2() {
    return actualApply2(bind2, $apply, arguments);
  };
  return applyBind;
}
var hasRequiredCallBind;
function requireCallBind() {
  if (hasRequiredCallBind) return callBind.exports;
  hasRequiredCallBind = 1;
  (function(module2) {
    var setFunctionLength2 = /* @__PURE__ */ requireSetFunctionLength();
    var $defineProperty = /* @__PURE__ */ requireEsDefineProperty();
    var callBindBasic = requireCallBindApplyHelpers();
    var applyBind2 = requireApplyBind();
    module2.exports = function callBind2(originalFunction) {
      var func = callBindBasic(arguments);
      var adjustedLength = originalFunction.length - (arguments.length - 1);
      return setFunctionLength2(
        func,
        1 + (adjustedLength > 0 ? adjustedLength : 0),
        true
      );
    };
    if ($defineProperty) {
      $defineProperty(module2.exports, "apply", { value: applyBind2 });
    } else {
      module2.exports.apply = applyBind2;
    }
  })(callBind);
  return callBind.exports;
}
var shams;
var hasRequiredShams;
function requireShams() {
  if (hasRequiredShams) return shams;
  hasRequiredShams = 1;
  var hasSymbols2 = requireShams$1();
  shams = function hasToStringTagShams() {
    return hasSymbols2() && !!Symbol.toStringTag;
  };
  return shams;
}
var whichTypedArray;
var hasRequiredWhichTypedArray;
function requireWhichTypedArray() {
  if (hasRequiredWhichTypedArray) return whichTypedArray;
  hasRequiredWhichTypedArray = 1;
  var forEach2 = requireForEach();
  var availableTypedArrays2 = /* @__PURE__ */ requireAvailableTypedArrays();
  var callBind2 = requireCallBind();
  var callBound2 = /* @__PURE__ */ requireCallBound();
  var gOPD2 = /* @__PURE__ */ requireGopd();
  var getProto2 = requireGetProto();
  var $toString = callBound2("Object.prototype.toString");
  var hasToStringTag = requireShams()();
  var g = typeof globalThis === "undefined" ? commonjsGlobal$1 : globalThis;
  var typedArrays = availableTypedArrays2();
  var $slice = callBound2("String.prototype.slice");
  var $indexOf = callBound2("Array.prototype.indexOf", true) || function indexOf(array, value) {
    for (var i2 = 0; i2 < array.length; i2 += 1) {
      if (array[i2] === value) {
        return i2;
      }
    }
    return -1;
  };
  var cache2 = { __proto__: null };
  if (hasToStringTag && gOPD2 && getProto2) {
    forEach2(typedArrays, function(typedArray) {
      var arr = new g[typedArray]();
      if (Symbol.toStringTag in arr && getProto2) {
        var proto = getProto2(arr);
        var descriptor = gOPD2(proto, Symbol.toStringTag);
        if (!descriptor && proto) {
          var superProto = getProto2(proto);
          descriptor = gOPD2(superProto, Symbol.toStringTag);
        }
        cache2["$" + typedArray] = callBind2(descriptor.get);
      }
    });
  } else {
    forEach2(typedArrays, function(typedArray) {
      var arr = new g[typedArray]();
      var fn = arr.slice || arr.set;
      if (fn) {
        cache2[
          /** @type {`$${import('.').TypedArrayName}`} */
          "$" + typedArray
        ] = /** @type {import('./types').BoundSlice | import('./types').BoundSet} */
        // @ts-expect-error TODO FIXME
        callBind2(fn);
      }
    });
  }
  var tryTypedArrays = function tryAllTypedArrays(value) {
    var found = false;
    forEach2(
      /** @type {Record<`\$${import('.').TypedArrayName}`, Getter>} */
      cache2,
      /** @type {(getter: Getter, name: `\$${import('.').TypedArrayName}`) => void} */
      function(getter, typedArray) {
        if (!found) {
          try {
            if ("$" + getter(value) === typedArray) {
              found = /** @type {import('.').TypedArrayName} */
              $slice(typedArray, 1);
            }
          } catch (e4) {
          }
        }
      }
    );
    return found;
  };
  var trySlices = function tryAllSlices(value) {
    var found = false;
    forEach2(
      /** @type {Record<`\$${import('.').TypedArrayName}`, Getter>} */
      cache2,
      /** @type {(getter: Getter, name: `\$${import('.').TypedArrayName}`) => void} */
      function(getter, name) {
        if (!found) {
          try {
            getter(value);
            found = /** @type {import('.').TypedArrayName} */
            $slice(name, 1);
          } catch (e4) {
          }
        }
      }
    );
    return found;
  };
  whichTypedArray = function whichTypedArray2(value) {
    if (!value || typeof value !== "object") {
      return false;
    }
    if (!hasToStringTag) {
      var tag = $slice($toString(value), 8, -1);
      if ($indexOf(typedArrays, tag) > -1) {
        return tag;
      }
      if (tag !== "Object") {
        return false;
      }
      return trySlices(value);
    }
    if (!gOPD2) {
      return null;
    }
    return tryTypedArrays(value);
  };
  return whichTypedArray;
}
var isTypedArray;
var hasRequiredIsTypedArray;
function requireIsTypedArray() {
  if (hasRequiredIsTypedArray) return isTypedArray;
  hasRequiredIsTypedArray = 1;
  var whichTypedArray2 = /* @__PURE__ */ requireWhichTypedArray();
  isTypedArray = function isTypedArray2(value) {
    return !!whichTypedArray2(value);
  };
  return isTypedArray;
}
var typedArrayBuffer;
var hasRequiredTypedArrayBuffer;
function requireTypedArrayBuffer() {
  if (hasRequiredTypedArrayBuffer) return typedArrayBuffer;
  hasRequiredTypedArrayBuffer = 1;
  var $TypeError = /* @__PURE__ */ requireType();
  var callBound2 = /* @__PURE__ */ requireCallBound();
  var $typedArrayBuffer = callBound2("TypedArray.prototype.buffer", true);
  var isTypedArray2 = /* @__PURE__ */ requireIsTypedArray();
  typedArrayBuffer = $typedArrayBuffer || function typedArrayBuffer2(x2) {
    if (!isTypedArray2(x2)) {
      throw new $TypeError("Not a Typed Array");
    }
    return x2.buffer;
  };
  return typedArrayBuffer;
}
var toBuffer;
var hasRequiredToBuffer$2;
function requireToBuffer$2() {
  if (hasRequiredToBuffer$2) return toBuffer;
  hasRequiredToBuffer$2 = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var isArray2 = requireIsarray$1();
  var typedArrayBuffer2 = /* @__PURE__ */ requireTypedArrayBuffer();
  var isView = ArrayBuffer.isView || function isView2(obj) {
    try {
      typedArrayBuffer2(obj);
      return true;
    } catch (e4) {
      return false;
    }
  };
  var useUint8Array = typeof Uint8Array !== "undefined";
  var useArrayBuffer = typeof ArrayBuffer !== "undefined" && typeof Uint8Array !== "undefined";
  var useFromArrayBuffer = useArrayBuffer && (Buffer2.prototype instanceof Uint8Array || Buffer2.TYPED_ARRAY_SUPPORT);
  toBuffer = function toBuffer2(data2, encoding) {
    if (Buffer2.isBuffer(data2)) {
      if (data2.constructor && !("isBuffer" in data2)) {
        return Buffer2.from(data2);
      }
      return data2;
    }
    if (typeof data2 === "string") {
      return Buffer2.from(data2, encoding);
    }
    if (useArrayBuffer && isView(data2)) {
      if (data2.byteLength === 0) {
        return Buffer2.alloc(0);
      }
      if (useFromArrayBuffer) {
        var res = Buffer2.from(data2.buffer, data2.byteOffset, data2.byteLength);
        if (res.byteLength === data2.byteLength) {
          return res;
        }
      }
      var uint8 = data2 instanceof Uint8Array ? data2 : new Uint8Array(data2.buffer, data2.byteOffset, data2.byteLength);
      var result = Buffer2.from(uint8);
      if (result.length === data2.byteLength) {
        return result;
      }
    }
    if (useUint8Array && data2 instanceof Uint8Array) {
      return Buffer2.from(data2);
    }
    var isArr = isArray2(data2);
    if (isArr) {
      for (var i2 = 0; i2 < data2.length; i2 += 1) {
        var x2 = data2[i2];
        if (typeof x2 !== "number" || x2 < 0 || x2 > 255 || ~~x2 !== x2) {
          throw new RangeError("Array items must be numbers in the range 0-255.");
        }
      }
    }
    if (isArr || Buffer2.isBuffer(data2) && data2.constructor && typeof data2.constructor.isBuffer === "function" && data2.constructor.isBuffer(data2)) {
      return Buffer2.from(data2);
    }
    throw new TypeError('The "data" argument must be a string, an Array, a Buffer, a Uint8Array, or a DataView.');
  };
  return toBuffer;
}
var toBuffer_1$1;
var hasRequiredToBuffer$1;
function requireToBuffer$1() {
  if (hasRequiredToBuffer$1) return toBuffer_1$1;
  hasRequiredToBuffer$1 = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var toBuffer2 = /* @__PURE__ */ requireToBuffer$2();
  var useUint8Array = typeof Uint8Array !== "undefined";
  var useArrayBuffer = useUint8Array && typeof ArrayBuffer !== "undefined";
  var isView = useArrayBuffer && ArrayBuffer.isView;
  toBuffer_1$1 = function(thing, encoding) {
    if (typeof thing === "string" || Buffer2.isBuffer(thing) || useUint8Array && thing instanceof Uint8Array || isView && isView(thing)) {
      return toBuffer2(thing, encoding);
    }
    throw new TypeError('The "data" argument must be a string, a Buffer, a Uint8Array, or a DataView');
  };
  return toBuffer_1$1;
}
var readableBrowser = { exports: {} };
var processNextickArgs = { exports: {} };
var hasRequiredProcessNextickArgs;
function requireProcessNextickArgs() {
  if (hasRequiredProcessNextickArgs) return processNextickArgs.exports;
  hasRequiredProcessNextickArgs = 1;
  if (typeof process === "undefined" || !process.version || process.version.indexOf("v0.") === 0 || process.version.indexOf("v1.") === 0 && process.version.indexOf("v1.8.") !== 0) {
    processNextickArgs.exports = { nextTick };
  } else {
    processNextickArgs.exports = process;
  }
  function nextTick(fn, arg1, arg2, arg3) {
    if (typeof fn !== "function") {
      throw new TypeError('"callback" argument must be a function');
    }
    var len = arguments.length;
    var args, i2;
    switch (len) {
      case 0:
      case 1:
        return process.nextTick(fn);
      case 2:
        return process.nextTick(function afterTickOne() {
          fn.call(null, arg1);
        });
      case 3:
        return process.nextTick(function afterTickTwo() {
          fn.call(null, arg1, arg2);
        });
      case 4:
        return process.nextTick(function afterTickThree() {
          fn.call(null, arg1, arg2, arg3);
        });
      default:
        args = new Array(len - 1);
        i2 = 0;
        while (i2 < args.length) {
          args[i2++] = arguments[i2];
        }
        return process.nextTick(function afterTick() {
          fn.apply(null, args);
        });
    }
  }
  return processNextickArgs.exports;
}
var isarray;
var hasRequiredIsarray;
function requireIsarray() {
  if (hasRequiredIsarray) return isarray;
  hasRequiredIsarray = 1;
  var toString2 = {}.toString;
  isarray = Array.isArray || function(arr) {
    return toString2.call(arr) == "[object Array]";
  };
  return isarray;
}
var events = { exports: {} };
var hasRequiredEvents;
function requireEvents() {
  if (hasRequiredEvents) return events.exports;
  hasRequiredEvents = 1;
  var R2 = typeof Reflect === "object" ? Reflect : null;
  var ReflectApply = R2 && typeof R2.apply === "function" ? R2.apply : function ReflectApply2(target, receiver, args) {
    return Function.prototype.apply.call(target, receiver, args);
  };
  var ReflectOwnKeys;
  if (R2 && typeof R2.ownKeys === "function") {
    ReflectOwnKeys = R2.ownKeys;
  } else if (Object.getOwnPropertySymbols) {
    ReflectOwnKeys = function ReflectOwnKeys2(target) {
      return Object.getOwnPropertyNames(target).concat(Object.getOwnPropertySymbols(target));
    };
  } else {
    ReflectOwnKeys = function ReflectOwnKeys2(target) {
      return Object.getOwnPropertyNames(target);
    };
  }
  function ProcessEmitWarning(warning) {
    if (console && console.warn) console.warn(warning);
  }
  var NumberIsNaN = Number.isNaN || function NumberIsNaN2(value) {
    return value !== value;
  };
  function EventEmitter2() {
    EventEmitter2.init.call(this);
  }
  events.exports = EventEmitter2;
  events.exports.once = once;
  EventEmitter2.EventEmitter = EventEmitter2;
  EventEmitter2.prototype._events = void 0;
  EventEmitter2.prototype._eventsCount = 0;
  EventEmitter2.prototype._maxListeners = void 0;
  var defaultMaxListeners = 10;
  function checkListener(listener) {
    if (typeof listener !== "function") {
      throw new TypeError('The "listener" argument must be of type Function. Received type ' + typeof listener);
    }
  }
  Object.defineProperty(EventEmitter2, "defaultMaxListeners", {
    enumerable: true,
    get: function() {
      return defaultMaxListeners;
    },
    set: function(arg) {
      if (typeof arg !== "number" || arg < 0 || NumberIsNaN(arg)) {
        throw new RangeError('The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received ' + arg + ".");
      }
      defaultMaxListeners = arg;
    }
  });
  EventEmitter2.init = function() {
    if (this._events === void 0 || this._events === Object.getPrototypeOf(this)._events) {
      this._events = /* @__PURE__ */ Object.create(null);
      this._eventsCount = 0;
    }
    this._maxListeners = this._maxListeners || void 0;
  };
  EventEmitter2.prototype.setMaxListeners = function setMaxListeners(n2) {
    if (typeof n2 !== "number" || n2 < 0 || NumberIsNaN(n2)) {
      throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received ' + n2 + ".");
    }
    this._maxListeners = n2;
    return this;
  };
  function _getMaxListeners(that) {
    if (that._maxListeners === void 0)
      return EventEmitter2.defaultMaxListeners;
    return that._maxListeners;
  }
  EventEmitter2.prototype.getMaxListeners = function getMaxListeners() {
    return _getMaxListeners(this);
  };
  EventEmitter2.prototype.emit = function emit(type2) {
    var args = [];
    for (var i2 = 1; i2 < arguments.length; i2++) args.push(arguments[i2]);
    var doError = type2 === "error";
    var events2 = this._events;
    if (events2 !== void 0)
      doError = doError && events2.error === void 0;
    else if (!doError)
      return false;
    if (doError) {
      var er;
      if (args.length > 0)
        er = args[0];
      if (er instanceof Error) {
        throw er;
      }
      var err = new Error("Unhandled error." + (er ? " (" + er.message + ")" : ""));
      err.context = er;
      throw err;
    }
    var handler = events2[type2];
    if (handler === void 0)
      return false;
    if (typeof handler === "function") {
      ReflectApply(handler, this, args);
    } else {
      var len = handler.length;
      var listeners = arrayClone(handler, len);
      for (var i2 = 0; i2 < len; ++i2)
        ReflectApply(listeners[i2], this, args);
    }
    return true;
  };
  function _addListener(target, type2, listener, prepend) {
    var m;
    var events2;
    var existing;
    checkListener(listener);
    events2 = target._events;
    if (events2 === void 0) {
      events2 = target._events = /* @__PURE__ */ Object.create(null);
      target._eventsCount = 0;
    } else {
      if (events2.newListener !== void 0) {
        target.emit(
          "newListener",
          type2,
          listener.listener ? listener.listener : listener
        );
        events2 = target._events;
      }
      existing = events2[type2];
    }
    if (existing === void 0) {
      existing = events2[type2] = listener;
      ++target._eventsCount;
    } else {
      if (typeof existing === "function") {
        existing = events2[type2] = prepend ? [listener, existing] : [existing, listener];
      } else if (prepend) {
        existing.unshift(listener);
      } else {
        existing.push(listener);
      }
      m = _getMaxListeners(target);
      if (m > 0 && existing.length > m && !existing.warned) {
        existing.warned = true;
        var w = new Error("Possible EventEmitter memory leak detected. " + existing.length + " " + String(type2) + " listeners added. Use emitter.setMaxListeners() to increase limit");
        w.name = "MaxListenersExceededWarning";
        w.emitter = target;
        w.type = type2;
        w.count = existing.length;
        ProcessEmitWarning(w);
      }
    }
    return target;
  }
  EventEmitter2.prototype.addListener = function addListener(type2, listener) {
    return _addListener(this, type2, listener, false);
  };
  EventEmitter2.prototype.on = EventEmitter2.prototype.addListener;
  EventEmitter2.prototype.prependListener = function prependListener(type2, listener) {
    return _addListener(this, type2, listener, true);
  };
  function onceWrapper() {
    if (!this.fired) {
      this.target.removeListener(this.type, this.wrapFn);
      this.fired = true;
      if (arguments.length === 0)
        return this.listener.call(this.target);
      return this.listener.apply(this.target, arguments);
    }
  }
  function _onceWrap(target, type2, listener) {
    var state = { fired: false, wrapFn: void 0, target, type: type2, listener };
    var wrapped = onceWrapper.bind(state);
    wrapped.listener = listener;
    state.wrapFn = wrapped;
    return wrapped;
  }
  EventEmitter2.prototype.once = function once2(type2, listener) {
    checkListener(listener);
    this.on(type2, _onceWrap(this, type2, listener));
    return this;
  };
  EventEmitter2.prototype.prependOnceListener = function prependOnceListener(type2, listener) {
    checkListener(listener);
    this.prependListener(type2, _onceWrap(this, type2, listener));
    return this;
  };
  EventEmitter2.prototype.removeListener = function removeListener(type2, listener) {
    var list, events2, position, i2, originalListener;
    checkListener(listener);
    events2 = this._events;
    if (events2 === void 0)
      return this;
    list = events2[type2];
    if (list === void 0)
      return this;
    if (list === listener || list.listener === listener) {
      if (--this._eventsCount === 0)
        this._events = /* @__PURE__ */ Object.create(null);
      else {
        delete events2[type2];
        if (events2.removeListener)
          this.emit("removeListener", type2, list.listener || listener);
      }
    } else if (typeof list !== "function") {
      position = -1;
      for (i2 = list.length - 1; i2 >= 0; i2--) {
        if (list[i2] === listener || list[i2].listener === listener) {
          originalListener = list[i2].listener;
          position = i2;
          break;
        }
      }
      if (position < 0)
        return this;
      if (position === 0)
        list.shift();
      else {
        spliceOne(list, position);
      }
      if (list.length === 1)
        events2[type2] = list[0];
      if (events2.removeListener !== void 0)
        this.emit("removeListener", type2, originalListener || listener);
    }
    return this;
  };
  EventEmitter2.prototype.off = EventEmitter2.prototype.removeListener;
  EventEmitter2.prototype.removeAllListeners = function removeAllListeners(type2) {
    var listeners, events2, i2;
    events2 = this._events;
    if (events2 === void 0)
      return this;
    if (events2.removeListener === void 0) {
      if (arguments.length === 0) {
        this._events = /* @__PURE__ */ Object.create(null);
        this._eventsCount = 0;
      } else if (events2[type2] !== void 0) {
        if (--this._eventsCount === 0)
          this._events = /* @__PURE__ */ Object.create(null);
        else
          delete events2[type2];
      }
      return this;
    }
    if (arguments.length === 0) {
      var keys = Object.keys(events2);
      var key2;
      for (i2 = 0; i2 < keys.length; ++i2) {
        key2 = keys[i2];
        if (key2 === "removeListener") continue;
        this.removeAllListeners(key2);
      }
      this.removeAllListeners("removeListener");
      this._events = /* @__PURE__ */ Object.create(null);
      this._eventsCount = 0;
      return this;
    }
    listeners = events2[type2];
    if (typeof listeners === "function") {
      this.removeListener(type2, listeners);
    } else if (listeners !== void 0) {
      for (i2 = listeners.length - 1; i2 >= 0; i2--) {
        this.removeListener(type2, listeners[i2]);
      }
    }
    return this;
  };
  function _listeners(target, type2, unwrap) {
    var events2 = target._events;
    if (events2 === void 0)
      return [];
    var evlistener = events2[type2];
    if (evlistener === void 0)
      return [];
    if (typeof evlistener === "function")
      return unwrap ? [evlistener.listener || evlistener] : [evlistener];
    return unwrap ? unwrapListeners(evlistener) : arrayClone(evlistener, evlistener.length);
  }
  EventEmitter2.prototype.listeners = function listeners(type2) {
    return _listeners(this, type2, true);
  };
  EventEmitter2.prototype.rawListeners = function rawListeners(type2) {
    return _listeners(this, type2, false);
  };
  EventEmitter2.listenerCount = function(emitter, type2) {
    if (typeof emitter.listenerCount === "function") {
      return emitter.listenerCount(type2);
    } else {
      return listenerCount.call(emitter, type2);
    }
  };
  EventEmitter2.prototype.listenerCount = listenerCount;
  function listenerCount(type2) {
    var events2 = this._events;
    if (events2 !== void 0) {
      var evlistener = events2[type2];
      if (typeof evlistener === "function") {
        return 1;
      } else if (evlistener !== void 0) {
        return evlistener.length;
      }
    }
    return 0;
  }
  EventEmitter2.prototype.eventNames = function eventNames() {
    return this._eventsCount > 0 ? ReflectOwnKeys(this._events) : [];
  };
  function arrayClone(arr, n2) {
    var copy2 = new Array(n2);
    for (var i2 = 0; i2 < n2; ++i2)
      copy2[i2] = arr[i2];
    return copy2;
  }
  function spliceOne(list, index2) {
    for (; index2 + 1 < list.length; index2++)
      list[index2] = list[index2 + 1];
    list.pop();
  }
  function unwrapListeners(arr) {
    var ret = new Array(arr.length);
    for (var i2 = 0; i2 < ret.length; ++i2) {
      ret[i2] = arr[i2].listener || arr[i2];
    }
    return ret;
  }
  function once(emitter, name) {
    return new Promise(function(resolve2, reject2) {
      function errorListener(err) {
        emitter.removeListener(name, resolver);
        reject2(err);
      }
      function resolver() {
        if (typeof emitter.removeListener === "function") {
          emitter.removeListener("error", errorListener);
        }
        resolve2([].slice.call(arguments));
      }
      eventTargetAgnosticAddListener(emitter, name, resolver, { once: true });
      if (name !== "error") {
        addErrorHandlerIfEventEmitter(emitter, errorListener, { once: true });
      }
    });
  }
  function addErrorHandlerIfEventEmitter(emitter, handler, flags) {
    if (typeof emitter.on === "function") {
      eventTargetAgnosticAddListener(emitter, "error", handler, flags);
    }
  }
  function eventTargetAgnosticAddListener(emitter, name, listener, flags) {
    if (typeof emitter.on === "function") {
      if (flags.once) {
        emitter.once(name, listener);
      } else {
        emitter.on(name, listener);
      }
    } else if (typeof emitter.addEventListener === "function") {
      emitter.addEventListener(name, function wrapListener(arg) {
        if (flags.once) {
          emitter.removeEventListener(name, wrapListener);
        }
        listener(arg);
      });
    } else {
      throw new TypeError('The "emitter" argument must be of type EventEmitter. Received type ' + typeof emitter);
    }
  }
  return events.exports;
}
var streamBrowser;
var hasRequiredStreamBrowser;
function requireStreamBrowser() {
  if (hasRequiredStreamBrowser) return streamBrowser;
  hasRequiredStreamBrowser = 1;
  streamBrowser = requireEvents().EventEmitter;
  return streamBrowser;
}
var safeBuffer = { exports: {} };
var hasRequiredSafeBuffer;
function requireSafeBuffer() {
  if (hasRequiredSafeBuffer) return safeBuffer.exports;
  hasRequiredSafeBuffer = 1;
  (function(module2, exports) {
    var buffer2 = requireBuffer$1();
    var Buffer2 = buffer2.Buffer;
    function copyProps(src2, dst) {
      for (var key2 in src2) {
        dst[key2] = src2[key2];
      }
    }
    if (Buffer2.from && Buffer2.alloc && Buffer2.allocUnsafe && Buffer2.allocUnsafeSlow) {
      module2.exports = buffer2;
    } else {
      copyProps(buffer2, exports);
      exports.Buffer = SafeBuffer;
    }
    function SafeBuffer(arg, encodingOrOffset, length) {
      return Buffer2(arg, encodingOrOffset, length);
    }
    copyProps(Buffer2, SafeBuffer);
    SafeBuffer.from = function(arg, encodingOrOffset, length) {
      if (typeof arg === "number") {
        throw new TypeError("Argument must not be a number");
      }
      return Buffer2(arg, encodingOrOffset, length);
    };
    SafeBuffer.alloc = function(size, fill, encoding) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      var buf = Buffer2(size);
      if (fill !== void 0) {
        if (typeof encoding === "string") {
          buf.fill(fill, encoding);
        } else {
          buf.fill(fill);
        }
      } else {
        buf.fill(0);
      }
      return buf;
    };
    SafeBuffer.allocUnsafe = function(size) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      return Buffer2(size);
    };
    SafeBuffer.allocUnsafeSlow = function(size) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      return buffer2.SlowBuffer(size);
    };
  })(safeBuffer, safeBuffer.exports);
  return safeBuffer.exports;
}
var util$4 = {};
var hasRequiredUtil$1;
function requireUtil$1() {
  if (hasRequiredUtil$1) return util$4;
  hasRequiredUtil$1 = 1;
  function isArray2(arg) {
    if (Array.isArray) {
      return Array.isArray(arg);
    }
    return objectToString(arg) === "[object Array]";
  }
  util$4.isArray = isArray2;
  function isBoolean(arg) {
    return typeof arg === "boolean";
  }
  util$4.isBoolean = isBoolean;
  function isNull(arg) {
    return arg === null;
  }
  util$4.isNull = isNull;
  function isNullOrUndefined(arg) {
    return arg == null;
  }
  util$4.isNullOrUndefined = isNullOrUndefined;
  function isNumber(arg) {
    return typeof arg === "number";
  }
  util$4.isNumber = isNumber;
  function isString2(arg) {
    return typeof arg === "string";
  }
  util$4.isString = isString2;
  function isSymbol(arg) {
    return typeof arg === "symbol";
  }
  util$4.isSymbol = isSymbol;
  function isUndefined(arg) {
    return arg === void 0;
  }
  util$4.isUndefined = isUndefined;
  function isRegExp(re) {
    return objectToString(re) === "[object RegExp]";
  }
  util$4.isRegExp = isRegExp;
  function isObject(arg) {
    return typeof arg === "object" && arg !== null;
  }
  util$4.isObject = isObject;
  function isDate(d) {
    return objectToString(d) === "[object Date]";
  }
  util$4.isDate = isDate;
  function isError(e4) {
    return objectToString(e4) === "[object Error]" || e4 instanceof Error;
  }
  util$4.isError = isError;
  function isFunction(arg) {
    return typeof arg === "function";
  }
  util$4.isFunction = isFunction;
  function isPrimitive(arg) {
    return arg === null || typeof arg === "boolean" || typeof arg === "number" || typeof arg === "string" || typeof arg === "symbol" || // ES6 symbol
    typeof arg === "undefined";
  }
  util$4.isPrimitive = isPrimitive;
  util$4.isBuffer = requireBuffer$1().Buffer.isBuffer;
  function objectToString(o2) {
    return Object.prototype.toString.call(o2);
  }
  return util$4;
}
const __viteBrowserExternal = new Proxy({}, {
  get(_2, key2) {
    throw new Error(`Module "" has been externalized for browser compatibility. Cannot access ".${key2}" in client code.  See https://vite.dev/guide/troubleshooting.html#module-externalized-for-browser-compatibility for more details.`);
  }
});
const __viteBrowserExternal$1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: __viteBrowserExternal
}, Symbol.toStringTag, { value: "Module" }));
const require$$0$2 = /* @__PURE__ */ getAugmentedNamespace$1(__viteBrowserExternal$1);
var BufferList = { exports: {} };
var hasRequiredBufferList;
function requireBufferList() {
  if (hasRequiredBufferList) return BufferList.exports;
  hasRequiredBufferList = 1;
  (function(module2) {
    function _classCallCheck(instance2, Constructor) {
      if (!(instance2 instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }
    var Buffer2 = requireSafeBuffer().Buffer;
    var util2 = require$$0$2;
    function copyBuffer(src2, target, offset) {
      src2.copy(target, offset);
    }
    module2.exports = function() {
      function BufferList2() {
        _classCallCheck(this, BufferList2);
        this.head = null;
        this.tail = null;
        this.length = 0;
      }
      BufferList2.prototype.push = function push(v2) {
        var entry = { data: v2, next: null };
        if (this.length > 0) this.tail.next = entry;
        else this.head = entry;
        this.tail = entry;
        ++this.length;
      };
      BufferList2.prototype.unshift = function unshift(v2) {
        var entry = { data: v2, next: this.head };
        if (this.length === 0) this.tail = entry;
        this.head = entry;
        ++this.length;
      };
      BufferList2.prototype.shift = function shift() {
        if (this.length === 0) return;
        var ret = this.head.data;
        if (this.length === 1) this.head = this.tail = null;
        else this.head = this.head.next;
        --this.length;
        return ret;
      };
      BufferList2.prototype.clear = function clear() {
        this.head = this.tail = null;
        this.length = 0;
      };
      BufferList2.prototype.join = function join(s2) {
        if (this.length === 0) return "";
        var p2 = this.head;
        var ret = "" + p2.data;
        while (p2 = p2.next) {
          ret += s2 + p2.data;
        }
        return ret;
      };
      BufferList2.prototype.concat = function concat(n2) {
        if (this.length === 0) return Buffer2.alloc(0);
        var ret = Buffer2.allocUnsafe(n2 >>> 0);
        var p2 = this.head;
        var i2 = 0;
        while (p2) {
          copyBuffer(p2.data, ret, i2);
          i2 += p2.data.length;
          p2 = p2.next;
        }
        return ret;
      };
      return BufferList2;
    }();
    if (util2 && util2.inspect && util2.inspect.custom) {
      module2.exports.prototype[util2.inspect.custom] = function() {
        var obj = util2.inspect({ length: this.length });
        return this.constructor.name + " " + obj;
      };
    }
  })(BufferList);
  return BufferList.exports;
}
var destroy_1;
var hasRequiredDestroy;
function requireDestroy() {
  if (hasRequiredDestroy) return destroy_1;
  hasRequiredDestroy = 1;
  var pna = requireProcessNextickArgs();
  function destroy(err, cb) {
    var _this = this;
    var readableDestroyed = this._readableState && this._readableState.destroyed;
    var writableDestroyed = this._writableState && this._writableState.destroyed;
    if (readableDestroyed || writableDestroyed) {
      if (cb) {
        cb(err);
      } else if (err) {
        if (!this._writableState) {
          pna.nextTick(emitErrorNT, this, err);
        } else if (!this._writableState.errorEmitted) {
          this._writableState.errorEmitted = true;
          pna.nextTick(emitErrorNT, this, err);
        }
      }
      return this;
    }
    if (this._readableState) {
      this._readableState.destroyed = true;
    }
    if (this._writableState) {
      this._writableState.destroyed = true;
    }
    this._destroy(err || null, function(err2) {
      if (!cb && err2) {
        if (!_this._writableState) {
          pna.nextTick(emitErrorNT, _this, err2);
        } else if (!_this._writableState.errorEmitted) {
          _this._writableState.errorEmitted = true;
          pna.nextTick(emitErrorNT, _this, err2);
        }
      } else if (cb) {
        cb(err2);
      }
    });
    return this;
  }
  function undestroy() {
    if (this._readableState) {
      this._readableState.destroyed = false;
      this._readableState.reading = false;
      this._readableState.ended = false;
      this._readableState.endEmitted = false;
    }
    if (this._writableState) {
      this._writableState.destroyed = false;
      this._writableState.ended = false;
      this._writableState.ending = false;
      this._writableState.finalCalled = false;
      this._writableState.prefinished = false;
      this._writableState.finished = false;
      this._writableState.errorEmitted = false;
    }
  }
  function emitErrorNT(self2, err) {
    self2.emit("error", err);
  }
  destroy_1 = {
    destroy,
    undestroy
  };
  return destroy_1;
}
var browser$f;
var hasRequiredBrowser$d;
function requireBrowser$d() {
  if (hasRequiredBrowser$d) return browser$f;
  hasRequiredBrowser$d = 1;
  browser$f = deprecate;
  function deprecate(fn, msg) {
    if (config("noDeprecation")) {
      return fn;
    }
    var warned = false;
    function deprecated() {
      if (!warned) {
        if (config("throwDeprecation")) {
          throw new Error(msg);
        } else if (config("traceDeprecation")) {
          console.trace(msg);
        } else {
          console.warn(msg);
        }
        warned = true;
      }
      return fn.apply(this, arguments);
    }
    return deprecated;
  }
  function config(name) {
    try {
      if (!commonjsGlobal$1.localStorage) return false;
    } catch (_2) {
      return false;
    }
    var val = commonjsGlobal$1.localStorage[name];
    if (null == val) return false;
    return String(val).toLowerCase() === "true";
  }
  return browser$f;
}
var _stream_writable;
var hasRequired_stream_writable;
function require_stream_writable() {
  if (hasRequired_stream_writable) return _stream_writable;
  hasRequired_stream_writable = 1;
  var pna = requireProcessNextickArgs();
  _stream_writable = Writable;
  function CorkedRequest(state) {
    var _this = this;
    this.next = null;
    this.entry = null;
    this.finish = function() {
      onCorkedFinish(_this, state);
    };
  }
  var asyncWrite = !process.browser && ["v0.10", "v0.9."].indexOf(process.version.slice(0, 5)) > -1 ? setImmediate : pna.nextTick;
  var Duplex;
  Writable.WritableState = WritableState;
  var util2 = Object.create(requireUtil$1());
  util2.inherits = requireInherits_browser();
  var internalUtil = {
    deprecate: requireBrowser$d()
  };
  var Stream2 = requireStreamBrowser();
  var Buffer2 = requireSafeBuffer().Buffer;
  var OurUint8Array = (typeof commonjsGlobal$1 !== "undefined" ? commonjsGlobal$1 : typeof window !== "undefined" ? window : typeof self !== "undefined" ? self : {}).Uint8Array || function() {
  };
  function _uint8ArrayToBuffer(chunk) {
    return Buffer2.from(chunk);
  }
  function _isUint8Array(obj) {
    return Buffer2.isBuffer(obj) || obj instanceof OurUint8Array;
  }
  var destroyImpl = requireDestroy();
  util2.inherits(Writable, Stream2);
  function nop() {
  }
  function WritableState(options2, stream2) {
    Duplex = Duplex || require_stream_duplex();
    options2 = options2 || {};
    var isDuplex = stream2 instanceof Duplex;
    this.objectMode = !!options2.objectMode;
    if (isDuplex) this.objectMode = this.objectMode || !!options2.writableObjectMode;
    var hwm = options2.highWaterMark;
    var writableHwm = options2.writableHighWaterMark;
    var defaultHwm = this.objectMode ? 16 : 16 * 1024;
    if (hwm || hwm === 0) this.highWaterMark = hwm;
    else if (isDuplex && (writableHwm || writableHwm === 0)) this.highWaterMark = writableHwm;
    else this.highWaterMark = defaultHwm;
    this.highWaterMark = Math.floor(this.highWaterMark);
    this.finalCalled = false;
    this.needDrain = false;
    this.ending = false;
    this.ended = false;
    this.finished = false;
    this.destroyed = false;
    var noDecode = options2.decodeStrings === false;
    this.decodeStrings = !noDecode;
    this.defaultEncoding = options2.defaultEncoding || "utf8";
    this.length = 0;
    this.writing = false;
    this.corked = 0;
    this.sync = true;
    this.bufferProcessing = false;
    this.onwrite = function(er) {
      onwrite(stream2, er);
    };
    this.writecb = null;
    this.writelen = 0;
    this.bufferedRequest = null;
    this.lastBufferedRequest = null;
    this.pendingcb = 0;
    this.prefinished = false;
    this.errorEmitted = false;
    this.bufferedRequestCount = 0;
    this.corkedRequestsFree = new CorkedRequest(this);
  }
  WritableState.prototype.getBuffer = function getBuffer() {
    var current = this.bufferedRequest;
    var out = [];
    while (current) {
      out.push(current);
      current = current.next;
    }
    return out;
  };
  (function() {
    try {
      Object.defineProperty(WritableState.prototype, "buffer", {
        get: internalUtil.deprecate(function() {
          return this.getBuffer();
        }, "_writableState.buffer is deprecated. Use _writableState.getBuffer instead.", "DEP0003")
      });
    } catch (_2) {
    }
  })();
  var realHasInstance;
  if (typeof Symbol === "function" && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === "function") {
    realHasInstance = Function.prototype[Symbol.hasInstance];
    Object.defineProperty(Writable, Symbol.hasInstance, {
      value: function(object) {
        if (realHasInstance.call(this, object)) return true;
        if (this !== Writable) return false;
        return object && object._writableState instanceof WritableState;
      }
    });
  } else {
    realHasInstance = function(object) {
      return object instanceof this;
    };
  }
  function Writable(options2) {
    Duplex = Duplex || require_stream_duplex();
    if (!realHasInstance.call(Writable, this) && !(this instanceof Duplex)) {
      return new Writable(options2);
    }
    this._writableState = new WritableState(options2, this);
    this.writable = true;
    if (options2) {
      if (typeof options2.write === "function") this._write = options2.write;
      if (typeof options2.writev === "function") this._writev = options2.writev;
      if (typeof options2.destroy === "function") this._destroy = options2.destroy;
      if (typeof options2.final === "function") this._final = options2.final;
    }
    Stream2.call(this);
  }
  Writable.prototype.pipe = function() {
    this.emit("error", new Error("Cannot pipe, not readable"));
  };
  function writeAfterEnd(stream2, cb) {
    var er = new Error("write after end");
    stream2.emit("error", er);
    pna.nextTick(cb, er);
  }
  function validChunk(stream2, state, chunk, cb) {
    var valid = true;
    var er = false;
    if (chunk === null) {
      er = new TypeError("May not write null values to stream");
    } else if (typeof chunk !== "string" && chunk !== void 0 && !state.objectMode) {
      er = new TypeError("Invalid non-string/buffer chunk");
    }
    if (er) {
      stream2.emit("error", er);
      pna.nextTick(cb, er);
      valid = false;
    }
    return valid;
  }
  Writable.prototype.write = function(chunk, encoding, cb) {
    var state = this._writableState;
    var ret = false;
    var isBuf = !state.objectMode && _isUint8Array(chunk);
    if (isBuf && !Buffer2.isBuffer(chunk)) {
      chunk = _uint8ArrayToBuffer(chunk);
    }
    if (typeof encoding === "function") {
      cb = encoding;
      encoding = null;
    }
    if (isBuf) encoding = "buffer";
    else if (!encoding) encoding = state.defaultEncoding;
    if (typeof cb !== "function") cb = nop;
    if (state.ended) writeAfterEnd(this, cb);
    else if (isBuf || validChunk(this, state, chunk, cb)) {
      state.pendingcb++;
      ret = writeOrBuffer(this, state, isBuf, chunk, encoding, cb);
    }
    return ret;
  };
  Writable.prototype.cork = function() {
    var state = this._writableState;
    state.corked++;
  };
  Writable.prototype.uncork = function() {
    var state = this._writableState;
    if (state.corked) {
      state.corked--;
      if (!state.writing && !state.corked && !state.bufferProcessing && state.bufferedRequest) clearBuffer(this, state);
    }
  };
  Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
    if (typeof encoding === "string") encoding = encoding.toLowerCase();
    if (!(["hex", "utf8", "utf-8", "ascii", "binary", "base64", "ucs2", "ucs-2", "utf16le", "utf-16le", "raw"].indexOf((encoding + "").toLowerCase()) > -1)) throw new TypeError("Unknown encoding: " + encoding);
    this._writableState.defaultEncoding = encoding;
    return this;
  };
  function decodeChunk(state, chunk, encoding) {
    if (!state.objectMode && state.decodeStrings !== false && typeof chunk === "string") {
      chunk = Buffer2.from(chunk, encoding);
    }
    return chunk;
  }
  Object.defineProperty(Writable.prototype, "writableHighWaterMark", {
    // making it explicit this property is not enumerable
    // because otherwise some prototype manipulation in
    // userland will fail
    enumerable: false,
    get: function() {
      return this._writableState.highWaterMark;
    }
  });
  function writeOrBuffer(stream2, state, isBuf, chunk, encoding, cb) {
    if (!isBuf) {
      var newChunk = decodeChunk(state, chunk, encoding);
      if (chunk !== newChunk) {
        isBuf = true;
        encoding = "buffer";
        chunk = newChunk;
      }
    }
    var len = state.objectMode ? 1 : chunk.length;
    state.length += len;
    var ret = state.length < state.highWaterMark;
    if (!ret) state.needDrain = true;
    if (state.writing || state.corked) {
      var last = state.lastBufferedRequest;
      state.lastBufferedRequest = {
        chunk,
        encoding,
        isBuf,
        callback: cb,
        next: null
      };
      if (last) {
        last.next = state.lastBufferedRequest;
      } else {
        state.bufferedRequest = state.lastBufferedRequest;
      }
      state.bufferedRequestCount += 1;
    } else {
      doWrite(stream2, state, false, len, chunk, encoding, cb);
    }
    return ret;
  }
  function doWrite(stream2, state, writev, len, chunk, encoding, cb) {
    state.writelen = len;
    state.writecb = cb;
    state.writing = true;
    state.sync = true;
    if (writev) stream2._writev(chunk, state.onwrite);
    else stream2._write(chunk, encoding, state.onwrite);
    state.sync = false;
  }
  function onwriteError(stream2, state, sync, er, cb) {
    --state.pendingcb;
    if (sync) {
      pna.nextTick(cb, er);
      pna.nextTick(finishMaybe, stream2, state);
      stream2._writableState.errorEmitted = true;
      stream2.emit("error", er);
    } else {
      cb(er);
      stream2._writableState.errorEmitted = true;
      stream2.emit("error", er);
      finishMaybe(stream2, state);
    }
  }
  function onwriteStateUpdate(state) {
    state.writing = false;
    state.writecb = null;
    state.length -= state.writelen;
    state.writelen = 0;
  }
  function onwrite(stream2, er) {
    var state = stream2._writableState;
    var sync = state.sync;
    var cb = state.writecb;
    onwriteStateUpdate(state);
    if (er) onwriteError(stream2, state, sync, er, cb);
    else {
      var finished = needFinish(state);
      if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
        clearBuffer(stream2, state);
      }
      if (sync) {
        asyncWrite(afterWrite, stream2, state, finished, cb);
      } else {
        afterWrite(stream2, state, finished, cb);
      }
    }
  }
  function afterWrite(stream2, state, finished, cb) {
    if (!finished) onwriteDrain(stream2, state);
    state.pendingcb--;
    cb();
    finishMaybe(stream2, state);
  }
  function onwriteDrain(stream2, state) {
    if (state.length === 0 && state.needDrain) {
      state.needDrain = false;
      stream2.emit("drain");
    }
  }
  function clearBuffer(stream2, state) {
    state.bufferProcessing = true;
    var entry = state.bufferedRequest;
    if (stream2._writev && entry && entry.next) {
      var l2 = state.bufferedRequestCount;
      var buffer2 = new Array(l2);
      var holder = state.corkedRequestsFree;
      holder.entry = entry;
      var count = 0;
      var allBuffers = true;
      while (entry) {
        buffer2[count] = entry;
        if (!entry.isBuf) allBuffers = false;
        entry = entry.next;
        count += 1;
      }
      buffer2.allBuffers = allBuffers;
      doWrite(stream2, state, true, state.length, buffer2, "", holder.finish);
      state.pendingcb++;
      state.lastBufferedRequest = null;
      if (holder.next) {
        state.corkedRequestsFree = holder.next;
        holder.next = null;
      } else {
        state.corkedRequestsFree = new CorkedRequest(state);
      }
      state.bufferedRequestCount = 0;
    } else {
      while (entry) {
        var chunk = entry.chunk;
        var encoding = entry.encoding;
        var cb = entry.callback;
        var len = state.objectMode ? 1 : chunk.length;
        doWrite(stream2, state, false, len, chunk, encoding, cb);
        entry = entry.next;
        state.bufferedRequestCount--;
        if (state.writing) {
          break;
        }
      }
      if (entry === null) state.lastBufferedRequest = null;
    }
    state.bufferedRequest = entry;
    state.bufferProcessing = false;
  }
  Writable.prototype._write = function(chunk, encoding, cb) {
    cb(new Error("_write() is not implemented"));
  };
  Writable.prototype._writev = null;
  Writable.prototype.end = function(chunk, encoding, cb) {
    var state = this._writableState;
    if (typeof chunk === "function") {
      cb = chunk;
      chunk = null;
      encoding = null;
    } else if (typeof encoding === "function") {
      cb = encoding;
      encoding = null;
    }
    if (chunk !== null && chunk !== void 0) this.write(chunk, encoding);
    if (state.corked) {
      state.corked = 1;
      this.uncork();
    }
    if (!state.ending) endWritable(this, state, cb);
  };
  function needFinish(state) {
    return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
  }
  function callFinal(stream2, state) {
    stream2._final(function(err) {
      state.pendingcb--;
      if (err) {
        stream2.emit("error", err);
      }
      state.prefinished = true;
      stream2.emit("prefinish");
      finishMaybe(stream2, state);
    });
  }
  function prefinish(stream2, state) {
    if (!state.prefinished && !state.finalCalled) {
      if (typeof stream2._final === "function") {
        state.pendingcb++;
        state.finalCalled = true;
        pna.nextTick(callFinal, stream2, state);
      } else {
        state.prefinished = true;
        stream2.emit("prefinish");
      }
    }
  }
  function finishMaybe(stream2, state) {
    var need = needFinish(state);
    if (need) {
      prefinish(stream2, state);
      if (state.pendingcb === 0) {
        state.finished = true;
        stream2.emit("finish");
      }
    }
    return need;
  }
  function endWritable(stream2, state, cb) {
    state.ending = true;
    finishMaybe(stream2, state);
    if (cb) {
      if (state.finished) pna.nextTick(cb);
      else stream2.once("finish", cb);
    }
    state.ended = true;
    stream2.writable = false;
  }
  function onCorkedFinish(corkReq, state, err) {
    var entry = corkReq.entry;
    corkReq.entry = null;
    while (entry) {
      var cb = entry.callback;
      state.pendingcb--;
      cb(err);
      entry = entry.next;
    }
    state.corkedRequestsFree.next = corkReq;
  }
  Object.defineProperty(Writable.prototype, "destroyed", {
    get: function() {
      if (this._writableState === void 0) {
        return false;
      }
      return this._writableState.destroyed;
    },
    set: function(value) {
      if (!this._writableState) {
        return;
      }
      this._writableState.destroyed = value;
    }
  });
  Writable.prototype.destroy = destroyImpl.destroy;
  Writable.prototype._undestroy = destroyImpl.undestroy;
  Writable.prototype._destroy = function(err, cb) {
    this.end();
    cb(err);
  };
  return _stream_writable;
}
var _stream_duplex;
var hasRequired_stream_duplex;
function require_stream_duplex() {
  if (hasRequired_stream_duplex) return _stream_duplex;
  hasRequired_stream_duplex = 1;
  var pna = requireProcessNextickArgs();
  var objectKeys = Object.keys || function(obj) {
    var keys2 = [];
    for (var key2 in obj) {
      keys2.push(key2);
    }
    return keys2;
  };
  _stream_duplex = Duplex;
  var util2 = Object.create(requireUtil$1());
  util2.inherits = requireInherits_browser();
  var Readable = require_stream_readable();
  var Writable = require_stream_writable();
  util2.inherits(Duplex, Readable);
  {
    var keys = objectKeys(Writable.prototype);
    for (var v2 = 0; v2 < keys.length; v2++) {
      var method = keys[v2];
      if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];
    }
  }
  function Duplex(options2) {
    if (!(this instanceof Duplex)) return new Duplex(options2);
    Readable.call(this, options2);
    Writable.call(this, options2);
    if (options2 && options2.readable === false) this.readable = false;
    if (options2 && options2.writable === false) this.writable = false;
    this.allowHalfOpen = true;
    if (options2 && options2.allowHalfOpen === false) this.allowHalfOpen = false;
    this.once("end", onend);
  }
  Object.defineProperty(Duplex.prototype, "writableHighWaterMark", {
    // making it explicit this property is not enumerable
    // because otherwise some prototype manipulation in
    // userland will fail
    enumerable: false,
    get: function() {
      return this._writableState.highWaterMark;
    }
  });
  function onend() {
    if (this.allowHalfOpen || this._writableState.ended) return;
    pna.nextTick(onEndNT, this);
  }
  function onEndNT(self2) {
    self2.end();
  }
  Object.defineProperty(Duplex.prototype, "destroyed", {
    get: function() {
      if (this._readableState === void 0 || this._writableState === void 0) {
        return false;
      }
      return this._readableState.destroyed && this._writableState.destroyed;
    },
    set: function(value) {
      if (this._readableState === void 0 || this._writableState === void 0) {
        return;
      }
      this._readableState.destroyed = value;
      this._writableState.destroyed = value;
    }
  });
  Duplex.prototype._destroy = function(err, cb) {
    this.push(null);
    this.end();
    pna.nextTick(cb, err);
  };
  return _stream_duplex;
}
var string_decoder$1 = {};
var hasRequiredString_decoder$1;
function requireString_decoder$1() {
  if (hasRequiredString_decoder$1) return string_decoder$1;
  hasRequiredString_decoder$1 = 1;
  var Buffer2 = requireSafeBuffer().Buffer;
  var isEncoding = Buffer2.isEncoding || function(encoding) {
    encoding = "" + encoding;
    switch (encoding && encoding.toLowerCase()) {
      case "hex":
      case "utf8":
      case "utf-8":
      case "ascii":
      case "binary":
      case "base64":
      case "ucs2":
      case "ucs-2":
      case "utf16le":
      case "utf-16le":
      case "raw":
        return true;
      default:
        return false;
    }
  };
  function _normalizeEncoding(enc) {
    if (!enc) return "utf8";
    var retried;
    while (true) {
      switch (enc) {
        case "utf8":
        case "utf-8":
          return "utf8";
        case "ucs2":
        case "ucs-2":
        case "utf16le":
        case "utf-16le":
          return "utf16le";
        case "latin1":
        case "binary":
          return "latin1";
        case "base64":
        case "ascii":
        case "hex":
          return enc;
        default:
          if (retried) return;
          enc = ("" + enc).toLowerCase();
          retried = true;
      }
    }
  }
  function normalizeEncoding(enc) {
    var nenc = _normalizeEncoding(enc);
    if (typeof nenc !== "string" && (Buffer2.isEncoding === isEncoding || !isEncoding(enc))) throw new Error("Unknown encoding: " + enc);
    return nenc || enc;
  }
  string_decoder$1.StringDecoder = StringDecoder;
  function StringDecoder(encoding) {
    this.encoding = normalizeEncoding(encoding);
    var nb;
    switch (this.encoding) {
      case "utf16le":
        this.text = utf16Text;
        this.end = utf16End;
        nb = 4;
        break;
      case "utf8":
        this.fillLast = utf8FillLast;
        nb = 4;
        break;
      case "base64":
        this.text = base64Text;
        this.end = base64End;
        nb = 3;
        break;
      default:
        this.write = simpleWrite;
        this.end = simpleEnd;
        return;
    }
    this.lastNeed = 0;
    this.lastTotal = 0;
    this.lastChar = Buffer2.allocUnsafe(nb);
  }
  StringDecoder.prototype.write = function(buf) {
    if (buf.length === 0) return "";
    var r2;
    var i2;
    if (this.lastNeed) {
      r2 = this.fillLast(buf);
      if (r2 === void 0) return "";
      i2 = this.lastNeed;
      this.lastNeed = 0;
    } else {
      i2 = 0;
    }
    if (i2 < buf.length) return r2 ? r2 + this.text(buf, i2) : this.text(buf, i2);
    return r2 || "";
  };
  StringDecoder.prototype.end = utf8End;
  StringDecoder.prototype.text = utf8Text;
  StringDecoder.prototype.fillLast = function(buf) {
    if (this.lastNeed <= buf.length) {
      buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
      return this.lastChar.toString(this.encoding, 0, this.lastTotal);
    }
    buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
    this.lastNeed -= buf.length;
  };
  function utf8CheckByte(byte) {
    if (byte <= 127) return 0;
    else if (byte >> 5 === 6) return 2;
    else if (byte >> 4 === 14) return 3;
    else if (byte >> 3 === 30) return 4;
    return byte >> 6 === 2 ? -1 : -2;
  }
  function utf8CheckIncomplete(self2, buf, i2) {
    var j = buf.length - 1;
    if (j < i2) return 0;
    var nb = utf8CheckByte(buf[j]);
    if (nb >= 0) {
      if (nb > 0) self2.lastNeed = nb - 1;
      return nb;
    }
    if (--j < i2 || nb === -2) return 0;
    nb = utf8CheckByte(buf[j]);
    if (nb >= 0) {
      if (nb > 0) self2.lastNeed = nb - 2;
      return nb;
    }
    if (--j < i2 || nb === -2) return 0;
    nb = utf8CheckByte(buf[j]);
    if (nb >= 0) {
      if (nb > 0) {
        if (nb === 2) nb = 0;
        else self2.lastNeed = nb - 3;
      }
      return nb;
    }
    return 0;
  }
  function utf8CheckExtraBytes(self2, buf, p2) {
    if ((buf[0] & 192) !== 128) {
      self2.lastNeed = 0;
      return "�";
    }
    if (self2.lastNeed > 1 && buf.length > 1) {
      if ((buf[1] & 192) !== 128) {
        self2.lastNeed = 1;
        return "�";
      }
      if (self2.lastNeed > 2 && buf.length > 2) {
        if ((buf[2] & 192) !== 128) {
          self2.lastNeed = 2;
          return "�";
        }
      }
    }
  }
  function utf8FillLast(buf) {
    var p2 = this.lastTotal - this.lastNeed;
    var r2 = utf8CheckExtraBytes(this, buf);
    if (r2 !== void 0) return r2;
    if (this.lastNeed <= buf.length) {
      buf.copy(this.lastChar, p2, 0, this.lastNeed);
      return this.lastChar.toString(this.encoding, 0, this.lastTotal);
    }
    buf.copy(this.lastChar, p2, 0, buf.length);
    this.lastNeed -= buf.length;
  }
  function utf8Text(buf, i2) {
    var total = utf8CheckIncomplete(this, buf, i2);
    if (!this.lastNeed) return buf.toString("utf8", i2);
    this.lastTotal = total;
    var end = buf.length - (total - this.lastNeed);
    buf.copy(this.lastChar, 0, end);
    return buf.toString("utf8", i2, end);
  }
  function utf8End(buf) {
    var r2 = buf && buf.length ? this.write(buf) : "";
    if (this.lastNeed) return r2 + "�";
    return r2;
  }
  function utf16Text(buf, i2) {
    if ((buf.length - i2) % 2 === 0) {
      var r2 = buf.toString("utf16le", i2);
      if (r2) {
        var c2 = r2.charCodeAt(r2.length - 1);
        if (c2 >= 55296 && c2 <= 56319) {
          this.lastNeed = 2;
          this.lastTotal = 4;
          this.lastChar[0] = buf[buf.length - 2];
          this.lastChar[1] = buf[buf.length - 1];
          return r2.slice(0, -1);
        }
      }
      return r2;
    }
    this.lastNeed = 1;
    this.lastTotal = 2;
    this.lastChar[0] = buf[buf.length - 1];
    return buf.toString("utf16le", i2, buf.length - 1);
  }
  function utf16End(buf) {
    var r2 = buf && buf.length ? this.write(buf) : "";
    if (this.lastNeed) {
      var end = this.lastTotal - this.lastNeed;
      return r2 + this.lastChar.toString("utf16le", 0, end);
    }
    return r2;
  }
  function base64Text(buf, i2) {
    var n2 = (buf.length - i2) % 3;
    if (n2 === 0) return buf.toString("base64", i2);
    this.lastNeed = 3 - n2;
    this.lastTotal = 3;
    if (n2 === 1) {
      this.lastChar[0] = buf[buf.length - 1];
    } else {
      this.lastChar[0] = buf[buf.length - 2];
      this.lastChar[1] = buf[buf.length - 1];
    }
    return buf.toString("base64", i2, buf.length - n2);
  }
  function base64End(buf) {
    var r2 = buf && buf.length ? this.write(buf) : "";
    if (this.lastNeed) return r2 + this.lastChar.toString("base64", 0, 3 - this.lastNeed);
    return r2;
  }
  function simpleWrite(buf) {
    return buf.toString(this.encoding);
  }
  function simpleEnd(buf) {
    return buf && buf.length ? this.write(buf) : "";
  }
  return string_decoder$1;
}
var _stream_readable;
var hasRequired_stream_readable;
function require_stream_readable() {
  if (hasRequired_stream_readable) return _stream_readable;
  hasRequired_stream_readable = 1;
  var pna = requireProcessNextickArgs();
  _stream_readable = Readable;
  var isArray2 = requireIsarray();
  var Duplex;
  Readable.ReadableState = ReadableState;
  requireEvents().EventEmitter;
  var EElistenerCount = function(emitter, type2) {
    return emitter.listeners(type2).length;
  };
  var Stream2 = requireStreamBrowser();
  var Buffer2 = requireSafeBuffer().Buffer;
  var OurUint8Array = (typeof commonjsGlobal$1 !== "undefined" ? commonjsGlobal$1 : typeof window !== "undefined" ? window : typeof self !== "undefined" ? self : {}).Uint8Array || function() {
  };
  function _uint8ArrayToBuffer(chunk) {
    return Buffer2.from(chunk);
  }
  function _isUint8Array(obj) {
    return Buffer2.isBuffer(obj) || obj instanceof OurUint8Array;
  }
  var util2 = Object.create(requireUtil$1());
  util2.inherits = requireInherits_browser();
  var debugUtil = require$$0$2;
  var debug2 = void 0;
  if (debugUtil && debugUtil.debuglog) {
    debug2 = debugUtil.debuglog("stream");
  } else {
    debug2 = function() {
    };
  }
  var BufferList2 = requireBufferList();
  var destroyImpl = requireDestroy();
  var StringDecoder;
  util2.inherits(Readable, Stream2);
  var kProxyEvents = ["error", "close", "destroy", "pause", "resume"];
  function prependListener(emitter, event, fn) {
    if (typeof emitter.prependListener === "function") return emitter.prependListener(event, fn);
    if (!emitter._events || !emitter._events[event]) emitter.on(event, fn);
    else if (isArray2(emitter._events[event])) emitter._events[event].unshift(fn);
    else emitter._events[event] = [fn, emitter._events[event]];
  }
  function ReadableState(options2, stream2) {
    Duplex = Duplex || require_stream_duplex();
    options2 = options2 || {};
    var isDuplex = stream2 instanceof Duplex;
    this.objectMode = !!options2.objectMode;
    if (isDuplex) this.objectMode = this.objectMode || !!options2.readableObjectMode;
    var hwm = options2.highWaterMark;
    var readableHwm = options2.readableHighWaterMark;
    var defaultHwm = this.objectMode ? 16 : 16 * 1024;
    if (hwm || hwm === 0) this.highWaterMark = hwm;
    else if (isDuplex && (readableHwm || readableHwm === 0)) this.highWaterMark = readableHwm;
    else this.highWaterMark = defaultHwm;
    this.highWaterMark = Math.floor(this.highWaterMark);
    this.buffer = new BufferList2();
    this.length = 0;
    this.pipes = null;
    this.pipesCount = 0;
    this.flowing = null;
    this.ended = false;
    this.endEmitted = false;
    this.reading = false;
    this.sync = true;
    this.needReadable = false;
    this.emittedReadable = false;
    this.readableListening = false;
    this.resumeScheduled = false;
    this.destroyed = false;
    this.defaultEncoding = options2.defaultEncoding || "utf8";
    this.awaitDrain = 0;
    this.readingMore = false;
    this.decoder = null;
    this.encoding = null;
    if (options2.encoding) {
      if (!StringDecoder) StringDecoder = requireString_decoder$1().StringDecoder;
      this.decoder = new StringDecoder(options2.encoding);
      this.encoding = options2.encoding;
    }
  }
  function Readable(options2) {
    Duplex = Duplex || require_stream_duplex();
    if (!(this instanceof Readable)) return new Readable(options2);
    this._readableState = new ReadableState(options2, this);
    this.readable = true;
    if (options2) {
      if (typeof options2.read === "function") this._read = options2.read;
      if (typeof options2.destroy === "function") this._destroy = options2.destroy;
    }
    Stream2.call(this);
  }
  Object.defineProperty(Readable.prototype, "destroyed", {
    get: function() {
      if (this._readableState === void 0) {
        return false;
      }
      return this._readableState.destroyed;
    },
    set: function(value) {
      if (!this._readableState) {
        return;
      }
      this._readableState.destroyed = value;
    }
  });
  Readable.prototype.destroy = destroyImpl.destroy;
  Readable.prototype._undestroy = destroyImpl.undestroy;
  Readable.prototype._destroy = function(err, cb) {
    this.push(null);
    cb(err);
  };
  Readable.prototype.push = function(chunk, encoding) {
    var state = this._readableState;
    var skipChunkCheck;
    if (!state.objectMode) {
      if (typeof chunk === "string") {
        encoding = encoding || state.defaultEncoding;
        if (encoding !== state.encoding) {
          chunk = Buffer2.from(chunk, encoding);
          encoding = "";
        }
        skipChunkCheck = true;
      }
    } else {
      skipChunkCheck = true;
    }
    return readableAddChunk(this, chunk, encoding, false, skipChunkCheck);
  };
  Readable.prototype.unshift = function(chunk) {
    return readableAddChunk(this, chunk, null, true, false);
  };
  function readableAddChunk(stream2, chunk, encoding, addToFront, skipChunkCheck) {
    var state = stream2._readableState;
    if (chunk === null) {
      state.reading = false;
      onEofChunk(stream2, state);
    } else {
      var er;
      if (!skipChunkCheck) er = chunkInvalid(state, chunk);
      if (er) {
        stream2.emit("error", er);
      } else if (state.objectMode || chunk && chunk.length > 0) {
        if (typeof chunk !== "string" && !state.objectMode && Object.getPrototypeOf(chunk) !== Buffer2.prototype) {
          chunk = _uint8ArrayToBuffer(chunk);
        }
        if (addToFront) {
          if (state.endEmitted) stream2.emit("error", new Error("stream.unshift() after end event"));
          else addChunk(stream2, state, chunk, true);
        } else if (state.ended) {
          stream2.emit("error", new Error("stream.push() after EOF"));
        } else {
          state.reading = false;
          if (state.decoder && !encoding) {
            chunk = state.decoder.write(chunk);
            if (state.objectMode || chunk.length !== 0) addChunk(stream2, state, chunk, false);
            else maybeReadMore(stream2, state);
          } else {
            addChunk(stream2, state, chunk, false);
          }
        }
      } else if (!addToFront) {
        state.reading = false;
      }
    }
    return needMoreData(state);
  }
  function addChunk(stream2, state, chunk, addToFront) {
    if (state.flowing && state.length === 0 && !state.sync) {
      stream2.emit("data", chunk);
      stream2.read(0);
    } else {
      state.length += state.objectMode ? 1 : chunk.length;
      if (addToFront) state.buffer.unshift(chunk);
      else state.buffer.push(chunk);
      if (state.needReadable) emitReadable(stream2);
    }
    maybeReadMore(stream2, state);
  }
  function chunkInvalid(state, chunk) {
    var er;
    if (!_isUint8Array(chunk) && typeof chunk !== "string" && chunk !== void 0 && !state.objectMode) {
      er = new TypeError("Invalid non-string/buffer chunk");
    }
    return er;
  }
  function needMoreData(state) {
    return !state.ended && (state.needReadable || state.length < state.highWaterMark || state.length === 0);
  }
  Readable.prototype.isPaused = function() {
    return this._readableState.flowing === false;
  };
  Readable.prototype.setEncoding = function(enc) {
    if (!StringDecoder) StringDecoder = requireString_decoder$1().StringDecoder;
    this._readableState.decoder = new StringDecoder(enc);
    this._readableState.encoding = enc;
    return this;
  };
  var MAX_HWM = 8388608;
  function computeNewHighWaterMark(n2) {
    if (n2 >= MAX_HWM) {
      n2 = MAX_HWM;
    } else {
      n2--;
      n2 |= n2 >>> 1;
      n2 |= n2 >>> 2;
      n2 |= n2 >>> 4;
      n2 |= n2 >>> 8;
      n2 |= n2 >>> 16;
      n2++;
    }
    return n2;
  }
  function howMuchToRead(n2, state) {
    if (n2 <= 0 || state.length === 0 && state.ended) return 0;
    if (state.objectMode) return 1;
    if (n2 !== n2) {
      if (state.flowing && state.length) return state.buffer.head.data.length;
      else return state.length;
    }
    if (n2 > state.highWaterMark) state.highWaterMark = computeNewHighWaterMark(n2);
    if (n2 <= state.length) return n2;
    if (!state.ended) {
      state.needReadable = true;
      return 0;
    }
    return state.length;
  }
  Readable.prototype.read = function(n2) {
    debug2("read", n2);
    n2 = parseInt(n2, 10);
    var state = this._readableState;
    var nOrig = n2;
    if (n2 !== 0) state.emittedReadable = false;
    if (n2 === 0 && state.needReadable && (state.length >= state.highWaterMark || state.ended)) {
      debug2("read: emitReadable", state.length, state.ended);
      if (state.length === 0 && state.ended) endReadable(this);
      else emitReadable(this);
      return null;
    }
    n2 = howMuchToRead(n2, state);
    if (n2 === 0 && state.ended) {
      if (state.length === 0) endReadable(this);
      return null;
    }
    var doRead = state.needReadable;
    debug2("need readable", doRead);
    if (state.length === 0 || state.length - n2 < state.highWaterMark) {
      doRead = true;
      debug2("length less than watermark", doRead);
    }
    if (state.ended || state.reading) {
      doRead = false;
      debug2("reading or ended", doRead);
    } else if (doRead) {
      debug2("do read");
      state.reading = true;
      state.sync = true;
      if (state.length === 0) state.needReadable = true;
      this._read(state.highWaterMark);
      state.sync = false;
      if (!state.reading) n2 = howMuchToRead(nOrig, state);
    }
    var ret;
    if (n2 > 0) ret = fromList(n2, state);
    else ret = null;
    if (ret === null) {
      state.needReadable = true;
      n2 = 0;
    } else {
      state.length -= n2;
    }
    if (state.length === 0) {
      if (!state.ended) state.needReadable = true;
      if (nOrig !== n2 && state.ended) endReadable(this);
    }
    if (ret !== null) this.emit("data", ret);
    return ret;
  };
  function onEofChunk(stream2, state) {
    if (state.ended) return;
    if (state.decoder) {
      var chunk = state.decoder.end();
      if (chunk && chunk.length) {
        state.buffer.push(chunk);
        state.length += state.objectMode ? 1 : chunk.length;
      }
    }
    state.ended = true;
    emitReadable(stream2);
  }
  function emitReadable(stream2) {
    var state = stream2._readableState;
    state.needReadable = false;
    if (!state.emittedReadable) {
      debug2("emitReadable", state.flowing);
      state.emittedReadable = true;
      if (state.sync) pna.nextTick(emitReadable_, stream2);
      else emitReadable_(stream2);
    }
  }
  function emitReadable_(stream2) {
    debug2("emit readable");
    stream2.emit("readable");
    flow(stream2);
  }
  function maybeReadMore(stream2, state) {
    if (!state.readingMore) {
      state.readingMore = true;
      pna.nextTick(maybeReadMore_, stream2, state);
    }
  }
  function maybeReadMore_(stream2, state) {
    var len = state.length;
    while (!state.reading && !state.flowing && !state.ended && state.length < state.highWaterMark) {
      debug2("maybeReadMore read 0");
      stream2.read(0);
      if (len === state.length)
        break;
      else len = state.length;
    }
    state.readingMore = false;
  }
  Readable.prototype._read = function(n2) {
    this.emit("error", new Error("_read() is not implemented"));
  };
  Readable.prototype.pipe = function(dest, pipeOpts) {
    var src2 = this;
    var state = this._readableState;
    switch (state.pipesCount) {
      case 0:
        state.pipes = dest;
        break;
      case 1:
        state.pipes = [state.pipes, dest];
        break;
      default:
        state.pipes.push(dest);
        break;
    }
    state.pipesCount += 1;
    debug2("pipe count=%d opts=%j", state.pipesCount, pipeOpts);
    var doEnd = (!pipeOpts || pipeOpts.end !== false) && dest !== process.stdout && dest !== process.stderr;
    var endFn = doEnd ? onend : unpipe;
    if (state.endEmitted) pna.nextTick(endFn);
    else src2.once("end", endFn);
    dest.on("unpipe", onunpipe);
    function onunpipe(readable, unpipeInfo) {
      debug2("onunpipe");
      if (readable === src2) {
        if (unpipeInfo && unpipeInfo.hasUnpiped === false) {
          unpipeInfo.hasUnpiped = true;
          cleanup();
        }
      }
    }
    function onend() {
      debug2("onend");
      dest.end();
    }
    var ondrain = pipeOnDrain(src2);
    dest.on("drain", ondrain);
    var cleanedUp = false;
    function cleanup() {
      debug2("cleanup");
      dest.removeListener("close", onclose);
      dest.removeListener("finish", onfinish);
      dest.removeListener("drain", ondrain);
      dest.removeListener("error", onerror);
      dest.removeListener("unpipe", onunpipe);
      src2.removeListener("end", onend);
      src2.removeListener("end", unpipe);
      src2.removeListener("data", ondata);
      cleanedUp = true;
      if (state.awaitDrain && (!dest._writableState || dest._writableState.needDrain)) ondrain();
    }
    var increasedAwaitDrain = false;
    src2.on("data", ondata);
    function ondata(chunk) {
      debug2("ondata");
      increasedAwaitDrain = false;
      var ret = dest.write(chunk);
      if (false === ret && !increasedAwaitDrain) {
        if ((state.pipesCount === 1 && state.pipes === dest || state.pipesCount > 1 && indexOf(state.pipes, dest) !== -1) && !cleanedUp) {
          debug2("false write response, pause", state.awaitDrain);
          state.awaitDrain++;
          increasedAwaitDrain = true;
        }
        src2.pause();
      }
    }
    function onerror(er) {
      debug2("onerror", er);
      unpipe();
      dest.removeListener("error", onerror);
      if (EElistenerCount(dest, "error") === 0) dest.emit("error", er);
    }
    prependListener(dest, "error", onerror);
    function onclose() {
      dest.removeListener("finish", onfinish);
      unpipe();
    }
    dest.once("close", onclose);
    function onfinish() {
      debug2("onfinish");
      dest.removeListener("close", onclose);
      unpipe();
    }
    dest.once("finish", onfinish);
    function unpipe() {
      debug2("unpipe");
      src2.unpipe(dest);
    }
    dest.emit("pipe", src2);
    if (!state.flowing) {
      debug2("pipe resume");
      src2.resume();
    }
    return dest;
  };
  function pipeOnDrain(src2) {
    return function() {
      var state = src2._readableState;
      debug2("pipeOnDrain", state.awaitDrain);
      if (state.awaitDrain) state.awaitDrain--;
      if (state.awaitDrain === 0 && EElistenerCount(src2, "data")) {
        state.flowing = true;
        flow(src2);
      }
    };
  }
  Readable.prototype.unpipe = function(dest) {
    var state = this._readableState;
    var unpipeInfo = { hasUnpiped: false };
    if (state.pipesCount === 0) return this;
    if (state.pipesCount === 1) {
      if (dest && dest !== state.pipes) return this;
      if (!dest) dest = state.pipes;
      state.pipes = null;
      state.pipesCount = 0;
      state.flowing = false;
      if (dest) dest.emit("unpipe", this, unpipeInfo);
      return this;
    }
    if (!dest) {
      var dests = state.pipes;
      var len = state.pipesCount;
      state.pipes = null;
      state.pipesCount = 0;
      state.flowing = false;
      for (var i2 = 0; i2 < len; i2++) {
        dests[i2].emit("unpipe", this, { hasUnpiped: false });
      }
      return this;
    }
    var index2 = indexOf(state.pipes, dest);
    if (index2 === -1) return this;
    state.pipes.splice(index2, 1);
    state.pipesCount -= 1;
    if (state.pipesCount === 1) state.pipes = state.pipes[0];
    dest.emit("unpipe", this, unpipeInfo);
    return this;
  };
  Readable.prototype.on = function(ev, fn) {
    var res = Stream2.prototype.on.call(this, ev, fn);
    if (ev === "data") {
      if (this._readableState.flowing !== false) this.resume();
    } else if (ev === "readable") {
      var state = this._readableState;
      if (!state.endEmitted && !state.readableListening) {
        state.readableListening = state.needReadable = true;
        state.emittedReadable = false;
        if (!state.reading) {
          pna.nextTick(nReadingNextTick, this);
        } else if (state.length) {
          emitReadable(this);
        }
      }
    }
    return res;
  };
  Readable.prototype.addListener = Readable.prototype.on;
  function nReadingNextTick(self2) {
    debug2("readable nexttick read 0");
    self2.read(0);
  }
  Readable.prototype.resume = function() {
    var state = this._readableState;
    if (!state.flowing) {
      debug2("resume");
      state.flowing = true;
      resume(this, state);
    }
    return this;
  };
  function resume(stream2, state) {
    if (!state.resumeScheduled) {
      state.resumeScheduled = true;
      pna.nextTick(resume_, stream2, state);
    }
  }
  function resume_(stream2, state) {
    if (!state.reading) {
      debug2("resume read 0");
      stream2.read(0);
    }
    state.resumeScheduled = false;
    state.awaitDrain = 0;
    stream2.emit("resume");
    flow(stream2);
    if (state.flowing && !state.reading) stream2.read(0);
  }
  Readable.prototype.pause = function() {
    debug2("call pause flowing=%j", this._readableState.flowing);
    if (false !== this._readableState.flowing) {
      debug2("pause");
      this._readableState.flowing = false;
      this.emit("pause");
    }
    return this;
  };
  function flow(stream2) {
    var state = stream2._readableState;
    debug2("flow", state.flowing);
    while (state.flowing && stream2.read() !== null) {
    }
  }
  Readable.prototype.wrap = function(stream2) {
    var _this = this;
    var state = this._readableState;
    var paused = false;
    stream2.on("end", function() {
      debug2("wrapped end");
      if (state.decoder && !state.ended) {
        var chunk = state.decoder.end();
        if (chunk && chunk.length) _this.push(chunk);
      }
      _this.push(null);
    });
    stream2.on("data", function(chunk) {
      debug2("wrapped data");
      if (state.decoder) chunk = state.decoder.write(chunk);
      if (state.objectMode && (chunk === null || chunk === void 0)) return;
      else if (!state.objectMode && (!chunk || !chunk.length)) return;
      var ret = _this.push(chunk);
      if (!ret) {
        paused = true;
        stream2.pause();
      }
    });
    for (var i2 in stream2) {
      if (this[i2] === void 0 && typeof stream2[i2] === "function") {
        this[i2] = /* @__PURE__ */ function(method) {
          return function() {
            return stream2[method].apply(stream2, arguments);
          };
        }(i2);
      }
    }
    for (var n2 = 0; n2 < kProxyEvents.length; n2++) {
      stream2.on(kProxyEvents[n2], this.emit.bind(this, kProxyEvents[n2]));
    }
    this._read = function(n3) {
      debug2("wrapped _read", n3);
      if (paused) {
        paused = false;
        stream2.resume();
      }
    };
    return this;
  };
  Object.defineProperty(Readable.prototype, "readableHighWaterMark", {
    // making it explicit this property is not enumerable
    // because otherwise some prototype manipulation in
    // userland will fail
    enumerable: false,
    get: function() {
      return this._readableState.highWaterMark;
    }
  });
  Readable._fromList = fromList;
  function fromList(n2, state) {
    if (state.length === 0) return null;
    var ret;
    if (state.objectMode) ret = state.buffer.shift();
    else if (!n2 || n2 >= state.length) {
      if (state.decoder) ret = state.buffer.join("");
      else if (state.buffer.length === 1) ret = state.buffer.head.data;
      else ret = state.buffer.concat(state.length);
      state.buffer.clear();
    } else {
      ret = fromListPartial(n2, state.buffer, state.decoder);
    }
    return ret;
  }
  function fromListPartial(n2, list, hasStrings) {
    var ret;
    if (n2 < list.head.data.length) {
      ret = list.head.data.slice(0, n2);
      list.head.data = list.head.data.slice(n2);
    } else if (n2 === list.head.data.length) {
      ret = list.shift();
    } else {
      ret = hasStrings ? copyFromBufferString(n2, list) : copyFromBuffer(n2, list);
    }
    return ret;
  }
  function copyFromBufferString(n2, list) {
    var p2 = list.head;
    var c2 = 1;
    var ret = p2.data;
    n2 -= ret.length;
    while (p2 = p2.next) {
      var str = p2.data;
      var nb = n2 > str.length ? str.length : n2;
      if (nb === str.length) ret += str;
      else ret += str.slice(0, n2);
      n2 -= nb;
      if (n2 === 0) {
        if (nb === str.length) {
          ++c2;
          if (p2.next) list.head = p2.next;
          else list.head = list.tail = null;
        } else {
          list.head = p2;
          p2.data = str.slice(nb);
        }
        break;
      }
      ++c2;
    }
    list.length -= c2;
    return ret;
  }
  function copyFromBuffer(n2, list) {
    var ret = Buffer2.allocUnsafe(n2);
    var p2 = list.head;
    var c2 = 1;
    p2.data.copy(ret);
    n2 -= p2.data.length;
    while (p2 = p2.next) {
      var buf = p2.data;
      var nb = n2 > buf.length ? buf.length : n2;
      buf.copy(ret, ret.length - n2, 0, nb);
      n2 -= nb;
      if (n2 === 0) {
        if (nb === buf.length) {
          ++c2;
          if (p2.next) list.head = p2.next;
          else list.head = list.tail = null;
        } else {
          list.head = p2;
          p2.data = buf.slice(nb);
        }
        break;
      }
      ++c2;
    }
    list.length -= c2;
    return ret;
  }
  function endReadable(stream2) {
    var state = stream2._readableState;
    if (state.length > 0) throw new Error('"endReadable()" called on non-empty stream');
    if (!state.endEmitted) {
      state.ended = true;
      pna.nextTick(endReadableNT, state, stream2);
    }
  }
  function endReadableNT(state, stream2) {
    if (!state.endEmitted && state.length === 0) {
      state.endEmitted = true;
      stream2.readable = false;
      stream2.emit("end");
    }
  }
  function indexOf(xs, x2) {
    for (var i2 = 0, l2 = xs.length; i2 < l2; i2++) {
      if (xs[i2] === x2) return i2;
    }
    return -1;
  }
  return _stream_readable;
}
var _stream_transform;
var hasRequired_stream_transform;
function require_stream_transform() {
  if (hasRequired_stream_transform) return _stream_transform;
  hasRequired_stream_transform = 1;
  _stream_transform = Transform;
  var Duplex = require_stream_duplex();
  var util2 = Object.create(requireUtil$1());
  util2.inherits = requireInherits_browser();
  util2.inherits(Transform, Duplex);
  function afterTransform(er, data2) {
    var ts = this._transformState;
    ts.transforming = false;
    var cb = ts.writecb;
    if (!cb) {
      return this.emit("error", new Error("write callback called multiple times"));
    }
    ts.writechunk = null;
    ts.writecb = null;
    if (data2 != null)
      this.push(data2);
    cb(er);
    var rs = this._readableState;
    rs.reading = false;
    if (rs.needReadable || rs.length < rs.highWaterMark) {
      this._read(rs.highWaterMark);
    }
  }
  function Transform(options2) {
    if (!(this instanceof Transform)) return new Transform(options2);
    Duplex.call(this, options2);
    this._transformState = {
      afterTransform: afterTransform.bind(this),
      needTransform: false,
      transforming: false,
      writecb: null,
      writechunk: null,
      writeencoding: null
    };
    this._readableState.needReadable = true;
    this._readableState.sync = false;
    if (options2) {
      if (typeof options2.transform === "function") this._transform = options2.transform;
      if (typeof options2.flush === "function") this._flush = options2.flush;
    }
    this.on("prefinish", prefinish);
  }
  function prefinish() {
    var _this = this;
    if (typeof this._flush === "function") {
      this._flush(function(er, data2) {
        done(_this, er, data2);
      });
    } else {
      done(this, null, null);
    }
  }
  Transform.prototype.push = function(chunk, encoding) {
    this._transformState.needTransform = false;
    return Duplex.prototype.push.call(this, chunk, encoding);
  };
  Transform.prototype._transform = function(chunk, encoding, cb) {
    throw new Error("_transform() is not implemented");
  };
  Transform.prototype._write = function(chunk, encoding, cb) {
    var ts = this._transformState;
    ts.writecb = cb;
    ts.writechunk = chunk;
    ts.writeencoding = encoding;
    if (!ts.transforming) {
      var rs = this._readableState;
      if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
    }
  };
  Transform.prototype._read = function(n2) {
    var ts = this._transformState;
    if (ts.writechunk !== null && ts.writecb && !ts.transforming) {
      ts.transforming = true;
      this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
    } else {
      ts.needTransform = true;
    }
  };
  Transform.prototype._destroy = function(err, cb) {
    var _this2 = this;
    Duplex.prototype._destroy.call(this, err, function(err2) {
      cb(err2);
      _this2.emit("close");
    });
  };
  function done(stream2, er, data2) {
    if (er) return stream2.emit("error", er);
    if (data2 != null)
      stream2.push(data2);
    if (stream2._writableState.length) throw new Error("Calling transform done when ws.length != 0");
    if (stream2._transformState.transforming) throw new Error("Calling transform done when still transforming");
    return stream2.push(null);
  }
  return _stream_transform;
}
var _stream_passthrough;
var hasRequired_stream_passthrough;
function require_stream_passthrough() {
  if (hasRequired_stream_passthrough) return _stream_passthrough;
  hasRequired_stream_passthrough = 1;
  _stream_passthrough = PassThrough;
  var Transform = require_stream_transform();
  var util2 = Object.create(requireUtil$1());
  util2.inherits = requireInherits_browser();
  util2.inherits(PassThrough, Transform);
  function PassThrough(options2) {
    if (!(this instanceof PassThrough)) return new PassThrough(options2);
    Transform.call(this, options2);
  }
  PassThrough.prototype._transform = function(chunk, encoding, cb) {
    cb(null, chunk);
  };
  return _stream_passthrough;
}
var hasRequiredReadableBrowser;
function requireReadableBrowser() {
  if (hasRequiredReadableBrowser) return readableBrowser.exports;
  hasRequiredReadableBrowser = 1;
  (function(module2, exports) {
    exports = module2.exports = require_stream_readable();
    exports.Stream = exports;
    exports.Readable = exports;
    exports.Writable = require_stream_writable();
    exports.Duplex = require_stream_duplex();
    exports.Transform = require_stream_transform();
    exports.PassThrough = require_stream_passthrough();
  })(readableBrowser, readableBrowser.exports);
  return readableBrowser.exports;
}
var hashBase;
var hasRequiredHashBase;
function requireHashBase() {
  if (hasRequiredHashBase) return hashBase;
  hasRequiredHashBase = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var toBuffer2 = requireToBuffer$1();
  var Transform = requireReadableBrowser().Transform;
  var inherits = requireInherits_browser();
  function HashBase(blockSize) {
    Transform.call(this);
    this._block = Buffer2.allocUnsafe(blockSize);
    this._blockSize = blockSize;
    this._blockOffset = 0;
    this._length = [0, 0, 0, 0];
    this._finalized = false;
  }
  inherits(HashBase, Transform);
  HashBase.prototype._transform = function(chunk, encoding, callback) {
    var error = null;
    try {
      this.update(chunk, encoding);
    } catch (err) {
      error = err;
    }
    callback(error);
  };
  HashBase.prototype._flush = function(callback) {
    var error = null;
    try {
      this.push(this.digest());
    } catch (err) {
      error = err;
    }
    callback(error);
  };
  HashBase.prototype.update = function(data2, encoding) {
    if (this._finalized) {
      throw new Error("Digest already called");
    }
    var dataBuffer = toBuffer2(data2, encoding);
    var block = this._block;
    var offset = 0;
    while (this._blockOffset + dataBuffer.length - offset >= this._blockSize) {
      for (var i2 = this._blockOffset; i2 < this._blockSize; ) {
        block[i2] = dataBuffer[offset];
        i2 += 1;
        offset += 1;
      }
      this._update();
      this._blockOffset = 0;
    }
    while (offset < dataBuffer.length) {
      block[this._blockOffset] = dataBuffer[offset];
      this._blockOffset += 1;
      offset += 1;
    }
    for (var j = 0, carry = dataBuffer.length * 8; carry > 0; ++j) {
      this._length[j] += carry;
      carry = this._length[j] / 4294967296 | 0;
      if (carry > 0) {
        this._length[j] -= 4294967296 * carry;
      }
    }
    return this;
  };
  HashBase.prototype._update = function() {
    throw new Error("_update is not implemented");
  };
  HashBase.prototype.digest = function(encoding) {
    if (this._finalized) {
      throw new Error("Digest already called");
    }
    this._finalized = true;
    var digest = this._digest();
    if (encoding !== void 0) {
      digest = digest.toString(encoding);
    }
    this._block.fill(0);
    this._blockOffset = 0;
    for (var i2 = 0; i2 < 4; ++i2) {
      this._length[i2] = 0;
    }
    return digest;
  };
  HashBase.prototype._digest = function() {
    throw new Error("_digest is not implemented");
  };
  hashBase = HashBase;
  return hashBase;
}
var ripemd160$2;
var hasRequiredRipemd160$1;
function requireRipemd160$1() {
  if (hasRequiredRipemd160$1) return ripemd160$2;
  hasRequiredRipemd160$1 = 1;
  var Buffer2 = requireBuffer$1().Buffer;
  var inherits = requireInherits_browser();
  var HashBase = requireHashBase();
  var ARRAY16 = new Array(16);
  var zl = [
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    7,
    4,
    13,
    1,
    10,
    6,
    15,
    3,
    12,
    0,
    9,
    5,
    2,
    14,
    11,
    8,
    3,
    10,
    14,
    4,
    9,
    15,
    8,
    1,
    2,
    7,
    0,
    6,
    13,
    11,
    5,
    12,
    1,
    9,
    11,
    10,
    0,
    8,
    12,
    4,
    13,
    3,
    7,
    15,
    14,
    5,
    6,
    2,
    4,
    0,
    5,
    9,
    7,
    12,
    2,
    10,
    14,
    1,
    3,
    8,
    11,
    6,
    15,
    13
  ];
  var zr = [
    5,
    14,
    7,
    0,
    9,
    2,
    11,
    4,
    13,
    6,
    15,
    8,
    1,
    10,
    3,
    12,
    6,
    11,
    3,
    7,
    0,
    13,
    5,
    10,
    14,
    15,
    8,
    12,
    4,
    9,
    1,
    2,
    15,
    5,
    1,
    3,
    7,
    14,
    6,
    9,
    11,
    8,
    12,
    2,
    10,
    0,
    4,
    13,
    8,
    6,
    4,
    1,
    3,
    11,
    15,
    0,
    5,
    12,
    2,
    13,
    9,
    7,
    10,
    14,
    12,
    15,
    10,
    4,
    1,
    5,
    8,
    7,
    6,
    2,
    13,
    14,
    0,
    3,
    9,
    11
  ];
  var sl = [
    11,
    14,
    15,
    12,
    5,
    8,
    7,
    9,
    11,
    13,
    14,
    15,
    6,
    7,
    9,
    8,
    7,
    6,
    8,
    13,
    11,
    9,
    7,
    15,
    7,
    12,
    15,
    9,
    11,
    7,
    13,
    12,
    11,
    13,
    6,
    7,
    14,
    9,
    13,
    15,
    14,
    8,
    13,
    6,
    5,
    12,
    7,
    5,
    11,
    12,
    14,
    15,
    14,
    15,
    9,
    8,
    9,
    14,
    5,
    6,
    8,
    6,
    5,
    12,
    9,
    15,
    5,
    11,
    6,
    8,
    13,
    12,
    5,
    12,
    13,
    14,
    11,
    8,
    5,
    6
  ];
  var sr = [
    8,
    9,
    9,
    11,
    13,
    15,
    15,
    5,
    7,
    7,
    8,
    11,
    14,
    14,
    12,
    6,
    9,
    13,
    15,
    7,
    12,
    8,
    9,
    11,
    7,
    7,
    12,
    7,
    6,
    15,
    13,
    11,
    9,
    7,
    15,
    11,
    8,
    6,
    6,
    14,
    12,
    13,
    5,
    14,
    13,
    13,
    7,
    5,
    15,
    5,
    8,
    11,
    14,
    14,
    6,
    14,
    6,
    9,
    12,
    9,
    12,
    5,
    15,
    8,
    8,
    5,
    12,
    9,
    12,
    5,
    14,
    6,
    8,
    13,
    6,
    5,
    15,
    13,
    11,
    11
  ];
  var hl = [0, 1518500249, 1859775393, 2400959708, 2840853838];
  var hr = [1352829926, 1548603684, 1836072691, 2053994217, 0];
  function rotl2(x2, n2) {
    return x2 << n2 | x2 >>> 32 - n2;
  }
  function fn1(a2, b2, c2, d, e4, m, k2, s2) {
    return rotl2(a2 + (b2 ^ c2 ^ d) + m + k2 | 0, s2) + e4 | 0;
  }
  function fn2(a2, b2, c2, d, e4, m, k2, s2) {
    return rotl2(a2 + (b2 & c2 | ~b2 & d) + m + k2 | 0, s2) + e4 | 0;
  }
  function fn3(a2, b2, c2, d, e4, m, k2, s2) {
    return rotl2(a2 + ((b2 | ~c2) ^ d) + m + k2 | 0, s2) + e4 | 0;
  }
  function fn4(a2, b2, c2, d, e4, m, k2, s2) {
    return rotl2(a2 + (b2 & d | c2 & ~d) + m + k2 | 0, s2) + e4 | 0;
  }
  function fn5(a2, b2, c2, d, e4, m, k2, s2) {
    return rotl2(a2 + (b2 ^ (c2 | ~d)) + m + k2 | 0, s2) + e4 | 0;
  }
  function RIPEMD160() {
    HashBase.call(this, 64);
    this._a = 1732584193;
    this._b = 4023233417;
    this._c = 2562383102;
    this._d = 271733878;
    this._e = 3285377520;
  }
  inherits(RIPEMD160, HashBase);
  RIPEMD160.prototype._update = function() {
    var words = ARRAY16;
    for (var j = 0; j < 16; ++j) {
      words[j] = this._block.readInt32LE(j * 4);
    }
    var al = this._a | 0;
    var bl = this._b | 0;
    var cl = this._c | 0;
    var dl = this._d | 0;
    var el = this._e | 0;
    var ar = this._a | 0;
    var br = this._b | 0;
    var cr = this._c | 0;
    var dr = this._d | 0;
    var er = this._e | 0;
    for (var i2 = 0; i2 < 80; i2 += 1) {
      var tl;
      var tr;
      if (i2 < 16) {
        tl = fn1(al, bl, cl, dl, el, words[zl[i2]], hl[0], sl[i2]);
        tr = fn5(ar, br, cr, dr, er, words[zr[i2]], hr[0], sr[i2]);
      } else if (i2 < 32) {
        tl = fn2(al, bl, cl, dl, el, words[zl[i2]], hl[1], sl[i2]);
        tr = fn4(ar, br, cr, dr, er, words[zr[i2]], hr[1], sr[i2]);
      } else if (i2 < 48) {
        tl = fn3(al, bl, cl, dl, el, words[zl[i2]], hl[2], sl[i2]);
        tr = fn3(ar, br, cr, dr, er, words[zr[i2]], hr[2], sr[i2]);
      } else if (i2 < 64) {
        tl = fn4(al, bl, cl, dl, el, words[zl[i2]], hl[3], sl[i2]);
        tr = fn2(ar, br, cr, dr, er, words[zr[i2]], hr[3], sr[i2]);
      } else {
        tl = fn5(al, bl, cl, dl, el, words[zl[i2]], hl[4], sl[i2]);
        tr = fn1(ar, br, cr, dr, er, words[zr[i2]], hr[4], sr[i2]);
      }
      al = el;
      el = dl;
      dl = rotl2(cl, 10);
      cl = bl;
      bl = tl;
      ar = er;
      er = dr;
      dr = rotl2(cr, 10);
      cr = br;
      br = tr;
    }
    var t2 = this._b + cl + dr | 0;
    this._b = this._c + dl + er | 0;
    this._c = this._d + el + ar | 0;
    this._d = this._e + al + br | 0;
    this._e = this._a + bl + cr | 0;
    this._a = t2;
  };
  RIPEMD160.prototype._digest = function() {
    this._block[this._blockOffset] = 128;
    this._blockOffset += 1;
    if (this._blockOffset > 56) {
      this._block.fill(0, this._blockOffset, 64);
      this._update();
      this._blockOffset = 0;
    }
    this._block.fill(0, this._blockOffset, 56);
    this._block.writeUInt32LE(this._length[0], 56);
    this._block.writeUInt32LE(this._length[1], 60);
    this._update();
    var buffer2 = Buffer2.alloc ? Buffer2.alloc(20) : new Buffer2(20);
    buffer2.writeInt32LE(this._a, 0);
    buffer2.writeInt32LE(this._b, 4);
    buffer2.writeInt32LE(this._c, 8);
    buffer2.writeInt32LE(this._d, 12);
    buffer2.writeInt32LE(this._e, 16);
    return buffer2;
  };
  ripemd160$2 = RIPEMD160;
  return ripemd160$2;
}
var sha_js = { exports: {} };
var hash$1;
var hasRequiredHash$1;
function requireHash$1() {
  if (hasRequiredHash$1) return hash$1;
  hasRequiredHash$1 = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var toBuffer2 = /* @__PURE__ */ requireToBuffer$2();
  function Hash(blockSize, finalSize) {
    this._block = Buffer2.alloc(blockSize);
    this._finalSize = finalSize;
    this._blockSize = blockSize;
    this._len = 0;
  }
  Hash.prototype.update = function(data2, enc) {
    data2 = toBuffer2(data2, enc || "utf8");
    var block = this._block;
    var blockSize = this._blockSize;
    var length = data2.length;
    var accum = this._len;
    for (var offset = 0; offset < length; ) {
      var assigned = accum % blockSize;
      var remainder = Math.min(length - offset, blockSize - assigned);
      for (var i2 = 0; i2 < remainder; i2++) {
        block[assigned + i2] = data2[offset + i2];
      }
      accum += remainder;
      offset += remainder;
      if (accum % blockSize === 0) {
        this._update(block);
      }
    }
    this._len += length;
    return this;
  };
  Hash.prototype.digest = function(enc) {
    var rem = this._len % this._blockSize;
    this._block[rem] = 128;
    this._block.fill(0, rem + 1);
    if (rem >= this._finalSize) {
      this._update(this._block);
      this._block.fill(0);
    }
    var bits = this._len * 8;
    if (bits <= 4294967295) {
      this._block.writeUInt32BE(bits, this._blockSize - 4);
    } else {
      var lowBits = (bits & 4294967295) >>> 0;
      var highBits = (bits - lowBits) / 4294967296;
      this._block.writeUInt32BE(highBits, this._blockSize - 8);
      this._block.writeUInt32BE(lowBits, this._blockSize - 4);
    }
    this._update(this._block);
    var hash2 = this._hash();
    return enc ? hash2.toString(enc) : hash2;
  };
  Hash.prototype._update = function() {
    throw new Error("_update must be implemented by subclass");
  };
  hash$1 = Hash;
  return hash$1;
}
var sha$1;
var hasRequiredSha$1;
function requireSha$1() {
  if (hasRequiredSha$1) return sha$1;
  hasRequiredSha$1 = 1;
  var inherits = requireInherits_browser();
  var Hash = requireHash$1();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var K = [
    1518500249,
    1859775393,
    2400959708 | 0,
    3395469782 | 0
  ];
  var W = new Array(80);
  function Sha() {
    this.init();
    this._w = W;
    Hash.call(this, 64, 56);
  }
  inherits(Sha, Hash);
  Sha.prototype.init = function() {
    this._a = 1732584193;
    this._b = 4023233417;
    this._c = 2562383102;
    this._d = 271733878;
    this._e = 3285377520;
    return this;
  };
  function rotl5(num) {
    return num << 5 | num >>> 27;
  }
  function rotl30(num) {
    return num << 30 | num >>> 2;
  }
  function ft(s2, b2, c2, d) {
    if (s2 === 0) {
      return b2 & c2 | ~b2 & d;
    }
    if (s2 === 2) {
      return b2 & c2 | b2 & d | c2 & d;
    }
    return b2 ^ c2 ^ d;
  }
  Sha.prototype._update = function(M2) {
    var w = this._w;
    var a2 = this._a | 0;
    var b2 = this._b | 0;
    var c2 = this._c | 0;
    var d = this._d | 0;
    var e4 = this._e | 0;
    for (var i2 = 0; i2 < 16; ++i2) {
      w[i2] = M2.readInt32BE(i2 * 4);
    }
    for (; i2 < 80; ++i2) {
      w[i2] = w[i2 - 3] ^ w[i2 - 8] ^ w[i2 - 14] ^ w[i2 - 16];
    }
    for (var j = 0; j < 80; ++j) {
      var s2 = ~~(j / 20);
      var t2 = rotl5(a2) + ft(s2, b2, c2, d) + e4 + w[j] + K[s2] | 0;
      e4 = d;
      d = c2;
      c2 = rotl30(b2);
      b2 = a2;
      a2 = t2;
    }
    this._a = a2 + this._a | 0;
    this._b = b2 + this._b | 0;
    this._c = c2 + this._c | 0;
    this._d = d + this._d | 0;
    this._e = e4 + this._e | 0;
  };
  Sha.prototype._hash = function() {
    var H = Buffer2.allocUnsafe(20);
    H.writeInt32BE(this._a | 0, 0);
    H.writeInt32BE(this._b | 0, 4);
    H.writeInt32BE(this._c | 0, 8);
    H.writeInt32BE(this._d | 0, 12);
    H.writeInt32BE(this._e | 0, 16);
    return H;
  };
  sha$1 = Sha;
  return sha$1;
}
var sha1$2;
var hasRequiredSha1$1;
function requireSha1$1() {
  if (hasRequiredSha1$1) return sha1$2;
  hasRequiredSha1$1 = 1;
  var inherits = requireInherits_browser();
  var Hash = requireHash$1();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var K = [
    1518500249,
    1859775393,
    2400959708 | 0,
    3395469782 | 0
  ];
  var W = new Array(80);
  function Sha1() {
    this.init();
    this._w = W;
    Hash.call(this, 64, 56);
  }
  inherits(Sha1, Hash);
  Sha1.prototype.init = function() {
    this._a = 1732584193;
    this._b = 4023233417;
    this._c = 2562383102;
    this._d = 271733878;
    this._e = 3285377520;
    return this;
  };
  function rotl1(num) {
    return num << 1 | num >>> 31;
  }
  function rotl5(num) {
    return num << 5 | num >>> 27;
  }
  function rotl30(num) {
    return num << 30 | num >>> 2;
  }
  function ft(s2, b2, c2, d) {
    if (s2 === 0) {
      return b2 & c2 | ~b2 & d;
    }
    if (s2 === 2) {
      return b2 & c2 | b2 & d | c2 & d;
    }
    return b2 ^ c2 ^ d;
  }
  Sha1.prototype._update = function(M2) {
    var w = this._w;
    var a2 = this._a | 0;
    var b2 = this._b | 0;
    var c2 = this._c | 0;
    var d = this._d | 0;
    var e4 = this._e | 0;
    for (var i2 = 0; i2 < 16; ++i2) {
      w[i2] = M2.readInt32BE(i2 * 4);
    }
    for (; i2 < 80; ++i2) {
      w[i2] = rotl1(w[i2 - 3] ^ w[i2 - 8] ^ w[i2 - 14] ^ w[i2 - 16]);
    }
    for (var j = 0; j < 80; ++j) {
      var s2 = ~~(j / 20);
      var t2 = rotl5(a2) + ft(s2, b2, c2, d) + e4 + w[j] + K[s2] | 0;
      e4 = d;
      d = c2;
      c2 = rotl30(b2);
      b2 = a2;
      a2 = t2;
    }
    this._a = a2 + this._a | 0;
    this._b = b2 + this._b | 0;
    this._c = c2 + this._c | 0;
    this._d = d + this._d | 0;
    this._e = e4 + this._e | 0;
  };
  Sha1.prototype._hash = function() {
    var H = Buffer2.allocUnsafe(20);
    H.writeInt32BE(this._a | 0, 0);
    H.writeInt32BE(this._b | 0, 4);
    H.writeInt32BE(this._c | 0, 8);
    H.writeInt32BE(this._d | 0, 12);
    H.writeInt32BE(this._e | 0, 16);
    return H;
  };
  sha1$2 = Sha1;
  return sha1$2;
}
var sha256$4;
var hasRequiredSha256$1;
function requireSha256$1() {
  if (hasRequiredSha256$1) return sha256$4;
  hasRequiredSha256$1 = 1;
  var inherits = requireInherits_browser();
  var Hash = requireHash$1();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var K = [
    1116352408,
    1899447441,
    3049323471,
    3921009573,
    961987163,
    1508970993,
    2453635748,
    2870763221,
    3624381080,
    310598401,
    607225278,
    1426881987,
    1925078388,
    2162078206,
    2614888103,
    3248222580,
    3835390401,
    4022224774,
    264347078,
    604807628,
    770255983,
    1249150122,
    1555081692,
    1996064986,
    2554220882,
    2821834349,
    2952996808,
    3210313671,
    3336571891,
    3584528711,
    113926993,
    338241895,
    666307205,
    773529912,
    1294757372,
    1396182291,
    1695183700,
    1986661051,
    2177026350,
    2456956037,
    2730485921,
    2820302411,
    3259730800,
    3345764771,
    3516065817,
    3600352804,
    4094571909,
    275423344,
    430227734,
    506948616,
    659060556,
    883997877,
    958139571,
    1322822218,
    1537002063,
    1747873779,
    1955562222,
    2024104815,
    2227730452,
    2361852424,
    2428436474,
    2756734187,
    3204031479,
    3329325298
  ];
  var W = new Array(64);
  function Sha256() {
    this.init();
    this._w = W;
    Hash.call(this, 64, 56);
  }
  inherits(Sha256, Hash);
  Sha256.prototype.init = function() {
    this._a = 1779033703;
    this._b = 3144134277;
    this._c = 1013904242;
    this._d = 2773480762;
    this._e = 1359893119;
    this._f = 2600822924;
    this._g = 528734635;
    this._h = 1541459225;
    return this;
  };
  function ch(x2, y2, z2) {
    return z2 ^ x2 & (y2 ^ z2);
  }
  function maj(x2, y2, z2) {
    return x2 & y2 | z2 & (x2 | y2);
  }
  function sigma0(x2) {
    return (x2 >>> 2 | x2 << 30) ^ (x2 >>> 13 | x2 << 19) ^ (x2 >>> 22 | x2 << 10);
  }
  function sigma1(x2) {
    return (x2 >>> 6 | x2 << 26) ^ (x2 >>> 11 | x2 << 21) ^ (x2 >>> 25 | x2 << 7);
  }
  function gamma0(x2) {
    return (x2 >>> 7 | x2 << 25) ^ (x2 >>> 18 | x2 << 14) ^ x2 >>> 3;
  }
  function gamma1(x2) {
    return (x2 >>> 17 | x2 << 15) ^ (x2 >>> 19 | x2 << 13) ^ x2 >>> 10;
  }
  Sha256.prototype._update = function(M2) {
    var w = this._w;
    var a2 = this._a | 0;
    var b2 = this._b | 0;
    var c2 = this._c | 0;
    var d = this._d | 0;
    var e4 = this._e | 0;
    var f2 = this._f | 0;
    var g = this._g | 0;
    var h2 = this._h | 0;
    for (var i2 = 0; i2 < 16; ++i2) {
      w[i2] = M2.readInt32BE(i2 * 4);
    }
    for (; i2 < 64; ++i2) {
      w[i2] = gamma1(w[i2 - 2]) + w[i2 - 7] + gamma0(w[i2 - 15]) + w[i2 - 16] | 0;
    }
    for (var j = 0; j < 64; ++j) {
      var T1 = h2 + sigma1(e4) + ch(e4, f2, g) + K[j] + w[j] | 0;
      var T2 = sigma0(a2) + maj(a2, b2, c2) | 0;
      h2 = g;
      g = f2;
      f2 = e4;
      e4 = d + T1 | 0;
      d = c2;
      c2 = b2;
      b2 = a2;
      a2 = T1 + T2 | 0;
    }
    this._a = a2 + this._a | 0;
    this._b = b2 + this._b | 0;
    this._c = c2 + this._c | 0;
    this._d = d + this._d | 0;
    this._e = e4 + this._e | 0;
    this._f = f2 + this._f | 0;
    this._g = g + this._g | 0;
    this._h = h2 + this._h | 0;
  };
  Sha256.prototype._hash = function() {
    var H = Buffer2.allocUnsafe(32);
    H.writeInt32BE(this._a, 0);
    H.writeInt32BE(this._b, 4);
    H.writeInt32BE(this._c, 8);
    H.writeInt32BE(this._d, 12);
    H.writeInt32BE(this._e, 16);
    H.writeInt32BE(this._f, 20);
    H.writeInt32BE(this._g, 24);
    H.writeInt32BE(this._h, 28);
    return H;
  };
  sha256$4 = Sha256;
  return sha256$4;
}
var sha224$3;
var hasRequiredSha224$1;
function requireSha224$1() {
  if (hasRequiredSha224$1) return sha224$3;
  hasRequiredSha224$1 = 1;
  var inherits = requireInherits_browser();
  var Sha256 = requireSha256$1();
  var Hash = requireHash$1();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var W = new Array(64);
  function Sha224() {
    this.init();
    this._w = W;
    Hash.call(this, 64, 56);
  }
  inherits(Sha224, Sha256);
  Sha224.prototype.init = function() {
    this._a = 3238371032;
    this._b = 914150663;
    this._c = 812702999;
    this._d = 4144912697;
    this._e = 4290775857;
    this._f = 1750603025;
    this._g = 1694076839;
    this._h = 3204075428;
    return this;
  };
  Sha224.prototype._hash = function() {
    var H = Buffer2.allocUnsafe(28);
    H.writeInt32BE(this._a, 0);
    H.writeInt32BE(this._b, 4);
    H.writeInt32BE(this._c, 8);
    H.writeInt32BE(this._d, 12);
    H.writeInt32BE(this._e, 16);
    H.writeInt32BE(this._f, 20);
    H.writeInt32BE(this._g, 24);
    return H;
  };
  sha224$3 = Sha224;
  return sha224$3;
}
var sha512$3;
var hasRequiredSha512$1;
function requireSha512$1() {
  if (hasRequiredSha512$1) return sha512$3;
  hasRequiredSha512$1 = 1;
  var inherits = requireInherits_browser();
  var Hash = requireHash$1();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var K = [
    1116352408,
    3609767458,
    1899447441,
    602891725,
    3049323471,
    3964484399,
    3921009573,
    2173295548,
    961987163,
    4081628472,
    1508970993,
    3053834265,
    2453635748,
    2937671579,
    2870763221,
    3664609560,
    3624381080,
    2734883394,
    310598401,
    1164996542,
    607225278,
    1323610764,
    1426881987,
    3590304994,
    1925078388,
    4068182383,
    2162078206,
    991336113,
    2614888103,
    633803317,
    3248222580,
    3479774868,
    3835390401,
    2666613458,
    4022224774,
    944711139,
    264347078,
    2341262773,
    604807628,
    2007800933,
    770255983,
    1495990901,
    1249150122,
    1856431235,
    1555081692,
    3175218132,
    1996064986,
    2198950837,
    2554220882,
    3999719339,
    2821834349,
    766784016,
    2952996808,
    2566594879,
    3210313671,
    3203337956,
    3336571891,
    1034457026,
    3584528711,
    2466948901,
    113926993,
    3758326383,
    338241895,
    168717936,
    666307205,
    1188179964,
    773529912,
    1546045734,
    1294757372,
    1522805485,
    1396182291,
    2643833823,
    1695183700,
    2343527390,
    1986661051,
    1014477480,
    2177026350,
    1206759142,
    2456956037,
    344077627,
    2730485921,
    1290863460,
    2820302411,
    3158454273,
    3259730800,
    3505952657,
    3345764771,
    106217008,
    3516065817,
    3606008344,
    3600352804,
    1432725776,
    4094571909,
    1467031594,
    275423344,
    851169720,
    430227734,
    3100823752,
    506948616,
    1363258195,
    659060556,
    3750685593,
    883997877,
    3785050280,
    958139571,
    3318307427,
    1322822218,
    3812723403,
    1537002063,
    2003034995,
    1747873779,
    3602036899,
    1955562222,
    1575990012,
    2024104815,
    1125592928,
    2227730452,
    2716904306,
    2361852424,
    442776044,
    2428436474,
    593698344,
    2756734187,
    3733110249,
    3204031479,
    2999351573,
    3329325298,
    3815920427,
    3391569614,
    3928383900,
    3515267271,
    566280711,
    3940187606,
    3454069534,
    4118630271,
    4000239992,
    116418474,
    1914138554,
    174292421,
    2731055270,
    289380356,
    3203993006,
    460393269,
    320620315,
    685471733,
    587496836,
    852142971,
    1086792851,
    1017036298,
    365543100,
    1126000580,
    2618297676,
    1288033470,
    3409855158,
    1501505948,
    4234509866,
    1607167915,
    987167468,
    1816402316,
    1246189591
  ];
  var W = new Array(160);
  function Sha512() {
    this.init();
    this._w = W;
    Hash.call(this, 128, 112);
  }
  inherits(Sha512, Hash);
  Sha512.prototype.init = function() {
    this._ah = 1779033703;
    this._bh = 3144134277;
    this._ch = 1013904242;
    this._dh = 2773480762;
    this._eh = 1359893119;
    this._fh = 2600822924;
    this._gh = 528734635;
    this._hh = 1541459225;
    this._al = 4089235720;
    this._bl = 2227873595;
    this._cl = 4271175723;
    this._dl = 1595750129;
    this._el = 2917565137;
    this._fl = 725511199;
    this._gl = 4215389547;
    this._hl = 327033209;
    return this;
  };
  function Ch(x2, y2, z2) {
    return z2 ^ x2 & (y2 ^ z2);
  }
  function maj(x2, y2, z2) {
    return x2 & y2 | z2 & (x2 | y2);
  }
  function sigma0(x2, xl) {
    return (x2 >>> 28 | xl << 4) ^ (xl >>> 2 | x2 << 30) ^ (xl >>> 7 | x2 << 25);
  }
  function sigma1(x2, xl) {
    return (x2 >>> 14 | xl << 18) ^ (x2 >>> 18 | xl << 14) ^ (xl >>> 9 | x2 << 23);
  }
  function Gamma0(x2, xl) {
    return (x2 >>> 1 | xl << 31) ^ (x2 >>> 8 | xl << 24) ^ x2 >>> 7;
  }
  function Gamma0l(x2, xl) {
    return (x2 >>> 1 | xl << 31) ^ (x2 >>> 8 | xl << 24) ^ (x2 >>> 7 | xl << 25);
  }
  function Gamma1(x2, xl) {
    return (x2 >>> 19 | xl << 13) ^ (xl >>> 29 | x2 << 3) ^ x2 >>> 6;
  }
  function Gamma1l(x2, xl) {
    return (x2 >>> 19 | xl << 13) ^ (xl >>> 29 | x2 << 3) ^ (x2 >>> 6 | xl << 26);
  }
  function getCarry(a2, b2) {
    return a2 >>> 0 < b2 >>> 0 ? 1 : 0;
  }
  Sha512.prototype._update = function(M2) {
    var w = this._w;
    var ah = this._ah | 0;
    var bh = this._bh | 0;
    var ch = this._ch | 0;
    var dh2 = this._dh | 0;
    var eh = this._eh | 0;
    var fh = this._fh | 0;
    var gh = this._gh | 0;
    var hh = this._hh | 0;
    var al = this._al | 0;
    var bl = this._bl | 0;
    var cl = this._cl | 0;
    var dl = this._dl | 0;
    var el = this._el | 0;
    var fl = this._fl | 0;
    var gl = this._gl | 0;
    var hl = this._hl | 0;
    for (var i2 = 0; i2 < 32; i2 += 2) {
      w[i2] = M2.readInt32BE(i2 * 4);
      w[i2 + 1] = M2.readInt32BE(i2 * 4 + 4);
    }
    for (; i2 < 160; i2 += 2) {
      var xh = w[i2 - 15 * 2];
      var xl = w[i2 - 15 * 2 + 1];
      var gamma0 = Gamma0(xh, xl);
      var gamma0l = Gamma0l(xl, xh);
      xh = w[i2 - 2 * 2];
      xl = w[i2 - 2 * 2 + 1];
      var gamma1 = Gamma1(xh, xl);
      var gamma1l = Gamma1l(xl, xh);
      var Wi7h = w[i2 - 7 * 2];
      var Wi7l = w[i2 - 7 * 2 + 1];
      var Wi16h = w[i2 - 16 * 2];
      var Wi16l = w[i2 - 16 * 2 + 1];
      var Wil = gamma0l + Wi7l | 0;
      var Wih = gamma0 + Wi7h + getCarry(Wil, gamma0l) | 0;
      Wil = Wil + gamma1l | 0;
      Wih = Wih + gamma1 + getCarry(Wil, gamma1l) | 0;
      Wil = Wil + Wi16l | 0;
      Wih = Wih + Wi16h + getCarry(Wil, Wi16l) | 0;
      w[i2] = Wih;
      w[i2 + 1] = Wil;
    }
    for (var j = 0; j < 160; j += 2) {
      Wih = w[j];
      Wil = w[j + 1];
      var majh = maj(ah, bh, ch);
      var majl = maj(al, bl, cl);
      var sigma0h = sigma0(ah, al);
      var sigma0l = sigma0(al, ah);
      var sigma1h = sigma1(eh, el);
      var sigma1l = sigma1(el, eh);
      var Kih = K[j];
      var Kil = K[j + 1];
      var chh = Ch(eh, fh, gh);
      var chl = Ch(el, fl, gl);
      var t1l = hl + sigma1l | 0;
      var t1h = hh + sigma1h + getCarry(t1l, hl) | 0;
      t1l = t1l + chl | 0;
      t1h = t1h + chh + getCarry(t1l, chl) | 0;
      t1l = t1l + Kil | 0;
      t1h = t1h + Kih + getCarry(t1l, Kil) | 0;
      t1l = t1l + Wil | 0;
      t1h = t1h + Wih + getCarry(t1l, Wil) | 0;
      var t2l = sigma0l + majl | 0;
      var t2h = sigma0h + majh + getCarry(t2l, sigma0l) | 0;
      hh = gh;
      hl = gl;
      gh = fh;
      gl = fl;
      fh = eh;
      fl = el;
      el = dl + t1l | 0;
      eh = dh2 + t1h + getCarry(el, dl) | 0;
      dh2 = ch;
      dl = cl;
      ch = bh;
      cl = bl;
      bh = ah;
      bl = al;
      al = t1l + t2l | 0;
      ah = t1h + t2h + getCarry(al, t1l) | 0;
    }
    this._al = this._al + al | 0;
    this._bl = this._bl + bl | 0;
    this._cl = this._cl + cl | 0;
    this._dl = this._dl + dl | 0;
    this._el = this._el + el | 0;
    this._fl = this._fl + fl | 0;
    this._gl = this._gl + gl | 0;
    this._hl = this._hl + hl | 0;
    this._ah = this._ah + ah + getCarry(this._al, al) | 0;
    this._bh = this._bh + bh + getCarry(this._bl, bl) | 0;
    this._ch = this._ch + ch + getCarry(this._cl, cl) | 0;
    this._dh = this._dh + dh2 + getCarry(this._dl, dl) | 0;
    this._eh = this._eh + eh + getCarry(this._el, el) | 0;
    this._fh = this._fh + fh + getCarry(this._fl, fl) | 0;
    this._gh = this._gh + gh + getCarry(this._gl, gl) | 0;
    this._hh = this._hh + hh + getCarry(this._hl, hl) | 0;
  };
  Sha512.prototype._hash = function() {
    var H = Buffer2.allocUnsafe(64);
    function writeInt64BE(h2, l2, offset) {
      H.writeInt32BE(h2, offset);
      H.writeInt32BE(l2, offset + 4);
    }
    writeInt64BE(this._ah, this._al, 0);
    writeInt64BE(this._bh, this._bl, 8);
    writeInt64BE(this._ch, this._cl, 16);
    writeInt64BE(this._dh, this._dl, 24);
    writeInt64BE(this._eh, this._el, 32);
    writeInt64BE(this._fh, this._fl, 40);
    writeInt64BE(this._gh, this._gl, 48);
    writeInt64BE(this._hh, this._hl, 56);
    return H;
  };
  sha512$3 = Sha512;
  return sha512$3;
}
var sha384$3;
var hasRequiredSha384$1;
function requireSha384$1() {
  if (hasRequiredSha384$1) return sha384$3;
  hasRequiredSha384$1 = 1;
  var inherits = requireInherits_browser();
  var SHA512 = requireSha512$1();
  var Hash = requireHash$1();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var W = new Array(160);
  function Sha384() {
    this.init();
    this._w = W;
    Hash.call(this, 128, 112);
  }
  inherits(Sha384, SHA512);
  Sha384.prototype.init = function() {
    this._ah = 3418070365;
    this._bh = 1654270250;
    this._ch = 2438529370;
    this._dh = 355462360;
    this._eh = 1731405415;
    this._fh = 2394180231;
    this._gh = 3675008525;
    this._hh = 1203062813;
    this._al = 3238371032;
    this._bl = 914150663;
    this._cl = 812702999;
    this._dl = 4144912697;
    this._el = 4290775857;
    this._fl = 1750603025;
    this._gl = 1694076839;
    this._hl = 3204075428;
    return this;
  };
  Sha384.prototype._hash = function() {
    var H = Buffer2.allocUnsafe(48);
    function writeInt64BE(h2, l2, offset) {
      H.writeInt32BE(h2, offset);
      H.writeInt32BE(l2, offset + 4);
    }
    writeInt64BE(this._ah, this._al, 0);
    writeInt64BE(this._bh, this._bl, 8);
    writeInt64BE(this._ch, this._cl, 16);
    writeInt64BE(this._dh, this._dl, 24);
    writeInt64BE(this._eh, this._el, 32);
    writeInt64BE(this._fh, this._fl, 40);
    return H;
  };
  sha384$3 = Sha384;
  return sha384$3;
}
var hasRequiredSha_js;
function requireSha_js() {
  if (hasRequiredSha_js) return sha_js.exports;
  hasRequiredSha_js = 1;
  (function(module2) {
    module2.exports = function SHA(algorithm) {
      var alg = algorithm.toLowerCase();
      var Algorithm = module2.exports[alg];
      if (!Algorithm) {
        throw new Error(alg + " is not supported (we accept pull requests)");
      }
      return new Algorithm();
    };
    module2.exports.sha = requireSha$1();
    module2.exports.sha1 = requireSha1$1();
    module2.exports.sha224 = requireSha224$1();
    module2.exports.sha256 = requireSha256$1();
    module2.exports.sha384 = requireSha384$1();
    module2.exports.sha512 = requireSha512$1();
  })(sha_js);
  return sha_js.exports;
}
var string_decoder = {};
var hasRequiredString_decoder;
function requireString_decoder() {
  if (hasRequiredString_decoder) return string_decoder;
  hasRequiredString_decoder = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var isEncoding = Buffer2.isEncoding || function(encoding) {
    encoding = "" + encoding;
    switch (encoding && encoding.toLowerCase()) {
      case "hex":
      case "utf8":
      case "utf-8":
      case "ascii":
      case "binary":
      case "base64":
      case "ucs2":
      case "ucs-2":
      case "utf16le":
      case "utf-16le":
      case "raw":
        return true;
      default:
        return false;
    }
  };
  function _normalizeEncoding(enc) {
    if (!enc) return "utf8";
    var retried;
    while (true) {
      switch (enc) {
        case "utf8":
        case "utf-8":
          return "utf8";
        case "ucs2":
        case "ucs-2":
        case "utf16le":
        case "utf-16le":
          return "utf16le";
        case "latin1":
        case "binary":
          return "latin1";
        case "base64":
        case "ascii":
        case "hex":
          return enc;
        default:
          if (retried) return;
          enc = ("" + enc).toLowerCase();
          retried = true;
      }
    }
  }
  function normalizeEncoding(enc) {
    var nenc = _normalizeEncoding(enc);
    if (typeof nenc !== "string" && (Buffer2.isEncoding === isEncoding || !isEncoding(enc))) throw new Error("Unknown encoding: " + enc);
    return nenc || enc;
  }
  string_decoder.StringDecoder = StringDecoder;
  function StringDecoder(encoding) {
    this.encoding = normalizeEncoding(encoding);
    var nb;
    switch (this.encoding) {
      case "utf16le":
        this.text = utf16Text;
        this.end = utf16End;
        nb = 4;
        break;
      case "utf8":
        this.fillLast = utf8FillLast;
        nb = 4;
        break;
      case "base64":
        this.text = base64Text;
        this.end = base64End;
        nb = 3;
        break;
      default:
        this.write = simpleWrite;
        this.end = simpleEnd;
        return;
    }
    this.lastNeed = 0;
    this.lastTotal = 0;
    this.lastChar = Buffer2.allocUnsafe(nb);
  }
  StringDecoder.prototype.write = function(buf) {
    if (buf.length === 0) return "";
    var r2;
    var i2;
    if (this.lastNeed) {
      r2 = this.fillLast(buf);
      if (r2 === void 0) return "";
      i2 = this.lastNeed;
      this.lastNeed = 0;
    } else {
      i2 = 0;
    }
    if (i2 < buf.length) return r2 ? r2 + this.text(buf, i2) : this.text(buf, i2);
    return r2 || "";
  };
  StringDecoder.prototype.end = utf8End;
  StringDecoder.prototype.text = utf8Text;
  StringDecoder.prototype.fillLast = function(buf) {
    if (this.lastNeed <= buf.length) {
      buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
      return this.lastChar.toString(this.encoding, 0, this.lastTotal);
    }
    buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
    this.lastNeed -= buf.length;
  };
  function utf8CheckByte(byte) {
    if (byte <= 127) return 0;
    else if (byte >> 5 === 6) return 2;
    else if (byte >> 4 === 14) return 3;
    else if (byte >> 3 === 30) return 4;
    return byte >> 6 === 2 ? -1 : -2;
  }
  function utf8CheckIncomplete(self2, buf, i2) {
    var j = buf.length - 1;
    if (j < i2) return 0;
    var nb = utf8CheckByte(buf[j]);
    if (nb >= 0) {
      if (nb > 0) self2.lastNeed = nb - 1;
      return nb;
    }
    if (--j < i2 || nb === -2) return 0;
    nb = utf8CheckByte(buf[j]);
    if (nb >= 0) {
      if (nb > 0) self2.lastNeed = nb - 2;
      return nb;
    }
    if (--j < i2 || nb === -2) return 0;
    nb = utf8CheckByte(buf[j]);
    if (nb >= 0) {
      if (nb > 0) {
        if (nb === 2) nb = 0;
        else self2.lastNeed = nb - 3;
      }
      return nb;
    }
    return 0;
  }
  function utf8CheckExtraBytes(self2, buf, p2) {
    if ((buf[0] & 192) !== 128) {
      self2.lastNeed = 0;
      return "�";
    }
    if (self2.lastNeed > 1 && buf.length > 1) {
      if ((buf[1] & 192) !== 128) {
        self2.lastNeed = 1;
        return "�";
      }
      if (self2.lastNeed > 2 && buf.length > 2) {
        if ((buf[2] & 192) !== 128) {
          self2.lastNeed = 2;
          return "�";
        }
      }
    }
  }
  function utf8FillLast(buf) {
    var p2 = this.lastTotal - this.lastNeed;
    var r2 = utf8CheckExtraBytes(this, buf);
    if (r2 !== void 0) return r2;
    if (this.lastNeed <= buf.length) {
      buf.copy(this.lastChar, p2, 0, this.lastNeed);
      return this.lastChar.toString(this.encoding, 0, this.lastTotal);
    }
    buf.copy(this.lastChar, p2, 0, buf.length);
    this.lastNeed -= buf.length;
  }
  function utf8Text(buf, i2) {
    var total = utf8CheckIncomplete(this, buf, i2);
    if (!this.lastNeed) return buf.toString("utf8", i2);
    this.lastTotal = total;
    var end = buf.length - (total - this.lastNeed);
    buf.copy(this.lastChar, 0, end);
    return buf.toString("utf8", i2, end);
  }
  function utf8End(buf) {
    var r2 = buf && buf.length ? this.write(buf) : "";
    if (this.lastNeed) return r2 + "�";
    return r2;
  }
  function utf16Text(buf, i2) {
    if ((buf.length - i2) % 2 === 0) {
      var r2 = buf.toString("utf16le", i2);
      if (r2) {
        var c2 = r2.charCodeAt(r2.length - 1);
        if (c2 >= 55296 && c2 <= 56319) {
          this.lastNeed = 2;
          this.lastTotal = 4;
          this.lastChar[0] = buf[buf.length - 2];
          this.lastChar[1] = buf[buf.length - 1];
          return r2.slice(0, -1);
        }
      }
      return r2;
    }
    this.lastNeed = 1;
    this.lastTotal = 2;
    this.lastChar[0] = buf[buf.length - 1];
    return buf.toString("utf16le", i2, buf.length - 1);
  }
  function utf16End(buf) {
    var r2 = buf && buf.length ? this.write(buf) : "";
    if (this.lastNeed) {
      var end = this.lastTotal - this.lastNeed;
      return r2 + this.lastChar.toString("utf16le", 0, end);
    }
    return r2;
  }
  function base64Text(buf, i2) {
    var n2 = (buf.length - i2) % 3;
    if (n2 === 0) return buf.toString("base64", i2);
    this.lastNeed = 3 - n2;
    this.lastTotal = 3;
    if (n2 === 1) {
      this.lastChar[0] = buf[buf.length - 1];
    } else {
      this.lastChar[0] = buf[buf.length - 2];
      this.lastChar[1] = buf[buf.length - 1];
    }
    return buf.toString("base64", i2, buf.length - n2);
  }
  function base64End(buf) {
    var r2 = buf && buf.length ? this.write(buf) : "";
    if (this.lastNeed) return r2 + this.lastChar.toString("base64", 0, 3 - this.lastNeed);
    return r2;
  }
  function simpleWrite(buf) {
    return buf.toString(this.encoding);
  }
  function simpleEnd(buf) {
    return buf && buf.length ? this.write(buf) : "";
  }
  return string_decoder;
}
var cipherBase;
var hasRequiredCipherBase;
function requireCipherBase() {
  if (hasRequiredCipherBase) return cipherBase;
  hasRequiredCipherBase = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var Transform = requireStream().Transform;
  var StringDecoder = requireString_decoder().StringDecoder;
  var inherits = requireInherits_browser();
  var toBuffer2 = /* @__PURE__ */ requireToBuffer$2();
  function CipherBase(hashMode) {
    Transform.call(this);
    this.hashMode = typeof hashMode === "string";
    if (this.hashMode) {
      this[hashMode] = this._finalOrDigest;
    } else {
      this["final"] = this._finalOrDigest;
    }
    if (this._final) {
      this.__final = this._final;
      this._final = null;
    }
    this._decoder = null;
    this._encoding = null;
  }
  inherits(CipherBase, Transform);
  CipherBase.prototype.update = function(data2, inputEnc, outputEnc) {
    var bufferData = toBuffer2(data2, inputEnc);
    var outData = this._update(bufferData);
    if (this.hashMode) {
      return this;
    }
    if (outputEnc) {
      outData = this._toString(outData, outputEnc);
    }
    return outData;
  };
  CipherBase.prototype.setAutoPadding = function() {
  };
  CipherBase.prototype.getAuthTag = function() {
    throw new Error("trying to get auth tag in unsupported state");
  };
  CipherBase.prototype.setAuthTag = function() {
    throw new Error("trying to set auth tag in unsupported state");
  };
  CipherBase.prototype.setAAD = function() {
    throw new Error("trying to set aad in unsupported state");
  };
  CipherBase.prototype._transform = function(data2, _2, next) {
    var err;
    try {
      if (this.hashMode) {
        this._update(data2);
      } else {
        this.push(this._update(data2));
      }
    } catch (e4) {
      err = e4;
    } finally {
      next(err);
    }
  };
  CipherBase.prototype._flush = function(done) {
    var err;
    try {
      this.push(this.__final());
    } catch (e4) {
      err = e4;
    }
    done(err);
  };
  CipherBase.prototype._finalOrDigest = function(outputEnc) {
    var outData = this.__final() || Buffer2.alloc(0);
    if (outputEnc) {
      outData = this._toString(outData, outputEnc, true);
    }
    return outData;
  };
  CipherBase.prototype._toString = function(value, enc, fin) {
    if (!this._decoder) {
      this._decoder = new StringDecoder(enc);
      this._encoding = enc;
    }
    if (this._encoding !== enc) {
      throw new Error("can’t switch encodings");
    }
    var out = this._decoder.write(value);
    if (fin) {
      out += this._decoder.end();
    }
    return out;
  };
  cipherBase = CipherBase;
  return cipherBase;
}
var browser$e;
var hasRequiredBrowser$c;
function requireBrowser$c() {
  if (hasRequiredBrowser$c) return browser$e;
  hasRequiredBrowser$c = 1;
  var inherits = requireInherits_browser();
  var MD5 = requireMd5_js();
  var RIPEMD160 = requireRipemd160$1();
  var sha2 = requireSha_js();
  var Base = requireCipherBase();
  function Hash(hash2) {
    Base.call(this, "digest");
    this._hash = hash2;
  }
  inherits(Hash, Base);
  Hash.prototype._update = function(data2) {
    this._hash.update(data2);
  };
  Hash.prototype._final = function() {
    return this._hash.digest();
  };
  browser$e = function createHash(alg) {
    alg = alg.toLowerCase();
    if (alg === "md5") return new MD5();
    if (alg === "rmd160" || alg === "ripemd160") return new RIPEMD160();
    return new Hash(sha2(alg));
  };
  return browser$e;
}
var legacy;
var hasRequiredLegacy;
function requireLegacy() {
  if (hasRequiredLegacy) return legacy;
  hasRequiredLegacy = 1;
  var inherits = requireInherits_browser();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var Base = requireCipherBase();
  var ZEROS = Buffer2.alloc(128);
  var blocksize = 64;
  function Hmac(alg, key2) {
    Base.call(this, "digest");
    if (typeof key2 === "string") {
      key2 = Buffer2.from(key2);
    }
    this._alg = alg;
    this._key = key2;
    if (key2.length > blocksize) {
      key2 = alg(key2);
    } else if (key2.length < blocksize) {
      key2 = Buffer2.concat([key2, ZEROS], blocksize);
    }
    var ipad = this._ipad = Buffer2.allocUnsafe(blocksize);
    var opad = this._opad = Buffer2.allocUnsafe(blocksize);
    for (var i2 = 0; i2 < blocksize; i2++) {
      ipad[i2] = key2[i2] ^ 54;
      opad[i2] = key2[i2] ^ 92;
    }
    this._hash = [ipad];
  }
  inherits(Hmac, Base);
  Hmac.prototype._update = function(data2) {
    this._hash.push(data2);
  };
  Hmac.prototype._final = function() {
    var h2 = this._alg(Buffer2.concat(this._hash));
    return this._alg(Buffer2.concat([this._opad, h2]));
  };
  legacy = Hmac;
  return legacy;
}
var md5$2;
var hasRequiredMd5$1;
function requireMd5$1() {
  if (hasRequiredMd5$1) return md5$2;
  hasRequiredMd5$1 = 1;
  var MD5 = requireMd5_js();
  md5$2 = function(buffer2) {
    return new MD5().update(buffer2).digest();
  };
  return md5$2;
}
var browser$d;
var hasRequiredBrowser$b;
function requireBrowser$b() {
  if (hasRequiredBrowser$b) return browser$d;
  hasRequiredBrowser$b = 1;
  var inherits = requireInherits_browser();
  var Legacy = requireLegacy();
  var Base = requireCipherBase();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var md52 = requireMd5$1();
  var RIPEMD160 = requireRipemd160$1();
  var sha2 = requireSha_js();
  var ZEROS = Buffer2.alloc(128);
  function Hmac(alg, key2) {
    Base.call(this, "digest");
    if (typeof key2 === "string") {
      key2 = Buffer2.from(key2);
    }
    var blocksize = alg === "sha512" || alg === "sha384" ? 128 : 64;
    this._alg = alg;
    this._key = key2;
    if (key2.length > blocksize) {
      var hash2 = alg === "rmd160" ? new RIPEMD160() : sha2(alg);
      key2 = hash2.update(key2).digest();
    } else if (key2.length < blocksize) {
      key2 = Buffer2.concat([key2, ZEROS], blocksize);
    }
    var ipad = this._ipad = Buffer2.allocUnsafe(blocksize);
    var opad = this._opad = Buffer2.allocUnsafe(blocksize);
    for (var i2 = 0; i2 < blocksize; i2++) {
      ipad[i2] = key2[i2] ^ 54;
      opad[i2] = key2[i2] ^ 92;
    }
    this._hash = alg === "rmd160" ? new RIPEMD160() : sha2(alg);
    this._hash.update(ipad);
  }
  inherits(Hmac, Base);
  Hmac.prototype._update = function(data2) {
    this._hash.update(data2);
  };
  Hmac.prototype._final = function() {
    var h2 = this._hash.digest();
    var hash2 = this._alg === "rmd160" ? new RIPEMD160() : sha2(this._alg);
    return hash2.update(this._opad).update(h2).digest();
  };
  browser$d = function createHmac(alg, key2) {
    alg = alg.toLowerCase();
    if (alg === "rmd160" || alg === "ripemd160") {
      return new Hmac("rmd160", key2);
    }
    if (alg === "md5") {
      return new Legacy(md52, key2);
    }
    return new Hmac(alg, key2);
  };
  return browser$d;
}
const sha224WithRSAEncryption = { "sign": "rsa", "hash": "sha224", "id": "302d300d06096086480165030402040500041c" };
const sha256WithRSAEncryption = { "sign": "rsa", "hash": "sha256", "id": "3031300d060960864801650304020105000420" };
const sha384WithRSAEncryption = { "sign": "rsa", "hash": "sha384", "id": "3041300d060960864801650304020205000430" };
const sha512WithRSAEncryption = { "sign": "rsa", "hash": "sha512", "id": "3051300d060960864801650304020305000440" };
const sha256$3 = { "sign": "ecdsa", "hash": "sha256", "id": "" };
const sha224$2 = { "sign": "ecdsa", "hash": "sha224", "id": "" };
const sha384$2 = { "sign": "ecdsa", "hash": "sha384", "id": "" };
const sha512$2 = { "sign": "ecdsa", "hash": "sha512", "id": "" };
const DSA = { "sign": "dsa", "hash": "sha1", "id": "" };
const ripemd160WithRSA = { "sign": "rsa", "hash": "rmd160", "id": "3021300906052b2403020105000414" };
const md5WithRSAEncryption = { "sign": "rsa", "hash": "md5", "id": "3020300c06082a864886f70d020505000410" };
const require$$6 = {
  sha224WithRSAEncryption,
  "RSA-SHA224": { "sign": "ecdsa/rsa", "hash": "sha224", "id": "302d300d06096086480165030402040500041c" },
  sha256WithRSAEncryption,
  "RSA-SHA256": { "sign": "ecdsa/rsa", "hash": "sha256", "id": "3031300d060960864801650304020105000420" },
  sha384WithRSAEncryption,
  "RSA-SHA384": { "sign": "ecdsa/rsa", "hash": "sha384", "id": "3041300d060960864801650304020205000430" },
  sha512WithRSAEncryption,
  "RSA-SHA512": { "sign": "ecdsa/rsa", "hash": "sha512", "id": "3051300d060960864801650304020305000440" },
  "RSA-SHA1": { "sign": "rsa", "hash": "sha1", "id": "3021300906052b0e03021a05000414" },
  "ecdsa-with-SHA1": { "sign": "ecdsa", "hash": "sha1", "id": "" },
  sha256: sha256$3,
  sha224: sha224$2,
  sha384: sha384$2,
  sha512: sha512$2,
  "DSA-SHA": { "sign": "dsa", "hash": "sha1", "id": "" },
  "DSA-SHA1": { "sign": "dsa", "hash": "sha1", "id": "" },
  DSA,
  "DSA-WITH-SHA224": { "sign": "dsa", "hash": "sha224", "id": "" },
  "DSA-SHA224": { "sign": "dsa", "hash": "sha224", "id": "" },
  "DSA-WITH-SHA256": { "sign": "dsa", "hash": "sha256", "id": "" },
  "DSA-SHA256": { "sign": "dsa", "hash": "sha256", "id": "" },
  "DSA-WITH-SHA384": { "sign": "dsa", "hash": "sha384", "id": "" },
  "DSA-SHA384": { "sign": "dsa", "hash": "sha384", "id": "" },
  "DSA-WITH-SHA512": { "sign": "dsa", "hash": "sha512", "id": "" },
  "DSA-SHA512": { "sign": "dsa", "hash": "sha512", "id": "" },
  "DSA-RIPEMD160": { "sign": "dsa", "hash": "rmd160", "id": "" },
  ripemd160WithRSA,
  "RSA-RIPEMD160": { "sign": "rsa", "hash": "rmd160", "id": "3021300906052b2403020105000414" },
  md5WithRSAEncryption,
  "RSA-MD5": { "sign": "rsa", "hash": "md5", "id": "3020300c06082a864886f70d020505000410" }
};
var algos;
var hasRequiredAlgos;
function requireAlgos() {
  if (hasRequiredAlgos) return algos;
  hasRequiredAlgos = 1;
  algos = require$$6;
  return algos;
}
var browser$c = {};
var precondition;
var hasRequiredPrecondition;
function requirePrecondition() {
  if (hasRequiredPrecondition) return precondition;
  hasRequiredPrecondition = 1;
  var $isFinite = isFinite;
  var MAX_ALLOC = Math.pow(2, 30) - 1;
  precondition = function(iterations, keylen) {
    if (typeof iterations !== "number") {
      throw new TypeError("Iterations not a number");
    }
    if (iterations < 0 || !$isFinite(iterations)) {
      throw new TypeError("Bad iterations");
    }
    if (typeof keylen !== "number") {
      throw new TypeError("Key length not a number");
    }
    if (keylen < 0 || keylen > MAX_ALLOC || keylen !== keylen) {
      throw new TypeError("Bad key length");
    }
  };
  return precondition;
}
var defaultEncoding_1;
var hasRequiredDefaultEncoding;
function requireDefaultEncoding() {
  if (hasRequiredDefaultEncoding) return defaultEncoding_1;
  hasRequiredDefaultEncoding = 1;
  var defaultEncoding;
  if (commonjsGlobal$1.process && commonjsGlobal$1.process.browser) {
    defaultEncoding = "utf-8";
  } else if (commonjsGlobal$1.process && commonjsGlobal$1.process.version) {
    var pVersionMajor = parseInt(process.version.split(".")[0].slice(1), 10);
    defaultEncoding = pVersionMajor >= 6 ? "utf-8" : "binary";
  } else {
    defaultEncoding = "utf-8";
  }
  defaultEncoding_1 = defaultEncoding;
  return defaultEncoding_1;
}
var toBuffer_1;
var hasRequiredToBuffer;
function requireToBuffer() {
  if (hasRequiredToBuffer) return toBuffer_1;
  hasRequiredToBuffer = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var toBuffer2 = /* @__PURE__ */ requireToBuffer$2();
  var useUint8Array = typeof Uint8Array !== "undefined";
  var useArrayBuffer = useUint8Array && typeof ArrayBuffer !== "undefined";
  var isView = useArrayBuffer && ArrayBuffer.isView;
  toBuffer_1 = function(thing, encoding, name) {
    if (typeof thing === "string" || Buffer2.isBuffer(thing) || useUint8Array && thing instanceof Uint8Array || isView && isView(thing)) {
      return toBuffer2(thing, encoding);
    }
    throw new TypeError(name + " must be a string, a Buffer, a Uint8Array, or a DataView");
  };
  return toBuffer_1;
}
var syncBrowser;
var hasRequiredSyncBrowser;
function requireSyncBrowser() {
  if (hasRequiredSyncBrowser) return syncBrowser;
  hasRequiredSyncBrowser = 1;
  var md52 = requireMd5$1();
  var RIPEMD160 = requireRipemd160$1();
  var sha2 = requireSha_js();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var checkParameters = requirePrecondition();
  var defaultEncoding = requireDefaultEncoding();
  var toBuffer2 = requireToBuffer();
  var ZEROS = Buffer2.alloc(128);
  var sizes = {
    __proto__: null,
    md5: 16,
    sha1: 20,
    sha224: 28,
    sha256: 32,
    sha384: 48,
    sha512: 64,
    "sha512-256": 32,
    ripemd160: 20,
    rmd160: 20
  };
  var mapping = {
    __proto__: null,
    "sha-1": "sha1",
    "sha-224": "sha224",
    "sha-256": "sha256",
    "sha-384": "sha384",
    "sha-512": "sha512",
    "ripemd-160": "ripemd160"
  };
  function rmd160Func(data2) {
    return new RIPEMD160().update(data2).digest();
  }
  function getDigest(alg) {
    function shaFunc(data2) {
      return sha2(alg).update(data2).digest();
    }
    if (alg === "rmd160" || alg === "ripemd160") {
      return rmd160Func;
    }
    if (alg === "md5") {
      return md52;
    }
    return shaFunc;
  }
  function Hmac(alg, key2, saltLen) {
    var hash2 = getDigest(alg);
    var blocksize = alg === "sha512" || alg === "sha384" ? 128 : 64;
    if (key2.length > blocksize) {
      key2 = hash2(key2);
    } else if (key2.length < blocksize) {
      key2 = Buffer2.concat([key2, ZEROS], blocksize);
    }
    var ipad = Buffer2.allocUnsafe(blocksize + sizes[alg]);
    var opad = Buffer2.allocUnsafe(blocksize + sizes[alg]);
    for (var i2 = 0; i2 < blocksize; i2++) {
      ipad[i2] = key2[i2] ^ 54;
      opad[i2] = key2[i2] ^ 92;
    }
    var ipad1 = Buffer2.allocUnsafe(blocksize + saltLen + 4);
    ipad.copy(ipad1, 0, 0, blocksize);
    this.ipad1 = ipad1;
    this.ipad2 = ipad;
    this.opad = opad;
    this.alg = alg;
    this.blocksize = blocksize;
    this.hash = hash2;
    this.size = sizes[alg];
  }
  Hmac.prototype.run = function(data2, ipad) {
    data2.copy(ipad, this.blocksize);
    var h2 = this.hash(ipad);
    h2.copy(this.opad, this.blocksize);
    return this.hash(this.opad);
  };
  function pbkdf22(password, salt, iterations, keylen, digest) {
    checkParameters(iterations, keylen);
    password = toBuffer2(password, defaultEncoding, "Password");
    salt = toBuffer2(salt, defaultEncoding, "Salt");
    var lowerDigest = (digest || "sha1").toLowerCase();
    var mappedDigest = mapping[lowerDigest] || lowerDigest;
    var size = sizes[mappedDigest];
    if (typeof size !== "number" || !size) {
      throw new TypeError("Digest algorithm not supported: " + digest);
    }
    var hmac2 = new Hmac(mappedDigest, password, salt.length);
    var DK = Buffer2.allocUnsafe(keylen);
    var block1 = Buffer2.allocUnsafe(salt.length + 4);
    salt.copy(block1, 0, 0, salt.length);
    var destPos = 0;
    var hLen = size;
    var l2 = Math.ceil(keylen / hLen);
    for (var i2 = 1; i2 <= l2; i2++) {
      block1.writeUInt32BE(i2, salt.length);
      var T2 = hmac2.run(block1, hmac2.ipad1);
      var U = T2;
      for (var j = 1; j < iterations; j++) {
        U = hmac2.run(U, hmac2.ipad2);
        for (var k2 = 0; k2 < hLen; k2++) {
          T2[k2] ^= U[k2];
        }
      }
      T2.copy(DK, destPos);
      destPos += hLen;
    }
    return DK;
  }
  syncBrowser = pbkdf22;
  return syncBrowser;
}
var async$1;
var hasRequiredAsync$1;
function requireAsync$1() {
  if (hasRequiredAsync$1) return async$1;
  hasRequiredAsync$1 = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var checkParameters = requirePrecondition();
  var defaultEncoding = requireDefaultEncoding();
  var sync = requireSyncBrowser();
  var toBuffer2 = requireToBuffer();
  var ZERO_BUF;
  var subtle = commonjsGlobal$1.crypto && commonjsGlobal$1.crypto.subtle;
  var toBrowser = {
    sha: "SHA-1",
    "sha-1": "SHA-1",
    sha1: "SHA-1",
    sha256: "SHA-256",
    "sha-256": "SHA-256",
    sha384: "SHA-384",
    "sha-384": "SHA-384",
    "sha-512": "SHA-512",
    sha512: "SHA-512"
  };
  var checks = [];
  var nextTick;
  function getNextTick() {
    if (nextTick) {
      return nextTick;
    }
    if (commonjsGlobal$1.process && commonjsGlobal$1.process.nextTick) {
      nextTick = commonjsGlobal$1.process.nextTick;
    } else if (commonjsGlobal$1.queueMicrotask) {
      nextTick = commonjsGlobal$1.queueMicrotask;
    } else if (commonjsGlobal$1.setImmediate) {
      nextTick = commonjsGlobal$1.setImmediate;
    } else {
      nextTick = commonjsGlobal$1.setTimeout;
    }
    return nextTick;
  }
  function browserPbkdf2(password, salt, iterations, length, algo) {
    return subtle.importKey("raw", password, { name: "PBKDF2" }, false, ["deriveBits"]).then(function(key2) {
      return subtle.deriveBits({
        name: "PBKDF2",
        salt,
        iterations,
        hash: {
          name: algo
        }
      }, key2, length << 3);
    }).then(function(res) {
      return Buffer2.from(res);
    });
  }
  function checkNative(algo) {
    if (commonjsGlobal$1.process && !commonjsGlobal$1.process.browser) {
      return Promise.resolve(false);
    }
    if (!subtle || !subtle.importKey || !subtle.deriveBits) {
      return Promise.resolve(false);
    }
    if (checks[algo] !== void 0) {
      return checks[algo];
    }
    ZERO_BUF = ZERO_BUF || Buffer2.alloc(8);
    var prom = browserPbkdf2(ZERO_BUF, ZERO_BUF, 10, 128, algo).then(
      function() {
        return true;
      },
      function() {
        return false;
      }
    );
    checks[algo] = prom;
    return prom;
  }
  function resolvePromise(promise, callback) {
    promise.then(function(out) {
      getNextTick()(function() {
        callback(null, out);
      });
    }, function(e4) {
      getNextTick()(function() {
        callback(e4);
      });
    });
  }
  async$1 = function(password, salt, iterations, keylen, digest, callback) {
    if (typeof digest === "function") {
      callback = digest;
      digest = void 0;
    }
    checkParameters(iterations, keylen);
    password = toBuffer2(password, defaultEncoding, "Password");
    salt = toBuffer2(salt, defaultEncoding, "Salt");
    if (typeof callback !== "function") {
      throw new Error("No callback provided to pbkdf2");
    }
    digest = digest || "sha1";
    var algo = toBrowser[digest.toLowerCase()];
    if (!algo || typeof commonjsGlobal$1.Promise !== "function") {
      getNextTick()(function() {
        var out;
        try {
          out = sync(password, salt, iterations, keylen, digest);
        } catch (e4) {
          callback(e4);
          return;
        }
        callback(null, out);
      });
      return;
    }
    resolvePromise(checkNative(algo).then(function(resp) {
      if (resp) {
        return browserPbkdf2(password, salt, iterations, keylen, algo);
      }
      return sync(password, salt, iterations, keylen, digest);
    }), callback);
  };
  return async$1;
}
var hasRequiredBrowser$a;
function requireBrowser$a() {
  if (hasRequiredBrowser$a) return browser$c;
  hasRequiredBrowser$a = 1;
  browser$c.pbkdf2 = requireAsync$1();
  browser$c.pbkdf2Sync = requireSyncBrowser();
  return browser$c;
}
var browser$b = {};
var des$1 = {};
var utils$4 = {};
var hasRequiredUtils$4;
function requireUtils$4() {
  if (hasRequiredUtils$4) return utils$4;
  hasRequiredUtils$4 = 1;
  utils$4.readUInt32BE = function readUInt32BE(bytes, off) {
    var res = bytes[0 + off] << 24 | bytes[1 + off] << 16 | bytes[2 + off] << 8 | bytes[3 + off];
    return res >>> 0;
  };
  utils$4.writeUInt32BE = function writeUInt32BE(bytes, value, off) {
    bytes[0 + off] = value >>> 24;
    bytes[1 + off] = value >>> 16 & 255;
    bytes[2 + off] = value >>> 8 & 255;
    bytes[3 + off] = value & 255;
  };
  utils$4.ip = function ip(inL, inR, out, off) {
    var outL = 0;
    var outR = 0;
    for (var i2 = 6; i2 >= 0; i2 -= 2) {
      for (var j = 0; j <= 24; j += 8) {
        outL <<= 1;
        outL |= inR >>> j + i2 & 1;
      }
      for (var j = 0; j <= 24; j += 8) {
        outL <<= 1;
        outL |= inL >>> j + i2 & 1;
      }
    }
    for (var i2 = 6; i2 >= 0; i2 -= 2) {
      for (var j = 1; j <= 25; j += 8) {
        outR <<= 1;
        outR |= inR >>> j + i2 & 1;
      }
      for (var j = 1; j <= 25; j += 8) {
        outR <<= 1;
        outR |= inL >>> j + i2 & 1;
      }
    }
    out[off + 0] = outL >>> 0;
    out[off + 1] = outR >>> 0;
  };
  utils$4.rip = function rip(inL, inR, out, off) {
    var outL = 0;
    var outR = 0;
    for (var i2 = 0; i2 < 4; i2++) {
      for (var j = 24; j >= 0; j -= 8) {
        outL <<= 1;
        outL |= inR >>> j + i2 & 1;
        outL <<= 1;
        outL |= inL >>> j + i2 & 1;
      }
    }
    for (var i2 = 4; i2 < 8; i2++) {
      for (var j = 24; j >= 0; j -= 8) {
        outR <<= 1;
        outR |= inR >>> j + i2 & 1;
        outR <<= 1;
        outR |= inL >>> j + i2 & 1;
      }
    }
    out[off + 0] = outL >>> 0;
    out[off + 1] = outR >>> 0;
  };
  utils$4.pc1 = function pc1(inL, inR, out, off) {
    var outL = 0;
    var outR = 0;
    for (var i2 = 7; i2 >= 5; i2--) {
      for (var j = 0; j <= 24; j += 8) {
        outL <<= 1;
        outL |= inR >> j + i2 & 1;
      }
      for (var j = 0; j <= 24; j += 8) {
        outL <<= 1;
        outL |= inL >> j + i2 & 1;
      }
    }
    for (var j = 0; j <= 24; j += 8) {
      outL <<= 1;
      outL |= inR >> j + i2 & 1;
    }
    for (var i2 = 1; i2 <= 3; i2++) {
      for (var j = 0; j <= 24; j += 8) {
        outR <<= 1;
        outR |= inR >> j + i2 & 1;
      }
      for (var j = 0; j <= 24; j += 8) {
        outR <<= 1;
        outR |= inL >> j + i2 & 1;
      }
    }
    for (var j = 0; j <= 24; j += 8) {
      outR <<= 1;
      outR |= inL >> j + i2 & 1;
    }
    out[off + 0] = outL >>> 0;
    out[off + 1] = outR >>> 0;
  };
  utils$4.r28shl = function r28shl(num, shift) {
    return num << shift & 268435455 | num >>> 28 - shift;
  };
  var pc2table = [
    // inL => outL
    14,
    11,
    17,
    4,
    27,
    23,
    25,
    0,
    13,
    22,
    7,
    18,
    5,
    9,
    16,
    24,
    2,
    20,
    12,
    21,
    1,
    8,
    15,
    26,
    // inR => outR
    15,
    4,
    25,
    19,
    9,
    1,
    26,
    16,
    5,
    11,
    23,
    8,
    12,
    7,
    17,
    0,
    22,
    3,
    10,
    14,
    6,
    20,
    27,
    24
  ];
  utils$4.pc2 = function pc2(inL, inR, out, off) {
    var outL = 0;
    var outR = 0;
    var len = pc2table.length >>> 1;
    for (var i2 = 0; i2 < len; i2++) {
      outL <<= 1;
      outL |= inL >>> pc2table[i2] & 1;
    }
    for (var i2 = len; i2 < pc2table.length; i2++) {
      outR <<= 1;
      outR |= inR >>> pc2table[i2] & 1;
    }
    out[off + 0] = outL >>> 0;
    out[off + 1] = outR >>> 0;
  };
  utils$4.expand = function expand(r2, out, off) {
    var outL = 0;
    var outR = 0;
    outL = (r2 & 1) << 5 | r2 >>> 27;
    for (var i2 = 23; i2 >= 15; i2 -= 4) {
      outL <<= 6;
      outL |= r2 >>> i2 & 63;
    }
    for (var i2 = 11; i2 >= 3; i2 -= 4) {
      outR |= r2 >>> i2 & 63;
      outR <<= 6;
    }
    outR |= (r2 & 31) << 1 | r2 >>> 31;
    out[off + 0] = outL >>> 0;
    out[off + 1] = outR >>> 0;
  };
  var sTable = [
    14,
    0,
    4,
    15,
    13,
    7,
    1,
    4,
    2,
    14,
    15,
    2,
    11,
    13,
    8,
    1,
    3,
    10,
    10,
    6,
    6,
    12,
    12,
    11,
    5,
    9,
    9,
    5,
    0,
    3,
    7,
    8,
    4,
    15,
    1,
    12,
    14,
    8,
    8,
    2,
    13,
    4,
    6,
    9,
    2,
    1,
    11,
    7,
    15,
    5,
    12,
    11,
    9,
    3,
    7,
    14,
    3,
    10,
    10,
    0,
    5,
    6,
    0,
    13,
    15,
    3,
    1,
    13,
    8,
    4,
    14,
    7,
    6,
    15,
    11,
    2,
    3,
    8,
    4,
    14,
    9,
    12,
    7,
    0,
    2,
    1,
    13,
    10,
    12,
    6,
    0,
    9,
    5,
    11,
    10,
    5,
    0,
    13,
    14,
    8,
    7,
    10,
    11,
    1,
    10,
    3,
    4,
    15,
    13,
    4,
    1,
    2,
    5,
    11,
    8,
    6,
    12,
    7,
    6,
    12,
    9,
    0,
    3,
    5,
    2,
    14,
    15,
    9,
    10,
    13,
    0,
    7,
    9,
    0,
    14,
    9,
    6,
    3,
    3,
    4,
    15,
    6,
    5,
    10,
    1,
    2,
    13,
    8,
    12,
    5,
    7,
    14,
    11,
    12,
    4,
    11,
    2,
    15,
    8,
    1,
    13,
    1,
    6,
    10,
    4,
    13,
    9,
    0,
    8,
    6,
    15,
    9,
    3,
    8,
    0,
    7,
    11,
    4,
    1,
    15,
    2,
    14,
    12,
    3,
    5,
    11,
    10,
    5,
    14,
    2,
    7,
    12,
    7,
    13,
    13,
    8,
    14,
    11,
    3,
    5,
    0,
    6,
    6,
    15,
    9,
    0,
    10,
    3,
    1,
    4,
    2,
    7,
    8,
    2,
    5,
    12,
    11,
    1,
    12,
    10,
    4,
    14,
    15,
    9,
    10,
    3,
    6,
    15,
    9,
    0,
    0,
    6,
    12,
    10,
    11,
    1,
    7,
    13,
    13,
    8,
    15,
    9,
    1,
    4,
    3,
    5,
    14,
    11,
    5,
    12,
    2,
    7,
    8,
    2,
    4,
    14,
    2,
    14,
    12,
    11,
    4,
    2,
    1,
    12,
    7,
    4,
    10,
    7,
    11,
    13,
    6,
    1,
    8,
    5,
    5,
    0,
    3,
    15,
    15,
    10,
    13,
    3,
    0,
    9,
    14,
    8,
    9,
    6,
    4,
    11,
    2,
    8,
    1,
    12,
    11,
    7,
    10,
    1,
    13,
    14,
    7,
    2,
    8,
    13,
    15,
    6,
    9,
    15,
    12,
    0,
    5,
    9,
    6,
    10,
    3,
    4,
    0,
    5,
    14,
    3,
    12,
    10,
    1,
    15,
    10,
    4,
    15,
    2,
    9,
    7,
    2,
    12,
    6,
    9,
    8,
    5,
    0,
    6,
    13,
    1,
    3,
    13,
    4,
    14,
    14,
    0,
    7,
    11,
    5,
    3,
    11,
    8,
    9,
    4,
    14,
    3,
    15,
    2,
    5,
    12,
    2,
    9,
    8,
    5,
    12,
    15,
    3,
    10,
    7,
    11,
    0,
    14,
    4,
    1,
    10,
    7,
    1,
    6,
    13,
    0,
    11,
    8,
    6,
    13,
    4,
    13,
    11,
    0,
    2,
    11,
    14,
    7,
    15,
    4,
    0,
    9,
    8,
    1,
    13,
    10,
    3,
    14,
    12,
    3,
    9,
    5,
    7,
    12,
    5,
    2,
    10,
    15,
    6,
    8,
    1,
    6,
    1,
    6,
    4,
    11,
    11,
    13,
    13,
    8,
    12,
    1,
    3,
    4,
    7,
    10,
    14,
    7,
    10,
    9,
    15,
    5,
    6,
    0,
    8,
    15,
    0,
    14,
    5,
    2,
    9,
    3,
    2,
    12,
    13,
    1,
    2,
    15,
    8,
    13,
    4,
    8,
    6,
    10,
    15,
    3,
    11,
    7,
    1,
    4,
    10,
    12,
    9,
    5,
    3,
    6,
    14,
    11,
    5,
    0,
    0,
    14,
    12,
    9,
    7,
    2,
    7,
    2,
    11,
    1,
    4,
    14,
    1,
    7,
    9,
    4,
    12,
    10,
    14,
    8,
    2,
    13,
    0,
    15,
    6,
    12,
    10,
    9,
    13,
    0,
    15,
    3,
    3,
    5,
    5,
    6,
    8,
    11
  ];
  utils$4.substitute = function substitute(inL, inR) {
    var out = 0;
    for (var i2 = 0; i2 < 4; i2++) {
      var b2 = inL >>> 18 - i2 * 6 & 63;
      var sb = sTable[i2 * 64 + b2];
      out <<= 4;
      out |= sb;
    }
    for (var i2 = 0; i2 < 4; i2++) {
      var b2 = inR >>> 18 - i2 * 6 & 63;
      var sb = sTable[4 * 64 + i2 * 64 + b2];
      out <<= 4;
      out |= sb;
    }
    return out >>> 0;
  };
  var permuteTable = [
    16,
    25,
    12,
    11,
    3,
    20,
    4,
    15,
    31,
    17,
    9,
    6,
    27,
    14,
    1,
    22,
    30,
    24,
    8,
    18,
    0,
    5,
    29,
    23,
    13,
    19,
    2,
    26,
    10,
    21,
    28,
    7
  ];
  utils$4.permute = function permute(num) {
    var out = 0;
    for (var i2 = 0; i2 < permuteTable.length; i2++) {
      out <<= 1;
      out |= num >>> permuteTable[i2] & 1;
    }
    return out >>> 0;
  };
  utils$4.padSplit = function padSplit(num, size, group) {
    var str = num.toString(2);
    while (str.length < size)
      str = "0" + str;
    var out = [];
    for (var i2 = 0; i2 < size; i2 += group)
      out.push(str.slice(i2, i2 + group));
    return out.join(" ");
  };
  return utils$4;
}
var minimalisticAssert;
var hasRequiredMinimalisticAssert;
function requireMinimalisticAssert() {
  if (hasRequiredMinimalisticAssert) return minimalisticAssert;
  hasRequiredMinimalisticAssert = 1;
  minimalisticAssert = assert;
  function assert(val, msg) {
    if (!val)
      throw new Error(msg || "Assertion failed");
  }
  assert.equal = function assertEqual(l2, r2, msg) {
    if (l2 != r2)
      throw new Error(msg || "Assertion failed: " + l2 + " != " + r2);
  };
  return minimalisticAssert;
}
var cipher;
var hasRequiredCipher;
function requireCipher() {
  if (hasRequiredCipher) return cipher;
  hasRequiredCipher = 1;
  var assert = requireMinimalisticAssert();
  function Cipher(options2) {
    this.options = options2;
    this.type = this.options.type;
    this.blockSize = 8;
    this._init();
    this.buffer = new Array(this.blockSize);
    this.bufferOff = 0;
    this.padding = options2.padding !== false;
  }
  cipher = Cipher;
  Cipher.prototype._init = function _init() {
  };
  Cipher.prototype.update = function update(data2) {
    if (data2.length === 0)
      return [];
    if (this.type === "decrypt")
      return this._updateDecrypt(data2);
    else
      return this._updateEncrypt(data2);
  };
  Cipher.prototype._buffer = function _buffer(data2, off) {
    var min2 = Math.min(this.buffer.length - this.bufferOff, data2.length - off);
    for (var i2 = 0; i2 < min2; i2++)
      this.buffer[this.bufferOff + i2] = data2[off + i2];
    this.bufferOff += min2;
    return min2;
  };
  Cipher.prototype._flushBuffer = function _flushBuffer(out, off) {
    this._update(this.buffer, 0, out, off);
    this.bufferOff = 0;
    return this.blockSize;
  };
  Cipher.prototype._updateEncrypt = function _updateEncrypt(data2) {
    var inputOff = 0;
    var outputOff = 0;
    var count = (this.bufferOff + data2.length) / this.blockSize | 0;
    var out = new Array(count * this.blockSize);
    if (this.bufferOff !== 0) {
      inputOff += this._buffer(data2, inputOff);
      if (this.bufferOff === this.buffer.length)
        outputOff += this._flushBuffer(out, outputOff);
    }
    var max2 = data2.length - (data2.length - inputOff) % this.blockSize;
    for (; inputOff < max2; inputOff += this.blockSize) {
      this._update(data2, inputOff, out, outputOff);
      outputOff += this.blockSize;
    }
    for (; inputOff < data2.length; inputOff++, this.bufferOff++)
      this.buffer[this.bufferOff] = data2[inputOff];
    return out;
  };
  Cipher.prototype._updateDecrypt = function _updateDecrypt(data2) {
    var inputOff = 0;
    var outputOff = 0;
    var count = Math.ceil((this.bufferOff + data2.length) / this.blockSize) - 1;
    var out = new Array(count * this.blockSize);
    for (; count > 0; count--) {
      inputOff += this._buffer(data2, inputOff);
      outputOff += this._flushBuffer(out, outputOff);
    }
    inputOff += this._buffer(data2, inputOff);
    return out;
  };
  Cipher.prototype.final = function final(buffer2) {
    var first;
    if (buffer2)
      first = this.update(buffer2);
    var last;
    if (this.type === "encrypt")
      last = this._finalEncrypt();
    else
      last = this._finalDecrypt();
    if (first)
      return first.concat(last);
    else
      return last;
  };
  Cipher.prototype._pad = function _pad(buffer2, off) {
    if (off === 0)
      return false;
    while (off < buffer2.length)
      buffer2[off++] = 0;
    return true;
  };
  Cipher.prototype._finalEncrypt = function _finalEncrypt() {
    if (!this._pad(this.buffer, this.bufferOff))
      return [];
    var out = new Array(this.blockSize);
    this._update(this.buffer, 0, out, 0);
    return out;
  };
  Cipher.prototype._unpad = function _unpad(buffer2) {
    return buffer2;
  };
  Cipher.prototype._finalDecrypt = function _finalDecrypt() {
    assert.equal(this.bufferOff, this.blockSize, "Not enough data to decrypt");
    var out = new Array(this.blockSize);
    this._flushBuffer(out, 0);
    return this._unpad(out);
  };
  return cipher;
}
var des;
var hasRequiredDes$1;
function requireDes$1() {
  if (hasRequiredDes$1) return des;
  hasRequiredDes$1 = 1;
  var assert = requireMinimalisticAssert();
  var inherits = requireInherits_browser();
  var utils2 = requireUtils$4();
  var Cipher = requireCipher();
  function DESState() {
    this.tmp = new Array(2);
    this.keys = null;
  }
  function DES(options2) {
    Cipher.call(this, options2);
    var state = new DESState();
    this._desState = state;
    this.deriveKeys(state, options2.key);
  }
  inherits(DES, Cipher);
  des = DES;
  DES.create = function create2(options2) {
    return new DES(options2);
  };
  var shiftTable = [
    1,
    1,
    2,
    2,
    2,
    2,
    2,
    2,
    1,
    2,
    2,
    2,
    2,
    2,
    2,
    1
  ];
  DES.prototype.deriveKeys = function deriveKeys(state, key2) {
    state.keys = new Array(16 * 2);
    assert.equal(key2.length, this.blockSize, "Invalid key length");
    var kL = utils2.readUInt32BE(key2, 0);
    var kR = utils2.readUInt32BE(key2, 4);
    utils2.pc1(kL, kR, state.tmp, 0);
    kL = state.tmp[0];
    kR = state.tmp[1];
    for (var i2 = 0; i2 < state.keys.length; i2 += 2) {
      var shift = shiftTable[i2 >>> 1];
      kL = utils2.r28shl(kL, shift);
      kR = utils2.r28shl(kR, shift);
      utils2.pc2(kL, kR, state.keys, i2);
    }
  };
  DES.prototype._update = function _update(inp, inOff, out, outOff) {
    var state = this._desState;
    var l2 = utils2.readUInt32BE(inp, inOff);
    var r2 = utils2.readUInt32BE(inp, inOff + 4);
    utils2.ip(l2, r2, state.tmp, 0);
    l2 = state.tmp[0];
    r2 = state.tmp[1];
    if (this.type === "encrypt")
      this._encrypt(state, l2, r2, state.tmp, 0);
    else
      this._decrypt(state, l2, r2, state.tmp, 0);
    l2 = state.tmp[0];
    r2 = state.tmp[1];
    utils2.writeUInt32BE(out, l2, outOff);
    utils2.writeUInt32BE(out, r2, outOff + 4);
  };
  DES.prototype._pad = function _pad(buffer2, off) {
    if (this.padding === false) {
      return false;
    }
    var value = buffer2.length - off;
    for (var i2 = off; i2 < buffer2.length; i2++)
      buffer2[i2] = value;
    return true;
  };
  DES.prototype._unpad = function _unpad(buffer2) {
    if (this.padding === false) {
      return buffer2;
    }
    var pad = buffer2[buffer2.length - 1];
    for (var i2 = buffer2.length - pad; i2 < buffer2.length; i2++)
      assert.equal(buffer2[i2], pad);
    return buffer2.slice(0, buffer2.length - pad);
  };
  DES.prototype._encrypt = function _encrypt(state, lStart, rStart, out, off) {
    var l2 = lStart;
    var r2 = rStart;
    for (var i2 = 0; i2 < state.keys.length; i2 += 2) {
      var keyL = state.keys[i2];
      var keyR = state.keys[i2 + 1];
      utils2.expand(r2, state.tmp, 0);
      keyL ^= state.tmp[0];
      keyR ^= state.tmp[1];
      var s2 = utils2.substitute(keyL, keyR);
      var f2 = utils2.permute(s2);
      var t2 = r2;
      r2 = (l2 ^ f2) >>> 0;
      l2 = t2;
    }
    utils2.rip(r2, l2, out, off);
  };
  DES.prototype._decrypt = function _decrypt(state, lStart, rStart, out, off) {
    var l2 = rStart;
    var r2 = lStart;
    for (var i2 = state.keys.length - 2; i2 >= 0; i2 -= 2) {
      var keyL = state.keys[i2];
      var keyR = state.keys[i2 + 1];
      utils2.expand(l2, state.tmp, 0);
      keyL ^= state.tmp[0];
      keyR ^= state.tmp[1];
      var s2 = utils2.substitute(keyL, keyR);
      var f2 = utils2.permute(s2);
      var t2 = l2;
      l2 = (r2 ^ f2) >>> 0;
      r2 = t2;
    }
    utils2.rip(l2, r2, out, off);
  };
  return des;
}
var cbc$1 = {};
var hasRequiredCbc$1;
function requireCbc$1() {
  if (hasRequiredCbc$1) return cbc$1;
  hasRequiredCbc$1 = 1;
  var assert = requireMinimalisticAssert();
  var inherits = requireInherits_browser();
  var proto = {};
  function CBCState(iv) {
    assert.equal(iv.length, 8, "Invalid IV length");
    this.iv = new Array(8);
    for (var i2 = 0; i2 < this.iv.length; i2++)
      this.iv[i2] = iv[i2];
  }
  function instantiate(Base) {
    function CBC(options2) {
      Base.call(this, options2);
      this._cbcInit();
    }
    inherits(CBC, Base);
    var keys = Object.keys(proto);
    for (var i2 = 0; i2 < keys.length; i2++) {
      var key2 = keys[i2];
      CBC.prototype[key2] = proto[key2];
    }
    CBC.create = function create2(options2) {
      return new CBC(options2);
    };
    return CBC;
  }
  cbc$1.instantiate = instantiate;
  proto._cbcInit = function _cbcInit() {
    var state = new CBCState(this.options.iv);
    this._cbcState = state;
  };
  proto._update = function _update(inp, inOff, out, outOff) {
    var state = this._cbcState;
    var superProto = this.constructor.super_.prototype;
    var iv = state.iv;
    if (this.type === "encrypt") {
      for (var i2 = 0; i2 < this.blockSize; i2++)
        iv[i2] ^= inp[inOff + i2];
      superProto._update.call(this, iv, 0, out, outOff);
      for (var i2 = 0; i2 < this.blockSize; i2++)
        iv[i2] = out[outOff + i2];
    } else {
      superProto._update.call(this, inp, inOff, out, outOff);
      for (var i2 = 0; i2 < this.blockSize; i2++)
        out[outOff + i2] ^= iv[i2];
      for (var i2 = 0; i2 < this.blockSize; i2++)
        iv[i2] = inp[inOff + i2];
    }
  };
  return cbc$1;
}
var ede;
var hasRequiredEde;
function requireEde() {
  if (hasRequiredEde) return ede;
  hasRequiredEde = 1;
  var assert = requireMinimalisticAssert();
  var inherits = requireInherits_browser();
  var Cipher = requireCipher();
  var DES = requireDes$1();
  function EDEState(type2, key2) {
    assert.equal(key2.length, 24, "Invalid key length");
    var k1 = key2.slice(0, 8);
    var k2 = key2.slice(8, 16);
    var k3 = key2.slice(16, 24);
    if (type2 === "encrypt") {
      this.ciphers = [
        DES.create({ type: "encrypt", key: k1 }),
        DES.create({ type: "decrypt", key: k2 }),
        DES.create({ type: "encrypt", key: k3 })
      ];
    } else {
      this.ciphers = [
        DES.create({ type: "decrypt", key: k3 }),
        DES.create({ type: "encrypt", key: k2 }),
        DES.create({ type: "decrypt", key: k1 })
      ];
    }
  }
  function EDE(options2) {
    Cipher.call(this, options2);
    var state = new EDEState(this.type, this.options.key);
    this._edeState = state;
  }
  inherits(EDE, Cipher);
  ede = EDE;
  EDE.create = function create2(options2) {
    return new EDE(options2);
  };
  EDE.prototype._update = function _update(inp, inOff, out, outOff) {
    var state = this._edeState;
    state.ciphers[0]._update(inp, inOff, out, outOff);
    state.ciphers[1]._update(out, outOff, out, outOff);
    state.ciphers[2]._update(out, outOff, out, outOff);
  };
  EDE.prototype._pad = DES.prototype._pad;
  EDE.prototype._unpad = DES.prototype._unpad;
  return ede;
}
var hasRequiredDes;
function requireDes() {
  if (hasRequiredDes) return des$1;
  hasRequiredDes = 1;
  des$1.utils = requireUtils$4();
  des$1.Cipher = requireCipher();
  des$1.DES = requireDes$1();
  des$1.CBC = requireCbc$1();
  des$1.EDE = requireEde();
  return des$1;
}
var browserifyDes;
var hasRequiredBrowserifyDes;
function requireBrowserifyDes() {
  if (hasRequiredBrowserifyDes) return browserifyDes;
  hasRequiredBrowserifyDes = 1;
  var CipherBase = requireCipherBase();
  var des2 = requireDes();
  var inherits = requireInherits_browser();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var modes2 = {
    "des-ede3-cbc": des2.CBC.instantiate(des2.EDE),
    "des-ede3": des2.EDE,
    "des-ede-cbc": des2.CBC.instantiate(des2.EDE),
    "des-ede": des2.EDE,
    "des-cbc": des2.CBC.instantiate(des2.DES),
    "des-ecb": des2.DES
  };
  modes2.des = modes2["des-cbc"];
  modes2.des3 = modes2["des-ede3-cbc"];
  browserifyDes = DES;
  inherits(DES, CipherBase);
  function DES(opts) {
    CipherBase.call(this);
    var modeName = opts.mode.toLowerCase();
    var mode = modes2[modeName];
    var type2;
    if (opts.decrypt) {
      type2 = "decrypt";
    } else {
      type2 = "encrypt";
    }
    var key2 = opts.key;
    if (!Buffer2.isBuffer(key2)) {
      key2 = Buffer2.from(key2);
    }
    if (modeName === "des-ede" || modeName === "des-ede-cbc") {
      key2 = Buffer2.concat([key2, key2.slice(0, 8)]);
    }
    var iv = opts.iv;
    if (!Buffer2.isBuffer(iv)) {
      iv = Buffer2.from(iv);
    }
    this._des = mode.create({
      key: key2,
      iv,
      type: type2
    });
  }
  DES.prototype._update = function(data2) {
    return Buffer2.from(this._des.update(data2));
  };
  DES.prototype._final = function() {
    return Buffer2.from(this._des.final());
  };
  return browserifyDes;
}
var browser$a = {};
var encrypter = {};
var ecb = {};
var hasRequiredEcb;
function requireEcb() {
  if (hasRequiredEcb) return ecb;
  hasRequiredEcb = 1;
  ecb.encrypt = function(self2, block) {
    return self2._cipher.encryptBlock(block);
  };
  ecb.decrypt = function(self2, block) {
    return self2._cipher.decryptBlock(block);
  };
  return ecb;
}
var cbc = {};
var bufferXor;
var hasRequiredBufferXor;
function requireBufferXor() {
  if (hasRequiredBufferXor) return bufferXor;
  hasRequiredBufferXor = 1;
  bufferXor = function xor2(a2, b2) {
    var length = Math.min(a2.length, b2.length);
    var buffer2 = new Buffer(length);
    for (var i2 = 0; i2 < length; ++i2) {
      buffer2[i2] = a2[i2] ^ b2[i2];
    }
    return buffer2;
  };
  return bufferXor;
}
var hasRequiredCbc;
function requireCbc() {
  if (hasRequiredCbc) return cbc;
  hasRequiredCbc = 1;
  var xor2 = requireBufferXor();
  cbc.encrypt = function(self2, block) {
    var data2 = xor2(block, self2._prev);
    self2._prev = self2._cipher.encryptBlock(data2);
    return self2._prev;
  };
  cbc.decrypt = function(self2, block) {
    var pad = self2._prev;
    self2._prev = block;
    var out = self2._cipher.decryptBlock(block);
    return xor2(out, pad);
  };
  return cbc;
}
var cfb = {};
var hasRequiredCfb;
function requireCfb() {
  if (hasRequiredCfb) return cfb;
  hasRequiredCfb = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var xor2 = requireBufferXor();
  function encryptStart(self2, data2, decrypt2) {
    var len = data2.length;
    var out = xor2(data2, self2._cache);
    self2._cache = self2._cache.slice(len);
    self2._prev = Buffer2.concat([self2._prev, decrypt2 ? data2 : out]);
    return out;
  }
  cfb.encrypt = function(self2, data2, decrypt2) {
    var out = Buffer2.allocUnsafe(0);
    var len;
    while (data2.length) {
      if (self2._cache.length === 0) {
        self2._cache = self2._cipher.encryptBlock(self2._prev);
        self2._prev = Buffer2.allocUnsafe(0);
      }
      if (self2._cache.length <= data2.length) {
        len = self2._cache.length;
        out = Buffer2.concat([out, encryptStart(self2, data2.slice(0, len), decrypt2)]);
        data2 = data2.slice(len);
      } else {
        out = Buffer2.concat([out, encryptStart(self2, data2, decrypt2)]);
        break;
      }
    }
    return out;
  };
  return cfb;
}
var cfb8 = {};
var hasRequiredCfb8;
function requireCfb8() {
  if (hasRequiredCfb8) return cfb8;
  hasRequiredCfb8 = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  function encryptByte(self2, byteParam, decrypt2) {
    var pad = self2._cipher.encryptBlock(self2._prev);
    var out = pad[0] ^ byteParam;
    self2._prev = Buffer2.concat([
      self2._prev.slice(1),
      Buffer2.from([decrypt2 ? byteParam : out])
    ]);
    return out;
  }
  cfb8.encrypt = function(self2, chunk, decrypt2) {
    var len = chunk.length;
    var out = Buffer2.allocUnsafe(len);
    var i2 = -1;
    while (++i2 < len) {
      out[i2] = encryptByte(self2, chunk[i2], decrypt2);
    }
    return out;
  };
  return cfb8;
}
var cfb1 = {};
var hasRequiredCfb1;
function requireCfb1() {
  if (hasRequiredCfb1) return cfb1;
  hasRequiredCfb1 = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  function encryptByte(self2, byteParam, decrypt2) {
    var pad;
    var i2 = -1;
    var len = 8;
    var out = 0;
    var bit, value;
    while (++i2 < len) {
      pad = self2._cipher.encryptBlock(self2._prev);
      bit = byteParam & 1 << 7 - i2 ? 128 : 0;
      value = pad[0] ^ bit;
      out += (value & 128) >> i2 % 8;
      self2._prev = shiftIn(self2._prev, decrypt2 ? bit : value);
    }
    return out;
  }
  function shiftIn(buffer2, value) {
    var len = buffer2.length;
    var i2 = -1;
    var out = Buffer2.allocUnsafe(buffer2.length);
    buffer2 = Buffer2.concat([buffer2, Buffer2.from([value])]);
    while (++i2 < len) {
      out[i2] = buffer2[i2] << 1 | buffer2[i2 + 1] >> 7;
    }
    return out;
  }
  cfb1.encrypt = function(self2, chunk, decrypt2) {
    var len = chunk.length;
    var out = Buffer2.allocUnsafe(len);
    var i2 = -1;
    while (++i2 < len) {
      out[i2] = encryptByte(self2, chunk[i2], decrypt2);
    }
    return out;
  };
  return cfb1;
}
var ofb = {};
var hasRequiredOfb;
function requireOfb() {
  if (hasRequiredOfb) return ofb;
  hasRequiredOfb = 1;
  var xor2 = requireBufferXor();
  function getBlock(self2) {
    self2._prev = self2._cipher.encryptBlock(self2._prev);
    return self2._prev;
  }
  ofb.encrypt = function(self2, chunk) {
    while (self2._cache.length < chunk.length) {
      self2._cache = Buffer.concat([self2._cache, getBlock(self2)]);
    }
    var pad = self2._cache.slice(0, chunk.length);
    self2._cache = self2._cache.slice(chunk.length);
    return xor2(chunk, pad);
  };
  return ofb;
}
var ctr = {};
var incr32_1;
var hasRequiredIncr32;
function requireIncr32() {
  if (hasRequiredIncr32) return incr32_1;
  hasRequiredIncr32 = 1;
  function incr32(iv) {
    var len = iv.length;
    var item;
    while (len--) {
      item = iv.readUInt8(len);
      if (item === 255) {
        iv.writeUInt8(0, len);
      } else {
        item++;
        iv.writeUInt8(item, len);
        break;
      }
    }
  }
  incr32_1 = incr32;
  return incr32_1;
}
var hasRequiredCtr;
function requireCtr() {
  if (hasRequiredCtr) return ctr;
  hasRequiredCtr = 1;
  var xor2 = requireBufferXor();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var incr32 = requireIncr32();
  function getBlock(self2) {
    var out = self2._cipher.encryptBlockRaw(self2._prev);
    incr32(self2._prev);
    return out;
  }
  var blockSize = 16;
  ctr.encrypt = function(self2, chunk) {
    var chunkNum = Math.ceil(chunk.length / blockSize);
    var start = self2._cache.length;
    self2._cache = Buffer2.concat([
      self2._cache,
      Buffer2.allocUnsafe(chunkNum * blockSize)
    ]);
    for (var i2 = 0; i2 < chunkNum; i2++) {
      var out = getBlock(self2);
      var offset = start + i2 * blockSize;
      self2._cache.writeUInt32BE(out[0], offset + 0);
      self2._cache.writeUInt32BE(out[1], offset + 4);
      self2._cache.writeUInt32BE(out[2], offset + 8);
      self2._cache.writeUInt32BE(out[3], offset + 12);
    }
    var pad = self2._cache.slice(0, chunk.length);
    self2._cache = self2._cache.slice(chunk.length);
    return xor2(chunk, pad);
  };
  return ctr;
}
const aes128 = { "cipher": "AES", "key": 128, "iv": 16, "mode": "CBC", "type": "block" };
const aes192 = { "cipher": "AES", "key": 192, "iv": 16, "mode": "CBC", "type": "block" };
const aes256 = { "cipher": "AES", "key": 256, "iv": 16, "mode": "CBC", "type": "block" };
const require$$2$1 = {
  "aes-128-ecb": { "cipher": "AES", "key": 128, "iv": 0, "mode": "ECB", "type": "block" },
  "aes-192-ecb": { "cipher": "AES", "key": 192, "iv": 0, "mode": "ECB", "type": "block" },
  "aes-256-ecb": { "cipher": "AES", "key": 256, "iv": 0, "mode": "ECB", "type": "block" },
  "aes-128-cbc": { "cipher": "AES", "key": 128, "iv": 16, "mode": "CBC", "type": "block" },
  "aes-192-cbc": { "cipher": "AES", "key": 192, "iv": 16, "mode": "CBC", "type": "block" },
  "aes-256-cbc": { "cipher": "AES", "key": 256, "iv": 16, "mode": "CBC", "type": "block" },
  aes128,
  aes192,
  aes256,
  "aes-128-cfb": { "cipher": "AES", "key": 128, "iv": 16, "mode": "CFB", "type": "stream" },
  "aes-192-cfb": { "cipher": "AES", "key": 192, "iv": 16, "mode": "CFB", "type": "stream" },
  "aes-256-cfb": { "cipher": "AES", "key": 256, "iv": 16, "mode": "CFB", "type": "stream" },
  "aes-128-cfb8": { "cipher": "AES", "key": 128, "iv": 16, "mode": "CFB8", "type": "stream" },
  "aes-192-cfb8": { "cipher": "AES", "key": 192, "iv": 16, "mode": "CFB8", "type": "stream" },
  "aes-256-cfb8": { "cipher": "AES", "key": 256, "iv": 16, "mode": "CFB8", "type": "stream" },
  "aes-128-cfb1": { "cipher": "AES", "key": 128, "iv": 16, "mode": "CFB1", "type": "stream" },
  "aes-192-cfb1": { "cipher": "AES", "key": 192, "iv": 16, "mode": "CFB1", "type": "stream" },
  "aes-256-cfb1": { "cipher": "AES", "key": 256, "iv": 16, "mode": "CFB1", "type": "stream" },
  "aes-128-ofb": { "cipher": "AES", "key": 128, "iv": 16, "mode": "OFB", "type": "stream" },
  "aes-192-ofb": { "cipher": "AES", "key": 192, "iv": 16, "mode": "OFB", "type": "stream" },
  "aes-256-ofb": { "cipher": "AES", "key": 256, "iv": 16, "mode": "OFB", "type": "stream" },
  "aes-128-ctr": { "cipher": "AES", "key": 128, "iv": 16, "mode": "CTR", "type": "stream" },
  "aes-192-ctr": { "cipher": "AES", "key": 192, "iv": 16, "mode": "CTR", "type": "stream" },
  "aes-256-ctr": { "cipher": "AES", "key": 256, "iv": 16, "mode": "CTR", "type": "stream" },
  "aes-128-gcm": { "cipher": "AES", "key": 128, "iv": 12, "mode": "GCM", "type": "auth" },
  "aes-192-gcm": { "cipher": "AES", "key": 192, "iv": 12, "mode": "GCM", "type": "auth" },
  "aes-256-gcm": { "cipher": "AES", "key": 256, "iv": 12, "mode": "GCM", "type": "auth" }
};
var modes_1;
var hasRequiredModes$1;
function requireModes$1() {
  if (hasRequiredModes$1) return modes_1;
  hasRequiredModes$1 = 1;
  var modeModules = {
    ECB: requireEcb(),
    CBC: requireCbc(),
    CFB: requireCfb(),
    CFB8: requireCfb8(),
    CFB1: requireCfb1(),
    OFB: requireOfb(),
    CTR: requireCtr(),
    GCM: requireCtr()
  };
  var modes2 = require$$2$1;
  for (var key2 in modes2) {
    modes2[key2].module = modeModules[modes2[key2].mode];
  }
  modes_1 = modes2;
  return modes_1;
}
var aes$2 = {};
var hasRequiredAes$1;
function requireAes$1() {
  if (hasRequiredAes$1) return aes$2;
  hasRequiredAes$1 = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  function asUInt32Array(buf) {
    if (!Buffer2.isBuffer(buf)) buf = Buffer2.from(buf);
    var len = buf.length / 4 | 0;
    var out = new Array(len);
    for (var i2 = 0; i2 < len; i2++) {
      out[i2] = buf.readUInt32BE(i2 * 4);
    }
    return out;
  }
  function scrubVec(v2) {
    for (var i2 = 0; i2 < v2.length; v2++) {
      v2[i2] = 0;
    }
  }
  function cryptBlock(M2, keySchedule, SUB_MIX, SBOX, nRounds) {
    var SUB_MIX0 = SUB_MIX[0];
    var SUB_MIX1 = SUB_MIX[1];
    var SUB_MIX2 = SUB_MIX[2];
    var SUB_MIX3 = SUB_MIX[3];
    var s0 = M2[0] ^ keySchedule[0];
    var s1 = M2[1] ^ keySchedule[1];
    var s2 = M2[2] ^ keySchedule[2];
    var s3 = M2[3] ^ keySchedule[3];
    var t0, t1, t2, t3;
    var ksRow = 4;
    for (var round2 = 1; round2 < nRounds; round2++) {
      t0 = SUB_MIX0[s0 >>> 24] ^ SUB_MIX1[s1 >>> 16 & 255] ^ SUB_MIX2[s2 >>> 8 & 255] ^ SUB_MIX3[s3 & 255] ^ keySchedule[ksRow++];
      t1 = SUB_MIX0[s1 >>> 24] ^ SUB_MIX1[s2 >>> 16 & 255] ^ SUB_MIX2[s3 >>> 8 & 255] ^ SUB_MIX3[s0 & 255] ^ keySchedule[ksRow++];
      t2 = SUB_MIX0[s2 >>> 24] ^ SUB_MIX1[s3 >>> 16 & 255] ^ SUB_MIX2[s0 >>> 8 & 255] ^ SUB_MIX3[s1 & 255] ^ keySchedule[ksRow++];
      t3 = SUB_MIX0[s3 >>> 24] ^ SUB_MIX1[s0 >>> 16 & 255] ^ SUB_MIX2[s1 >>> 8 & 255] ^ SUB_MIX3[s2 & 255] ^ keySchedule[ksRow++];
      s0 = t0;
      s1 = t1;
      s2 = t2;
      s3 = t3;
    }
    t0 = (SBOX[s0 >>> 24] << 24 | SBOX[s1 >>> 16 & 255] << 16 | SBOX[s2 >>> 8 & 255] << 8 | SBOX[s3 & 255]) ^ keySchedule[ksRow++];
    t1 = (SBOX[s1 >>> 24] << 24 | SBOX[s2 >>> 16 & 255] << 16 | SBOX[s3 >>> 8 & 255] << 8 | SBOX[s0 & 255]) ^ keySchedule[ksRow++];
    t2 = (SBOX[s2 >>> 24] << 24 | SBOX[s3 >>> 16 & 255] << 16 | SBOX[s0 >>> 8 & 255] << 8 | SBOX[s1 & 255]) ^ keySchedule[ksRow++];
    t3 = (SBOX[s3 >>> 24] << 24 | SBOX[s0 >>> 16 & 255] << 16 | SBOX[s1 >>> 8 & 255] << 8 | SBOX[s2 & 255]) ^ keySchedule[ksRow++];
    t0 = t0 >>> 0;
    t1 = t1 >>> 0;
    t2 = t2 >>> 0;
    t3 = t3 >>> 0;
    return [t0, t1, t2, t3];
  }
  var RCON = [0, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54];
  var G2 = function() {
    var d = new Array(256);
    for (var j = 0; j < 256; j++) {
      if (j < 128) {
        d[j] = j << 1;
      } else {
        d[j] = j << 1 ^ 283;
      }
    }
    var SBOX = [];
    var INV_SBOX = [];
    var SUB_MIX = [[], [], [], []];
    var INV_SUB_MIX = [[], [], [], []];
    var x2 = 0;
    var xi = 0;
    for (var i2 = 0; i2 < 256; ++i2) {
      var sx = xi ^ xi << 1 ^ xi << 2 ^ xi << 3 ^ xi << 4;
      sx = sx >>> 8 ^ sx & 255 ^ 99;
      SBOX[x2] = sx;
      INV_SBOX[sx] = x2;
      var x22 = d[x2];
      var x4 = d[x22];
      var x8 = d[x4];
      var t2 = d[sx] * 257 ^ sx * 16843008;
      SUB_MIX[0][x2] = t2 << 24 | t2 >>> 8;
      SUB_MIX[1][x2] = t2 << 16 | t2 >>> 16;
      SUB_MIX[2][x2] = t2 << 8 | t2 >>> 24;
      SUB_MIX[3][x2] = t2;
      t2 = x8 * 16843009 ^ x4 * 65537 ^ x22 * 257 ^ x2 * 16843008;
      INV_SUB_MIX[0][sx] = t2 << 24 | t2 >>> 8;
      INV_SUB_MIX[1][sx] = t2 << 16 | t2 >>> 16;
      INV_SUB_MIX[2][sx] = t2 << 8 | t2 >>> 24;
      INV_SUB_MIX[3][sx] = t2;
      if (x2 === 0) {
        x2 = xi = 1;
      } else {
        x2 = x22 ^ d[d[d[x8 ^ x22]]];
        xi ^= d[d[xi]];
      }
    }
    return {
      SBOX,
      INV_SBOX,
      SUB_MIX,
      INV_SUB_MIX
    };
  }();
  function AES(key2) {
    this._key = asUInt32Array(key2);
    this._reset();
  }
  AES.blockSize = 4 * 4;
  AES.keySize = 256 / 8;
  AES.prototype.blockSize = AES.blockSize;
  AES.prototype.keySize = AES.keySize;
  AES.prototype._reset = function() {
    var keyWords = this._key;
    var keySize = keyWords.length;
    var nRounds = keySize + 6;
    var ksRows = (nRounds + 1) * 4;
    var keySchedule = [];
    for (var k2 = 0; k2 < keySize; k2++) {
      keySchedule[k2] = keyWords[k2];
    }
    for (k2 = keySize; k2 < ksRows; k2++) {
      var t2 = keySchedule[k2 - 1];
      if (k2 % keySize === 0) {
        t2 = t2 << 8 | t2 >>> 24;
        t2 = G2.SBOX[t2 >>> 24] << 24 | G2.SBOX[t2 >>> 16 & 255] << 16 | G2.SBOX[t2 >>> 8 & 255] << 8 | G2.SBOX[t2 & 255];
        t2 ^= RCON[k2 / keySize | 0] << 24;
      } else if (keySize > 6 && k2 % keySize === 4) {
        t2 = G2.SBOX[t2 >>> 24] << 24 | G2.SBOX[t2 >>> 16 & 255] << 16 | G2.SBOX[t2 >>> 8 & 255] << 8 | G2.SBOX[t2 & 255];
      }
      keySchedule[k2] = keySchedule[k2 - keySize] ^ t2;
    }
    var invKeySchedule = [];
    for (var ik = 0; ik < ksRows; ik++) {
      var ksR = ksRows - ik;
      var tt = keySchedule[ksR - (ik % 4 ? 0 : 4)];
      if (ik < 4 || ksR <= 4) {
        invKeySchedule[ik] = tt;
      } else {
        invKeySchedule[ik] = G2.INV_SUB_MIX[0][G2.SBOX[tt >>> 24]] ^ G2.INV_SUB_MIX[1][G2.SBOX[tt >>> 16 & 255]] ^ G2.INV_SUB_MIX[2][G2.SBOX[tt >>> 8 & 255]] ^ G2.INV_SUB_MIX[3][G2.SBOX[tt & 255]];
      }
    }
    this._nRounds = nRounds;
    this._keySchedule = keySchedule;
    this._invKeySchedule = invKeySchedule;
  };
  AES.prototype.encryptBlockRaw = function(M2) {
    M2 = asUInt32Array(M2);
    return cryptBlock(M2, this._keySchedule, G2.SUB_MIX, G2.SBOX, this._nRounds);
  };
  AES.prototype.encryptBlock = function(M2) {
    var out = this.encryptBlockRaw(M2);
    var buf = Buffer2.allocUnsafe(16);
    buf.writeUInt32BE(out[0], 0);
    buf.writeUInt32BE(out[1], 4);
    buf.writeUInt32BE(out[2], 8);
    buf.writeUInt32BE(out[3], 12);
    return buf;
  };
  AES.prototype.decryptBlock = function(M2) {
    M2 = asUInt32Array(M2);
    var m1 = M2[1];
    M2[1] = M2[3];
    M2[3] = m1;
    var out = cryptBlock(M2, this._invKeySchedule, G2.INV_SUB_MIX, G2.INV_SBOX, this._nRounds);
    var buf = Buffer2.allocUnsafe(16);
    buf.writeUInt32BE(out[0], 0);
    buf.writeUInt32BE(out[3], 4);
    buf.writeUInt32BE(out[2], 8);
    buf.writeUInt32BE(out[1], 12);
    return buf;
  };
  AES.prototype.scrub = function() {
    scrubVec(this._keySchedule);
    scrubVec(this._invKeySchedule);
    scrubVec(this._key);
  };
  aes$2.AES = AES;
  return aes$2;
}
var ghash;
var hasRequiredGhash;
function requireGhash() {
  if (hasRequiredGhash) return ghash;
  hasRequiredGhash = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var ZEROES = Buffer2.alloc(16, 0);
  function toArray(buf) {
    return [
      buf.readUInt32BE(0),
      buf.readUInt32BE(4),
      buf.readUInt32BE(8),
      buf.readUInt32BE(12)
    ];
  }
  function fromArray(out) {
    var buf = Buffer2.allocUnsafe(16);
    buf.writeUInt32BE(out[0] >>> 0, 0);
    buf.writeUInt32BE(out[1] >>> 0, 4);
    buf.writeUInt32BE(out[2] >>> 0, 8);
    buf.writeUInt32BE(out[3] >>> 0, 12);
    return buf;
  }
  function GHASH(key2) {
    this.h = key2;
    this.state = Buffer2.alloc(16, 0);
    this.cache = Buffer2.allocUnsafe(0);
  }
  GHASH.prototype.ghash = function(block) {
    var i2 = -1;
    while (++i2 < block.length) {
      this.state[i2] ^= block[i2];
    }
    this._multiply();
  };
  GHASH.prototype._multiply = function() {
    var Vi = toArray(this.h);
    var Zi = [0, 0, 0, 0];
    var j, xi, lsbVi;
    var i2 = -1;
    while (++i2 < 128) {
      xi = (this.state[~~(i2 / 8)] & 1 << 7 - i2 % 8) !== 0;
      if (xi) {
        Zi[0] ^= Vi[0];
        Zi[1] ^= Vi[1];
        Zi[2] ^= Vi[2];
        Zi[3] ^= Vi[3];
      }
      lsbVi = (Vi[3] & 1) !== 0;
      for (j = 3; j > 0; j--) {
        Vi[j] = Vi[j] >>> 1 | (Vi[j - 1] & 1) << 31;
      }
      Vi[0] = Vi[0] >>> 1;
      if (lsbVi) {
        Vi[0] = Vi[0] ^ 225 << 24;
      }
    }
    this.state = fromArray(Zi);
  };
  GHASH.prototype.update = function(buf) {
    this.cache = Buffer2.concat([this.cache, buf]);
    var chunk;
    while (this.cache.length >= 16) {
      chunk = this.cache.slice(0, 16);
      this.cache = this.cache.slice(16);
      this.ghash(chunk);
    }
  };
  GHASH.prototype.final = function(abl, bl) {
    if (this.cache.length) {
      this.ghash(Buffer2.concat([this.cache, ZEROES], 16));
    }
    this.ghash(fromArray([0, abl, 0, bl]));
    return this.state;
  };
  ghash = GHASH;
  return ghash;
}
var authCipher;
var hasRequiredAuthCipher;
function requireAuthCipher() {
  if (hasRequiredAuthCipher) return authCipher;
  hasRequiredAuthCipher = 1;
  var aes2 = requireAes$1();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var Transform = requireCipherBase();
  var inherits = requireInherits_browser();
  var GHASH = requireGhash();
  var xor2 = requireBufferXor();
  var incr32 = requireIncr32();
  function xorTest(a2, b2) {
    var out = 0;
    if (a2.length !== b2.length) out++;
    var len = Math.min(a2.length, b2.length);
    for (var i2 = 0; i2 < len; ++i2) {
      out += a2[i2] ^ b2[i2];
    }
    return out;
  }
  function calcIv(self2, iv, ck) {
    if (iv.length === 12) {
      self2._finID = Buffer2.concat([iv, Buffer2.from([0, 0, 0, 1])]);
      return Buffer2.concat([iv, Buffer2.from([0, 0, 0, 2])]);
    }
    var ghash2 = new GHASH(ck);
    var len = iv.length;
    var toPad = len % 16;
    ghash2.update(iv);
    if (toPad) {
      toPad = 16 - toPad;
      ghash2.update(Buffer2.alloc(toPad, 0));
    }
    ghash2.update(Buffer2.alloc(8, 0));
    var ivBits = len * 8;
    var tail = Buffer2.alloc(8);
    tail.writeUIntBE(ivBits, 0, 8);
    ghash2.update(tail);
    self2._finID = ghash2.state;
    var out = Buffer2.from(self2._finID);
    incr32(out);
    return out;
  }
  function StreamCipher(mode, key2, iv, decrypt2) {
    Transform.call(this);
    var h2 = Buffer2.alloc(4, 0);
    this._cipher = new aes2.AES(key2);
    var ck = this._cipher.encryptBlock(h2);
    this._ghash = new GHASH(ck);
    iv = calcIv(this, iv, ck);
    this._prev = Buffer2.from(iv);
    this._cache = Buffer2.allocUnsafe(0);
    this._secCache = Buffer2.allocUnsafe(0);
    this._decrypt = decrypt2;
    this._alen = 0;
    this._len = 0;
    this._mode = mode;
    this._authTag = null;
    this._called = false;
  }
  inherits(StreamCipher, Transform);
  StreamCipher.prototype._update = function(chunk) {
    if (!this._called && this._alen) {
      var rump = 16 - this._alen % 16;
      if (rump < 16) {
        rump = Buffer2.alloc(rump, 0);
        this._ghash.update(rump);
      }
    }
    this._called = true;
    var out = this._mode.encrypt(this, chunk);
    if (this._decrypt) {
      this._ghash.update(chunk);
    } else {
      this._ghash.update(out);
    }
    this._len += chunk.length;
    return out;
  };
  StreamCipher.prototype._final = function() {
    if (this._decrypt && !this._authTag) throw new Error("Unsupported state or unable to authenticate data");
    var tag = xor2(this._ghash.final(this._alen * 8, this._len * 8), this._cipher.encryptBlock(this._finID));
    if (this._decrypt && xorTest(tag, this._authTag)) throw new Error("Unsupported state or unable to authenticate data");
    this._authTag = tag;
    this._cipher.scrub();
  };
  StreamCipher.prototype.getAuthTag = function getAuthTag() {
    if (this._decrypt || !Buffer2.isBuffer(this._authTag)) throw new Error("Attempting to get auth tag in unsupported state");
    return this._authTag;
  };
  StreamCipher.prototype.setAuthTag = function setAuthTag(tag) {
    if (!this._decrypt) throw new Error("Attempting to set auth tag in unsupported state");
    this._authTag = tag;
  };
  StreamCipher.prototype.setAAD = function setAAD(buf) {
    if (this._called) throw new Error("Attempting to set AAD in unsupported state");
    this._ghash.update(buf);
    this._alen += buf.length;
  };
  authCipher = StreamCipher;
  return authCipher;
}
var streamCipher;
var hasRequiredStreamCipher;
function requireStreamCipher() {
  if (hasRequiredStreamCipher) return streamCipher;
  hasRequiredStreamCipher = 1;
  var aes2 = requireAes$1();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var Transform = requireCipherBase();
  var inherits = requireInherits_browser();
  function StreamCipher(mode, key2, iv, decrypt2) {
    Transform.call(this);
    this._cipher = new aes2.AES(key2);
    this._prev = Buffer2.from(iv);
    this._cache = Buffer2.allocUnsafe(0);
    this._secCache = Buffer2.allocUnsafe(0);
    this._decrypt = decrypt2;
    this._mode = mode;
  }
  inherits(StreamCipher, Transform);
  StreamCipher.prototype._update = function(chunk) {
    return this._mode.encrypt(this, chunk, this._decrypt);
  };
  StreamCipher.prototype._final = function() {
    this._cipher.scrub();
  };
  streamCipher = StreamCipher;
  return streamCipher;
}
var evp_bytestokey;
var hasRequiredEvp_bytestokey;
function requireEvp_bytestokey() {
  if (hasRequiredEvp_bytestokey) return evp_bytestokey;
  hasRequiredEvp_bytestokey = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var MD5 = requireMd5_js();
  function EVP_BytesToKey(password, salt, keyBits, ivLen) {
    if (!Buffer2.isBuffer(password)) password = Buffer2.from(password, "binary");
    if (salt) {
      if (!Buffer2.isBuffer(salt)) salt = Buffer2.from(salt, "binary");
      if (salt.length !== 8) throw new RangeError("salt should be Buffer with 8 byte length");
    }
    var keyLen = keyBits / 8;
    var key2 = Buffer2.alloc(keyLen);
    var iv = Buffer2.alloc(ivLen || 0);
    var tmp = Buffer2.alloc(0);
    while (keyLen > 0 || ivLen > 0) {
      var hash2 = new MD5();
      hash2.update(tmp);
      hash2.update(password);
      if (salt) hash2.update(salt);
      tmp = hash2.digest();
      var used = 0;
      if (keyLen > 0) {
        var keyStart = key2.length - keyLen;
        used = Math.min(keyLen, tmp.length);
        tmp.copy(key2, keyStart, 0, used);
        keyLen -= used;
      }
      if (used < tmp.length && ivLen > 0) {
        var ivStart = iv.length - ivLen;
        var length = Math.min(ivLen, tmp.length - used);
        tmp.copy(iv, ivStart, used, used + length);
        ivLen -= length;
      }
    }
    tmp.fill(0);
    return { key: key2, iv };
  }
  evp_bytestokey = EVP_BytesToKey;
  return evp_bytestokey;
}
var hasRequiredEncrypter;
function requireEncrypter() {
  if (hasRequiredEncrypter) return encrypter;
  hasRequiredEncrypter = 1;
  var MODES = requireModes$1();
  var AuthCipher = requireAuthCipher();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var StreamCipher = requireStreamCipher();
  var Transform = requireCipherBase();
  var aes2 = requireAes$1();
  var ebtk = requireEvp_bytestokey();
  var inherits = requireInherits_browser();
  function Cipher(mode, key2, iv) {
    Transform.call(this);
    this._cache = new Splitter();
    this._cipher = new aes2.AES(key2);
    this._prev = Buffer2.from(iv);
    this._mode = mode;
    this._autopadding = true;
  }
  inherits(Cipher, Transform);
  Cipher.prototype._update = function(data2) {
    this._cache.add(data2);
    var chunk;
    var thing;
    var out = [];
    while (chunk = this._cache.get()) {
      thing = this._mode.encrypt(this, chunk);
      out.push(thing);
    }
    return Buffer2.concat(out);
  };
  var PADDING = Buffer2.alloc(16, 16);
  Cipher.prototype._final = function() {
    var chunk = this._cache.flush();
    if (this._autopadding) {
      chunk = this._mode.encrypt(this, chunk);
      this._cipher.scrub();
      return chunk;
    }
    if (!chunk.equals(PADDING)) {
      this._cipher.scrub();
      throw new Error("data not multiple of block length");
    }
  };
  Cipher.prototype.setAutoPadding = function(setTo) {
    this._autopadding = !!setTo;
    return this;
  };
  function Splitter() {
    this.cache = Buffer2.allocUnsafe(0);
  }
  Splitter.prototype.add = function(data2) {
    this.cache = Buffer2.concat([this.cache, data2]);
  };
  Splitter.prototype.get = function() {
    if (this.cache.length > 15) {
      var out = this.cache.slice(0, 16);
      this.cache = this.cache.slice(16);
      return out;
    }
    return null;
  };
  Splitter.prototype.flush = function() {
    var len = 16 - this.cache.length;
    var padBuff = Buffer2.allocUnsafe(len);
    var i2 = -1;
    while (++i2 < len) {
      padBuff.writeUInt8(len, i2);
    }
    return Buffer2.concat([this.cache, padBuff]);
  };
  function createCipheriv(suite, password, iv) {
    var config = MODES[suite.toLowerCase()];
    if (!config) throw new TypeError("invalid suite type");
    if (typeof password === "string") password = Buffer2.from(password);
    if (password.length !== config.key / 8) throw new TypeError("invalid key length " + password.length);
    if (typeof iv === "string") iv = Buffer2.from(iv);
    if (config.mode !== "GCM" && iv.length !== config.iv) throw new TypeError("invalid iv length " + iv.length);
    if (config.type === "stream") {
      return new StreamCipher(config.module, password, iv);
    } else if (config.type === "auth") {
      return new AuthCipher(config.module, password, iv);
    }
    return new Cipher(config.module, password, iv);
  }
  function createCipher(suite, password) {
    var config = MODES[suite.toLowerCase()];
    if (!config) throw new TypeError("invalid suite type");
    var keys = ebtk(password, false, config.key, config.iv);
    return createCipheriv(suite, keys.key, keys.iv);
  }
  encrypter.createCipheriv = createCipheriv;
  encrypter.createCipher = createCipher;
  return encrypter;
}
var decrypter = {};
var hasRequiredDecrypter;
function requireDecrypter() {
  if (hasRequiredDecrypter) return decrypter;
  hasRequiredDecrypter = 1;
  var AuthCipher = requireAuthCipher();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var MODES = requireModes$1();
  var StreamCipher = requireStreamCipher();
  var Transform = requireCipherBase();
  var aes2 = requireAes$1();
  var ebtk = requireEvp_bytestokey();
  var inherits = requireInherits_browser();
  function Decipher(mode, key2, iv) {
    Transform.call(this);
    this._cache = new Splitter();
    this._last = void 0;
    this._cipher = new aes2.AES(key2);
    this._prev = Buffer2.from(iv);
    this._mode = mode;
    this._autopadding = true;
  }
  inherits(Decipher, Transform);
  Decipher.prototype._update = function(data2) {
    this._cache.add(data2);
    var chunk;
    var thing;
    var out = [];
    while (chunk = this._cache.get(this._autopadding)) {
      thing = this._mode.decrypt(this, chunk);
      out.push(thing);
    }
    return Buffer2.concat(out);
  };
  Decipher.prototype._final = function() {
    var chunk = this._cache.flush();
    if (this._autopadding) {
      return unpad(this._mode.decrypt(this, chunk));
    } else if (chunk) {
      throw new Error("data not multiple of block length");
    }
  };
  Decipher.prototype.setAutoPadding = function(setTo) {
    this._autopadding = !!setTo;
    return this;
  };
  function Splitter() {
    this.cache = Buffer2.allocUnsafe(0);
  }
  Splitter.prototype.add = function(data2) {
    this.cache = Buffer2.concat([this.cache, data2]);
  };
  Splitter.prototype.get = function(autoPadding) {
    var out;
    if (autoPadding) {
      if (this.cache.length > 16) {
        out = this.cache.slice(0, 16);
        this.cache = this.cache.slice(16);
        return out;
      }
    } else {
      if (this.cache.length >= 16) {
        out = this.cache.slice(0, 16);
        this.cache = this.cache.slice(16);
        return out;
      }
    }
    return null;
  };
  Splitter.prototype.flush = function() {
    if (this.cache.length) return this.cache;
  };
  function unpad(last) {
    var padded = last[15];
    if (padded < 1 || padded > 16) {
      throw new Error("unable to decrypt data");
    }
    var i2 = -1;
    while (++i2 < padded) {
      if (last[i2 + (16 - padded)] !== padded) {
        throw new Error("unable to decrypt data");
      }
    }
    if (padded === 16) return;
    return last.slice(0, 16 - padded);
  }
  function createDecipheriv(suite, password, iv) {
    var config = MODES[suite.toLowerCase()];
    if (!config) throw new TypeError("invalid suite type");
    if (typeof iv === "string") iv = Buffer2.from(iv);
    if (config.mode !== "GCM" && iv.length !== config.iv) throw new TypeError("invalid iv length " + iv.length);
    if (typeof password === "string") password = Buffer2.from(password);
    if (password.length !== config.key / 8) throw new TypeError("invalid key length " + password.length);
    if (config.type === "stream") {
      return new StreamCipher(config.module, password, iv, true);
    } else if (config.type === "auth") {
      return new AuthCipher(config.module, password, iv, true);
    }
    return new Decipher(config.module, password, iv);
  }
  function createDecipher(suite, password) {
    var config = MODES[suite.toLowerCase()];
    if (!config) throw new TypeError("invalid suite type");
    var keys = ebtk(password, false, config.key, config.iv);
    return createDecipheriv(suite, keys.key, keys.iv);
  }
  decrypter.createDecipher = createDecipher;
  decrypter.createDecipheriv = createDecipheriv;
  return decrypter;
}
var hasRequiredBrowser$9;
function requireBrowser$9() {
  if (hasRequiredBrowser$9) return browser$a;
  hasRequiredBrowser$9 = 1;
  var ciphers = requireEncrypter();
  var deciphers = requireDecrypter();
  var modes2 = require$$2$1;
  function getCiphers() {
    return Object.keys(modes2);
  }
  browser$a.createCipher = browser$a.Cipher = ciphers.createCipher;
  browser$a.createCipheriv = browser$a.Cipheriv = ciphers.createCipheriv;
  browser$a.createDecipher = browser$a.Decipher = deciphers.createDecipher;
  browser$a.createDecipheriv = browser$a.Decipheriv = deciphers.createDecipheriv;
  browser$a.listCiphers = browser$a.getCiphers = getCiphers;
  return browser$a;
}
var modes = {};
var hasRequiredModes;
function requireModes() {
  if (hasRequiredModes) return modes;
  hasRequiredModes = 1;
  (function(exports) {
    exports["des-ecb"] = {
      key: 8,
      iv: 0
    };
    exports["des-cbc"] = exports.des = {
      key: 8,
      iv: 8
    };
    exports["des-ede3-cbc"] = exports.des3 = {
      key: 24,
      iv: 8
    };
    exports["des-ede3"] = {
      key: 24,
      iv: 0
    };
    exports["des-ede-cbc"] = {
      key: 16,
      iv: 8
    };
    exports["des-ede"] = {
      key: 16,
      iv: 0
    };
  })(modes);
  return modes;
}
var hasRequiredBrowser$8;
function requireBrowser$8() {
  if (hasRequiredBrowser$8) return browser$b;
  hasRequiredBrowser$8 = 1;
  var DES = requireBrowserifyDes();
  var aes2 = requireBrowser$9();
  var aesModes = requireModes$1();
  var desModes = requireModes();
  var ebtk = requireEvp_bytestokey();
  function createCipher(suite, password) {
    suite = suite.toLowerCase();
    var keyLen, ivLen;
    if (aesModes[suite]) {
      keyLen = aesModes[suite].key;
      ivLen = aesModes[suite].iv;
    } else if (desModes[suite]) {
      keyLen = desModes[suite].key * 8;
      ivLen = desModes[suite].iv;
    } else {
      throw new TypeError("invalid suite type");
    }
    var keys = ebtk(password, false, keyLen, ivLen);
    return createCipheriv(suite, keys.key, keys.iv);
  }
  function createDecipher(suite, password) {
    suite = suite.toLowerCase();
    var keyLen, ivLen;
    if (aesModes[suite]) {
      keyLen = aesModes[suite].key;
      ivLen = aesModes[suite].iv;
    } else if (desModes[suite]) {
      keyLen = desModes[suite].key * 8;
      ivLen = desModes[suite].iv;
    } else {
      throw new TypeError("invalid suite type");
    }
    var keys = ebtk(password, false, keyLen, ivLen);
    return createDecipheriv(suite, keys.key, keys.iv);
  }
  function createCipheriv(suite, key2, iv) {
    suite = suite.toLowerCase();
    if (aesModes[suite]) return aes2.createCipheriv(suite, key2, iv);
    if (desModes[suite]) return new DES({ key: key2, iv, mode: suite });
    throw new TypeError("invalid suite type");
  }
  function createDecipheriv(suite, key2, iv) {
    suite = suite.toLowerCase();
    if (aesModes[suite]) return aes2.createDecipheriv(suite, key2, iv);
    if (desModes[suite]) return new DES({ key: key2, iv, mode: suite, decrypt: true });
    throw new TypeError("invalid suite type");
  }
  function getCiphers() {
    return Object.keys(desModes).concat(aes2.getCiphers());
  }
  browser$b.createCipher = browser$b.Cipher = createCipher;
  browser$b.createCipheriv = browser$b.Cipheriv = createCipheriv;
  browser$b.createDecipher = browser$b.Decipher = createDecipher;
  browser$b.createDecipheriv = browser$b.Decipheriv = createDecipheriv;
  browser$b.listCiphers = browser$b.getCiphers = getCiphers;
  return browser$b;
}
var browser$9 = {};
var bn$3 = { exports: {} };
var bn$2 = bn$3.exports;
var hasRequiredBn$1;
function requireBn$1() {
  if (hasRequiredBn$1) return bn$3.exports;
  hasRequiredBn$1 = 1;
  (function(module2) {
    (function(module3, exports) {
      function assert(val, msg) {
        if (!val) throw new Error(msg || "Assertion failed");
      }
      function inherits(ctor, superCtor) {
        ctor.super_ = superCtor;
        var TempCtor = function() {
        };
        TempCtor.prototype = superCtor.prototype;
        ctor.prototype = new TempCtor();
        ctor.prototype.constructor = ctor;
      }
      function BN(number, base2, endian) {
        if (BN.isBN(number)) {
          return number;
        }
        this.negative = 0;
        this.words = null;
        this.length = 0;
        this.red = null;
        if (number !== null) {
          if (base2 === "le" || base2 === "be") {
            endian = base2;
            base2 = 10;
          }
          this._init(number || 0, base2 || 10, endian || "be");
        }
      }
      if (typeof module3 === "object") {
        module3.exports = BN;
      } else {
        exports.BN = BN;
      }
      BN.BN = BN;
      BN.wordSize = 26;
      var Buffer2;
      try {
        if (typeof window !== "undefined" && typeof window.Buffer !== "undefined") {
          Buffer2 = window.Buffer;
        } else {
          Buffer2 = require$$0$2.Buffer;
        }
      } catch (e4) {
      }
      BN.isBN = function isBN(num) {
        if (num instanceof BN) {
          return true;
        }
        return num !== null && typeof num === "object" && num.constructor.wordSize === BN.wordSize && Array.isArray(num.words);
      };
      BN.max = function max2(left, right) {
        if (left.cmp(right) > 0) return left;
        return right;
      };
      BN.min = function min2(left, right) {
        if (left.cmp(right) < 0) return left;
        return right;
      };
      BN.prototype._init = function init2(number, base2, endian) {
        if (typeof number === "number") {
          return this._initNumber(number, base2, endian);
        }
        if (typeof number === "object") {
          return this._initArray(number, base2, endian);
        }
        if (base2 === "hex") {
          base2 = 16;
        }
        assert(base2 === (base2 | 0) && base2 >= 2 && base2 <= 36);
        number = number.toString().replace(/\s+/g, "");
        var start = 0;
        if (number[0] === "-") {
          start++;
          this.negative = 1;
        }
        if (start < number.length) {
          if (base2 === 16) {
            this._parseHex(number, start, endian);
          } else {
            this._parseBase(number, base2, start);
            if (endian === "le") {
              this._initArray(this.toArray(), base2, endian);
            }
          }
        }
      };
      BN.prototype._initNumber = function _initNumber(number, base2, endian) {
        if (number < 0) {
          this.negative = 1;
          number = -number;
        }
        if (number < 67108864) {
          this.words = [number & 67108863];
          this.length = 1;
        } else if (number < 4503599627370496) {
          this.words = [
            number & 67108863,
            number / 67108864 & 67108863
          ];
          this.length = 2;
        } else {
          assert(number < 9007199254740992);
          this.words = [
            number & 67108863,
            number / 67108864 & 67108863,
            1
          ];
          this.length = 3;
        }
        if (endian !== "le") return;
        this._initArray(this.toArray(), base2, endian);
      };
      BN.prototype._initArray = function _initArray(number, base2, endian) {
        assert(typeof number.length === "number");
        if (number.length <= 0) {
          this.words = [0];
          this.length = 1;
          return this;
        }
        this.length = Math.ceil(number.length / 3);
        this.words = new Array(this.length);
        for (var i2 = 0; i2 < this.length; i2++) {
          this.words[i2] = 0;
        }
        var j, w;
        var off = 0;
        if (endian === "be") {
          for (i2 = number.length - 1, j = 0; i2 >= 0; i2 -= 3) {
            w = number[i2] | number[i2 - 1] << 8 | number[i2 - 2] << 16;
            this.words[j] |= w << off & 67108863;
            this.words[j + 1] = w >>> 26 - off & 67108863;
            off += 24;
            if (off >= 26) {
              off -= 26;
              j++;
            }
          }
        } else if (endian === "le") {
          for (i2 = 0, j = 0; i2 < number.length; i2 += 3) {
            w = number[i2] | number[i2 + 1] << 8 | number[i2 + 2] << 16;
            this.words[j] |= w << off & 67108863;
            this.words[j + 1] = w >>> 26 - off & 67108863;
            off += 24;
            if (off >= 26) {
              off -= 26;
              j++;
            }
          }
        }
        return this.strip();
      };
      function parseHex4Bits(string, index2) {
        var c2 = string.charCodeAt(index2);
        if (c2 >= 65 && c2 <= 70) {
          return c2 - 55;
        } else if (c2 >= 97 && c2 <= 102) {
          return c2 - 87;
        } else {
          return c2 - 48 & 15;
        }
      }
      function parseHexByte(string, lowerBound, index2) {
        var r2 = parseHex4Bits(string, index2);
        if (index2 - 1 >= lowerBound) {
          r2 |= parseHex4Bits(string, index2 - 1) << 4;
        }
        return r2;
      }
      BN.prototype._parseHex = function _parseHex(number, start, endian) {
        this.length = Math.ceil((number.length - start) / 6);
        this.words = new Array(this.length);
        for (var i2 = 0; i2 < this.length; i2++) {
          this.words[i2] = 0;
        }
        var off = 0;
        var j = 0;
        var w;
        if (endian === "be") {
          for (i2 = number.length - 1; i2 >= start; i2 -= 2) {
            w = parseHexByte(number, start, i2) << off;
            this.words[j] |= w & 67108863;
            if (off >= 18) {
              off -= 18;
              j += 1;
              this.words[j] |= w >>> 26;
            } else {
              off += 8;
            }
          }
        } else {
          var parseLength = number.length - start;
          for (i2 = parseLength % 2 === 0 ? start + 1 : start; i2 < number.length; i2 += 2) {
            w = parseHexByte(number, start, i2) << off;
            this.words[j] |= w & 67108863;
            if (off >= 18) {
              off -= 18;
              j += 1;
              this.words[j] |= w >>> 26;
            } else {
              off += 8;
            }
          }
        }
        this.strip();
      };
      function parseBase(str, start, end, mul) {
        var r2 = 0;
        var len = Math.min(str.length, end);
        for (var i2 = start; i2 < len; i2++) {
          var c2 = str.charCodeAt(i2) - 48;
          r2 *= mul;
          if (c2 >= 49) {
            r2 += c2 - 49 + 10;
          } else if (c2 >= 17) {
            r2 += c2 - 17 + 10;
          } else {
            r2 += c2;
          }
        }
        return r2;
      }
      BN.prototype._parseBase = function _parseBase(number, base2, start) {
        this.words = [0];
        this.length = 1;
        for (var limbLen = 0, limbPow = 1; limbPow <= 67108863; limbPow *= base2) {
          limbLen++;
        }
        limbLen--;
        limbPow = limbPow / base2 | 0;
        var total = number.length - start;
        var mod = total % limbLen;
        var end = Math.min(total, total - mod) + start;
        var word = 0;
        for (var i2 = start; i2 < end; i2 += limbLen) {
          word = parseBase(number, i2, i2 + limbLen, base2);
          this.imuln(limbPow);
          if (this.words[0] + word < 67108864) {
            this.words[0] += word;
          } else {
            this._iaddn(word);
          }
        }
        if (mod !== 0) {
          var pow2 = 1;
          word = parseBase(number, i2, number.length, base2);
          for (i2 = 0; i2 < mod; i2++) {
            pow2 *= base2;
          }
          this.imuln(pow2);
          if (this.words[0] + word < 67108864) {
            this.words[0] += word;
          } else {
            this._iaddn(word);
          }
        }
        this.strip();
      };
      BN.prototype.copy = function copy2(dest) {
        dest.words = new Array(this.length);
        for (var i2 = 0; i2 < this.length; i2++) {
          dest.words[i2] = this.words[i2];
        }
        dest.length = this.length;
        dest.negative = this.negative;
        dest.red = this.red;
      };
      BN.prototype.clone = function clone2() {
        var r2 = new BN(null);
        this.copy(r2);
        return r2;
      };
      BN.prototype._expand = function _expand(size) {
        while (this.length < size) {
          this.words[this.length++] = 0;
        }
        return this;
      };
      BN.prototype.strip = function strip() {
        while (this.length > 1 && this.words[this.length - 1] === 0) {
          this.length--;
        }
        return this._normSign();
      };
      BN.prototype._normSign = function _normSign() {
        if (this.length === 1 && this.words[0] === 0) {
          this.negative = 0;
        }
        return this;
      };
      BN.prototype.inspect = function inspect() {
        return (this.red ? "<BN-R: " : "<BN: ") + this.toString(16) + ">";
      };
      var zeros = [
        "",
        "0",
        "00",
        "000",
        "0000",
        "00000",
        "000000",
        "0000000",
        "00000000",
        "000000000",
        "0000000000",
        "00000000000",
        "000000000000",
        "0000000000000",
        "00000000000000",
        "000000000000000",
        "0000000000000000",
        "00000000000000000",
        "000000000000000000",
        "0000000000000000000",
        "00000000000000000000",
        "000000000000000000000",
        "0000000000000000000000",
        "00000000000000000000000",
        "000000000000000000000000",
        "0000000000000000000000000"
      ];
      var groupSizes = [
        0,
        0,
        25,
        16,
        12,
        11,
        10,
        9,
        8,
        8,
        7,
        7,
        7,
        7,
        6,
        6,
        6,
        6,
        6,
        6,
        6,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5
      ];
      var groupBases = [
        0,
        0,
        33554432,
        43046721,
        16777216,
        48828125,
        60466176,
        40353607,
        16777216,
        43046721,
        1e7,
        19487171,
        35831808,
        62748517,
        7529536,
        11390625,
        16777216,
        24137569,
        34012224,
        47045881,
        64e6,
        4084101,
        5153632,
        6436343,
        7962624,
        9765625,
        11881376,
        14348907,
        17210368,
        20511149,
        243e5,
        28629151,
        33554432,
        39135393,
        45435424,
        52521875,
        60466176
      ];
      BN.prototype.toString = function toString2(base2, padding) {
        base2 = base2 || 10;
        padding = padding | 0 || 1;
        var out;
        if (base2 === 16 || base2 === "hex") {
          out = "";
          var off = 0;
          var carry = 0;
          for (var i2 = 0; i2 < this.length; i2++) {
            var w = this.words[i2];
            var word = ((w << off | carry) & 16777215).toString(16);
            carry = w >>> 24 - off & 16777215;
            off += 2;
            if (off >= 26) {
              off -= 26;
              i2--;
            }
            if (carry !== 0 || i2 !== this.length - 1) {
              out = zeros[6 - word.length] + word + out;
            } else {
              out = word + out;
            }
          }
          if (carry !== 0) {
            out = carry.toString(16) + out;
          }
          while (out.length % padding !== 0) {
            out = "0" + out;
          }
          if (this.negative !== 0) {
            out = "-" + out;
          }
          return out;
        }
        if (base2 === (base2 | 0) && base2 >= 2 && base2 <= 36) {
          var groupSize = groupSizes[base2];
          var groupBase = groupBases[base2];
          out = "";
          var c2 = this.clone();
          c2.negative = 0;
          while (!c2.isZero()) {
            var r2 = c2.modn(groupBase).toString(base2);
            c2 = c2.idivn(groupBase);
            if (!c2.isZero()) {
              out = zeros[groupSize - r2.length] + r2 + out;
            } else {
              out = r2 + out;
            }
          }
          if (this.isZero()) {
            out = "0" + out;
          }
          while (out.length % padding !== 0) {
            out = "0" + out;
          }
          if (this.negative !== 0) {
            out = "-" + out;
          }
          return out;
        }
        assert(false, "Base should be between 2 and 36");
      };
      BN.prototype.toNumber = function toNumber() {
        var ret = this.words[0];
        if (this.length === 2) {
          ret += this.words[1] * 67108864;
        } else if (this.length === 3 && this.words[2] === 1) {
          ret += 4503599627370496 + this.words[1] * 67108864;
        } else if (this.length > 2) {
          assert(false, "Number can only safely store up to 53 bits");
        }
        return this.negative !== 0 ? -ret : ret;
      };
      BN.prototype.toJSON = function toJSON() {
        return this.toString(16);
      };
      BN.prototype.toBuffer = function toBuffer2(endian, length) {
        assert(typeof Buffer2 !== "undefined");
        return this.toArrayLike(Buffer2, endian, length);
      };
      BN.prototype.toArray = function toArray(endian, length) {
        return this.toArrayLike(Array, endian, length);
      };
      BN.prototype.toArrayLike = function toArrayLike(ArrayType, endian, length) {
        var byteLength2 = this.byteLength();
        var reqLength = length || Math.max(1, byteLength2);
        assert(byteLength2 <= reqLength, "byte array longer than desired length");
        assert(reqLength > 0, "Requested array length <= 0");
        this.strip();
        var littleEndian = endian === "le";
        var res = new ArrayType(reqLength);
        var b2, i2;
        var q = this.clone();
        if (!littleEndian) {
          for (i2 = 0; i2 < reqLength - byteLength2; i2++) {
            res[i2] = 0;
          }
          for (i2 = 0; !q.isZero(); i2++) {
            b2 = q.andln(255);
            q.iushrn(8);
            res[reqLength - i2 - 1] = b2;
          }
        } else {
          for (i2 = 0; !q.isZero(); i2++) {
            b2 = q.andln(255);
            q.iushrn(8);
            res[i2] = b2;
          }
          for (; i2 < reqLength; i2++) {
            res[i2] = 0;
          }
        }
        return res;
      };
      if (Math.clz32) {
        BN.prototype._countBits = function _countBits(w) {
          return 32 - Math.clz32(w);
        };
      } else {
        BN.prototype._countBits = function _countBits(w) {
          var t2 = w;
          var r2 = 0;
          if (t2 >= 4096) {
            r2 += 13;
            t2 >>>= 13;
          }
          if (t2 >= 64) {
            r2 += 7;
            t2 >>>= 7;
          }
          if (t2 >= 8) {
            r2 += 4;
            t2 >>>= 4;
          }
          if (t2 >= 2) {
            r2 += 2;
            t2 >>>= 2;
          }
          return r2 + t2;
        };
      }
      BN.prototype._zeroBits = function _zeroBits(w) {
        if (w === 0) return 26;
        var t2 = w;
        var r2 = 0;
        if ((t2 & 8191) === 0) {
          r2 += 13;
          t2 >>>= 13;
        }
        if ((t2 & 127) === 0) {
          r2 += 7;
          t2 >>>= 7;
        }
        if ((t2 & 15) === 0) {
          r2 += 4;
          t2 >>>= 4;
        }
        if ((t2 & 3) === 0) {
          r2 += 2;
          t2 >>>= 2;
        }
        if ((t2 & 1) === 0) {
          r2++;
        }
        return r2;
      };
      BN.prototype.bitLength = function bitLength() {
        var w = this.words[this.length - 1];
        var hi = this._countBits(w);
        return (this.length - 1) * 26 + hi;
      };
      function toBitArray(num) {
        var w = new Array(num.bitLength());
        for (var bit = 0; bit < w.length; bit++) {
          var off = bit / 26 | 0;
          var wbit = bit % 26;
          w[bit] = (num.words[off] & 1 << wbit) >>> wbit;
        }
        return w;
      }
      BN.prototype.zeroBits = function zeroBits() {
        if (this.isZero()) return 0;
        var r2 = 0;
        for (var i2 = 0; i2 < this.length; i2++) {
          var b2 = this._zeroBits(this.words[i2]);
          r2 += b2;
          if (b2 !== 26) break;
        }
        return r2;
      };
      BN.prototype.byteLength = function byteLength2() {
        return Math.ceil(this.bitLength() / 8);
      };
      BN.prototype.toTwos = function toTwos(width) {
        if (this.negative !== 0) {
          return this.abs().inotn(width).iaddn(1);
        }
        return this.clone();
      };
      BN.prototype.fromTwos = function fromTwos(width) {
        if (this.testn(width - 1)) {
          return this.notn(width).iaddn(1).ineg();
        }
        return this.clone();
      };
      BN.prototype.isNeg = function isNeg() {
        return this.negative !== 0;
      };
      BN.prototype.neg = function neg() {
        return this.clone().ineg();
      };
      BN.prototype.ineg = function ineg() {
        if (!this.isZero()) {
          this.negative ^= 1;
        }
        return this;
      };
      BN.prototype.iuor = function iuor(num) {
        while (this.length < num.length) {
          this.words[this.length++] = 0;
        }
        for (var i2 = 0; i2 < num.length; i2++) {
          this.words[i2] = this.words[i2] | num.words[i2];
        }
        return this.strip();
      };
      BN.prototype.ior = function ior(num) {
        assert((this.negative | num.negative) === 0);
        return this.iuor(num);
      };
      BN.prototype.or = function or2(num) {
        if (this.length > num.length) return this.clone().ior(num);
        return num.clone().ior(this);
      };
      BN.prototype.uor = function uor(num) {
        if (this.length > num.length) return this.clone().iuor(num);
        return num.clone().iuor(this);
      };
      BN.prototype.iuand = function iuand(num) {
        var b2;
        if (this.length > num.length) {
          b2 = num;
        } else {
          b2 = this;
        }
        for (var i2 = 0; i2 < b2.length; i2++) {
          this.words[i2] = this.words[i2] & num.words[i2];
        }
        this.length = b2.length;
        return this.strip();
      };
      BN.prototype.iand = function iand(num) {
        assert((this.negative | num.negative) === 0);
        return this.iuand(num);
      };
      BN.prototype.and = function and2(num) {
        if (this.length > num.length) return this.clone().iand(num);
        return num.clone().iand(this);
      };
      BN.prototype.uand = function uand(num) {
        if (this.length > num.length) return this.clone().iuand(num);
        return num.clone().iuand(this);
      };
      BN.prototype.iuxor = function iuxor(num) {
        var a2;
        var b2;
        if (this.length > num.length) {
          a2 = this;
          b2 = num;
        } else {
          a2 = num;
          b2 = this;
        }
        for (var i2 = 0; i2 < b2.length; i2++) {
          this.words[i2] = a2.words[i2] ^ b2.words[i2];
        }
        if (this !== a2) {
          for (; i2 < a2.length; i2++) {
            this.words[i2] = a2.words[i2];
          }
        }
        this.length = a2.length;
        return this.strip();
      };
      BN.prototype.ixor = function ixor(num) {
        assert((this.negative | num.negative) === 0);
        return this.iuxor(num);
      };
      BN.prototype.xor = function xor2(num) {
        if (this.length > num.length) return this.clone().ixor(num);
        return num.clone().ixor(this);
      };
      BN.prototype.uxor = function uxor(num) {
        if (this.length > num.length) return this.clone().iuxor(num);
        return num.clone().iuxor(this);
      };
      BN.prototype.inotn = function inotn(width) {
        assert(typeof width === "number" && width >= 0);
        var bytesNeeded = Math.ceil(width / 26) | 0;
        var bitsLeft = width % 26;
        this._expand(bytesNeeded);
        if (bitsLeft > 0) {
          bytesNeeded--;
        }
        for (var i2 = 0; i2 < bytesNeeded; i2++) {
          this.words[i2] = ~this.words[i2] & 67108863;
        }
        if (bitsLeft > 0) {
          this.words[i2] = ~this.words[i2] & 67108863 >> 26 - bitsLeft;
        }
        return this.strip();
      };
      BN.prototype.notn = function notn(width) {
        return this.clone().inotn(width);
      };
      BN.prototype.setn = function setn(bit, val) {
        assert(typeof bit === "number" && bit >= 0);
        var off = bit / 26 | 0;
        var wbit = bit % 26;
        this._expand(off + 1);
        if (val) {
          this.words[off] = this.words[off] | 1 << wbit;
        } else {
          this.words[off] = this.words[off] & ~(1 << wbit);
        }
        return this.strip();
      };
      BN.prototype.iadd = function iadd(num) {
        var r2;
        if (this.negative !== 0 && num.negative === 0) {
          this.negative = 0;
          r2 = this.isub(num);
          this.negative ^= 1;
          return this._normSign();
        } else if (this.negative === 0 && num.negative !== 0) {
          num.negative = 0;
          r2 = this.isub(num);
          num.negative = 1;
          return r2._normSign();
        }
        var a2, b2;
        if (this.length > num.length) {
          a2 = this;
          b2 = num;
        } else {
          a2 = num;
          b2 = this;
        }
        var carry = 0;
        for (var i2 = 0; i2 < b2.length; i2++) {
          r2 = (a2.words[i2] | 0) + (b2.words[i2] | 0) + carry;
          this.words[i2] = r2 & 67108863;
          carry = r2 >>> 26;
        }
        for (; carry !== 0 && i2 < a2.length; i2++) {
          r2 = (a2.words[i2] | 0) + carry;
          this.words[i2] = r2 & 67108863;
          carry = r2 >>> 26;
        }
        this.length = a2.length;
        if (carry !== 0) {
          this.words[this.length] = carry;
          this.length++;
        } else if (a2 !== this) {
          for (; i2 < a2.length; i2++) {
            this.words[i2] = a2.words[i2];
          }
        }
        return this;
      };
      BN.prototype.add = function add2(num) {
        var res;
        if (num.negative !== 0 && this.negative === 0) {
          num.negative = 0;
          res = this.sub(num);
          num.negative ^= 1;
          return res;
        } else if (num.negative === 0 && this.negative !== 0) {
          this.negative = 0;
          res = num.sub(this);
          this.negative = 1;
          return res;
        }
        if (this.length > num.length) return this.clone().iadd(num);
        return num.clone().iadd(this);
      };
      BN.prototype.isub = function isub(num) {
        if (num.negative !== 0) {
          num.negative = 0;
          var r2 = this.iadd(num);
          num.negative = 1;
          return r2._normSign();
        } else if (this.negative !== 0) {
          this.negative = 0;
          this.iadd(num);
          this.negative = 1;
          return this._normSign();
        }
        var cmp = this.cmp(num);
        if (cmp === 0) {
          this.negative = 0;
          this.length = 1;
          this.words[0] = 0;
          return this;
        }
        var a2, b2;
        if (cmp > 0) {
          a2 = this;
          b2 = num;
        } else {
          a2 = num;
          b2 = this;
        }
        var carry = 0;
        for (var i2 = 0; i2 < b2.length; i2++) {
          r2 = (a2.words[i2] | 0) - (b2.words[i2] | 0) + carry;
          carry = r2 >> 26;
          this.words[i2] = r2 & 67108863;
        }
        for (; carry !== 0 && i2 < a2.length; i2++) {
          r2 = (a2.words[i2] | 0) + carry;
          carry = r2 >> 26;
          this.words[i2] = r2 & 67108863;
        }
        if (carry === 0 && i2 < a2.length && a2 !== this) {
          for (; i2 < a2.length; i2++) {
            this.words[i2] = a2.words[i2];
          }
        }
        this.length = Math.max(this.length, i2);
        if (a2 !== this) {
          this.negative = 1;
        }
        return this.strip();
      };
      BN.prototype.sub = function sub(num) {
        return this.clone().isub(num);
      };
      function smallMulTo(self2, num, out) {
        out.negative = num.negative ^ self2.negative;
        var len = self2.length + num.length | 0;
        out.length = len;
        len = len - 1 | 0;
        var a2 = self2.words[0] | 0;
        var b2 = num.words[0] | 0;
        var r2 = a2 * b2;
        var lo = r2 & 67108863;
        var carry = r2 / 67108864 | 0;
        out.words[0] = lo;
        for (var k2 = 1; k2 < len; k2++) {
          var ncarry = carry >>> 26;
          var rword = carry & 67108863;
          var maxJ = Math.min(k2, num.length - 1);
          for (var j = Math.max(0, k2 - self2.length + 1); j <= maxJ; j++) {
            var i2 = k2 - j | 0;
            a2 = self2.words[i2] | 0;
            b2 = num.words[j] | 0;
            r2 = a2 * b2 + rword;
            ncarry += r2 / 67108864 | 0;
            rword = r2 & 67108863;
          }
          out.words[k2] = rword | 0;
          carry = ncarry | 0;
        }
        if (carry !== 0) {
          out.words[k2] = carry | 0;
        } else {
          out.length--;
        }
        return out.strip();
      }
      var comb10MulTo = function comb10MulTo2(self2, num, out) {
        var a2 = self2.words;
        var b2 = num.words;
        var o2 = out.words;
        var c2 = 0;
        var lo;
        var mid;
        var hi;
        var a0 = a2[0] | 0;
        var al0 = a0 & 8191;
        var ah0 = a0 >>> 13;
        var a1 = a2[1] | 0;
        var al1 = a1 & 8191;
        var ah1 = a1 >>> 13;
        var a22 = a2[2] | 0;
        var al2 = a22 & 8191;
        var ah2 = a22 >>> 13;
        var a3 = a2[3] | 0;
        var al3 = a3 & 8191;
        var ah3 = a3 >>> 13;
        var a4 = a2[4] | 0;
        var al4 = a4 & 8191;
        var ah4 = a4 >>> 13;
        var a5 = a2[5] | 0;
        var al5 = a5 & 8191;
        var ah5 = a5 >>> 13;
        var a6 = a2[6] | 0;
        var al6 = a6 & 8191;
        var ah6 = a6 >>> 13;
        var a7 = a2[7] | 0;
        var al7 = a7 & 8191;
        var ah7 = a7 >>> 13;
        var a8 = a2[8] | 0;
        var al8 = a8 & 8191;
        var ah8 = a8 >>> 13;
        var a9 = a2[9] | 0;
        var al9 = a9 & 8191;
        var ah9 = a9 >>> 13;
        var b0 = b2[0] | 0;
        var bl0 = b0 & 8191;
        var bh0 = b0 >>> 13;
        var b1 = b2[1] | 0;
        var bl1 = b1 & 8191;
        var bh1 = b1 >>> 13;
        var b22 = b2[2] | 0;
        var bl2 = b22 & 8191;
        var bh2 = b22 >>> 13;
        var b3 = b2[3] | 0;
        var bl3 = b3 & 8191;
        var bh3 = b3 >>> 13;
        var b4 = b2[4] | 0;
        var bl4 = b4 & 8191;
        var bh4 = b4 >>> 13;
        var b5 = b2[5] | 0;
        var bl5 = b5 & 8191;
        var bh5 = b5 >>> 13;
        var b6 = b2[6] | 0;
        var bl6 = b6 & 8191;
        var bh6 = b6 >>> 13;
        var b7 = b2[7] | 0;
        var bl7 = b7 & 8191;
        var bh7 = b7 >>> 13;
        var b8 = b2[8] | 0;
        var bl8 = b8 & 8191;
        var bh8 = b8 >>> 13;
        var b9 = b2[9] | 0;
        var bl9 = b9 & 8191;
        var bh9 = b9 >>> 13;
        out.negative = self2.negative ^ num.negative;
        out.length = 19;
        lo = Math.imul(al0, bl0);
        mid = Math.imul(al0, bh0);
        mid = mid + Math.imul(ah0, bl0) | 0;
        hi = Math.imul(ah0, bh0);
        var w0 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w0 >>> 26) | 0;
        w0 &= 67108863;
        lo = Math.imul(al1, bl0);
        mid = Math.imul(al1, bh0);
        mid = mid + Math.imul(ah1, bl0) | 0;
        hi = Math.imul(ah1, bh0);
        lo = lo + Math.imul(al0, bl1) | 0;
        mid = mid + Math.imul(al0, bh1) | 0;
        mid = mid + Math.imul(ah0, bl1) | 0;
        hi = hi + Math.imul(ah0, bh1) | 0;
        var w1 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w1 >>> 26) | 0;
        w1 &= 67108863;
        lo = Math.imul(al2, bl0);
        mid = Math.imul(al2, bh0);
        mid = mid + Math.imul(ah2, bl0) | 0;
        hi = Math.imul(ah2, bh0);
        lo = lo + Math.imul(al1, bl1) | 0;
        mid = mid + Math.imul(al1, bh1) | 0;
        mid = mid + Math.imul(ah1, bl1) | 0;
        hi = hi + Math.imul(ah1, bh1) | 0;
        lo = lo + Math.imul(al0, bl2) | 0;
        mid = mid + Math.imul(al0, bh2) | 0;
        mid = mid + Math.imul(ah0, bl2) | 0;
        hi = hi + Math.imul(ah0, bh2) | 0;
        var w2 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w2 >>> 26) | 0;
        w2 &= 67108863;
        lo = Math.imul(al3, bl0);
        mid = Math.imul(al3, bh0);
        mid = mid + Math.imul(ah3, bl0) | 0;
        hi = Math.imul(ah3, bh0);
        lo = lo + Math.imul(al2, bl1) | 0;
        mid = mid + Math.imul(al2, bh1) | 0;
        mid = mid + Math.imul(ah2, bl1) | 0;
        hi = hi + Math.imul(ah2, bh1) | 0;
        lo = lo + Math.imul(al1, bl2) | 0;
        mid = mid + Math.imul(al1, bh2) | 0;
        mid = mid + Math.imul(ah1, bl2) | 0;
        hi = hi + Math.imul(ah1, bh2) | 0;
        lo = lo + Math.imul(al0, bl3) | 0;
        mid = mid + Math.imul(al0, bh3) | 0;
        mid = mid + Math.imul(ah0, bl3) | 0;
        hi = hi + Math.imul(ah0, bh3) | 0;
        var w3 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w3 >>> 26) | 0;
        w3 &= 67108863;
        lo = Math.imul(al4, bl0);
        mid = Math.imul(al4, bh0);
        mid = mid + Math.imul(ah4, bl0) | 0;
        hi = Math.imul(ah4, bh0);
        lo = lo + Math.imul(al3, bl1) | 0;
        mid = mid + Math.imul(al3, bh1) | 0;
        mid = mid + Math.imul(ah3, bl1) | 0;
        hi = hi + Math.imul(ah3, bh1) | 0;
        lo = lo + Math.imul(al2, bl2) | 0;
        mid = mid + Math.imul(al2, bh2) | 0;
        mid = mid + Math.imul(ah2, bl2) | 0;
        hi = hi + Math.imul(ah2, bh2) | 0;
        lo = lo + Math.imul(al1, bl3) | 0;
        mid = mid + Math.imul(al1, bh3) | 0;
        mid = mid + Math.imul(ah1, bl3) | 0;
        hi = hi + Math.imul(ah1, bh3) | 0;
        lo = lo + Math.imul(al0, bl4) | 0;
        mid = mid + Math.imul(al0, bh4) | 0;
        mid = mid + Math.imul(ah0, bl4) | 0;
        hi = hi + Math.imul(ah0, bh4) | 0;
        var w4 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w4 >>> 26) | 0;
        w4 &= 67108863;
        lo = Math.imul(al5, bl0);
        mid = Math.imul(al5, bh0);
        mid = mid + Math.imul(ah5, bl0) | 0;
        hi = Math.imul(ah5, bh0);
        lo = lo + Math.imul(al4, bl1) | 0;
        mid = mid + Math.imul(al4, bh1) | 0;
        mid = mid + Math.imul(ah4, bl1) | 0;
        hi = hi + Math.imul(ah4, bh1) | 0;
        lo = lo + Math.imul(al3, bl2) | 0;
        mid = mid + Math.imul(al3, bh2) | 0;
        mid = mid + Math.imul(ah3, bl2) | 0;
        hi = hi + Math.imul(ah3, bh2) | 0;
        lo = lo + Math.imul(al2, bl3) | 0;
        mid = mid + Math.imul(al2, bh3) | 0;
        mid = mid + Math.imul(ah2, bl3) | 0;
        hi = hi + Math.imul(ah2, bh3) | 0;
        lo = lo + Math.imul(al1, bl4) | 0;
        mid = mid + Math.imul(al1, bh4) | 0;
        mid = mid + Math.imul(ah1, bl4) | 0;
        hi = hi + Math.imul(ah1, bh4) | 0;
        lo = lo + Math.imul(al0, bl5) | 0;
        mid = mid + Math.imul(al0, bh5) | 0;
        mid = mid + Math.imul(ah0, bl5) | 0;
        hi = hi + Math.imul(ah0, bh5) | 0;
        var w5 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w5 >>> 26) | 0;
        w5 &= 67108863;
        lo = Math.imul(al6, bl0);
        mid = Math.imul(al6, bh0);
        mid = mid + Math.imul(ah6, bl0) | 0;
        hi = Math.imul(ah6, bh0);
        lo = lo + Math.imul(al5, bl1) | 0;
        mid = mid + Math.imul(al5, bh1) | 0;
        mid = mid + Math.imul(ah5, bl1) | 0;
        hi = hi + Math.imul(ah5, bh1) | 0;
        lo = lo + Math.imul(al4, bl2) | 0;
        mid = mid + Math.imul(al4, bh2) | 0;
        mid = mid + Math.imul(ah4, bl2) | 0;
        hi = hi + Math.imul(ah4, bh2) | 0;
        lo = lo + Math.imul(al3, bl3) | 0;
        mid = mid + Math.imul(al3, bh3) | 0;
        mid = mid + Math.imul(ah3, bl3) | 0;
        hi = hi + Math.imul(ah3, bh3) | 0;
        lo = lo + Math.imul(al2, bl4) | 0;
        mid = mid + Math.imul(al2, bh4) | 0;
        mid = mid + Math.imul(ah2, bl4) | 0;
        hi = hi + Math.imul(ah2, bh4) | 0;
        lo = lo + Math.imul(al1, bl5) | 0;
        mid = mid + Math.imul(al1, bh5) | 0;
        mid = mid + Math.imul(ah1, bl5) | 0;
        hi = hi + Math.imul(ah1, bh5) | 0;
        lo = lo + Math.imul(al0, bl6) | 0;
        mid = mid + Math.imul(al0, bh6) | 0;
        mid = mid + Math.imul(ah0, bl6) | 0;
        hi = hi + Math.imul(ah0, bh6) | 0;
        var w6 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w6 >>> 26) | 0;
        w6 &= 67108863;
        lo = Math.imul(al7, bl0);
        mid = Math.imul(al7, bh0);
        mid = mid + Math.imul(ah7, bl0) | 0;
        hi = Math.imul(ah7, bh0);
        lo = lo + Math.imul(al6, bl1) | 0;
        mid = mid + Math.imul(al6, bh1) | 0;
        mid = mid + Math.imul(ah6, bl1) | 0;
        hi = hi + Math.imul(ah6, bh1) | 0;
        lo = lo + Math.imul(al5, bl2) | 0;
        mid = mid + Math.imul(al5, bh2) | 0;
        mid = mid + Math.imul(ah5, bl2) | 0;
        hi = hi + Math.imul(ah5, bh2) | 0;
        lo = lo + Math.imul(al4, bl3) | 0;
        mid = mid + Math.imul(al4, bh3) | 0;
        mid = mid + Math.imul(ah4, bl3) | 0;
        hi = hi + Math.imul(ah4, bh3) | 0;
        lo = lo + Math.imul(al3, bl4) | 0;
        mid = mid + Math.imul(al3, bh4) | 0;
        mid = mid + Math.imul(ah3, bl4) | 0;
        hi = hi + Math.imul(ah3, bh4) | 0;
        lo = lo + Math.imul(al2, bl5) | 0;
        mid = mid + Math.imul(al2, bh5) | 0;
        mid = mid + Math.imul(ah2, bl5) | 0;
        hi = hi + Math.imul(ah2, bh5) | 0;
        lo = lo + Math.imul(al1, bl6) | 0;
        mid = mid + Math.imul(al1, bh6) | 0;
        mid = mid + Math.imul(ah1, bl6) | 0;
        hi = hi + Math.imul(ah1, bh6) | 0;
        lo = lo + Math.imul(al0, bl7) | 0;
        mid = mid + Math.imul(al0, bh7) | 0;
        mid = mid + Math.imul(ah0, bl7) | 0;
        hi = hi + Math.imul(ah0, bh7) | 0;
        var w7 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w7 >>> 26) | 0;
        w7 &= 67108863;
        lo = Math.imul(al8, bl0);
        mid = Math.imul(al8, bh0);
        mid = mid + Math.imul(ah8, bl0) | 0;
        hi = Math.imul(ah8, bh0);
        lo = lo + Math.imul(al7, bl1) | 0;
        mid = mid + Math.imul(al7, bh1) | 0;
        mid = mid + Math.imul(ah7, bl1) | 0;
        hi = hi + Math.imul(ah7, bh1) | 0;
        lo = lo + Math.imul(al6, bl2) | 0;
        mid = mid + Math.imul(al6, bh2) | 0;
        mid = mid + Math.imul(ah6, bl2) | 0;
        hi = hi + Math.imul(ah6, bh2) | 0;
        lo = lo + Math.imul(al5, bl3) | 0;
        mid = mid + Math.imul(al5, bh3) | 0;
        mid = mid + Math.imul(ah5, bl3) | 0;
        hi = hi + Math.imul(ah5, bh3) | 0;
        lo = lo + Math.imul(al4, bl4) | 0;
        mid = mid + Math.imul(al4, bh4) | 0;
        mid = mid + Math.imul(ah4, bl4) | 0;
        hi = hi + Math.imul(ah4, bh4) | 0;
        lo = lo + Math.imul(al3, bl5) | 0;
        mid = mid + Math.imul(al3, bh5) | 0;
        mid = mid + Math.imul(ah3, bl5) | 0;
        hi = hi + Math.imul(ah3, bh5) | 0;
        lo = lo + Math.imul(al2, bl6) | 0;
        mid = mid + Math.imul(al2, bh6) | 0;
        mid = mid + Math.imul(ah2, bl6) | 0;
        hi = hi + Math.imul(ah2, bh6) | 0;
        lo = lo + Math.imul(al1, bl7) | 0;
        mid = mid + Math.imul(al1, bh7) | 0;
        mid = mid + Math.imul(ah1, bl7) | 0;
        hi = hi + Math.imul(ah1, bh7) | 0;
        lo = lo + Math.imul(al0, bl8) | 0;
        mid = mid + Math.imul(al0, bh8) | 0;
        mid = mid + Math.imul(ah0, bl8) | 0;
        hi = hi + Math.imul(ah0, bh8) | 0;
        var w8 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w8 >>> 26) | 0;
        w8 &= 67108863;
        lo = Math.imul(al9, bl0);
        mid = Math.imul(al9, bh0);
        mid = mid + Math.imul(ah9, bl0) | 0;
        hi = Math.imul(ah9, bh0);
        lo = lo + Math.imul(al8, bl1) | 0;
        mid = mid + Math.imul(al8, bh1) | 0;
        mid = mid + Math.imul(ah8, bl1) | 0;
        hi = hi + Math.imul(ah8, bh1) | 0;
        lo = lo + Math.imul(al7, bl2) | 0;
        mid = mid + Math.imul(al7, bh2) | 0;
        mid = mid + Math.imul(ah7, bl2) | 0;
        hi = hi + Math.imul(ah7, bh2) | 0;
        lo = lo + Math.imul(al6, bl3) | 0;
        mid = mid + Math.imul(al6, bh3) | 0;
        mid = mid + Math.imul(ah6, bl3) | 0;
        hi = hi + Math.imul(ah6, bh3) | 0;
        lo = lo + Math.imul(al5, bl4) | 0;
        mid = mid + Math.imul(al5, bh4) | 0;
        mid = mid + Math.imul(ah5, bl4) | 0;
        hi = hi + Math.imul(ah5, bh4) | 0;
        lo = lo + Math.imul(al4, bl5) | 0;
        mid = mid + Math.imul(al4, bh5) | 0;
        mid = mid + Math.imul(ah4, bl5) | 0;
        hi = hi + Math.imul(ah4, bh5) | 0;
        lo = lo + Math.imul(al3, bl6) | 0;
        mid = mid + Math.imul(al3, bh6) | 0;
        mid = mid + Math.imul(ah3, bl6) | 0;
        hi = hi + Math.imul(ah3, bh6) | 0;
        lo = lo + Math.imul(al2, bl7) | 0;
        mid = mid + Math.imul(al2, bh7) | 0;
        mid = mid + Math.imul(ah2, bl7) | 0;
        hi = hi + Math.imul(ah2, bh7) | 0;
        lo = lo + Math.imul(al1, bl8) | 0;
        mid = mid + Math.imul(al1, bh8) | 0;
        mid = mid + Math.imul(ah1, bl8) | 0;
        hi = hi + Math.imul(ah1, bh8) | 0;
        lo = lo + Math.imul(al0, bl9) | 0;
        mid = mid + Math.imul(al0, bh9) | 0;
        mid = mid + Math.imul(ah0, bl9) | 0;
        hi = hi + Math.imul(ah0, bh9) | 0;
        var w9 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w9 >>> 26) | 0;
        w9 &= 67108863;
        lo = Math.imul(al9, bl1);
        mid = Math.imul(al9, bh1);
        mid = mid + Math.imul(ah9, bl1) | 0;
        hi = Math.imul(ah9, bh1);
        lo = lo + Math.imul(al8, bl2) | 0;
        mid = mid + Math.imul(al8, bh2) | 0;
        mid = mid + Math.imul(ah8, bl2) | 0;
        hi = hi + Math.imul(ah8, bh2) | 0;
        lo = lo + Math.imul(al7, bl3) | 0;
        mid = mid + Math.imul(al7, bh3) | 0;
        mid = mid + Math.imul(ah7, bl3) | 0;
        hi = hi + Math.imul(ah7, bh3) | 0;
        lo = lo + Math.imul(al6, bl4) | 0;
        mid = mid + Math.imul(al6, bh4) | 0;
        mid = mid + Math.imul(ah6, bl4) | 0;
        hi = hi + Math.imul(ah6, bh4) | 0;
        lo = lo + Math.imul(al5, bl5) | 0;
        mid = mid + Math.imul(al5, bh5) | 0;
        mid = mid + Math.imul(ah5, bl5) | 0;
        hi = hi + Math.imul(ah5, bh5) | 0;
        lo = lo + Math.imul(al4, bl6) | 0;
        mid = mid + Math.imul(al4, bh6) | 0;
        mid = mid + Math.imul(ah4, bl6) | 0;
        hi = hi + Math.imul(ah4, bh6) | 0;
        lo = lo + Math.imul(al3, bl7) | 0;
        mid = mid + Math.imul(al3, bh7) | 0;
        mid = mid + Math.imul(ah3, bl7) | 0;
        hi = hi + Math.imul(ah3, bh7) | 0;
        lo = lo + Math.imul(al2, bl8) | 0;
        mid = mid + Math.imul(al2, bh8) | 0;
        mid = mid + Math.imul(ah2, bl8) | 0;
        hi = hi + Math.imul(ah2, bh8) | 0;
        lo = lo + Math.imul(al1, bl9) | 0;
        mid = mid + Math.imul(al1, bh9) | 0;
        mid = mid + Math.imul(ah1, bl9) | 0;
        hi = hi + Math.imul(ah1, bh9) | 0;
        var w10 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w10 >>> 26) | 0;
        w10 &= 67108863;
        lo = Math.imul(al9, bl2);
        mid = Math.imul(al9, bh2);
        mid = mid + Math.imul(ah9, bl2) | 0;
        hi = Math.imul(ah9, bh2);
        lo = lo + Math.imul(al8, bl3) | 0;
        mid = mid + Math.imul(al8, bh3) | 0;
        mid = mid + Math.imul(ah8, bl3) | 0;
        hi = hi + Math.imul(ah8, bh3) | 0;
        lo = lo + Math.imul(al7, bl4) | 0;
        mid = mid + Math.imul(al7, bh4) | 0;
        mid = mid + Math.imul(ah7, bl4) | 0;
        hi = hi + Math.imul(ah7, bh4) | 0;
        lo = lo + Math.imul(al6, bl5) | 0;
        mid = mid + Math.imul(al6, bh5) | 0;
        mid = mid + Math.imul(ah6, bl5) | 0;
        hi = hi + Math.imul(ah6, bh5) | 0;
        lo = lo + Math.imul(al5, bl6) | 0;
        mid = mid + Math.imul(al5, bh6) | 0;
        mid = mid + Math.imul(ah5, bl6) | 0;
        hi = hi + Math.imul(ah5, bh6) | 0;
        lo = lo + Math.imul(al4, bl7) | 0;
        mid = mid + Math.imul(al4, bh7) | 0;
        mid = mid + Math.imul(ah4, bl7) | 0;
        hi = hi + Math.imul(ah4, bh7) | 0;
        lo = lo + Math.imul(al3, bl8) | 0;
        mid = mid + Math.imul(al3, bh8) | 0;
        mid = mid + Math.imul(ah3, bl8) | 0;
        hi = hi + Math.imul(ah3, bh8) | 0;
        lo = lo + Math.imul(al2, bl9) | 0;
        mid = mid + Math.imul(al2, bh9) | 0;
        mid = mid + Math.imul(ah2, bl9) | 0;
        hi = hi + Math.imul(ah2, bh9) | 0;
        var w11 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w11 >>> 26) | 0;
        w11 &= 67108863;
        lo = Math.imul(al9, bl3);
        mid = Math.imul(al9, bh3);
        mid = mid + Math.imul(ah9, bl3) | 0;
        hi = Math.imul(ah9, bh3);
        lo = lo + Math.imul(al8, bl4) | 0;
        mid = mid + Math.imul(al8, bh4) | 0;
        mid = mid + Math.imul(ah8, bl4) | 0;
        hi = hi + Math.imul(ah8, bh4) | 0;
        lo = lo + Math.imul(al7, bl5) | 0;
        mid = mid + Math.imul(al7, bh5) | 0;
        mid = mid + Math.imul(ah7, bl5) | 0;
        hi = hi + Math.imul(ah7, bh5) | 0;
        lo = lo + Math.imul(al6, bl6) | 0;
        mid = mid + Math.imul(al6, bh6) | 0;
        mid = mid + Math.imul(ah6, bl6) | 0;
        hi = hi + Math.imul(ah6, bh6) | 0;
        lo = lo + Math.imul(al5, bl7) | 0;
        mid = mid + Math.imul(al5, bh7) | 0;
        mid = mid + Math.imul(ah5, bl7) | 0;
        hi = hi + Math.imul(ah5, bh7) | 0;
        lo = lo + Math.imul(al4, bl8) | 0;
        mid = mid + Math.imul(al4, bh8) | 0;
        mid = mid + Math.imul(ah4, bl8) | 0;
        hi = hi + Math.imul(ah4, bh8) | 0;
        lo = lo + Math.imul(al3, bl9) | 0;
        mid = mid + Math.imul(al3, bh9) | 0;
        mid = mid + Math.imul(ah3, bl9) | 0;
        hi = hi + Math.imul(ah3, bh9) | 0;
        var w12 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w12 >>> 26) | 0;
        w12 &= 67108863;
        lo = Math.imul(al9, bl4);
        mid = Math.imul(al9, bh4);
        mid = mid + Math.imul(ah9, bl4) | 0;
        hi = Math.imul(ah9, bh4);
        lo = lo + Math.imul(al8, bl5) | 0;
        mid = mid + Math.imul(al8, bh5) | 0;
        mid = mid + Math.imul(ah8, bl5) | 0;
        hi = hi + Math.imul(ah8, bh5) | 0;
        lo = lo + Math.imul(al7, bl6) | 0;
        mid = mid + Math.imul(al7, bh6) | 0;
        mid = mid + Math.imul(ah7, bl6) | 0;
        hi = hi + Math.imul(ah7, bh6) | 0;
        lo = lo + Math.imul(al6, bl7) | 0;
        mid = mid + Math.imul(al6, bh7) | 0;
        mid = mid + Math.imul(ah6, bl7) | 0;
        hi = hi + Math.imul(ah6, bh7) | 0;
        lo = lo + Math.imul(al5, bl8) | 0;
        mid = mid + Math.imul(al5, bh8) | 0;
        mid = mid + Math.imul(ah5, bl8) | 0;
        hi = hi + Math.imul(ah5, bh8) | 0;
        lo = lo + Math.imul(al4, bl9) | 0;
        mid = mid + Math.imul(al4, bh9) | 0;
        mid = mid + Math.imul(ah4, bl9) | 0;
        hi = hi + Math.imul(ah4, bh9) | 0;
        var w13 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w13 >>> 26) | 0;
        w13 &= 67108863;
        lo = Math.imul(al9, bl5);
        mid = Math.imul(al9, bh5);
        mid = mid + Math.imul(ah9, bl5) | 0;
        hi = Math.imul(ah9, bh5);
        lo = lo + Math.imul(al8, bl6) | 0;
        mid = mid + Math.imul(al8, bh6) | 0;
        mid = mid + Math.imul(ah8, bl6) | 0;
        hi = hi + Math.imul(ah8, bh6) | 0;
        lo = lo + Math.imul(al7, bl7) | 0;
        mid = mid + Math.imul(al7, bh7) | 0;
        mid = mid + Math.imul(ah7, bl7) | 0;
        hi = hi + Math.imul(ah7, bh7) | 0;
        lo = lo + Math.imul(al6, bl8) | 0;
        mid = mid + Math.imul(al6, bh8) | 0;
        mid = mid + Math.imul(ah6, bl8) | 0;
        hi = hi + Math.imul(ah6, bh8) | 0;
        lo = lo + Math.imul(al5, bl9) | 0;
        mid = mid + Math.imul(al5, bh9) | 0;
        mid = mid + Math.imul(ah5, bl9) | 0;
        hi = hi + Math.imul(ah5, bh9) | 0;
        var w14 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w14 >>> 26) | 0;
        w14 &= 67108863;
        lo = Math.imul(al9, bl6);
        mid = Math.imul(al9, bh6);
        mid = mid + Math.imul(ah9, bl6) | 0;
        hi = Math.imul(ah9, bh6);
        lo = lo + Math.imul(al8, bl7) | 0;
        mid = mid + Math.imul(al8, bh7) | 0;
        mid = mid + Math.imul(ah8, bl7) | 0;
        hi = hi + Math.imul(ah8, bh7) | 0;
        lo = lo + Math.imul(al7, bl8) | 0;
        mid = mid + Math.imul(al7, bh8) | 0;
        mid = mid + Math.imul(ah7, bl8) | 0;
        hi = hi + Math.imul(ah7, bh8) | 0;
        lo = lo + Math.imul(al6, bl9) | 0;
        mid = mid + Math.imul(al6, bh9) | 0;
        mid = mid + Math.imul(ah6, bl9) | 0;
        hi = hi + Math.imul(ah6, bh9) | 0;
        var w15 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w15 >>> 26) | 0;
        w15 &= 67108863;
        lo = Math.imul(al9, bl7);
        mid = Math.imul(al9, bh7);
        mid = mid + Math.imul(ah9, bl7) | 0;
        hi = Math.imul(ah9, bh7);
        lo = lo + Math.imul(al8, bl8) | 0;
        mid = mid + Math.imul(al8, bh8) | 0;
        mid = mid + Math.imul(ah8, bl8) | 0;
        hi = hi + Math.imul(ah8, bh8) | 0;
        lo = lo + Math.imul(al7, bl9) | 0;
        mid = mid + Math.imul(al7, bh9) | 0;
        mid = mid + Math.imul(ah7, bl9) | 0;
        hi = hi + Math.imul(ah7, bh9) | 0;
        var w16 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w16 >>> 26) | 0;
        w16 &= 67108863;
        lo = Math.imul(al9, bl8);
        mid = Math.imul(al9, bh8);
        mid = mid + Math.imul(ah9, bl8) | 0;
        hi = Math.imul(ah9, bh8);
        lo = lo + Math.imul(al8, bl9) | 0;
        mid = mid + Math.imul(al8, bh9) | 0;
        mid = mid + Math.imul(ah8, bl9) | 0;
        hi = hi + Math.imul(ah8, bh9) | 0;
        var w17 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w17 >>> 26) | 0;
        w17 &= 67108863;
        lo = Math.imul(al9, bl9);
        mid = Math.imul(al9, bh9);
        mid = mid + Math.imul(ah9, bl9) | 0;
        hi = Math.imul(ah9, bh9);
        var w18 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w18 >>> 26) | 0;
        w18 &= 67108863;
        o2[0] = w0;
        o2[1] = w1;
        o2[2] = w2;
        o2[3] = w3;
        o2[4] = w4;
        o2[5] = w5;
        o2[6] = w6;
        o2[7] = w7;
        o2[8] = w8;
        o2[9] = w9;
        o2[10] = w10;
        o2[11] = w11;
        o2[12] = w12;
        o2[13] = w13;
        o2[14] = w14;
        o2[15] = w15;
        o2[16] = w16;
        o2[17] = w17;
        o2[18] = w18;
        if (c2 !== 0) {
          o2[19] = c2;
          out.length++;
        }
        return out;
      };
      if (!Math.imul) {
        comb10MulTo = smallMulTo;
      }
      function bigMulTo(self2, num, out) {
        out.negative = num.negative ^ self2.negative;
        out.length = self2.length + num.length;
        var carry = 0;
        var hncarry = 0;
        for (var k2 = 0; k2 < out.length - 1; k2++) {
          var ncarry = hncarry;
          hncarry = 0;
          var rword = carry & 67108863;
          var maxJ = Math.min(k2, num.length - 1);
          for (var j = Math.max(0, k2 - self2.length + 1); j <= maxJ; j++) {
            var i2 = k2 - j;
            var a2 = self2.words[i2] | 0;
            var b2 = num.words[j] | 0;
            var r2 = a2 * b2;
            var lo = r2 & 67108863;
            ncarry = ncarry + (r2 / 67108864 | 0) | 0;
            lo = lo + rword | 0;
            rword = lo & 67108863;
            ncarry = ncarry + (lo >>> 26) | 0;
            hncarry += ncarry >>> 26;
            ncarry &= 67108863;
          }
          out.words[k2] = rword;
          carry = ncarry;
          ncarry = hncarry;
        }
        if (carry !== 0) {
          out.words[k2] = carry;
        } else {
          out.length--;
        }
        return out.strip();
      }
      function jumboMulTo(self2, num, out) {
        var fftm = new FFTM();
        return fftm.mulp(self2, num, out);
      }
      BN.prototype.mulTo = function mulTo(num, out) {
        var res;
        var len = this.length + num.length;
        if (this.length === 10 && num.length === 10) {
          res = comb10MulTo(this, num, out);
        } else if (len < 63) {
          res = smallMulTo(this, num, out);
        } else if (len < 1024) {
          res = bigMulTo(this, num, out);
        } else {
          res = jumboMulTo(this, num, out);
        }
        return res;
      };
      function FFTM(x2, y2) {
        this.x = x2;
        this.y = y2;
      }
      FFTM.prototype.makeRBT = function makeRBT(N2) {
        var t2 = new Array(N2);
        var l2 = BN.prototype._countBits(N2) - 1;
        for (var i2 = 0; i2 < N2; i2++) {
          t2[i2] = this.revBin(i2, l2, N2);
        }
        return t2;
      };
      FFTM.prototype.revBin = function revBin(x2, l2, N2) {
        if (x2 === 0 || x2 === N2 - 1) return x2;
        var rb = 0;
        for (var i2 = 0; i2 < l2; i2++) {
          rb |= (x2 & 1) << l2 - i2 - 1;
          x2 >>= 1;
        }
        return rb;
      };
      FFTM.prototype.permute = function permute(rbt, rws, iws, rtws, itws, N2) {
        for (var i2 = 0; i2 < N2; i2++) {
          rtws[i2] = rws[rbt[i2]];
          itws[i2] = iws[rbt[i2]];
        }
      };
      FFTM.prototype.transform = function transform(rws, iws, rtws, itws, N2, rbt) {
        this.permute(rbt, rws, iws, rtws, itws, N2);
        for (var s2 = 1; s2 < N2; s2 <<= 1) {
          var l2 = s2 << 1;
          var rtwdf = Math.cos(2 * Math.PI / l2);
          var itwdf = Math.sin(2 * Math.PI / l2);
          for (var p2 = 0; p2 < N2; p2 += l2) {
            var rtwdf_ = rtwdf;
            var itwdf_ = itwdf;
            for (var j = 0; j < s2; j++) {
              var re = rtws[p2 + j];
              var ie = itws[p2 + j];
              var ro = rtws[p2 + j + s2];
              var io = itws[p2 + j + s2];
              var rx = rtwdf_ * ro - itwdf_ * io;
              io = rtwdf_ * io + itwdf_ * ro;
              ro = rx;
              rtws[p2 + j] = re + ro;
              itws[p2 + j] = ie + io;
              rtws[p2 + j + s2] = re - ro;
              itws[p2 + j + s2] = ie - io;
              if (j !== l2) {
                rx = rtwdf * rtwdf_ - itwdf * itwdf_;
                itwdf_ = rtwdf * itwdf_ + itwdf * rtwdf_;
                rtwdf_ = rx;
              }
            }
          }
        }
      };
      FFTM.prototype.guessLen13b = function guessLen13b(n2, m) {
        var N2 = Math.max(m, n2) | 1;
        var odd = N2 & 1;
        var i2 = 0;
        for (N2 = N2 / 2 | 0; N2; N2 = N2 >>> 1) {
          i2++;
        }
        return 1 << i2 + 1 + odd;
      };
      FFTM.prototype.conjugate = function conjugate(rws, iws, N2) {
        if (N2 <= 1) return;
        for (var i2 = 0; i2 < N2 / 2; i2++) {
          var t2 = rws[i2];
          rws[i2] = rws[N2 - i2 - 1];
          rws[N2 - i2 - 1] = t2;
          t2 = iws[i2];
          iws[i2] = -iws[N2 - i2 - 1];
          iws[N2 - i2 - 1] = -t2;
        }
      };
      FFTM.prototype.normalize13b = function normalize13b(ws, N2) {
        var carry = 0;
        for (var i2 = 0; i2 < N2 / 2; i2++) {
          var w = Math.round(ws[2 * i2 + 1] / N2) * 8192 + Math.round(ws[2 * i2] / N2) + carry;
          ws[i2] = w & 67108863;
          if (w < 67108864) {
            carry = 0;
          } else {
            carry = w / 67108864 | 0;
          }
        }
        return ws;
      };
      FFTM.prototype.convert13b = function convert13b(ws, len, rws, N2) {
        var carry = 0;
        for (var i2 = 0; i2 < len; i2++) {
          carry = carry + (ws[i2] | 0);
          rws[2 * i2] = carry & 8191;
          carry = carry >>> 13;
          rws[2 * i2 + 1] = carry & 8191;
          carry = carry >>> 13;
        }
        for (i2 = 2 * len; i2 < N2; ++i2) {
          rws[i2] = 0;
        }
        assert(carry === 0);
        assert((carry & -8192) === 0);
      };
      FFTM.prototype.stub = function stub(N2) {
        var ph = new Array(N2);
        for (var i2 = 0; i2 < N2; i2++) {
          ph[i2] = 0;
        }
        return ph;
      };
      FFTM.prototype.mulp = function mulp(x2, y2, out) {
        var N2 = 2 * this.guessLen13b(x2.length, y2.length);
        var rbt = this.makeRBT(N2);
        var _2 = this.stub(N2);
        var rws = new Array(N2);
        var rwst = new Array(N2);
        var iwst = new Array(N2);
        var nrws = new Array(N2);
        var nrwst = new Array(N2);
        var niwst = new Array(N2);
        var rmws = out.words;
        rmws.length = N2;
        this.convert13b(x2.words, x2.length, rws, N2);
        this.convert13b(y2.words, y2.length, nrws, N2);
        this.transform(rws, _2, rwst, iwst, N2, rbt);
        this.transform(nrws, _2, nrwst, niwst, N2, rbt);
        for (var i2 = 0; i2 < N2; i2++) {
          var rx = rwst[i2] * nrwst[i2] - iwst[i2] * niwst[i2];
          iwst[i2] = rwst[i2] * niwst[i2] + iwst[i2] * nrwst[i2];
          rwst[i2] = rx;
        }
        this.conjugate(rwst, iwst, N2);
        this.transform(rwst, iwst, rmws, _2, N2, rbt);
        this.conjugate(rmws, _2, N2);
        this.normalize13b(rmws, N2);
        out.negative = x2.negative ^ y2.negative;
        out.length = x2.length + y2.length;
        return out.strip();
      };
      BN.prototype.mul = function mul(num) {
        var out = new BN(null);
        out.words = new Array(this.length + num.length);
        return this.mulTo(num, out);
      };
      BN.prototype.mulf = function mulf(num) {
        var out = new BN(null);
        out.words = new Array(this.length + num.length);
        return jumboMulTo(this, num, out);
      };
      BN.prototype.imul = function imul(num) {
        return this.clone().mulTo(num, this);
      };
      BN.prototype.imuln = function imuln(num) {
        assert(typeof num === "number");
        assert(num < 67108864);
        var carry = 0;
        for (var i2 = 0; i2 < this.length; i2++) {
          var w = (this.words[i2] | 0) * num;
          var lo = (w & 67108863) + (carry & 67108863);
          carry >>= 26;
          carry += w / 67108864 | 0;
          carry += lo >>> 26;
          this.words[i2] = lo & 67108863;
        }
        if (carry !== 0) {
          this.words[i2] = carry;
          this.length++;
        }
        this.length = num === 0 ? 1 : this.length;
        return this;
      };
      BN.prototype.muln = function muln(num) {
        return this.clone().imuln(num);
      };
      BN.prototype.sqr = function sqr() {
        return this.mul(this);
      };
      BN.prototype.isqr = function isqr() {
        return this.imul(this.clone());
      };
      BN.prototype.pow = function pow2(num) {
        var w = toBitArray(num);
        if (w.length === 0) return new BN(1);
        var res = this;
        for (var i2 = 0; i2 < w.length; i2++, res = res.sqr()) {
          if (w[i2] !== 0) break;
        }
        if (++i2 < w.length) {
          for (var q = res.sqr(); i2 < w.length; i2++, q = q.sqr()) {
            if (w[i2] === 0) continue;
            res = res.mul(q);
          }
        }
        return res;
      };
      BN.prototype.iushln = function iushln(bits) {
        assert(typeof bits === "number" && bits >= 0);
        var r2 = bits % 26;
        var s2 = (bits - r2) / 26;
        var carryMask = 67108863 >>> 26 - r2 << 26 - r2;
        var i2;
        if (r2 !== 0) {
          var carry = 0;
          for (i2 = 0; i2 < this.length; i2++) {
            var newCarry = this.words[i2] & carryMask;
            var c2 = (this.words[i2] | 0) - newCarry << r2;
            this.words[i2] = c2 | carry;
            carry = newCarry >>> 26 - r2;
          }
          if (carry) {
            this.words[i2] = carry;
            this.length++;
          }
        }
        if (s2 !== 0) {
          for (i2 = this.length - 1; i2 >= 0; i2--) {
            this.words[i2 + s2] = this.words[i2];
          }
          for (i2 = 0; i2 < s2; i2++) {
            this.words[i2] = 0;
          }
          this.length += s2;
        }
        return this.strip();
      };
      BN.prototype.ishln = function ishln(bits) {
        assert(this.negative === 0);
        return this.iushln(bits);
      };
      BN.prototype.iushrn = function iushrn(bits, hint, extended) {
        assert(typeof bits === "number" && bits >= 0);
        var h2;
        if (hint) {
          h2 = (hint - hint % 26) / 26;
        } else {
          h2 = 0;
        }
        var r2 = bits % 26;
        var s2 = Math.min((bits - r2) / 26, this.length);
        var mask = 67108863 ^ 67108863 >>> r2 << r2;
        var maskedWords = extended;
        h2 -= s2;
        h2 = Math.max(0, h2);
        if (maskedWords) {
          for (var i2 = 0; i2 < s2; i2++) {
            maskedWords.words[i2] = this.words[i2];
          }
          maskedWords.length = s2;
        }
        if (s2 === 0) ;
        else if (this.length > s2) {
          this.length -= s2;
          for (i2 = 0; i2 < this.length; i2++) {
            this.words[i2] = this.words[i2 + s2];
          }
        } else {
          this.words[0] = 0;
          this.length = 1;
        }
        var carry = 0;
        for (i2 = this.length - 1; i2 >= 0 && (carry !== 0 || i2 >= h2); i2--) {
          var word = this.words[i2] | 0;
          this.words[i2] = carry << 26 - r2 | word >>> r2;
          carry = word & mask;
        }
        if (maskedWords && carry !== 0) {
          maskedWords.words[maskedWords.length++] = carry;
        }
        if (this.length === 0) {
          this.words[0] = 0;
          this.length = 1;
        }
        return this.strip();
      };
      BN.prototype.ishrn = function ishrn(bits, hint, extended) {
        assert(this.negative === 0);
        return this.iushrn(bits, hint, extended);
      };
      BN.prototype.shln = function shln(bits) {
        return this.clone().ishln(bits);
      };
      BN.prototype.ushln = function ushln(bits) {
        return this.clone().iushln(bits);
      };
      BN.prototype.shrn = function shrn(bits) {
        return this.clone().ishrn(bits);
      };
      BN.prototype.ushrn = function ushrn(bits) {
        return this.clone().iushrn(bits);
      };
      BN.prototype.testn = function testn(bit) {
        assert(typeof bit === "number" && bit >= 0);
        var r2 = bit % 26;
        var s2 = (bit - r2) / 26;
        var q = 1 << r2;
        if (this.length <= s2) return false;
        var w = this.words[s2];
        return !!(w & q);
      };
      BN.prototype.imaskn = function imaskn(bits) {
        assert(typeof bits === "number" && bits >= 0);
        var r2 = bits % 26;
        var s2 = (bits - r2) / 26;
        assert(this.negative === 0, "imaskn works only with positive numbers");
        if (this.length <= s2) {
          return this;
        }
        if (r2 !== 0) {
          s2++;
        }
        this.length = Math.min(s2, this.length);
        if (r2 !== 0) {
          var mask = 67108863 ^ 67108863 >>> r2 << r2;
          this.words[this.length - 1] &= mask;
        }
        return this.strip();
      };
      BN.prototype.maskn = function maskn(bits) {
        return this.clone().imaskn(bits);
      };
      BN.prototype.iaddn = function iaddn(num) {
        assert(typeof num === "number");
        assert(num < 67108864);
        if (num < 0) return this.isubn(-num);
        if (this.negative !== 0) {
          if (this.length === 1 && (this.words[0] | 0) < num) {
            this.words[0] = num - (this.words[0] | 0);
            this.negative = 0;
            return this;
          }
          this.negative = 0;
          this.isubn(num);
          this.negative = 1;
          return this;
        }
        return this._iaddn(num);
      };
      BN.prototype._iaddn = function _iaddn(num) {
        this.words[0] += num;
        for (var i2 = 0; i2 < this.length && this.words[i2] >= 67108864; i2++) {
          this.words[i2] -= 67108864;
          if (i2 === this.length - 1) {
            this.words[i2 + 1] = 1;
          } else {
            this.words[i2 + 1]++;
          }
        }
        this.length = Math.max(this.length, i2 + 1);
        return this;
      };
      BN.prototype.isubn = function isubn(num) {
        assert(typeof num === "number");
        assert(num < 67108864);
        if (num < 0) return this.iaddn(-num);
        if (this.negative !== 0) {
          this.negative = 0;
          this.iaddn(num);
          this.negative = 1;
          return this;
        }
        this.words[0] -= num;
        if (this.length === 1 && this.words[0] < 0) {
          this.words[0] = -this.words[0];
          this.negative = 1;
        } else {
          for (var i2 = 0; i2 < this.length && this.words[i2] < 0; i2++) {
            this.words[i2] += 67108864;
            this.words[i2 + 1] -= 1;
          }
        }
        return this.strip();
      };
      BN.prototype.addn = function addn(num) {
        return this.clone().iaddn(num);
      };
      BN.prototype.subn = function subn(num) {
        return this.clone().isubn(num);
      };
      BN.prototype.iabs = function iabs() {
        this.negative = 0;
        return this;
      };
      BN.prototype.abs = function abs2() {
        return this.clone().iabs();
      };
      BN.prototype._ishlnsubmul = function _ishlnsubmul(num, mul, shift) {
        var len = num.length + shift;
        var i2;
        this._expand(len);
        var w;
        var carry = 0;
        for (i2 = 0; i2 < num.length; i2++) {
          w = (this.words[i2 + shift] | 0) + carry;
          var right = (num.words[i2] | 0) * mul;
          w -= right & 67108863;
          carry = (w >> 26) - (right / 67108864 | 0);
          this.words[i2 + shift] = w & 67108863;
        }
        for (; i2 < this.length - shift; i2++) {
          w = (this.words[i2 + shift] | 0) + carry;
          carry = w >> 26;
          this.words[i2 + shift] = w & 67108863;
        }
        if (carry === 0) return this.strip();
        assert(carry === -1);
        carry = 0;
        for (i2 = 0; i2 < this.length; i2++) {
          w = -(this.words[i2] | 0) + carry;
          carry = w >> 26;
          this.words[i2] = w & 67108863;
        }
        this.negative = 1;
        return this.strip();
      };
      BN.prototype._wordDiv = function _wordDiv(num, mode) {
        var shift = this.length - num.length;
        var a2 = this.clone();
        var b2 = num;
        var bhi = b2.words[b2.length - 1] | 0;
        var bhiBits = this._countBits(bhi);
        shift = 26 - bhiBits;
        if (shift !== 0) {
          b2 = b2.ushln(shift);
          a2.iushln(shift);
          bhi = b2.words[b2.length - 1] | 0;
        }
        var m = a2.length - b2.length;
        var q;
        if (mode !== "mod") {
          q = new BN(null);
          q.length = m + 1;
          q.words = new Array(q.length);
          for (var i2 = 0; i2 < q.length; i2++) {
            q.words[i2] = 0;
          }
        }
        var diff = a2.clone()._ishlnsubmul(b2, 1, m);
        if (diff.negative === 0) {
          a2 = diff;
          if (q) {
            q.words[m] = 1;
          }
        }
        for (var j = m - 1; j >= 0; j--) {
          var qj = (a2.words[b2.length + j] | 0) * 67108864 + (a2.words[b2.length + j - 1] | 0);
          qj = Math.min(qj / bhi | 0, 67108863);
          a2._ishlnsubmul(b2, qj, j);
          while (a2.negative !== 0) {
            qj--;
            a2.negative = 0;
            a2._ishlnsubmul(b2, 1, j);
            if (!a2.isZero()) {
              a2.negative ^= 1;
            }
          }
          if (q) {
            q.words[j] = qj;
          }
        }
        if (q) {
          q.strip();
        }
        a2.strip();
        if (mode !== "div" && shift !== 0) {
          a2.iushrn(shift);
        }
        return {
          div: q || null,
          mod: a2
        };
      };
      BN.prototype.divmod = function divmod(num, mode, positive) {
        assert(!num.isZero());
        if (this.isZero()) {
          return {
            div: new BN(0),
            mod: new BN(0)
          };
        }
        var div, mod, res;
        if (this.negative !== 0 && num.negative === 0) {
          res = this.neg().divmod(num, mode);
          if (mode !== "mod") {
            div = res.div.neg();
          }
          if (mode !== "div") {
            mod = res.mod.neg();
            if (positive && mod.negative !== 0) {
              mod.iadd(num);
            }
          }
          return {
            div,
            mod
          };
        }
        if (this.negative === 0 && num.negative !== 0) {
          res = this.divmod(num.neg(), mode);
          if (mode !== "mod") {
            div = res.div.neg();
          }
          return {
            div,
            mod: res.mod
          };
        }
        if ((this.negative & num.negative) !== 0) {
          res = this.neg().divmod(num.neg(), mode);
          if (mode !== "div") {
            mod = res.mod.neg();
            if (positive && mod.negative !== 0) {
              mod.isub(num);
            }
          }
          return {
            div: res.div,
            mod
          };
        }
        if (num.length > this.length || this.cmp(num) < 0) {
          return {
            div: new BN(0),
            mod: this
          };
        }
        if (num.length === 1) {
          if (mode === "div") {
            return {
              div: this.divn(num.words[0]),
              mod: null
            };
          }
          if (mode === "mod") {
            return {
              div: null,
              mod: new BN(this.modn(num.words[0]))
            };
          }
          return {
            div: this.divn(num.words[0]),
            mod: new BN(this.modn(num.words[0]))
          };
        }
        return this._wordDiv(num, mode);
      };
      BN.prototype.div = function div(num) {
        return this.divmod(num, "div", false).div;
      };
      BN.prototype.mod = function mod(num) {
        return this.divmod(num, "mod", false).mod;
      };
      BN.prototype.umod = function umod(num) {
        return this.divmod(num, "mod", true).mod;
      };
      BN.prototype.divRound = function divRound(num) {
        var dm = this.divmod(num);
        if (dm.mod.isZero()) return dm.div;
        var mod = dm.div.negative !== 0 ? dm.mod.isub(num) : dm.mod;
        var half = num.ushrn(1);
        var r2 = num.andln(1);
        var cmp = mod.cmp(half);
        if (cmp < 0 || r2 === 1 && cmp === 0) return dm.div;
        return dm.div.negative !== 0 ? dm.div.isubn(1) : dm.div.iaddn(1);
      };
      BN.prototype.modn = function modn(num) {
        assert(num <= 67108863);
        var p2 = (1 << 26) % num;
        var acc = 0;
        for (var i2 = this.length - 1; i2 >= 0; i2--) {
          acc = (p2 * acc + (this.words[i2] | 0)) % num;
        }
        return acc;
      };
      BN.prototype.idivn = function idivn(num) {
        assert(num <= 67108863);
        var carry = 0;
        for (var i2 = this.length - 1; i2 >= 0; i2--) {
          var w = (this.words[i2] | 0) + carry * 67108864;
          this.words[i2] = w / num | 0;
          carry = w % num;
        }
        return this.strip();
      };
      BN.prototype.divn = function divn(num) {
        return this.clone().idivn(num);
      };
      BN.prototype.egcd = function egcd(p2) {
        assert(p2.negative === 0);
        assert(!p2.isZero());
        var x2 = this;
        var y2 = p2.clone();
        if (x2.negative !== 0) {
          x2 = x2.umod(p2);
        } else {
          x2 = x2.clone();
        }
        var A2 = new BN(1);
        var B2 = new BN(0);
        var C2 = new BN(0);
        var D = new BN(1);
        var g = 0;
        while (x2.isEven() && y2.isEven()) {
          x2.iushrn(1);
          y2.iushrn(1);
          ++g;
        }
        var yp = y2.clone();
        var xp = x2.clone();
        while (!x2.isZero()) {
          for (var i2 = 0, im = 1; (x2.words[0] & im) === 0 && i2 < 26; ++i2, im <<= 1) ;
          if (i2 > 0) {
            x2.iushrn(i2);
            while (i2-- > 0) {
              if (A2.isOdd() || B2.isOdd()) {
                A2.iadd(yp);
                B2.isub(xp);
              }
              A2.iushrn(1);
              B2.iushrn(1);
            }
          }
          for (var j = 0, jm = 1; (y2.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1) ;
          if (j > 0) {
            y2.iushrn(j);
            while (j-- > 0) {
              if (C2.isOdd() || D.isOdd()) {
                C2.iadd(yp);
                D.isub(xp);
              }
              C2.iushrn(1);
              D.iushrn(1);
            }
          }
          if (x2.cmp(y2) >= 0) {
            x2.isub(y2);
            A2.isub(C2);
            B2.isub(D);
          } else {
            y2.isub(x2);
            C2.isub(A2);
            D.isub(B2);
          }
        }
        return {
          a: C2,
          b: D,
          gcd: y2.iushln(g)
        };
      };
      BN.prototype._invmp = function _invmp(p2) {
        assert(p2.negative === 0);
        assert(!p2.isZero());
        var a2 = this;
        var b2 = p2.clone();
        if (a2.negative !== 0) {
          a2 = a2.umod(p2);
        } else {
          a2 = a2.clone();
        }
        var x1 = new BN(1);
        var x2 = new BN(0);
        var delta = b2.clone();
        while (a2.cmpn(1) > 0 && b2.cmpn(1) > 0) {
          for (var i2 = 0, im = 1; (a2.words[0] & im) === 0 && i2 < 26; ++i2, im <<= 1) ;
          if (i2 > 0) {
            a2.iushrn(i2);
            while (i2-- > 0) {
              if (x1.isOdd()) {
                x1.iadd(delta);
              }
              x1.iushrn(1);
            }
          }
          for (var j = 0, jm = 1; (b2.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1) ;
          if (j > 0) {
            b2.iushrn(j);
            while (j-- > 0) {
              if (x2.isOdd()) {
                x2.iadd(delta);
              }
              x2.iushrn(1);
            }
          }
          if (a2.cmp(b2) >= 0) {
            a2.isub(b2);
            x1.isub(x2);
          } else {
            b2.isub(a2);
            x2.isub(x1);
          }
        }
        var res;
        if (a2.cmpn(1) === 0) {
          res = x1;
        } else {
          res = x2;
        }
        if (res.cmpn(0) < 0) {
          res.iadd(p2);
        }
        return res;
      };
      BN.prototype.gcd = function gcd(num) {
        if (this.isZero()) return num.abs();
        if (num.isZero()) return this.abs();
        var a2 = this.clone();
        var b2 = num.clone();
        a2.negative = 0;
        b2.negative = 0;
        for (var shift = 0; a2.isEven() && b2.isEven(); shift++) {
          a2.iushrn(1);
          b2.iushrn(1);
        }
        do {
          while (a2.isEven()) {
            a2.iushrn(1);
          }
          while (b2.isEven()) {
            b2.iushrn(1);
          }
          var r2 = a2.cmp(b2);
          if (r2 < 0) {
            var t2 = a2;
            a2 = b2;
            b2 = t2;
          } else if (r2 === 0 || b2.cmpn(1) === 0) {
            break;
          }
          a2.isub(b2);
        } while (true);
        return b2.iushln(shift);
      };
      BN.prototype.invm = function invm(num) {
        return this.egcd(num).a.umod(num);
      };
      BN.prototype.isEven = function isEven() {
        return (this.words[0] & 1) === 0;
      };
      BN.prototype.isOdd = function isOdd() {
        return (this.words[0] & 1) === 1;
      };
      BN.prototype.andln = function andln(num) {
        return this.words[0] & num;
      };
      BN.prototype.bincn = function bincn(bit) {
        assert(typeof bit === "number");
        var r2 = bit % 26;
        var s2 = (bit - r2) / 26;
        var q = 1 << r2;
        if (this.length <= s2) {
          this._expand(s2 + 1);
          this.words[s2] |= q;
          return this;
        }
        var carry = q;
        for (var i2 = s2; carry !== 0 && i2 < this.length; i2++) {
          var w = this.words[i2] | 0;
          w += carry;
          carry = w >>> 26;
          w &= 67108863;
          this.words[i2] = w;
        }
        if (carry !== 0) {
          this.words[i2] = carry;
          this.length++;
        }
        return this;
      };
      BN.prototype.isZero = function isZero() {
        return this.length === 1 && this.words[0] === 0;
      };
      BN.prototype.cmpn = function cmpn(num) {
        var negative = num < 0;
        if (this.negative !== 0 && !negative) return -1;
        if (this.negative === 0 && negative) return 1;
        this.strip();
        var res;
        if (this.length > 1) {
          res = 1;
        } else {
          if (negative) {
            num = -num;
          }
          assert(num <= 67108863, "Number is too big");
          var w = this.words[0] | 0;
          res = w === num ? 0 : w < num ? -1 : 1;
        }
        if (this.negative !== 0) return -res | 0;
        return res;
      };
      BN.prototype.cmp = function cmp(num) {
        if (this.negative !== 0 && num.negative === 0) return -1;
        if (this.negative === 0 && num.negative !== 0) return 1;
        var res = this.ucmp(num);
        if (this.negative !== 0) return -res | 0;
        return res;
      };
      BN.prototype.ucmp = function ucmp(num) {
        if (this.length > num.length) return 1;
        if (this.length < num.length) return -1;
        var res = 0;
        for (var i2 = this.length - 1; i2 >= 0; i2--) {
          var a2 = this.words[i2] | 0;
          var b2 = num.words[i2] | 0;
          if (a2 === b2) continue;
          if (a2 < b2) {
            res = -1;
          } else if (a2 > b2) {
            res = 1;
          }
          break;
        }
        return res;
      };
      BN.prototype.gtn = function gtn(num) {
        return this.cmpn(num) === 1;
      };
      BN.prototype.gt = function gt(num) {
        return this.cmp(num) === 1;
      };
      BN.prototype.gten = function gten(num) {
        return this.cmpn(num) >= 0;
      };
      BN.prototype.gte = function gte(num) {
        return this.cmp(num) >= 0;
      };
      BN.prototype.ltn = function ltn(num) {
        return this.cmpn(num) === -1;
      };
      BN.prototype.lt = function lt(num) {
        return this.cmp(num) === -1;
      };
      BN.prototype.lten = function lten(num) {
        return this.cmpn(num) <= 0;
      };
      BN.prototype.lte = function lte(num) {
        return this.cmp(num) <= 0;
      };
      BN.prototype.eqn = function eqn(num) {
        return this.cmpn(num) === 0;
      };
      BN.prototype.eq = function eq(num) {
        return this.cmp(num) === 0;
      };
      BN.red = function red(num) {
        return new Red(num);
      };
      BN.prototype.toRed = function toRed(ctx) {
        assert(!this.red, "Already a number in reduction context");
        assert(this.negative === 0, "red works only with positives");
        return ctx.convertTo(this)._forceRed(ctx);
      };
      BN.prototype.fromRed = function fromRed() {
        assert(this.red, "fromRed works only with numbers in reduction context");
        return this.red.convertFrom(this);
      };
      BN.prototype._forceRed = function _forceRed(ctx) {
        this.red = ctx;
        return this;
      };
      BN.prototype.forceRed = function forceRed(ctx) {
        assert(!this.red, "Already a number in reduction context");
        return this._forceRed(ctx);
      };
      BN.prototype.redAdd = function redAdd(num) {
        assert(this.red, "redAdd works only with red numbers");
        return this.red.add(this, num);
      };
      BN.prototype.redIAdd = function redIAdd(num) {
        assert(this.red, "redIAdd works only with red numbers");
        return this.red.iadd(this, num);
      };
      BN.prototype.redSub = function redSub(num) {
        assert(this.red, "redSub works only with red numbers");
        return this.red.sub(this, num);
      };
      BN.prototype.redISub = function redISub(num) {
        assert(this.red, "redISub works only with red numbers");
        return this.red.isub(this, num);
      };
      BN.prototype.redShl = function redShl(num) {
        assert(this.red, "redShl works only with red numbers");
        return this.red.shl(this, num);
      };
      BN.prototype.redMul = function redMul(num) {
        assert(this.red, "redMul works only with red numbers");
        this.red._verify2(this, num);
        return this.red.mul(this, num);
      };
      BN.prototype.redIMul = function redIMul(num) {
        assert(this.red, "redMul works only with red numbers");
        this.red._verify2(this, num);
        return this.red.imul(this, num);
      };
      BN.prototype.redSqr = function redSqr() {
        assert(this.red, "redSqr works only with red numbers");
        this.red._verify1(this);
        return this.red.sqr(this);
      };
      BN.prototype.redISqr = function redISqr() {
        assert(this.red, "redISqr works only with red numbers");
        this.red._verify1(this);
        return this.red.isqr(this);
      };
      BN.prototype.redSqrt = function redSqrt() {
        assert(this.red, "redSqrt works only with red numbers");
        this.red._verify1(this);
        return this.red.sqrt(this);
      };
      BN.prototype.redInvm = function redInvm() {
        assert(this.red, "redInvm works only with red numbers");
        this.red._verify1(this);
        return this.red.invm(this);
      };
      BN.prototype.redNeg = function redNeg() {
        assert(this.red, "redNeg works only with red numbers");
        this.red._verify1(this);
        return this.red.neg(this);
      };
      BN.prototype.redPow = function redPow(num) {
        assert(this.red && !num.red, "redPow(normalNum)");
        this.red._verify1(this);
        return this.red.pow(this, num);
      };
      var primes = {
        k256: null,
        p224: null,
        p192: null,
        p25519: null
      };
      function MPrime(name, p2) {
        this.name = name;
        this.p = new BN(p2, 16);
        this.n = this.p.bitLength();
        this.k = new BN(1).iushln(this.n).isub(this.p);
        this.tmp = this._tmp();
      }
      MPrime.prototype._tmp = function _tmp() {
        var tmp = new BN(null);
        tmp.words = new Array(Math.ceil(this.n / 13));
        return tmp;
      };
      MPrime.prototype.ireduce = function ireduce(num) {
        var r2 = num;
        var rlen;
        do {
          this.split(r2, this.tmp);
          r2 = this.imulK(r2);
          r2 = r2.iadd(this.tmp);
          rlen = r2.bitLength();
        } while (rlen > this.n);
        var cmp = rlen < this.n ? -1 : r2.ucmp(this.p);
        if (cmp === 0) {
          r2.words[0] = 0;
          r2.length = 1;
        } else if (cmp > 0) {
          r2.isub(this.p);
        } else {
          if (r2.strip !== void 0) {
            r2.strip();
          } else {
            r2._strip();
          }
        }
        return r2;
      };
      MPrime.prototype.split = function split(input, out) {
        input.iushrn(this.n, 0, out);
      };
      MPrime.prototype.imulK = function imulK(num) {
        return num.imul(this.k);
      };
      function K256() {
        MPrime.call(
          this,
          "k256",
          "ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f"
        );
      }
      inherits(K256, MPrime);
      K256.prototype.split = function split(input, output) {
        var mask = 4194303;
        var outLen = Math.min(input.length, 9);
        for (var i2 = 0; i2 < outLen; i2++) {
          output.words[i2] = input.words[i2];
        }
        output.length = outLen;
        if (input.length <= 9) {
          input.words[0] = 0;
          input.length = 1;
          return;
        }
        var prev = input.words[9];
        output.words[output.length++] = prev & mask;
        for (i2 = 10; i2 < input.length; i2++) {
          var next = input.words[i2] | 0;
          input.words[i2 - 10] = (next & mask) << 4 | prev >>> 22;
          prev = next;
        }
        prev >>>= 22;
        input.words[i2 - 10] = prev;
        if (prev === 0 && input.length > 10) {
          input.length -= 10;
        } else {
          input.length -= 9;
        }
      };
      K256.prototype.imulK = function imulK(num) {
        num.words[num.length] = 0;
        num.words[num.length + 1] = 0;
        num.length += 2;
        var lo = 0;
        for (var i2 = 0; i2 < num.length; i2++) {
          var w = num.words[i2] | 0;
          lo += w * 977;
          num.words[i2] = lo & 67108863;
          lo = w * 64 + (lo / 67108864 | 0);
        }
        if (num.words[num.length - 1] === 0) {
          num.length--;
          if (num.words[num.length - 1] === 0) {
            num.length--;
          }
        }
        return num;
      };
      function P224() {
        MPrime.call(
          this,
          "p224",
          "ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001"
        );
      }
      inherits(P224, MPrime);
      function P192() {
        MPrime.call(
          this,
          "p192",
          "ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff"
        );
      }
      inherits(P192, MPrime);
      function P25519() {
        MPrime.call(
          this,
          "25519",
          "7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed"
        );
      }
      inherits(P25519, MPrime);
      P25519.prototype.imulK = function imulK(num) {
        var carry = 0;
        for (var i2 = 0; i2 < num.length; i2++) {
          var hi = (num.words[i2] | 0) * 19 + carry;
          var lo = hi & 67108863;
          hi >>>= 26;
          num.words[i2] = lo;
          carry = hi;
        }
        if (carry !== 0) {
          num.words[num.length++] = carry;
        }
        return num;
      };
      BN._prime = function prime(name) {
        if (primes[name]) return primes[name];
        var prime2;
        if (name === "k256") {
          prime2 = new K256();
        } else if (name === "p224") {
          prime2 = new P224();
        } else if (name === "p192") {
          prime2 = new P192();
        } else if (name === "p25519") {
          prime2 = new P25519();
        } else {
          throw new Error("Unknown prime " + name);
        }
        primes[name] = prime2;
        return prime2;
      };
      function Red(m) {
        if (typeof m === "string") {
          var prime = BN._prime(m);
          this.m = prime.p;
          this.prime = prime;
        } else {
          assert(m.gtn(1), "modulus must be greater than 1");
          this.m = m;
          this.prime = null;
        }
      }
      Red.prototype._verify1 = function _verify1(a2) {
        assert(a2.negative === 0, "red works only with positives");
        assert(a2.red, "red works only with red numbers");
      };
      Red.prototype._verify2 = function _verify2(a2, b2) {
        assert((a2.negative | b2.negative) === 0, "red works only with positives");
        assert(
          a2.red && a2.red === b2.red,
          "red works only with red numbers"
        );
      };
      Red.prototype.imod = function imod(a2) {
        if (this.prime) return this.prime.ireduce(a2)._forceRed(this);
        return a2.umod(this.m)._forceRed(this);
      };
      Red.prototype.neg = function neg(a2) {
        if (a2.isZero()) {
          return a2.clone();
        }
        return this.m.sub(a2)._forceRed(this);
      };
      Red.prototype.add = function add2(a2, b2) {
        this._verify2(a2, b2);
        var res = a2.add(b2);
        if (res.cmp(this.m) >= 0) {
          res.isub(this.m);
        }
        return res._forceRed(this);
      };
      Red.prototype.iadd = function iadd(a2, b2) {
        this._verify2(a2, b2);
        var res = a2.iadd(b2);
        if (res.cmp(this.m) >= 0) {
          res.isub(this.m);
        }
        return res;
      };
      Red.prototype.sub = function sub(a2, b2) {
        this._verify2(a2, b2);
        var res = a2.sub(b2);
        if (res.cmpn(0) < 0) {
          res.iadd(this.m);
        }
        return res._forceRed(this);
      };
      Red.prototype.isub = function isub(a2, b2) {
        this._verify2(a2, b2);
        var res = a2.isub(b2);
        if (res.cmpn(0) < 0) {
          res.iadd(this.m);
        }
        return res;
      };
      Red.prototype.shl = function shl(a2, num) {
        this._verify1(a2);
        return this.imod(a2.ushln(num));
      };
      Red.prototype.imul = function imul(a2, b2) {
        this._verify2(a2, b2);
        return this.imod(a2.imul(b2));
      };
      Red.prototype.mul = function mul(a2, b2) {
        this._verify2(a2, b2);
        return this.imod(a2.mul(b2));
      };
      Red.prototype.isqr = function isqr(a2) {
        return this.imul(a2, a2.clone());
      };
      Red.prototype.sqr = function sqr(a2) {
        return this.mul(a2, a2);
      };
      Red.prototype.sqrt = function sqrt(a2) {
        if (a2.isZero()) return a2.clone();
        var mod3 = this.m.andln(3);
        assert(mod3 % 2 === 1);
        if (mod3 === 3) {
          var pow2 = this.m.add(new BN(1)).iushrn(2);
          return this.pow(a2, pow2);
        }
        var q = this.m.subn(1);
        var s2 = 0;
        while (!q.isZero() && q.andln(1) === 0) {
          s2++;
          q.iushrn(1);
        }
        assert(!q.isZero());
        var one = new BN(1).toRed(this);
        var nOne = one.redNeg();
        var lpow = this.m.subn(1).iushrn(1);
        var z2 = this.m.bitLength();
        z2 = new BN(2 * z2 * z2).toRed(this);
        while (this.pow(z2, lpow).cmp(nOne) !== 0) {
          z2.redIAdd(nOne);
        }
        var c2 = this.pow(z2, q);
        var r2 = this.pow(a2, q.addn(1).iushrn(1));
        var t2 = this.pow(a2, q);
        var m = s2;
        while (t2.cmp(one) !== 0) {
          var tmp = t2;
          for (var i2 = 0; tmp.cmp(one) !== 0; i2++) {
            tmp = tmp.redSqr();
          }
          assert(i2 < m);
          var b2 = this.pow(c2, new BN(1).iushln(m - i2 - 1));
          r2 = r2.redMul(b2);
          c2 = b2.redSqr();
          t2 = t2.redMul(c2);
          m = i2;
        }
        return r2;
      };
      Red.prototype.invm = function invm(a2) {
        var inv = a2._invmp(this.m);
        if (inv.negative !== 0) {
          inv.negative = 0;
          return this.imod(inv).redNeg();
        } else {
          return this.imod(inv);
        }
      };
      Red.prototype.pow = function pow2(a2, num) {
        if (num.isZero()) return new BN(1).toRed(this);
        if (num.cmpn(1) === 0) return a2.clone();
        var windowSize = 4;
        var wnd = new Array(1 << windowSize);
        wnd[0] = new BN(1).toRed(this);
        wnd[1] = a2;
        for (var i2 = 2; i2 < wnd.length; i2++) {
          wnd[i2] = this.mul(wnd[i2 - 1], a2);
        }
        var res = wnd[0];
        var current = 0;
        var currentLen = 0;
        var start = num.bitLength() % 26;
        if (start === 0) {
          start = 26;
        }
        for (i2 = num.length - 1; i2 >= 0; i2--) {
          var word = num.words[i2];
          for (var j = start - 1; j >= 0; j--) {
            var bit = word >> j & 1;
            if (res !== wnd[0]) {
              res = this.sqr(res);
            }
            if (bit === 0 && current === 0) {
              currentLen = 0;
              continue;
            }
            current <<= 1;
            current |= bit;
            currentLen++;
            if (currentLen !== windowSize && (i2 !== 0 || j !== 0)) continue;
            res = this.mul(res, wnd[current]);
            currentLen = 0;
            current = 0;
          }
          start = 26;
        }
        return res;
      };
      Red.prototype.convertTo = function convertTo(num) {
        var r2 = num.umod(this.m);
        return r2 === num ? r2.clone() : r2;
      };
      Red.prototype.convertFrom = function convertFrom(num) {
        var res = num.clone();
        res.red = null;
        return res;
      };
      BN.mont = function mont2(num) {
        return new Mont(num);
      };
      function Mont(m) {
        Red.call(this, m);
        this.shift = this.m.bitLength();
        if (this.shift % 26 !== 0) {
          this.shift += 26 - this.shift % 26;
        }
        this.r = new BN(1).iushln(this.shift);
        this.r2 = this.imod(this.r.sqr());
        this.rinv = this.r._invmp(this.m);
        this.minv = this.rinv.mul(this.r).isubn(1).div(this.m);
        this.minv = this.minv.umod(this.r);
        this.minv = this.r.sub(this.minv);
      }
      inherits(Mont, Red);
      Mont.prototype.convertTo = function convertTo(num) {
        return this.imod(num.ushln(this.shift));
      };
      Mont.prototype.convertFrom = function convertFrom(num) {
        var r2 = this.imod(num.mul(this.rinv));
        r2.red = null;
        return r2;
      };
      Mont.prototype.imul = function imul(a2, b2) {
        if (a2.isZero() || b2.isZero()) {
          a2.words[0] = 0;
          a2.length = 1;
          return a2;
        }
        var t2 = a2.imul(b2);
        var c2 = t2.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);
        var u2 = t2.isub(c2).iushrn(this.shift);
        var res = u2;
        if (u2.cmp(this.m) >= 0) {
          res = u2.isub(this.m);
        } else if (u2.cmpn(0) < 0) {
          res = u2.iadd(this.m);
        }
        return res._forceRed(this);
      };
      Mont.prototype.mul = function mul(a2, b2) {
        if (a2.isZero() || b2.isZero()) return new BN(0)._forceRed(this);
        var t2 = a2.mul(b2);
        var c2 = t2.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);
        var u2 = t2.isub(c2).iushrn(this.shift);
        var res = u2;
        if (u2.cmp(this.m) >= 0) {
          res = u2.isub(this.m);
        } else if (u2.cmpn(0) < 0) {
          res = u2.iadd(this.m);
        }
        return res._forceRed(this);
      };
      Mont.prototype.invm = function invm(a2) {
        var res = this.imod(a2._invmp(this.m).mul(this.r2));
        return res._forceRed(this);
      };
    })(module2, bn$2);
  })(bn$3);
  return bn$3.exports;
}
var brorand = { exports: {} };
var hasRequiredBrorand;
function requireBrorand() {
  if (hasRequiredBrorand) return brorand.exports;
  hasRequiredBrorand = 1;
  var r2;
  brorand.exports = function rand(len) {
    if (!r2)
      r2 = new Rand(null);
    return r2.generate(len);
  };
  function Rand(rand) {
    this.rand = rand;
  }
  brorand.exports.Rand = Rand;
  Rand.prototype.generate = function generate(len) {
    return this._rand(len);
  };
  Rand.prototype._rand = function _rand(n2) {
    if (this.rand.getBytes)
      return this.rand.getBytes(n2);
    var res = new Uint8Array(n2);
    for (var i2 = 0; i2 < res.length; i2++)
      res[i2] = this.rand.getByte();
    return res;
  };
  if (typeof self === "object") {
    if (self.crypto && self.crypto.getRandomValues) {
      Rand.prototype._rand = function _rand(n2) {
        var arr = new Uint8Array(n2);
        self.crypto.getRandomValues(arr);
        return arr;
      };
    } else if (self.msCrypto && self.msCrypto.getRandomValues) {
      Rand.prototype._rand = function _rand(n2) {
        var arr = new Uint8Array(n2);
        self.msCrypto.getRandomValues(arr);
        return arr;
      };
    } else if (typeof window === "object") {
      Rand.prototype._rand = function() {
        throw new Error("Not implemented yet");
      };
    }
  } else {
    try {
      var crypto2 = /* @__PURE__ */ requireCryptoBrowserify();
      if (typeof crypto2.randomBytes !== "function")
        throw new Error("Not supported");
      Rand.prototype._rand = function _rand(n2) {
        return crypto2.randomBytes(n2);
      };
    } catch (e4) {
    }
  }
  return brorand.exports;
}
var mr;
var hasRequiredMr;
function requireMr() {
  if (hasRequiredMr) return mr;
  hasRequiredMr = 1;
  var bn2 = requireBn$1();
  var brorand2 = requireBrorand();
  function MillerRabin(rand) {
    this.rand = rand || new brorand2.Rand();
  }
  mr = MillerRabin;
  MillerRabin.create = function create2(rand) {
    return new MillerRabin(rand);
  };
  MillerRabin.prototype._randbelow = function _randbelow(n2) {
    var len = n2.bitLength();
    var min_bytes = Math.ceil(len / 8);
    do
      var a2 = new bn2(this.rand.generate(min_bytes));
    while (a2.cmp(n2) >= 0);
    return a2;
  };
  MillerRabin.prototype._randrange = function _randrange(start, stop) {
    var size = stop.sub(start);
    return start.add(this._randbelow(size));
  };
  MillerRabin.prototype.test = function test(n2, k2, cb) {
    var len = n2.bitLength();
    var red = bn2.mont(n2);
    var rone = new bn2(1).toRed(red);
    if (!k2)
      k2 = Math.max(1, len / 48 | 0);
    var n1 = n2.subn(1);
    for (var s2 = 0; !n1.testn(s2); s2++) {
    }
    var d = n2.shrn(s2);
    var rn1 = n1.toRed(red);
    var prime = true;
    for (; k2 > 0; k2--) {
      var a2 = this._randrange(new bn2(2), n1);
      if (cb)
        cb(a2);
      var x2 = a2.toRed(red).redPow(d);
      if (x2.cmp(rone) === 0 || x2.cmp(rn1) === 0)
        continue;
      for (var i2 = 1; i2 < s2; i2++) {
        x2 = x2.redSqr();
        if (x2.cmp(rone) === 0)
          return false;
        if (x2.cmp(rn1) === 0)
          break;
      }
      if (i2 === s2)
        return false;
    }
    return prime;
  };
  MillerRabin.prototype.getDivisor = function getDivisor(n2, k2) {
    var len = n2.bitLength();
    var red = bn2.mont(n2);
    var rone = new bn2(1).toRed(red);
    if (!k2)
      k2 = Math.max(1, len / 48 | 0);
    var n1 = n2.subn(1);
    for (var s2 = 0; !n1.testn(s2); s2++) {
    }
    var d = n2.shrn(s2);
    var rn1 = n1.toRed(red);
    for (; k2 > 0; k2--) {
      var a2 = this._randrange(new bn2(2), n1);
      var g = n2.gcd(a2);
      if (g.cmpn(1) !== 0)
        return g;
      var x2 = a2.toRed(red).redPow(d);
      if (x2.cmp(rone) === 0 || x2.cmp(rn1) === 0)
        continue;
      for (var i2 = 1; i2 < s2; i2++) {
        x2 = x2.redSqr();
        if (x2.cmp(rone) === 0)
          return x2.fromRed().subn(1).gcd(n2);
        if (x2.cmp(rn1) === 0)
          break;
      }
      if (i2 === s2) {
        x2 = x2.redSqr();
        return x2.fromRed().subn(1).gcd(n2);
      }
    }
    return false;
  };
  return mr;
}
var generatePrime;
var hasRequiredGeneratePrime;
function requireGeneratePrime() {
  if (hasRequiredGeneratePrime) return generatePrime;
  hasRequiredGeneratePrime = 1;
  var randomBytes = requireBrowser$e();
  generatePrime = findPrime;
  findPrime.simpleSieve = simpleSieve;
  findPrime.fermatTest = fermatTest;
  var BN = requireBn$1();
  var TWENTYFOUR = new BN(24);
  var MillerRabin = requireMr();
  var millerRabin = new MillerRabin();
  var ONE = new BN(1);
  var TWO = new BN(2);
  var FIVE = new BN(5);
  new BN(16);
  new BN(8);
  var TEN = new BN(10);
  var THREE2 = new BN(3);
  new BN(7);
  var ELEVEN = new BN(11);
  var FOUR = new BN(4);
  new BN(12);
  var primes = null;
  function _getPrimes() {
    if (primes !== null)
      return primes;
    var limit = 1048576;
    var res = [];
    res[0] = 2;
    for (var i2 = 1, k2 = 3; k2 < limit; k2 += 2) {
      var sqrt = Math.ceil(Math.sqrt(k2));
      for (var j = 0; j < i2 && res[j] <= sqrt; j++)
        if (k2 % res[j] === 0)
          break;
      if (i2 !== j && res[j] <= sqrt)
        continue;
      res[i2++] = k2;
    }
    primes = res;
    return res;
  }
  function simpleSieve(p2) {
    var primes2 = _getPrimes();
    for (var i2 = 0; i2 < primes2.length; i2++)
      if (p2.modn(primes2[i2]) === 0) {
        if (p2.cmpn(primes2[i2]) === 0) {
          return true;
        } else {
          return false;
        }
      }
    return true;
  }
  function fermatTest(p2) {
    var red = BN.mont(p2);
    return TWO.toRed(red).redPow(p2.subn(1)).fromRed().cmpn(1) === 0;
  }
  function findPrime(bits, gen) {
    if (bits < 16) {
      if (gen === 2 || gen === 5) {
        return new BN([140, 123]);
      } else {
        return new BN([140, 39]);
      }
    }
    gen = new BN(gen);
    var num, n2;
    while (true) {
      num = new BN(randomBytes(Math.ceil(bits / 8)));
      while (num.bitLength() > bits) {
        num.ishrn(1);
      }
      if (num.isEven()) {
        num.iadd(ONE);
      }
      if (!num.testn(1)) {
        num.iadd(TWO);
      }
      if (!gen.cmp(TWO)) {
        while (num.mod(TWENTYFOUR).cmp(ELEVEN)) {
          num.iadd(FOUR);
        }
      } else if (!gen.cmp(FIVE)) {
        while (num.mod(TEN).cmp(THREE2)) {
          num.iadd(FOUR);
        }
      }
      n2 = num.shrn(1);
      if (simpleSieve(n2) && simpleSieve(num) && fermatTest(n2) && fermatTest(num) && millerRabin.test(n2) && millerRabin.test(num)) {
        return num;
      }
    }
  }
  return generatePrime;
}
const modp1 = { "gen": "02", "prime": "ffffffffffffffffc90fdaa22168c234c4c6628b80dc1cd129024e088a67cc74020bbea63b139b22514a08798e3404ddef9519b3cd3a431b302b0a6df25f14374fe1356d6d51c245e485b576625e7ec6f44c42e9a63a3620ffffffffffffffff" };
const modp2 = { "gen": "02", "prime": "ffffffffffffffffc90fdaa22168c234c4c6628b80dc1cd129024e088a67cc74020bbea63b139b22514a08798e3404ddef9519b3cd3a431b302b0a6df25f14374fe1356d6d51c245e485b576625e7ec6f44c42e9a637ed6b0bff5cb6f406b7edee386bfb5a899fa5ae9f24117c4b1fe649286651ece65381ffffffffffffffff" };
const modp5 = { "gen": "02", "prime": "ffffffffffffffffc90fdaa22168c234c4c6628b80dc1cd129024e088a67cc74020bbea63b139b22514a08798e3404ddef9519b3cd3a431b302b0a6df25f14374fe1356d6d51c245e485b576625e7ec6f44c42e9a637ed6b0bff5cb6f406b7edee386bfb5a899fa5ae9f24117c4b1fe649286651ece45b3dc2007cb8a163bf0598da48361c55d39a69163fa8fd24cf5f83655d23dca3ad961c62f356208552bb9ed529077096966d670c354e4abc9804f1746c08ca237327ffffffffffffffff" };
const modp14 = { "gen": "02", "prime": "ffffffffffffffffc90fdaa22168c234c4c6628b80dc1cd129024e088a67cc74020bbea63b139b22514a08798e3404ddef9519b3cd3a431b302b0a6df25f14374fe1356d6d51c245e485b576625e7ec6f44c42e9a637ed6b0bff5cb6f406b7edee386bfb5a899fa5ae9f24117c4b1fe649286651ece45b3dc2007cb8a163bf0598da48361c55d39a69163fa8fd24cf5f83655d23dca3ad961c62f356208552bb9ed529077096966d670c354e4abc9804f1746c08ca18217c32905e462e36ce3be39e772c180e86039b2783a2ec07a28fb5c55df06f4c52c9de2bcbf6955817183995497cea956ae515d2261898fa051015728e5a8aacaa68ffffffffffffffff" };
const modp15 = { "gen": "02", "prime": "ffffffffffffffffc90fdaa22168c234c4c6628b80dc1cd129024e088a67cc74020bbea63b139b22514a08798e3404ddef9519b3cd3a431b302b0a6df25f14374fe1356d6d51c245e485b576625e7ec6f44c42e9a637ed6b0bff5cb6f406b7edee386bfb5a899fa5ae9f24117c4b1fe649286651ece45b3dc2007cb8a163bf0598da48361c55d39a69163fa8fd24cf5f83655d23dca3ad961c62f356208552bb9ed529077096966d670c354e4abc9804f1746c08ca18217c32905e462e36ce3be39e772c180e86039b2783a2ec07a28fb5c55df06f4c52c9de2bcbf6955817183995497cea956ae515d2261898fa051015728e5a8aaac42dad33170d04507a33a85521abdf1cba64ecfb850458dbef0a8aea71575d060c7db3970f85a6e1e4c7abf5ae8cdb0933d71e8c94e04a25619dcee3d2261ad2ee6bf12ffa06d98a0864d87602733ec86a64521f2b18177b200cbbe117577a615d6c770988c0bad946e208e24fa074e5ab3143db5bfce0fd108e4b82d120a93ad2caffffffffffffffff" };
const modp16 = { "gen": "02", "prime": "ffffffffffffffffc90fdaa22168c234c4c6628b80dc1cd129024e088a67cc74020bbea63b139b22514a08798e3404ddef9519b3cd3a431b302b0a6df25f14374fe1356d6d51c245e485b576625e7ec6f44c42e9a637ed6b0bff5cb6f406b7edee386bfb5a899fa5ae9f24117c4b1fe649286651ece45b3dc2007cb8a163bf0598da48361c55d39a69163fa8fd24cf5f83655d23dca3ad961c62f356208552bb9ed529077096966d670c354e4abc9804f1746c08ca18217c32905e462e36ce3be39e772c180e86039b2783a2ec07a28fb5c55df06f4c52c9de2bcbf6955817183995497cea956ae515d2261898fa051015728e5a8aaac42dad33170d04507a33a85521abdf1cba64ecfb850458dbef0a8aea71575d060c7db3970f85a6e1e4c7abf5ae8cdb0933d71e8c94e04a25619dcee3d2261ad2ee6bf12ffa06d98a0864d87602733ec86a64521f2b18177b200cbbe117577a615d6c770988c0bad946e208e24fa074e5ab3143db5bfce0fd108e4b82d120a92108011a723c12a787e6d788719a10bdba5b2699c327186af4e23c1a946834b6150bda2583e9ca2ad44ce8dbbbc2db04de8ef92e8efc141fbecaa6287c59474e6bc05d99b2964fa090c3a2233ba186515be7ed1f612970cee2d7afb81bdd762170481cd0069127d5b05aa993b4ea988d8fddc186ffb7dc90a6c08f4df435c934063199ffffffffffffffff" };
const modp17 = { "gen": "02", "prime": "ffffffffffffffffc90fdaa22168c234c4c6628b80dc1cd129024e088a67cc74020bbea63b139b22514a08798e3404ddef9519b3cd3a431b302b0a6df25f14374fe1356d6d51c245e485b576625e7ec6f44c42e9a637ed6b0bff5cb6f406b7edee386bfb5a899fa5ae9f24117c4b1fe649286651ece45b3dc2007cb8a163bf0598da48361c55d39a69163fa8fd24cf5f83655d23dca3ad961c62f356208552bb9ed529077096966d670c354e4abc9804f1746c08ca18217c32905e462e36ce3be39e772c180e86039b2783a2ec07a28fb5c55df06f4c52c9de2bcbf6955817183995497cea956ae515d2261898fa051015728e5a8aaac42dad33170d04507a33a85521abdf1cba64ecfb850458dbef0a8aea71575d060c7db3970f85a6e1e4c7abf5ae8cdb0933d71e8c94e04a25619dcee3d2261ad2ee6bf12ffa06d98a0864d87602733ec86a64521f2b18177b200cbbe117577a615d6c770988c0bad946e208e24fa074e5ab3143db5bfce0fd108e4b82d120a92108011a723c12a787e6d788719a10bdba5b2699c327186af4e23c1a946834b6150bda2583e9ca2ad44ce8dbbbc2db04de8ef92e8efc141fbecaa6287c59474e6bc05d99b2964fa090c3a2233ba186515be7ed1f612970cee2d7afb81bdd762170481cd0069127d5b05aa993b4ea988d8fddc186ffb7dc90a6c08f4df435c93402849236c3fab4d27c7026c1d4dcb2602646dec9751e763dba37bdf8ff9406ad9e530ee5db382f413001aeb06a53ed9027d831179727b0865a8918da3edbebcf9b14ed44ce6cbaced4bb1bdb7f1447e6cc254b332051512bd7af426fb8f401378cd2bf5983ca01c64b92ecf032ea15d1721d03f482d7ce6e74fef6d55e702f46980c82b5a84031900b1c9e59e7c97fbec7e8f323a97a7e36cc88be0f1d45b7ff585ac54bd407b22b4154aacc8f6d7ebf48e1d814cc5ed20f8037e0a79715eef29be32806a1d58bb7c5da76f550aa3d8a1fbff0eb19ccb1a313d55cda56c9ec2ef29632387fe8d76e3c0468043e8f663f4860ee12bf2d5b0b7474d6e694f91e6dcc4024ffffffffffffffff" };
const modp18 = { "gen": "02", "prime": "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" };
const require$$1$1 = {
  modp1,
  modp2,
  modp5,
  modp14,
  modp15,
  modp16,
  modp17,
  modp18
};
var dh;
var hasRequiredDh;
function requireDh() {
  if (hasRequiredDh) return dh;
  hasRequiredDh = 1;
  var BN = requireBn$1();
  var MillerRabin = requireMr();
  var millerRabin = new MillerRabin();
  var TWENTYFOUR = new BN(24);
  var ELEVEN = new BN(11);
  var TEN = new BN(10);
  var THREE2 = new BN(3);
  var SEVEN = new BN(7);
  var primes = requireGeneratePrime();
  var randomBytes = requireBrowser$e();
  dh = DH;
  function setPublicKey(pub, enc) {
    enc = enc || "utf8";
    if (!Buffer.isBuffer(pub)) {
      pub = new Buffer(pub, enc);
    }
    this._pub = new BN(pub);
    return this;
  }
  function setPrivateKey(priv, enc) {
    enc = enc || "utf8";
    if (!Buffer.isBuffer(priv)) {
      priv = new Buffer(priv, enc);
    }
    this._priv = new BN(priv);
    return this;
  }
  var primeCache = {};
  function checkPrime(prime, generator) {
    var gen = generator.toString("hex");
    var hex = [gen, prime.toString(16)].join("_");
    if (hex in primeCache) {
      return primeCache[hex];
    }
    var error = 0;
    if (prime.isEven() || !primes.simpleSieve || !primes.fermatTest(prime) || !millerRabin.test(prime)) {
      error += 1;
      if (gen === "02" || gen === "05") {
        error += 8;
      } else {
        error += 4;
      }
      primeCache[hex] = error;
      return error;
    }
    if (!millerRabin.test(prime.shrn(1))) {
      error += 2;
    }
    var rem;
    switch (gen) {
      case "02":
        if (prime.mod(TWENTYFOUR).cmp(ELEVEN)) {
          error += 8;
        }
        break;
      case "05":
        rem = prime.mod(TEN);
        if (rem.cmp(THREE2) && rem.cmp(SEVEN)) {
          error += 8;
        }
        break;
      default:
        error += 4;
    }
    primeCache[hex] = error;
    return error;
  }
  function DH(prime, generator, malleable) {
    this.setGenerator(generator);
    this.__prime = new BN(prime);
    this._prime = BN.mont(this.__prime);
    this._primeLen = prime.length;
    this._pub = void 0;
    this._priv = void 0;
    this._primeCode = void 0;
    if (malleable) {
      this.setPublicKey = setPublicKey;
      this.setPrivateKey = setPrivateKey;
    } else {
      this._primeCode = 8;
    }
  }
  Object.defineProperty(DH.prototype, "verifyError", {
    enumerable: true,
    get: function() {
      if (typeof this._primeCode !== "number") {
        this._primeCode = checkPrime(this.__prime, this.__gen);
      }
      return this._primeCode;
    }
  });
  DH.prototype.generateKeys = function() {
    if (!this._priv) {
      this._priv = new BN(randomBytes(this._primeLen));
    }
    this._pub = this._gen.toRed(this._prime).redPow(this._priv).fromRed();
    return this.getPublicKey();
  };
  DH.prototype.computeSecret = function(other) {
    other = new BN(other);
    other = other.toRed(this._prime);
    var secret = other.redPow(this._priv).fromRed();
    var out = new Buffer(secret.toArray());
    var prime = this.getPrime();
    if (out.length < prime.length) {
      var front = new Buffer(prime.length - out.length);
      front.fill(0);
      out = Buffer.concat([front, out]);
    }
    return out;
  };
  DH.prototype.getPublicKey = function getPublicKey(enc) {
    return formatReturnValue(this._pub, enc);
  };
  DH.prototype.getPrivateKey = function getPrivateKey(enc) {
    return formatReturnValue(this._priv, enc);
  };
  DH.prototype.getPrime = function(enc) {
    return formatReturnValue(this.__prime, enc);
  };
  DH.prototype.getGenerator = function(enc) {
    return formatReturnValue(this._gen, enc);
  };
  DH.prototype.setGenerator = function(gen, enc) {
    enc = enc || "utf8";
    if (!Buffer.isBuffer(gen)) {
      gen = new Buffer(gen, enc);
    }
    this.__gen = gen;
    this._gen = new BN(gen);
    return this;
  };
  function formatReturnValue(bn2, enc) {
    var buf = new Buffer(bn2.toArray());
    if (!enc) {
      return buf;
    } else {
      return buf.toString(enc);
    }
  }
  return dh;
}
var hasRequiredBrowser$7;
function requireBrowser$7() {
  if (hasRequiredBrowser$7) return browser$9;
  hasRequiredBrowser$7 = 1;
  var generatePrime2 = requireGeneratePrime();
  var primes = require$$1$1;
  var DH = requireDh();
  function getDiffieHellman(mod) {
    var prime = new Buffer(primes[mod].prime, "hex");
    var gen = new Buffer(primes[mod].gen, "hex");
    return new DH(prime, gen);
  }
  var ENCODINGS = {
    "binary": true,
    "hex": true,
    "base64": true
  };
  function createDiffieHellman(prime, enc, generator, genc) {
    if (Buffer.isBuffer(enc) || ENCODINGS[enc] === void 0) {
      return createDiffieHellman(prime, "binary", enc, generator);
    }
    enc = enc || "binary";
    genc = genc || "binary";
    generator = generator || new Buffer([2]);
    if (!Buffer.isBuffer(generator)) {
      generator = new Buffer(generator, genc);
    }
    if (typeof prime === "number") {
      return new DH(generatePrime2(prime, generator), generator, true);
    }
    if (!Buffer.isBuffer(prime)) {
      prime = new Buffer(prime, enc);
    }
    return new DH(prime, generator, true);
  }
  browser$9.DiffieHellmanGroup = browser$9.createDiffieHellmanGroup = browser$9.getDiffieHellman = getDiffieHellman;
  browser$9.createDiffieHellman = browser$9.DiffieHellman = createDiffieHellman;
  return browser$9;
}
var sign = { exports: {} };
var bn$1 = { exports: {} };
var bn = bn$1.exports;
var hasRequiredBn;
function requireBn() {
  if (hasRequiredBn) return bn$1.exports;
  hasRequiredBn = 1;
  (function(module2) {
    (function(module3, exports) {
      function assert(val, msg) {
        if (!val) throw new Error(msg || "Assertion failed");
      }
      function inherits(ctor, superCtor) {
        ctor.super_ = superCtor;
        var TempCtor = function() {
        };
        TempCtor.prototype = superCtor.prototype;
        ctor.prototype = new TempCtor();
        ctor.prototype.constructor = ctor;
      }
      function BN(number, base2, endian) {
        if (BN.isBN(number)) {
          return number;
        }
        this.negative = 0;
        this.words = null;
        this.length = 0;
        this.red = null;
        if (number !== null) {
          if (base2 === "le" || base2 === "be") {
            endian = base2;
            base2 = 10;
          }
          this._init(number || 0, base2 || 10, endian || "be");
        }
      }
      if (typeof module3 === "object") {
        module3.exports = BN;
      } else {
        exports.BN = BN;
      }
      BN.BN = BN;
      BN.wordSize = 26;
      var Buffer2;
      try {
        if (typeof window !== "undefined" && typeof window.Buffer !== "undefined") {
          Buffer2 = window.Buffer;
        } else {
          Buffer2 = require$$0$2.Buffer;
        }
      } catch (e4) {
      }
      BN.isBN = function isBN(num) {
        if (num instanceof BN) {
          return true;
        }
        return num !== null && typeof num === "object" && num.constructor.wordSize === BN.wordSize && Array.isArray(num.words);
      };
      BN.max = function max2(left, right) {
        if (left.cmp(right) > 0) return left;
        return right;
      };
      BN.min = function min2(left, right) {
        if (left.cmp(right) < 0) return left;
        return right;
      };
      BN.prototype._init = function init2(number, base2, endian) {
        if (typeof number === "number") {
          return this._initNumber(number, base2, endian);
        }
        if (typeof number === "object") {
          return this._initArray(number, base2, endian);
        }
        if (base2 === "hex") {
          base2 = 16;
        }
        assert(base2 === (base2 | 0) && base2 >= 2 && base2 <= 36);
        number = number.toString().replace(/\s+/g, "");
        var start = 0;
        if (number[0] === "-") {
          start++;
          this.negative = 1;
        }
        if (start < number.length) {
          if (base2 === 16) {
            this._parseHex(number, start, endian);
          } else {
            this._parseBase(number, base2, start);
            if (endian === "le") {
              this._initArray(this.toArray(), base2, endian);
            }
          }
        }
      };
      BN.prototype._initNumber = function _initNumber(number, base2, endian) {
        if (number < 0) {
          this.negative = 1;
          number = -number;
        }
        if (number < 67108864) {
          this.words = [number & 67108863];
          this.length = 1;
        } else if (number < 4503599627370496) {
          this.words = [
            number & 67108863,
            number / 67108864 & 67108863
          ];
          this.length = 2;
        } else {
          assert(number < 9007199254740992);
          this.words = [
            number & 67108863,
            number / 67108864 & 67108863,
            1
          ];
          this.length = 3;
        }
        if (endian !== "le") return;
        this._initArray(this.toArray(), base2, endian);
      };
      BN.prototype._initArray = function _initArray(number, base2, endian) {
        assert(typeof number.length === "number");
        if (number.length <= 0) {
          this.words = [0];
          this.length = 1;
          return this;
        }
        this.length = Math.ceil(number.length / 3);
        this.words = new Array(this.length);
        for (var i2 = 0; i2 < this.length; i2++) {
          this.words[i2] = 0;
        }
        var j, w;
        var off = 0;
        if (endian === "be") {
          for (i2 = number.length - 1, j = 0; i2 >= 0; i2 -= 3) {
            w = number[i2] | number[i2 - 1] << 8 | number[i2 - 2] << 16;
            this.words[j] |= w << off & 67108863;
            this.words[j + 1] = w >>> 26 - off & 67108863;
            off += 24;
            if (off >= 26) {
              off -= 26;
              j++;
            }
          }
        } else if (endian === "le") {
          for (i2 = 0, j = 0; i2 < number.length; i2 += 3) {
            w = number[i2] | number[i2 + 1] << 8 | number[i2 + 2] << 16;
            this.words[j] |= w << off & 67108863;
            this.words[j + 1] = w >>> 26 - off & 67108863;
            off += 24;
            if (off >= 26) {
              off -= 26;
              j++;
            }
          }
        }
        return this._strip();
      };
      function parseHex4Bits(string, index2) {
        var c2 = string.charCodeAt(index2);
        if (c2 >= 48 && c2 <= 57) {
          return c2 - 48;
        } else if (c2 >= 65 && c2 <= 70) {
          return c2 - 55;
        } else if (c2 >= 97 && c2 <= 102) {
          return c2 - 87;
        } else {
          assert(false, "Invalid character in " + string);
        }
      }
      function parseHexByte(string, lowerBound, index2) {
        var r2 = parseHex4Bits(string, index2);
        if (index2 - 1 >= lowerBound) {
          r2 |= parseHex4Bits(string, index2 - 1) << 4;
        }
        return r2;
      }
      BN.prototype._parseHex = function _parseHex(number, start, endian) {
        this.length = Math.ceil((number.length - start) / 6);
        this.words = new Array(this.length);
        for (var i2 = 0; i2 < this.length; i2++) {
          this.words[i2] = 0;
        }
        var off = 0;
        var j = 0;
        var w;
        if (endian === "be") {
          for (i2 = number.length - 1; i2 >= start; i2 -= 2) {
            w = parseHexByte(number, start, i2) << off;
            this.words[j] |= w & 67108863;
            if (off >= 18) {
              off -= 18;
              j += 1;
              this.words[j] |= w >>> 26;
            } else {
              off += 8;
            }
          }
        } else {
          var parseLength = number.length - start;
          for (i2 = parseLength % 2 === 0 ? start + 1 : start; i2 < number.length; i2 += 2) {
            w = parseHexByte(number, start, i2) << off;
            this.words[j] |= w & 67108863;
            if (off >= 18) {
              off -= 18;
              j += 1;
              this.words[j] |= w >>> 26;
            } else {
              off += 8;
            }
          }
        }
        this._strip();
      };
      function parseBase(str, start, end, mul) {
        var r2 = 0;
        var b2 = 0;
        var len = Math.min(str.length, end);
        for (var i2 = start; i2 < len; i2++) {
          var c2 = str.charCodeAt(i2) - 48;
          r2 *= mul;
          if (c2 >= 49) {
            b2 = c2 - 49 + 10;
          } else if (c2 >= 17) {
            b2 = c2 - 17 + 10;
          } else {
            b2 = c2;
          }
          assert(c2 >= 0 && b2 < mul, "Invalid character");
          r2 += b2;
        }
        return r2;
      }
      BN.prototype._parseBase = function _parseBase(number, base2, start) {
        this.words = [0];
        this.length = 1;
        for (var limbLen = 0, limbPow = 1; limbPow <= 67108863; limbPow *= base2) {
          limbLen++;
        }
        limbLen--;
        limbPow = limbPow / base2 | 0;
        var total = number.length - start;
        var mod = total % limbLen;
        var end = Math.min(total, total - mod) + start;
        var word = 0;
        for (var i2 = start; i2 < end; i2 += limbLen) {
          word = parseBase(number, i2, i2 + limbLen, base2);
          this.imuln(limbPow);
          if (this.words[0] + word < 67108864) {
            this.words[0] += word;
          } else {
            this._iaddn(word);
          }
        }
        if (mod !== 0) {
          var pow2 = 1;
          word = parseBase(number, i2, number.length, base2);
          for (i2 = 0; i2 < mod; i2++) {
            pow2 *= base2;
          }
          this.imuln(pow2);
          if (this.words[0] + word < 67108864) {
            this.words[0] += word;
          } else {
            this._iaddn(word);
          }
        }
        this._strip();
      };
      BN.prototype.copy = function copy2(dest) {
        dest.words = new Array(this.length);
        for (var i2 = 0; i2 < this.length; i2++) {
          dest.words[i2] = this.words[i2];
        }
        dest.length = this.length;
        dest.negative = this.negative;
        dest.red = this.red;
      };
      function move(dest, src2) {
        dest.words = src2.words;
        dest.length = src2.length;
        dest.negative = src2.negative;
        dest.red = src2.red;
      }
      BN.prototype._move = function _move(dest) {
        move(dest, this);
      };
      BN.prototype.clone = function clone2() {
        var r2 = new BN(null);
        this.copy(r2);
        return r2;
      };
      BN.prototype._expand = function _expand(size) {
        while (this.length < size) {
          this.words[this.length++] = 0;
        }
        return this;
      };
      BN.prototype._strip = function strip() {
        while (this.length > 1 && this.words[this.length - 1] === 0) {
          this.length--;
        }
        return this._normSign();
      };
      BN.prototype._normSign = function _normSign() {
        if (this.length === 1 && this.words[0] === 0) {
          this.negative = 0;
        }
        return this;
      };
      if (typeof Symbol !== "undefined" && typeof Symbol.for === "function") {
        try {
          BN.prototype[Symbol.for("nodejs.util.inspect.custom")] = inspect;
        } catch (e4) {
          BN.prototype.inspect = inspect;
        }
      } else {
        BN.prototype.inspect = inspect;
      }
      function inspect() {
        return (this.red ? "<BN-R: " : "<BN: ") + this.toString(16) + ">";
      }
      var zeros = [
        "",
        "0",
        "00",
        "000",
        "0000",
        "00000",
        "000000",
        "0000000",
        "00000000",
        "000000000",
        "0000000000",
        "00000000000",
        "000000000000",
        "0000000000000",
        "00000000000000",
        "000000000000000",
        "0000000000000000",
        "00000000000000000",
        "000000000000000000",
        "0000000000000000000",
        "00000000000000000000",
        "000000000000000000000",
        "0000000000000000000000",
        "00000000000000000000000",
        "000000000000000000000000",
        "0000000000000000000000000"
      ];
      var groupSizes = [
        0,
        0,
        25,
        16,
        12,
        11,
        10,
        9,
        8,
        8,
        7,
        7,
        7,
        7,
        6,
        6,
        6,
        6,
        6,
        6,
        6,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5,
        5
      ];
      var groupBases = [
        0,
        0,
        33554432,
        43046721,
        16777216,
        48828125,
        60466176,
        40353607,
        16777216,
        43046721,
        1e7,
        19487171,
        35831808,
        62748517,
        7529536,
        11390625,
        16777216,
        24137569,
        34012224,
        47045881,
        64e6,
        4084101,
        5153632,
        6436343,
        7962624,
        9765625,
        11881376,
        14348907,
        17210368,
        20511149,
        243e5,
        28629151,
        33554432,
        39135393,
        45435424,
        52521875,
        60466176
      ];
      BN.prototype.toString = function toString2(base2, padding) {
        base2 = base2 || 10;
        padding = padding | 0 || 1;
        var out;
        if (base2 === 16 || base2 === "hex") {
          out = "";
          var off = 0;
          var carry = 0;
          for (var i2 = 0; i2 < this.length; i2++) {
            var w = this.words[i2];
            var word = ((w << off | carry) & 16777215).toString(16);
            carry = w >>> 24 - off & 16777215;
            off += 2;
            if (off >= 26) {
              off -= 26;
              i2--;
            }
            if (carry !== 0 || i2 !== this.length - 1) {
              out = zeros[6 - word.length] + word + out;
            } else {
              out = word + out;
            }
          }
          if (carry !== 0) {
            out = carry.toString(16) + out;
          }
          while (out.length % padding !== 0) {
            out = "0" + out;
          }
          if (this.negative !== 0) {
            out = "-" + out;
          }
          return out;
        }
        if (base2 === (base2 | 0) && base2 >= 2 && base2 <= 36) {
          var groupSize = groupSizes[base2];
          var groupBase = groupBases[base2];
          out = "";
          var c2 = this.clone();
          c2.negative = 0;
          while (!c2.isZero()) {
            var r2 = c2.modrn(groupBase).toString(base2);
            c2 = c2.idivn(groupBase);
            if (!c2.isZero()) {
              out = zeros[groupSize - r2.length] + r2 + out;
            } else {
              out = r2 + out;
            }
          }
          if (this.isZero()) {
            out = "0" + out;
          }
          while (out.length % padding !== 0) {
            out = "0" + out;
          }
          if (this.negative !== 0) {
            out = "-" + out;
          }
          return out;
        }
        assert(false, "Base should be between 2 and 36");
      };
      BN.prototype.toNumber = function toNumber() {
        var ret = this.words[0];
        if (this.length === 2) {
          ret += this.words[1] * 67108864;
        } else if (this.length === 3 && this.words[2] === 1) {
          ret += 4503599627370496 + this.words[1] * 67108864;
        } else if (this.length > 2) {
          assert(false, "Number can only safely store up to 53 bits");
        }
        return this.negative !== 0 ? -ret : ret;
      };
      BN.prototype.toJSON = function toJSON() {
        return this.toString(16, 2);
      };
      if (Buffer2) {
        BN.prototype.toBuffer = function toBuffer2(endian, length) {
          return this.toArrayLike(Buffer2, endian, length);
        };
      }
      BN.prototype.toArray = function toArray(endian, length) {
        return this.toArrayLike(Array, endian, length);
      };
      var allocate = function allocate2(ArrayType, size) {
        if (ArrayType.allocUnsafe) {
          return ArrayType.allocUnsafe(size);
        }
        return new ArrayType(size);
      };
      BN.prototype.toArrayLike = function toArrayLike(ArrayType, endian, length) {
        this._strip();
        var byteLength2 = this.byteLength();
        var reqLength = length || Math.max(1, byteLength2);
        assert(byteLength2 <= reqLength, "byte array longer than desired length");
        assert(reqLength > 0, "Requested array length <= 0");
        var res = allocate(ArrayType, reqLength);
        var postfix = endian === "le" ? "LE" : "BE";
        this["_toArrayLike" + postfix](res, byteLength2);
        return res;
      };
      BN.prototype._toArrayLikeLE = function _toArrayLikeLE(res, byteLength2) {
        var position = 0;
        var carry = 0;
        for (var i2 = 0, shift = 0; i2 < this.length; i2++) {
          var word = this.words[i2] << shift | carry;
          res[position++] = word & 255;
          if (position < res.length) {
            res[position++] = word >> 8 & 255;
          }
          if (position < res.length) {
            res[position++] = word >> 16 & 255;
          }
          if (shift === 6) {
            if (position < res.length) {
              res[position++] = word >> 24 & 255;
            }
            carry = 0;
            shift = 0;
          } else {
            carry = word >>> 24;
            shift += 2;
          }
        }
        if (position < res.length) {
          res[position++] = carry;
          while (position < res.length) {
            res[position++] = 0;
          }
        }
      };
      BN.prototype._toArrayLikeBE = function _toArrayLikeBE(res, byteLength2) {
        var position = res.length - 1;
        var carry = 0;
        for (var i2 = 0, shift = 0; i2 < this.length; i2++) {
          var word = this.words[i2] << shift | carry;
          res[position--] = word & 255;
          if (position >= 0) {
            res[position--] = word >> 8 & 255;
          }
          if (position >= 0) {
            res[position--] = word >> 16 & 255;
          }
          if (shift === 6) {
            if (position >= 0) {
              res[position--] = word >> 24 & 255;
            }
            carry = 0;
            shift = 0;
          } else {
            carry = word >>> 24;
            shift += 2;
          }
        }
        if (position >= 0) {
          res[position--] = carry;
          while (position >= 0) {
            res[position--] = 0;
          }
        }
      };
      if (Math.clz32) {
        BN.prototype._countBits = function _countBits(w) {
          return 32 - Math.clz32(w);
        };
      } else {
        BN.prototype._countBits = function _countBits(w) {
          var t2 = w;
          var r2 = 0;
          if (t2 >= 4096) {
            r2 += 13;
            t2 >>>= 13;
          }
          if (t2 >= 64) {
            r2 += 7;
            t2 >>>= 7;
          }
          if (t2 >= 8) {
            r2 += 4;
            t2 >>>= 4;
          }
          if (t2 >= 2) {
            r2 += 2;
            t2 >>>= 2;
          }
          return r2 + t2;
        };
      }
      BN.prototype._zeroBits = function _zeroBits(w) {
        if (w === 0) return 26;
        var t2 = w;
        var r2 = 0;
        if ((t2 & 8191) === 0) {
          r2 += 13;
          t2 >>>= 13;
        }
        if ((t2 & 127) === 0) {
          r2 += 7;
          t2 >>>= 7;
        }
        if ((t2 & 15) === 0) {
          r2 += 4;
          t2 >>>= 4;
        }
        if ((t2 & 3) === 0) {
          r2 += 2;
          t2 >>>= 2;
        }
        if ((t2 & 1) === 0) {
          r2++;
        }
        return r2;
      };
      BN.prototype.bitLength = function bitLength() {
        var w = this.words[this.length - 1];
        var hi = this._countBits(w);
        return (this.length - 1) * 26 + hi;
      };
      function toBitArray(num) {
        var w = new Array(num.bitLength());
        for (var bit = 0; bit < w.length; bit++) {
          var off = bit / 26 | 0;
          var wbit = bit % 26;
          w[bit] = num.words[off] >>> wbit & 1;
        }
        return w;
      }
      BN.prototype.zeroBits = function zeroBits() {
        if (this.isZero()) return 0;
        var r2 = 0;
        for (var i2 = 0; i2 < this.length; i2++) {
          var b2 = this._zeroBits(this.words[i2]);
          r2 += b2;
          if (b2 !== 26) break;
        }
        return r2;
      };
      BN.prototype.byteLength = function byteLength2() {
        return Math.ceil(this.bitLength() / 8);
      };
      BN.prototype.toTwos = function toTwos(width) {
        if (this.negative !== 0) {
          return this.abs().inotn(width).iaddn(1);
        }
        return this.clone();
      };
      BN.prototype.fromTwos = function fromTwos(width) {
        if (this.testn(width - 1)) {
          return this.notn(width).iaddn(1).ineg();
        }
        return this.clone();
      };
      BN.prototype.isNeg = function isNeg() {
        return this.negative !== 0;
      };
      BN.prototype.neg = function neg() {
        return this.clone().ineg();
      };
      BN.prototype.ineg = function ineg() {
        if (!this.isZero()) {
          this.negative ^= 1;
        }
        return this;
      };
      BN.prototype.iuor = function iuor(num) {
        while (this.length < num.length) {
          this.words[this.length++] = 0;
        }
        for (var i2 = 0; i2 < num.length; i2++) {
          this.words[i2] = this.words[i2] | num.words[i2];
        }
        return this._strip();
      };
      BN.prototype.ior = function ior(num) {
        assert((this.negative | num.negative) === 0);
        return this.iuor(num);
      };
      BN.prototype.or = function or2(num) {
        if (this.length > num.length) return this.clone().ior(num);
        return num.clone().ior(this);
      };
      BN.prototype.uor = function uor(num) {
        if (this.length > num.length) return this.clone().iuor(num);
        return num.clone().iuor(this);
      };
      BN.prototype.iuand = function iuand(num) {
        var b2;
        if (this.length > num.length) {
          b2 = num;
        } else {
          b2 = this;
        }
        for (var i2 = 0; i2 < b2.length; i2++) {
          this.words[i2] = this.words[i2] & num.words[i2];
        }
        this.length = b2.length;
        return this._strip();
      };
      BN.prototype.iand = function iand(num) {
        assert((this.negative | num.negative) === 0);
        return this.iuand(num);
      };
      BN.prototype.and = function and2(num) {
        if (this.length > num.length) return this.clone().iand(num);
        return num.clone().iand(this);
      };
      BN.prototype.uand = function uand(num) {
        if (this.length > num.length) return this.clone().iuand(num);
        return num.clone().iuand(this);
      };
      BN.prototype.iuxor = function iuxor(num) {
        var a2;
        var b2;
        if (this.length > num.length) {
          a2 = this;
          b2 = num;
        } else {
          a2 = num;
          b2 = this;
        }
        for (var i2 = 0; i2 < b2.length; i2++) {
          this.words[i2] = a2.words[i2] ^ b2.words[i2];
        }
        if (this !== a2) {
          for (; i2 < a2.length; i2++) {
            this.words[i2] = a2.words[i2];
          }
        }
        this.length = a2.length;
        return this._strip();
      };
      BN.prototype.ixor = function ixor(num) {
        assert((this.negative | num.negative) === 0);
        return this.iuxor(num);
      };
      BN.prototype.xor = function xor2(num) {
        if (this.length > num.length) return this.clone().ixor(num);
        return num.clone().ixor(this);
      };
      BN.prototype.uxor = function uxor(num) {
        if (this.length > num.length) return this.clone().iuxor(num);
        return num.clone().iuxor(this);
      };
      BN.prototype.inotn = function inotn(width) {
        assert(typeof width === "number" && width >= 0);
        var bytesNeeded = Math.ceil(width / 26) | 0;
        var bitsLeft = width % 26;
        this._expand(bytesNeeded);
        if (bitsLeft > 0) {
          bytesNeeded--;
        }
        for (var i2 = 0; i2 < bytesNeeded; i2++) {
          this.words[i2] = ~this.words[i2] & 67108863;
        }
        if (bitsLeft > 0) {
          this.words[i2] = ~this.words[i2] & 67108863 >> 26 - bitsLeft;
        }
        return this._strip();
      };
      BN.prototype.notn = function notn(width) {
        return this.clone().inotn(width);
      };
      BN.prototype.setn = function setn(bit, val) {
        assert(typeof bit === "number" && bit >= 0);
        var off = bit / 26 | 0;
        var wbit = bit % 26;
        this._expand(off + 1);
        if (val) {
          this.words[off] = this.words[off] | 1 << wbit;
        } else {
          this.words[off] = this.words[off] & ~(1 << wbit);
        }
        return this._strip();
      };
      BN.prototype.iadd = function iadd(num) {
        var r2;
        if (this.negative !== 0 && num.negative === 0) {
          this.negative = 0;
          r2 = this.isub(num);
          this.negative ^= 1;
          return this._normSign();
        } else if (this.negative === 0 && num.negative !== 0) {
          num.negative = 0;
          r2 = this.isub(num);
          num.negative = 1;
          return r2._normSign();
        }
        var a2, b2;
        if (this.length > num.length) {
          a2 = this;
          b2 = num;
        } else {
          a2 = num;
          b2 = this;
        }
        var carry = 0;
        for (var i2 = 0; i2 < b2.length; i2++) {
          r2 = (a2.words[i2] | 0) + (b2.words[i2] | 0) + carry;
          this.words[i2] = r2 & 67108863;
          carry = r2 >>> 26;
        }
        for (; carry !== 0 && i2 < a2.length; i2++) {
          r2 = (a2.words[i2] | 0) + carry;
          this.words[i2] = r2 & 67108863;
          carry = r2 >>> 26;
        }
        this.length = a2.length;
        if (carry !== 0) {
          this.words[this.length] = carry;
          this.length++;
        } else if (a2 !== this) {
          for (; i2 < a2.length; i2++) {
            this.words[i2] = a2.words[i2];
          }
        }
        return this;
      };
      BN.prototype.add = function add2(num) {
        var res;
        if (num.negative !== 0 && this.negative === 0) {
          num.negative = 0;
          res = this.sub(num);
          num.negative ^= 1;
          return res;
        } else if (num.negative === 0 && this.negative !== 0) {
          this.negative = 0;
          res = num.sub(this);
          this.negative = 1;
          return res;
        }
        if (this.length > num.length) return this.clone().iadd(num);
        return num.clone().iadd(this);
      };
      BN.prototype.isub = function isub(num) {
        if (num.negative !== 0) {
          num.negative = 0;
          var r2 = this.iadd(num);
          num.negative = 1;
          return r2._normSign();
        } else if (this.negative !== 0) {
          this.negative = 0;
          this.iadd(num);
          this.negative = 1;
          return this._normSign();
        }
        var cmp = this.cmp(num);
        if (cmp === 0) {
          this.negative = 0;
          this.length = 1;
          this.words[0] = 0;
          return this;
        }
        var a2, b2;
        if (cmp > 0) {
          a2 = this;
          b2 = num;
        } else {
          a2 = num;
          b2 = this;
        }
        var carry = 0;
        for (var i2 = 0; i2 < b2.length; i2++) {
          r2 = (a2.words[i2] | 0) - (b2.words[i2] | 0) + carry;
          carry = r2 >> 26;
          this.words[i2] = r2 & 67108863;
        }
        for (; carry !== 0 && i2 < a2.length; i2++) {
          r2 = (a2.words[i2] | 0) + carry;
          carry = r2 >> 26;
          this.words[i2] = r2 & 67108863;
        }
        if (carry === 0 && i2 < a2.length && a2 !== this) {
          for (; i2 < a2.length; i2++) {
            this.words[i2] = a2.words[i2];
          }
        }
        this.length = Math.max(this.length, i2);
        if (a2 !== this) {
          this.negative = 1;
        }
        return this._strip();
      };
      BN.prototype.sub = function sub(num) {
        return this.clone().isub(num);
      };
      function smallMulTo(self2, num, out) {
        out.negative = num.negative ^ self2.negative;
        var len = self2.length + num.length | 0;
        out.length = len;
        len = len - 1 | 0;
        var a2 = self2.words[0] | 0;
        var b2 = num.words[0] | 0;
        var r2 = a2 * b2;
        var lo = r2 & 67108863;
        var carry = r2 / 67108864 | 0;
        out.words[0] = lo;
        for (var k2 = 1; k2 < len; k2++) {
          var ncarry = carry >>> 26;
          var rword = carry & 67108863;
          var maxJ = Math.min(k2, num.length - 1);
          for (var j = Math.max(0, k2 - self2.length + 1); j <= maxJ; j++) {
            var i2 = k2 - j | 0;
            a2 = self2.words[i2] | 0;
            b2 = num.words[j] | 0;
            r2 = a2 * b2 + rword;
            ncarry += r2 / 67108864 | 0;
            rword = r2 & 67108863;
          }
          out.words[k2] = rword | 0;
          carry = ncarry | 0;
        }
        if (carry !== 0) {
          out.words[k2] = carry | 0;
        } else {
          out.length--;
        }
        return out._strip();
      }
      var comb10MulTo = function comb10MulTo2(self2, num, out) {
        var a2 = self2.words;
        var b2 = num.words;
        var o2 = out.words;
        var c2 = 0;
        var lo;
        var mid;
        var hi;
        var a0 = a2[0] | 0;
        var al0 = a0 & 8191;
        var ah0 = a0 >>> 13;
        var a1 = a2[1] | 0;
        var al1 = a1 & 8191;
        var ah1 = a1 >>> 13;
        var a22 = a2[2] | 0;
        var al2 = a22 & 8191;
        var ah2 = a22 >>> 13;
        var a3 = a2[3] | 0;
        var al3 = a3 & 8191;
        var ah3 = a3 >>> 13;
        var a4 = a2[4] | 0;
        var al4 = a4 & 8191;
        var ah4 = a4 >>> 13;
        var a5 = a2[5] | 0;
        var al5 = a5 & 8191;
        var ah5 = a5 >>> 13;
        var a6 = a2[6] | 0;
        var al6 = a6 & 8191;
        var ah6 = a6 >>> 13;
        var a7 = a2[7] | 0;
        var al7 = a7 & 8191;
        var ah7 = a7 >>> 13;
        var a8 = a2[8] | 0;
        var al8 = a8 & 8191;
        var ah8 = a8 >>> 13;
        var a9 = a2[9] | 0;
        var al9 = a9 & 8191;
        var ah9 = a9 >>> 13;
        var b0 = b2[0] | 0;
        var bl0 = b0 & 8191;
        var bh0 = b0 >>> 13;
        var b1 = b2[1] | 0;
        var bl1 = b1 & 8191;
        var bh1 = b1 >>> 13;
        var b22 = b2[2] | 0;
        var bl2 = b22 & 8191;
        var bh2 = b22 >>> 13;
        var b3 = b2[3] | 0;
        var bl3 = b3 & 8191;
        var bh3 = b3 >>> 13;
        var b4 = b2[4] | 0;
        var bl4 = b4 & 8191;
        var bh4 = b4 >>> 13;
        var b5 = b2[5] | 0;
        var bl5 = b5 & 8191;
        var bh5 = b5 >>> 13;
        var b6 = b2[6] | 0;
        var bl6 = b6 & 8191;
        var bh6 = b6 >>> 13;
        var b7 = b2[7] | 0;
        var bl7 = b7 & 8191;
        var bh7 = b7 >>> 13;
        var b8 = b2[8] | 0;
        var bl8 = b8 & 8191;
        var bh8 = b8 >>> 13;
        var b9 = b2[9] | 0;
        var bl9 = b9 & 8191;
        var bh9 = b9 >>> 13;
        out.negative = self2.negative ^ num.negative;
        out.length = 19;
        lo = Math.imul(al0, bl0);
        mid = Math.imul(al0, bh0);
        mid = mid + Math.imul(ah0, bl0) | 0;
        hi = Math.imul(ah0, bh0);
        var w0 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w0 >>> 26) | 0;
        w0 &= 67108863;
        lo = Math.imul(al1, bl0);
        mid = Math.imul(al1, bh0);
        mid = mid + Math.imul(ah1, bl0) | 0;
        hi = Math.imul(ah1, bh0);
        lo = lo + Math.imul(al0, bl1) | 0;
        mid = mid + Math.imul(al0, bh1) | 0;
        mid = mid + Math.imul(ah0, bl1) | 0;
        hi = hi + Math.imul(ah0, bh1) | 0;
        var w1 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w1 >>> 26) | 0;
        w1 &= 67108863;
        lo = Math.imul(al2, bl0);
        mid = Math.imul(al2, bh0);
        mid = mid + Math.imul(ah2, bl0) | 0;
        hi = Math.imul(ah2, bh0);
        lo = lo + Math.imul(al1, bl1) | 0;
        mid = mid + Math.imul(al1, bh1) | 0;
        mid = mid + Math.imul(ah1, bl1) | 0;
        hi = hi + Math.imul(ah1, bh1) | 0;
        lo = lo + Math.imul(al0, bl2) | 0;
        mid = mid + Math.imul(al0, bh2) | 0;
        mid = mid + Math.imul(ah0, bl2) | 0;
        hi = hi + Math.imul(ah0, bh2) | 0;
        var w2 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w2 >>> 26) | 0;
        w2 &= 67108863;
        lo = Math.imul(al3, bl0);
        mid = Math.imul(al3, bh0);
        mid = mid + Math.imul(ah3, bl0) | 0;
        hi = Math.imul(ah3, bh0);
        lo = lo + Math.imul(al2, bl1) | 0;
        mid = mid + Math.imul(al2, bh1) | 0;
        mid = mid + Math.imul(ah2, bl1) | 0;
        hi = hi + Math.imul(ah2, bh1) | 0;
        lo = lo + Math.imul(al1, bl2) | 0;
        mid = mid + Math.imul(al1, bh2) | 0;
        mid = mid + Math.imul(ah1, bl2) | 0;
        hi = hi + Math.imul(ah1, bh2) | 0;
        lo = lo + Math.imul(al0, bl3) | 0;
        mid = mid + Math.imul(al0, bh3) | 0;
        mid = mid + Math.imul(ah0, bl3) | 0;
        hi = hi + Math.imul(ah0, bh3) | 0;
        var w3 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w3 >>> 26) | 0;
        w3 &= 67108863;
        lo = Math.imul(al4, bl0);
        mid = Math.imul(al4, bh0);
        mid = mid + Math.imul(ah4, bl0) | 0;
        hi = Math.imul(ah4, bh0);
        lo = lo + Math.imul(al3, bl1) | 0;
        mid = mid + Math.imul(al3, bh1) | 0;
        mid = mid + Math.imul(ah3, bl1) | 0;
        hi = hi + Math.imul(ah3, bh1) | 0;
        lo = lo + Math.imul(al2, bl2) | 0;
        mid = mid + Math.imul(al2, bh2) | 0;
        mid = mid + Math.imul(ah2, bl2) | 0;
        hi = hi + Math.imul(ah2, bh2) | 0;
        lo = lo + Math.imul(al1, bl3) | 0;
        mid = mid + Math.imul(al1, bh3) | 0;
        mid = mid + Math.imul(ah1, bl3) | 0;
        hi = hi + Math.imul(ah1, bh3) | 0;
        lo = lo + Math.imul(al0, bl4) | 0;
        mid = mid + Math.imul(al0, bh4) | 0;
        mid = mid + Math.imul(ah0, bl4) | 0;
        hi = hi + Math.imul(ah0, bh4) | 0;
        var w4 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w4 >>> 26) | 0;
        w4 &= 67108863;
        lo = Math.imul(al5, bl0);
        mid = Math.imul(al5, bh0);
        mid = mid + Math.imul(ah5, bl0) | 0;
        hi = Math.imul(ah5, bh0);
        lo = lo + Math.imul(al4, bl1) | 0;
        mid = mid + Math.imul(al4, bh1) | 0;
        mid = mid + Math.imul(ah4, bl1) | 0;
        hi = hi + Math.imul(ah4, bh1) | 0;
        lo = lo + Math.imul(al3, bl2) | 0;
        mid = mid + Math.imul(al3, bh2) | 0;
        mid = mid + Math.imul(ah3, bl2) | 0;
        hi = hi + Math.imul(ah3, bh2) | 0;
        lo = lo + Math.imul(al2, bl3) | 0;
        mid = mid + Math.imul(al2, bh3) | 0;
        mid = mid + Math.imul(ah2, bl3) | 0;
        hi = hi + Math.imul(ah2, bh3) | 0;
        lo = lo + Math.imul(al1, bl4) | 0;
        mid = mid + Math.imul(al1, bh4) | 0;
        mid = mid + Math.imul(ah1, bl4) | 0;
        hi = hi + Math.imul(ah1, bh4) | 0;
        lo = lo + Math.imul(al0, bl5) | 0;
        mid = mid + Math.imul(al0, bh5) | 0;
        mid = mid + Math.imul(ah0, bl5) | 0;
        hi = hi + Math.imul(ah0, bh5) | 0;
        var w5 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w5 >>> 26) | 0;
        w5 &= 67108863;
        lo = Math.imul(al6, bl0);
        mid = Math.imul(al6, bh0);
        mid = mid + Math.imul(ah6, bl0) | 0;
        hi = Math.imul(ah6, bh0);
        lo = lo + Math.imul(al5, bl1) | 0;
        mid = mid + Math.imul(al5, bh1) | 0;
        mid = mid + Math.imul(ah5, bl1) | 0;
        hi = hi + Math.imul(ah5, bh1) | 0;
        lo = lo + Math.imul(al4, bl2) | 0;
        mid = mid + Math.imul(al4, bh2) | 0;
        mid = mid + Math.imul(ah4, bl2) | 0;
        hi = hi + Math.imul(ah4, bh2) | 0;
        lo = lo + Math.imul(al3, bl3) | 0;
        mid = mid + Math.imul(al3, bh3) | 0;
        mid = mid + Math.imul(ah3, bl3) | 0;
        hi = hi + Math.imul(ah3, bh3) | 0;
        lo = lo + Math.imul(al2, bl4) | 0;
        mid = mid + Math.imul(al2, bh4) | 0;
        mid = mid + Math.imul(ah2, bl4) | 0;
        hi = hi + Math.imul(ah2, bh4) | 0;
        lo = lo + Math.imul(al1, bl5) | 0;
        mid = mid + Math.imul(al1, bh5) | 0;
        mid = mid + Math.imul(ah1, bl5) | 0;
        hi = hi + Math.imul(ah1, bh5) | 0;
        lo = lo + Math.imul(al0, bl6) | 0;
        mid = mid + Math.imul(al0, bh6) | 0;
        mid = mid + Math.imul(ah0, bl6) | 0;
        hi = hi + Math.imul(ah0, bh6) | 0;
        var w6 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w6 >>> 26) | 0;
        w6 &= 67108863;
        lo = Math.imul(al7, bl0);
        mid = Math.imul(al7, bh0);
        mid = mid + Math.imul(ah7, bl0) | 0;
        hi = Math.imul(ah7, bh0);
        lo = lo + Math.imul(al6, bl1) | 0;
        mid = mid + Math.imul(al6, bh1) | 0;
        mid = mid + Math.imul(ah6, bl1) | 0;
        hi = hi + Math.imul(ah6, bh1) | 0;
        lo = lo + Math.imul(al5, bl2) | 0;
        mid = mid + Math.imul(al5, bh2) | 0;
        mid = mid + Math.imul(ah5, bl2) | 0;
        hi = hi + Math.imul(ah5, bh2) | 0;
        lo = lo + Math.imul(al4, bl3) | 0;
        mid = mid + Math.imul(al4, bh3) | 0;
        mid = mid + Math.imul(ah4, bl3) | 0;
        hi = hi + Math.imul(ah4, bh3) | 0;
        lo = lo + Math.imul(al3, bl4) | 0;
        mid = mid + Math.imul(al3, bh4) | 0;
        mid = mid + Math.imul(ah3, bl4) | 0;
        hi = hi + Math.imul(ah3, bh4) | 0;
        lo = lo + Math.imul(al2, bl5) | 0;
        mid = mid + Math.imul(al2, bh5) | 0;
        mid = mid + Math.imul(ah2, bl5) | 0;
        hi = hi + Math.imul(ah2, bh5) | 0;
        lo = lo + Math.imul(al1, bl6) | 0;
        mid = mid + Math.imul(al1, bh6) | 0;
        mid = mid + Math.imul(ah1, bl6) | 0;
        hi = hi + Math.imul(ah1, bh6) | 0;
        lo = lo + Math.imul(al0, bl7) | 0;
        mid = mid + Math.imul(al0, bh7) | 0;
        mid = mid + Math.imul(ah0, bl7) | 0;
        hi = hi + Math.imul(ah0, bh7) | 0;
        var w7 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w7 >>> 26) | 0;
        w7 &= 67108863;
        lo = Math.imul(al8, bl0);
        mid = Math.imul(al8, bh0);
        mid = mid + Math.imul(ah8, bl0) | 0;
        hi = Math.imul(ah8, bh0);
        lo = lo + Math.imul(al7, bl1) | 0;
        mid = mid + Math.imul(al7, bh1) | 0;
        mid = mid + Math.imul(ah7, bl1) | 0;
        hi = hi + Math.imul(ah7, bh1) | 0;
        lo = lo + Math.imul(al6, bl2) | 0;
        mid = mid + Math.imul(al6, bh2) | 0;
        mid = mid + Math.imul(ah6, bl2) | 0;
        hi = hi + Math.imul(ah6, bh2) | 0;
        lo = lo + Math.imul(al5, bl3) | 0;
        mid = mid + Math.imul(al5, bh3) | 0;
        mid = mid + Math.imul(ah5, bl3) | 0;
        hi = hi + Math.imul(ah5, bh3) | 0;
        lo = lo + Math.imul(al4, bl4) | 0;
        mid = mid + Math.imul(al4, bh4) | 0;
        mid = mid + Math.imul(ah4, bl4) | 0;
        hi = hi + Math.imul(ah4, bh4) | 0;
        lo = lo + Math.imul(al3, bl5) | 0;
        mid = mid + Math.imul(al3, bh5) | 0;
        mid = mid + Math.imul(ah3, bl5) | 0;
        hi = hi + Math.imul(ah3, bh5) | 0;
        lo = lo + Math.imul(al2, bl6) | 0;
        mid = mid + Math.imul(al2, bh6) | 0;
        mid = mid + Math.imul(ah2, bl6) | 0;
        hi = hi + Math.imul(ah2, bh6) | 0;
        lo = lo + Math.imul(al1, bl7) | 0;
        mid = mid + Math.imul(al1, bh7) | 0;
        mid = mid + Math.imul(ah1, bl7) | 0;
        hi = hi + Math.imul(ah1, bh7) | 0;
        lo = lo + Math.imul(al0, bl8) | 0;
        mid = mid + Math.imul(al0, bh8) | 0;
        mid = mid + Math.imul(ah0, bl8) | 0;
        hi = hi + Math.imul(ah0, bh8) | 0;
        var w8 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w8 >>> 26) | 0;
        w8 &= 67108863;
        lo = Math.imul(al9, bl0);
        mid = Math.imul(al9, bh0);
        mid = mid + Math.imul(ah9, bl0) | 0;
        hi = Math.imul(ah9, bh0);
        lo = lo + Math.imul(al8, bl1) | 0;
        mid = mid + Math.imul(al8, bh1) | 0;
        mid = mid + Math.imul(ah8, bl1) | 0;
        hi = hi + Math.imul(ah8, bh1) | 0;
        lo = lo + Math.imul(al7, bl2) | 0;
        mid = mid + Math.imul(al7, bh2) | 0;
        mid = mid + Math.imul(ah7, bl2) | 0;
        hi = hi + Math.imul(ah7, bh2) | 0;
        lo = lo + Math.imul(al6, bl3) | 0;
        mid = mid + Math.imul(al6, bh3) | 0;
        mid = mid + Math.imul(ah6, bl3) | 0;
        hi = hi + Math.imul(ah6, bh3) | 0;
        lo = lo + Math.imul(al5, bl4) | 0;
        mid = mid + Math.imul(al5, bh4) | 0;
        mid = mid + Math.imul(ah5, bl4) | 0;
        hi = hi + Math.imul(ah5, bh4) | 0;
        lo = lo + Math.imul(al4, bl5) | 0;
        mid = mid + Math.imul(al4, bh5) | 0;
        mid = mid + Math.imul(ah4, bl5) | 0;
        hi = hi + Math.imul(ah4, bh5) | 0;
        lo = lo + Math.imul(al3, bl6) | 0;
        mid = mid + Math.imul(al3, bh6) | 0;
        mid = mid + Math.imul(ah3, bl6) | 0;
        hi = hi + Math.imul(ah3, bh6) | 0;
        lo = lo + Math.imul(al2, bl7) | 0;
        mid = mid + Math.imul(al2, bh7) | 0;
        mid = mid + Math.imul(ah2, bl7) | 0;
        hi = hi + Math.imul(ah2, bh7) | 0;
        lo = lo + Math.imul(al1, bl8) | 0;
        mid = mid + Math.imul(al1, bh8) | 0;
        mid = mid + Math.imul(ah1, bl8) | 0;
        hi = hi + Math.imul(ah1, bh8) | 0;
        lo = lo + Math.imul(al0, bl9) | 0;
        mid = mid + Math.imul(al0, bh9) | 0;
        mid = mid + Math.imul(ah0, bl9) | 0;
        hi = hi + Math.imul(ah0, bh9) | 0;
        var w9 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w9 >>> 26) | 0;
        w9 &= 67108863;
        lo = Math.imul(al9, bl1);
        mid = Math.imul(al9, bh1);
        mid = mid + Math.imul(ah9, bl1) | 0;
        hi = Math.imul(ah9, bh1);
        lo = lo + Math.imul(al8, bl2) | 0;
        mid = mid + Math.imul(al8, bh2) | 0;
        mid = mid + Math.imul(ah8, bl2) | 0;
        hi = hi + Math.imul(ah8, bh2) | 0;
        lo = lo + Math.imul(al7, bl3) | 0;
        mid = mid + Math.imul(al7, bh3) | 0;
        mid = mid + Math.imul(ah7, bl3) | 0;
        hi = hi + Math.imul(ah7, bh3) | 0;
        lo = lo + Math.imul(al6, bl4) | 0;
        mid = mid + Math.imul(al6, bh4) | 0;
        mid = mid + Math.imul(ah6, bl4) | 0;
        hi = hi + Math.imul(ah6, bh4) | 0;
        lo = lo + Math.imul(al5, bl5) | 0;
        mid = mid + Math.imul(al5, bh5) | 0;
        mid = mid + Math.imul(ah5, bl5) | 0;
        hi = hi + Math.imul(ah5, bh5) | 0;
        lo = lo + Math.imul(al4, bl6) | 0;
        mid = mid + Math.imul(al4, bh6) | 0;
        mid = mid + Math.imul(ah4, bl6) | 0;
        hi = hi + Math.imul(ah4, bh6) | 0;
        lo = lo + Math.imul(al3, bl7) | 0;
        mid = mid + Math.imul(al3, bh7) | 0;
        mid = mid + Math.imul(ah3, bl7) | 0;
        hi = hi + Math.imul(ah3, bh7) | 0;
        lo = lo + Math.imul(al2, bl8) | 0;
        mid = mid + Math.imul(al2, bh8) | 0;
        mid = mid + Math.imul(ah2, bl8) | 0;
        hi = hi + Math.imul(ah2, bh8) | 0;
        lo = lo + Math.imul(al1, bl9) | 0;
        mid = mid + Math.imul(al1, bh9) | 0;
        mid = mid + Math.imul(ah1, bl9) | 0;
        hi = hi + Math.imul(ah1, bh9) | 0;
        var w10 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w10 >>> 26) | 0;
        w10 &= 67108863;
        lo = Math.imul(al9, bl2);
        mid = Math.imul(al9, bh2);
        mid = mid + Math.imul(ah9, bl2) | 0;
        hi = Math.imul(ah9, bh2);
        lo = lo + Math.imul(al8, bl3) | 0;
        mid = mid + Math.imul(al8, bh3) | 0;
        mid = mid + Math.imul(ah8, bl3) | 0;
        hi = hi + Math.imul(ah8, bh3) | 0;
        lo = lo + Math.imul(al7, bl4) | 0;
        mid = mid + Math.imul(al7, bh4) | 0;
        mid = mid + Math.imul(ah7, bl4) | 0;
        hi = hi + Math.imul(ah7, bh4) | 0;
        lo = lo + Math.imul(al6, bl5) | 0;
        mid = mid + Math.imul(al6, bh5) | 0;
        mid = mid + Math.imul(ah6, bl5) | 0;
        hi = hi + Math.imul(ah6, bh5) | 0;
        lo = lo + Math.imul(al5, bl6) | 0;
        mid = mid + Math.imul(al5, bh6) | 0;
        mid = mid + Math.imul(ah5, bl6) | 0;
        hi = hi + Math.imul(ah5, bh6) | 0;
        lo = lo + Math.imul(al4, bl7) | 0;
        mid = mid + Math.imul(al4, bh7) | 0;
        mid = mid + Math.imul(ah4, bl7) | 0;
        hi = hi + Math.imul(ah4, bh7) | 0;
        lo = lo + Math.imul(al3, bl8) | 0;
        mid = mid + Math.imul(al3, bh8) | 0;
        mid = mid + Math.imul(ah3, bl8) | 0;
        hi = hi + Math.imul(ah3, bh8) | 0;
        lo = lo + Math.imul(al2, bl9) | 0;
        mid = mid + Math.imul(al2, bh9) | 0;
        mid = mid + Math.imul(ah2, bl9) | 0;
        hi = hi + Math.imul(ah2, bh9) | 0;
        var w11 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w11 >>> 26) | 0;
        w11 &= 67108863;
        lo = Math.imul(al9, bl3);
        mid = Math.imul(al9, bh3);
        mid = mid + Math.imul(ah9, bl3) | 0;
        hi = Math.imul(ah9, bh3);
        lo = lo + Math.imul(al8, bl4) | 0;
        mid = mid + Math.imul(al8, bh4) | 0;
        mid = mid + Math.imul(ah8, bl4) | 0;
        hi = hi + Math.imul(ah8, bh4) | 0;
        lo = lo + Math.imul(al7, bl5) | 0;
        mid = mid + Math.imul(al7, bh5) | 0;
        mid = mid + Math.imul(ah7, bl5) | 0;
        hi = hi + Math.imul(ah7, bh5) | 0;
        lo = lo + Math.imul(al6, bl6) | 0;
        mid = mid + Math.imul(al6, bh6) | 0;
        mid = mid + Math.imul(ah6, bl6) | 0;
        hi = hi + Math.imul(ah6, bh6) | 0;
        lo = lo + Math.imul(al5, bl7) | 0;
        mid = mid + Math.imul(al5, bh7) | 0;
        mid = mid + Math.imul(ah5, bl7) | 0;
        hi = hi + Math.imul(ah5, bh7) | 0;
        lo = lo + Math.imul(al4, bl8) | 0;
        mid = mid + Math.imul(al4, bh8) | 0;
        mid = mid + Math.imul(ah4, bl8) | 0;
        hi = hi + Math.imul(ah4, bh8) | 0;
        lo = lo + Math.imul(al3, bl9) | 0;
        mid = mid + Math.imul(al3, bh9) | 0;
        mid = mid + Math.imul(ah3, bl9) | 0;
        hi = hi + Math.imul(ah3, bh9) | 0;
        var w12 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w12 >>> 26) | 0;
        w12 &= 67108863;
        lo = Math.imul(al9, bl4);
        mid = Math.imul(al9, bh4);
        mid = mid + Math.imul(ah9, bl4) | 0;
        hi = Math.imul(ah9, bh4);
        lo = lo + Math.imul(al8, bl5) | 0;
        mid = mid + Math.imul(al8, bh5) | 0;
        mid = mid + Math.imul(ah8, bl5) | 0;
        hi = hi + Math.imul(ah8, bh5) | 0;
        lo = lo + Math.imul(al7, bl6) | 0;
        mid = mid + Math.imul(al7, bh6) | 0;
        mid = mid + Math.imul(ah7, bl6) | 0;
        hi = hi + Math.imul(ah7, bh6) | 0;
        lo = lo + Math.imul(al6, bl7) | 0;
        mid = mid + Math.imul(al6, bh7) | 0;
        mid = mid + Math.imul(ah6, bl7) | 0;
        hi = hi + Math.imul(ah6, bh7) | 0;
        lo = lo + Math.imul(al5, bl8) | 0;
        mid = mid + Math.imul(al5, bh8) | 0;
        mid = mid + Math.imul(ah5, bl8) | 0;
        hi = hi + Math.imul(ah5, bh8) | 0;
        lo = lo + Math.imul(al4, bl9) | 0;
        mid = mid + Math.imul(al4, bh9) | 0;
        mid = mid + Math.imul(ah4, bl9) | 0;
        hi = hi + Math.imul(ah4, bh9) | 0;
        var w13 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w13 >>> 26) | 0;
        w13 &= 67108863;
        lo = Math.imul(al9, bl5);
        mid = Math.imul(al9, bh5);
        mid = mid + Math.imul(ah9, bl5) | 0;
        hi = Math.imul(ah9, bh5);
        lo = lo + Math.imul(al8, bl6) | 0;
        mid = mid + Math.imul(al8, bh6) | 0;
        mid = mid + Math.imul(ah8, bl6) | 0;
        hi = hi + Math.imul(ah8, bh6) | 0;
        lo = lo + Math.imul(al7, bl7) | 0;
        mid = mid + Math.imul(al7, bh7) | 0;
        mid = mid + Math.imul(ah7, bl7) | 0;
        hi = hi + Math.imul(ah7, bh7) | 0;
        lo = lo + Math.imul(al6, bl8) | 0;
        mid = mid + Math.imul(al6, bh8) | 0;
        mid = mid + Math.imul(ah6, bl8) | 0;
        hi = hi + Math.imul(ah6, bh8) | 0;
        lo = lo + Math.imul(al5, bl9) | 0;
        mid = mid + Math.imul(al5, bh9) | 0;
        mid = mid + Math.imul(ah5, bl9) | 0;
        hi = hi + Math.imul(ah5, bh9) | 0;
        var w14 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w14 >>> 26) | 0;
        w14 &= 67108863;
        lo = Math.imul(al9, bl6);
        mid = Math.imul(al9, bh6);
        mid = mid + Math.imul(ah9, bl6) | 0;
        hi = Math.imul(ah9, bh6);
        lo = lo + Math.imul(al8, bl7) | 0;
        mid = mid + Math.imul(al8, bh7) | 0;
        mid = mid + Math.imul(ah8, bl7) | 0;
        hi = hi + Math.imul(ah8, bh7) | 0;
        lo = lo + Math.imul(al7, bl8) | 0;
        mid = mid + Math.imul(al7, bh8) | 0;
        mid = mid + Math.imul(ah7, bl8) | 0;
        hi = hi + Math.imul(ah7, bh8) | 0;
        lo = lo + Math.imul(al6, bl9) | 0;
        mid = mid + Math.imul(al6, bh9) | 0;
        mid = mid + Math.imul(ah6, bl9) | 0;
        hi = hi + Math.imul(ah6, bh9) | 0;
        var w15 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w15 >>> 26) | 0;
        w15 &= 67108863;
        lo = Math.imul(al9, bl7);
        mid = Math.imul(al9, bh7);
        mid = mid + Math.imul(ah9, bl7) | 0;
        hi = Math.imul(ah9, bh7);
        lo = lo + Math.imul(al8, bl8) | 0;
        mid = mid + Math.imul(al8, bh8) | 0;
        mid = mid + Math.imul(ah8, bl8) | 0;
        hi = hi + Math.imul(ah8, bh8) | 0;
        lo = lo + Math.imul(al7, bl9) | 0;
        mid = mid + Math.imul(al7, bh9) | 0;
        mid = mid + Math.imul(ah7, bl9) | 0;
        hi = hi + Math.imul(ah7, bh9) | 0;
        var w16 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w16 >>> 26) | 0;
        w16 &= 67108863;
        lo = Math.imul(al9, bl8);
        mid = Math.imul(al9, bh8);
        mid = mid + Math.imul(ah9, bl8) | 0;
        hi = Math.imul(ah9, bh8);
        lo = lo + Math.imul(al8, bl9) | 0;
        mid = mid + Math.imul(al8, bh9) | 0;
        mid = mid + Math.imul(ah8, bl9) | 0;
        hi = hi + Math.imul(ah8, bh9) | 0;
        var w17 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w17 >>> 26) | 0;
        w17 &= 67108863;
        lo = Math.imul(al9, bl9);
        mid = Math.imul(al9, bh9);
        mid = mid + Math.imul(ah9, bl9) | 0;
        hi = Math.imul(ah9, bh9);
        var w18 = (c2 + lo | 0) + ((mid & 8191) << 13) | 0;
        c2 = (hi + (mid >>> 13) | 0) + (w18 >>> 26) | 0;
        w18 &= 67108863;
        o2[0] = w0;
        o2[1] = w1;
        o2[2] = w2;
        o2[3] = w3;
        o2[4] = w4;
        o2[5] = w5;
        o2[6] = w6;
        o2[7] = w7;
        o2[8] = w8;
        o2[9] = w9;
        o2[10] = w10;
        o2[11] = w11;
        o2[12] = w12;
        o2[13] = w13;
        o2[14] = w14;
        o2[15] = w15;
        o2[16] = w16;
        o2[17] = w17;
        o2[18] = w18;
        if (c2 !== 0) {
          o2[19] = c2;
          out.length++;
        }
        return out;
      };
      if (!Math.imul) {
        comb10MulTo = smallMulTo;
      }
      function bigMulTo(self2, num, out) {
        out.negative = num.negative ^ self2.negative;
        out.length = self2.length + num.length;
        var carry = 0;
        var hncarry = 0;
        for (var k2 = 0; k2 < out.length - 1; k2++) {
          var ncarry = hncarry;
          hncarry = 0;
          var rword = carry & 67108863;
          var maxJ = Math.min(k2, num.length - 1);
          for (var j = Math.max(0, k2 - self2.length + 1); j <= maxJ; j++) {
            var i2 = k2 - j;
            var a2 = self2.words[i2] | 0;
            var b2 = num.words[j] | 0;
            var r2 = a2 * b2;
            var lo = r2 & 67108863;
            ncarry = ncarry + (r2 / 67108864 | 0) | 0;
            lo = lo + rword | 0;
            rword = lo & 67108863;
            ncarry = ncarry + (lo >>> 26) | 0;
            hncarry += ncarry >>> 26;
            ncarry &= 67108863;
          }
          out.words[k2] = rword;
          carry = ncarry;
          ncarry = hncarry;
        }
        if (carry !== 0) {
          out.words[k2] = carry;
        } else {
          out.length--;
        }
        return out._strip();
      }
      function jumboMulTo(self2, num, out) {
        return bigMulTo(self2, num, out);
      }
      BN.prototype.mulTo = function mulTo(num, out) {
        var res;
        var len = this.length + num.length;
        if (this.length === 10 && num.length === 10) {
          res = comb10MulTo(this, num, out);
        } else if (len < 63) {
          res = smallMulTo(this, num, out);
        } else if (len < 1024) {
          res = bigMulTo(this, num, out);
        } else {
          res = jumboMulTo(this, num, out);
        }
        return res;
      };
      BN.prototype.mul = function mul(num) {
        var out = new BN(null);
        out.words = new Array(this.length + num.length);
        return this.mulTo(num, out);
      };
      BN.prototype.mulf = function mulf(num) {
        var out = new BN(null);
        out.words = new Array(this.length + num.length);
        return jumboMulTo(this, num, out);
      };
      BN.prototype.imul = function imul(num) {
        return this.clone().mulTo(num, this);
      };
      BN.prototype.imuln = function imuln(num) {
        var isNegNum = num < 0;
        if (isNegNum) num = -num;
        assert(typeof num === "number");
        assert(num < 67108864);
        var carry = 0;
        for (var i2 = 0; i2 < this.length; i2++) {
          var w = (this.words[i2] | 0) * num;
          var lo = (w & 67108863) + (carry & 67108863);
          carry >>= 26;
          carry += w / 67108864 | 0;
          carry += lo >>> 26;
          this.words[i2] = lo & 67108863;
        }
        if (carry !== 0) {
          this.words[i2] = carry;
          this.length++;
        }
        this.length = num === 0 ? 1 : this.length;
        return isNegNum ? this.ineg() : this;
      };
      BN.prototype.muln = function muln(num) {
        return this.clone().imuln(num);
      };
      BN.prototype.sqr = function sqr() {
        return this.mul(this);
      };
      BN.prototype.isqr = function isqr() {
        return this.imul(this.clone());
      };
      BN.prototype.pow = function pow2(num) {
        var w = toBitArray(num);
        if (w.length === 0) return new BN(1);
        var res = this;
        for (var i2 = 0; i2 < w.length; i2++, res = res.sqr()) {
          if (w[i2] !== 0) break;
        }
        if (++i2 < w.length) {
          for (var q = res.sqr(); i2 < w.length; i2++, q = q.sqr()) {
            if (w[i2] === 0) continue;
            res = res.mul(q);
          }
        }
        return res;
      };
      BN.prototype.iushln = function iushln(bits) {
        assert(typeof bits === "number" && bits >= 0);
        var r2 = bits % 26;
        var s2 = (bits - r2) / 26;
        var carryMask = 67108863 >>> 26 - r2 << 26 - r2;
        var i2;
        if (r2 !== 0) {
          var carry = 0;
          for (i2 = 0; i2 < this.length; i2++) {
            var newCarry = this.words[i2] & carryMask;
            var c2 = (this.words[i2] | 0) - newCarry << r2;
            this.words[i2] = c2 | carry;
            carry = newCarry >>> 26 - r2;
          }
          if (carry) {
            this.words[i2] = carry;
            this.length++;
          }
        }
        if (s2 !== 0) {
          for (i2 = this.length - 1; i2 >= 0; i2--) {
            this.words[i2 + s2] = this.words[i2];
          }
          for (i2 = 0; i2 < s2; i2++) {
            this.words[i2] = 0;
          }
          this.length += s2;
        }
        return this._strip();
      };
      BN.prototype.ishln = function ishln(bits) {
        assert(this.negative === 0);
        return this.iushln(bits);
      };
      BN.prototype.iushrn = function iushrn(bits, hint, extended) {
        assert(typeof bits === "number" && bits >= 0);
        var h2;
        if (hint) {
          h2 = (hint - hint % 26) / 26;
        } else {
          h2 = 0;
        }
        var r2 = bits % 26;
        var s2 = Math.min((bits - r2) / 26, this.length);
        var mask = 67108863 ^ 67108863 >>> r2 << r2;
        var maskedWords = extended;
        h2 -= s2;
        h2 = Math.max(0, h2);
        if (maskedWords) {
          for (var i2 = 0; i2 < s2; i2++) {
            maskedWords.words[i2] = this.words[i2];
          }
          maskedWords.length = s2;
        }
        if (s2 === 0) ;
        else if (this.length > s2) {
          this.length -= s2;
          for (i2 = 0; i2 < this.length; i2++) {
            this.words[i2] = this.words[i2 + s2];
          }
        } else {
          this.words[0] = 0;
          this.length = 1;
        }
        var carry = 0;
        for (i2 = this.length - 1; i2 >= 0 && (carry !== 0 || i2 >= h2); i2--) {
          var word = this.words[i2] | 0;
          this.words[i2] = carry << 26 - r2 | word >>> r2;
          carry = word & mask;
        }
        if (maskedWords && carry !== 0) {
          maskedWords.words[maskedWords.length++] = carry;
        }
        if (this.length === 0) {
          this.words[0] = 0;
          this.length = 1;
        }
        return this._strip();
      };
      BN.prototype.ishrn = function ishrn(bits, hint, extended) {
        assert(this.negative === 0);
        return this.iushrn(bits, hint, extended);
      };
      BN.prototype.shln = function shln(bits) {
        return this.clone().ishln(bits);
      };
      BN.prototype.ushln = function ushln(bits) {
        return this.clone().iushln(bits);
      };
      BN.prototype.shrn = function shrn(bits) {
        return this.clone().ishrn(bits);
      };
      BN.prototype.ushrn = function ushrn(bits) {
        return this.clone().iushrn(bits);
      };
      BN.prototype.testn = function testn(bit) {
        assert(typeof bit === "number" && bit >= 0);
        var r2 = bit % 26;
        var s2 = (bit - r2) / 26;
        var q = 1 << r2;
        if (this.length <= s2) return false;
        var w = this.words[s2];
        return !!(w & q);
      };
      BN.prototype.imaskn = function imaskn(bits) {
        assert(typeof bits === "number" && bits >= 0);
        var r2 = bits % 26;
        var s2 = (bits - r2) / 26;
        assert(this.negative === 0, "imaskn works only with positive numbers");
        if (this.length <= s2) {
          return this;
        }
        if (r2 !== 0) {
          s2++;
        }
        this.length = Math.min(s2, this.length);
        if (r2 !== 0) {
          var mask = 67108863 ^ 67108863 >>> r2 << r2;
          this.words[this.length - 1] &= mask;
        }
        return this._strip();
      };
      BN.prototype.maskn = function maskn(bits) {
        return this.clone().imaskn(bits);
      };
      BN.prototype.iaddn = function iaddn(num) {
        assert(typeof num === "number");
        assert(num < 67108864);
        if (num < 0) return this.isubn(-num);
        if (this.negative !== 0) {
          if (this.length === 1 && (this.words[0] | 0) <= num) {
            this.words[0] = num - (this.words[0] | 0);
            this.negative = 0;
            return this;
          }
          this.negative = 0;
          this.isubn(num);
          this.negative = 1;
          return this;
        }
        return this._iaddn(num);
      };
      BN.prototype._iaddn = function _iaddn(num) {
        this.words[0] += num;
        for (var i2 = 0; i2 < this.length && this.words[i2] >= 67108864; i2++) {
          this.words[i2] -= 67108864;
          if (i2 === this.length - 1) {
            this.words[i2 + 1] = 1;
          } else {
            this.words[i2 + 1]++;
          }
        }
        this.length = Math.max(this.length, i2 + 1);
        return this;
      };
      BN.prototype.isubn = function isubn(num) {
        assert(typeof num === "number");
        assert(num < 67108864);
        if (num < 0) return this.iaddn(-num);
        if (this.negative !== 0) {
          this.negative = 0;
          this.iaddn(num);
          this.negative = 1;
          return this;
        }
        this.words[0] -= num;
        if (this.length === 1 && this.words[0] < 0) {
          this.words[0] = -this.words[0];
          this.negative = 1;
        } else {
          for (var i2 = 0; i2 < this.length && this.words[i2] < 0; i2++) {
            this.words[i2] += 67108864;
            this.words[i2 + 1] -= 1;
          }
        }
        return this._strip();
      };
      BN.prototype.addn = function addn(num) {
        return this.clone().iaddn(num);
      };
      BN.prototype.subn = function subn(num) {
        return this.clone().isubn(num);
      };
      BN.prototype.iabs = function iabs() {
        this.negative = 0;
        return this;
      };
      BN.prototype.abs = function abs2() {
        return this.clone().iabs();
      };
      BN.prototype._ishlnsubmul = function _ishlnsubmul(num, mul, shift) {
        var len = num.length + shift;
        var i2;
        this._expand(len);
        var w;
        var carry = 0;
        for (i2 = 0; i2 < num.length; i2++) {
          w = (this.words[i2 + shift] | 0) + carry;
          var right = (num.words[i2] | 0) * mul;
          w -= right & 67108863;
          carry = (w >> 26) - (right / 67108864 | 0);
          this.words[i2 + shift] = w & 67108863;
        }
        for (; i2 < this.length - shift; i2++) {
          w = (this.words[i2 + shift] | 0) + carry;
          carry = w >> 26;
          this.words[i2 + shift] = w & 67108863;
        }
        if (carry === 0) return this._strip();
        assert(carry === -1);
        carry = 0;
        for (i2 = 0; i2 < this.length; i2++) {
          w = -(this.words[i2] | 0) + carry;
          carry = w >> 26;
          this.words[i2] = w & 67108863;
        }
        this.negative = 1;
        return this._strip();
      };
      BN.prototype._wordDiv = function _wordDiv(num, mode) {
        var shift = this.length - num.length;
        var a2 = this.clone();
        var b2 = num;
        var bhi = b2.words[b2.length - 1] | 0;
        var bhiBits = this._countBits(bhi);
        shift = 26 - bhiBits;
        if (shift !== 0) {
          b2 = b2.ushln(shift);
          a2.iushln(shift);
          bhi = b2.words[b2.length - 1] | 0;
        }
        var m = a2.length - b2.length;
        var q;
        if (mode !== "mod") {
          q = new BN(null);
          q.length = m + 1;
          q.words = new Array(q.length);
          for (var i2 = 0; i2 < q.length; i2++) {
            q.words[i2] = 0;
          }
        }
        var diff = a2.clone()._ishlnsubmul(b2, 1, m);
        if (diff.negative === 0) {
          a2 = diff;
          if (q) {
            q.words[m] = 1;
          }
        }
        for (var j = m - 1; j >= 0; j--) {
          var qj = (a2.words[b2.length + j] | 0) * 67108864 + (a2.words[b2.length + j - 1] | 0);
          qj = Math.min(qj / bhi | 0, 67108863);
          a2._ishlnsubmul(b2, qj, j);
          while (a2.negative !== 0) {
            qj--;
            a2.negative = 0;
            a2._ishlnsubmul(b2, 1, j);
            if (!a2.isZero()) {
              a2.negative ^= 1;
            }
          }
          if (q) {
            q.words[j] = qj;
          }
        }
        if (q) {
          q._strip();
        }
        a2._strip();
        if (mode !== "div" && shift !== 0) {
          a2.iushrn(shift);
        }
        return {
          div: q || null,
          mod: a2
        };
      };
      BN.prototype.divmod = function divmod(num, mode, positive) {
        assert(!num.isZero());
        if (this.isZero()) {
          return {
            div: new BN(0),
            mod: new BN(0)
          };
        }
        var div, mod, res;
        if (this.negative !== 0 && num.negative === 0) {
          res = this.neg().divmod(num, mode);
          if (mode !== "mod") {
            div = res.div.neg();
          }
          if (mode !== "div") {
            mod = res.mod.neg();
            if (positive && mod.negative !== 0) {
              mod.iadd(num);
            }
          }
          return {
            div,
            mod
          };
        }
        if (this.negative === 0 && num.negative !== 0) {
          res = this.divmod(num.neg(), mode);
          if (mode !== "mod") {
            div = res.div.neg();
          }
          return {
            div,
            mod: res.mod
          };
        }
        if ((this.negative & num.negative) !== 0) {
          res = this.neg().divmod(num.neg(), mode);
          if (mode !== "div") {
            mod = res.mod.neg();
            if (positive && mod.negative !== 0) {
              mod.isub(num);
            }
          }
          return {
            div: res.div,
            mod
          };
        }
        if (num.length > this.length || this.cmp(num) < 0) {
          return {
            div: new BN(0),
            mod: this
          };
        }
        if (num.length === 1) {
          if (mode === "div") {
            return {
              div: this.divn(num.words[0]),
              mod: null
            };
          }
          if (mode === "mod") {
            return {
              div: null,
              mod: new BN(this.modrn(num.words[0]))
            };
          }
          return {
            div: this.divn(num.words[0]),
            mod: new BN(this.modrn(num.words[0]))
          };
        }
        return this._wordDiv(num, mode);
      };
      BN.prototype.div = function div(num) {
        return this.divmod(num, "div", false).div;
      };
      BN.prototype.mod = function mod(num) {
        return this.divmod(num, "mod", false).mod;
      };
      BN.prototype.umod = function umod(num) {
        return this.divmod(num, "mod", true).mod;
      };
      BN.prototype.divRound = function divRound(num) {
        var dm = this.divmod(num);
        if (dm.mod.isZero()) return dm.div;
        var mod = dm.div.negative !== 0 ? dm.mod.isub(num) : dm.mod;
        var half = num.ushrn(1);
        var r2 = num.andln(1);
        var cmp = mod.cmp(half);
        if (cmp < 0 || r2 === 1 && cmp === 0) return dm.div;
        return dm.div.negative !== 0 ? dm.div.isubn(1) : dm.div.iaddn(1);
      };
      BN.prototype.modrn = function modrn(num) {
        var isNegNum = num < 0;
        if (isNegNum) num = -num;
        assert(num <= 67108863);
        var p2 = (1 << 26) % num;
        var acc = 0;
        for (var i2 = this.length - 1; i2 >= 0; i2--) {
          acc = (p2 * acc + (this.words[i2] | 0)) % num;
        }
        return isNegNum ? -acc : acc;
      };
      BN.prototype.modn = function modn(num) {
        return this.modrn(num);
      };
      BN.prototype.idivn = function idivn(num) {
        var isNegNum = num < 0;
        if (isNegNum) num = -num;
        assert(num <= 67108863);
        var carry = 0;
        for (var i2 = this.length - 1; i2 >= 0; i2--) {
          var w = (this.words[i2] | 0) + carry * 67108864;
          this.words[i2] = w / num | 0;
          carry = w % num;
        }
        this._strip();
        return isNegNum ? this.ineg() : this;
      };
      BN.prototype.divn = function divn(num) {
        return this.clone().idivn(num);
      };
      BN.prototype.egcd = function egcd(p2) {
        assert(p2.negative === 0);
        assert(!p2.isZero());
        var x2 = this;
        var y2 = p2.clone();
        if (x2.negative !== 0) {
          x2 = x2.umod(p2);
        } else {
          x2 = x2.clone();
        }
        var A2 = new BN(1);
        var B2 = new BN(0);
        var C2 = new BN(0);
        var D = new BN(1);
        var g = 0;
        while (x2.isEven() && y2.isEven()) {
          x2.iushrn(1);
          y2.iushrn(1);
          ++g;
        }
        var yp = y2.clone();
        var xp = x2.clone();
        while (!x2.isZero()) {
          for (var i2 = 0, im = 1; (x2.words[0] & im) === 0 && i2 < 26; ++i2, im <<= 1) ;
          if (i2 > 0) {
            x2.iushrn(i2);
            while (i2-- > 0) {
              if (A2.isOdd() || B2.isOdd()) {
                A2.iadd(yp);
                B2.isub(xp);
              }
              A2.iushrn(1);
              B2.iushrn(1);
            }
          }
          for (var j = 0, jm = 1; (y2.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1) ;
          if (j > 0) {
            y2.iushrn(j);
            while (j-- > 0) {
              if (C2.isOdd() || D.isOdd()) {
                C2.iadd(yp);
                D.isub(xp);
              }
              C2.iushrn(1);
              D.iushrn(1);
            }
          }
          if (x2.cmp(y2) >= 0) {
            x2.isub(y2);
            A2.isub(C2);
            B2.isub(D);
          } else {
            y2.isub(x2);
            C2.isub(A2);
            D.isub(B2);
          }
        }
        return {
          a: C2,
          b: D,
          gcd: y2.iushln(g)
        };
      };
      BN.prototype._invmp = function _invmp(p2) {
        assert(p2.negative === 0);
        assert(!p2.isZero());
        var a2 = this;
        var b2 = p2.clone();
        if (a2.negative !== 0) {
          a2 = a2.umod(p2);
        } else {
          a2 = a2.clone();
        }
        var x1 = new BN(1);
        var x2 = new BN(0);
        var delta = b2.clone();
        while (a2.cmpn(1) > 0 && b2.cmpn(1) > 0) {
          for (var i2 = 0, im = 1; (a2.words[0] & im) === 0 && i2 < 26; ++i2, im <<= 1) ;
          if (i2 > 0) {
            a2.iushrn(i2);
            while (i2-- > 0) {
              if (x1.isOdd()) {
                x1.iadd(delta);
              }
              x1.iushrn(1);
            }
          }
          for (var j = 0, jm = 1; (b2.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1) ;
          if (j > 0) {
            b2.iushrn(j);
            while (j-- > 0) {
              if (x2.isOdd()) {
                x2.iadd(delta);
              }
              x2.iushrn(1);
            }
          }
          if (a2.cmp(b2) >= 0) {
            a2.isub(b2);
            x1.isub(x2);
          } else {
            b2.isub(a2);
            x2.isub(x1);
          }
        }
        var res;
        if (a2.cmpn(1) === 0) {
          res = x1;
        } else {
          res = x2;
        }
        if (res.cmpn(0) < 0) {
          res.iadd(p2);
        }
        return res;
      };
      BN.prototype.gcd = function gcd(num) {
        if (this.isZero()) return num.abs();
        if (num.isZero()) return this.abs();
        var a2 = this.clone();
        var b2 = num.clone();
        a2.negative = 0;
        b2.negative = 0;
        for (var shift = 0; a2.isEven() && b2.isEven(); shift++) {
          a2.iushrn(1);
          b2.iushrn(1);
        }
        do {
          while (a2.isEven()) {
            a2.iushrn(1);
          }
          while (b2.isEven()) {
            b2.iushrn(1);
          }
          var r2 = a2.cmp(b2);
          if (r2 < 0) {
            var t2 = a2;
            a2 = b2;
            b2 = t2;
          } else if (r2 === 0 || b2.cmpn(1) === 0) {
            break;
          }
          a2.isub(b2);
        } while (true);
        return b2.iushln(shift);
      };
      BN.prototype.invm = function invm(num) {
        return this.egcd(num).a.umod(num);
      };
      BN.prototype.isEven = function isEven() {
        return (this.words[0] & 1) === 0;
      };
      BN.prototype.isOdd = function isOdd() {
        return (this.words[0] & 1) === 1;
      };
      BN.prototype.andln = function andln(num) {
        return this.words[0] & num;
      };
      BN.prototype.bincn = function bincn(bit) {
        assert(typeof bit === "number");
        var r2 = bit % 26;
        var s2 = (bit - r2) / 26;
        var q = 1 << r2;
        if (this.length <= s2) {
          this._expand(s2 + 1);
          this.words[s2] |= q;
          return this;
        }
        var carry = q;
        for (var i2 = s2; carry !== 0 && i2 < this.length; i2++) {
          var w = this.words[i2] | 0;
          w += carry;
          carry = w >>> 26;
          w &= 67108863;
          this.words[i2] = w;
        }
        if (carry !== 0) {
          this.words[i2] = carry;
          this.length++;
        }
        return this;
      };
      BN.prototype.isZero = function isZero() {
        return this.length === 1 && this.words[0] === 0;
      };
      BN.prototype.cmpn = function cmpn(num) {
        var negative = num < 0;
        if (this.negative !== 0 && !negative) return -1;
        if (this.negative === 0 && negative) return 1;
        this._strip();
        var res;
        if (this.length > 1) {
          res = 1;
        } else {
          if (negative) {
            num = -num;
          }
          assert(num <= 67108863, "Number is too big");
          var w = this.words[0] | 0;
          res = w === num ? 0 : w < num ? -1 : 1;
        }
        if (this.negative !== 0) return -res | 0;
        return res;
      };
      BN.prototype.cmp = function cmp(num) {
        if (this.negative !== 0 && num.negative === 0) return -1;
        if (this.negative === 0 && num.negative !== 0) return 1;
        var res = this.ucmp(num);
        if (this.negative !== 0) return -res | 0;
        return res;
      };
      BN.prototype.ucmp = function ucmp(num) {
        if (this.length > num.length) return 1;
        if (this.length < num.length) return -1;
        var res = 0;
        for (var i2 = this.length - 1; i2 >= 0; i2--) {
          var a2 = this.words[i2] | 0;
          var b2 = num.words[i2] | 0;
          if (a2 === b2) continue;
          if (a2 < b2) {
            res = -1;
          } else if (a2 > b2) {
            res = 1;
          }
          break;
        }
        return res;
      };
      BN.prototype.gtn = function gtn(num) {
        return this.cmpn(num) === 1;
      };
      BN.prototype.gt = function gt(num) {
        return this.cmp(num) === 1;
      };
      BN.prototype.gten = function gten(num) {
        return this.cmpn(num) >= 0;
      };
      BN.prototype.gte = function gte(num) {
        return this.cmp(num) >= 0;
      };
      BN.prototype.ltn = function ltn(num) {
        return this.cmpn(num) === -1;
      };
      BN.prototype.lt = function lt(num) {
        return this.cmp(num) === -1;
      };
      BN.prototype.lten = function lten(num) {
        return this.cmpn(num) <= 0;
      };
      BN.prototype.lte = function lte(num) {
        return this.cmp(num) <= 0;
      };
      BN.prototype.eqn = function eqn(num) {
        return this.cmpn(num) === 0;
      };
      BN.prototype.eq = function eq(num) {
        return this.cmp(num) === 0;
      };
      BN.red = function red(num) {
        return new Red(num);
      };
      BN.prototype.toRed = function toRed(ctx) {
        assert(!this.red, "Already a number in reduction context");
        assert(this.negative === 0, "red works only with positives");
        return ctx.convertTo(this)._forceRed(ctx);
      };
      BN.prototype.fromRed = function fromRed() {
        assert(this.red, "fromRed works only with numbers in reduction context");
        return this.red.convertFrom(this);
      };
      BN.prototype._forceRed = function _forceRed(ctx) {
        this.red = ctx;
        return this;
      };
      BN.prototype.forceRed = function forceRed(ctx) {
        assert(!this.red, "Already a number in reduction context");
        return this._forceRed(ctx);
      };
      BN.prototype.redAdd = function redAdd(num) {
        assert(this.red, "redAdd works only with red numbers");
        return this.red.add(this, num);
      };
      BN.prototype.redIAdd = function redIAdd(num) {
        assert(this.red, "redIAdd works only with red numbers");
        return this.red.iadd(this, num);
      };
      BN.prototype.redSub = function redSub(num) {
        assert(this.red, "redSub works only with red numbers");
        return this.red.sub(this, num);
      };
      BN.prototype.redISub = function redISub(num) {
        assert(this.red, "redISub works only with red numbers");
        return this.red.isub(this, num);
      };
      BN.prototype.redShl = function redShl(num) {
        assert(this.red, "redShl works only with red numbers");
        return this.red.shl(this, num);
      };
      BN.prototype.redMul = function redMul(num) {
        assert(this.red, "redMul works only with red numbers");
        this.red._verify2(this, num);
        return this.red.mul(this, num);
      };
      BN.prototype.redIMul = function redIMul(num) {
        assert(this.red, "redMul works only with red numbers");
        this.red._verify2(this, num);
        return this.red.imul(this, num);
      };
      BN.prototype.redSqr = function redSqr() {
        assert(this.red, "redSqr works only with red numbers");
        this.red._verify1(this);
        return this.red.sqr(this);
      };
      BN.prototype.redISqr = function redISqr() {
        assert(this.red, "redISqr works only with red numbers");
        this.red._verify1(this);
        return this.red.isqr(this);
      };
      BN.prototype.redSqrt = function redSqrt() {
        assert(this.red, "redSqrt works only with red numbers");
        this.red._verify1(this);
        return this.red.sqrt(this);
      };
      BN.prototype.redInvm = function redInvm() {
        assert(this.red, "redInvm works only with red numbers");
        this.red._verify1(this);
        return this.red.invm(this);
      };
      BN.prototype.redNeg = function redNeg() {
        assert(this.red, "redNeg works only with red numbers");
        this.red._verify1(this);
        return this.red.neg(this);
      };
      BN.prototype.redPow = function redPow(num) {
        assert(this.red && !num.red, "redPow(normalNum)");
        this.red._verify1(this);
        return this.red.pow(this, num);
      };
      var primes = {
        k256: null,
        p224: null,
        p192: null,
        p25519: null
      };
      function MPrime(name, p2) {
        this.name = name;
        this.p = new BN(p2, 16);
        this.n = this.p.bitLength();
        this.k = new BN(1).iushln(this.n).isub(this.p);
        this.tmp = this._tmp();
      }
      MPrime.prototype._tmp = function _tmp() {
        var tmp = new BN(null);
        tmp.words = new Array(Math.ceil(this.n / 13));
        return tmp;
      };
      MPrime.prototype.ireduce = function ireduce(num) {
        var r2 = num;
        var rlen;
        do {
          this.split(r2, this.tmp);
          r2 = this.imulK(r2);
          r2 = r2.iadd(this.tmp);
          rlen = r2.bitLength();
        } while (rlen > this.n);
        var cmp = rlen < this.n ? -1 : r2.ucmp(this.p);
        if (cmp === 0) {
          r2.words[0] = 0;
          r2.length = 1;
        } else if (cmp > 0) {
          r2.isub(this.p);
        } else {
          if (r2.strip !== void 0) {
            r2.strip();
          } else {
            r2._strip();
          }
        }
        return r2;
      };
      MPrime.prototype.split = function split(input, out) {
        input.iushrn(this.n, 0, out);
      };
      MPrime.prototype.imulK = function imulK(num) {
        return num.imul(this.k);
      };
      function K256() {
        MPrime.call(
          this,
          "k256",
          "ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f"
        );
      }
      inherits(K256, MPrime);
      K256.prototype.split = function split(input, output) {
        var mask = 4194303;
        var outLen = Math.min(input.length, 9);
        for (var i2 = 0; i2 < outLen; i2++) {
          output.words[i2] = input.words[i2];
        }
        output.length = outLen;
        if (input.length <= 9) {
          input.words[0] = 0;
          input.length = 1;
          return;
        }
        var prev = input.words[9];
        output.words[output.length++] = prev & mask;
        for (i2 = 10; i2 < input.length; i2++) {
          var next = input.words[i2] | 0;
          input.words[i2 - 10] = (next & mask) << 4 | prev >>> 22;
          prev = next;
        }
        prev >>>= 22;
        input.words[i2 - 10] = prev;
        if (prev === 0 && input.length > 10) {
          input.length -= 10;
        } else {
          input.length -= 9;
        }
      };
      K256.prototype.imulK = function imulK(num) {
        num.words[num.length] = 0;
        num.words[num.length + 1] = 0;
        num.length += 2;
        var lo = 0;
        for (var i2 = 0; i2 < num.length; i2++) {
          var w = num.words[i2] | 0;
          lo += w * 977;
          num.words[i2] = lo & 67108863;
          lo = w * 64 + (lo / 67108864 | 0);
        }
        if (num.words[num.length - 1] === 0) {
          num.length--;
          if (num.words[num.length - 1] === 0) {
            num.length--;
          }
        }
        return num;
      };
      function P224() {
        MPrime.call(
          this,
          "p224",
          "ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001"
        );
      }
      inherits(P224, MPrime);
      function P192() {
        MPrime.call(
          this,
          "p192",
          "ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff"
        );
      }
      inherits(P192, MPrime);
      function P25519() {
        MPrime.call(
          this,
          "25519",
          "7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed"
        );
      }
      inherits(P25519, MPrime);
      P25519.prototype.imulK = function imulK(num) {
        var carry = 0;
        for (var i2 = 0; i2 < num.length; i2++) {
          var hi = (num.words[i2] | 0) * 19 + carry;
          var lo = hi & 67108863;
          hi >>>= 26;
          num.words[i2] = lo;
          carry = hi;
        }
        if (carry !== 0) {
          num.words[num.length++] = carry;
        }
        return num;
      };
      BN._prime = function prime(name) {
        if (primes[name]) return primes[name];
        var prime2;
        if (name === "k256") {
          prime2 = new K256();
        } else if (name === "p224") {
          prime2 = new P224();
        } else if (name === "p192") {
          prime2 = new P192();
        } else if (name === "p25519") {
          prime2 = new P25519();
        } else {
          throw new Error("Unknown prime " + name);
        }
        primes[name] = prime2;
        return prime2;
      };
      function Red(m) {
        if (typeof m === "string") {
          var prime = BN._prime(m);
          this.m = prime.p;
          this.prime = prime;
        } else {
          assert(m.gtn(1), "modulus must be greater than 1");
          this.m = m;
          this.prime = null;
        }
      }
      Red.prototype._verify1 = function _verify1(a2) {
        assert(a2.negative === 0, "red works only with positives");
        assert(a2.red, "red works only with red numbers");
      };
      Red.prototype._verify2 = function _verify2(a2, b2) {
        assert((a2.negative | b2.negative) === 0, "red works only with positives");
        assert(
          a2.red && a2.red === b2.red,
          "red works only with red numbers"
        );
      };
      Red.prototype.imod = function imod(a2) {
        if (this.prime) return this.prime.ireduce(a2)._forceRed(this);
        move(a2, a2.umod(this.m)._forceRed(this));
        return a2;
      };
      Red.prototype.neg = function neg(a2) {
        if (a2.isZero()) {
          return a2.clone();
        }
        return this.m.sub(a2)._forceRed(this);
      };
      Red.prototype.add = function add2(a2, b2) {
        this._verify2(a2, b2);
        var res = a2.add(b2);
        if (res.cmp(this.m) >= 0) {
          res.isub(this.m);
        }
        return res._forceRed(this);
      };
      Red.prototype.iadd = function iadd(a2, b2) {
        this._verify2(a2, b2);
        var res = a2.iadd(b2);
        if (res.cmp(this.m) >= 0) {
          res.isub(this.m);
        }
        return res;
      };
      Red.prototype.sub = function sub(a2, b2) {
        this._verify2(a2, b2);
        var res = a2.sub(b2);
        if (res.cmpn(0) < 0) {
          res.iadd(this.m);
        }
        return res._forceRed(this);
      };
      Red.prototype.isub = function isub(a2, b2) {
        this._verify2(a2, b2);
        var res = a2.isub(b2);
        if (res.cmpn(0) < 0) {
          res.iadd(this.m);
        }
        return res;
      };
      Red.prototype.shl = function shl(a2, num) {
        this._verify1(a2);
        return this.imod(a2.ushln(num));
      };
      Red.prototype.imul = function imul(a2, b2) {
        this._verify2(a2, b2);
        return this.imod(a2.imul(b2));
      };
      Red.prototype.mul = function mul(a2, b2) {
        this._verify2(a2, b2);
        return this.imod(a2.mul(b2));
      };
      Red.prototype.isqr = function isqr(a2) {
        return this.imul(a2, a2.clone());
      };
      Red.prototype.sqr = function sqr(a2) {
        return this.mul(a2, a2);
      };
      Red.prototype.sqrt = function sqrt(a2) {
        if (a2.isZero()) return a2.clone();
        var mod3 = this.m.andln(3);
        assert(mod3 % 2 === 1);
        if (mod3 === 3) {
          var pow2 = this.m.add(new BN(1)).iushrn(2);
          return this.pow(a2, pow2);
        }
        var q = this.m.subn(1);
        var s2 = 0;
        while (!q.isZero() && q.andln(1) === 0) {
          s2++;
          q.iushrn(1);
        }
        assert(!q.isZero());
        var one = new BN(1).toRed(this);
        var nOne = one.redNeg();
        var lpow = this.m.subn(1).iushrn(1);
        var z2 = this.m.bitLength();
        z2 = new BN(2 * z2 * z2).toRed(this);
        while (this.pow(z2, lpow).cmp(nOne) !== 0) {
          z2.redIAdd(nOne);
        }
        var c2 = this.pow(z2, q);
        var r2 = this.pow(a2, q.addn(1).iushrn(1));
        var t2 = this.pow(a2, q);
        var m = s2;
        while (t2.cmp(one) !== 0) {
          var tmp = t2;
          for (var i2 = 0; tmp.cmp(one) !== 0; i2++) {
            tmp = tmp.redSqr();
          }
          assert(i2 < m);
          var b2 = this.pow(c2, new BN(1).iushln(m - i2 - 1));
          r2 = r2.redMul(b2);
          c2 = b2.redSqr();
          t2 = t2.redMul(c2);
          m = i2;
        }
        return r2;
      };
      Red.prototype.invm = function invm(a2) {
        var inv = a2._invmp(this.m);
        if (inv.negative !== 0) {
          inv.negative = 0;
          return this.imod(inv).redNeg();
        } else {
          return this.imod(inv);
        }
      };
      Red.prototype.pow = function pow2(a2, num) {
        if (num.isZero()) return new BN(1).toRed(this);
        if (num.cmpn(1) === 0) return a2.clone();
        var windowSize = 4;
        var wnd = new Array(1 << windowSize);
        wnd[0] = new BN(1).toRed(this);
        wnd[1] = a2;
        for (var i2 = 2; i2 < wnd.length; i2++) {
          wnd[i2] = this.mul(wnd[i2 - 1], a2);
        }
        var res = wnd[0];
        var current = 0;
        var currentLen = 0;
        var start = num.bitLength() % 26;
        if (start === 0) {
          start = 26;
        }
        for (i2 = num.length - 1; i2 >= 0; i2--) {
          var word = num.words[i2];
          for (var j = start - 1; j >= 0; j--) {
            var bit = word >> j & 1;
            if (res !== wnd[0]) {
              res = this.sqr(res);
            }
            if (bit === 0 && current === 0) {
              currentLen = 0;
              continue;
            }
            current <<= 1;
            current |= bit;
            currentLen++;
            if (currentLen !== windowSize && (i2 !== 0 || j !== 0)) continue;
            res = this.mul(res, wnd[current]);
            currentLen = 0;
            current = 0;
          }
          start = 26;
        }
        return res;
      };
      Red.prototype.convertTo = function convertTo(num) {
        var r2 = num.umod(this.m);
        return r2 === num ? r2.clone() : r2;
      };
      Red.prototype.convertFrom = function convertFrom(num) {
        var res = num.clone();
        res.red = null;
        return res;
      };
      BN.mont = function mont2(num) {
        return new Mont(num);
      };
      function Mont(m) {
        Red.call(this, m);
        this.shift = this.m.bitLength();
        if (this.shift % 26 !== 0) {
          this.shift += 26 - this.shift % 26;
        }
        this.r = new BN(1).iushln(this.shift);
        this.r2 = this.imod(this.r.sqr());
        this.rinv = this.r._invmp(this.m);
        this.minv = this.rinv.mul(this.r).isubn(1).div(this.m);
        this.minv = this.minv.umod(this.r);
        this.minv = this.r.sub(this.minv);
      }
      inherits(Mont, Red);
      Mont.prototype.convertTo = function convertTo(num) {
        return this.imod(num.ushln(this.shift));
      };
      Mont.prototype.convertFrom = function convertFrom(num) {
        var r2 = this.imod(num.mul(this.rinv));
        r2.red = null;
        return r2;
      };
      Mont.prototype.imul = function imul(a2, b2) {
        if (a2.isZero() || b2.isZero()) {
          a2.words[0] = 0;
          a2.length = 1;
          return a2;
        }
        var t2 = a2.imul(b2);
        var c2 = t2.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);
        var u2 = t2.isub(c2).iushrn(this.shift);
        var res = u2;
        if (u2.cmp(this.m) >= 0) {
          res = u2.isub(this.m);
        } else if (u2.cmpn(0) < 0) {
          res = u2.iadd(this.m);
        }
        return res._forceRed(this);
      };
      Mont.prototype.mul = function mul(a2, b2) {
        if (a2.isZero() || b2.isZero()) return new BN(0)._forceRed(this);
        var t2 = a2.mul(b2);
        var c2 = t2.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);
        var u2 = t2.isub(c2).iushrn(this.shift);
        var res = u2;
        if (u2.cmp(this.m) >= 0) {
          res = u2.isub(this.m);
        } else if (u2.cmpn(0) < 0) {
          res = u2.iadd(this.m);
        }
        return res._forceRed(this);
      };
      Mont.prototype.invm = function invm(a2) {
        var res = this.imod(a2._invmp(this.m).mul(this.r2));
        return res._forceRed(this);
      };
    })(module2, bn);
  })(bn$1);
  return bn$1.exports;
}
var browserifyRsa;
var hasRequiredBrowserifyRsa;
function requireBrowserifyRsa() {
  if (hasRequiredBrowserifyRsa) return browserifyRsa;
  hasRequiredBrowserifyRsa = 1;
  var BN = requireBn();
  var randomBytes = requireBrowser$e();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  function getr(priv) {
    var len = priv.modulus.byteLength();
    var r2;
    do {
      r2 = new BN(randomBytes(len));
    } while (r2.cmp(priv.modulus) >= 0 || !r2.umod(priv.prime1) || !r2.umod(priv.prime2));
    return r2;
  }
  function blind(priv) {
    var r2 = getr(priv);
    var blinder = r2.toRed(BN.mont(priv.modulus)).redPow(new BN(priv.publicExponent)).fromRed();
    return { blinder, unblinder: r2.invm(priv.modulus) };
  }
  function crt(msg, priv) {
    var blinds = blind(priv);
    var len = priv.modulus.byteLength();
    var blinded = new BN(msg).mul(blinds.blinder).umod(priv.modulus);
    var c1 = blinded.toRed(BN.mont(priv.prime1));
    var c2 = blinded.toRed(BN.mont(priv.prime2));
    var qinv = priv.coefficient;
    var p2 = priv.prime1;
    var q = priv.prime2;
    var m1 = c1.redPow(priv.exponent1).fromRed();
    var m2 = c2.redPow(priv.exponent2).fromRed();
    var h2 = m1.isub(m2).imul(qinv).umod(p2).imul(q);
    return m2.iadd(h2).imul(blinds.unblinder).umod(priv.modulus).toArrayLike(Buffer2, "be", len);
  }
  crt.getr = getr;
  browserifyRsa = crt;
  return browserifyRsa;
}
var elliptic = {};
const version$1 = "6.6.1";
const require$$0$1 = {
  version: version$1
};
var utils$3 = {};
var utils$2 = {};
var hasRequiredUtils$3;
function requireUtils$3() {
  if (hasRequiredUtils$3) return utils$2;
  hasRequiredUtils$3 = 1;
  (function(exports) {
    var utils2 = exports;
    function toArray(msg, enc) {
      if (Array.isArray(msg))
        return msg.slice();
      if (!msg)
        return [];
      var res = [];
      if (typeof msg !== "string") {
        for (var i2 = 0; i2 < msg.length; i2++)
          res[i2] = msg[i2] | 0;
        return res;
      }
      if (enc === "hex") {
        msg = msg.replace(/[^a-z0-9]+/ig, "");
        if (msg.length % 2 !== 0)
          msg = "0" + msg;
        for (var i2 = 0; i2 < msg.length; i2 += 2)
          res.push(parseInt(msg[i2] + msg[i2 + 1], 16));
      } else {
        for (var i2 = 0; i2 < msg.length; i2++) {
          var c2 = msg.charCodeAt(i2);
          var hi = c2 >> 8;
          var lo = c2 & 255;
          if (hi)
            res.push(hi, lo);
          else
            res.push(lo);
        }
      }
      return res;
    }
    utils2.toArray = toArray;
    function zero2(word) {
      if (word.length === 1)
        return "0" + word;
      else
        return word;
    }
    utils2.zero2 = zero2;
    function toHex2(msg) {
      var res = "";
      for (var i2 = 0; i2 < msg.length; i2++)
        res += zero2(msg[i2].toString(16));
      return res;
    }
    utils2.toHex = toHex2;
    utils2.encode = function encode2(arr, enc) {
      if (enc === "hex")
        return toHex2(arr);
      else
        return arr;
    };
  })(utils$2);
  return utils$2;
}
var hasRequiredUtils$2;
function requireUtils$2() {
  if (hasRequiredUtils$2) return utils$3;
  hasRequiredUtils$2 = 1;
  (function(exports) {
    var utils2 = exports;
    var BN = requireBn$1();
    var minAssert = requireMinimalisticAssert();
    var minUtils = requireUtils$3();
    utils2.assert = minAssert;
    utils2.toArray = minUtils.toArray;
    utils2.zero2 = minUtils.zero2;
    utils2.toHex = minUtils.toHex;
    utils2.encode = minUtils.encode;
    function getNAF(num, w, bits) {
      var naf = new Array(Math.max(num.bitLength(), bits) + 1);
      var i2;
      for (i2 = 0; i2 < naf.length; i2 += 1) {
        naf[i2] = 0;
      }
      var ws = 1 << w + 1;
      var k2 = num.clone();
      for (i2 = 0; i2 < naf.length; i2++) {
        var z2;
        var mod = k2.andln(ws - 1);
        if (k2.isOdd()) {
          if (mod > (ws >> 1) - 1)
            z2 = (ws >> 1) - mod;
          else
            z2 = mod;
          k2.isubn(z2);
        } else {
          z2 = 0;
        }
        naf[i2] = z2;
        k2.iushrn(1);
      }
      return naf;
    }
    utils2.getNAF = getNAF;
    function getJSF(k1, k2) {
      var jsf = [
        [],
        []
      ];
      k1 = k1.clone();
      k2 = k2.clone();
      var d1 = 0;
      var d2 = 0;
      var m8;
      while (k1.cmpn(-d1) > 0 || k2.cmpn(-d2) > 0) {
        var m14 = k1.andln(3) + d1 & 3;
        var m24 = k2.andln(3) + d2 & 3;
        if (m14 === 3)
          m14 = -1;
        if (m24 === 3)
          m24 = -1;
        var u1;
        if ((m14 & 1) === 0) {
          u1 = 0;
        } else {
          m8 = k1.andln(7) + d1 & 7;
          if ((m8 === 3 || m8 === 5) && m24 === 2)
            u1 = -m14;
          else
            u1 = m14;
        }
        jsf[0].push(u1);
        var u2;
        if ((m24 & 1) === 0) {
          u2 = 0;
        } else {
          m8 = k2.andln(7) + d2 & 7;
          if ((m8 === 3 || m8 === 5) && m14 === 2)
            u2 = -m24;
          else
            u2 = m24;
        }
        jsf[1].push(u2);
        if (2 * d1 === u1 + 1)
          d1 = 1 - d1;
        if (2 * d2 === u2 + 1)
          d2 = 1 - d2;
        k1.iushrn(1);
        k2.iushrn(1);
      }
      return jsf;
    }
    utils2.getJSF = getJSF;
    function cachedProperty(obj, name, computer) {
      var key2 = "_" + name;
      obj.prototype[name] = function cachedProperty2() {
        return this[key2] !== void 0 ? this[key2] : this[key2] = computer.call(this);
      };
    }
    utils2.cachedProperty = cachedProperty;
    function parseBytes(bytes) {
      return typeof bytes === "string" ? utils2.toArray(bytes, "hex") : bytes;
    }
    utils2.parseBytes = parseBytes;
    function intFromLE(bytes) {
      return new BN(bytes, "hex", "le");
    }
    utils2.intFromLE = intFromLE;
  })(utils$3);
  return utils$3;
}
var curve$1 = {};
var base$1;
var hasRequiredBase$1;
function requireBase$1() {
  if (hasRequiredBase$1) return base$1;
  hasRequiredBase$1 = 1;
  var BN = requireBn$1();
  var utils2 = requireUtils$2();
  var getNAF = utils2.getNAF;
  var getJSF = utils2.getJSF;
  var assert = utils2.assert;
  function BaseCurve(type2, conf) {
    this.type = type2;
    this.p = new BN(conf.p, 16);
    this.red = conf.prime ? BN.red(conf.prime) : BN.mont(this.p);
    this.zero = new BN(0).toRed(this.red);
    this.one = new BN(1).toRed(this.red);
    this.two = new BN(2).toRed(this.red);
    this.n = conf.n && new BN(conf.n, 16);
    this.g = conf.g && this.pointFromJSON(conf.g, conf.gRed);
    this._wnafT1 = new Array(4);
    this._wnafT2 = new Array(4);
    this._wnafT3 = new Array(4);
    this._wnafT4 = new Array(4);
    this._bitLength = this.n ? this.n.bitLength() : 0;
    var adjustCount = this.n && this.p.div(this.n);
    if (!adjustCount || adjustCount.cmpn(100) > 0) {
      this.redN = null;
    } else {
      this._maxwellTrick = true;
      this.redN = this.n.toRed(this.red);
    }
  }
  base$1 = BaseCurve;
  BaseCurve.prototype.point = function point() {
    throw new Error("Not implemented");
  };
  BaseCurve.prototype.validate = function validate2() {
    throw new Error("Not implemented");
  };
  BaseCurve.prototype._fixedNafMul = function _fixedNafMul(p2, k2) {
    assert(p2.precomputed);
    var doubles = p2._getDoubles();
    var naf = getNAF(k2, 1, this._bitLength);
    var I = (1 << doubles.step + 1) - (doubles.step % 2 === 0 ? 2 : 1);
    I /= 3;
    var repr = [];
    var j;
    var nafW;
    for (j = 0; j < naf.length; j += doubles.step) {
      nafW = 0;
      for (var l2 = j + doubles.step - 1; l2 >= j; l2--)
        nafW = (nafW << 1) + naf[l2];
      repr.push(nafW);
    }
    var a2 = this.jpoint(null, null, null);
    var b2 = this.jpoint(null, null, null);
    for (var i2 = I; i2 > 0; i2--) {
      for (j = 0; j < repr.length; j++) {
        nafW = repr[j];
        if (nafW === i2)
          b2 = b2.mixedAdd(doubles.points[j]);
        else if (nafW === -i2)
          b2 = b2.mixedAdd(doubles.points[j].neg());
      }
      a2 = a2.add(b2);
    }
    return a2.toP();
  };
  BaseCurve.prototype._wnafMul = function _wnafMul(p2, k2) {
    var w = 4;
    var nafPoints = p2._getNAFPoints(w);
    w = nafPoints.wnd;
    var wnd = nafPoints.points;
    var naf = getNAF(k2, w, this._bitLength);
    var acc = this.jpoint(null, null, null);
    for (var i2 = naf.length - 1; i2 >= 0; i2--) {
      for (var l2 = 0; i2 >= 0 && naf[i2] === 0; i2--)
        l2++;
      if (i2 >= 0)
        l2++;
      acc = acc.dblp(l2);
      if (i2 < 0)
        break;
      var z2 = naf[i2];
      assert(z2 !== 0);
      if (p2.type === "affine") {
        if (z2 > 0)
          acc = acc.mixedAdd(wnd[z2 - 1 >> 1]);
        else
          acc = acc.mixedAdd(wnd[-z2 - 1 >> 1].neg());
      } else {
        if (z2 > 0)
          acc = acc.add(wnd[z2 - 1 >> 1]);
        else
          acc = acc.add(wnd[-z2 - 1 >> 1].neg());
      }
    }
    return p2.type === "affine" ? acc.toP() : acc;
  };
  BaseCurve.prototype._wnafMulAdd = function _wnafMulAdd(defW, points, coeffs, len, jacobianResult) {
    var wndWidth = this._wnafT1;
    var wnd = this._wnafT2;
    var naf = this._wnafT3;
    var max2 = 0;
    var i2;
    var j;
    var p2;
    for (i2 = 0; i2 < len; i2++) {
      p2 = points[i2];
      var nafPoints = p2._getNAFPoints(defW);
      wndWidth[i2] = nafPoints.wnd;
      wnd[i2] = nafPoints.points;
    }
    for (i2 = len - 1; i2 >= 1; i2 -= 2) {
      var a2 = i2 - 1;
      var b2 = i2;
      if (wndWidth[a2] !== 1 || wndWidth[b2] !== 1) {
        naf[a2] = getNAF(coeffs[a2], wndWidth[a2], this._bitLength);
        naf[b2] = getNAF(coeffs[b2], wndWidth[b2], this._bitLength);
        max2 = Math.max(naf[a2].length, max2);
        max2 = Math.max(naf[b2].length, max2);
        continue;
      }
      var comb = [
        points[a2],
        /* 1 */
        null,
        /* 3 */
        null,
        /* 5 */
        points[b2]
        /* 7 */
      ];
      if (points[a2].y.cmp(points[b2].y) === 0) {
        comb[1] = points[a2].add(points[b2]);
        comb[2] = points[a2].toJ().mixedAdd(points[b2].neg());
      } else if (points[a2].y.cmp(points[b2].y.redNeg()) === 0) {
        comb[1] = points[a2].toJ().mixedAdd(points[b2]);
        comb[2] = points[a2].add(points[b2].neg());
      } else {
        comb[1] = points[a2].toJ().mixedAdd(points[b2]);
        comb[2] = points[a2].toJ().mixedAdd(points[b2].neg());
      }
      var index2 = [
        -3,
        /* -1 -1 */
        -1,
        /* -1 0 */
        -5,
        /* -1 1 */
        -7,
        /* 0 -1 */
        0,
        /* 0 0 */
        7,
        /* 0 1 */
        5,
        /* 1 -1 */
        1,
        /* 1 0 */
        3
        /* 1 1 */
      ];
      var jsf = getJSF(coeffs[a2], coeffs[b2]);
      max2 = Math.max(jsf[0].length, max2);
      naf[a2] = new Array(max2);
      naf[b2] = new Array(max2);
      for (j = 0; j < max2; j++) {
        var ja = jsf[0][j] | 0;
        var jb = jsf[1][j] | 0;
        naf[a2][j] = index2[(ja + 1) * 3 + (jb + 1)];
        naf[b2][j] = 0;
        wnd[a2] = comb;
      }
    }
    var acc = this.jpoint(null, null, null);
    var tmp = this._wnafT4;
    for (i2 = max2; i2 >= 0; i2--) {
      var k2 = 0;
      while (i2 >= 0) {
        var zero = true;
        for (j = 0; j < len; j++) {
          tmp[j] = naf[j][i2] | 0;
          if (tmp[j] !== 0)
            zero = false;
        }
        if (!zero)
          break;
        k2++;
        i2--;
      }
      if (i2 >= 0)
        k2++;
      acc = acc.dblp(k2);
      if (i2 < 0)
        break;
      for (j = 0; j < len; j++) {
        var z2 = tmp[j];
        if (z2 === 0)
          continue;
        else if (z2 > 0)
          p2 = wnd[j][z2 - 1 >> 1];
        else if (z2 < 0)
          p2 = wnd[j][-z2 - 1 >> 1].neg();
        if (p2.type === "affine")
          acc = acc.mixedAdd(p2);
        else
          acc = acc.add(p2);
      }
    }
    for (i2 = 0; i2 < len; i2++)
      wnd[i2] = null;
    if (jacobianResult)
      return acc;
    else
      return acc.toP();
  };
  function BasePoint(curve2, type2) {
    this.curve = curve2;
    this.type = type2;
    this.precomputed = null;
  }
  BaseCurve.BasePoint = BasePoint;
  BasePoint.prototype.eq = function eq() {
    throw new Error("Not implemented");
  };
  BasePoint.prototype.validate = function validate2() {
    return this.curve.validate(this);
  };
  BaseCurve.prototype.decodePoint = function decodePoint(bytes, enc) {
    bytes = utils2.toArray(bytes, enc);
    var len = this.p.byteLength();
    if ((bytes[0] === 4 || bytes[0] === 6 || bytes[0] === 7) && bytes.length - 1 === 2 * len) {
      if (bytes[0] === 6)
        assert(bytes[bytes.length - 1] % 2 === 0);
      else if (bytes[0] === 7)
        assert(bytes[bytes.length - 1] % 2 === 1);
      var res = this.point(
        bytes.slice(1, 1 + len),
        bytes.slice(1 + len, 1 + 2 * len)
      );
      return res;
    } else if ((bytes[0] === 2 || bytes[0] === 3) && bytes.length - 1 === len) {
      return this.pointFromX(bytes.slice(1, 1 + len), bytes[0] === 3);
    }
    throw new Error("Unknown point format");
  };
  BasePoint.prototype.encodeCompressed = function encodeCompressed(enc) {
    return this.encode(enc, true);
  };
  BasePoint.prototype._encode = function _encode(compact) {
    var len = this.curve.p.byteLength();
    var x2 = this.getX().toArray("be", len);
    if (compact)
      return [this.getY().isEven() ? 2 : 3].concat(x2);
    return [4].concat(x2, this.getY().toArray("be", len));
  };
  BasePoint.prototype.encode = function encode2(enc, compact) {
    return utils2.encode(this._encode(compact), enc);
  };
  BasePoint.prototype.precompute = function precompute(power) {
    if (this.precomputed)
      return this;
    var precomputed = {
      doubles: null,
      naf: null,
      beta: null
    };
    precomputed.naf = this._getNAFPoints(8);
    precomputed.doubles = this._getDoubles(4, power);
    precomputed.beta = this._getBeta();
    this.precomputed = precomputed;
    return this;
  };
  BasePoint.prototype._hasDoubles = function _hasDoubles(k2) {
    if (!this.precomputed)
      return false;
    var doubles = this.precomputed.doubles;
    if (!doubles)
      return false;
    return doubles.points.length >= Math.ceil((k2.bitLength() + 1) / doubles.step);
  };
  BasePoint.prototype._getDoubles = function _getDoubles(step, power) {
    if (this.precomputed && this.precomputed.doubles)
      return this.precomputed.doubles;
    var doubles = [this];
    var acc = this;
    for (var i2 = 0; i2 < power; i2 += step) {
      for (var j = 0; j < step; j++)
        acc = acc.dbl();
      doubles.push(acc);
    }
    return {
      step,
      points: doubles
    };
  };
  BasePoint.prototype._getNAFPoints = function _getNAFPoints(wnd) {
    if (this.precomputed && this.precomputed.naf)
      return this.precomputed.naf;
    var res = [this];
    var max2 = (1 << wnd) - 1;
    var dbl = max2 === 1 ? null : this.dbl();
    for (var i2 = 1; i2 < max2; i2++)
      res[i2] = res[i2 - 1].add(dbl);
    return {
      wnd,
      points: res
    };
  };
  BasePoint.prototype._getBeta = function _getBeta() {
    return null;
  };
  BasePoint.prototype.dblp = function dblp(k2) {
    var r2 = this;
    for (var i2 = 0; i2 < k2; i2++)
      r2 = r2.dbl();
    return r2;
  };
  return base$1;
}
var short;
var hasRequiredShort;
function requireShort() {
  if (hasRequiredShort) return short;
  hasRequiredShort = 1;
  var utils2 = requireUtils$2();
  var BN = requireBn$1();
  var inherits = requireInherits_browser();
  var Base = requireBase$1();
  var assert = utils2.assert;
  function ShortCurve(conf) {
    Base.call(this, "short", conf);
    this.a = new BN(conf.a, 16).toRed(this.red);
    this.b = new BN(conf.b, 16).toRed(this.red);
    this.tinv = this.two.redInvm();
    this.zeroA = this.a.fromRed().cmpn(0) === 0;
    this.threeA = this.a.fromRed().sub(this.p).cmpn(-3) === 0;
    this.endo = this._getEndomorphism(conf);
    this._endoWnafT1 = new Array(4);
    this._endoWnafT2 = new Array(4);
  }
  inherits(ShortCurve, Base);
  short = ShortCurve;
  ShortCurve.prototype._getEndomorphism = function _getEndomorphism(conf) {
    if (!this.zeroA || !this.g || !this.n || this.p.modn(3) !== 1)
      return;
    var beta;
    var lambda;
    if (conf.beta) {
      beta = new BN(conf.beta, 16).toRed(this.red);
    } else {
      var betas = this._getEndoRoots(this.p);
      beta = betas[0].cmp(betas[1]) < 0 ? betas[0] : betas[1];
      beta = beta.toRed(this.red);
    }
    if (conf.lambda) {
      lambda = new BN(conf.lambda, 16);
    } else {
      var lambdas = this._getEndoRoots(this.n);
      if (this.g.mul(lambdas[0]).x.cmp(this.g.x.redMul(beta)) === 0) {
        lambda = lambdas[0];
      } else {
        lambda = lambdas[1];
        assert(this.g.mul(lambda).x.cmp(this.g.x.redMul(beta)) === 0);
      }
    }
    var basis;
    if (conf.basis) {
      basis = conf.basis.map(function(vec) {
        return {
          a: new BN(vec.a, 16),
          b: new BN(vec.b, 16)
        };
      });
    } else {
      basis = this._getEndoBasis(lambda);
    }
    return {
      beta,
      lambda,
      basis
    };
  };
  ShortCurve.prototype._getEndoRoots = function _getEndoRoots(num) {
    var red = num === this.p ? this.red : BN.mont(num);
    var tinv = new BN(2).toRed(red).redInvm();
    var ntinv = tinv.redNeg();
    var s2 = new BN(3).toRed(red).redNeg().redSqrt().redMul(tinv);
    var l1 = ntinv.redAdd(s2).fromRed();
    var l2 = ntinv.redSub(s2).fromRed();
    return [l1, l2];
  };
  ShortCurve.prototype._getEndoBasis = function _getEndoBasis(lambda) {
    var aprxSqrt = this.n.ushrn(Math.floor(this.n.bitLength() / 2));
    var u2 = lambda;
    var v2 = this.n.clone();
    var x1 = new BN(1);
    var y1 = new BN(0);
    var x2 = new BN(0);
    var y2 = new BN(1);
    var a0;
    var b0;
    var a1;
    var b1;
    var a2;
    var b2;
    var prevR;
    var i2 = 0;
    var r2;
    var x3;
    while (u2.cmpn(0) !== 0) {
      var q = v2.div(u2);
      r2 = v2.sub(q.mul(u2));
      x3 = x2.sub(q.mul(x1));
      var y3 = y2.sub(q.mul(y1));
      if (!a1 && r2.cmp(aprxSqrt) < 0) {
        a0 = prevR.neg();
        b0 = x1;
        a1 = r2.neg();
        b1 = x3;
      } else if (a1 && ++i2 === 2) {
        break;
      }
      prevR = r2;
      v2 = u2;
      u2 = r2;
      x2 = x1;
      x1 = x3;
      y2 = y1;
      y1 = y3;
    }
    a2 = r2.neg();
    b2 = x3;
    var len1 = a1.sqr().add(b1.sqr());
    var len2 = a2.sqr().add(b2.sqr());
    if (len2.cmp(len1) >= 0) {
      a2 = a0;
      b2 = b0;
    }
    if (a1.negative) {
      a1 = a1.neg();
      b1 = b1.neg();
    }
    if (a2.negative) {
      a2 = a2.neg();
      b2 = b2.neg();
    }
    return [
      { a: a1, b: b1 },
      { a: a2, b: b2 }
    ];
  };
  ShortCurve.prototype._endoSplit = function _endoSplit(k2) {
    var basis = this.endo.basis;
    var v1 = basis[0];
    var v2 = basis[1];
    var c1 = v2.b.mul(k2).divRound(this.n);
    var c2 = v1.b.neg().mul(k2).divRound(this.n);
    var p1 = c1.mul(v1.a);
    var p2 = c2.mul(v2.a);
    var q1 = c1.mul(v1.b);
    var q2 = c2.mul(v2.b);
    var k1 = k2.sub(p1).sub(p2);
    var k22 = q1.add(q2).neg();
    return { k1, k2: k22 };
  };
  ShortCurve.prototype.pointFromX = function pointFromX(x2, odd) {
    x2 = new BN(x2, 16);
    if (!x2.red)
      x2 = x2.toRed(this.red);
    var y2 = x2.redSqr().redMul(x2).redIAdd(x2.redMul(this.a)).redIAdd(this.b);
    var y3 = y2.redSqrt();
    if (y3.redSqr().redSub(y2).cmp(this.zero) !== 0)
      throw new Error("invalid point");
    var isOdd = y3.fromRed().isOdd();
    if (odd && !isOdd || !odd && isOdd)
      y3 = y3.redNeg();
    return this.point(x2, y3);
  };
  ShortCurve.prototype.validate = function validate2(point) {
    if (point.inf)
      return true;
    var x2 = point.x;
    var y2 = point.y;
    var ax = this.a.redMul(x2);
    var rhs = x2.redSqr().redMul(x2).redIAdd(ax).redIAdd(this.b);
    return y2.redSqr().redISub(rhs).cmpn(0) === 0;
  };
  ShortCurve.prototype._endoWnafMulAdd = function _endoWnafMulAdd(points, coeffs, jacobianResult) {
    var npoints = this._endoWnafT1;
    var ncoeffs = this._endoWnafT2;
    for (var i2 = 0; i2 < points.length; i2++) {
      var split = this._endoSplit(coeffs[i2]);
      var p2 = points[i2];
      var beta = p2._getBeta();
      if (split.k1.negative) {
        split.k1.ineg();
        p2 = p2.neg(true);
      }
      if (split.k2.negative) {
        split.k2.ineg();
        beta = beta.neg(true);
      }
      npoints[i2 * 2] = p2;
      npoints[i2 * 2 + 1] = beta;
      ncoeffs[i2 * 2] = split.k1;
      ncoeffs[i2 * 2 + 1] = split.k2;
    }
    var res = this._wnafMulAdd(1, npoints, ncoeffs, i2 * 2, jacobianResult);
    for (var j = 0; j < i2 * 2; j++) {
      npoints[j] = null;
      ncoeffs[j] = null;
    }
    return res;
  };
  function Point2(curve2, x2, y2, isRed) {
    Base.BasePoint.call(this, curve2, "affine");
    if (x2 === null && y2 === null) {
      this.x = null;
      this.y = null;
      this.inf = true;
    } else {
      this.x = new BN(x2, 16);
      this.y = new BN(y2, 16);
      if (isRed) {
        this.x.forceRed(this.curve.red);
        this.y.forceRed(this.curve.red);
      }
      if (!this.x.red)
        this.x = this.x.toRed(this.curve.red);
      if (!this.y.red)
        this.y = this.y.toRed(this.curve.red);
      this.inf = false;
    }
  }
  inherits(Point2, Base.BasePoint);
  ShortCurve.prototype.point = function point(x2, y2, isRed) {
    return new Point2(this, x2, y2, isRed);
  };
  ShortCurve.prototype.pointFromJSON = function pointFromJSON(obj, red) {
    return Point2.fromJSON(this, obj, red);
  };
  Point2.prototype._getBeta = function _getBeta() {
    if (!this.curve.endo)
      return;
    var pre = this.precomputed;
    if (pre && pre.beta)
      return pre.beta;
    var beta = this.curve.point(this.x.redMul(this.curve.endo.beta), this.y);
    if (pre) {
      var curve2 = this.curve;
      var endoMul = function(p2) {
        return curve2.point(p2.x.redMul(curve2.endo.beta), p2.y);
      };
      pre.beta = beta;
      beta.precomputed = {
        beta: null,
        naf: pre.naf && {
          wnd: pre.naf.wnd,
          points: pre.naf.points.map(endoMul)
        },
        doubles: pre.doubles && {
          step: pre.doubles.step,
          points: pre.doubles.points.map(endoMul)
        }
      };
    }
    return beta;
  };
  Point2.prototype.toJSON = function toJSON() {
    if (!this.precomputed)
      return [this.x, this.y];
    return [this.x, this.y, this.precomputed && {
      doubles: this.precomputed.doubles && {
        step: this.precomputed.doubles.step,
        points: this.precomputed.doubles.points.slice(1)
      },
      naf: this.precomputed.naf && {
        wnd: this.precomputed.naf.wnd,
        points: this.precomputed.naf.points.slice(1)
      }
    }];
  };
  Point2.fromJSON = function fromJSON(curve2, obj, red) {
    if (typeof obj === "string")
      obj = JSON.parse(obj);
    var res = curve2.point(obj[0], obj[1], red);
    if (!obj[2])
      return res;
    function obj2point(obj2) {
      return curve2.point(obj2[0], obj2[1], red);
    }
    var pre = obj[2];
    res.precomputed = {
      beta: null,
      doubles: pre.doubles && {
        step: pre.doubles.step,
        points: [res].concat(pre.doubles.points.map(obj2point))
      },
      naf: pre.naf && {
        wnd: pre.naf.wnd,
        points: [res].concat(pre.naf.points.map(obj2point))
      }
    };
    return res;
  };
  Point2.prototype.inspect = function inspect() {
    if (this.isInfinity())
      return "<EC Point Infinity>";
    return "<EC Point x: " + this.x.fromRed().toString(16, 2) + " y: " + this.y.fromRed().toString(16, 2) + ">";
  };
  Point2.prototype.isInfinity = function isInfinity() {
    return this.inf;
  };
  Point2.prototype.add = function add2(p2) {
    if (this.inf)
      return p2;
    if (p2.inf)
      return this;
    if (this.eq(p2))
      return this.dbl();
    if (this.neg().eq(p2))
      return this.curve.point(null, null);
    if (this.x.cmp(p2.x) === 0)
      return this.curve.point(null, null);
    var c2 = this.y.redSub(p2.y);
    if (c2.cmpn(0) !== 0)
      c2 = c2.redMul(this.x.redSub(p2.x).redInvm());
    var nx = c2.redSqr().redISub(this.x).redISub(p2.x);
    var ny = c2.redMul(this.x.redSub(nx)).redISub(this.y);
    return this.curve.point(nx, ny);
  };
  Point2.prototype.dbl = function dbl() {
    if (this.inf)
      return this;
    var ys1 = this.y.redAdd(this.y);
    if (ys1.cmpn(0) === 0)
      return this.curve.point(null, null);
    var a2 = this.curve.a;
    var x2 = this.x.redSqr();
    var dyinv = ys1.redInvm();
    var c2 = x2.redAdd(x2).redIAdd(x2).redIAdd(a2).redMul(dyinv);
    var nx = c2.redSqr().redISub(this.x.redAdd(this.x));
    var ny = c2.redMul(this.x.redSub(nx)).redISub(this.y);
    return this.curve.point(nx, ny);
  };
  Point2.prototype.getX = function getX() {
    return this.x.fromRed();
  };
  Point2.prototype.getY = function getY() {
    return this.y.fromRed();
  };
  Point2.prototype.mul = function mul(k2) {
    k2 = new BN(k2, 16);
    if (this.isInfinity())
      return this;
    else if (this._hasDoubles(k2))
      return this.curve._fixedNafMul(this, k2);
    else if (this.curve.endo)
      return this.curve._endoWnafMulAdd([this], [k2]);
    else
      return this.curve._wnafMul(this, k2);
  };
  Point2.prototype.mulAdd = function mulAdd(k1, p2, k2) {
    var points = [this, p2];
    var coeffs = [k1, k2];
    if (this.curve.endo)
      return this.curve._endoWnafMulAdd(points, coeffs);
    else
      return this.curve._wnafMulAdd(1, points, coeffs, 2);
  };
  Point2.prototype.jmulAdd = function jmulAdd(k1, p2, k2) {
    var points = [this, p2];
    var coeffs = [k1, k2];
    if (this.curve.endo)
      return this.curve._endoWnafMulAdd(points, coeffs, true);
    else
      return this.curve._wnafMulAdd(1, points, coeffs, 2, true);
  };
  Point2.prototype.eq = function eq(p2) {
    return this === p2 || this.inf === p2.inf && (this.inf || this.x.cmp(p2.x) === 0 && this.y.cmp(p2.y) === 0);
  };
  Point2.prototype.neg = function neg(_precompute) {
    if (this.inf)
      return this;
    var res = this.curve.point(this.x, this.y.redNeg());
    if (_precompute && this.precomputed) {
      var pre = this.precomputed;
      var negate = function(p2) {
        return p2.neg();
      };
      res.precomputed = {
        naf: pre.naf && {
          wnd: pre.naf.wnd,
          points: pre.naf.points.map(negate)
        },
        doubles: pre.doubles && {
          step: pre.doubles.step,
          points: pre.doubles.points.map(negate)
        }
      };
    }
    return res;
  };
  Point2.prototype.toJ = function toJ() {
    if (this.inf)
      return this.curve.jpoint(null, null, null);
    var res = this.curve.jpoint(this.x, this.y, this.curve.one);
    return res;
  };
  function JPoint(curve2, x2, y2, z2) {
    Base.BasePoint.call(this, curve2, "jacobian");
    if (x2 === null && y2 === null && z2 === null) {
      this.x = this.curve.one;
      this.y = this.curve.one;
      this.z = new BN(0);
    } else {
      this.x = new BN(x2, 16);
      this.y = new BN(y2, 16);
      this.z = new BN(z2, 16);
    }
    if (!this.x.red)
      this.x = this.x.toRed(this.curve.red);
    if (!this.y.red)
      this.y = this.y.toRed(this.curve.red);
    if (!this.z.red)
      this.z = this.z.toRed(this.curve.red);
    this.zOne = this.z === this.curve.one;
  }
  inherits(JPoint, Base.BasePoint);
  ShortCurve.prototype.jpoint = function jpoint(x2, y2, z2) {
    return new JPoint(this, x2, y2, z2);
  };
  JPoint.prototype.toP = function toP() {
    if (this.isInfinity())
      return this.curve.point(null, null);
    var zinv = this.z.redInvm();
    var zinv2 = zinv.redSqr();
    var ax = this.x.redMul(zinv2);
    var ay = this.y.redMul(zinv2).redMul(zinv);
    return this.curve.point(ax, ay);
  };
  JPoint.prototype.neg = function neg() {
    return this.curve.jpoint(this.x, this.y.redNeg(), this.z);
  };
  JPoint.prototype.add = function add2(p2) {
    if (this.isInfinity())
      return p2;
    if (p2.isInfinity())
      return this;
    var pz2 = p2.z.redSqr();
    var z2 = this.z.redSqr();
    var u1 = this.x.redMul(pz2);
    var u2 = p2.x.redMul(z2);
    var s1 = this.y.redMul(pz2.redMul(p2.z));
    var s2 = p2.y.redMul(z2.redMul(this.z));
    var h2 = u1.redSub(u2);
    var r2 = s1.redSub(s2);
    if (h2.cmpn(0) === 0) {
      if (r2.cmpn(0) !== 0)
        return this.curve.jpoint(null, null, null);
      else
        return this.dbl();
    }
    var h22 = h2.redSqr();
    var h3 = h22.redMul(h2);
    var v2 = u1.redMul(h22);
    var nx = r2.redSqr().redIAdd(h3).redISub(v2).redISub(v2);
    var ny = r2.redMul(v2.redISub(nx)).redISub(s1.redMul(h3));
    var nz = this.z.redMul(p2.z).redMul(h2);
    return this.curve.jpoint(nx, ny, nz);
  };
  JPoint.prototype.mixedAdd = function mixedAdd(p2) {
    if (this.isInfinity())
      return p2.toJ();
    if (p2.isInfinity())
      return this;
    var z2 = this.z.redSqr();
    var u1 = this.x;
    var u2 = p2.x.redMul(z2);
    var s1 = this.y;
    var s2 = p2.y.redMul(z2).redMul(this.z);
    var h2 = u1.redSub(u2);
    var r2 = s1.redSub(s2);
    if (h2.cmpn(0) === 0) {
      if (r2.cmpn(0) !== 0)
        return this.curve.jpoint(null, null, null);
      else
        return this.dbl();
    }
    var h22 = h2.redSqr();
    var h3 = h22.redMul(h2);
    var v2 = u1.redMul(h22);
    var nx = r2.redSqr().redIAdd(h3).redISub(v2).redISub(v2);
    var ny = r2.redMul(v2.redISub(nx)).redISub(s1.redMul(h3));
    var nz = this.z.redMul(h2);
    return this.curve.jpoint(nx, ny, nz);
  };
  JPoint.prototype.dblp = function dblp(pow2) {
    if (pow2 === 0)
      return this;
    if (this.isInfinity())
      return this;
    if (!pow2)
      return this.dbl();
    var i2;
    if (this.curve.zeroA || this.curve.threeA) {
      var r2 = this;
      for (i2 = 0; i2 < pow2; i2++)
        r2 = r2.dbl();
      return r2;
    }
    var a2 = this.curve.a;
    var tinv = this.curve.tinv;
    var jx = this.x;
    var jy = this.y;
    var jz = this.z;
    var jz4 = jz.redSqr().redSqr();
    var jyd = jy.redAdd(jy);
    for (i2 = 0; i2 < pow2; i2++) {
      var jx2 = jx.redSqr();
      var jyd2 = jyd.redSqr();
      var jyd4 = jyd2.redSqr();
      var c2 = jx2.redAdd(jx2).redIAdd(jx2).redIAdd(a2.redMul(jz4));
      var t1 = jx.redMul(jyd2);
      var nx = c2.redSqr().redISub(t1.redAdd(t1));
      var t2 = t1.redISub(nx);
      var dny = c2.redMul(t2);
      dny = dny.redIAdd(dny).redISub(jyd4);
      var nz = jyd.redMul(jz);
      if (i2 + 1 < pow2)
        jz4 = jz4.redMul(jyd4);
      jx = nx;
      jz = nz;
      jyd = dny;
    }
    return this.curve.jpoint(jx, jyd.redMul(tinv), jz);
  };
  JPoint.prototype.dbl = function dbl() {
    if (this.isInfinity())
      return this;
    if (this.curve.zeroA)
      return this._zeroDbl();
    else if (this.curve.threeA)
      return this._threeDbl();
    else
      return this._dbl();
  };
  JPoint.prototype._zeroDbl = function _zeroDbl() {
    var nx;
    var ny;
    var nz;
    if (this.zOne) {
      var xx = this.x.redSqr();
      var yy = this.y.redSqr();
      var yyyy = yy.redSqr();
      var s2 = this.x.redAdd(yy).redSqr().redISub(xx).redISub(yyyy);
      s2 = s2.redIAdd(s2);
      var m = xx.redAdd(xx).redIAdd(xx);
      var t2 = m.redSqr().redISub(s2).redISub(s2);
      var yyyy8 = yyyy.redIAdd(yyyy);
      yyyy8 = yyyy8.redIAdd(yyyy8);
      yyyy8 = yyyy8.redIAdd(yyyy8);
      nx = t2;
      ny = m.redMul(s2.redISub(t2)).redISub(yyyy8);
      nz = this.y.redAdd(this.y);
    } else {
      var a2 = this.x.redSqr();
      var b2 = this.y.redSqr();
      var c2 = b2.redSqr();
      var d = this.x.redAdd(b2).redSqr().redISub(a2).redISub(c2);
      d = d.redIAdd(d);
      var e4 = a2.redAdd(a2).redIAdd(a2);
      var f2 = e4.redSqr();
      var c8 = c2.redIAdd(c2);
      c8 = c8.redIAdd(c8);
      c8 = c8.redIAdd(c8);
      nx = f2.redISub(d).redISub(d);
      ny = e4.redMul(d.redISub(nx)).redISub(c8);
      nz = this.y.redMul(this.z);
      nz = nz.redIAdd(nz);
    }
    return this.curve.jpoint(nx, ny, nz);
  };
  JPoint.prototype._threeDbl = function _threeDbl() {
    var nx;
    var ny;
    var nz;
    if (this.zOne) {
      var xx = this.x.redSqr();
      var yy = this.y.redSqr();
      var yyyy = yy.redSqr();
      var s2 = this.x.redAdd(yy).redSqr().redISub(xx).redISub(yyyy);
      s2 = s2.redIAdd(s2);
      var m = xx.redAdd(xx).redIAdd(xx).redIAdd(this.curve.a);
      var t2 = m.redSqr().redISub(s2).redISub(s2);
      nx = t2;
      var yyyy8 = yyyy.redIAdd(yyyy);
      yyyy8 = yyyy8.redIAdd(yyyy8);
      yyyy8 = yyyy8.redIAdd(yyyy8);
      ny = m.redMul(s2.redISub(t2)).redISub(yyyy8);
      nz = this.y.redAdd(this.y);
    } else {
      var delta = this.z.redSqr();
      var gamma = this.y.redSqr();
      var beta = this.x.redMul(gamma);
      var alpha = this.x.redSub(delta).redMul(this.x.redAdd(delta));
      alpha = alpha.redAdd(alpha).redIAdd(alpha);
      var beta4 = beta.redIAdd(beta);
      beta4 = beta4.redIAdd(beta4);
      var beta8 = beta4.redAdd(beta4);
      nx = alpha.redSqr().redISub(beta8);
      nz = this.y.redAdd(this.z).redSqr().redISub(gamma).redISub(delta);
      var ggamma8 = gamma.redSqr();
      ggamma8 = ggamma8.redIAdd(ggamma8);
      ggamma8 = ggamma8.redIAdd(ggamma8);
      ggamma8 = ggamma8.redIAdd(ggamma8);
      ny = alpha.redMul(beta4.redISub(nx)).redISub(ggamma8);
    }
    return this.curve.jpoint(nx, ny, nz);
  };
  JPoint.prototype._dbl = function _dbl() {
    var a2 = this.curve.a;
    var jx = this.x;
    var jy = this.y;
    var jz = this.z;
    var jz4 = jz.redSqr().redSqr();
    var jx2 = jx.redSqr();
    var jy2 = jy.redSqr();
    var c2 = jx2.redAdd(jx2).redIAdd(jx2).redIAdd(a2.redMul(jz4));
    var jxd4 = jx.redAdd(jx);
    jxd4 = jxd4.redIAdd(jxd4);
    var t1 = jxd4.redMul(jy2);
    var nx = c2.redSqr().redISub(t1.redAdd(t1));
    var t2 = t1.redISub(nx);
    var jyd8 = jy2.redSqr();
    jyd8 = jyd8.redIAdd(jyd8);
    jyd8 = jyd8.redIAdd(jyd8);
    jyd8 = jyd8.redIAdd(jyd8);
    var ny = c2.redMul(t2).redISub(jyd8);
    var nz = jy.redAdd(jy).redMul(jz);
    return this.curve.jpoint(nx, ny, nz);
  };
  JPoint.prototype.trpl = function trpl() {
    if (!this.curve.zeroA)
      return this.dbl().add(this);
    var xx = this.x.redSqr();
    var yy = this.y.redSqr();
    var zz = this.z.redSqr();
    var yyyy = yy.redSqr();
    var m = xx.redAdd(xx).redIAdd(xx);
    var mm = m.redSqr();
    var e4 = this.x.redAdd(yy).redSqr().redISub(xx).redISub(yyyy);
    e4 = e4.redIAdd(e4);
    e4 = e4.redAdd(e4).redIAdd(e4);
    e4 = e4.redISub(mm);
    var ee = e4.redSqr();
    var t2 = yyyy.redIAdd(yyyy);
    t2 = t2.redIAdd(t2);
    t2 = t2.redIAdd(t2);
    t2 = t2.redIAdd(t2);
    var u2 = m.redIAdd(e4).redSqr().redISub(mm).redISub(ee).redISub(t2);
    var yyu4 = yy.redMul(u2);
    yyu4 = yyu4.redIAdd(yyu4);
    yyu4 = yyu4.redIAdd(yyu4);
    var nx = this.x.redMul(ee).redISub(yyu4);
    nx = nx.redIAdd(nx);
    nx = nx.redIAdd(nx);
    var ny = this.y.redMul(u2.redMul(t2.redISub(u2)).redISub(e4.redMul(ee)));
    ny = ny.redIAdd(ny);
    ny = ny.redIAdd(ny);
    ny = ny.redIAdd(ny);
    var nz = this.z.redAdd(e4).redSqr().redISub(zz).redISub(ee);
    return this.curve.jpoint(nx, ny, nz);
  };
  JPoint.prototype.mul = function mul(k2, kbase) {
    k2 = new BN(k2, kbase);
    return this.curve._wnafMul(this, k2);
  };
  JPoint.prototype.eq = function eq(p2) {
    if (p2.type === "affine")
      return this.eq(p2.toJ());
    if (this === p2)
      return true;
    var z2 = this.z.redSqr();
    var pz2 = p2.z.redSqr();
    if (this.x.redMul(pz2).redISub(p2.x.redMul(z2)).cmpn(0) !== 0)
      return false;
    var z3 = z2.redMul(this.z);
    var pz3 = pz2.redMul(p2.z);
    return this.y.redMul(pz3).redISub(p2.y.redMul(z3)).cmpn(0) === 0;
  };
  JPoint.prototype.eqXToP = function eqXToP(x2) {
    var zs = this.z.redSqr();
    var rx = x2.toRed(this.curve.red).redMul(zs);
    if (this.x.cmp(rx) === 0)
      return true;
    var xc = x2.clone();
    var t2 = this.curve.redN.redMul(zs);
    for (; ; ) {
      xc.iadd(this.curve.n);
      if (xc.cmp(this.curve.p) >= 0)
        return false;
      rx.redIAdd(t2);
      if (this.x.cmp(rx) === 0)
        return true;
    }
  };
  JPoint.prototype.inspect = function inspect() {
    if (this.isInfinity())
      return "<EC JPoint Infinity>";
    return "<EC JPoint x: " + this.x.toString(16, 2) + " y: " + this.y.toString(16, 2) + " z: " + this.z.toString(16, 2) + ">";
  };
  JPoint.prototype.isInfinity = function isInfinity() {
    return this.z.cmpn(0) === 0;
  };
  return short;
}
var mont;
var hasRequiredMont;
function requireMont() {
  if (hasRequiredMont) return mont;
  hasRequiredMont = 1;
  var BN = requireBn$1();
  var inherits = requireInherits_browser();
  var Base = requireBase$1();
  var utils2 = requireUtils$2();
  function MontCurve(conf) {
    Base.call(this, "mont", conf);
    this.a = new BN(conf.a, 16).toRed(this.red);
    this.b = new BN(conf.b, 16).toRed(this.red);
    this.i4 = new BN(4).toRed(this.red).redInvm();
    this.two = new BN(2).toRed(this.red);
    this.a24 = this.i4.redMul(this.a.redAdd(this.two));
  }
  inherits(MontCurve, Base);
  mont = MontCurve;
  MontCurve.prototype.validate = function validate2(point) {
    var x2 = point.normalize().x;
    var x22 = x2.redSqr();
    var rhs = x22.redMul(x2).redAdd(x22.redMul(this.a)).redAdd(x2);
    var y2 = rhs.redSqrt();
    return y2.redSqr().cmp(rhs) === 0;
  };
  function Point2(curve2, x2, z2) {
    Base.BasePoint.call(this, curve2, "projective");
    if (x2 === null && z2 === null) {
      this.x = this.curve.one;
      this.z = this.curve.zero;
    } else {
      this.x = new BN(x2, 16);
      this.z = new BN(z2, 16);
      if (!this.x.red)
        this.x = this.x.toRed(this.curve.red);
      if (!this.z.red)
        this.z = this.z.toRed(this.curve.red);
    }
  }
  inherits(Point2, Base.BasePoint);
  MontCurve.prototype.decodePoint = function decodePoint(bytes, enc) {
    return this.point(utils2.toArray(bytes, enc), 1);
  };
  MontCurve.prototype.point = function point(x2, z2) {
    return new Point2(this, x2, z2);
  };
  MontCurve.prototype.pointFromJSON = function pointFromJSON(obj) {
    return Point2.fromJSON(this, obj);
  };
  Point2.prototype.precompute = function precompute() {
  };
  Point2.prototype._encode = function _encode() {
    return this.getX().toArray("be", this.curve.p.byteLength());
  };
  Point2.fromJSON = function fromJSON(curve2, obj) {
    return new Point2(curve2, obj[0], obj[1] || curve2.one);
  };
  Point2.prototype.inspect = function inspect() {
    if (this.isInfinity())
      return "<EC Point Infinity>";
    return "<EC Point x: " + this.x.fromRed().toString(16, 2) + " z: " + this.z.fromRed().toString(16, 2) + ">";
  };
  Point2.prototype.isInfinity = function isInfinity() {
    return this.z.cmpn(0) === 0;
  };
  Point2.prototype.dbl = function dbl() {
    var a2 = this.x.redAdd(this.z);
    var aa = a2.redSqr();
    var b2 = this.x.redSub(this.z);
    var bb = b2.redSqr();
    var c2 = aa.redSub(bb);
    var nx = aa.redMul(bb);
    var nz = c2.redMul(bb.redAdd(this.curve.a24.redMul(c2)));
    return this.curve.point(nx, nz);
  };
  Point2.prototype.add = function add2() {
    throw new Error("Not supported on Montgomery curve");
  };
  Point2.prototype.diffAdd = function diffAdd(p2, diff) {
    var a2 = this.x.redAdd(this.z);
    var b2 = this.x.redSub(this.z);
    var c2 = p2.x.redAdd(p2.z);
    var d = p2.x.redSub(p2.z);
    var da = d.redMul(a2);
    var cb = c2.redMul(b2);
    var nx = diff.z.redMul(da.redAdd(cb).redSqr());
    var nz = diff.x.redMul(da.redISub(cb).redSqr());
    return this.curve.point(nx, nz);
  };
  Point2.prototype.mul = function mul(k2) {
    var t2 = k2.clone();
    var a2 = this;
    var b2 = this.curve.point(null, null);
    var c2 = this;
    for (var bits = []; t2.cmpn(0) !== 0; t2.iushrn(1))
      bits.push(t2.andln(1));
    for (var i2 = bits.length - 1; i2 >= 0; i2--) {
      if (bits[i2] === 0) {
        a2 = a2.diffAdd(b2, c2);
        b2 = b2.dbl();
      } else {
        b2 = a2.diffAdd(b2, c2);
        a2 = a2.dbl();
      }
    }
    return b2;
  };
  Point2.prototype.mulAdd = function mulAdd() {
    throw new Error("Not supported on Montgomery curve");
  };
  Point2.prototype.jumlAdd = function jumlAdd() {
    throw new Error("Not supported on Montgomery curve");
  };
  Point2.prototype.eq = function eq(other) {
    return this.getX().cmp(other.getX()) === 0;
  };
  Point2.prototype.normalize = function normalize() {
    this.x = this.x.redMul(this.z.redInvm());
    this.z = this.curve.one;
    return this;
  };
  Point2.prototype.getX = function getX() {
    this.normalize();
    return this.x.fromRed();
  };
  return mont;
}
var edwards;
var hasRequiredEdwards;
function requireEdwards() {
  if (hasRequiredEdwards) return edwards;
  hasRequiredEdwards = 1;
  var utils2 = requireUtils$2();
  var BN = requireBn$1();
  var inherits = requireInherits_browser();
  var Base = requireBase$1();
  var assert = utils2.assert;
  function EdwardsCurve(conf) {
    this.twisted = (conf.a | 0) !== 1;
    this.mOneA = this.twisted && (conf.a | 0) === -1;
    this.extended = this.mOneA;
    Base.call(this, "edwards", conf);
    this.a = new BN(conf.a, 16).umod(this.red.m);
    this.a = this.a.toRed(this.red);
    this.c = new BN(conf.c, 16).toRed(this.red);
    this.c2 = this.c.redSqr();
    this.d = new BN(conf.d, 16).toRed(this.red);
    this.dd = this.d.redAdd(this.d);
    assert(!this.twisted || this.c.fromRed().cmpn(1) === 0);
    this.oneC = (conf.c | 0) === 1;
  }
  inherits(EdwardsCurve, Base);
  edwards = EdwardsCurve;
  EdwardsCurve.prototype._mulA = function _mulA(num) {
    if (this.mOneA)
      return num.redNeg();
    else
      return this.a.redMul(num);
  };
  EdwardsCurve.prototype._mulC = function _mulC(num) {
    if (this.oneC)
      return num;
    else
      return this.c.redMul(num);
  };
  EdwardsCurve.prototype.jpoint = function jpoint(x2, y2, z2, t2) {
    return this.point(x2, y2, z2, t2);
  };
  EdwardsCurve.prototype.pointFromX = function pointFromX(x2, odd) {
    x2 = new BN(x2, 16);
    if (!x2.red)
      x2 = x2.toRed(this.red);
    var x22 = x2.redSqr();
    var rhs = this.c2.redSub(this.a.redMul(x22));
    var lhs = this.one.redSub(this.c2.redMul(this.d).redMul(x22));
    var y2 = rhs.redMul(lhs.redInvm());
    var y3 = y2.redSqrt();
    if (y3.redSqr().redSub(y2).cmp(this.zero) !== 0)
      throw new Error("invalid point");
    var isOdd = y3.fromRed().isOdd();
    if (odd && !isOdd || !odd && isOdd)
      y3 = y3.redNeg();
    return this.point(x2, y3);
  };
  EdwardsCurve.prototype.pointFromY = function pointFromY(y2, odd) {
    y2 = new BN(y2, 16);
    if (!y2.red)
      y2 = y2.toRed(this.red);
    var y22 = y2.redSqr();
    var lhs = y22.redSub(this.c2);
    var rhs = y22.redMul(this.d).redMul(this.c2).redSub(this.a);
    var x2 = lhs.redMul(rhs.redInvm());
    if (x2.cmp(this.zero) === 0) {
      if (odd)
        throw new Error("invalid point");
      else
        return this.point(this.zero, y2);
    }
    var x3 = x2.redSqrt();
    if (x3.redSqr().redSub(x2).cmp(this.zero) !== 0)
      throw new Error("invalid point");
    if (x3.fromRed().isOdd() !== odd)
      x3 = x3.redNeg();
    return this.point(x3, y2);
  };
  EdwardsCurve.prototype.validate = function validate2(point) {
    if (point.isInfinity())
      return true;
    point.normalize();
    var x2 = point.x.redSqr();
    var y2 = point.y.redSqr();
    var lhs = x2.redMul(this.a).redAdd(y2);
    var rhs = this.c2.redMul(this.one.redAdd(this.d.redMul(x2).redMul(y2)));
    return lhs.cmp(rhs) === 0;
  };
  function Point2(curve2, x2, y2, z2, t2) {
    Base.BasePoint.call(this, curve2, "projective");
    if (x2 === null && y2 === null && z2 === null) {
      this.x = this.curve.zero;
      this.y = this.curve.one;
      this.z = this.curve.one;
      this.t = this.curve.zero;
      this.zOne = true;
    } else {
      this.x = new BN(x2, 16);
      this.y = new BN(y2, 16);
      this.z = z2 ? new BN(z2, 16) : this.curve.one;
      this.t = t2 && new BN(t2, 16);
      if (!this.x.red)
        this.x = this.x.toRed(this.curve.red);
      if (!this.y.red)
        this.y = this.y.toRed(this.curve.red);
      if (!this.z.red)
        this.z = this.z.toRed(this.curve.red);
      if (this.t && !this.t.red)
        this.t = this.t.toRed(this.curve.red);
      this.zOne = this.z === this.curve.one;
      if (this.curve.extended && !this.t) {
        this.t = this.x.redMul(this.y);
        if (!this.zOne)
          this.t = this.t.redMul(this.z.redInvm());
      }
    }
  }
  inherits(Point2, Base.BasePoint);
  EdwardsCurve.prototype.pointFromJSON = function pointFromJSON(obj) {
    return Point2.fromJSON(this, obj);
  };
  EdwardsCurve.prototype.point = function point(x2, y2, z2, t2) {
    return new Point2(this, x2, y2, z2, t2);
  };
  Point2.fromJSON = function fromJSON(curve2, obj) {
    return new Point2(curve2, obj[0], obj[1], obj[2]);
  };
  Point2.prototype.inspect = function inspect() {
    if (this.isInfinity())
      return "<EC Point Infinity>";
    return "<EC Point x: " + this.x.fromRed().toString(16, 2) + " y: " + this.y.fromRed().toString(16, 2) + " z: " + this.z.fromRed().toString(16, 2) + ">";
  };
  Point2.prototype.isInfinity = function isInfinity() {
    return this.x.cmpn(0) === 0 && (this.y.cmp(this.z) === 0 || this.zOne && this.y.cmp(this.curve.c) === 0);
  };
  Point2.prototype._extDbl = function _extDbl() {
    var a2 = this.x.redSqr();
    var b2 = this.y.redSqr();
    var c2 = this.z.redSqr();
    c2 = c2.redIAdd(c2);
    var d = this.curve._mulA(a2);
    var e4 = this.x.redAdd(this.y).redSqr().redISub(a2).redISub(b2);
    var g = d.redAdd(b2);
    var f2 = g.redSub(c2);
    var h2 = d.redSub(b2);
    var nx = e4.redMul(f2);
    var ny = g.redMul(h2);
    var nt = e4.redMul(h2);
    var nz = f2.redMul(g);
    return this.curve.point(nx, ny, nz, nt);
  };
  Point2.prototype._projDbl = function _projDbl() {
    var b2 = this.x.redAdd(this.y).redSqr();
    var c2 = this.x.redSqr();
    var d = this.y.redSqr();
    var nx;
    var ny;
    var nz;
    var e4;
    var h2;
    var j;
    if (this.curve.twisted) {
      e4 = this.curve._mulA(c2);
      var f2 = e4.redAdd(d);
      if (this.zOne) {
        nx = b2.redSub(c2).redSub(d).redMul(f2.redSub(this.curve.two));
        ny = f2.redMul(e4.redSub(d));
        nz = f2.redSqr().redSub(f2).redSub(f2);
      } else {
        h2 = this.z.redSqr();
        j = f2.redSub(h2).redISub(h2);
        nx = b2.redSub(c2).redISub(d).redMul(j);
        ny = f2.redMul(e4.redSub(d));
        nz = f2.redMul(j);
      }
    } else {
      e4 = c2.redAdd(d);
      h2 = this.curve._mulC(this.z).redSqr();
      j = e4.redSub(h2).redSub(h2);
      nx = this.curve._mulC(b2.redISub(e4)).redMul(j);
      ny = this.curve._mulC(e4).redMul(c2.redISub(d));
      nz = e4.redMul(j);
    }
    return this.curve.point(nx, ny, nz);
  };
  Point2.prototype.dbl = function dbl() {
    if (this.isInfinity())
      return this;
    if (this.curve.extended)
      return this._extDbl();
    else
      return this._projDbl();
  };
  Point2.prototype._extAdd = function _extAdd(p2) {
    var a2 = this.y.redSub(this.x).redMul(p2.y.redSub(p2.x));
    var b2 = this.y.redAdd(this.x).redMul(p2.y.redAdd(p2.x));
    var c2 = this.t.redMul(this.curve.dd).redMul(p2.t);
    var d = this.z.redMul(p2.z.redAdd(p2.z));
    var e4 = b2.redSub(a2);
    var f2 = d.redSub(c2);
    var g = d.redAdd(c2);
    var h2 = b2.redAdd(a2);
    var nx = e4.redMul(f2);
    var ny = g.redMul(h2);
    var nt = e4.redMul(h2);
    var nz = f2.redMul(g);
    return this.curve.point(nx, ny, nz, nt);
  };
  Point2.prototype._projAdd = function _projAdd(p2) {
    var a2 = this.z.redMul(p2.z);
    var b2 = a2.redSqr();
    var c2 = this.x.redMul(p2.x);
    var d = this.y.redMul(p2.y);
    var e4 = this.curve.d.redMul(c2).redMul(d);
    var f2 = b2.redSub(e4);
    var g = b2.redAdd(e4);
    var tmp = this.x.redAdd(this.y).redMul(p2.x.redAdd(p2.y)).redISub(c2).redISub(d);
    var nx = a2.redMul(f2).redMul(tmp);
    var ny;
    var nz;
    if (this.curve.twisted) {
      ny = a2.redMul(g).redMul(d.redSub(this.curve._mulA(c2)));
      nz = f2.redMul(g);
    } else {
      ny = a2.redMul(g).redMul(d.redSub(c2));
      nz = this.curve._mulC(f2).redMul(g);
    }
    return this.curve.point(nx, ny, nz);
  };
  Point2.prototype.add = function add2(p2) {
    if (this.isInfinity())
      return p2;
    if (p2.isInfinity())
      return this;
    if (this.curve.extended)
      return this._extAdd(p2);
    else
      return this._projAdd(p2);
  };
  Point2.prototype.mul = function mul(k2) {
    if (this._hasDoubles(k2))
      return this.curve._fixedNafMul(this, k2);
    else
      return this.curve._wnafMul(this, k2);
  };
  Point2.prototype.mulAdd = function mulAdd(k1, p2, k2) {
    return this.curve._wnafMulAdd(1, [this, p2], [k1, k2], 2, false);
  };
  Point2.prototype.jmulAdd = function jmulAdd(k1, p2, k2) {
    return this.curve._wnafMulAdd(1, [this, p2], [k1, k2], 2, true);
  };
  Point2.prototype.normalize = function normalize() {
    if (this.zOne)
      return this;
    var zi = this.z.redInvm();
    this.x = this.x.redMul(zi);
    this.y = this.y.redMul(zi);
    if (this.t)
      this.t = this.t.redMul(zi);
    this.z = this.curve.one;
    this.zOne = true;
    return this;
  };
  Point2.prototype.neg = function neg() {
    return this.curve.point(
      this.x.redNeg(),
      this.y,
      this.z,
      this.t && this.t.redNeg()
    );
  };
  Point2.prototype.getX = function getX() {
    this.normalize();
    return this.x.fromRed();
  };
  Point2.prototype.getY = function getY() {
    this.normalize();
    return this.y.fromRed();
  };
  Point2.prototype.eq = function eq(other) {
    return this === other || this.getX().cmp(other.getX()) === 0 && this.getY().cmp(other.getY()) === 0;
  };
  Point2.prototype.eqXToP = function eqXToP(x2) {
    var rx = x2.toRed(this.curve.red).redMul(this.z);
    if (this.x.cmp(rx) === 0)
      return true;
    var xc = x2.clone();
    var t2 = this.curve.redN.redMul(this.z);
    for (; ; ) {
      xc.iadd(this.curve.n);
      if (xc.cmp(this.curve.p) >= 0)
        return false;
      rx.redIAdd(t2);
      if (this.x.cmp(rx) === 0)
        return true;
    }
  };
  Point2.prototype.toP = Point2.prototype.normalize;
  Point2.prototype.mixedAdd = Point2.prototype.add;
  return edwards;
}
var hasRequiredCurve;
function requireCurve() {
  if (hasRequiredCurve) return curve$1;
  hasRequiredCurve = 1;
  (function(exports) {
    var curve2 = exports;
    curve2.base = requireBase$1();
    curve2.short = requireShort();
    curve2.mont = requireMont();
    curve2.edwards = requireEdwards();
  })(curve$1);
  return curve$1;
}
var curves = {};
var hash = {};
var utils$1 = {};
var hasRequiredUtils$1;
function requireUtils$1() {
  if (hasRequiredUtils$1) return utils$1;
  hasRequiredUtils$1 = 1;
  var assert = requireMinimalisticAssert();
  var inherits = requireInherits_browser();
  utils$1.inherits = inherits;
  function isSurrogatePair(msg, i2) {
    if ((msg.charCodeAt(i2) & 64512) !== 55296) {
      return false;
    }
    if (i2 < 0 || i2 + 1 >= msg.length) {
      return false;
    }
    return (msg.charCodeAt(i2 + 1) & 64512) === 56320;
  }
  function toArray(msg, enc) {
    if (Array.isArray(msg))
      return msg.slice();
    if (!msg)
      return [];
    var res = [];
    if (typeof msg === "string") {
      if (!enc) {
        var p2 = 0;
        for (var i2 = 0; i2 < msg.length; i2++) {
          var c2 = msg.charCodeAt(i2);
          if (c2 < 128) {
            res[p2++] = c2;
          } else if (c2 < 2048) {
            res[p2++] = c2 >> 6 | 192;
            res[p2++] = c2 & 63 | 128;
          } else if (isSurrogatePair(msg, i2)) {
            c2 = 65536 + ((c2 & 1023) << 10) + (msg.charCodeAt(++i2) & 1023);
            res[p2++] = c2 >> 18 | 240;
            res[p2++] = c2 >> 12 & 63 | 128;
            res[p2++] = c2 >> 6 & 63 | 128;
            res[p2++] = c2 & 63 | 128;
          } else {
            res[p2++] = c2 >> 12 | 224;
            res[p2++] = c2 >> 6 & 63 | 128;
            res[p2++] = c2 & 63 | 128;
          }
        }
      } else if (enc === "hex") {
        msg = msg.replace(/[^a-z0-9]+/ig, "");
        if (msg.length % 2 !== 0)
          msg = "0" + msg;
        for (i2 = 0; i2 < msg.length; i2 += 2)
          res.push(parseInt(msg[i2] + msg[i2 + 1], 16));
      }
    } else {
      for (i2 = 0; i2 < msg.length; i2++)
        res[i2] = msg[i2] | 0;
    }
    return res;
  }
  utils$1.toArray = toArray;
  function toHex2(msg) {
    var res = "";
    for (var i2 = 0; i2 < msg.length; i2++)
      res += zero2(msg[i2].toString(16));
    return res;
  }
  utils$1.toHex = toHex2;
  function htonl(w) {
    var res = w >>> 24 | w >>> 8 & 65280 | w << 8 & 16711680 | (w & 255) << 24;
    return res >>> 0;
  }
  utils$1.htonl = htonl;
  function toHex32(msg, endian) {
    var res = "";
    for (var i2 = 0; i2 < msg.length; i2++) {
      var w = msg[i2];
      if (endian === "little")
        w = htonl(w);
      res += zero8(w.toString(16));
    }
    return res;
  }
  utils$1.toHex32 = toHex32;
  function zero2(word) {
    if (word.length === 1)
      return "0" + word;
    else
      return word;
  }
  utils$1.zero2 = zero2;
  function zero8(word) {
    if (word.length === 7)
      return "0" + word;
    else if (word.length === 6)
      return "00" + word;
    else if (word.length === 5)
      return "000" + word;
    else if (word.length === 4)
      return "0000" + word;
    else if (word.length === 3)
      return "00000" + word;
    else if (word.length === 2)
      return "000000" + word;
    else if (word.length === 1)
      return "0000000" + word;
    else
      return word;
  }
  utils$1.zero8 = zero8;
  function join32(msg, start, end, endian) {
    var len = end - start;
    assert(len % 4 === 0);
    var res = new Array(len / 4);
    for (var i2 = 0, k2 = start; i2 < res.length; i2++, k2 += 4) {
      var w;
      if (endian === "big")
        w = msg[k2] << 24 | msg[k2 + 1] << 16 | msg[k2 + 2] << 8 | msg[k2 + 3];
      else
        w = msg[k2 + 3] << 24 | msg[k2 + 2] << 16 | msg[k2 + 1] << 8 | msg[k2];
      res[i2] = w >>> 0;
    }
    return res;
  }
  utils$1.join32 = join32;
  function split32(msg, endian) {
    var res = new Array(msg.length * 4);
    for (var i2 = 0, k2 = 0; i2 < msg.length; i2++, k2 += 4) {
      var m = msg[i2];
      if (endian === "big") {
        res[k2] = m >>> 24;
        res[k2 + 1] = m >>> 16 & 255;
        res[k2 + 2] = m >>> 8 & 255;
        res[k2 + 3] = m & 255;
      } else {
        res[k2 + 3] = m >>> 24;
        res[k2 + 2] = m >>> 16 & 255;
        res[k2 + 1] = m >>> 8 & 255;
        res[k2] = m & 255;
      }
    }
    return res;
  }
  utils$1.split32 = split32;
  function rotr32(w, b2) {
    return w >>> b2 | w << 32 - b2;
  }
  utils$1.rotr32 = rotr32;
  function rotl32(w, b2) {
    return w << b2 | w >>> 32 - b2;
  }
  utils$1.rotl32 = rotl32;
  function sum32(a2, b2) {
    return a2 + b2 >>> 0;
  }
  utils$1.sum32 = sum32;
  function sum32_3(a2, b2, c2) {
    return a2 + b2 + c2 >>> 0;
  }
  utils$1.sum32_3 = sum32_3;
  function sum32_4(a2, b2, c2, d) {
    return a2 + b2 + c2 + d >>> 0;
  }
  utils$1.sum32_4 = sum32_4;
  function sum32_5(a2, b2, c2, d, e4) {
    return a2 + b2 + c2 + d + e4 >>> 0;
  }
  utils$1.sum32_5 = sum32_5;
  function sum64(buf, pos, ah, al) {
    var bh = buf[pos];
    var bl = buf[pos + 1];
    var lo = al + bl >>> 0;
    var hi = (lo < al ? 1 : 0) + ah + bh;
    buf[pos] = hi >>> 0;
    buf[pos + 1] = lo;
  }
  utils$1.sum64 = sum64;
  function sum64_hi(ah, al, bh, bl) {
    var lo = al + bl >>> 0;
    var hi = (lo < al ? 1 : 0) + ah + bh;
    return hi >>> 0;
  }
  utils$1.sum64_hi = sum64_hi;
  function sum64_lo(ah, al, bh, bl) {
    var lo = al + bl;
    return lo >>> 0;
  }
  utils$1.sum64_lo = sum64_lo;
  function sum64_4_hi(ah, al, bh, bl, ch, cl, dh2, dl) {
    var carry = 0;
    var lo = al;
    lo = lo + bl >>> 0;
    carry += lo < al ? 1 : 0;
    lo = lo + cl >>> 0;
    carry += lo < cl ? 1 : 0;
    lo = lo + dl >>> 0;
    carry += lo < dl ? 1 : 0;
    var hi = ah + bh + ch + dh2 + carry;
    return hi >>> 0;
  }
  utils$1.sum64_4_hi = sum64_4_hi;
  function sum64_4_lo(ah, al, bh, bl, ch, cl, dh2, dl) {
    var lo = al + bl + cl + dl;
    return lo >>> 0;
  }
  utils$1.sum64_4_lo = sum64_4_lo;
  function sum64_5_hi(ah, al, bh, bl, ch, cl, dh2, dl, eh, el) {
    var carry = 0;
    var lo = al;
    lo = lo + bl >>> 0;
    carry += lo < al ? 1 : 0;
    lo = lo + cl >>> 0;
    carry += lo < cl ? 1 : 0;
    lo = lo + dl >>> 0;
    carry += lo < dl ? 1 : 0;
    lo = lo + el >>> 0;
    carry += lo < el ? 1 : 0;
    var hi = ah + bh + ch + dh2 + eh + carry;
    return hi >>> 0;
  }
  utils$1.sum64_5_hi = sum64_5_hi;
  function sum64_5_lo(ah, al, bh, bl, ch, cl, dh2, dl, eh, el) {
    var lo = al + bl + cl + dl + el;
    return lo >>> 0;
  }
  utils$1.sum64_5_lo = sum64_5_lo;
  function rotr64_hi(ah, al, num) {
    var r2 = al << 32 - num | ah >>> num;
    return r2 >>> 0;
  }
  utils$1.rotr64_hi = rotr64_hi;
  function rotr64_lo(ah, al, num) {
    var r2 = ah << 32 - num | al >>> num;
    return r2 >>> 0;
  }
  utils$1.rotr64_lo = rotr64_lo;
  function shr64_hi(ah, al, num) {
    return ah >>> num;
  }
  utils$1.shr64_hi = shr64_hi;
  function shr64_lo(ah, al, num) {
    var r2 = ah << 32 - num | al >>> num;
    return r2 >>> 0;
  }
  utils$1.shr64_lo = shr64_lo;
  return utils$1;
}
var common$3 = {};
var hasRequiredCommon$3;
function requireCommon$3() {
  if (hasRequiredCommon$3) return common$3;
  hasRequiredCommon$3 = 1;
  var utils2 = requireUtils$1();
  var assert = requireMinimalisticAssert();
  function BlockHash() {
    this.pending = null;
    this.pendingTotal = 0;
    this.blockSize = this.constructor.blockSize;
    this.outSize = this.constructor.outSize;
    this.hmacStrength = this.constructor.hmacStrength;
    this.padLength = this.constructor.padLength / 8;
    this.endian = "big";
    this._delta8 = this.blockSize / 8;
    this._delta32 = this.blockSize / 32;
  }
  common$3.BlockHash = BlockHash;
  BlockHash.prototype.update = function update(msg, enc) {
    msg = utils2.toArray(msg, enc);
    if (!this.pending)
      this.pending = msg;
    else
      this.pending = this.pending.concat(msg);
    this.pendingTotal += msg.length;
    if (this.pending.length >= this._delta8) {
      msg = this.pending;
      var r2 = msg.length % this._delta8;
      this.pending = msg.slice(msg.length - r2, msg.length);
      if (this.pending.length === 0)
        this.pending = null;
      msg = utils2.join32(msg, 0, msg.length - r2, this.endian);
      for (var i2 = 0; i2 < msg.length; i2 += this._delta32)
        this._update(msg, i2, i2 + this._delta32);
    }
    return this;
  };
  BlockHash.prototype.digest = function digest(enc) {
    this.update(this._pad());
    assert(this.pending === null);
    return this._digest(enc);
  };
  BlockHash.prototype._pad = function pad() {
    var len = this.pendingTotal;
    var bytes = this._delta8;
    var k2 = bytes - (len + this.padLength) % bytes;
    var res = new Array(k2 + this.padLength);
    res[0] = 128;
    for (var i2 = 1; i2 < k2; i2++)
      res[i2] = 0;
    len <<= 3;
    if (this.endian === "big") {
      for (var t2 = 8; t2 < this.padLength; t2++)
        res[i2++] = 0;
      res[i2++] = 0;
      res[i2++] = 0;
      res[i2++] = 0;
      res[i2++] = 0;
      res[i2++] = len >>> 24 & 255;
      res[i2++] = len >>> 16 & 255;
      res[i2++] = len >>> 8 & 255;
      res[i2++] = len & 255;
    } else {
      res[i2++] = len & 255;
      res[i2++] = len >>> 8 & 255;
      res[i2++] = len >>> 16 & 255;
      res[i2++] = len >>> 24 & 255;
      res[i2++] = 0;
      res[i2++] = 0;
      res[i2++] = 0;
      res[i2++] = 0;
      for (t2 = 8; t2 < this.padLength; t2++)
        res[i2++] = 0;
    }
    return res;
  };
  return common$3;
}
var sha = {};
var common$2 = {};
var hasRequiredCommon$2;
function requireCommon$2() {
  if (hasRequiredCommon$2) return common$2;
  hasRequiredCommon$2 = 1;
  var utils2 = requireUtils$1();
  var rotr32 = utils2.rotr32;
  function ft_1(s2, x2, y2, z2) {
    if (s2 === 0)
      return ch32(x2, y2, z2);
    if (s2 === 1 || s2 === 3)
      return p32(x2, y2, z2);
    if (s2 === 2)
      return maj32(x2, y2, z2);
  }
  common$2.ft_1 = ft_1;
  function ch32(x2, y2, z2) {
    return x2 & y2 ^ ~x2 & z2;
  }
  common$2.ch32 = ch32;
  function maj32(x2, y2, z2) {
    return x2 & y2 ^ x2 & z2 ^ y2 & z2;
  }
  common$2.maj32 = maj32;
  function p32(x2, y2, z2) {
    return x2 ^ y2 ^ z2;
  }
  common$2.p32 = p32;
  function s0_256(x2) {
    return rotr32(x2, 2) ^ rotr32(x2, 13) ^ rotr32(x2, 22);
  }
  common$2.s0_256 = s0_256;
  function s1_256(x2) {
    return rotr32(x2, 6) ^ rotr32(x2, 11) ^ rotr32(x2, 25);
  }
  common$2.s1_256 = s1_256;
  function g0_256(x2) {
    return rotr32(x2, 7) ^ rotr32(x2, 18) ^ x2 >>> 3;
  }
  common$2.g0_256 = g0_256;
  function g1_256(x2) {
    return rotr32(x2, 17) ^ rotr32(x2, 19) ^ x2 >>> 10;
  }
  common$2.g1_256 = g1_256;
  return common$2;
}
var _1;
var hasRequired_1;
function require_1() {
  if (hasRequired_1) return _1;
  hasRequired_1 = 1;
  var utils2 = requireUtils$1();
  var common2 = requireCommon$3();
  var shaCommon = requireCommon$2();
  var rotl32 = utils2.rotl32;
  var sum32 = utils2.sum32;
  var sum32_5 = utils2.sum32_5;
  var ft_1 = shaCommon.ft_1;
  var BlockHash = common2.BlockHash;
  var sha1_K = [
    1518500249,
    1859775393,
    2400959708,
    3395469782
  ];
  function SHA1() {
    if (!(this instanceof SHA1))
      return new SHA1();
    BlockHash.call(this);
    this.h = [
      1732584193,
      4023233417,
      2562383102,
      271733878,
      3285377520
    ];
    this.W = new Array(80);
  }
  utils2.inherits(SHA1, BlockHash);
  _1 = SHA1;
  SHA1.blockSize = 512;
  SHA1.outSize = 160;
  SHA1.hmacStrength = 80;
  SHA1.padLength = 64;
  SHA1.prototype._update = function _update(msg, start) {
    var W = this.W;
    for (var i2 = 0; i2 < 16; i2++)
      W[i2] = msg[start + i2];
    for (; i2 < W.length; i2++)
      W[i2] = rotl32(W[i2 - 3] ^ W[i2 - 8] ^ W[i2 - 14] ^ W[i2 - 16], 1);
    var a2 = this.h[0];
    var b2 = this.h[1];
    var c2 = this.h[2];
    var d = this.h[3];
    var e4 = this.h[4];
    for (i2 = 0; i2 < W.length; i2++) {
      var s2 = ~~(i2 / 20);
      var t2 = sum32_5(rotl32(a2, 5), ft_1(s2, b2, c2, d), e4, W[i2], sha1_K[s2]);
      e4 = d;
      d = c2;
      c2 = rotl32(b2, 30);
      b2 = a2;
      a2 = t2;
    }
    this.h[0] = sum32(this.h[0], a2);
    this.h[1] = sum32(this.h[1], b2);
    this.h[2] = sum32(this.h[2], c2);
    this.h[3] = sum32(this.h[3], d);
    this.h[4] = sum32(this.h[4], e4);
  };
  SHA1.prototype._digest = function digest(enc) {
    if (enc === "hex")
      return utils2.toHex32(this.h, "big");
    else
      return utils2.split32(this.h, "big");
  };
  return _1;
}
var _256;
var hasRequired_256;
function require_256() {
  if (hasRequired_256) return _256;
  hasRequired_256 = 1;
  var utils2 = requireUtils$1();
  var common2 = requireCommon$3();
  var shaCommon = requireCommon$2();
  var assert = requireMinimalisticAssert();
  var sum32 = utils2.sum32;
  var sum32_4 = utils2.sum32_4;
  var sum32_5 = utils2.sum32_5;
  var ch32 = shaCommon.ch32;
  var maj32 = shaCommon.maj32;
  var s0_256 = shaCommon.s0_256;
  var s1_256 = shaCommon.s1_256;
  var g0_256 = shaCommon.g0_256;
  var g1_256 = shaCommon.g1_256;
  var BlockHash = common2.BlockHash;
  var sha256_K = [
    1116352408,
    1899447441,
    3049323471,
    3921009573,
    961987163,
    1508970993,
    2453635748,
    2870763221,
    3624381080,
    310598401,
    607225278,
    1426881987,
    1925078388,
    2162078206,
    2614888103,
    3248222580,
    3835390401,
    4022224774,
    264347078,
    604807628,
    770255983,
    1249150122,
    1555081692,
    1996064986,
    2554220882,
    2821834349,
    2952996808,
    3210313671,
    3336571891,
    3584528711,
    113926993,
    338241895,
    666307205,
    773529912,
    1294757372,
    1396182291,
    1695183700,
    1986661051,
    2177026350,
    2456956037,
    2730485921,
    2820302411,
    3259730800,
    3345764771,
    3516065817,
    3600352804,
    4094571909,
    275423344,
    430227734,
    506948616,
    659060556,
    883997877,
    958139571,
    1322822218,
    1537002063,
    1747873779,
    1955562222,
    2024104815,
    2227730452,
    2361852424,
    2428436474,
    2756734187,
    3204031479,
    3329325298
  ];
  function SHA256() {
    if (!(this instanceof SHA256))
      return new SHA256();
    BlockHash.call(this);
    this.h = [
      1779033703,
      3144134277,
      1013904242,
      2773480762,
      1359893119,
      2600822924,
      528734635,
      1541459225
    ];
    this.k = sha256_K;
    this.W = new Array(64);
  }
  utils2.inherits(SHA256, BlockHash);
  _256 = SHA256;
  SHA256.blockSize = 512;
  SHA256.outSize = 256;
  SHA256.hmacStrength = 192;
  SHA256.padLength = 64;
  SHA256.prototype._update = function _update(msg, start) {
    var W = this.W;
    for (var i2 = 0; i2 < 16; i2++)
      W[i2] = msg[start + i2];
    for (; i2 < W.length; i2++)
      W[i2] = sum32_4(g1_256(W[i2 - 2]), W[i2 - 7], g0_256(W[i2 - 15]), W[i2 - 16]);
    var a2 = this.h[0];
    var b2 = this.h[1];
    var c2 = this.h[2];
    var d = this.h[3];
    var e4 = this.h[4];
    var f2 = this.h[5];
    var g = this.h[6];
    var h2 = this.h[7];
    assert(this.k.length === W.length);
    for (i2 = 0; i2 < W.length; i2++) {
      var T1 = sum32_5(h2, s1_256(e4), ch32(e4, f2, g), this.k[i2], W[i2]);
      var T2 = sum32(s0_256(a2), maj32(a2, b2, c2));
      h2 = g;
      g = f2;
      f2 = e4;
      e4 = sum32(d, T1);
      d = c2;
      c2 = b2;
      b2 = a2;
      a2 = sum32(T1, T2);
    }
    this.h[0] = sum32(this.h[0], a2);
    this.h[1] = sum32(this.h[1], b2);
    this.h[2] = sum32(this.h[2], c2);
    this.h[3] = sum32(this.h[3], d);
    this.h[4] = sum32(this.h[4], e4);
    this.h[5] = sum32(this.h[5], f2);
    this.h[6] = sum32(this.h[6], g);
    this.h[7] = sum32(this.h[7], h2);
  };
  SHA256.prototype._digest = function digest(enc) {
    if (enc === "hex")
      return utils2.toHex32(this.h, "big");
    else
      return utils2.split32(this.h, "big");
  };
  return _256;
}
var _224;
var hasRequired_224;
function require_224() {
  if (hasRequired_224) return _224;
  hasRequired_224 = 1;
  var utils2 = requireUtils$1();
  var SHA256 = require_256();
  function SHA224() {
    if (!(this instanceof SHA224))
      return new SHA224();
    SHA256.call(this);
    this.h = [
      3238371032,
      914150663,
      812702999,
      4144912697,
      4290775857,
      1750603025,
      1694076839,
      3204075428
    ];
  }
  utils2.inherits(SHA224, SHA256);
  _224 = SHA224;
  SHA224.blockSize = 512;
  SHA224.outSize = 224;
  SHA224.hmacStrength = 192;
  SHA224.padLength = 64;
  SHA224.prototype._digest = function digest(enc) {
    if (enc === "hex")
      return utils2.toHex32(this.h.slice(0, 7), "big");
    else
      return utils2.split32(this.h.slice(0, 7), "big");
  };
  return _224;
}
var _512;
var hasRequired_512;
function require_512() {
  if (hasRequired_512) return _512;
  hasRequired_512 = 1;
  var utils2 = requireUtils$1();
  var common2 = requireCommon$3();
  var assert = requireMinimalisticAssert();
  var rotr64_hi = utils2.rotr64_hi;
  var rotr64_lo = utils2.rotr64_lo;
  var shr64_hi = utils2.shr64_hi;
  var shr64_lo = utils2.shr64_lo;
  var sum64 = utils2.sum64;
  var sum64_hi = utils2.sum64_hi;
  var sum64_lo = utils2.sum64_lo;
  var sum64_4_hi = utils2.sum64_4_hi;
  var sum64_4_lo = utils2.sum64_4_lo;
  var sum64_5_hi = utils2.sum64_5_hi;
  var sum64_5_lo = utils2.sum64_5_lo;
  var BlockHash = common2.BlockHash;
  var sha512_K = [
    1116352408,
    3609767458,
    1899447441,
    602891725,
    3049323471,
    3964484399,
    3921009573,
    2173295548,
    961987163,
    4081628472,
    1508970993,
    3053834265,
    2453635748,
    2937671579,
    2870763221,
    3664609560,
    3624381080,
    2734883394,
    310598401,
    1164996542,
    607225278,
    1323610764,
    1426881987,
    3590304994,
    1925078388,
    4068182383,
    2162078206,
    991336113,
    2614888103,
    633803317,
    3248222580,
    3479774868,
    3835390401,
    2666613458,
    4022224774,
    944711139,
    264347078,
    2341262773,
    604807628,
    2007800933,
    770255983,
    1495990901,
    1249150122,
    1856431235,
    1555081692,
    3175218132,
    1996064986,
    2198950837,
    2554220882,
    3999719339,
    2821834349,
    766784016,
    2952996808,
    2566594879,
    3210313671,
    3203337956,
    3336571891,
    1034457026,
    3584528711,
    2466948901,
    113926993,
    3758326383,
    338241895,
    168717936,
    666307205,
    1188179964,
    773529912,
    1546045734,
    1294757372,
    1522805485,
    1396182291,
    2643833823,
    1695183700,
    2343527390,
    1986661051,
    1014477480,
    2177026350,
    1206759142,
    2456956037,
    344077627,
    2730485921,
    1290863460,
    2820302411,
    3158454273,
    3259730800,
    3505952657,
    3345764771,
    106217008,
    3516065817,
    3606008344,
    3600352804,
    1432725776,
    4094571909,
    1467031594,
    275423344,
    851169720,
    430227734,
    3100823752,
    506948616,
    1363258195,
    659060556,
    3750685593,
    883997877,
    3785050280,
    958139571,
    3318307427,
    1322822218,
    3812723403,
    1537002063,
    2003034995,
    1747873779,
    3602036899,
    1955562222,
    1575990012,
    2024104815,
    1125592928,
    2227730452,
    2716904306,
    2361852424,
    442776044,
    2428436474,
    593698344,
    2756734187,
    3733110249,
    3204031479,
    2999351573,
    3329325298,
    3815920427,
    3391569614,
    3928383900,
    3515267271,
    566280711,
    3940187606,
    3454069534,
    4118630271,
    4000239992,
    116418474,
    1914138554,
    174292421,
    2731055270,
    289380356,
    3203993006,
    460393269,
    320620315,
    685471733,
    587496836,
    852142971,
    1086792851,
    1017036298,
    365543100,
    1126000580,
    2618297676,
    1288033470,
    3409855158,
    1501505948,
    4234509866,
    1607167915,
    987167468,
    1816402316,
    1246189591
  ];
  function SHA512() {
    if (!(this instanceof SHA512))
      return new SHA512();
    BlockHash.call(this);
    this.h = [
      1779033703,
      4089235720,
      3144134277,
      2227873595,
      1013904242,
      4271175723,
      2773480762,
      1595750129,
      1359893119,
      2917565137,
      2600822924,
      725511199,
      528734635,
      4215389547,
      1541459225,
      327033209
    ];
    this.k = sha512_K;
    this.W = new Array(160);
  }
  utils2.inherits(SHA512, BlockHash);
  _512 = SHA512;
  SHA512.blockSize = 1024;
  SHA512.outSize = 512;
  SHA512.hmacStrength = 192;
  SHA512.padLength = 128;
  SHA512.prototype._prepareBlock = function _prepareBlock(msg, start) {
    var W = this.W;
    for (var i2 = 0; i2 < 32; i2++)
      W[i2] = msg[start + i2];
    for (; i2 < W.length; i2 += 2) {
      var c0_hi = g1_512_hi(W[i2 - 4], W[i2 - 3]);
      var c0_lo = g1_512_lo(W[i2 - 4], W[i2 - 3]);
      var c1_hi = W[i2 - 14];
      var c1_lo = W[i2 - 13];
      var c2_hi = g0_512_hi(W[i2 - 30], W[i2 - 29]);
      var c2_lo = g0_512_lo(W[i2 - 30], W[i2 - 29]);
      var c3_hi = W[i2 - 32];
      var c3_lo = W[i2 - 31];
      W[i2] = sum64_4_hi(
        c0_hi,
        c0_lo,
        c1_hi,
        c1_lo,
        c2_hi,
        c2_lo,
        c3_hi,
        c3_lo
      );
      W[i2 + 1] = sum64_4_lo(
        c0_hi,
        c0_lo,
        c1_hi,
        c1_lo,
        c2_hi,
        c2_lo,
        c3_hi,
        c3_lo
      );
    }
  };
  SHA512.prototype._update = function _update(msg, start) {
    this._prepareBlock(msg, start);
    var W = this.W;
    var ah = this.h[0];
    var al = this.h[1];
    var bh = this.h[2];
    var bl = this.h[3];
    var ch = this.h[4];
    var cl = this.h[5];
    var dh2 = this.h[6];
    var dl = this.h[7];
    var eh = this.h[8];
    var el = this.h[9];
    var fh = this.h[10];
    var fl = this.h[11];
    var gh = this.h[12];
    var gl = this.h[13];
    var hh = this.h[14];
    var hl = this.h[15];
    assert(this.k.length === W.length);
    for (var i2 = 0; i2 < W.length; i2 += 2) {
      var c0_hi = hh;
      var c0_lo = hl;
      var c1_hi = s1_512_hi(eh, el);
      var c1_lo = s1_512_lo(eh, el);
      var c2_hi = ch64_hi(eh, el, fh, fl, gh);
      var c2_lo = ch64_lo(eh, el, fh, fl, gh, gl);
      var c3_hi = this.k[i2];
      var c3_lo = this.k[i2 + 1];
      var c4_hi = W[i2];
      var c4_lo = W[i2 + 1];
      var T1_hi = sum64_5_hi(
        c0_hi,
        c0_lo,
        c1_hi,
        c1_lo,
        c2_hi,
        c2_lo,
        c3_hi,
        c3_lo,
        c4_hi,
        c4_lo
      );
      var T1_lo = sum64_5_lo(
        c0_hi,
        c0_lo,
        c1_hi,
        c1_lo,
        c2_hi,
        c2_lo,
        c3_hi,
        c3_lo,
        c4_hi,
        c4_lo
      );
      c0_hi = s0_512_hi(ah, al);
      c0_lo = s0_512_lo(ah, al);
      c1_hi = maj64_hi(ah, al, bh, bl, ch);
      c1_lo = maj64_lo(ah, al, bh, bl, ch, cl);
      var T2_hi = sum64_hi(c0_hi, c0_lo, c1_hi, c1_lo);
      var T2_lo = sum64_lo(c0_hi, c0_lo, c1_hi, c1_lo);
      hh = gh;
      hl = gl;
      gh = fh;
      gl = fl;
      fh = eh;
      fl = el;
      eh = sum64_hi(dh2, dl, T1_hi, T1_lo);
      el = sum64_lo(dl, dl, T1_hi, T1_lo);
      dh2 = ch;
      dl = cl;
      ch = bh;
      cl = bl;
      bh = ah;
      bl = al;
      ah = sum64_hi(T1_hi, T1_lo, T2_hi, T2_lo);
      al = sum64_lo(T1_hi, T1_lo, T2_hi, T2_lo);
    }
    sum64(this.h, 0, ah, al);
    sum64(this.h, 2, bh, bl);
    sum64(this.h, 4, ch, cl);
    sum64(this.h, 6, dh2, dl);
    sum64(this.h, 8, eh, el);
    sum64(this.h, 10, fh, fl);
    sum64(this.h, 12, gh, gl);
    sum64(this.h, 14, hh, hl);
  };
  SHA512.prototype._digest = function digest(enc) {
    if (enc === "hex")
      return utils2.toHex32(this.h, "big");
    else
      return utils2.split32(this.h, "big");
  };
  function ch64_hi(xh, xl, yh, yl, zh) {
    var r2 = xh & yh ^ ~xh & zh;
    if (r2 < 0)
      r2 += 4294967296;
    return r2;
  }
  function ch64_lo(xh, xl, yh, yl, zh, zl) {
    var r2 = xl & yl ^ ~xl & zl;
    if (r2 < 0)
      r2 += 4294967296;
    return r2;
  }
  function maj64_hi(xh, xl, yh, yl, zh) {
    var r2 = xh & yh ^ xh & zh ^ yh & zh;
    if (r2 < 0)
      r2 += 4294967296;
    return r2;
  }
  function maj64_lo(xh, xl, yh, yl, zh, zl) {
    var r2 = xl & yl ^ xl & zl ^ yl & zl;
    if (r2 < 0)
      r2 += 4294967296;
    return r2;
  }
  function s0_512_hi(xh, xl) {
    var c0_hi = rotr64_hi(xh, xl, 28);
    var c1_hi = rotr64_hi(xl, xh, 2);
    var c2_hi = rotr64_hi(xl, xh, 7);
    var r2 = c0_hi ^ c1_hi ^ c2_hi;
    if (r2 < 0)
      r2 += 4294967296;
    return r2;
  }
  function s0_512_lo(xh, xl) {
    var c0_lo = rotr64_lo(xh, xl, 28);
    var c1_lo = rotr64_lo(xl, xh, 2);
    var c2_lo = rotr64_lo(xl, xh, 7);
    var r2 = c0_lo ^ c1_lo ^ c2_lo;
    if (r2 < 0)
      r2 += 4294967296;
    return r2;
  }
  function s1_512_hi(xh, xl) {
    var c0_hi = rotr64_hi(xh, xl, 14);
    var c1_hi = rotr64_hi(xh, xl, 18);
    var c2_hi = rotr64_hi(xl, xh, 9);
    var r2 = c0_hi ^ c1_hi ^ c2_hi;
    if (r2 < 0)
      r2 += 4294967296;
    return r2;
  }
  function s1_512_lo(xh, xl) {
    var c0_lo = rotr64_lo(xh, xl, 14);
    var c1_lo = rotr64_lo(xh, xl, 18);
    var c2_lo = rotr64_lo(xl, xh, 9);
    var r2 = c0_lo ^ c1_lo ^ c2_lo;
    if (r2 < 0)
      r2 += 4294967296;
    return r2;
  }
  function g0_512_hi(xh, xl) {
    var c0_hi = rotr64_hi(xh, xl, 1);
    var c1_hi = rotr64_hi(xh, xl, 8);
    var c2_hi = shr64_hi(xh, xl, 7);
    var r2 = c0_hi ^ c1_hi ^ c2_hi;
    if (r2 < 0)
      r2 += 4294967296;
    return r2;
  }
  function g0_512_lo(xh, xl) {
    var c0_lo = rotr64_lo(xh, xl, 1);
    var c1_lo = rotr64_lo(xh, xl, 8);
    var c2_lo = shr64_lo(xh, xl, 7);
    var r2 = c0_lo ^ c1_lo ^ c2_lo;
    if (r2 < 0)
      r2 += 4294967296;
    return r2;
  }
  function g1_512_hi(xh, xl) {
    var c0_hi = rotr64_hi(xh, xl, 19);
    var c1_hi = rotr64_hi(xl, xh, 29);
    var c2_hi = shr64_hi(xh, xl, 6);
    var r2 = c0_hi ^ c1_hi ^ c2_hi;
    if (r2 < 0)
      r2 += 4294967296;
    return r2;
  }
  function g1_512_lo(xh, xl) {
    var c0_lo = rotr64_lo(xh, xl, 19);
    var c1_lo = rotr64_lo(xl, xh, 29);
    var c2_lo = shr64_lo(xh, xl, 6);
    var r2 = c0_lo ^ c1_lo ^ c2_lo;
    if (r2 < 0)
      r2 += 4294967296;
    return r2;
  }
  return _512;
}
var _384;
var hasRequired_384;
function require_384() {
  if (hasRequired_384) return _384;
  hasRequired_384 = 1;
  var utils2 = requireUtils$1();
  var SHA512 = require_512();
  function SHA384() {
    if (!(this instanceof SHA384))
      return new SHA384();
    SHA512.call(this);
    this.h = [
      3418070365,
      3238371032,
      1654270250,
      914150663,
      2438529370,
      812702999,
      355462360,
      4144912697,
      1731405415,
      4290775857,
      2394180231,
      1750603025,
      3675008525,
      1694076839,
      1203062813,
      3204075428
    ];
  }
  utils2.inherits(SHA384, SHA512);
  _384 = SHA384;
  SHA384.blockSize = 1024;
  SHA384.outSize = 384;
  SHA384.hmacStrength = 192;
  SHA384.padLength = 128;
  SHA384.prototype._digest = function digest(enc) {
    if (enc === "hex")
      return utils2.toHex32(this.h.slice(0, 12), "big");
    else
      return utils2.split32(this.h.slice(0, 12), "big");
  };
  return _384;
}
var hasRequiredSha;
function requireSha() {
  if (hasRequiredSha) return sha;
  hasRequiredSha = 1;
  sha.sha1 = require_1();
  sha.sha224 = require_224();
  sha.sha256 = require_256();
  sha.sha384 = require_384();
  sha.sha512 = require_512();
  return sha;
}
var ripemd = {};
var hasRequiredRipemd;
function requireRipemd() {
  if (hasRequiredRipemd) return ripemd;
  hasRequiredRipemd = 1;
  var utils2 = requireUtils$1();
  var common2 = requireCommon$3();
  var rotl32 = utils2.rotl32;
  var sum32 = utils2.sum32;
  var sum32_3 = utils2.sum32_3;
  var sum32_4 = utils2.sum32_4;
  var BlockHash = common2.BlockHash;
  function RIPEMD160() {
    if (!(this instanceof RIPEMD160))
      return new RIPEMD160();
    BlockHash.call(this);
    this.h = [1732584193, 4023233417, 2562383102, 271733878, 3285377520];
    this.endian = "little";
  }
  utils2.inherits(RIPEMD160, BlockHash);
  ripemd.ripemd160 = RIPEMD160;
  RIPEMD160.blockSize = 512;
  RIPEMD160.outSize = 160;
  RIPEMD160.hmacStrength = 192;
  RIPEMD160.padLength = 64;
  RIPEMD160.prototype._update = function update(msg, start) {
    var A2 = this.h[0];
    var B2 = this.h[1];
    var C2 = this.h[2];
    var D = this.h[3];
    var E2 = this.h[4];
    var Ah = A2;
    var Bh = B2;
    var Ch = C2;
    var Dh = D;
    var Eh = E2;
    for (var j = 0; j < 80; j++) {
      var T2 = sum32(
        rotl32(
          sum32_4(A2, f2(j, B2, C2, D), msg[r2[j] + start], K(j)),
          s2[j]
        ),
        E2
      );
      A2 = E2;
      E2 = D;
      D = rotl32(C2, 10);
      C2 = B2;
      B2 = T2;
      T2 = sum32(
        rotl32(
          sum32_4(Ah, f2(79 - j, Bh, Ch, Dh), msg[rh[j] + start], Kh(j)),
          sh[j]
        ),
        Eh
      );
      Ah = Eh;
      Eh = Dh;
      Dh = rotl32(Ch, 10);
      Ch = Bh;
      Bh = T2;
    }
    T2 = sum32_3(this.h[1], C2, Dh);
    this.h[1] = sum32_3(this.h[2], D, Eh);
    this.h[2] = sum32_3(this.h[3], E2, Ah);
    this.h[3] = sum32_3(this.h[4], A2, Bh);
    this.h[4] = sum32_3(this.h[0], B2, Ch);
    this.h[0] = T2;
  };
  RIPEMD160.prototype._digest = function digest(enc) {
    if (enc === "hex")
      return utils2.toHex32(this.h, "little");
    else
      return utils2.split32(this.h, "little");
  };
  function f2(j, x2, y2, z2) {
    if (j <= 15)
      return x2 ^ y2 ^ z2;
    else if (j <= 31)
      return x2 & y2 | ~x2 & z2;
    else if (j <= 47)
      return (x2 | ~y2) ^ z2;
    else if (j <= 63)
      return x2 & z2 | y2 & ~z2;
    else
      return x2 ^ (y2 | ~z2);
  }
  function K(j) {
    if (j <= 15)
      return 0;
    else if (j <= 31)
      return 1518500249;
    else if (j <= 47)
      return 1859775393;
    else if (j <= 63)
      return 2400959708;
    else
      return 2840853838;
  }
  function Kh(j) {
    if (j <= 15)
      return 1352829926;
    else if (j <= 31)
      return 1548603684;
    else if (j <= 47)
      return 1836072691;
    else if (j <= 63)
      return 2053994217;
    else
      return 0;
  }
  var r2 = [
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    7,
    4,
    13,
    1,
    10,
    6,
    15,
    3,
    12,
    0,
    9,
    5,
    2,
    14,
    11,
    8,
    3,
    10,
    14,
    4,
    9,
    15,
    8,
    1,
    2,
    7,
    0,
    6,
    13,
    11,
    5,
    12,
    1,
    9,
    11,
    10,
    0,
    8,
    12,
    4,
    13,
    3,
    7,
    15,
    14,
    5,
    6,
    2,
    4,
    0,
    5,
    9,
    7,
    12,
    2,
    10,
    14,
    1,
    3,
    8,
    11,
    6,
    15,
    13
  ];
  var rh = [
    5,
    14,
    7,
    0,
    9,
    2,
    11,
    4,
    13,
    6,
    15,
    8,
    1,
    10,
    3,
    12,
    6,
    11,
    3,
    7,
    0,
    13,
    5,
    10,
    14,
    15,
    8,
    12,
    4,
    9,
    1,
    2,
    15,
    5,
    1,
    3,
    7,
    14,
    6,
    9,
    11,
    8,
    12,
    2,
    10,
    0,
    4,
    13,
    8,
    6,
    4,
    1,
    3,
    11,
    15,
    0,
    5,
    12,
    2,
    13,
    9,
    7,
    10,
    14,
    12,
    15,
    10,
    4,
    1,
    5,
    8,
    7,
    6,
    2,
    13,
    14,
    0,
    3,
    9,
    11
  ];
  var s2 = [
    11,
    14,
    15,
    12,
    5,
    8,
    7,
    9,
    11,
    13,
    14,
    15,
    6,
    7,
    9,
    8,
    7,
    6,
    8,
    13,
    11,
    9,
    7,
    15,
    7,
    12,
    15,
    9,
    11,
    7,
    13,
    12,
    11,
    13,
    6,
    7,
    14,
    9,
    13,
    15,
    14,
    8,
    13,
    6,
    5,
    12,
    7,
    5,
    11,
    12,
    14,
    15,
    14,
    15,
    9,
    8,
    9,
    14,
    5,
    6,
    8,
    6,
    5,
    12,
    9,
    15,
    5,
    11,
    6,
    8,
    13,
    12,
    5,
    12,
    13,
    14,
    11,
    8,
    5,
    6
  ];
  var sh = [
    8,
    9,
    9,
    11,
    13,
    15,
    15,
    5,
    7,
    7,
    8,
    11,
    14,
    14,
    12,
    6,
    9,
    13,
    15,
    7,
    12,
    8,
    9,
    11,
    7,
    7,
    12,
    7,
    6,
    15,
    13,
    11,
    9,
    7,
    15,
    11,
    8,
    6,
    6,
    14,
    12,
    13,
    5,
    14,
    13,
    13,
    7,
    5,
    15,
    5,
    8,
    11,
    14,
    14,
    6,
    14,
    6,
    9,
    12,
    9,
    12,
    5,
    15,
    8,
    8,
    5,
    12,
    9,
    12,
    5,
    14,
    6,
    8,
    13,
    6,
    5,
    15,
    13,
    11,
    11
  ];
  return ripemd;
}
var hmac$2;
var hasRequiredHmac$1;
function requireHmac$1() {
  if (hasRequiredHmac$1) return hmac$2;
  hasRequiredHmac$1 = 1;
  var utils2 = requireUtils$1();
  var assert = requireMinimalisticAssert();
  function Hmac(hash2, key2, enc) {
    if (!(this instanceof Hmac))
      return new Hmac(hash2, key2, enc);
    this.Hash = hash2;
    this.blockSize = hash2.blockSize / 8;
    this.outSize = hash2.outSize / 8;
    this.inner = null;
    this.outer = null;
    this._init(utils2.toArray(key2, enc));
  }
  hmac$2 = Hmac;
  Hmac.prototype._init = function init2(key2) {
    if (key2.length > this.blockSize)
      key2 = new this.Hash().update(key2).digest();
    assert(key2.length <= this.blockSize);
    for (var i2 = key2.length; i2 < this.blockSize; i2++)
      key2.push(0);
    for (i2 = 0; i2 < key2.length; i2++)
      key2[i2] ^= 54;
    this.inner = new this.Hash().update(key2);
    for (i2 = 0; i2 < key2.length; i2++)
      key2[i2] ^= 106;
    this.outer = new this.Hash().update(key2);
  };
  Hmac.prototype.update = function update(msg, enc) {
    this.inner.update(msg, enc);
    return this;
  };
  Hmac.prototype.digest = function digest(enc) {
    this.outer.update(this.inner.digest());
    return this.outer.digest(enc);
  };
  return hmac$2;
}
var hasRequiredHash;
function requireHash() {
  if (hasRequiredHash) return hash;
  hasRequiredHash = 1;
  (function(exports) {
    var hash2 = exports;
    hash2.utils = requireUtils$1();
    hash2.common = requireCommon$3();
    hash2.sha = requireSha();
    hash2.ripemd = requireRipemd();
    hash2.hmac = requireHmac$1();
    hash2.sha1 = hash2.sha.sha1;
    hash2.sha256 = hash2.sha.sha256;
    hash2.sha224 = hash2.sha.sha224;
    hash2.sha384 = hash2.sha.sha384;
    hash2.sha512 = hash2.sha.sha512;
    hash2.ripemd160 = hash2.ripemd.ripemd160;
  })(hash);
  return hash;
}
var secp256k1;
var hasRequiredSecp256k1;
function requireSecp256k1() {
  if (hasRequiredSecp256k1) return secp256k1;
  hasRequiredSecp256k1 = 1;
  secp256k1 = {
    doubles: {
      step: 4,
      points: [
        [
          "e60fce93b59e9ec53011aabc21c23e97b2a31369b87a5ae9c44ee89e2a6dec0a",
          "f7e3507399e595929db99f34f57937101296891e44d23f0be1f32cce69616821"
        ],
        [
          "8282263212c609d9ea2a6e3e172de238d8c39cabd5ac1ca10646e23fd5f51508",
          "11f8a8098557dfe45e8256e830b60ace62d613ac2f7b17bed31b6eaff6e26caf"
        ],
        [
          "175e159f728b865a72f99cc6c6fc846de0b93833fd2222ed73fce5b551e5b739",
          "d3506e0d9e3c79eba4ef97a51ff71f5eacb5955add24345c6efa6ffee9fed695"
        ],
        [
          "363d90d447b00c9c99ceac05b6262ee053441c7e55552ffe526bad8f83ff4640",
          "4e273adfc732221953b445397f3363145b9a89008199ecb62003c7f3bee9de9"
        ],
        [
          "8b4b5f165df3c2be8c6244b5b745638843e4a781a15bcd1b69f79a55dffdf80c",
          "4aad0a6f68d308b4b3fbd7813ab0da04f9e336546162ee56b3eff0c65fd4fd36"
        ],
        [
          "723cbaa6e5db996d6bf771c00bd548c7b700dbffa6c0e77bcb6115925232fcda",
          "96e867b5595cc498a921137488824d6e2660a0653779494801dc069d9eb39f5f"
        ],
        [
          "eebfa4d493bebf98ba5feec812c2d3b50947961237a919839a533eca0e7dd7fa",
          "5d9a8ca3970ef0f269ee7edaf178089d9ae4cdc3a711f712ddfd4fdae1de8999"
        ],
        [
          "100f44da696e71672791d0a09b7bde459f1215a29b3c03bfefd7835b39a48db0",
          "cdd9e13192a00b772ec8f3300c090666b7ff4a18ff5195ac0fbd5cd62bc65a09"
        ],
        [
          "e1031be262c7ed1b1dc9227a4a04c017a77f8d4464f3b3852c8acde6e534fd2d",
          "9d7061928940405e6bb6a4176597535af292dd419e1ced79a44f18f29456a00d"
        ],
        [
          "feea6cae46d55b530ac2839f143bd7ec5cf8b266a41d6af52d5e688d9094696d",
          "e57c6b6c97dce1bab06e4e12bf3ecd5c981c8957cc41442d3155debf18090088"
        ],
        [
          "da67a91d91049cdcb367be4be6ffca3cfeed657d808583de33fa978bc1ec6cb1",
          "9bacaa35481642bc41f463f7ec9780e5dec7adc508f740a17e9ea8e27a68be1d"
        ],
        [
          "53904faa0b334cdda6e000935ef22151ec08d0f7bb11069f57545ccc1a37b7c0",
          "5bc087d0bc80106d88c9eccac20d3c1c13999981e14434699dcb096b022771c8"
        ],
        [
          "8e7bcd0bd35983a7719cca7764ca906779b53a043a9b8bcaeff959f43ad86047",
          "10b7770b2a3da4b3940310420ca9514579e88e2e47fd68b3ea10047e8460372a"
        ],
        [
          "385eed34c1cdff21e6d0818689b81bde71a7f4f18397e6690a841e1599c43862",
          "283bebc3e8ea23f56701de19e9ebf4576b304eec2086dc8cc0458fe5542e5453"
        ],
        [
          "6f9d9b803ecf191637c73a4413dfa180fddf84a5947fbc9c606ed86c3fac3a7",
          "7c80c68e603059ba69b8e2a30e45c4d47ea4dd2f5c281002d86890603a842160"
        ],
        [
          "3322d401243c4e2582a2147c104d6ecbf774d163db0f5e5313b7e0e742d0e6bd",
          "56e70797e9664ef5bfb019bc4ddaf9b72805f63ea2873af624f3a2e96c28b2a0"
        ],
        [
          "85672c7d2de0b7da2bd1770d89665868741b3f9af7643397721d74d28134ab83",
          "7c481b9b5b43b2eb6374049bfa62c2e5e77f17fcc5298f44c8e3094f790313a6"
        ],
        [
          "948bf809b1988a46b06c9f1919413b10f9226c60f668832ffd959af60c82a0a",
          "53a562856dcb6646dc6b74c5d1c3418c6d4dff08c97cd2bed4cb7f88d8c8e589"
        ],
        [
          "6260ce7f461801c34f067ce0f02873a8f1b0e44dfc69752accecd819f38fd8e8",
          "bc2da82b6fa5b571a7f09049776a1ef7ecd292238051c198c1a84e95b2b4ae17"
        ],
        [
          "e5037de0afc1d8d43d8348414bbf4103043ec8f575bfdc432953cc8d2037fa2d",
          "4571534baa94d3b5f9f98d09fb990bddbd5f5b03ec481f10e0e5dc841d755bda"
        ],
        [
          "e06372b0f4a207adf5ea905e8f1771b4e7e8dbd1c6a6c5b725866a0ae4fce725",
          "7a908974bce18cfe12a27bb2ad5a488cd7484a7787104870b27034f94eee31dd"
        ],
        [
          "213c7a715cd5d45358d0bbf9dc0ce02204b10bdde2a3f58540ad6908d0559754",
          "4b6dad0b5ae462507013ad06245ba190bb4850f5f36a7eeddff2c27534b458f2"
        ],
        [
          "4e7c272a7af4b34e8dbb9352a5419a87e2838c70adc62cddf0cc3a3b08fbd53c",
          "17749c766c9d0b18e16fd09f6def681b530b9614bff7dd33e0b3941817dcaae6"
        ],
        [
          "fea74e3dbe778b1b10f238ad61686aa5c76e3db2be43057632427e2840fb27b6",
          "6e0568db9b0b13297cf674deccb6af93126b596b973f7b77701d3db7f23cb96f"
        ],
        [
          "76e64113f677cf0e10a2570d599968d31544e179b760432952c02a4417bdde39",
          "c90ddf8dee4e95cf577066d70681f0d35e2a33d2b56d2032b4b1752d1901ac01"
        ],
        [
          "c738c56b03b2abe1e8281baa743f8f9a8f7cc643df26cbee3ab150242bcbb891",
          "893fb578951ad2537f718f2eacbfbbbb82314eef7880cfe917e735d9699a84c3"
        ],
        [
          "d895626548b65b81e264c7637c972877d1d72e5f3a925014372e9f6588f6c14b",
          "febfaa38f2bc7eae728ec60818c340eb03428d632bb067e179363ed75d7d991f"
        ],
        [
          "b8da94032a957518eb0f6433571e8761ceffc73693e84edd49150a564f676e03",
          "2804dfa44805a1e4d7c99cc9762808b092cc584d95ff3b511488e4e74efdf6e7"
        ],
        [
          "e80fea14441fb33a7d8adab9475d7fab2019effb5156a792f1a11778e3c0df5d",
          "eed1de7f638e00771e89768ca3ca94472d155e80af322ea9fcb4291b6ac9ec78"
        ],
        [
          "a301697bdfcd704313ba48e51d567543f2a182031efd6915ddc07bbcc4e16070",
          "7370f91cfb67e4f5081809fa25d40f9b1735dbf7c0a11a130c0d1a041e177ea1"
        ],
        [
          "90ad85b389d6b936463f9d0512678de208cc330b11307fffab7ac63e3fb04ed4",
          "e507a3620a38261affdcbd9427222b839aefabe1582894d991d4d48cb6ef150"
        ],
        [
          "8f68b9d2f63b5f339239c1ad981f162ee88c5678723ea3351b7b444c9ec4c0da",
          "662a9f2dba063986de1d90c2b6be215dbbea2cfe95510bfdf23cbf79501fff82"
        ],
        [
          "e4f3fb0176af85d65ff99ff9198c36091f48e86503681e3e6686fd5053231e11",
          "1e63633ad0ef4f1c1661a6d0ea02b7286cc7e74ec951d1c9822c38576feb73bc"
        ],
        [
          "8c00fa9b18ebf331eb961537a45a4266c7034f2f0d4e1d0716fb6eae20eae29e",
          "efa47267fea521a1a9dc343a3736c974c2fadafa81e36c54e7d2a4c66702414b"
        ],
        [
          "e7a26ce69dd4829f3e10cec0a9e98ed3143d084f308b92c0997fddfc60cb3e41",
          "2a758e300fa7984b471b006a1aafbb18d0a6b2c0420e83e20e8a9421cf2cfd51"
        ],
        [
          "b6459e0ee3662ec8d23540c223bcbdc571cbcb967d79424f3cf29eb3de6b80ef",
          "67c876d06f3e06de1dadf16e5661db3c4b3ae6d48e35b2ff30bf0b61a71ba45"
        ],
        [
          "d68a80c8280bb840793234aa118f06231d6f1fc67e73c5a5deda0f5b496943e8",
          "db8ba9fff4b586d00c4b1f9177b0e28b5b0e7b8f7845295a294c84266b133120"
        ],
        [
          "324aed7df65c804252dc0270907a30b09612aeb973449cea4095980fc28d3d5d",
          "648a365774b61f2ff130c0c35aec1f4f19213b0c7e332843967224af96ab7c84"
        ],
        [
          "4df9c14919cde61f6d51dfdbe5fee5dceec4143ba8d1ca888e8bd373fd054c96",
          "35ec51092d8728050974c23a1d85d4b5d506cdc288490192ebac06cad10d5d"
        ],
        [
          "9c3919a84a474870faed8a9c1cc66021523489054d7f0308cbfc99c8ac1f98cd",
          "ddb84f0f4a4ddd57584f044bf260e641905326f76c64c8e6be7e5e03d4fc599d"
        ],
        [
          "6057170b1dd12fdf8de05f281d8e06bb91e1493a8b91d4cc5a21382120a959e5",
          "9a1af0b26a6a4807add9a2daf71df262465152bc3ee24c65e899be932385a2a8"
        ],
        [
          "a576df8e23a08411421439a4518da31880cef0fba7d4df12b1a6973eecb94266",
          "40a6bf20e76640b2c92b97afe58cd82c432e10a7f514d9f3ee8be11ae1b28ec8"
        ],
        [
          "7778a78c28dec3e30a05fe9629de8c38bb30d1f5cf9a3a208f763889be58ad71",
          "34626d9ab5a5b22ff7098e12f2ff580087b38411ff24ac563b513fc1fd9f43ac"
        ],
        [
          "928955ee637a84463729fd30e7afd2ed5f96274e5ad7e5cb09eda9c06d903ac",
          "c25621003d3f42a827b78a13093a95eeac3d26efa8a8d83fc5180e935bcd091f"
        ],
        [
          "85d0fef3ec6db109399064f3a0e3b2855645b4a907ad354527aae75163d82751",
          "1f03648413a38c0be29d496e582cf5663e8751e96877331582c237a24eb1f962"
        ],
        [
          "ff2b0dce97eece97c1c9b6041798b85dfdfb6d8882da20308f5404824526087e",
          "493d13fef524ba188af4c4dc54d07936c7b7ed6fb90e2ceb2c951e01f0c29907"
        ],
        [
          "827fbbe4b1e880ea9ed2b2e6301b212b57f1ee148cd6dd28780e5e2cf856e241",
          "c60f9c923c727b0b71bef2c67d1d12687ff7a63186903166d605b68baec293ec"
        ],
        [
          "eaa649f21f51bdbae7be4ae34ce6e5217a58fdce7f47f9aa7f3b58fa2120e2b3",
          "be3279ed5bbbb03ac69a80f89879aa5a01a6b965f13f7e59d47a5305ba5ad93d"
        ],
        [
          "e4a42d43c5cf169d9391df6decf42ee541b6d8f0c9a137401e23632dda34d24f",
          "4d9f92e716d1c73526fc99ccfb8ad34ce886eedfa8d8e4f13a7f7131deba9414"
        ],
        [
          "1ec80fef360cbdd954160fadab352b6b92b53576a88fea4947173b9d4300bf19",
          "aeefe93756b5340d2f3a4958a7abbf5e0146e77f6295a07b671cdc1cc107cefd"
        ],
        [
          "146a778c04670c2f91b00af4680dfa8bce3490717d58ba889ddb5928366642be",
          "b318e0ec3354028add669827f9d4b2870aaa971d2f7e5ed1d0b297483d83efd0"
        ],
        [
          "fa50c0f61d22e5f07e3acebb1aa07b128d0012209a28b9776d76a8793180eef9",
          "6b84c6922397eba9b72cd2872281a68a5e683293a57a213b38cd8d7d3f4f2811"
        ],
        [
          "da1d61d0ca721a11b1a5bf6b7d88e8421a288ab5d5bba5220e53d32b5f067ec2",
          "8157f55a7c99306c79c0766161c91e2966a73899d279b48a655fba0f1ad836f1"
        ],
        [
          "a8e282ff0c9706907215ff98e8fd416615311de0446f1e062a73b0610d064e13",
          "7f97355b8db81c09abfb7f3c5b2515888b679a3e50dd6bd6cef7c73111f4cc0c"
        ],
        [
          "174a53b9c9a285872d39e56e6913cab15d59b1fa512508c022f382de8319497c",
          "ccc9dc37abfc9c1657b4155f2c47f9e6646b3a1d8cb9854383da13ac079afa73"
        ],
        [
          "959396981943785c3d3e57edf5018cdbe039e730e4918b3d884fdff09475b7ba",
          "2e7e552888c331dd8ba0386a4b9cd6849c653f64c8709385e9b8abf87524f2fd"
        ],
        [
          "d2a63a50ae401e56d645a1153b109a8fcca0a43d561fba2dbb51340c9d82b151",
          "e82d86fb6443fcb7565aee58b2948220a70f750af484ca52d4142174dcf89405"
        ],
        [
          "64587e2335471eb890ee7896d7cfdc866bacbdbd3839317b3436f9b45617e073",
          "d99fcdd5bf6902e2ae96dd6447c299a185b90a39133aeab358299e5e9faf6589"
        ],
        [
          "8481bde0e4e4d885b3a546d3e549de042f0aa6cea250e7fd358d6c86dd45e458",
          "38ee7b8cba5404dd84a25bf39cecb2ca900a79c42b262e556d64b1b59779057e"
        ],
        [
          "13464a57a78102aa62b6979ae817f4637ffcfed3c4b1ce30bcd6303f6caf666b",
          "69be159004614580ef7e433453ccb0ca48f300a81d0942e13f495a907f6ecc27"
        ],
        [
          "bc4a9df5b713fe2e9aef430bcc1dc97a0cd9ccede2f28588cada3a0d2d83f366",
          "d3a81ca6e785c06383937adf4b798caa6e8a9fbfa547b16d758d666581f33c1"
        ],
        [
          "8c28a97bf8298bc0d23d8c749452a32e694b65e30a9472a3954ab30fe5324caa",
          "40a30463a3305193378fedf31f7cc0eb7ae784f0451cb9459e71dc73cbef9482"
        ],
        [
          "8ea9666139527a8c1dd94ce4f071fd23c8b350c5a4bb33748c4ba111faccae0",
          "620efabbc8ee2782e24e7c0cfb95c5d735b783be9cf0f8e955af34a30e62b945"
        ],
        [
          "dd3625faef5ba06074669716bbd3788d89bdde815959968092f76cc4eb9a9787",
          "7a188fa3520e30d461da2501045731ca941461982883395937f68d00c644a573"
        ],
        [
          "f710d79d9eb962297e4f6232b40e8f7feb2bc63814614d692c12de752408221e",
          "ea98e67232d3b3295d3b535532115ccac8612c721851617526ae47a9c77bfc82"
        ]
      ]
    },
    naf: {
      wnd: 7,
      points: [
        [
          "f9308a019258c31049344f85f89d5229b531c845836f99b08601f113bce036f9",
          "388f7b0f632de8140fe337e62a37f3566500a99934c2231b6cb9fd7584b8e672"
        ],
        [
          "2f8bde4d1a07209355b4a7250a5c5128e88b84bddc619ab7cba8d569b240efe4",
          "d8ac222636e5e3d6d4dba9dda6c9c426f788271bab0d6840dca87d3aa6ac62d6"
        ],
        [
          "5cbdf0646e5db4eaa398f365f2ea7a0e3d419b7e0330e39ce92bddedcac4f9bc",
          "6aebca40ba255960a3178d6d861a54dba813d0b813fde7b5a5082628087264da"
        ],
        [
          "acd484e2f0c7f65309ad178a9f559abde09796974c57e714c35f110dfc27ccbe",
          "cc338921b0a7d9fd64380971763b61e9add888a4375f8e0f05cc262ac64f9c37"
        ],
        [
          "774ae7f858a9411e5ef4246b70c65aac5649980be5c17891bbec17895da008cb",
          "d984a032eb6b5e190243dd56d7b7b365372db1e2dff9d6a8301d74c9c953c61b"
        ],
        [
          "f28773c2d975288bc7d1d205c3748651b075fbc6610e58cddeeddf8f19405aa8",
          "ab0902e8d880a89758212eb65cdaf473a1a06da521fa91f29b5cb52db03ed81"
        ],
        [
          "d7924d4f7d43ea965a465ae3095ff41131e5946f3c85f79e44adbcf8e27e080e",
          "581e2872a86c72a683842ec228cc6defea40af2bd896d3a5c504dc9ff6a26b58"
        ],
        [
          "defdea4cdb677750a420fee807eacf21eb9898ae79b9768766e4faa04a2d4a34",
          "4211ab0694635168e997b0ead2a93daeced1f4a04a95c0f6cfb199f69e56eb77"
        ],
        [
          "2b4ea0a797a443d293ef5cff444f4979f06acfebd7e86d277475656138385b6c",
          "85e89bc037945d93b343083b5a1c86131a01f60c50269763b570c854e5c09b7a"
        ],
        [
          "352bbf4a4cdd12564f93fa332ce333301d9ad40271f8107181340aef25be59d5",
          "321eb4075348f534d59c18259dda3e1f4a1b3b2e71b1039c67bd3d8bcf81998c"
        ],
        [
          "2fa2104d6b38d11b0230010559879124e42ab8dfeff5ff29dc9cdadd4ecacc3f",
          "2de1068295dd865b64569335bd5dd80181d70ecfc882648423ba76b532b7d67"
        ],
        [
          "9248279b09b4d68dab21a9b066edda83263c3d84e09572e269ca0cd7f5453714",
          "73016f7bf234aade5d1aa71bdea2b1ff3fc0de2a887912ffe54a32ce97cb3402"
        ],
        [
          "daed4f2be3a8bf278e70132fb0beb7522f570e144bf615c07e996d443dee8729",
          "a69dce4a7d6c98e8d4a1aca87ef8d7003f83c230f3afa726ab40e52290be1c55"
        ],
        [
          "c44d12c7065d812e8acf28d7cbb19f9011ecd9e9fdf281b0e6a3b5e87d22e7db",
          "2119a460ce326cdc76c45926c982fdac0e106e861edf61c5a039063f0e0e6482"
        ],
        [
          "6a245bf6dc698504c89a20cfded60853152b695336c28063b61c65cbd269e6b4",
          "e022cf42c2bd4a708b3f5126f16a24ad8b33ba48d0423b6efd5e6348100d8a82"
        ],
        [
          "1697ffa6fd9de627c077e3d2fe541084ce13300b0bec1146f95ae57f0d0bd6a5",
          "b9c398f186806f5d27561506e4557433a2cf15009e498ae7adee9d63d01b2396"
        ],
        [
          "605bdb019981718b986d0f07e834cb0d9deb8360ffb7f61df982345ef27a7479",
          "2972d2de4f8d20681a78d93ec96fe23c26bfae84fb14db43b01e1e9056b8c49"
        ],
        [
          "62d14dab4150bf497402fdc45a215e10dcb01c354959b10cfe31c7e9d87ff33d",
          "80fc06bd8cc5b01098088a1950eed0db01aa132967ab472235f5642483b25eaf"
        ],
        [
          "80c60ad0040f27dade5b4b06c408e56b2c50e9f56b9b8b425e555c2f86308b6f",
          "1c38303f1cc5c30f26e66bad7fe72f70a65eed4cbe7024eb1aa01f56430bd57a"
        ],
        [
          "7a9375ad6167ad54aa74c6348cc54d344cc5dc9487d847049d5eabb0fa03c8fb",
          "d0e3fa9eca8726909559e0d79269046bdc59ea10c70ce2b02d499ec224dc7f7"
        ],
        [
          "d528ecd9b696b54c907a9ed045447a79bb408ec39b68df504bb51f459bc3ffc9",
          "eecf41253136e5f99966f21881fd656ebc4345405c520dbc063465b521409933"
        ],
        [
          "49370a4b5f43412ea25f514e8ecdad05266115e4a7ecb1387231808f8b45963",
          "758f3f41afd6ed428b3081b0512fd62a54c3f3afbb5b6764b653052a12949c9a"
        ],
        [
          "77f230936ee88cbbd73df930d64702ef881d811e0e1498e2f1c13eb1fc345d74",
          "958ef42a7886b6400a08266e9ba1b37896c95330d97077cbbe8eb3c7671c60d6"
        ],
        [
          "f2dac991cc4ce4b9ea44887e5c7c0bce58c80074ab9d4dbaeb28531b7739f530",
          "e0dedc9b3b2f8dad4da1f32dec2531df9eb5fbeb0598e4fd1a117dba703a3c37"
        ],
        [
          "463b3d9f662621fb1b4be8fbbe2520125a216cdfc9dae3debcba4850c690d45b",
          "5ed430d78c296c3543114306dd8622d7c622e27c970a1de31cb377b01af7307e"
        ],
        [
          "f16f804244e46e2a09232d4aff3b59976b98fac14328a2d1a32496b49998f247",
          "cedabd9b82203f7e13d206fcdf4e33d92a6c53c26e5cce26d6579962c4e31df6"
        ],
        [
          "caf754272dc84563b0352b7a14311af55d245315ace27c65369e15f7151d41d1",
          "cb474660ef35f5f2a41b643fa5e460575f4fa9b7962232a5c32f908318a04476"
        ],
        [
          "2600ca4b282cb986f85d0f1709979d8b44a09c07cb86d7c124497bc86f082120",
          "4119b88753c15bd6a693b03fcddbb45d5ac6be74ab5f0ef44b0be9475a7e4b40"
        ],
        [
          "7635ca72d7e8432c338ec53cd12220bc01c48685e24f7dc8c602a7746998e435",
          "91b649609489d613d1d5e590f78e6d74ecfc061d57048bad9e76f302c5b9c61"
        ],
        [
          "754e3239f325570cdbbf4a87deee8a66b7f2b33479d468fbc1a50743bf56cc18",
          "673fb86e5bda30fb3cd0ed304ea49a023ee33d0197a695d0c5d98093c536683"
        ],
        [
          "e3e6bd1071a1e96aff57859c82d570f0330800661d1c952f9fe2694691d9b9e8",
          "59c9e0bba394e76f40c0aa58379a3cb6a5a2283993e90c4167002af4920e37f5"
        ],
        [
          "186b483d056a033826ae73d88f732985c4ccb1f32ba35f4b4cc47fdcf04aa6eb",
          "3b952d32c67cf77e2e17446e204180ab21fb8090895138b4a4a797f86e80888b"
        ],
        [
          "df9d70a6b9876ce544c98561f4be4f725442e6d2b737d9c91a8321724ce0963f",
          "55eb2dafd84d6ccd5f862b785dc39d4ab157222720ef9da217b8c45cf2ba2417"
        ],
        [
          "5edd5cc23c51e87a497ca815d5dce0f8ab52554f849ed8995de64c5f34ce7143",
          "efae9c8dbc14130661e8cec030c89ad0c13c66c0d17a2905cdc706ab7399a868"
        ],
        [
          "290798c2b6476830da12fe02287e9e777aa3fba1c355b17a722d362f84614fba",
          "e38da76dcd440621988d00bcf79af25d5b29c094db2a23146d003afd41943e7a"
        ],
        [
          "af3c423a95d9f5b3054754efa150ac39cd29552fe360257362dfdecef4053b45",
          "f98a3fd831eb2b749a93b0e6f35cfb40c8cd5aa667a15581bc2feded498fd9c6"
        ],
        [
          "766dbb24d134e745cccaa28c99bf274906bb66b26dcf98df8d2fed50d884249a",
          "744b1152eacbe5e38dcc887980da38b897584a65fa06cedd2c924f97cbac5996"
        ],
        [
          "59dbf46f8c94759ba21277c33784f41645f7b44f6c596a58ce92e666191abe3e",
          "c534ad44175fbc300f4ea6ce648309a042ce739a7919798cd85e216c4a307f6e"
        ],
        [
          "f13ada95103c4537305e691e74e9a4a8dd647e711a95e73cb62dc6018cfd87b8",
          "e13817b44ee14de663bf4bc808341f326949e21a6a75c2570778419bdaf5733d"
        ],
        [
          "7754b4fa0e8aced06d4167a2c59cca4cda1869c06ebadfb6488550015a88522c",
          "30e93e864e669d82224b967c3020b8fa8d1e4e350b6cbcc537a48b57841163a2"
        ],
        [
          "948dcadf5990e048aa3874d46abef9d701858f95de8041d2a6828c99e2262519",
          "e491a42537f6e597d5d28a3224b1bc25df9154efbd2ef1d2cbba2cae5347d57e"
        ],
        [
          "7962414450c76c1689c7b48f8202ec37fb224cf5ac0bfa1570328a8a3d7c77ab",
          "100b610ec4ffb4760d5c1fc133ef6f6b12507a051f04ac5760afa5b29db83437"
        ],
        [
          "3514087834964b54b15b160644d915485a16977225b8847bb0dd085137ec47ca",
          "ef0afbb2056205448e1652c48e8127fc6039e77c15c2378b7e7d15a0de293311"
        ],
        [
          "d3cc30ad6b483e4bc79ce2c9dd8bc54993e947eb8df787b442943d3f7b527eaf",
          "8b378a22d827278d89c5e9be8f9508ae3c2ad46290358630afb34db04eede0a4"
        ],
        [
          "1624d84780732860ce1c78fcbfefe08b2b29823db913f6493975ba0ff4847610",
          "68651cf9b6da903e0914448c6cd9d4ca896878f5282be4c8cc06e2a404078575"
        ],
        [
          "733ce80da955a8a26902c95633e62a985192474b5af207da6df7b4fd5fc61cd4",
          "f5435a2bd2badf7d485a4d8b8db9fcce3e1ef8e0201e4578c54673bc1dc5ea1d"
        ],
        [
          "15d9441254945064cf1a1c33bbd3b49f8966c5092171e699ef258dfab81c045c",
          "d56eb30b69463e7234f5137b73b84177434800bacebfc685fc37bbe9efe4070d"
        ],
        [
          "a1d0fcf2ec9de675b612136e5ce70d271c21417c9d2b8aaaac138599d0717940",
          "edd77f50bcb5a3cab2e90737309667f2641462a54070f3d519212d39c197a629"
        ],
        [
          "e22fbe15c0af8ccc5780c0735f84dbe9a790badee8245c06c7ca37331cb36980",
          "a855babad5cd60c88b430a69f53a1a7a38289154964799be43d06d77d31da06"
        ],
        [
          "311091dd9860e8e20ee13473c1155f5f69635e394704eaa74009452246cfa9b3",
          "66db656f87d1f04fffd1f04788c06830871ec5a64feee685bd80f0b1286d8374"
        ],
        [
          "34c1fd04d301be89b31c0442d3e6ac24883928b45a9340781867d4232ec2dbdf",
          "9414685e97b1b5954bd46f730174136d57f1ceeb487443dc5321857ba73abee"
        ],
        [
          "f219ea5d6b54701c1c14de5b557eb42a8d13f3abbcd08affcc2a5e6b049b8d63",
          "4cb95957e83d40b0f73af4544cccf6b1f4b08d3c07b27fb8d8c2962a400766d1"
        ],
        [
          "d7b8740f74a8fbaab1f683db8f45de26543a5490bca627087236912469a0b448",
          "fa77968128d9c92ee1010f337ad4717eff15db5ed3c049b3411e0315eaa4593b"
        ],
        [
          "32d31c222f8f6f0ef86f7c98d3a3335ead5bcd32abdd94289fe4d3091aa824bf",
          "5f3032f5892156e39ccd3d7915b9e1da2e6dac9e6f26e961118d14b8462e1661"
        ],
        [
          "7461f371914ab32671045a155d9831ea8793d77cd59592c4340f86cbc18347b5",
          "8ec0ba238b96bec0cbdddcae0aa442542eee1ff50c986ea6b39847b3cc092ff6"
        ],
        [
          "ee079adb1df1860074356a25aa38206a6d716b2c3e67453d287698bad7b2b2d6",
          "8dc2412aafe3be5c4c5f37e0ecc5f9f6a446989af04c4e25ebaac479ec1c8c1e"
        ],
        [
          "16ec93e447ec83f0467b18302ee620f7e65de331874c9dc72bfd8616ba9da6b5",
          "5e4631150e62fb40d0e8c2a7ca5804a39d58186a50e497139626778e25b0674d"
        ],
        [
          "eaa5f980c245f6f038978290afa70b6bd8855897f98b6aa485b96065d537bd99",
          "f65f5d3e292c2e0819a528391c994624d784869d7e6ea67fb18041024edc07dc"
        ],
        [
          "78c9407544ac132692ee1910a02439958ae04877151342ea96c4b6b35a49f51",
          "f3e0319169eb9b85d5404795539a5e68fa1fbd583c064d2462b675f194a3ddb4"
        ],
        [
          "494f4be219a1a77016dcd838431aea0001cdc8ae7a6fc688726578d9702857a5",
          "42242a969283a5f339ba7f075e36ba2af925ce30d767ed6e55f4b031880d562c"
        ],
        [
          "a598a8030da6d86c6bc7f2f5144ea549d28211ea58faa70ebf4c1e665c1fe9b5",
          "204b5d6f84822c307e4b4a7140737aec23fc63b65b35f86a10026dbd2d864e6b"
        ],
        [
          "c41916365abb2b5d09192f5f2dbeafec208f020f12570a184dbadc3e58595997",
          "4f14351d0087efa49d245b328984989d5caf9450f34bfc0ed16e96b58fa9913"
        ],
        [
          "841d6063a586fa475a724604da03bc5b92a2e0d2e0a36acfe4c73a5514742881",
          "73867f59c0659e81904f9a1c7543698e62562d6744c169ce7a36de01a8d6154"
        ],
        [
          "5e95bb399a6971d376026947f89bde2f282b33810928be4ded112ac4d70e20d5",
          "39f23f366809085beebfc71181313775a99c9aed7d8ba38b161384c746012865"
        ],
        [
          "36e4641a53948fd476c39f8a99fd974e5ec07564b5315d8bf99471bca0ef2f66",
          "d2424b1b1abe4eb8164227b085c9aa9456ea13493fd563e06fd51cf5694c78fc"
        ],
        [
          "336581ea7bfbbb290c191a2f507a41cf5643842170e914faeab27c2c579f726",
          "ead12168595fe1be99252129b6e56b3391f7ab1410cd1e0ef3dcdcabd2fda224"
        ],
        [
          "8ab89816dadfd6b6a1f2634fcf00ec8403781025ed6890c4849742706bd43ede",
          "6fdcef09f2f6d0a044e654aef624136f503d459c3e89845858a47a9129cdd24e"
        ],
        [
          "1e33f1a746c9c5778133344d9299fcaa20b0938e8acff2544bb40284b8c5fb94",
          "60660257dd11b3aa9c8ed618d24edff2306d320f1d03010e33a7d2057f3b3b6"
        ],
        [
          "85b7c1dcb3cec1b7ee7f30ded79dd20a0ed1f4cc18cbcfcfa410361fd8f08f31",
          "3d98a9cdd026dd43f39048f25a8847f4fcafad1895d7a633c6fed3c35e999511"
        ],
        [
          "29df9fbd8d9e46509275f4b125d6d45d7fbe9a3b878a7af872a2800661ac5f51",
          "b4c4fe99c775a606e2d8862179139ffda61dc861c019e55cd2876eb2a27d84b"
        ],
        [
          "a0b1cae06b0a847a3fea6e671aaf8adfdfe58ca2f768105c8082b2e449fce252",
          "ae434102edde0958ec4b19d917a6a28e6b72da1834aff0e650f049503a296cf2"
        ],
        [
          "4e8ceafb9b3e9a136dc7ff67e840295b499dfb3b2133e4ba113f2e4c0e121e5",
          "cf2174118c8b6d7a4b48f6d534ce5c79422c086a63460502b827ce62a326683c"
        ],
        [
          "d24a44e047e19b6f5afb81c7ca2f69080a5076689a010919f42725c2b789a33b",
          "6fb8d5591b466f8fc63db50f1c0f1c69013f996887b8244d2cdec417afea8fa3"
        ],
        [
          "ea01606a7a6c9cdd249fdfcfacb99584001edd28abbab77b5104e98e8e3b35d4",
          "322af4908c7312b0cfbfe369f7a7b3cdb7d4494bc2823700cfd652188a3ea98d"
        ],
        [
          "af8addbf2b661c8a6c6328655eb96651252007d8c5ea31be4ad196de8ce2131f",
          "6749e67c029b85f52a034eafd096836b2520818680e26ac8f3dfbcdb71749700"
        ],
        [
          "e3ae1974566ca06cc516d47e0fb165a674a3dabcfca15e722f0e3450f45889",
          "2aeabe7e4531510116217f07bf4d07300de97e4874f81f533420a72eeb0bd6a4"
        ],
        [
          "591ee355313d99721cf6993ffed1e3e301993ff3ed258802075ea8ced397e246",
          "b0ea558a113c30bea60fc4775460c7901ff0b053d25ca2bdeee98f1a4be5d196"
        ],
        [
          "11396d55fda54c49f19aa97318d8da61fa8584e47b084945077cf03255b52984",
          "998c74a8cd45ac01289d5833a7beb4744ff536b01b257be4c5767bea93ea57a4"
        ],
        [
          "3c5d2a1ba39c5a1790000738c9e0c40b8dcdfd5468754b6405540157e017aa7a",
          "b2284279995a34e2f9d4de7396fc18b80f9b8b9fdd270f6661f79ca4c81bd257"
        ],
        [
          "cc8704b8a60a0defa3a99a7299f2e9c3fbc395afb04ac078425ef8a1793cc030",
          "bdd46039feed17881d1e0862db347f8cf395b74fc4bcdc4e940b74e3ac1f1b13"
        ],
        [
          "c533e4f7ea8555aacd9777ac5cad29b97dd4defccc53ee7ea204119b2889b197",
          "6f0a256bc5efdf429a2fb6242f1a43a2d9b925bb4a4b3a26bb8e0f45eb596096"
        ],
        [
          "c14f8f2ccb27d6f109f6d08d03cc96a69ba8c34eec07bbcf566d48e33da6593",
          "c359d6923bb398f7fd4473e16fe1c28475b740dd098075e6c0e8649113dc3a38"
        ],
        [
          "a6cbc3046bc6a450bac24789fa17115a4c9739ed75f8f21ce441f72e0b90e6ef",
          "21ae7f4680e889bb130619e2c0f95a360ceb573c70603139862afd617fa9b9f"
        ],
        [
          "347d6d9a02c48927ebfb86c1359b1caf130a3c0267d11ce6344b39f99d43cc38",
          "60ea7f61a353524d1c987f6ecec92f086d565ab687870cb12689ff1e31c74448"
        ],
        [
          "da6545d2181db8d983f7dcb375ef5866d47c67b1bf31c8cf855ef7437b72656a",
          "49b96715ab6878a79e78f07ce5680c5d6673051b4935bd897fea824b77dc208a"
        ],
        [
          "c40747cc9d012cb1a13b8148309c6de7ec25d6945d657146b9d5994b8feb1111",
          "5ca560753be2a12fc6de6caf2cb489565db936156b9514e1bb5e83037e0fa2d4"
        ],
        [
          "4e42c8ec82c99798ccf3a610be870e78338c7f713348bd34c8203ef4037f3502",
          "7571d74ee5e0fb92a7a8b33a07783341a5492144cc54bcc40a94473693606437"
        ],
        [
          "3775ab7089bc6af823aba2e1af70b236d251cadb0c86743287522a1b3b0dedea",
          "be52d107bcfa09d8bcb9736a828cfa7fac8db17bf7a76a2c42ad961409018cf7"
        ],
        [
          "cee31cbf7e34ec379d94fb814d3d775ad954595d1314ba8846959e3e82f74e26",
          "8fd64a14c06b589c26b947ae2bcf6bfa0149ef0be14ed4d80f448a01c43b1c6d"
        ],
        [
          "b4f9eaea09b6917619f6ea6a4eb5464efddb58fd45b1ebefcdc1a01d08b47986",
          "39e5c9925b5a54b07433a4f18c61726f8bb131c012ca542eb24a8ac07200682a"
        ],
        [
          "d4263dfc3d2df923a0179a48966d30ce84e2515afc3dccc1b77907792ebcc60e",
          "62dfaf07a0f78feb30e30d6295853ce189e127760ad6cf7fae164e122a208d54"
        ],
        [
          "48457524820fa65a4f8d35eb6930857c0032acc0a4a2de422233eeda897612c4",
          "25a748ab367979d98733c38a1fa1c2e7dc6cc07db2d60a9ae7a76aaa49bd0f77"
        ],
        [
          "dfeeef1881101f2cb11644f3a2afdfc2045e19919152923f367a1767c11cceda",
          "ecfb7056cf1de042f9420bab396793c0c390bde74b4bbdff16a83ae09a9a7517"
        ],
        [
          "6d7ef6b17543f8373c573f44e1f389835d89bcbc6062ced36c82df83b8fae859",
          "cd450ec335438986dfefa10c57fea9bcc521a0959b2d80bbf74b190dca712d10"
        ],
        [
          "e75605d59102a5a2684500d3b991f2e3f3c88b93225547035af25af66e04541f",
          "f5c54754a8f71ee540b9b48728473e314f729ac5308b06938360990e2bfad125"
        ],
        [
          "eb98660f4c4dfaa06a2be453d5020bc99a0c2e60abe388457dd43fefb1ed620c",
          "6cb9a8876d9cb8520609af3add26cd20a0a7cd8a9411131ce85f44100099223e"
        ],
        [
          "13e87b027d8514d35939f2e6892b19922154596941888336dc3563e3b8dba942",
          "fef5a3c68059a6dec5d624114bf1e91aac2b9da568d6abeb2570d55646b8adf1"
        ],
        [
          "ee163026e9fd6fe017c38f06a5be6fc125424b371ce2708e7bf4491691e5764a",
          "1acb250f255dd61c43d94ccc670d0f58f49ae3fa15b96623e5430da0ad6c62b2"
        ],
        [
          "b268f5ef9ad51e4d78de3a750c2dc89b1e626d43505867999932e5db33af3d80",
          "5f310d4b3c99b9ebb19f77d41c1dee018cf0d34fd4191614003e945a1216e423"
        ],
        [
          "ff07f3118a9df035e9fad85eb6c7bfe42b02f01ca99ceea3bf7ffdba93c4750d",
          "438136d603e858a3a5c440c38eccbaddc1d2942114e2eddd4740d098ced1f0d8"
        ],
        [
          "8d8b9855c7c052a34146fd20ffb658bea4b9f69e0d825ebec16e8c3ce2b526a1",
          "cdb559eedc2d79f926baf44fb84ea4d44bcf50fee51d7ceb30e2e7f463036758"
        ],
        [
          "52db0b5384dfbf05bfa9d472d7ae26dfe4b851ceca91b1eba54263180da32b63",
          "c3b997d050ee5d423ebaf66a6db9f57b3180c902875679de924b69d84a7b375"
        ],
        [
          "e62f9490d3d51da6395efd24e80919cc7d0f29c3f3fa48c6fff543becbd43352",
          "6d89ad7ba4876b0b22c2ca280c682862f342c8591f1daf5170e07bfd9ccafa7d"
        ],
        [
          "7f30ea2476b399b4957509c88f77d0191afa2ff5cb7b14fd6d8e7d65aaab1193",
          "ca5ef7d4b231c94c3b15389a5f6311e9daff7bb67b103e9880ef4bff637acaec"
        ],
        [
          "5098ff1e1d9f14fb46a210fada6c903fef0fb7b4a1dd1d9ac60a0361800b7a00",
          "9731141d81fc8f8084d37c6e7542006b3ee1b40d60dfe5362a5b132fd17ddc0"
        ],
        [
          "32b78c7de9ee512a72895be6b9cbefa6e2f3c4ccce445c96b9f2c81e2778ad58",
          "ee1849f513df71e32efc3896ee28260c73bb80547ae2275ba497237794c8753c"
        ],
        [
          "e2cb74fddc8e9fbcd076eef2a7c72b0ce37d50f08269dfc074b581550547a4f7",
          "d3aa2ed71c9dd2247a62df062736eb0baddea9e36122d2be8641abcb005cc4a4"
        ],
        [
          "8438447566d4d7bedadc299496ab357426009a35f235cb141be0d99cd10ae3a8",
          "c4e1020916980a4da5d01ac5e6ad330734ef0d7906631c4f2390426b2edd791f"
        ],
        [
          "4162d488b89402039b584c6fc6c308870587d9c46f660b878ab65c82c711d67e",
          "67163e903236289f776f22c25fb8a3afc1732f2b84b4e95dbda47ae5a0852649"
        ],
        [
          "3fad3fa84caf0f34f0f89bfd2dcf54fc175d767aec3e50684f3ba4a4bf5f683d",
          "cd1bc7cb6cc407bb2f0ca647c718a730cf71872e7d0d2a53fa20efcdfe61826"
        ],
        [
          "674f2600a3007a00568c1a7ce05d0816c1fb84bf1370798f1c69532faeb1a86b",
          "299d21f9413f33b3edf43b257004580b70db57da0b182259e09eecc69e0d38a5"
        ],
        [
          "d32f4da54ade74abb81b815ad1fb3b263d82d6c692714bcff87d29bd5ee9f08f",
          "f9429e738b8e53b968e99016c059707782e14f4535359d582fc416910b3eea87"
        ],
        [
          "30e4e670435385556e593657135845d36fbb6931f72b08cb1ed954f1e3ce3ff6",
          "462f9bce619898638499350113bbc9b10a878d35da70740dc695a559eb88db7b"
        ],
        [
          "be2062003c51cc3004682904330e4dee7f3dcd10b01e580bf1971b04d4cad297",
          "62188bc49d61e5428573d48a74e1c655b1c61090905682a0d5558ed72dccb9bc"
        ],
        [
          "93144423ace3451ed29e0fb9ac2af211cb6e84a601df5993c419859fff5df04a",
          "7c10dfb164c3425f5c71a3f9d7992038f1065224f72bb9d1d902a6d13037b47c"
        ],
        [
          "b015f8044f5fcbdcf21ca26d6c34fb8197829205c7b7d2a7cb66418c157b112c",
          "ab8c1e086d04e813744a655b2df8d5f83b3cdc6faa3088c1d3aea1454e3a1d5f"
        ],
        [
          "d5e9e1da649d97d89e4868117a465a3a4f8a18de57a140d36b3f2af341a21b52",
          "4cb04437f391ed73111a13cc1d4dd0db1693465c2240480d8955e8592f27447a"
        ],
        [
          "d3ae41047dd7ca065dbf8ed77b992439983005cd72e16d6f996a5316d36966bb",
          "bd1aeb21ad22ebb22a10f0303417c6d964f8cdd7df0aca614b10dc14d125ac46"
        ],
        [
          "463e2763d885f958fc66cdd22800f0a487197d0a82e377b49f80af87c897b065",
          "bfefacdb0e5d0fd7df3a311a94de062b26b80c61fbc97508b79992671ef7ca7f"
        ],
        [
          "7985fdfd127c0567c6f53ec1bb63ec3158e597c40bfe747c83cddfc910641917",
          "603c12daf3d9862ef2b25fe1de289aed24ed291e0ec6708703a5bd567f32ed03"
        ],
        [
          "74a1ad6b5f76e39db2dd249410eac7f99e74c59cb83d2d0ed5ff1543da7703e9",
          "cc6157ef18c9c63cd6193d83631bbea0093e0968942e8c33d5737fd790e0db08"
        ],
        [
          "30682a50703375f602d416664ba19b7fc9bab42c72747463a71d0896b22f6da3",
          "553e04f6b018b4fa6c8f39e7f311d3176290d0e0f19ca73f17714d9977a22ff8"
        ],
        [
          "9e2158f0d7c0d5f26c3791efefa79597654e7a2b2464f52b1ee6c1347769ef57",
          "712fcdd1b9053f09003a3481fa7762e9ffd7c8ef35a38509e2fbf2629008373"
        ],
        [
          "176e26989a43c9cfeba4029c202538c28172e566e3c4fce7322857f3be327d66",
          "ed8cc9d04b29eb877d270b4878dc43c19aefd31f4eee09ee7b47834c1fa4b1c3"
        ],
        [
          "75d46efea3771e6e68abb89a13ad747ecf1892393dfc4f1b7004788c50374da8",
          "9852390a99507679fd0b86fd2b39a868d7efc22151346e1a3ca4726586a6bed8"
        ],
        [
          "809a20c67d64900ffb698c4c825f6d5f2310fb0451c869345b7319f645605721",
          "9e994980d9917e22b76b061927fa04143d096ccc54963e6a5ebfa5f3f8e286c1"
        ],
        [
          "1b38903a43f7f114ed4500b4eac7083fdefece1cf29c63528d563446f972c180",
          "4036edc931a60ae889353f77fd53de4a2708b26b6f5da72ad3394119daf408f9"
        ]
      ]
    }
  };
  return secp256k1;
}
var hasRequiredCurves;
function requireCurves() {
  if (hasRequiredCurves) return curves;
  hasRequiredCurves = 1;
  (function(exports) {
    var curves2 = exports;
    var hash2 = requireHash();
    var curve2 = requireCurve();
    var utils2 = requireUtils$2();
    var assert = utils2.assert;
    function PresetCurve(options2) {
      if (options2.type === "short")
        this.curve = new curve2.short(options2);
      else if (options2.type === "edwards")
        this.curve = new curve2.edwards(options2);
      else
        this.curve = new curve2.mont(options2);
      this.g = this.curve.g;
      this.n = this.curve.n;
      this.hash = options2.hash;
      assert(this.g.validate(), "Invalid curve");
      assert(this.g.mul(this.n).isInfinity(), "Invalid curve, G*N != O");
    }
    curves2.PresetCurve = PresetCurve;
    function defineCurve(name, options2) {
      Object.defineProperty(curves2, name, {
        configurable: true,
        enumerable: true,
        get: function() {
          var curve3 = new PresetCurve(options2);
          Object.defineProperty(curves2, name, {
            configurable: true,
            enumerable: true,
            value: curve3
          });
          return curve3;
        }
      });
    }
    defineCurve("p192", {
      type: "short",
      prime: "p192",
      p: "ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff",
      a: "ffffffff ffffffff ffffffff fffffffe ffffffff fffffffc",
      b: "64210519 e59c80e7 0fa7e9ab 72243049 feb8deec c146b9b1",
      n: "ffffffff ffffffff ffffffff 99def836 146bc9b1 b4d22831",
      hash: hash2.sha256,
      gRed: false,
      g: [
        "188da80e b03090f6 7cbf20eb 43a18800 f4ff0afd 82ff1012",
        "07192b95 ffc8da78 631011ed 6b24cdd5 73f977a1 1e794811"
      ]
    });
    defineCurve("p224", {
      type: "short",
      prime: "p224",
      p: "ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001",
      a: "ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff fffffffe",
      b: "b4050a85 0c04b3ab f5413256 5044b0b7 d7bfd8ba 270b3943 2355ffb4",
      n: "ffffffff ffffffff ffffffff ffff16a2 e0b8f03e 13dd2945 5c5c2a3d",
      hash: hash2.sha256,
      gRed: false,
      g: [
        "b70e0cbd 6bb4bf7f 321390b9 4a03c1d3 56c21122 343280d6 115c1d21",
        "bd376388 b5f723fb 4c22dfe6 cd4375a0 5a074764 44d58199 85007e34"
      ]
    });
    defineCurve("p256", {
      type: "short",
      prime: null,
      p: "ffffffff 00000001 00000000 00000000 00000000 ffffffff ffffffff ffffffff",
      a: "ffffffff 00000001 00000000 00000000 00000000 ffffffff ffffffff fffffffc",
      b: "5ac635d8 aa3a93e7 b3ebbd55 769886bc 651d06b0 cc53b0f6 3bce3c3e 27d2604b",
      n: "ffffffff 00000000 ffffffff ffffffff bce6faad a7179e84 f3b9cac2 fc632551",
      hash: hash2.sha256,
      gRed: false,
      g: [
        "6b17d1f2 e12c4247 f8bce6e5 63a440f2 77037d81 2deb33a0 f4a13945 d898c296",
        "4fe342e2 fe1a7f9b 8ee7eb4a 7c0f9e16 2bce3357 6b315ece cbb64068 37bf51f5"
      ]
    });
    defineCurve("p384", {
      type: "short",
      prime: null,
      p: "ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe ffffffff 00000000 00000000 ffffffff",
      a: "ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe ffffffff 00000000 00000000 fffffffc",
      b: "b3312fa7 e23ee7e4 988e056b e3f82d19 181d9c6e fe814112 0314088f 5013875a c656398d 8a2ed19d 2a85c8ed d3ec2aef",
      n: "ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff c7634d81 f4372ddf 581a0db2 48b0a77a ecec196a ccc52973",
      hash: hash2.sha384,
      gRed: false,
      g: [
        "aa87ca22 be8b0537 8eb1c71e f320ad74 6e1d3b62 8ba79b98 59f741e0 82542a38 5502f25d bf55296c 3a545e38 72760ab7",
        "3617de4a 96262c6f 5d9e98bf 9292dc29 f8f41dbd 289a147c e9da3113 b5f0b8c0 0a60b1ce 1d7e819d 7a431d7c 90ea0e5f"
      ]
    });
    defineCurve("p521", {
      type: "short",
      prime: null,
      p: "000001ff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff",
      a: "000001ff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffc",
      b: "00000051 953eb961 8e1c9a1f 929a21a0 b68540ee a2da725b 99b315f3 b8b48991 8ef109e1 56193951 ec7e937b 1652c0bd 3bb1bf07 3573df88 3d2c34f1 ef451fd4 6b503f00",
      n: "000001ff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffa 51868783 bf2f966b 7fcc0148 f709a5d0 3bb5c9b8 899c47ae bb6fb71e 91386409",
      hash: hash2.sha512,
      gRed: false,
      g: [
        "000000c6 858e06b7 0404e9cd 9e3ecb66 2395b442 9c648139 053fb521 f828af60 6b4d3dba a14b5e77 efe75928 fe1dc127 a2ffa8de 3348b3c1 856a429b f97e7e31 c2e5bd66",
        "00000118 39296a78 9a3bc004 5c8a5fb4 2c7d1bd9 98f54449 579b4468 17afbd17 273e662c 97ee7299 5ef42640 c550b901 3fad0761 353c7086 a272c240 88be9476 9fd16650"
      ]
    });
    defineCurve("curve25519", {
      type: "mont",
      prime: "p25519",
      p: "7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed",
      a: "76d06",
      b: "1",
      n: "1000000000000000 0000000000000000 14def9dea2f79cd6 5812631a5cf5d3ed",
      hash: hash2.sha256,
      gRed: false,
      g: [
        "9"
      ]
    });
    defineCurve("ed25519", {
      type: "edwards",
      prime: "p25519",
      p: "7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed",
      a: "-1",
      c: "1",
      // -121665 * (121666^(-1)) (mod P)
      d: "52036cee2b6ffe73 8cc740797779e898 00700a4d4141d8ab 75eb4dca135978a3",
      n: "1000000000000000 0000000000000000 14def9dea2f79cd6 5812631a5cf5d3ed",
      hash: hash2.sha256,
      gRed: false,
      g: [
        "216936d3cd6e53fec0a4e231fdd6dc5c692cc7609525a7b2c9562d608f25d51a",
        // 4/5
        "6666666666666666666666666666666666666666666666666666666666666658"
      ]
    });
    var pre;
    try {
      pre = requireSecp256k1();
    } catch (e4) {
      pre = void 0;
    }
    defineCurve("secp256k1", {
      type: "short",
      prime: "k256",
      p: "ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f",
      a: "0",
      b: "7",
      n: "ffffffff ffffffff ffffffff fffffffe baaedce6 af48a03b bfd25e8c d0364141",
      h: "1",
      hash: hash2.sha256,
      // Precomputed endomorphism
      beta: "7ae96a2b657c07106e64479eac3434e99cf0497512f58995c1396c28719501ee",
      lambda: "5363ad4cc05c30e0a5261c028812645a122e22ea20816678df02967c1b23bd72",
      basis: [
        {
          a: "3086d221a7d46bcde86c90e49284eb15",
          b: "-e4437ed6010e88286f547fa90abfe4c3"
        },
        {
          a: "114ca50f7a8e2f3f657c1108d9d44cfd8",
          b: "3086d221a7d46bcde86c90e49284eb15"
        }
      ],
      gRed: false,
      g: [
        "79be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798",
        "483ada7726a3c4655da4fbfc0e1108a8fd17b448a68554199c47d08ffb10d4b8",
        pre
      ]
    });
  })(curves);
  return curves;
}
var hmacDrbg;
var hasRequiredHmacDrbg;
function requireHmacDrbg() {
  if (hasRequiredHmacDrbg) return hmacDrbg;
  hasRequiredHmacDrbg = 1;
  var hash2 = requireHash();
  var utils2 = requireUtils$3();
  var assert = requireMinimalisticAssert();
  function HmacDRBG(options2) {
    if (!(this instanceof HmacDRBG))
      return new HmacDRBG(options2);
    this.hash = options2.hash;
    this.predResist = !!options2.predResist;
    this.outLen = this.hash.outSize;
    this.minEntropy = options2.minEntropy || this.hash.hmacStrength;
    this._reseed = null;
    this.reseedInterval = null;
    this.K = null;
    this.V = null;
    var entropy = utils2.toArray(options2.entropy, options2.entropyEnc || "hex");
    var nonce = utils2.toArray(options2.nonce, options2.nonceEnc || "hex");
    var pers = utils2.toArray(options2.pers, options2.persEnc || "hex");
    assert(
      entropy.length >= this.minEntropy / 8,
      "Not enough entropy. Minimum is: " + this.minEntropy + " bits"
    );
    this._init(entropy, nonce, pers);
  }
  hmacDrbg = HmacDRBG;
  HmacDRBG.prototype._init = function init2(entropy, nonce, pers) {
    var seed = entropy.concat(nonce).concat(pers);
    this.K = new Array(this.outLen / 8);
    this.V = new Array(this.outLen / 8);
    for (var i2 = 0; i2 < this.V.length; i2++) {
      this.K[i2] = 0;
      this.V[i2] = 1;
    }
    this._update(seed);
    this._reseed = 1;
    this.reseedInterval = 281474976710656;
  };
  HmacDRBG.prototype._hmac = function hmac2() {
    return new hash2.hmac(this.hash, this.K);
  };
  HmacDRBG.prototype._update = function update(seed) {
    var kmac = this._hmac().update(this.V).update([0]);
    if (seed)
      kmac = kmac.update(seed);
    this.K = kmac.digest();
    this.V = this._hmac().update(this.V).digest();
    if (!seed)
      return;
    this.K = this._hmac().update(this.V).update([1]).update(seed).digest();
    this.V = this._hmac().update(this.V).digest();
  };
  HmacDRBG.prototype.reseed = function reseed(entropy, entropyEnc, add2, addEnc) {
    if (typeof entropyEnc !== "string") {
      addEnc = add2;
      add2 = entropyEnc;
      entropyEnc = null;
    }
    entropy = utils2.toArray(entropy, entropyEnc);
    add2 = utils2.toArray(add2, addEnc);
    assert(
      entropy.length >= this.minEntropy / 8,
      "Not enough entropy. Minimum is: " + this.minEntropy + " bits"
    );
    this._update(entropy.concat(add2 || []));
    this._reseed = 1;
  };
  HmacDRBG.prototype.generate = function generate(len, enc, add2, addEnc) {
    if (this._reseed > this.reseedInterval)
      throw new Error("Reseed is required");
    if (typeof enc !== "string") {
      addEnc = add2;
      add2 = enc;
      enc = null;
    }
    if (add2) {
      add2 = utils2.toArray(add2, addEnc || "hex");
      this._update(add2);
    }
    var temp = [];
    while (temp.length < len) {
      this.V = this._hmac().update(this.V).digest();
      temp = temp.concat(this.V);
    }
    var res = temp.slice(0, len);
    this._update(add2);
    this._reseed++;
    return utils2.encode(res, enc);
  };
  return hmacDrbg;
}
var key$1;
var hasRequiredKey$1;
function requireKey$1() {
  if (hasRequiredKey$1) return key$1;
  hasRequiredKey$1 = 1;
  var BN = requireBn$1();
  var utils2 = requireUtils$2();
  var assert = utils2.assert;
  function KeyPair(ec2, options2) {
    this.ec = ec2;
    this.priv = null;
    this.pub = null;
    if (options2.priv)
      this._importPrivate(options2.priv, options2.privEnc);
    if (options2.pub)
      this._importPublic(options2.pub, options2.pubEnc);
  }
  key$1 = KeyPair;
  KeyPair.fromPublic = function fromPublic(ec2, pub, enc) {
    if (pub instanceof KeyPair)
      return pub;
    return new KeyPair(ec2, {
      pub,
      pubEnc: enc
    });
  };
  KeyPair.fromPrivate = function fromPrivate(ec2, priv, enc) {
    if (priv instanceof KeyPair)
      return priv;
    return new KeyPair(ec2, {
      priv,
      privEnc: enc
    });
  };
  KeyPair.prototype.validate = function validate2() {
    var pub = this.getPublic();
    if (pub.isInfinity())
      return { result: false, reason: "Invalid public key" };
    if (!pub.validate())
      return { result: false, reason: "Public key is not a point" };
    if (!pub.mul(this.ec.curve.n).isInfinity())
      return { result: false, reason: "Public key * N != O" };
    return { result: true, reason: null };
  };
  KeyPair.prototype.getPublic = function getPublic(compact, enc) {
    if (typeof compact === "string") {
      enc = compact;
      compact = null;
    }
    if (!this.pub)
      this.pub = this.ec.g.mul(this.priv);
    if (!enc)
      return this.pub;
    return this.pub.encode(enc, compact);
  };
  KeyPair.prototype.getPrivate = function getPrivate(enc) {
    if (enc === "hex")
      return this.priv.toString(16, 2);
    else
      return this.priv;
  };
  KeyPair.prototype._importPrivate = function _importPrivate(key2, enc) {
    this.priv = new BN(key2, enc || 16);
    this.priv = this.priv.umod(this.ec.curve.n);
  };
  KeyPair.prototype._importPublic = function _importPublic(key2, enc) {
    if (key2.x || key2.y) {
      if (this.ec.curve.type === "mont") {
        assert(key2.x, "Need x coordinate");
      } else if (this.ec.curve.type === "short" || this.ec.curve.type === "edwards") {
        assert(key2.x && key2.y, "Need both x and y coordinate");
      }
      this.pub = this.ec.curve.point(key2.x, key2.y);
      return;
    }
    this.pub = this.ec.curve.decodePoint(key2, enc);
  };
  KeyPair.prototype.derive = function derive(pub) {
    if (!pub.validate()) {
      assert(pub.validate(), "public point not validated");
    }
    return pub.mul(this.priv).getX();
  };
  KeyPair.prototype.sign = function sign2(msg, enc, options2) {
    return this.ec.sign(msg, this, enc, options2);
  };
  KeyPair.prototype.verify = function verify(msg, signature2, options2) {
    return this.ec.verify(msg, signature2, this, void 0, options2);
  };
  KeyPair.prototype.inspect = function inspect() {
    return "<Key priv: " + (this.priv && this.priv.toString(16, 2)) + " pub: " + (this.pub && this.pub.inspect()) + " >";
  };
  return key$1;
}
var signature$1;
var hasRequiredSignature$1;
function requireSignature$1() {
  if (hasRequiredSignature$1) return signature$1;
  hasRequiredSignature$1 = 1;
  var BN = requireBn$1();
  var utils2 = requireUtils$2();
  var assert = utils2.assert;
  function Signature(options2, enc) {
    if (options2 instanceof Signature)
      return options2;
    if (this._importDER(options2, enc))
      return;
    assert(options2.r && options2.s, "Signature without r or s");
    this.r = new BN(options2.r, 16);
    this.s = new BN(options2.s, 16);
    if (options2.recoveryParam === void 0)
      this.recoveryParam = null;
    else
      this.recoveryParam = options2.recoveryParam;
  }
  signature$1 = Signature;
  function Position() {
    this.place = 0;
  }
  function getLength(buf, p2) {
    var initial = buf[p2.place++];
    if (!(initial & 128)) {
      return initial;
    }
    var octetLen = initial & 15;
    if (octetLen === 0 || octetLen > 4) {
      return false;
    }
    if (buf[p2.place] === 0) {
      return false;
    }
    var val = 0;
    for (var i2 = 0, off = p2.place; i2 < octetLen; i2++, off++) {
      val <<= 8;
      val |= buf[off];
      val >>>= 0;
    }
    if (val <= 127) {
      return false;
    }
    p2.place = off;
    return val;
  }
  function rmPadding(buf) {
    var i2 = 0;
    var len = buf.length - 1;
    while (!buf[i2] && !(buf[i2 + 1] & 128) && i2 < len) {
      i2++;
    }
    if (i2 === 0) {
      return buf;
    }
    return buf.slice(i2);
  }
  Signature.prototype._importDER = function _importDER(data2, enc) {
    data2 = utils2.toArray(data2, enc);
    var p2 = new Position();
    if (data2[p2.place++] !== 48) {
      return false;
    }
    var len = getLength(data2, p2);
    if (len === false) {
      return false;
    }
    if (len + p2.place !== data2.length) {
      return false;
    }
    if (data2[p2.place++] !== 2) {
      return false;
    }
    var rlen = getLength(data2, p2);
    if (rlen === false) {
      return false;
    }
    if ((data2[p2.place] & 128) !== 0) {
      return false;
    }
    var r2 = data2.slice(p2.place, rlen + p2.place);
    p2.place += rlen;
    if (data2[p2.place++] !== 2) {
      return false;
    }
    var slen = getLength(data2, p2);
    if (slen === false) {
      return false;
    }
    if (data2.length !== slen + p2.place) {
      return false;
    }
    if ((data2[p2.place] & 128) !== 0) {
      return false;
    }
    var s2 = data2.slice(p2.place, slen + p2.place);
    if (r2[0] === 0) {
      if (r2[1] & 128) {
        r2 = r2.slice(1);
      } else {
        return false;
      }
    }
    if (s2[0] === 0) {
      if (s2[1] & 128) {
        s2 = s2.slice(1);
      } else {
        return false;
      }
    }
    this.r = new BN(r2);
    this.s = new BN(s2);
    this.recoveryParam = null;
    return true;
  };
  function constructLength(arr, len) {
    if (len < 128) {
      arr.push(len);
      return;
    }
    var octets = 1 + (Math.log(len) / Math.LN2 >>> 3);
    arr.push(octets | 128);
    while (--octets) {
      arr.push(len >>> (octets << 3) & 255);
    }
    arr.push(len);
  }
  Signature.prototype.toDER = function toDER(enc) {
    var r2 = this.r.toArray();
    var s2 = this.s.toArray();
    if (r2[0] & 128)
      r2 = [0].concat(r2);
    if (s2[0] & 128)
      s2 = [0].concat(s2);
    r2 = rmPadding(r2);
    s2 = rmPadding(s2);
    while (!s2[0] && !(s2[1] & 128)) {
      s2 = s2.slice(1);
    }
    var arr = [2];
    constructLength(arr, r2.length);
    arr = arr.concat(r2);
    arr.push(2);
    constructLength(arr, s2.length);
    var backHalf = arr.concat(s2);
    var res = [48];
    constructLength(res, backHalf.length);
    res = res.concat(backHalf);
    return utils2.encode(res, enc);
  };
  return signature$1;
}
var ec;
var hasRequiredEc;
function requireEc() {
  if (hasRequiredEc) return ec;
  hasRequiredEc = 1;
  var BN = requireBn$1();
  var HmacDRBG = requireHmacDrbg();
  var utils2 = requireUtils$2();
  var curves2 = requireCurves();
  var rand = requireBrorand();
  var assert = utils2.assert;
  var KeyPair = requireKey$1();
  var Signature = requireSignature$1();
  function EC(options2) {
    if (!(this instanceof EC))
      return new EC(options2);
    if (typeof options2 === "string") {
      assert(
        Object.prototype.hasOwnProperty.call(curves2, options2),
        "Unknown curve " + options2
      );
      options2 = curves2[options2];
    }
    if (options2 instanceof curves2.PresetCurve)
      options2 = { curve: options2 };
    this.curve = options2.curve.curve;
    this.n = this.curve.n;
    this.nh = this.n.ushrn(1);
    this.g = this.curve.g;
    this.g = options2.curve.g;
    this.g.precompute(options2.curve.n.bitLength() + 1);
    this.hash = options2.hash || options2.curve.hash;
  }
  ec = EC;
  EC.prototype.keyPair = function keyPair(options2) {
    return new KeyPair(this, options2);
  };
  EC.prototype.keyFromPrivate = function keyFromPrivate(priv, enc) {
    return KeyPair.fromPrivate(this, priv, enc);
  };
  EC.prototype.keyFromPublic = function keyFromPublic(pub, enc) {
    return KeyPair.fromPublic(this, pub, enc);
  };
  EC.prototype.genKeyPair = function genKeyPair(options2) {
    if (!options2)
      options2 = {};
    var drbg = new HmacDRBG({
      hash: this.hash,
      pers: options2.pers,
      persEnc: options2.persEnc || "utf8",
      entropy: options2.entropy || rand(this.hash.hmacStrength),
      entropyEnc: options2.entropy && options2.entropyEnc || "utf8",
      nonce: this.n.toArray()
    });
    var bytes = this.n.byteLength();
    var ns2 = this.n.sub(new BN(2));
    for (; ; ) {
      var priv = new BN(drbg.generate(bytes));
      if (priv.cmp(ns2) > 0)
        continue;
      priv.iaddn(1);
      return this.keyFromPrivate(priv);
    }
  };
  EC.prototype._truncateToN = function _truncateToN(msg, truncOnly, bitLength) {
    var byteLength2;
    if (BN.isBN(msg) || typeof msg === "number") {
      msg = new BN(msg, 16);
      byteLength2 = msg.byteLength();
    } else if (typeof msg === "object") {
      byteLength2 = msg.length;
      msg = new BN(msg, 16);
    } else {
      var str = msg.toString();
      byteLength2 = str.length + 1 >>> 1;
      msg = new BN(str, 16);
    }
    if (typeof bitLength !== "number") {
      bitLength = byteLength2 * 8;
    }
    var delta = bitLength - this.n.bitLength();
    if (delta > 0)
      msg = msg.ushrn(delta);
    if (!truncOnly && msg.cmp(this.n) >= 0)
      return msg.sub(this.n);
    else
      return msg;
  };
  EC.prototype.sign = function sign2(msg, key2, enc, options2) {
    if (typeof enc === "object") {
      options2 = enc;
      enc = null;
    }
    if (!options2)
      options2 = {};
    if (typeof msg !== "string" && typeof msg !== "number" && !BN.isBN(msg)) {
      assert(
        typeof msg === "object" && msg && typeof msg.length === "number",
        "Expected message to be an array-like, a hex string, or a BN instance"
      );
      assert(msg.length >>> 0 === msg.length);
      for (var i2 = 0; i2 < msg.length; i2++) assert((msg[i2] & 255) === msg[i2]);
    }
    key2 = this.keyFromPrivate(key2, enc);
    msg = this._truncateToN(msg, false, options2.msgBitLength);
    assert(!msg.isNeg(), "Can not sign a negative message");
    var bytes = this.n.byteLength();
    var bkey = key2.getPrivate().toArray("be", bytes);
    var nonce = msg.toArray("be", bytes);
    assert(new BN(nonce).eq(msg), "Can not sign message");
    var drbg = new HmacDRBG({
      hash: this.hash,
      entropy: bkey,
      nonce,
      pers: options2.pers,
      persEnc: options2.persEnc || "utf8"
    });
    var ns1 = this.n.sub(new BN(1));
    for (var iter = 0; ; iter++) {
      var k2 = options2.k ? options2.k(iter) : new BN(drbg.generate(this.n.byteLength()));
      k2 = this._truncateToN(k2, true);
      if (k2.cmpn(1) <= 0 || k2.cmp(ns1) >= 0)
        continue;
      var kp = this.g.mul(k2);
      if (kp.isInfinity())
        continue;
      var kpX = kp.getX();
      var r2 = kpX.umod(this.n);
      if (r2.cmpn(0) === 0)
        continue;
      var s2 = k2.invm(this.n).mul(r2.mul(key2.getPrivate()).iadd(msg));
      s2 = s2.umod(this.n);
      if (s2.cmpn(0) === 0)
        continue;
      var recoveryParam = (kp.getY().isOdd() ? 1 : 0) | (kpX.cmp(r2) !== 0 ? 2 : 0);
      if (options2.canonical && s2.cmp(this.nh) > 0) {
        s2 = this.n.sub(s2);
        recoveryParam ^= 1;
      }
      return new Signature({ r: r2, s: s2, recoveryParam });
    }
  };
  EC.prototype.verify = function verify(msg, signature2, key2, enc, options2) {
    if (!options2)
      options2 = {};
    msg = this._truncateToN(msg, false, options2.msgBitLength);
    key2 = this.keyFromPublic(key2, enc);
    signature2 = new Signature(signature2, "hex");
    var r2 = signature2.r;
    var s2 = signature2.s;
    if (r2.cmpn(1) < 0 || r2.cmp(this.n) >= 0)
      return false;
    if (s2.cmpn(1) < 0 || s2.cmp(this.n) >= 0)
      return false;
    var sinv = s2.invm(this.n);
    var u1 = sinv.mul(msg).umod(this.n);
    var u2 = sinv.mul(r2).umod(this.n);
    var p2;
    if (!this.curve._maxwellTrick) {
      p2 = this.g.mulAdd(u1, key2.getPublic(), u2);
      if (p2.isInfinity())
        return false;
      return p2.getX().umod(this.n).cmp(r2) === 0;
    }
    p2 = this.g.jmulAdd(u1, key2.getPublic(), u2);
    if (p2.isInfinity())
      return false;
    return p2.eqXToP(r2);
  };
  EC.prototype.recoverPubKey = function(msg, signature2, j, enc) {
    assert((3 & j) === j, "The recovery param is more than two bits");
    signature2 = new Signature(signature2, enc);
    var n2 = this.n;
    var e4 = new BN(msg);
    var r2 = signature2.r;
    var s2 = signature2.s;
    var isYOdd = j & 1;
    var isSecondKey = j >> 1;
    if (r2.cmp(this.curve.p.umod(this.curve.n)) >= 0 && isSecondKey)
      throw new Error("Unable to find sencond key candinate");
    if (isSecondKey)
      r2 = this.curve.pointFromX(r2.add(this.curve.n), isYOdd);
    else
      r2 = this.curve.pointFromX(r2, isYOdd);
    var rInv = signature2.r.invm(n2);
    var s1 = n2.sub(e4).mul(rInv).umod(n2);
    var s22 = s2.mul(rInv).umod(n2);
    return this.g.mulAdd(s1, r2, s22);
  };
  EC.prototype.getKeyRecoveryParam = function(e4, signature2, Q, enc) {
    signature2 = new Signature(signature2, enc);
    if (signature2.recoveryParam !== null)
      return signature2.recoveryParam;
    for (var i2 = 0; i2 < 4; i2++) {
      var Qprime;
      try {
        Qprime = this.recoverPubKey(e4, signature2, i2);
      } catch (e5) {
        continue;
      }
      if (Qprime.eq(Q))
        return i2;
    }
    throw new Error("Unable to find valid recovery factor");
  };
  return ec;
}
var key;
var hasRequiredKey;
function requireKey() {
  if (hasRequiredKey) return key;
  hasRequiredKey = 1;
  var utils2 = requireUtils$2();
  var assert = utils2.assert;
  var parseBytes = utils2.parseBytes;
  var cachedProperty = utils2.cachedProperty;
  function KeyPair(eddsa2, params) {
    this.eddsa = eddsa2;
    this._secret = parseBytes(params.secret);
    if (eddsa2.isPoint(params.pub))
      this._pub = params.pub;
    else
      this._pubBytes = parseBytes(params.pub);
  }
  KeyPair.fromPublic = function fromPublic(eddsa2, pub) {
    if (pub instanceof KeyPair)
      return pub;
    return new KeyPair(eddsa2, { pub });
  };
  KeyPair.fromSecret = function fromSecret(eddsa2, secret) {
    if (secret instanceof KeyPair)
      return secret;
    return new KeyPair(eddsa2, { secret });
  };
  KeyPair.prototype.secret = function secret() {
    return this._secret;
  };
  cachedProperty(KeyPair, "pubBytes", function pubBytes() {
    return this.eddsa.encodePoint(this.pub());
  });
  cachedProperty(KeyPair, "pub", function pub() {
    if (this._pubBytes)
      return this.eddsa.decodePoint(this._pubBytes);
    return this.eddsa.g.mul(this.priv());
  });
  cachedProperty(KeyPair, "privBytes", function privBytes() {
    var eddsa2 = this.eddsa;
    var hash2 = this.hash();
    var lastIx = eddsa2.encodingLength - 1;
    var a2 = hash2.slice(0, eddsa2.encodingLength);
    a2[0] &= 248;
    a2[lastIx] &= 127;
    a2[lastIx] |= 64;
    return a2;
  });
  cachedProperty(KeyPair, "priv", function priv() {
    return this.eddsa.decodeInt(this.privBytes());
  });
  cachedProperty(KeyPair, "hash", function hash2() {
    return this.eddsa.hash().update(this.secret()).digest();
  });
  cachedProperty(KeyPair, "messagePrefix", function messagePrefix() {
    return this.hash().slice(this.eddsa.encodingLength);
  });
  KeyPair.prototype.sign = function sign2(message) {
    assert(this._secret, "KeyPair can only verify");
    return this.eddsa.sign(message, this);
  };
  KeyPair.prototype.verify = function verify(message, sig) {
    return this.eddsa.verify(message, sig, this);
  };
  KeyPair.prototype.getSecret = function getSecret(enc) {
    assert(this._secret, "KeyPair is public only");
    return utils2.encode(this.secret(), enc);
  };
  KeyPair.prototype.getPublic = function getPublic(enc) {
    return utils2.encode(this.pubBytes(), enc);
  };
  key = KeyPair;
  return key;
}
var signature;
var hasRequiredSignature;
function requireSignature() {
  if (hasRequiredSignature) return signature;
  hasRequiredSignature = 1;
  var BN = requireBn$1();
  var utils2 = requireUtils$2();
  var assert = utils2.assert;
  var cachedProperty = utils2.cachedProperty;
  var parseBytes = utils2.parseBytes;
  function Signature(eddsa2, sig) {
    this.eddsa = eddsa2;
    if (typeof sig !== "object")
      sig = parseBytes(sig);
    if (Array.isArray(sig)) {
      assert(sig.length === eddsa2.encodingLength * 2, "Signature has invalid size");
      sig = {
        R: sig.slice(0, eddsa2.encodingLength),
        S: sig.slice(eddsa2.encodingLength)
      };
    }
    assert(sig.R && sig.S, "Signature without R or S");
    if (eddsa2.isPoint(sig.R))
      this._R = sig.R;
    if (sig.S instanceof BN)
      this._S = sig.S;
    this._Rencoded = Array.isArray(sig.R) ? sig.R : sig.Rencoded;
    this._Sencoded = Array.isArray(sig.S) ? sig.S : sig.Sencoded;
  }
  cachedProperty(Signature, "S", function S2() {
    return this.eddsa.decodeInt(this.Sencoded());
  });
  cachedProperty(Signature, "R", function R2() {
    return this.eddsa.decodePoint(this.Rencoded());
  });
  cachedProperty(Signature, "Rencoded", function Rencoded() {
    return this.eddsa.encodePoint(this.R());
  });
  cachedProperty(Signature, "Sencoded", function Sencoded() {
    return this.eddsa.encodeInt(this.S());
  });
  Signature.prototype.toBytes = function toBytes() {
    return this.Rencoded().concat(this.Sencoded());
  };
  Signature.prototype.toHex = function toHex2() {
    return utils2.encode(this.toBytes(), "hex").toUpperCase();
  };
  signature = Signature;
  return signature;
}
var eddsa;
var hasRequiredEddsa;
function requireEddsa() {
  if (hasRequiredEddsa) return eddsa;
  hasRequiredEddsa = 1;
  var hash2 = requireHash();
  var curves2 = requireCurves();
  var utils2 = requireUtils$2();
  var assert = utils2.assert;
  var parseBytes = utils2.parseBytes;
  var KeyPair = requireKey();
  var Signature = requireSignature();
  function EDDSA(curve2) {
    assert(curve2 === "ed25519", "only tested with ed25519 so far");
    if (!(this instanceof EDDSA))
      return new EDDSA(curve2);
    curve2 = curves2[curve2].curve;
    this.curve = curve2;
    this.g = curve2.g;
    this.g.precompute(curve2.n.bitLength() + 1);
    this.pointClass = curve2.point().constructor;
    this.encodingLength = Math.ceil(curve2.n.bitLength() / 8);
    this.hash = hash2.sha512;
  }
  eddsa = EDDSA;
  EDDSA.prototype.sign = function sign2(message, secret) {
    message = parseBytes(message);
    var key2 = this.keyFromSecret(secret);
    var r2 = this.hashInt(key2.messagePrefix(), message);
    var R2 = this.g.mul(r2);
    var Rencoded = this.encodePoint(R2);
    var s_ = this.hashInt(Rencoded, key2.pubBytes(), message).mul(key2.priv());
    var S2 = r2.add(s_).umod(this.curve.n);
    return this.makeSignature({ R: R2, S: S2, Rencoded });
  };
  EDDSA.prototype.verify = function verify(message, sig, pub) {
    message = parseBytes(message);
    sig = this.makeSignature(sig);
    if (sig.S().gte(sig.eddsa.curve.n) || sig.S().isNeg()) {
      return false;
    }
    var key2 = this.keyFromPublic(pub);
    var h2 = this.hashInt(sig.Rencoded(), key2.pubBytes(), message);
    var SG = this.g.mul(sig.S());
    var RplusAh = sig.R().add(key2.pub().mul(h2));
    return RplusAh.eq(SG);
  };
  EDDSA.prototype.hashInt = function hashInt() {
    var hash3 = this.hash();
    for (var i2 = 0; i2 < arguments.length; i2++)
      hash3.update(arguments[i2]);
    return utils2.intFromLE(hash3.digest()).umod(this.curve.n);
  };
  EDDSA.prototype.keyFromPublic = function keyFromPublic(pub) {
    return KeyPair.fromPublic(this, pub);
  };
  EDDSA.prototype.keyFromSecret = function keyFromSecret(secret) {
    return KeyPair.fromSecret(this, secret);
  };
  EDDSA.prototype.makeSignature = function makeSignature(sig) {
    if (sig instanceof Signature)
      return sig;
    return new Signature(this, sig);
  };
  EDDSA.prototype.encodePoint = function encodePoint(point) {
    var enc = point.getY().toArray("le", this.encodingLength);
    enc[this.encodingLength - 1] |= point.getX().isOdd() ? 128 : 0;
    return enc;
  };
  EDDSA.prototype.decodePoint = function decodePoint(bytes) {
    bytes = utils2.parseBytes(bytes);
    var lastIx = bytes.length - 1;
    var normed = bytes.slice(0, lastIx).concat(bytes[lastIx] & -129);
    var xIsOdd = (bytes[lastIx] & 128) !== 0;
    var y2 = utils2.intFromLE(normed);
    return this.curve.pointFromY(y2, xIsOdd);
  };
  EDDSA.prototype.encodeInt = function encodeInt(num) {
    return num.toArray("le", this.encodingLength);
  };
  EDDSA.prototype.decodeInt = function decodeInt(bytes) {
    return utils2.intFromLE(bytes);
  };
  EDDSA.prototype.isPoint = function isPoint(val) {
    return val instanceof this.pointClass;
  };
  return eddsa;
}
var hasRequiredElliptic;
function requireElliptic() {
  if (hasRequiredElliptic) return elliptic;
  hasRequiredElliptic = 1;
  (function(exports) {
    var elliptic2 = exports;
    elliptic2.version = require$$0$1.version;
    elliptic2.utils = requireUtils$2();
    elliptic2.rand = requireBrorand();
    elliptic2.curve = requireCurve();
    elliptic2.curves = requireCurves();
    elliptic2.ec = requireEc();
    elliptic2.eddsa = requireEddsa();
  })(elliptic);
  return elliptic;
}
var asn1$1 = {};
var asn1 = {};
var api = {};
const __viteBrowserExternal_vm = new Proxy({}, {
  get(_2, key2) {
    throw new Error(`Module "vm" has been externalized for browser compatibility. Cannot access "vm.${key2}" in client code.  See https://vite.dev/guide/troubleshooting.html#module-externalized-for-browser-compatibility for more details.`);
  }
});
const __viteBrowserExternal_vm$1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: __viteBrowserExternal_vm
}, Symbol.toStringTag, { value: "Module" }));
const require$$2 = /* @__PURE__ */ getAugmentedNamespace$1(__viteBrowserExternal_vm$1);
var hasRequiredApi;
function requireApi() {
  if (hasRequiredApi) return api;
  hasRequiredApi = 1;
  (function(exports) {
    var asn12 = requireAsn1$1();
    var inherits = requireInherits_browser();
    var api2 = exports;
    api2.define = function define(name, body) {
      return new Entity(name, body);
    };
    function Entity(name, body) {
      this.name = name;
      this.body = body;
      this.decoders = {};
      this.encoders = {};
    }
    Entity.prototype._createNamed = function createNamed(base2) {
      var named;
      try {
        named = require$$2.runInThisContext(
          "(function " + this.name + "(entity) {\n  this._initNamed(entity);\n})"
        );
      } catch (e4) {
        named = function(entity) {
          this._initNamed(entity);
        };
      }
      inherits(named, base2);
      named.prototype._initNamed = function initnamed(entity) {
        base2.call(this, entity);
      };
      return new named(this);
    };
    Entity.prototype._getDecoder = function _getDecoder(enc) {
      enc = enc || "der";
      if (!this.decoders.hasOwnProperty(enc))
        this.decoders[enc] = this._createNamed(asn12.decoders[enc]);
      return this.decoders[enc];
    };
    Entity.prototype.decode = function decode2(data2, enc, options2) {
      return this._getDecoder(enc).decode(data2, options2);
    };
    Entity.prototype._getEncoder = function _getEncoder(enc) {
      enc = enc || "der";
      if (!this.encoders.hasOwnProperty(enc))
        this.encoders[enc] = this._createNamed(asn12.encoders[enc]);
      return this.encoders[enc];
    };
    Entity.prototype.encode = function encode2(data2, enc, reporter2) {
      return this._getEncoder(enc).encode(data2, reporter2);
    };
  })(api);
  return api;
}
var base = {};
var reporter = {};
var hasRequiredReporter;
function requireReporter() {
  if (hasRequiredReporter) return reporter;
  hasRequiredReporter = 1;
  var inherits = requireInherits_browser();
  function Reporter(options2) {
    this._reporterState = {
      obj: null,
      path: [],
      options: options2 || {},
      errors: []
    };
  }
  reporter.Reporter = Reporter;
  Reporter.prototype.isError = function isError(obj) {
    return obj instanceof ReporterError;
  };
  Reporter.prototype.save = function save() {
    var state = this._reporterState;
    return { obj: state.obj, pathLen: state.path.length };
  };
  Reporter.prototype.restore = function restore(data2) {
    var state = this._reporterState;
    state.obj = data2.obj;
    state.path = state.path.slice(0, data2.pathLen);
  };
  Reporter.prototype.enterKey = function enterKey(key2) {
    return this._reporterState.path.push(key2);
  };
  Reporter.prototype.exitKey = function exitKey(index2) {
    var state = this._reporterState;
    state.path = state.path.slice(0, index2 - 1);
  };
  Reporter.prototype.leaveKey = function leaveKey(index2, key2, value) {
    var state = this._reporterState;
    this.exitKey(index2);
    if (state.obj !== null)
      state.obj[key2] = value;
  };
  Reporter.prototype.path = function path() {
    return this._reporterState.path.join("/");
  };
  Reporter.prototype.enterObject = function enterObject() {
    var state = this._reporterState;
    var prev = state.obj;
    state.obj = {};
    return prev;
  };
  Reporter.prototype.leaveObject = function leaveObject(prev) {
    var state = this._reporterState;
    var now = state.obj;
    state.obj = prev;
    return now;
  };
  Reporter.prototype.error = function error(msg) {
    var err;
    var state = this._reporterState;
    var inherited = msg instanceof ReporterError;
    if (inherited) {
      err = msg;
    } else {
      err = new ReporterError(state.path.map(function(elem) {
        return "[" + JSON.stringify(elem) + "]";
      }).join(""), msg.message || msg, msg.stack);
    }
    if (!state.options.partial)
      throw err;
    if (!inherited)
      state.errors.push(err);
    return err;
  };
  Reporter.prototype.wrapResult = function wrapResult(result) {
    var state = this._reporterState;
    if (!state.options.partial)
      return result;
    return {
      result: this.isError(result) ? null : result,
      errors: state.errors
    };
  };
  function ReporterError(path, msg) {
    this.path = path;
    this.rethrow(msg);
  }
  inherits(ReporterError, Error);
  ReporterError.prototype.rethrow = function rethrow(msg) {
    this.message = msg + " at: " + (this.path || "(shallow)");
    if (Error.captureStackTrace)
      Error.captureStackTrace(this, ReporterError);
    if (!this.stack) {
      try {
        throw new Error(this.message);
      } catch (e4) {
        this.stack = e4.stack;
      }
    }
    return this;
  };
  return reporter;
}
var buffer = {};
var hasRequiredBuffer;
function requireBuffer() {
  if (hasRequiredBuffer) return buffer;
  hasRequiredBuffer = 1;
  var inherits = requireInherits_browser();
  var Reporter = requireBase().Reporter;
  var Buffer2 = requireBuffer$1().Buffer;
  function DecoderBuffer(base2, options2) {
    Reporter.call(this, options2);
    if (!Buffer2.isBuffer(base2)) {
      this.error("Input not Buffer");
      return;
    }
    this.base = base2;
    this.offset = 0;
    this.length = base2.length;
  }
  inherits(DecoderBuffer, Reporter);
  buffer.DecoderBuffer = DecoderBuffer;
  DecoderBuffer.prototype.save = function save() {
    return { offset: this.offset, reporter: Reporter.prototype.save.call(this) };
  };
  DecoderBuffer.prototype.restore = function restore(save) {
    var res = new DecoderBuffer(this.base);
    res.offset = save.offset;
    res.length = this.offset;
    this.offset = save.offset;
    Reporter.prototype.restore.call(this, save.reporter);
    return res;
  };
  DecoderBuffer.prototype.isEmpty = function isEmpty() {
    return this.offset === this.length;
  };
  DecoderBuffer.prototype.readUInt8 = function readUInt8(fail) {
    if (this.offset + 1 <= this.length)
      return this.base.readUInt8(this.offset++, true);
    else
      return this.error(fail || "DecoderBuffer overrun");
  };
  DecoderBuffer.prototype.skip = function skip(bytes, fail) {
    if (!(this.offset + bytes <= this.length))
      return this.error(fail || "DecoderBuffer overrun");
    var res = new DecoderBuffer(this.base);
    res._reporterState = this._reporterState;
    res.offset = this.offset;
    res.length = this.offset + bytes;
    this.offset += bytes;
    return res;
  };
  DecoderBuffer.prototype.raw = function raw(save) {
    return this.base.slice(save ? save.offset : this.offset, this.length);
  };
  function EncoderBuffer(value, reporter2) {
    if (Array.isArray(value)) {
      this.length = 0;
      this.value = value.map(function(item) {
        if (!(item instanceof EncoderBuffer))
          item = new EncoderBuffer(item, reporter2);
        this.length += item.length;
        return item;
      }, this);
    } else if (typeof value === "number") {
      if (!(0 <= value && value <= 255))
        return reporter2.error("non-byte EncoderBuffer value");
      this.value = value;
      this.length = 1;
    } else if (typeof value === "string") {
      this.value = value;
      this.length = Buffer2.byteLength(value);
    } else if (Buffer2.isBuffer(value)) {
      this.value = value;
      this.length = value.length;
    } else {
      return reporter2.error("Unsupported type: " + typeof value);
    }
  }
  buffer.EncoderBuffer = EncoderBuffer;
  EncoderBuffer.prototype.join = function join(out, offset) {
    if (!out)
      out = new Buffer2(this.length);
    if (!offset)
      offset = 0;
    if (this.length === 0)
      return out;
    if (Array.isArray(this.value)) {
      this.value.forEach(function(item) {
        item.join(out, offset);
        offset += item.length;
      });
    } else {
      if (typeof this.value === "number")
        out[offset] = this.value;
      else if (typeof this.value === "string")
        out.write(this.value, offset);
      else if (Buffer2.isBuffer(this.value))
        this.value.copy(out, offset);
      offset += this.length;
    }
    return out;
  };
  return buffer;
}
var node;
var hasRequiredNode;
function requireNode() {
  if (hasRequiredNode) return node;
  hasRequiredNode = 1;
  var Reporter = requireBase().Reporter;
  var EncoderBuffer = requireBase().EncoderBuffer;
  var DecoderBuffer = requireBase().DecoderBuffer;
  var assert = requireMinimalisticAssert();
  var tags = [
    "seq",
    "seqof",
    "set",
    "setof",
    "objid",
    "bool",
    "gentime",
    "utctime",
    "null_",
    "enum",
    "int",
    "objDesc",
    "bitstr",
    "bmpstr",
    "charstr",
    "genstr",
    "graphstr",
    "ia5str",
    "iso646str",
    "numstr",
    "octstr",
    "printstr",
    "t61str",
    "unistr",
    "utf8str",
    "videostr"
  ];
  var methods2 = [
    "key",
    "obj",
    "use",
    "optional",
    "explicit",
    "implicit",
    "def",
    "choice",
    "any",
    "contains"
  ].concat(tags);
  var overrided = [
    "_peekTag",
    "_decodeTag",
    "_use",
    "_decodeStr",
    "_decodeObjid",
    "_decodeTime",
    "_decodeNull",
    "_decodeInt",
    "_decodeBool",
    "_decodeList",
    "_encodeComposite",
    "_encodeStr",
    "_encodeObjid",
    "_encodeTime",
    "_encodeNull",
    "_encodeInt",
    "_encodeBool"
  ];
  function Node(enc, parent) {
    var state = {};
    this._baseState = state;
    state.enc = enc;
    state.parent = parent || null;
    state.children = null;
    state.tag = null;
    state.args = null;
    state.reverseArgs = null;
    state.choice = null;
    state.optional = false;
    state.any = false;
    state.obj = false;
    state.use = null;
    state.useDecoder = null;
    state.key = null;
    state["default"] = null;
    state.explicit = null;
    state.implicit = null;
    state.contains = null;
    if (!state.parent) {
      state.children = [];
      this._wrap();
    }
  }
  node = Node;
  var stateProps = [
    "enc",
    "parent",
    "children",
    "tag",
    "args",
    "reverseArgs",
    "choice",
    "optional",
    "any",
    "obj",
    "use",
    "alteredUse",
    "key",
    "default",
    "explicit",
    "implicit",
    "contains"
  ];
  Node.prototype.clone = function clone2() {
    var state = this._baseState;
    var cstate = {};
    stateProps.forEach(function(prop) {
      cstate[prop] = state[prop];
    });
    var res = new this.constructor(cstate.parent);
    res._baseState = cstate;
    return res;
  };
  Node.prototype._wrap = function wrap() {
    var state = this._baseState;
    methods2.forEach(function(method) {
      this[method] = function _wrappedMethod() {
        var clone2 = new this.constructor(this);
        state.children.push(clone2);
        return clone2[method].apply(clone2, arguments);
      };
    }, this);
  };
  Node.prototype._init = function init2(body) {
    var state = this._baseState;
    assert(state.parent === null);
    body.call(this);
    state.children = state.children.filter(function(child) {
      return child._baseState.parent === this;
    }, this);
    assert.equal(state.children.length, 1, "Root node can have only one child");
  };
  Node.prototype._useArgs = function useArgs(args) {
    var state = this._baseState;
    var children = args.filter(function(arg) {
      return arg instanceof this.constructor;
    }, this);
    args = args.filter(function(arg) {
      return !(arg instanceof this.constructor);
    }, this);
    if (children.length !== 0) {
      assert(state.children === null);
      state.children = children;
      children.forEach(function(child) {
        child._baseState.parent = this;
      }, this);
    }
    if (args.length !== 0) {
      assert(state.args === null);
      state.args = args;
      state.reverseArgs = args.map(function(arg) {
        if (typeof arg !== "object" || arg.constructor !== Object)
          return arg;
        var res = {};
        Object.keys(arg).forEach(function(key2) {
          if (key2 == (key2 | 0))
            key2 |= 0;
          var value = arg[key2];
          res[value] = key2;
        });
        return res;
      });
    }
  };
  overrided.forEach(function(method) {
    Node.prototype[method] = function _overrided() {
      var state = this._baseState;
      throw new Error(method + " not implemented for encoding: " + state.enc);
    };
  });
  tags.forEach(function(tag) {
    Node.prototype[tag] = function _tagMethod() {
      var state = this._baseState;
      var args = Array.prototype.slice.call(arguments);
      assert(state.tag === null);
      state.tag = tag;
      this._useArgs(args);
      return this;
    };
  });
  Node.prototype.use = function use(item) {
    assert(item);
    var state = this._baseState;
    assert(state.use === null);
    state.use = item;
    return this;
  };
  Node.prototype.optional = function optional() {
    var state = this._baseState;
    state.optional = true;
    return this;
  };
  Node.prototype.def = function def(val) {
    var state = this._baseState;
    assert(state["default"] === null);
    state["default"] = val;
    state.optional = true;
    return this;
  };
  Node.prototype.explicit = function explicit(num) {
    var state = this._baseState;
    assert(state.explicit === null && state.implicit === null);
    state.explicit = num;
    return this;
  };
  Node.prototype.implicit = function implicit(num) {
    var state = this._baseState;
    assert(state.explicit === null && state.implicit === null);
    state.implicit = num;
    return this;
  };
  Node.prototype.obj = function obj() {
    var state = this._baseState;
    var args = Array.prototype.slice.call(arguments);
    state.obj = true;
    if (args.length !== 0)
      this._useArgs(args);
    return this;
  };
  Node.prototype.key = function key2(newKey) {
    var state = this._baseState;
    assert(state.key === null);
    state.key = newKey;
    return this;
  };
  Node.prototype.any = function any() {
    var state = this._baseState;
    state.any = true;
    return this;
  };
  Node.prototype.choice = function choice(obj) {
    var state = this._baseState;
    assert(state.choice === null);
    state.choice = obj;
    this._useArgs(Object.keys(obj).map(function(key2) {
      return obj[key2];
    }));
    return this;
  };
  Node.prototype.contains = function contains2(item) {
    var state = this._baseState;
    assert(state.use === null);
    state.contains = item;
    return this;
  };
  Node.prototype._decode = function decode2(input, options2) {
    var state = this._baseState;
    if (state.parent === null)
      return input.wrapResult(state.children[0]._decode(input, options2));
    var result = state["default"];
    var present = true;
    var prevKey = null;
    if (state.key !== null)
      prevKey = input.enterKey(state.key);
    if (state.optional) {
      var tag = null;
      if (state.explicit !== null)
        tag = state.explicit;
      else if (state.implicit !== null)
        tag = state.implicit;
      else if (state.tag !== null)
        tag = state.tag;
      if (tag === null && !state.any) {
        var save = input.save();
        try {
          if (state.choice === null)
            this._decodeGeneric(state.tag, input, options2);
          else
            this._decodeChoice(input, options2);
          present = true;
        } catch (e4) {
          present = false;
        }
        input.restore(save);
      } else {
        present = this._peekTag(input, tag, state.any);
        if (input.isError(present))
          return present;
      }
    }
    var prevObj;
    if (state.obj && present)
      prevObj = input.enterObject();
    if (present) {
      if (state.explicit !== null) {
        var explicit = this._decodeTag(input, state.explicit);
        if (input.isError(explicit))
          return explicit;
        input = explicit;
      }
      var start = input.offset;
      if (state.use === null && state.choice === null) {
        if (state.any)
          var save = input.save();
        var body = this._decodeTag(
          input,
          state.implicit !== null ? state.implicit : state.tag,
          state.any
        );
        if (input.isError(body))
          return body;
        if (state.any)
          result = input.raw(save);
        else
          input = body;
      }
      if (options2 && options2.track && state.tag !== null)
        options2.track(input.path(), start, input.length, "tagged");
      if (options2 && options2.track && state.tag !== null)
        options2.track(input.path(), input.offset, input.length, "content");
      if (state.any)
        result = result;
      else if (state.choice === null)
        result = this._decodeGeneric(state.tag, input, options2);
      else
        result = this._decodeChoice(input, options2);
      if (input.isError(result))
        return result;
      if (!state.any && state.choice === null && state.children !== null) {
        state.children.forEach(function decodeChildren(child) {
          child._decode(input, options2);
        });
      }
      if (state.contains && (state.tag === "octstr" || state.tag === "bitstr")) {
        var data2 = new DecoderBuffer(result);
        result = this._getUse(state.contains, input._reporterState.obj)._decode(data2, options2);
      }
    }
    if (state.obj && present)
      result = input.leaveObject(prevObj);
    if (state.key !== null && (result !== null || present === true))
      input.leaveKey(prevKey, state.key, result);
    else if (prevKey !== null)
      input.exitKey(prevKey);
    return result;
  };
  Node.prototype._decodeGeneric = function decodeGeneric(tag, input, options2) {
    var state = this._baseState;
    if (tag === "seq" || tag === "set")
      return null;
    if (tag === "seqof" || tag === "setof")
      return this._decodeList(input, tag, state.args[0], options2);
    else if (/str$/.test(tag))
      return this._decodeStr(input, tag, options2);
    else if (tag === "objid" && state.args)
      return this._decodeObjid(input, state.args[0], state.args[1], options2);
    else if (tag === "objid")
      return this._decodeObjid(input, null, null, options2);
    else if (tag === "gentime" || tag === "utctime")
      return this._decodeTime(input, tag, options2);
    else if (tag === "null_")
      return this._decodeNull(input, options2);
    else if (tag === "bool")
      return this._decodeBool(input, options2);
    else if (tag === "objDesc")
      return this._decodeStr(input, tag, options2);
    else if (tag === "int" || tag === "enum")
      return this._decodeInt(input, state.args && state.args[0], options2);
    if (state.use !== null) {
      return this._getUse(state.use, input._reporterState.obj)._decode(input, options2);
    } else {
      return input.error("unknown tag: " + tag);
    }
  };
  Node.prototype._getUse = function _getUse(entity, obj) {
    var state = this._baseState;
    state.useDecoder = this._use(entity, obj);
    assert(state.useDecoder._baseState.parent === null);
    state.useDecoder = state.useDecoder._baseState.children[0];
    if (state.implicit !== state.useDecoder._baseState.implicit) {
      state.useDecoder = state.useDecoder.clone();
      state.useDecoder._baseState.implicit = state.implicit;
    }
    return state.useDecoder;
  };
  Node.prototype._decodeChoice = function decodeChoice(input, options2) {
    var state = this._baseState;
    var result = null;
    var match = false;
    Object.keys(state.choice).some(function(key2) {
      var save = input.save();
      var node2 = state.choice[key2];
      try {
        var value = node2._decode(input, options2);
        if (input.isError(value))
          return false;
        result = { type: key2, value };
        match = true;
      } catch (e4) {
        input.restore(save);
        return false;
      }
      return true;
    }, this);
    if (!match)
      return input.error("Choice not matched");
    return result;
  };
  Node.prototype._createEncoderBuffer = function createEncoderBuffer(data2) {
    return new EncoderBuffer(data2, this.reporter);
  };
  Node.prototype._encode = function encode2(data2, reporter2, parent) {
    var state = this._baseState;
    if (state["default"] !== null && state["default"] === data2)
      return;
    var result = this._encodeValue(data2, reporter2, parent);
    if (result === void 0)
      return;
    if (this._skipDefault(result, reporter2, parent))
      return;
    return result;
  };
  Node.prototype._encodeValue = function encode2(data2, reporter2, parent) {
    var state = this._baseState;
    if (state.parent === null)
      return state.children[0]._encode(data2, reporter2 || new Reporter());
    var result = null;
    this.reporter = reporter2;
    if (state.optional && data2 === void 0) {
      if (state["default"] !== null)
        data2 = state["default"];
      else
        return;
    }
    var content = null;
    var primitive = false;
    if (state.any) {
      result = this._createEncoderBuffer(data2);
    } else if (state.choice) {
      result = this._encodeChoice(data2, reporter2);
    } else if (state.contains) {
      content = this._getUse(state.contains, parent)._encode(data2, reporter2);
      primitive = true;
    } else if (state.children) {
      content = state.children.map(function(child2) {
        if (child2._baseState.tag === "null_")
          return child2._encode(null, reporter2, data2);
        if (child2._baseState.key === null)
          return reporter2.error("Child should have a key");
        var prevKey = reporter2.enterKey(child2._baseState.key);
        if (typeof data2 !== "object")
          return reporter2.error("Child expected, but input is not object");
        var res = child2._encode(data2[child2._baseState.key], reporter2, data2);
        reporter2.leaveKey(prevKey);
        return res;
      }, this).filter(function(child2) {
        return child2;
      });
      content = this._createEncoderBuffer(content);
    } else {
      if (state.tag === "seqof" || state.tag === "setof") {
        if (!(state.args && state.args.length === 1))
          return reporter2.error("Too many args for : " + state.tag);
        if (!Array.isArray(data2))
          return reporter2.error("seqof/setof, but data is not Array");
        var child = this.clone();
        child._baseState.implicit = null;
        content = this._createEncoderBuffer(data2.map(function(item) {
          var state2 = this._baseState;
          return this._getUse(state2.args[0], data2)._encode(item, reporter2);
        }, child));
      } else if (state.use !== null) {
        result = this._getUse(state.use, parent)._encode(data2, reporter2);
      } else {
        content = this._encodePrimitive(state.tag, data2);
        primitive = true;
      }
    }
    var result;
    if (!state.any && state.choice === null) {
      var tag = state.implicit !== null ? state.implicit : state.tag;
      var cls = state.implicit === null ? "universal" : "context";
      if (tag === null) {
        if (state.use === null)
          reporter2.error("Tag could be omitted only for .use()");
      } else {
        if (state.use === null)
          result = this._encodeComposite(tag, primitive, cls, content);
      }
    }
    if (state.explicit !== null)
      result = this._encodeComposite(state.explicit, false, "context", result);
    return result;
  };
  Node.prototype._encodeChoice = function encodeChoice(data2, reporter2) {
    var state = this._baseState;
    var node2 = state.choice[data2.type];
    if (!node2) {
      assert(
        false,
        data2.type + " not found in " + JSON.stringify(Object.keys(state.choice))
      );
    }
    return node2._encode(data2.value, reporter2);
  };
  Node.prototype._encodePrimitive = function encodePrimitive(tag, data2) {
    var state = this._baseState;
    if (/str$/.test(tag))
      return this._encodeStr(data2, tag);
    else if (tag === "objid" && state.args)
      return this._encodeObjid(data2, state.reverseArgs[0], state.args[1]);
    else if (tag === "objid")
      return this._encodeObjid(data2, null, null);
    else if (tag === "gentime" || tag === "utctime")
      return this._encodeTime(data2, tag);
    else if (tag === "null_")
      return this._encodeNull();
    else if (tag === "int" || tag === "enum")
      return this._encodeInt(data2, state.args && state.reverseArgs[0]);
    else if (tag === "bool")
      return this._encodeBool(data2);
    else if (tag === "objDesc")
      return this._encodeStr(data2, tag);
    else
      throw new Error("Unsupported tag: " + tag);
  };
  Node.prototype._isNumstr = function isNumstr(str) {
    return /^[0-9 ]*$/.test(str);
  };
  Node.prototype._isPrintstr = function isPrintstr(str) {
    return /^[A-Za-z0-9 '\(\)\+,\-\.\/:=\?]*$/.test(str);
  };
  return node;
}
var hasRequiredBase;
function requireBase() {
  if (hasRequiredBase) return base;
  hasRequiredBase = 1;
  (function(exports) {
    var base2 = exports;
    base2.Reporter = requireReporter().Reporter;
    base2.DecoderBuffer = requireBuffer().DecoderBuffer;
    base2.EncoderBuffer = requireBuffer().EncoderBuffer;
    base2.Node = requireNode();
  })(base);
  return base;
}
var constants$1 = {};
var der = {};
var hasRequiredDer$2;
function requireDer$2() {
  if (hasRequiredDer$2) return der;
  hasRequiredDer$2 = 1;
  (function(exports) {
    var constants2 = requireConstants$1();
    exports.tagClass = {
      0: "universal",
      1: "application",
      2: "context",
      3: "private"
    };
    exports.tagClassByName = constants2._reverse(exports.tagClass);
    exports.tag = {
      0: "end",
      1: "bool",
      2: "int",
      3: "bitstr",
      4: "octstr",
      5: "null_",
      6: "objid",
      7: "objDesc",
      8: "external",
      9: "real",
      10: "enum",
      11: "embed",
      12: "utf8str",
      13: "relativeOid",
      16: "seq",
      17: "set",
      18: "numstr",
      19: "printstr",
      20: "t61str",
      21: "videostr",
      22: "ia5str",
      23: "utctime",
      24: "gentime",
      25: "graphstr",
      26: "iso646str",
      27: "genstr",
      28: "unistr",
      29: "charstr",
      30: "bmpstr"
    };
    exports.tagByName = constants2._reverse(exports.tag);
  })(der);
  return der;
}
var hasRequiredConstants$1;
function requireConstants$1() {
  if (hasRequiredConstants$1) return constants$1;
  hasRequiredConstants$1 = 1;
  (function(exports) {
    var constants2 = exports;
    constants2._reverse = function reverse(map) {
      var res = {};
      Object.keys(map).forEach(function(key2) {
        if ((key2 | 0) == key2)
          key2 = key2 | 0;
        var value = map[key2];
        res[value] = key2;
      });
      return res;
    };
    constants2.der = requireDer$2();
  })(constants$1);
  return constants$1;
}
var decoders = {};
var der_1$1;
var hasRequiredDer$1;
function requireDer$1() {
  if (hasRequiredDer$1) return der_1$1;
  hasRequiredDer$1 = 1;
  var inherits = requireInherits_browser();
  var asn12 = requireAsn1$1();
  var base2 = asn12.base;
  var bignum = asn12.bignum;
  var der2 = asn12.constants.der;
  function DERDecoder(entity) {
    this.enc = "der";
    this.name = entity.name;
    this.entity = entity;
    this.tree = new DERNode();
    this.tree._init(entity.body);
  }
  der_1$1 = DERDecoder;
  DERDecoder.prototype.decode = function decode2(data2, options2) {
    if (!(data2 instanceof base2.DecoderBuffer))
      data2 = new base2.DecoderBuffer(data2, options2);
    return this.tree._decode(data2, options2);
  };
  function DERNode(parent) {
    base2.Node.call(this, "der", parent);
  }
  inherits(DERNode, base2.Node);
  DERNode.prototype._peekTag = function peekTag(buffer2, tag, any) {
    if (buffer2.isEmpty())
      return false;
    var state = buffer2.save();
    var decodedTag = derDecodeTag(buffer2, 'Failed to peek tag: "' + tag + '"');
    if (buffer2.isError(decodedTag))
      return decodedTag;
    buffer2.restore(state);
    return decodedTag.tag === tag || decodedTag.tagStr === tag || decodedTag.tagStr + "of" === tag || any;
  };
  DERNode.prototype._decodeTag = function decodeTag(buffer2, tag, any) {
    var decodedTag = derDecodeTag(
      buffer2,
      'Failed to decode tag of "' + tag + '"'
    );
    if (buffer2.isError(decodedTag))
      return decodedTag;
    var len = derDecodeLen(
      buffer2,
      decodedTag.primitive,
      'Failed to get length of "' + tag + '"'
    );
    if (buffer2.isError(len))
      return len;
    if (!any && decodedTag.tag !== tag && decodedTag.tagStr !== tag && decodedTag.tagStr + "of" !== tag) {
      return buffer2.error('Failed to match tag: "' + tag + '"');
    }
    if (decodedTag.primitive || len !== null)
      return buffer2.skip(len, 'Failed to match body of: "' + tag + '"');
    var state = buffer2.save();
    var res = this._skipUntilEnd(
      buffer2,
      'Failed to skip indefinite length body: "' + this.tag + '"'
    );
    if (buffer2.isError(res))
      return res;
    len = buffer2.offset - state.offset;
    buffer2.restore(state);
    return buffer2.skip(len, 'Failed to match body of: "' + tag + '"');
  };
  DERNode.prototype._skipUntilEnd = function skipUntilEnd(buffer2, fail) {
    while (true) {
      var tag = derDecodeTag(buffer2, fail);
      if (buffer2.isError(tag))
        return tag;
      var len = derDecodeLen(buffer2, tag.primitive, fail);
      if (buffer2.isError(len))
        return len;
      var res;
      if (tag.primitive || len !== null)
        res = buffer2.skip(len);
      else
        res = this._skipUntilEnd(buffer2, fail);
      if (buffer2.isError(res))
        return res;
      if (tag.tagStr === "end")
        break;
    }
  };
  DERNode.prototype._decodeList = function decodeList(buffer2, tag, decoder2, options2) {
    var result = [];
    while (!buffer2.isEmpty()) {
      var possibleEnd = this._peekTag(buffer2, "end");
      if (buffer2.isError(possibleEnd))
        return possibleEnd;
      var res = decoder2.decode(buffer2, "der", options2);
      if (buffer2.isError(res) && possibleEnd)
        break;
      result.push(res);
    }
    return result;
  };
  DERNode.prototype._decodeStr = function decodeStr(buffer2, tag) {
    if (tag === "bitstr") {
      var unused = buffer2.readUInt8();
      if (buffer2.isError(unused))
        return unused;
      return { unused, data: buffer2.raw() };
    } else if (tag === "bmpstr") {
      var raw = buffer2.raw();
      if (raw.length % 2 === 1)
        return buffer2.error("Decoding of string type: bmpstr length mismatch");
      var str = "";
      for (var i2 = 0; i2 < raw.length / 2; i2++) {
        str += String.fromCharCode(raw.readUInt16BE(i2 * 2));
      }
      return str;
    } else if (tag === "numstr") {
      var numstr = buffer2.raw().toString("ascii");
      if (!this._isNumstr(numstr)) {
        return buffer2.error("Decoding of string type: numstr unsupported characters");
      }
      return numstr;
    } else if (tag === "octstr") {
      return buffer2.raw();
    } else if (tag === "objDesc") {
      return buffer2.raw();
    } else if (tag === "printstr") {
      var printstr = buffer2.raw().toString("ascii");
      if (!this._isPrintstr(printstr)) {
        return buffer2.error("Decoding of string type: printstr unsupported characters");
      }
      return printstr;
    } else if (/str$/.test(tag)) {
      return buffer2.raw().toString();
    } else {
      return buffer2.error("Decoding of string type: " + tag + " unsupported");
    }
  };
  DERNode.prototype._decodeObjid = function decodeObjid(buffer2, values, relative) {
    var result;
    var identifiers = [];
    var ident = 0;
    while (!buffer2.isEmpty()) {
      var subident = buffer2.readUInt8();
      ident <<= 7;
      ident |= subident & 127;
      if ((subident & 128) === 0) {
        identifiers.push(ident);
        ident = 0;
      }
    }
    if (subident & 128)
      identifiers.push(ident);
    var first = identifiers[0] / 40 | 0;
    var second = identifiers[0] % 40;
    if (relative)
      result = identifiers;
    else
      result = [first, second].concat(identifiers.slice(1));
    if (values) {
      var tmp = values[result.join(" ")];
      if (tmp === void 0)
        tmp = values[result.join(".")];
      if (tmp !== void 0)
        result = tmp;
    }
    return result;
  };
  DERNode.prototype._decodeTime = function decodeTime(buffer2, tag) {
    var str = buffer2.raw().toString();
    if (tag === "gentime") {
      var year = str.slice(0, 4) | 0;
      var mon = str.slice(4, 6) | 0;
      var day = str.slice(6, 8) | 0;
      var hour = str.slice(8, 10) | 0;
      var min2 = str.slice(10, 12) | 0;
      var sec = str.slice(12, 14) | 0;
    } else if (tag === "utctime") {
      var year = str.slice(0, 2) | 0;
      var mon = str.slice(2, 4) | 0;
      var day = str.slice(4, 6) | 0;
      var hour = str.slice(6, 8) | 0;
      var min2 = str.slice(8, 10) | 0;
      var sec = str.slice(10, 12) | 0;
      if (year < 70)
        year = 2e3 + year;
      else
        year = 1900 + year;
    } else {
      return buffer2.error("Decoding " + tag + " time is not supported yet");
    }
    return Date.UTC(year, mon - 1, day, hour, min2, sec, 0);
  };
  DERNode.prototype._decodeNull = function decodeNull(buffer2) {
    return null;
  };
  DERNode.prototype._decodeBool = function decodeBool(buffer2) {
    var res = buffer2.readUInt8();
    if (buffer2.isError(res))
      return res;
    else
      return res !== 0;
  };
  DERNode.prototype._decodeInt = function decodeInt(buffer2, values) {
    var raw = buffer2.raw();
    var res = new bignum(raw);
    if (values)
      res = values[res.toString(10)] || res;
    return res;
  };
  DERNode.prototype._use = function use(entity, obj) {
    if (typeof entity === "function")
      entity = entity(obj);
    return entity._getDecoder("der").tree;
  };
  function derDecodeTag(buf, fail) {
    var tag = buf.readUInt8(fail);
    if (buf.isError(tag))
      return tag;
    var cls = der2.tagClass[tag >> 6];
    var primitive = (tag & 32) === 0;
    if ((tag & 31) === 31) {
      var oct = tag;
      tag = 0;
      while ((oct & 128) === 128) {
        oct = buf.readUInt8(fail);
        if (buf.isError(oct))
          return oct;
        tag <<= 7;
        tag |= oct & 127;
      }
    } else {
      tag &= 31;
    }
    var tagStr = der2.tag[tag];
    return {
      cls,
      primitive,
      tag,
      tagStr
    };
  }
  function derDecodeLen(buf, primitive, fail) {
    var len = buf.readUInt8(fail);
    if (buf.isError(len))
      return len;
    if (!primitive && len === 128)
      return null;
    if ((len & 128) === 0) {
      return len;
    }
    var num = len & 127;
    if (num > 4)
      return buf.error("length octect is too long");
    len = 0;
    for (var i2 = 0; i2 < num; i2++) {
      len <<= 8;
      var j = buf.readUInt8(fail);
      if (buf.isError(j))
        return j;
      len |= j;
    }
    return len;
  }
  return der_1$1;
}
var pem$1;
var hasRequiredPem$1;
function requirePem$1() {
  if (hasRequiredPem$1) return pem$1;
  hasRequiredPem$1 = 1;
  var inherits = requireInherits_browser();
  var Buffer2 = requireBuffer$1().Buffer;
  var DERDecoder = requireDer$1();
  function PEMDecoder(entity) {
    DERDecoder.call(this, entity);
    this.enc = "pem";
  }
  inherits(PEMDecoder, DERDecoder);
  pem$1 = PEMDecoder;
  PEMDecoder.prototype.decode = function decode2(data2, options2) {
    var lines = data2.toString().split(/[\r\n]+/g);
    var label = options2.label.toUpperCase();
    var re = /^-----(BEGIN|END) ([^-]+)-----$/;
    var start = -1;
    var end = -1;
    for (var i2 = 0; i2 < lines.length; i2++) {
      var match = lines[i2].match(re);
      if (match === null)
        continue;
      if (match[2] !== label)
        continue;
      if (start === -1) {
        if (match[1] !== "BEGIN")
          break;
        start = i2;
      } else {
        if (match[1] !== "END")
          break;
        end = i2;
        break;
      }
    }
    if (start === -1 || end === -1)
      throw new Error("PEM section not found for: " + label);
    var base64 = lines.slice(start + 1, end).join("");
    base64.replace(/[^a-z0-9\+\/=]+/gi, "");
    var input = new Buffer2(base64, "base64");
    return DERDecoder.prototype.decode.call(this, input, options2);
  };
  return pem$1;
}
var hasRequiredDecoders;
function requireDecoders() {
  if (hasRequiredDecoders) return decoders;
  hasRequiredDecoders = 1;
  (function(exports) {
    var decoders2 = exports;
    decoders2.der = requireDer$1();
    decoders2.pem = requirePem$1();
  })(decoders);
  return decoders;
}
var encoders = {};
var der_1;
var hasRequiredDer;
function requireDer() {
  if (hasRequiredDer) return der_1;
  hasRequiredDer = 1;
  var inherits = requireInherits_browser();
  var Buffer2 = requireBuffer$1().Buffer;
  var asn12 = requireAsn1$1();
  var base2 = asn12.base;
  var der2 = asn12.constants.der;
  function DEREncoder(entity) {
    this.enc = "der";
    this.name = entity.name;
    this.entity = entity;
    this.tree = new DERNode();
    this.tree._init(entity.body);
  }
  der_1 = DEREncoder;
  DEREncoder.prototype.encode = function encode2(data2, reporter2) {
    return this.tree._encode(data2, reporter2).join();
  };
  function DERNode(parent) {
    base2.Node.call(this, "der", parent);
  }
  inherits(DERNode, base2.Node);
  DERNode.prototype._encodeComposite = function encodeComposite(tag, primitive, cls, content) {
    var encodedTag = encodeTag(tag, primitive, cls, this.reporter);
    if (content.length < 128) {
      var header = new Buffer2(2);
      header[0] = encodedTag;
      header[1] = content.length;
      return this._createEncoderBuffer([header, content]);
    }
    var lenOctets = 1;
    for (var i2 = content.length; i2 >= 256; i2 >>= 8)
      lenOctets++;
    var header = new Buffer2(1 + 1 + lenOctets);
    header[0] = encodedTag;
    header[1] = 128 | lenOctets;
    for (var i2 = 1 + lenOctets, j = content.length; j > 0; i2--, j >>= 8)
      header[i2] = j & 255;
    return this._createEncoderBuffer([header, content]);
  };
  DERNode.prototype._encodeStr = function encodeStr(str, tag) {
    if (tag === "bitstr") {
      return this._createEncoderBuffer([str.unused | 0, str.data]);
    } else if (tag === "bmpstr") {
      var buf = new Buffer2(str.length * 2);
      for (var i2 = 0; i2 < str.length; i2++) {
        buf.writeUInt16BE(str.charCodeAt(i2), i2 * 2);
      }
      return this._createEncoderBuffer(buf);
    } else if (tag === "numstr") {
      if (!this._isNumstr(str)) {
        return this.reporter.error("Encoding of string type: numstr supports only digits and space");
      }
      return this._createEncoderBuffer(str);
    } else if (tag === "printstr") {
      if (!this._isPrintstr(str)) {
        return this.reporter.error("Encoding of string type: printstr supports only latin upper and lower case letters, digits, space, apostrophe, left and rigth parenthesis, plus sign, comma, hyphen, dot, slash, colon, equal sign, question mark");
      }
      return this._createEncoderBuffer(str);
    } else if (/str$/.test(tag)) {
      return this._createEncoderBuffer(str);
    } else if (tag === "objDesc") {
      return this._createEncoderBuffer(str);
    } else {
      return this.reporter.error("Encoding of string type: " + tag + " unsupported");
    }
  };
  DERNode.prototype._encodeObjid = function encodeObjid(id, values, relative) {
    if (typeof id === "string") {
      if (!values)
        return this.reporter.error("string objid given, but no values map found");
      if (!values.hasOwnProperty(id))
        return this.reporter.error("objid not found in values map");
      id = values[id].split(/[\s\.]+/g);
      for (var i2 = 0; i2 < id.length; i2++)
        id[i2] |= 0;
    } else if (Array.isArray(id)) {
      id = id.slice();
      for (var i2 = 0; i2 < id.length; i2++)
        id[i2] |= 0;
    }
    if (!Array.isArray(id)) {
      return this.reporter.error("objid() should be either array or string, got: " + JSON.stringify(id));
    }
    if (!relative) {
      if (id[1] >= 40)
        return this.reporter.error("Second objid identifier OOB");
      id.splice(0, 2, id[0] * 40 + id[1]);
    }
    var size = 0;
    for (var i2 = 0; i2 < id.length; i2++) {
      var ident = id[i2];
      for (size++; ident >= 128; ident >>= 7)
        size++;
    }
    var objid = new Buffer2(size);
    var offset = objid.length - 1;
    for (var i2 = id.length - 1; i2 >= 0; i2--) {
      var ident = id[i2];
      objid[offset--] = ident & 127;
      while ((ident >>= 7) > 0)
        objid[offset--] = 128 | ident & 127;
    }
    return this._createEncoderBuffer(objid);
  };
  function two(num) {
    if (num < 10)
      return "0" + num;
    else
      return num;
  }
  DERNode.prototype._encodeTime = function encodeTime(time, tag) {
    var str;
    var date2 = new Date(time);
    if (tag === "gentime") {
      str = [
        two(date2.getFullYear()),
        two(date2.getUTCMonth() + 1),
        two(date2.getUTCDate()),
        two(date2.getUTCHours()),
        two(date2.getUTCMinutes()),
        two(date2.getUTCSeconds()),
        "Z"
      ].join("");
    } else if (tag === "utctime") {
      str = [
        two(date2.getFullYear() % 100),
        two(date2.getUTCMonth() + 1),
        two(date2.getUTCDate()),
        two(date2.getUTCHours()),
        two(date2.getUTCMinutes()),
        two(date2.getUTCSeconds()),
        "Z"
      ].join("");
    } else {
      this.reporter.error("Encoding " + tag + " time is not supported yet");
    }
    return this._encodeStr(str, "octstr");
  };
  DERNode.prototype._encodeNull = function encodeNull() {
    return this._createEncoderBuffer("");
  };
  DERNode.prototype._encodeInt = function encodeInt(num, values) {
    if (typeof num === "string") {
      if (!values)
        return this.reporter.error("String int or enum given, but no values map");
      if (!values.hasOwnProperty(num)) {
        return this.reporter.error("Values map doesn't contain: " + JSON.stringify(num));
      }
      num = values[num];
    }
    if (typeof num !== "number" && !Buffer2.isBuffer(num)) {
      var numArray = num.toArray();
      if (!num.sign && numArray[0] & 128) {
        numArray.unshift(0);
      }
      num = new Buffer2(numArray);
    }
    if (Buffer2.isBuffer(num)) {
      var size = num.length;
      if (num.length === 0)
        size++;
      var out = new Buffer2(size);
      num.copy(out);
      if (num.length === 0)
        out[0] = 0;
      return this._createEncoderBuffer(out);
    }
    if (num < 128)
      return this._createEncoderBuffer(num);
    if (num < 256)
      return this._createEncoderBuffer([0, num]);
    var size = 1;
    for (var i2 = num; i2 >= 256; i2 >>= 8)
      size++;
    var out = new Array(size);
    for (var i2 = out.length - 1; i2 >= 0; i2--) {
      out[i2] = num & 255;
      num >>= 8;
    }
    if (out[0] & 128) {
      out.unshift(0);
    }
    return this._createEncoderBuffer(new Buffer2(out));
  };
  DERNode.prototype._encodeBool = function encodeBool(value) {
    return this._createEncoderBuffer(value ? 255 : 0);
  };
  DERNode.prototype._use = function use(entity, obj) {
    if (typeof entity === "function")
      entity = entity(obj);
    return entity._getEncoder("der").tree;
  };
  DERNode.prototype._skipDefault = function skipDefault(dataBuffer, reporter2, parent) {
    var state = this._baseState;
    var i2;
    if (state["default"] === null)
      return false;
    var data2 = dataBuffer.join();
    if (state.defaultBuffer === void 0)
      state.defaultBuffer = this._encodeValue(state["default"], reporter2, parent).join();
    if (data2.length !== state.defaultBuffer.length)
      return false;
    for (i2 = 0; i2 < data2.length; i2++)
      if (data2[i2] !== state.defaultBuffer[i2])
        return false;
    return true;
  };
  function encodeTag(tag, primitive, cls, reporter2) {
    var res;
    if (tag === "seqof")
      tag = "seq";
    else if (tag === "setof")
      tag = "set";
    if (der2.tagByName.hasOwnProperty(tag))
      res = der2.tagByName[tag];
    else if (typeof tag === "number" && (tag | 0) === tag)
      res = tag;
    else
      return reporter2.error("Unknown tag: " + tag);
    if (res >= 31)
      return reporter2.error("Multi-octet tag encoding unsupported");
    if (!primitive)
      res |= 32;
    res |= der2.tagClassByName[cls || "universal"] << 6;
    return res;
  }
  return der_1;
}
var pem;
var hasRequiredPem;
function requirePem() {
  if (hasRequiredPem) return pem;
  hasRequiredPem = 1;
  var inherits = requireInherits_browser();
  var DEREncoder = requireDer();
  function PEMEncoder(entity) {
    DEREncoder.call(this, entity);
    this.enc = "pem";
  }
  inherits(PEMEncoder, DEREncoder);
  pem = PEMEncoder;
  PEMEncoder.prototype.encode = function encode2(data2, options2) {
    var buf = DEREncoder.prototype.encode.call(this, data2);
    var p2 = buf.toString("base64");
    var out = ["-----BEGIN " + options2.label + "-----"];
    for (var i2 = 0; i2 < p2.length; i2 += 64)
      out.push(p2.slice(i2, i2 + 64));
    out.push("-----END " + options2.label + "-----");
    return out.join("\n");
  };
  return pem;
}
var hasRequiredEncoders;
function requireEncoders() {
  if (hasRequiredEncoders) return encoders;
  hasRequiredEncoders = 1;
  (function(exports) {
    var encoders2 = exports;
    encoders2.der = requireDer();
    encoders2.pem = requirePem();
  })(encoders);
  return encoders;
}
var hasRequiredAsn1$1;
function requireAsn1$1() {
  if (hasRequiredAsn1$1) return asn1;
  hasRequiredAsn1$1 = 1;
  (function(exports) {
    var asn12 = exports;
    asn12.bignum = requireBn$1();
    asn12.define = requireApi().define;
    asn12.base = requireBase();
    asn12.constants = requireConstants$1();
    asn12.decoders = requireDecoders();
    asn12.encoders = requireEncoders();
  })(asn1);
  return asn1;
}
var certificate;
var hasRequiredCertificate;
function requireCertificate() {
  if (hasRequiredCertificate) return certificate;
  hasRequiredCertificate = 1;
  var asn = requireAsn1$1();
  var Time = asn.define("Time", function() {
    this.choice({
      utcTime: this.utctime(),
      generalTime: this.gentime()
    });
  });
  var AttributeTypeValue = asn.define("AttributeTypeValue", function() {
    this.seq().obj(
      this.key("type").objid(),
      this.key("value").any()
    );
  });
  var AlgorithmIdentifier = asn.define("AlgorithmIdentifier", function() {
    this.seq().obj(
      this.key("algorithm").objid(),
      this.key("parameters").optional(),
      this.key("curve").objid().optional()
    );
  });
  var SubjectPublicKeyInfo = asn.define("SubjectPublicKeyInfo", function() {
    this.seq().obj(
      this.key("algorithm").use(AlgorithmIdentifier),
      this.key("subjectPublicKey").bitstr()
    );
  });
  var RelativeDistinguishedName = asn.define("RelativeDistinguishedName", function() {
    this.setof(AttributeTypeValue);
  });
  var RDNSequence = asn.define("RDNSequence", function() {
    this.seqof(RelativeDistinguishedName);
  });
  var Name = asn.define("Name", function() {
    this.choice({
      rdnSequence: this.use(RDNSequence)
    });
  });
  var Validity = asn.define("Validity", function() {
    this.seq().obj(
      this.key("notBefore").use(Time),
      this.key("notAfter").use(Time)
    );
  });
  var Extension = asn.define("Extension", function() {
    this.seq().obj(
      this.key("extnID").objid(),
      this.key("critical").bool().def(false),
      this.key("extnValue").octstr()
    );
  });
  var TBSCertificate = asn.define("TBSCertificate", function() {
    this.seq().obj(
      this.key("version").explicit(0)["int"]().optional(),
      this.key("serialNumber")["int"](),
      this.key("signature").use(AlgorithmIdentifier),
      this.key("issuer").use(Name),
      this.key("validity").use(Validity),
      this.key("subject").use(Name),
      this.key("subjectPublicKeyInfo").use(SubjectPublicKeyInfo),
      this.key("issuerUniqueID").implicit(1).bitstr().optional(),
      this.key("subjectUniqueID").implicit(2).bitstr().optional(),
      this.key("extensions").explicit(3).seqof(Extension).optional()
    );
  });
  var X509Certificate = asn.define("X509Certificate", function() {
    this.seq().obj(
      this.key("tbsCertificate").use(TBSCertificate),
      this.key("signatureAlgorithm").use(AlgorithmIdentifier),
      this.key("signatureValue").bitstr()
    );
  });
  certificate = X509Certificate;
  return certificate;
}
var hasRequiredAsn1;
function requireAsn1() {
  if (hasRequiredAsn1) return asn1$1;
  hasRequiredAsn1 = 1;
  var asn12 = requireAsn1$1();
  asn1$1.certificate = requireCertificate();
  var RSAPrivateKey = asn12.define("RSAPrivateKey", function() {
    this.seq().obj(
      this.key("version")["int"](),
      this.key("modulus")["int"](),
      this.key("publicExponent")["int"](),
      this.key("privateExponent")["int"](),
      this.key("prime1")["int"](),
      this.key("prime2")["int"](),
      this.key("exponent1")["int"](),
      this.key("exponent2")["int"](),
      this.key("coefficient")["int"]()
    );
  });
  asn1$1.RSAPrivateKey = RSAPrivateKey;
  var RSAPublicKey = asn12.define("RSAPublicKey", function() {
    this.seq().obj(
      this.key("modulus")["int"](),
      this.key("publicExponent")["int"]()
    );
  });
  asn1$1.RSAPublicKey = RSAPublicKey;
  var AlgorithmIdentifier = asn12.define("AlgorithmIdentifier", function() {
    this.seq().obj(
      this.key("algorithm").objid(),
      this.key("none").null_().optional(),
      this.key("curve").objid().optional(),
      this.key("params").seq().obj(
        this.key("p")["int"](),
        this.key("q")["int"](),
        this.key("g")["int"]()
      ).optional()
    );
  });
  var PublicKey = asn12.define("SubjectPublicKeyInfo", function() {
    this.seq().obj(
      this.key("algorithm").use(AlgorithmIdentifier),
      this.key("subjectPublicKey").bitstr()
    );
  });
  asn1$1.PublicKey = PublicKey;
  var PrivateKeyInfo = asn12.define("PrivateKeyInfo", function() {
    this.seq().obj(
      this.key("version")["int"](),
      this.key("algorithm").use(AlgorithmIdentifier),
      this.key("subjectPrivateKey").octstr()
    );
  });
  asn1$1.PrivateKey = PrivateKeyInfo;
  var EncryptedPrivateKeyInfo = asn12.define("EncryptedPrivateKeyInfo", function() {
    this.seq().obj(
      this.key("algorithm").seq().obj(
        this.key("id").objid(),
        this.key("decrypt").seq().obj(
          this.key("kde").seq().obj(
            this.key("id").objid(),
            this.key("kdeparams").seq().obj(
              this.key("salt").octstr(),
              this.key("iters")["int"]()
            )
          ),
          this.key("cipher").seq().obj(
            this.key("algo").objid(),
            this.key("iv").octstr()
          )
        )
      ),
      this.key("subjectPrivateKey").octstr()
    );
  });
  asn1$1.EncryptedPrivateKey = EncryptedPrivateKeyInfo;
  var DSAPrivateKey = asn12.define("DSAPrivateKey", function() {
    this.seq().obj(
      this.key("version")["int"](),
      this.key("p")["int"](),
      this.key("q")["int"](),
      this.key("g")["int"](),
      this.key("pub_key")["int"](),
      this.key("priv_key")["int"]()
    );
  });
  asn1$1.DSAPrivateKey = DSAPrivateKey;
  asn1$1.DSAparam = asn12.define("DSAparam", function() {
    this["int"]();
  });
  var ECParameters = asn12.define("ECParameters", function() {
    this.choice({
      namedCurve: this.objid()
    });
  });
  var ECPrivateKey = asn12.define("ECPrivateKey", function() {
    this.seq().obj(
      this.key("version")["int"](),
      this.key("privateKey").octstr(),
      this.key("parameters").optional().explicit(0).use(ECParameters),
      this.key("publicKey").optional().explicit(1).bitstr()
    );
  });
  asn1$1.ECPrivateKey = ECPrivateKey;
  asn1$1.signature = asn12.define("signature", function() {
    this.seq().obj(
      this.key("r")["int"](),
      this.key("s")["int"]()
    );
  });
  return asn1$1;
}
const require$$1 = {
  "2.16.840.1.101.3.4.1.1": "aes-128-ecb",
  "2.16.840.1.101.3.4.1.2": "aes-128-cbc",
  "2.16.840.1.101.3.4.1.3": "aes-128-ofb",
  "2.16.840.1.101.3.4.1.4": "aes-128-cfb",
  "2.16.840.1.101.3.4.1.21": "aes-192-ecb",
  "2.16.840.1.101.3.4.1.22": "aes-192-cbc",
  "2.16.840.1.101.3.4.1.23": "aes-192-ofb",
  "2.16.840.1.101.3.4.1.24": "aes-192-cfb",
  "2.16.840.1.101.3.4.1.41": "aes-256-ecb",
  "2.16.840.1.101.3.4.1.42": "aes-256-cbc",
  "2.16.840.1.101.3.4.1.43": "aes-256-ofb",
  "2.16.840.1.101.3.4.1.44": "aes-256-cfb"
};
var fixProc;
var hasRequiredFixProc;
function requireFixProc() {
  if (hasRequiredFixProc) return fixProc;
  hasRequiredFixProc = 1;
  var findProc = /Proc-Type: 4,ENCRYPTED[\n\r]+DEK-Info: AES-((?:128)|(?:192)|(?:256))-CBC,([0-9A-H]+)[\n\r]+([0-9A-z\n\r+/=]+)[\n\r]+/m;
  var startRegex = /^-----BEGIN ((?:.*? KEY)|CERTIFICATE)-----/m;
  var fullRegex = /^-----BEGIN ((?:.*? KEY)|CERTIFICATE)-----([0-9A-z\n\r+/=]+)-----END \1-----$/m;
  var evp = requireEvp_bytestokey();
  var ciphers = requireBrowser$9();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  fixProc = function(okey, password) {
    var key2 = okey.toString();
    var match = key2.match(findProc);
    var decrypted;
    if (!match) {
      var match2 = key2.match(fullRegex);
      decrypted = Buffer2.from(match2[2].replace(/[\r\n]/g, ""), "base64");
    } else {
      var suite = "aes" + match[1];
      var iv = Buffer2.from(match[2], "hex");
      var cipherText = Buffer2.from(match[3].replace(/[\r\n]/g, ""), "base64");
      var cipherKey = evp(password, iv.slice(0, 8), parseInt(match[1], 10)).key;
      var out = [];
      var cipher2 = ciphers.createDecipheriv(suite, cipherKey, iv);
      out.push(cipher2.update(cipherText));
      out.push(cipher2["final"]());
      decrypted = Buffer2.concat(out);
    }
    var tag = key2.match(startRegex)[1];
    return {
      tag,
      data: decrypted
    };
  };
  return fixProc;
}
var parseAsn1;
var hasRequiredParseAsn1;
function requireParseAsn1() {
  if (hasRequiredParseAsn1) return parseAsn1;
  hasRequiredParseAsn1 = 1;
  var asn12 = requireAsn1();
  var aesid = require$$1;
  var fixProc2 = requireFixProc();
  var ciphers = requireBrowser$9();
  var pbkdf2Sync = requireBrowser$a().pbkdf2Sync;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  function decrypt2(data2, password) {
    var salt = data2.algorithm.decrypt.kde.kdeparams.salt;
    var iters = parseInt(data2.algorithm.decrypt.kde.kdeparams.iters.toString(), 10);
    var algo = aesid[data2.algorithm.decrypt.cipher.algo.join(".")];
    var iv = data2.algorithm.decrypt.cipher.iv;
    var cipherText = data2.subjectPrivateKey;
    var keylen = parseInt(algo.split("-")[1], 10) / 8;
    var key2 = pbkdf2Sync(password, salt, iters, keylen, "sha1");
    var cipher2 = ciphers.createDecipheriv(algo, key2, iv);
    var out = [];
    out.push(cipher2.update(cipherText));
    out.push(cipher2["final"]());
    return Buffer2.concat(out);
  }
  function parseKeys(buffer2) {
    var password;
    if (typeof buffer2 === "object" && !Buffer2.isBuffer(buffer2)) {
      password = buffer2.passphrase;
      buffer2 = buffer2.key;
    }
    if (typeof buffer2 === "string") {
      buffer2 = Buffer2.from(buffer2);
    }
    var stripped = fixProc2(buffer2, password);
    var type2 = stripped.tag;
    var data2 = stripped.data;
    var subtype, ndata;
    switch (type2) {
      case "CERTIFICATE":
        ndata = asn12.certificate.decode(data2, "der").tbsCertificate.subjectPublicKeyInfo;
      // falls through
      case "PUBLIC KEY":
        if (!ndata) {
          ndata = asn12.PublicKey.decode(data2, "der");
        }
        subtype = ndata.algorithm.algorithm.join(".");
        switch (subtype) {
          case "1.2.840.113549.1.1.1":
            return asn12.RSAPublicKey.decode(ndata.subjectPublicKey.data, "der");
          case "1.2.840.10045.2.1":
            ndata.subjectPrivateKey = ndata.subjectPublicKey;
            return {
              type: "ec",
              data: ndata
            };
          case "1.2.840.10040.4.1":
            ndata.algorithm.params.pub_key = asn12.DSAparam.decode(ndata.subjectPublicKey.data, "der");
            return {
              type: "dsa",
              data: ndata.algorithm.params
            };
          default:
            throw new Error("unknown key id " + subtype);
        }
      // throw new Error('unknown key type ' + type)
      case "ENCRYPTED PRIVATE KEY":
        data2 = asn12.EncryptedPrivateKey.decode(data2, "der");
        data2 = decrypt2(data2, password);
      // falls through
      case "PRIVATE KEY":
        ndata = asn12.PrivateKey.decode(data2, "der");
        subtype = ndata.algorithm.algorithm.join(".");
        switch (subtype) {
          case "1.2.840.113549.1.1.1":
            return asn12.RSAPrivateKey.decode(ndata.subjectPrivateKey, "der");
          case "1.2.840.10045.2.1":
            return {
              curve: ndata.algorithm.curve,
              privateKey: asn12.ECPrivateKey.decode(ndata.subjectPrivateKey, "der").privateKey
            };
          case "1.2.840.10040.4.1":
            ndata.algorithm.params.priv_key = asn12.DSAparam.decode(ndata.subjectPrivateKey, "der");
            return {
              type: "dsa",
              params: ndata.algorithm.params
            };
          default:
            throw new Error("unknown key id " + subtype);
        }
      // throw new Error('unknown key type ' + type)
      case "RSA PUBLIC KEY":
        return asn12.RSAPublicKey.decode(data2, "der");
      case "RSA PRIVATE KEY":
        return asn12.RSAPrivateKey.decode(data2, "der");
      case "DSA PRIVATE KEY":
        return {
          type: "dsa",
          params: asn12.DSAPrivateKey.decode(data2, "der")
        };
      case "EC PRIVATE KEY":
        data2 = asn12.ECPrivateKey.decode(data2, "der");
        return {
          curve: data2.parameters.value,
          privateKey: data2.privateKey
        };
      default:
        throw new Error("unknown key type " + type2);
    }
  }
  parseKeys.signature = asn12.signature;
  parseAsn1 = parseKeys;
  return parseAsn1;
}
const require$$4 = {
  "1.3.132.0.10": "secp256k1",
  "1.3.132.0.33": "p224",
  "1.2.840.10045.3.1.1": "p192",
  "1.2.840.10045.3.1.7": "p256",
  "1.3.132.0.34": "p384",
  "1.3.132.0.35": "p521"
};
var hasRequiredSign;
function requireSign() {
  if (hasRequiredSign) return sign.exports;
  hasRequiredSign = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var createHmac = requireBrowser$b();
  var crt = /* @__PURE__ */ requireBrowserifyRsa();
  var EC = requireElliptic().ec;
  var BN = requireBn();
  var parseKeys = requireParseAsn1();
  var curves2 = require$$4;
  var RSA_PKCS1_PADDING = 1;
  function sign$12(hash2, key2, hashType, signType, tag) {
    var priv = parseKeys(key2);
    if (priv.curve) {
      if (signType !== "ecdsa" && signType !== "ecdsa/rsa") {
        throw new Error("wrong private key type");
      }
      return ecSign(hash2, priv);
    } else if (priv.type === "dsa") {
      if (signType !== "dsa") {
        throw new Error("wrong private key type");
      }
      return dsaSign(hash2, priv, hashType);
    }
    if (signType !== "rsa" && signType !== "ecdsa/rsa") {
      throw new Error("wrong private key type");
    }
    if (key2.padding !== void 0 && key2.padding !== RSA_PKCS1_PADDING) {
      throw new Error("illegal or unsupported padding mode");
    }
    hash2 = Buffer2.concat([tag, hash2]);
    var len = priv.modulus.byteLength();
    var pad = [0, 1];
    while (hash2.length + pad.length + 1 < len) {
      pad.push(255);
    }
    pad.push(0);
    var i2 = -1;
    while (++i2 < hash2.length) {
      pad.push(hash2[i2]);
    }
    var out = crt(pad, priv);
    return out;
  }
  function ecSign(hash2, priv) {
    var curveId = curves2[priv.curve.join(".")];
    if (!curveId) {
      throw new Error("unknown curve " + priv.curve.join("."));
    }
    var curve2 = new EC(curveId);
    var key2 = curve2.keyFromPrivate(priv.privateKey);
    var out = key2.sign(hash2);
    return Buffer2.from(out.toDER());
  }
  function dsaSign(hash2, priv, algo) {
    var x2 = priv.params.priv_key;
    var p2 = priv.params.p;
    var q = priv.params.q;
    var g = priv.params.g;
    var r2 = new BN(0);
    var k2;
    var H = bits2int(hash2, q).mod(q);
    var s2 = false;
    var kv = getKey(x2, q, hash2, algo);
    while (s2 === false) {
      k2 = makeKey(q, kv, algo);
      r2 = makeR(g, k2, p2, q);
      s2 = k2.invm(q).imul(H.add(x2.mul(r2))).mod(q);
      if (s2.cmpn(0) === 0) {
        s2 = false;
        r2 = new BN(0);
      }
    }
    return toDER(r2, s2);
  }
  function toDER(r2, s2) {
    r2 = r2.toArray();
    s2 = s2.toArray();
    if (r2[0] & 128) {
      r2 = [0].concat(r2);
    }
    if (s2[0] & 128) {
      s2 = [0].concat(s2);
    }
    var total = r2.length + s2.length + 4;
    var res = [
      48,
      total,
      2,
      r2.length
    ];
    res = res.concat(r2, [2, s2.length], s2);
    return Buffer2.from(res);
  }
  function getKey(x2, q, hash2, algo) {
    x2 = Buffer2.from(x2.toArray());
    if (x2.length < q.byteLength()) {
      var zeros = Buffer2.alloc(q.byteLength() - x2.length);
      x2 = Buffer2.concat([zeros, x2]);
    }
    var hlen = hash2.length;
    var hbits = bits2octets(hash2, q);
    var v2 = Buffer2.alloc(hlen);
    v2.fill(1);
    var k2 = Buffer2.alloc(hlen);
    k2 = createHmac(algo, k2).update(v2).update(Buffer2.from([0])).update(x2).update(hbits).digest();
    v2 = createHmac(algo, k2).update(v2).digest();
    k2 = createHmac(algo, k2).update(v2).update(Buffer2.from([1])).update(x2).update(hbits).digest();
    v2 = createHmac(algo, k2).update(v2).digest();
    return { k: k2, v: v2 };
  }
  function bits2int(obits, q) {
    var bits = new BN(obits);
    var shift = (obits.length << 3) - q.bitLength();
    if (shift > 0) {
      bits.ishrn(shift);
    }
    return bits;
  }
  function bits2octets(bits, q) {
    bits = bits2int(bits, q);
    bits = bits.mod(q);
    var out = Buffer2.from(bits.toArray());
    if (out.length < q.byteLength()) {
      var zeros = Buffer2.alloc(q.byteLength() - out.length);
      out = Buffer2.concat([zeros, out]);
    }
    return out;
  }
  function makeKey(q, kv, algo) {
    var t2;
    var k2;
    do {
      t2 = Buffer2.alloc(0);
      while (t2.length * 8 < q.bitLength()) {
        kv.v = createHmac(algo, kv.k).update(kv.v).digest();
        t2 = Buffer2.concat([t2, kv.v]);
      }
      k2 = bits2int(t2, q);
      kv.k = createHmac(algo, kv.k).update(kv.v).update(Buffer2.from([0])).digest();
      kv.v = createHmac(algo, kv.k).update(kv.v).digest();
    } while (k2.cmp(q) !== -1);
    return k2;
  }
  function makeR(g, k2, p2, q) {
    return g.toRed(BN.mont(p2)).redPow(k2).fromRed().mod(q);
  }
  sign.exports = sign$12;
  sign.exports.getKey = getKey;
  sign.exports.makeKey = makeKey;
  return sign.exports;
}
var verify_1;
var hasRequiredVerify;
function requireVerify() {
  if (hasRequiredVerify) return verify_1;
  hasRequiredVerify = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var BN = requireBn();
  var EC = requireElliptic().ec;
  var parseKeys = requireParseAsn1();
  var curves2 = require$$4;
  function verify(sig, hash2, key2, signType, tag) {
    var pub = parseKeys(key2);
    if (pub.type === "ec") {
      if (signType !== "ecdsa" && signType !== "ecdsa/rsa") {
        throw new Error("wrong public key type");
      }
      return ecVerify(sig, hash2, pub);
    } else if (pub.type === "dsa") {
      if (signType !== "dsa") {
        throw new Error("wrong public key type");
      }
      return dsaVerify(sig, hash2, pub);
    }
    if (signType !== "rsa" && signType !== "ecdsa/rsa") {
      throw new Error("wrong public key type");
    }
    hash2 = Buffer2.concat([tag, hash2]);
    var len = pub.modulus.byteLength();
    var pad = [1];
    var padNum = 0;
    while (hash2.length + pad.length + 2 < len) {
      pad.push(255);
      padNum += 1;
    }
    pad.push(0);
    var i2 = -1;
    while (++i2 < hash2.length) {
      pad.push(hash2[i2]);
    }
    pad = Buffer2.from(pad);
    var red = BN.mont(pub.modulus);
    sig = new BN(sig).toRed(red);
    sig = sig.redPow(new BN(pub.publicExponent));
    sig = Buffer2.from(sig.fromRed().toArray());
    var out = padNum < 8 ? 1 : 0;
    len = Math.min(sig.length, pad.length);
    if (sig.length !== pad.length) {
      out = 1;
    }
    i2 = -1;
    while (++i2 < len) {
      out |= sig[i2] ^ pad[i2];
    }
    return out === 0;
  }
  function ecVerify(sig, hash2, pub) {
    var curveId = curves2[pub.data.algorithm.curve.join(".")];
    if (!curveId) {
      throw new Error("unknown curve " + pub.data.algorithm.curve.join("."));
    }
    var curve2 = new EC(curveId);
    var pubkey = pub.data.subjectPrivateKey.data;
    return curve2.verify(hash2, sig, pubkey);
  }
  function dsaVerify(sig, hash2, pub) {
    var p2 = pub.data.p;
    var q = pub.data.q;
    var g = pub.data.g;
    var y2 = pub.data.pub_key;
    var unpacked = parseKeys.signature.decode(sig, "der");
    var s2 = unpacked.s;
    var r2 = unpacked.r;
    checkValue(s2, q);
    checkValue(r2, q);
    var montp = BN.mont(p2);
    var w = s2.invm(q);
    var v2 = g.toRed(montp).redPow(new BN(hash2).mul(w).mod(q)).fromRed().mul(y2.toRed(montp).redPow(r2.mul(w).mod(q)).fromRed()).mod(p2).mod(q);
    return v2.cmp(r2) === 0;
  }
  function checkValue(b2, q) {
    if (b2.cmpn(0) <= 0) {
      throw new Error("invalid sig");
    }
    if (b2.cmp(q) >= 0) {
      throw new Error("invalid sig");
    }
  }
  verify_1 = verify;
  return verify_1;
}
var browser$8;
var hasRequiredBrowser$6;
function requireBrowser$6() {
  if (hasRequiredBrowser$6) return browser$8;
  hasRequiredBrowser$6 = 1;
  var Buffer2 = requireSafeBuffer$1().Buffer;
  var createHash = requireBrowser$c();
  var stream2 = requireReadableBrowser();
  var inherits = requireInherits_browser();
  var sign2 = requireSign();
  var verify = requireVerify();
  var algorithms = require$$6;
  Object.keys(algorithms).forEach(function(key2) {
    algorithms[key2].id = Buffer2.from(algorithms[key2].id, "hex");
    algorithms[key2.toLowerCase()] = algorithms[key2];
  });
  function Sign(algorithm) {
    stream2.Writable.call(this);
    var data2 = algorithms[algorithm];
    if (!data2) {
      throw new Error("Unknown message digest");
    }
    this._hashType = data2.hash;
    this._hash = createHash(data2.hash);
    this._tag = data2.id;
    this._signType = data2.sign;
  }
  inherits(Sign, stream2.Writable);
  Sign.prototype._write = function _write(data2, _2, done) {
    this._hash.update(data2);
    done();
  };
  Sign.prototype.update = function update(data2, enc) {
    this._hash.update(typeof data2 === "string" ? Buffer2.from(data2, enc) : data2);
    return this;
  };
  Sign.prototype.sign = function signMethod(key2, enc) {
    this.end();
    var hash2 = this._hash.digest();
    var sig = sign2(hash2, key2, this._hashType, this._signType, this._tag);
    return enc ? sig.toString(enc) : sig;
  };
  function Verify(algorithm) {
    stream2.Writable.call(this);
    var data2 = algorithms[algorithm];
    if (!data2) {
      throw new Error("Unknown message digest");
    }
    this._hash = createHash(data2.hash);
    this._tag = data2.id;
    this._signType = data2.sign;
  }
  inherits(Verify, stream2.Writable);
  Verify.prototype._write = function _write(data2, _2, done) {
    this._hash.update(data2);
    done();
  };
  Verify.prototype.update = function update(data2, enc) {
    this._hash.update(typeof data2 === "string" ? Buffer2.from(data2, enc) : data2);
    return this;
  };
  Verify.prototype.verify = function verifyMethod(key2, sig, enc) {
    var sigBuffer = typeof sig === "string" ? Buffer2.from(sig, enc) : sig;
    this.end();
    var hash2 = this._hash.digest();
    return verify(sigBuffer, hash2, key2, this._signType, this._tag);
  };
  function createSign(algorithm) {
    return new Sign(algorithm);
  }
  function createVerify(algorithm) {
    return new Verify(algorithm);
  }
  browser$8 = {
    Sign: createSign,
    Verify: createVerify,
    createSign,
    createVerify
  };
  return browser$8;
}
var browser$7;
var hasRequiredBrowser$5;
function requireBrowser$5() {
  if (hasRequiredBrowser$5) return browser$7;
  hasRequiredBrowser$5 = 1;
  var elliptic2 = requireElliptic();
  var BN = requireBn$1();
  browser$7 = function createECDH(curve2) {
    return new ECDH(curve2);
  };
  var aliases = {
    secp256k1: {
      name: "secp256k1",
      byteLength: 32
    },
    secp224r1: {
      name: "p224",
      byteLength: 28
    },
    prime256v1: {
      name: "p256",
      byteLength: 32
    },
    prime192v1: {
      name: "p192",
      byteLength: 24
    },
    ed25519: {
      name: "ed25519",
      byteLength: 32
    },
    secp384r1: {
      name: "p384",
      byteLength: 48
    },
    secp521r1: {
      name: "p521",
      byteLength: 66
    }
  };
  aliases.p224 = aliases.secp224r1;
  aliases.p256 = aliases.secp256r1 = aliases.prime256v1;
  aliases.p192 = aliases.secp192r1 = aliases.prime192v1;
  aliases.p384 = aliases.secp384r1;
  aliases.p521 = aliases.secp521r1;
  function ECDH(curve2) {
    this.curveType = aliases[curve2];
    if (!this.curveType) {
      this.curveType = {
        name: curve2
      };
    }
    this.curve = new elliptic2.ec(this.curveType.name);
    this.keys = void 0;
  }
  ECDH.prototype.generateKeys = function(enc, format2) {
    this.keys = this.curve.genKeyPair();
    return this.getPublicKey(enc, format2);
  };
  ECDH.prototype.computeSecret = function(other, inenc, enc) {
    inenc = inenc || "utf8";
    if (!Buffer.isBuffer(other)) {
      other = new Buffer(other, inenc);
    }
    var otherPub = this.curve.keyFromPublic(other).getPublic();
    var out = otherPub.mul(this.keys.getPrivate()).getX();
    return formatReturnValue(out, enc, this.curveType.byteLength);
  };
  ECDH.prototype.getPublicKey = function(enc, format2) {
    var key2 = this.keys.getPublic(format2 === "compressed", true);
    if (format2 === "hybrid") {
      if (key2[key2.length - 1] % 2) {
        key2[0] = 7;
      } else {
        key2[0] = 6;
      }
    }
    return formatReturnValue(key2, enc);
  };
  ECDH.prototype.getPrivateKey = function(enc) {
    return formatReturnValue(this.keys.getPrivate(), enc);
  };
  ECDH.prototype.setPublicKey = function(pub, enc) {
    enc = enc || "utf8";
    if (!Buffer.isBuffer(pub)) {
      pub = new Buffer(pub, enc);
    }
    this.keys._importPublic(pub);
    return this;
  };
  ECDH.prototype.setPrivateKey = function(priv, enc) {
    enc = enc || "utf8";
    if (!Buffer.isBuffer(priv)) {
      priv = new Buffer(priv, enc);
    }
    var _priv = new BN(priv);
    _priv = _priv.toString(16);
    this.keys = this.curve.genKeyPair();
    this.keys._importPrivate(_priv);
    return this;
  };
  function formatReturnValue(bn2, enc, len) {
    if (!Array.isArray(bn2)) {
      bn2 = bn2.toArray();
    }
    var buf = new Buffer(bn2);
    if (len && buf.length < len) {
      var zeros = new Buffer(len - buf.length);
      zeros.fill(0);
      buf = Buffer.concat([zeros, buf]);
    }
    if (!enc) {
      return buf;
    } else {
      return buf.toString(enc);
    }
  }
  return browser$7;
}
var browser$6 = {};
var mgf;
var hasRequiredMgf;
function requireMgf() {
  if (hasRequiredMgf) return mgf;
  hasRequiredMgf = 1;
  var createHash = requireBrowser$c();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  mgf = function(seed, len) {
    var t2 = Buffer2.alloc(0);
    var i2 = 0;
    var c2;
    while (t2.length < len) {
      c2 = i2ops(i2++);
      t2 = Buffer2.concat([t2, createHash("sha1").update(seed).update(c2).digest()]);
    }
    return t2.slice(0, len);
  };
  function i2ops(c2) {
    var out = Buffer2.allocUnsafe(4);
    out.writeUInt32BE(c2, 0);
    return out;
  }
  return mgf;
}
var xor$1;
var hasRequiredXor;
function requireXor() {
  if (hasRequiredXor) return xor$1;
  hasRequiredXor = 1;
  xor$1 = function xor2(a2, b2) {
    var len = a2.length;
    var i2 = -1;
    while (++i2 < len) {
      a2[i2] ^= b2[i2];
    }
    return a2;
  };
  return xor$1;
}
var withPublic_1;
var hasRequiredWithPublic;
function requireWithPublic() {
  if (hasRequiredWithPublic) return withPublic_1;
  hasRequiredWithPublic = 1;
  var BN = requireBn$1();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  function withPublic(paddedMsg, key2) {
    return Buffer2.from(paddedMsg.toRed(BN.mont(key2.modulus)).redPow(new BN(key2.publicExponent)).fromRed().toArray());
  }
  withPublic_1 = withPublic;
  return withPublic_1;
}
var publicEncrypt;
var hasRequiredPublicEncrypt;
function requirePublicEncrypt() {
  if (hasRequiredPublicEncrypt) return publicEncrypt;
  hasRequiredPublicEncrypt = 1;
  var parseKeys = requireParseAsn1();
  var randomBytes = requireBrowser$e();
  var createHash = requireBrowser$c();
  var mgf2 = requireMgf();
  var xor2 = requireXor();
  var BN = requireBn$1();
  var withPublic = requireWithPublic();
  var crt = /* @__PURE__ */ requireBrowserifyRsa();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  publicEncrypt = function publicEncrypt2(publicKey2, msg, reverse) {
    var padding;
    if (publicKey2.padding) {
      padding = publicKey2.padding;
    } else if (reverse) {
      padding = 1;
    } else {
      padding = 4;
    }
    var key2 = parseKeys(publicKey2);
    var paddedMsg;
    if (padding === 4) {
      paddedMsg = oaep(key2, msg);
    } else if (padding === 1) {
      paddedMsg = pkcs1(key2, msg, reverse);
    } else if (padding === 3) {
      paddedMsg = new BN(msg);
      if (paddedMsg.cmp(key2.modulus) >= 0) {
        throw new Error("data too long for modulus");
      }
    } else {
      throw new Error("unknown padding");
    }
    if (reverse) {
      return crt(paddedMsg, key2);
    } else {
      return withPublic(paddedMsg, key2);
    }
  };
  function oaep(key2, msg) {
    var k2 = key2.modulus.byteLength();
    var mLen = msg.length;
    var iHash = createHash("sha1").update(Buffer2.alloc(0)).digest();
    var hLen = iHash.length;
    var hLen2 = 2 * hLen;
    if (mLen > k2 - hLen2 - 2) {
      throw new Error("message too long");
    }
    var ps = Buffer2.alloc(k2 - mLen - hLen2 - 2);
    var dblen = k2 - hLen - 1;
    var seed = randomBytes(hLen);
    var maskedDb = xor2(Buffer2.concat([iHash, ps, Buffer2.alloc(1, 1), msg], dblen), mgf2(seed, dblen));
    var maskedSeed = xor2(seed, mgf2(maskedDb, hLen));
    return new BN(Buffer2.concat([Buffer2.alloc(1), maskedSeed, maskedDb], k2));
  }
  function pkcs1(key2, msg, reverse) {
    var mLen = msg.length;
    var k2 = key2.modulus.byteLength();
    if (mLen > k2 - 11) {
      throw new Error("message too long");
    }
    var ps;
    if (reverse) {
      ps = Buffer2.alloc(k2 - mLen - 3, 255);
    } else {
      ps = nonZero(k2 - mLen - 3);
    }
    return new BN(Buffer2.concat([Buffer2.from([0, reverse ? 1 : 2]), ps, Buffer2.alloc(1), msg], k2));
  }
  function nonZero(len) {
    var out = Buffer2.allocUnsafe(len);
    var i2 = 0;
    var cache2 = randomBytes(len * 2);
    var cur = 0;
    var num;
    while (i2 < len) {
      if (cur === cache2.length) {
        cache2 = randomBytes(len * 2);
        cur = 0;
      }
      num = cache2[cur++];
      if (num) {
        out[i2++] = num;
      }
    }
    return out;
  }
  return publicEncrypt;
}
var privateDecrypt;
var hasRequiredPrivateDecrypt;
function requirePrivateDecrypt() {
  if (hasRequiredPrivateDecrypt) return privateDecrypt;
  hasRequiredPrivateDecrypt = 1;
  var parseKeys = requireParseAsn1();
  var mgf2 = requireMgf();
  var xor2 = requireXor();
  var BN = requireBn$1();
  var crt = /* @__PURE__ */ requireBrowserifyRsa();
  var createHash = requireBrowser$c();
  var withPublic = requireWithPublic();
  var Buffer2 = requireSafeBuffer$1().Buffer;
  privateDecrypt = function privateDecrypt2(privateKey, enc, reverse) {
    var padding;
    if (privateKey.padding) {
      padding = privateKey.padding;
    } else if (reverse) {
      padding = 1;
    } else {
      padding = 4;
    }
    var key2 = parseKeys(privateKey);
    var k2 = key2.modulus.byteLength();
    if (enc.length > k2 || new BN(enc).cmp(key2.modulus) >= 0) {
      throw new Error("decryption error");
    }
    var msg;
    if (reverse) {
      msg = withPublic(new BN(enc), key2);
    } else {
      msg = crt(enc, key2);
    }
    var zBuffer = Buffer2.alloc(k2 - msg.length);
    msg = Buffer2.concat([zBuffer, msg], k2);
    if (padding === 4) {
      return oaep(key2, msg);
    } else if (padding === 1) {
      return pkcs1(key2, msg, reverse);
    } else if (padding === 3) {
      return msg;
    } else {
      throw new Error("unknown padding");
    }
  };
  function oaep(key2, msg) {
    var k2 = key2.modulus.byteLength();
    var iHash = createHash("sha1").update(Buffer2.alloc(0)).digest();
    var hLen = iHash.length;
    if (msg[0] !== 0) {
      throw new Error("decryption error");
    }
    var maskedSeed = msg.slice(1, hLen + 1);
    var maskedDb = msg.slice(hLen + 1);
    var seed = xor2(maskedSeed, mgf2(maskedDb, hLen));
    var db = xor2(maskedDb, mgf2(seed, k2 - hLen - 1));
    if (compare(iHash, db.slice(0, hLen))) {
      throw new Error("decryption error");
    }
    var i2 = hLen;
    while (db[i2] === 0) {
      i2++;
    }
    if (db[i2++] !== 1) {
      throw new Error("decryption error");
    }
    return db.slice(i2);
  }
  function pkcs1(key2, msg, reverse) {
    var p1 = msg.slice(0, 2);
    var i2 = 2;
    var status = 0;
    while (msg[i2++] !== 0) {
      if (i2 >= msg.length) {
        status++;
        break;
      }
    }
    var ps = msg.slice(2, i2 - 1);
    if (p1.toString("hex") !== "0002" && !reverse || p1.toString("hex") !== "0001" && reverse) {
      status++;
    }
    if (ps.length < 8) {
      status++;
    }
    if (status) {
      throw new Error("decryption error");
    }
    return msg.slice(i2);
  }
  function compare(a2, b2) {
    a2 = Buffer2.from(a2);
    b2 = Buffer2.from(b2);
    var dif = 0;
    var len = a2.length;
    if (a2.length !== b2.length) {
      dif++;
      len = Math.min(a2.length, b2.length);
    }
    var i2 = -1;
    while (++i2 < len) {
      dif += a2[i2] ^ b2[i2];
    }
    return dif;
  }
  return privateDecrypt;
}
var hasRequiredBrowser$4;
function requireBrowser$4() {
  if (hasRequiredBrowser$4) return browser$6;
  hasRequiredBrowser$4 = 1;
  (function(exports) {
    exports.publicEncrypt = requirePublicEncrypt();
    exports.privateDecrypt = requirePrivateDecrypt();
    exports.privateEncrypt = function privateEncrypt(key2, buf) {
      return exports.publicEncrypt(key2, buf, true);
    };
    exports.publicDecrypt = function publicDecrypt(key2, buf) {
      return exports.privateDecrypt(key2, buf, true);
    };
  })(browser$6);
  return browser$6;
}
var browser$5 = {};
var hasRequiredBrowser$3;
function requireBrowser$3() {
  if (hasRequiredBrowser$3) return browser$5;
  hasRequiredBrowser$3 = 1;
  function oldBrowser() {
    throw new Error("secure random number generation not supported by this browser\nuse chrome, FireFox or Internet Explorer 11");
  }
  var safeBuffer2 = requireSafeBuffer$1();
  var randombytes = requireBrowser$e();
  var Buffer2 = safeBuffer2.Buffer;
  var kBufferMaxLength = safeBuffer2.kMaxLength;
  var crypto2 = commonjsGlobal$1.crypto || commonjsGlobal$1.msCrypto;
  var kMaxUint32 = Math.pow(2, 32) - 1;
  function assertOffset(offset, length) {
    if (typeof offset !== "number" || offset !== offset) {
      throw new TypeError("offset must be a number");
    }
    if (offset > kMaxUint32 || offset < 0) {
      throw new TypeError("offset must be a uint32");
    }
    if (offset > kBufferMaxLength || offset > length) {
      throw new RangeError("offset out of range");
    }
  }
  function assertSize2(size, offset, length) {
    if (typeof size !== "number" || size !== size) {
      throw new TypeError("size must be a number");
    }
    if (size > kMaxUint32 || size < 0) {
      throw new TypeError("size must be a uint32");
    }
    if (size + offset > length || size > kBufferMaxLength) {
      throw new RangeError("buffer too small");
    }
  }
  if (crypto2 && crypto2.getRandomValues || !process.browser) {
    browser$5.randomFill = randomFill;
    browser$5.randomFillSync = randomFillSync;
  } else {
    browser$5.randomFill = oldBrowser;
    browser$5.randomFillSync = oldBrowser;
  }
  function randomFill(buf, offset, size, cb) {
    if (!Buffer2.isBuffer(buf) && !(buf instanceof commonjsGlobal$1.Uint8Array)) {
      throw new TypeError('"buf" argument must be a Buffer or Uint8Array');
    }
    if (typeof offset === "function") {
      cb = offset;
      offset = 0;
      size = buf.length;
    } else if (typeof size === "function") {
      cb = size;
      size = buf.length - offset;
    } else if (typeof cb !== "function") {
      throw new TypeError('"cb" argument must be a function');
    }
    assertOffset(offset, buf.length);
    assertSize2(size, offset, buf.length);
    return actualFill(buf, offset, size, cb);
  }
  function actualFill(buf, offset, size, cb) {
    if (process.browser) {
      var ourBuf = buf.buffer;
      var uint = new Uint8Array(ourBuf, offset, size);
      crypto2.getRandomValues(uint);
      if (cb) {
        process.nextTick(function() {
          cb(null, buf);
        });
        return;
      }
      return buf;
    }
    if (cb) {
      randombytes(size, function(err, bytes2) {
        if (err) {
          return cb(err);
        }
        bytes2.copy(buf, offset);
        cb(null, buf);
      });
      return;
    }
    var bytes = randombytes(size);
    bytes.copy(buf, offset);
    return buf;
  }
  function randomFillSync(buf, offset, size) {
    if (typeof offset === "undefined") {
      offset = 0;
    }
    if (!Buffer2.isBuffer(buf) && !(buf instanceof commonjsGlobal$1.Uint8Array)) {
      throw new TypeError('"buf" argument must be a Buffer or Uint8Array');
    }
    assertOffset(offset, buf.length);
    if (size === void 0) size = buf.length - offset;
    assertSize2(size, offset, buf.length);
    return actualFill(buf, offset, size);
  }
  return browser$5;
}
var hasRequiredCryptoBrowserify;
function requireCryptoBrowserify() {
  if (hasRequiredCryptoBrowserify) return cryptoBrowserify;
  hasRequiredCryptoBrowserify = 1;
  cryptoBrowserify.randomBytes = cryptoBrowserify.rng = cryptoBrowserify.pseudoRandomBytes = cryptoBrowserify.prng = requireBrowser$e();
  cryptoBrowserify.createHash = cryptoBrowserify.Hash = requireBrowser$c();
  cryptoBrowserify.createHmac = cryptoBrowserify.Hmac = requireBrowser$b();
  var algos2 = requireAlgos();
  var algoKeys = Object.keys(algos2);
  var hashes = [
    "sha1",
    "sha224",
    "sha256",
    "sha384",
    "sha512",
    "md5",
    "rmd160"
  ].concat(algoKeys);
  cryptoBrowserify.getHashes = function() {
    return hashes;
  };
  var p2 = requireBrowser$a();
  cryptoBrowserify.pbkdf2 = p2.pbkdf2;
  cryptoBrowserify.pbkdf2Sync = p2.pbkdf2Sync;
  var aes2 = requireBrowser$8();
  cryptoBrowserify.Cipher = aes2.Cipher;
  cryptoBrowserify.createCipher = aes2.createCipher;
  cryptoBrowserify.Cipheriv = aes2.Cipheriv;
  cryptoBrowserify.createCipheriv = aes2.createCipheriv;
  cryptoBrowserify.Decipher = aes2.Decipher;
  cryptoBrowserify.createDecipher = aes2.createDecipher;
  cryptoBrowserify.Decipheriv = aes2.Decipheriv;
  cryptoBrowserify.createDecipheriv = aes2.createDecipheriv;
  cryptoBrowserify.getCiphers = aes2.getCiphers;
  cryptoBrowserify.listCiphers = aes2.listCiphers;
  var dh2 = requireBrowser$7();
  cryptoBrowserify.DiffieHellmanGroup = dh2.DiffieHellmanGroup;
  cryptoBrowserify.createDiffieHellmanGroup = dh2.createDiffieHellmanGroup;
  cryptoBrowserify.getDiffieHellman = dh2.getDiffieHellman;
  cryptoBrowserify.createDiffieHellman = dh2.createDiffieHellman;
  cryptoBrowserify.DiffieHellman = dh2.DiffieHellman;
  var sign2 = requireBrowser$6();
  cryptoBrowserify.createSign = sign2.createSign;
  cryptoBrowserify.Sign = sign2.Sign;
  cryptoBrowserify.createVerify = sign2.createVerify;
  cryptoBrowserify.Verify = sign2.Verify;
  cryptoBrowserify.createECDH = requireBrowser$5();
  var publicEncrypt2 = requireBrowser$4();
  cryptoBrowserify.publicEncrypt = publicEncrypt2.publicEncrypt;
  cryptoBrowserify.privateEncrypt = publicEncrypt2.privateEncrypt;
  cryptoBrowserify.publicDecrypt = publicEncrypt2.publicDecrypt;
  cryptoBrowserify.privateDecrypt = publicEncrypt2.privateDecrypt;
  var rf = requireBrowser$3();
  cryptoBrowserify.randomFill = rf.randomFill;
  cryptoBrowserify.randomFillSync = rf.randomFillSync;
  cryptoBrowserify.createCredentials = function() {
    throw new Error("sorry, createCredentials is not implemented yet\nwe accept pull requests\nhttps://github.com/browserify/crypto-browserify");
  };
  cryptoBrowserify.constants = {
    DH_CHECK_P_NOT_SAFE_PRIME: 2,
    DH_CHECK_P_NOT_PRIME: 1,
    DH_UNABLE_TO_CHECK_GENERATOR: 4,
    DH_NOT_SUITABLE_GENERATOR: 8,
    NPN_ENABLED: 1,
    ALPN_ENABLED: 1,
    RSA_PKCS1_PADDING: 1,
    RSA_SSLV23_PADDING: 2,
    RSA_NO_PADDING: 3,
    RSA_PKCS1_OAEP_PADDING: 4,
    RSA_X931_PADDING: 5,
    RSA_PKCS1_PSS_PADDING: 6,
    POINT_CONVERSION_COMPRESSED: 2,
    POINT_CONVERSION_UNCOMPRESSED: 4,
    POINT_CONVERSION_HYBRID: 6
  };
  return cryptoBrowserify;
}
var core$2 = core$3.exports;
var hasRequiredCore;
function requireCore() {
  if (hasRequiredCore) return core$3.exports;
  hasRequiredCore = 1;
  (function(module2, exports) {
    (function(root, factory) {
      {
        module2.exports = factory();
      }
    })(core$2, function() {
      var CryptoJS2 = CryptoJS2 || function(Math2, undefined$1) {
        var crypto2;
        if (typeof window !== "undefined" && window.crypto) {
          crypto2 = window.crypto;
        }
        if (typeof self !== "undefined" && self.crypto) {
          crypto2 = self.crypto;
        }
        if (typeof globalThis !== "undefined" && globalThis.crypto) {
          crypto2 = globalThis.crypto;
        }
        if (!crypto2 && typeof window !== "undefined" && window.msCrypto) {
          crypto2 = window.msCrypto;
        }
        if (!crypto2 && typeof commonjsGlobal$1 !== "undefined" && commonjsGlobal$1.crypto) {
          crypto2 = commonjsGlobal$1.crypto;
        }
        if (!crypto2 && typeof commonjsRequire$1 === "function") {
          try {
            crypto2 = /* @__PURE__ */ requireCryptoBrowserify();
          } catch (err) {
          }
        }
        var cryptoSecureRandomInt = function() {
          if (crypto2) {
            if (typeof crypto2.getRandomValues === "function") {
              try {
                return crypto2.getRandomValues(new Uint32Array(1))[0];
              } catch (err) {
              }
            }
            if (typeof crypto2.randomBytes === "function") {
              try {
                return crypto2.randomBytes(4).readInt32LE();
              } catch (err) {
              }
            }
          }
          throw new Error("Native crypto module could not be used to get secure random number.");
        };
        var create2 = Object.create || /* @__PURE__ */ function() {
          function F() {
          }
          return function(obj) {
            var subtype;
            F.prototype = obj;
            subtype = new F();
            F.prototype = null;
            return subtype;
          };
        }();
        var C2 = {};
        var C_lib = C2.lib = {};
        var Base = C_lib.Base = /* @__PURE__ */ function() {
          return {
            /**
             * Creates a new object that inherits from this object.
             *
             * @param {Object} overrides Properties to copy into the new object.
             *
             * @return {Object} The new object.
             *
             * @static
             *
             * @example
             *
             *     var MyType = CryptoJS.lib.Base.extend({
             *         field: 'value',
             *
             *         method: function () {
             *         }
             *     });
             */
            extend: function(overrides) {
              var subtype = create2(this);
              if (overrides) {
                subtype.mixIn(overrides);
              }
              if (!subtype.hasOwnProperty("init") || this.init === subtype.init) {
                subtype.init = function() {
                  subtype.$super.init.apply(this, arguments);
                };
              }
              subtype.init.prototype = subtype;
              subtype.$super = this;
              return subtype;
            },
            /**
             * Extends this object and runs the init method.
             * Arguments to create() will be passed to init().
             *
             * @return {Object} The new object.
             *
             * @static
             *
             * @example
             *
             *     var instance = MyType.create();
             */
            create: function() {
              var instance2 = this.extend();
              instance2.init.apply(instance2, arguments);
              return instance2;
            },
            /**
             * Initializes a newly created object.
             * Override this method to add some logic when your objects are created.
             *
             * @example
             *
             *     var MyType = CryptoJS.lib.Base.extend({
             *         init: function () {
             *             // ...
             *         }
             *     });
             */
            init: function() {
            },
            /**
             * Copies properties into this object.
             *
             * @param {Object} properties The properties to mix in.
             *
             * @example
             *
             *     MyType.mixIn({
             *         field: 'value'
             *     });
             */
            mixIn: function(properties2) {
              for (var propertyName in properties2) {
                if (properties2.hasOwnProperty(propertyName)) {
                  this[propertyName] = properties2[propertyName];
                }
              }
              if (properties2.hasOwnProperty("toString")) {
                this.toString = properties2.toString;
              }
            },
            /**
             * Creates a copy of this object.
             *
             * @return {Object} The clone.
             *
             * @example
             *
             *     var clone = instance.clone();
             */
            clone: function() {
              return this.init.prototype.extend(this);
            }
          };
        }();
        var WordArray = C_lib.WordArray = Base.extend({
          /**
           * Initializes a newly created word array.
           *
           * @param {Array} words (Optional) An array of 32-bit words.
           * @param {number} sigBytes (Optional) The number of significant bytes in the words.
           *
           * @example
           *
           *     var wordArray = CryptoJS.lib.WordArray.create();
           *     var wordArray = CryptoJS.lib.WordArray.create([0x00010203, 0x04050607]);
           *     var wordArray = CryptoJS.lib.WordArray.create([0x00010203, 0x04050607], 6);
           */
          init: function(words, sigBytes) {
            words = this.words = words || [];
            if (sigBytes != undefined$1) {
              this.sigBytes = sigBytes;
            } else {
              this.sigBytes = words.length * 4;
            }
          },
          /**
           * Converts this word array to a string.
           *
           * @param {Encoder} encoder (Optional) The encoding strategy to use. Default: CryptoJS.enc.Hex
           *
           * @return {string} The stringified word array.
           *
           * @example
           *
           *     var string = wordArray + '';
           *     var string = wordArray.toString();
           *     var string = wordArray.toString(CryptoJS.enc.Utf8);
           */
          toString: function(encoder2) {
            return (encoder2 || Hex2).stringify(this);
          },
          /**
           * Concatenates a word array to this word array.
           *
           * @param {WordArray} wordArray The word array to append.
           *
           * @return {WordArray} This word array.
           *
           * @example
           *
           *     wordArray1.concat(wordArray2);
           */
          concat: function(wordArray) {
            var thisWords = this.words;
            var thatWords = wordArray.words;
            var thisSigBytes = this.sigBytes;
            var thatSigBytes = wordArray.sigBytes;
            this.clamp();
            if (thisSigBytes % 4) {
              for (var i2 = 0; i2 < thatSigBytes; i2++) {
                var thatByte = thatWords[i2 >>> 2] >>> 24 - i2 % 4 * 8 & 255;
                thisWords[thisSigBytes + i2 >>> 2] |= thatByte << 24 - (thisSigBytes + i2) % 4 * 8;
              }
            } else {
              for (var j = 0; j < thatSigBytes; j += 4) {
                thisWords[thisSigBytes + j >>> 2] = thatWords[j >>> 2];
              }
            }
            this.sigBytes += thatSigBytes;
            return this;
          },
          /**
           * Removes insignificant bits.
           *
           * @example
           *
           *     wordArray.clamp();
           */
          clamp: function() {
            var words = this.words;
            var sigBytes = this.sigBytes;
            words[sigBytes >>> 2] &= 4294967295 << 32 - sigBytes % 4 * 8;
            words.length = Math2.ceil(sigBytes / 4);
          },
          /**
           * Creates a copy of this word array.
           *
           * @return {WordArray} The clone.
           *
           * @example
           *
           *     var clone = wordArray.clone();
           */
          clone: function() {
            var clone2 = Base.clone.call(this);
            clone2.words = this.words.slice(0);
            return clone2;
          },
          /**
           * Creates a word array filled with random bytes.
           *
           * @param {number} nBytes The number of random bytes to generate.
           *
           * @return {WordArray} The random word array.
           *
           * @static
           *
           * @example
           *
           *     var wordArray = CryptoJS.lib.WordArray.random(16);
           */
          random: function(nBytes) {
            var words = [];
            for (var i2 = 0; i2 < nBytes; i2 += 4) {
              words.push(cryptoSecureRandomInt());
            }
            return new WordArray.init(words, nBytes);
          }
        });
        var C_enc = C2.enc = {};
        var Hex2 = C_enc.Hex = {
          /**
           * Converts a word array to a hex string.
           *
           * @param {WordArray} wordArray The word array.
           *
           * @return {string} The hex string.
           *
           * @static
           *
           * @example
           *
           *     var hexString = CryptoJS.enc.Hex.stringify(wordArray);
           */
          stringify: function(wordArray) {
            var words = wordArray.words;
            var sigBytes = wordArray.sigBytes;
            var hexChars = [];
            for (var i2 = 0; i2 < sigBytes; i2++) {
              var bite = words[i2 >>> 2] >>> 24 - i2 % 4 * 8 & 255;
              hexChars.push((bite >>> 4).toString(16));
              hexChars.push((bite & 15).toString(16));
            }
            return hexChars.join("");
          },
          /**
           * Converts a hex string to a word array.
           *
           * @param {string} hexStr The hex string.
           *
           * @return {WordArray} The word array.
           *
           * @static
           *
           * @example
           *
           *     var wordArray = CryptoJS.enc.Hex.parse(hexString);
           */
          parse: function(hexStr) {
            var hexStrLength = hexStr.length;
            var words = [];
            for (var i2 = 0; i2 < hexStrLength; i2 += 2) {
              words[i2 >>> 3] |= parseInt(hexStr.substr(i2, 2), 16) << 24 - i2 % 8 * 4;
            }
            return new WordArray.init(words, hexStrLength / 2);
          }
        };
        var Latin1 = C_enc.Latin1 = {
          /**
           * Converts a word array to a Latin1 string.
           *
           * @param {WordArray} wordArray The word array.
           *
           * @return {string} The Latin1 string.
           *
           * @static
           *
           * @example
           *
           *     var latin1String = CryptoJS.enc.Latin1.stringify(wordArray);
           */
          stringify: function(wordArray) {
            var words = wordArray.words;
            var sigBytes = wordArray.sigBytes;
            var latin1Chars = [];
            for (var i2 = 0; i2 < sigBytes; i2++) {
              var bite = words[i2 >>> 2] >>> 24 - i2 % 4 * 8 & 255;
              latin1Chars.push(String.fromCharCode(bite));
            }
            return latin1Chars.join("");
          },
          /**
           * Converts a Latin1 string to a word array.
           *
           * @param {string} latin1Str The Latin1 string.
           *
           * @return {WordArray} The word array.
           *
           * @static
           *
           * @example
           *
           *     var wordArray = CryptoJS.enc.Latin1.parse(latin1String);
           */
          parse: function(latin1Str) {
            var latin1StrLength = latin1Str.length;
            var words = [];
            for (var i2 = 0; i2 < latin1StrLength; i2++) {
              words[i2 >>> 2] |= (latin1Str.charCodeAt(i2) & 255) << 24 - i2 % 4 * 8;
            }
            return new WordArray.init(words, latin1StrLength);
          }
        };
        var Utf8 = C_enc.Utf8 = {
          /**
           * Converts a word array to a UTF-8 string.
           *
           * @param {WordArray} wordArray The word array.
           *
           * @return {string} The UTF-8 string.
           *
           * @static
           *
           * @example
           *
           *     var utf8String = CryptoJS.enc.Utf8.stringify(wordArray);
           */
          stringify: function(wordArray) {
            try {
              return decodeURIComponent(escape(Latin1.stringify(wordArray)));
            } catch (e4) {
              throw new Error("Malformed UTF-8 data");
            }
          },
          /**
           * Converts a UTF-8 string to a word array.
           *
           * @param {string} utf8Str The UTF-8 string.
           *
           * @return {WordArray} The word array.
           *
           * @static
           *
           * @example
           *
           *     var wordArray = CryptoJS.enc.Utf8.parse(utf8String);
           */
          parse: function(utf8Str) {
            return Latin1.parse(unescape(encodeURIComponent(utf8Str)));
          }
        };
        var BufferedBlockAlgorithm = C_lib.BufferedBlockAlgorithm = Base.extend({
          /**
           * Resets this block algorithm's data buffer to its initial state.
           *
           * @example
           *
           *     bufferedBlockAlgorithm.reset();
           */
          reset: function() {
            this._data = new WordArray.init();
            this._nDataBytes = 0;
          },
          /**
           * Adds new data to this block algorithm's buffer.
           *
           * @param {WordArray|string} data The data to append. Strings are converted to a WordArray using UTF-8.
           *
           * @example
           *
           *     bufferedBlockAlgorithm._append('data');
           *     bufferedBlockAlgorithm._append(wordArray);
           */
          _append: function(data2) {
            if (typeof data2 == "string") {
              data2 = Utf8.parse(data2);
            }
            this._data.concat(data2);
            this._nDataBytes += data2.sigBytes;
          },
          /**
           * Processes available data blocks.
           *
           * This method invokes _doProcessBlock(offset), which must be implemented by a concrete subtype.
           *
           * @param {boolean} doFlush Whether all blocks and partial blocks should be processed.
           *
           * @return {WordArray} The processed data.
           *
           * @example
           *
           *     var processedData = bufferedBlockAlgorithm._process();
           *     var processedData = bufferedBlockAlgorithm._process(!!'flush');
           */
          _process: function(doFlush) {
            var processedWords;
            var data2 = this._data;
            var dataWords = data2.words;
            var dataSigBytes = data2.sigBytes;
            var blockSize = this.blockSize;
            var blockSizeBytes = blockSize * 4;
            var nBlocksReady = dataSigBytes / blockSizeBytes;
            if (doFlush) {
              nBlocksReady = Math2.ceil(nBlocksReady);
            } else {
              nBlocksReady = Math2.max((nBlocksReady | 0) - this._minBufferSize, 0);
            }
            var nWordsReady = nBlocksReady * blockSize;
            var nBytesReady = Math2.min(nWordsReady * 4, dataSigBytes);
            if (nWordsReady) {
              for (var offset = 0; offset < nWordsReady; offset += blockSize) {
                this._doProcessBlock(dataWords, offset);
              }
              processedWords = dataWords.splice(0, nWordsReady);
              data2.sigBytes -= nBytesReady;
            }
            return new WordArray.init(processedWords, nBytesReady);
          },
          /**
           * Creates a copy of this object.
           *
           * @return {Object} The clone.
           *
           * @example
           *
           *     var clone = bufferedBlockAlgorithm.clone();
           */
          clone: function() {
            var clone2 = Base.clone.call(this);
            clone2._data = this._data.clone();
            return clone2;
          },
          _minBufferSize: 0
        });
        C_lib.Hasher = BufferedBlockAlgorithm.extend({
          /**
           * Configuration options.
           */
          cfg: Base.extend(),
          /**
           * Initializes a newly created hasher.
           *
           * @param {Object} cfg (Optional) The configuration options to use for this hash computation.
           *
           * @example
           *
           *     var hasher = CryptoJS.algo.SHA256.create();
           */
          init: function(cfg) {
            this.cfg = this.cfg.extend(cfg);
            this.reset();
          },
          /**
           * Resets this hasher to its initial state.
           *
           * @example
           *
           *     hasher.reset();
           */
          reset: function() {
            BufferedBlockAlgorithm.reset.call(this);
            this._doReset();
          },
          /**
           * Updates this hasher with a message.
           *
           * @param {WordArray|string} messageUpdate The message to append.
           *
           * @return {Hasher} This hasher.
           *
           * @example
           *
           *     hasher.update('message');
           *     hasher.update(wordArray);
           */
          update: function(messageUpdate) {
            this._append(messageUpdate);
            this._process();
            return this;
          },
          /**
           * Finalizes the hash computation.
           * Note that the finalize operation is effectively a destructive, read-once operation.
           *
           * @param {WordArray|string} messageUpdate (Optional) A final message update.
           *
           * @return {WordArray} The hash.
           *
           * @example
           *
           *     var hash = hasher.finalize();
           *     var hash = hasher.finalize('message');
           *     var hash = hasher.finalize(wordArray);
           */
          finalize: function(messageUpdate) {
            if (messageUpdate) {
              this._append(messageUpdate);
            }
            var hash2 = this._doFinalize();
            return hash2;
          },
          blockSize: 512 / 32,
          /**
           * Creates a shortcut function to a hasher's object interface.
           *
           * @param {Hasher} hasher The hasher to create a helper for.
           *
           * @return {Function} The shortcut function.
           *
           * @static
           *
           * @example
           *
           *     var SHA256 = CryptoJS.lib.Hasher._createHelper(CryptoJS.algo.SHA256);
           */
          _createHelper: function(hasher) {
            return function(message, cfg) {
              return new hasher.init(cfg).finalize(message);
            };
          },
          /**
           * Creates a shortcut function to the HMAC's object interface.
           *
           * @param {Hasher} hasher The hasher to use in this HMAC helper.
           *
           * @return {Function} The shortcut function.
           *
           * @static
           *
           * @example
           *
           *     var HmacSHA256 = CryptoJS.lib.Hasher._createHmacHelper(CryptoJS.algo.SHA256);
           */
          _createHmacHelper: function(hasher) {
            return function(message, key2) {
              return new C_algo.HMAC.init(hasher, key2).finalize(message);
            };
          }
        });
        var C_algo = C2.algo = {};
        return C2;
      }(Math);
      return CryptoJS2;
    });
  })(core$3);
  return core$3.exports;
}
var x64Core$1 = { exports: {} };
var x64Core = x64Core$1.exports;
var hasRequiredX64Core;
function requireX64Core() {
  if (hasRequiredX64Core) return x64Core$1.exports;
  hasRequiredX64Core = 1;
  (function(module2, exports) {
    (function(root, factory) {
      {
        module2.exports = factory(requireCore());
      }
    })(x64Core, function(CryptoJS2) {
      (function(undefined$1) {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var Base = C_lib.Base;
        var X32WordArray = C_lib.WordArray;
        var C_x64 = C2.x64 = {};
        C_x64.Word = Base.extend({
          /**
           * Initializes a newly created 64-bit word.
           *
           * @param {number} high The high 32 bits.
           * @param {number} low The low 32 bits.
           *
           * @example
           *
           *     var x64Word = CryptoJS.x64.Word.create(0x00010203, 0x04050607);
           */
          init: function(high, low) {
            this.high = high;
            this.low = low;
          }
          /**
           * Bitwise NOTs this word.
           *
           * @return {X64Word} A new x64-Word object after negating.
           *
           * @example
           *
           *     var negated = x64Word.not();
           */
          // not: function () {
          // var high = ~this.high;
          // var low = ~this.low;
          // return X64Word.create(high, low);
          // },
          /**
           * Bitwise ANDs this word with the passed word.
           *
           * @param {X64Word} word The x64-Word to AND with this word.
           *
           * @return {X64Word} A new x64-Word object after ANDing.
           *
           * @example
           *
           *     var anded = x64Word.and(anotherX64Word);
           */
          // and: function (word) {
          // var high = this.high & word.high;
          // var low = this.low & word.low;
          // return X64Word.create(high, low);
          // },
          /**
           * Bitwise ORs this word with the passed word.
           *
           * @param {X64Word} word The x64-Word to OR with this word.
           *
           * @return {X64Word} A new x64-Word object after ORing.
           *
           * @example
           *
           *     var ored = x64Word.or(anotherX64Word);
           */
          // or: function (word) {
          // var high = this.high | word.high;
          // var low = this.low | word.low;
          // return X64Word.create(high, low);
          // },
          /**
           * Bitwise XORs this word with the passed word.
           *
           * @param {X64Word} word The x64-Word to XOR with this word.
           *
           * @return {X64Word} A new x64-Word object after XORing.
           *
           * @example
           *
           *     var xored = x64Word.xor(anotherX64Word);
           */
          // xor: function (word) {
          // var high = this.high ^ word.high;
          // var low = this.low ^ word.low;
          // return X64Word.create(high, low);
          // },
          /**
           * Shifts this word n bits to the left.
           *
           * @param {number} n The number of bits to shift.
           *
           * @return {X64Word} A new x64-Word object after shifting.
           *
           * @example
           *
           *     var shifted = x64Word.shiftL(25);
           */
          // shiftL: function (n) {
          // if (n < 32) {
          // var high = (this.high << n) | (this.low >>> (32 - n));
          // var low = this.low << n;
          // } else {
          // var high = this.low << (n - 32);
          // var low = 0;
          // }
          // return X64Word.create(high, low);
          // },
          /**
           * Shifts this word n bits to the right.
           *
           * @param {number} n The number of bits to shift.
           *
           * @return {X64Word} A new x64-Word object after shifting.
           *
           * @example
           *
           *     var shifted = x64Word.shiftR(7);
           */
          // shiftR: function (n) {
          // if (n < 32) {
          // var low = (this.low >>> n) | (this.high << (32 - n));
          // var high = this.high >>> n;
          // } else {
          // var low = this.high >>> (n - 32);
          // var high = 0;
          // }
          // return X64Word.create(high, low);
          // },
          /**
           * Rotates this word n bits to the left.
           *
           * @param {number} n The number of bits to rotate.
           *
           * @return {X64Word} A new x64-Word object after rotating.
           *
           * @example
           *
           *     var rotated = x64Word.rotL(25);
           */
          // rotL: function (n) {
          // return this.shiftL(n).or(this.shiftR(64 - n));
          // },
          /**
           * Rotates this word n bits to the right.
           *
           * @param {number} n The number of bits to rotate.
           *
           * @return {X64Word} A new x64-Word object after rotating.
           *
           * @example
           *
           *     var rotated = x64Word.rotR(7);
           */
          // rotR: function (n) {
          // return this.shiftR(n).or(this.shiftL(64 - n));
          // },
          /**
           * Adds this word with the passed word.
           *
           * @param {X64Word} word The x64-Word to add with this word.
           *
           * @return {X64Word} A new x64-Word object after adding.
           *
           * @example
           *
           *     var added = x64Word.add(anotherX64Word);
           */
          // add: function (word) {
          // var low = (this.low + word.low) | 0;
          // var carry = (low >>> 0) < (this.low >>> 0) ? 1 : 0;
          // var high = (this.high + word.high + carry) | 0;
          // return X64Word.create(high, low);
          // }
        });
        C_x64.WordArray = Base.extend({
          /**
           * Initializes a newly created word array.
           *
           * @param {Array} words (Optional) An array of CryptoJS.x64.Word objects.
           * @param {number} sigBytes (Optional) The number of significant bytes in the words.
           *
           * @example
           *
           *     var wordArray = CryptoJS.x64.WordArray.create();
           *
           *     var wordArray = CryptoJS.x64.WordArray.create([
           *         CryptoJS.x64.Word.create(0x00010203, 0x04050607),
           *         CryptoJS.x64.Word.create(0x18191a1b, 0x1c1d1e1f)
           *     ]);
           *
           *     var wordArray = CryptoJS.x64.WordArray.create([
           *         CryptoJS.x64.Word.create(0x00010203, 0x04050607),
           *         CryptoJS.x64.Word.create(0x18191a1b, 0x1c1d1e1f)
           *     ], 10);
           */
          init: function(words, sigBytes) {
            words = this.words = words || [];
            if (sigBytes != undefined$1) {
              this.sigBytes = sigBytes;
            } else {
              this.sigBytes = words.length * 8;
            }
          },
          /**
           * Converts this 64-bit word array to a 32-bit word array.
           *
           * @return {CryptoJS.lib.WordArray} This word array's data as a 32-bit word array.
           *
           * @example
           *
           *     var x32WordArray = x64WordArray.toX32();
           */
          toX32: function() {
            var x64Words = this.words;
            var x64WordsLength = x64Words.length;
            var x32Words = [];
            for (var i2 = 0; i2 < x64WordsLength; i2++) {
              var x64Word = x64Words[i2];
              x32Words.push(x64Word.high);
              x32Words.push(x64Word.low);
            }
            return X32WordArray.create(x32Words, this.sigBytes);
          },
          /**
           * Creates a copy of this word array.
           *
           * @return {X64WordArray} The clone.
           *
           * @example
           *
           *     var clone = x64WordArray.clone();
           */
          clone: function() {
            var clone2 = Base.clone.call(this);
            var words = clone2.words = this.words.slice(0);
            var wordsLength = words.length;
            for (var i2 = 0; i2 < wordsLength; i2++) {
              words[i2] = words[i2].clone();
            }
            return clone2;
          }
        });
      })();
      return CryptoJS2;
    });
  })(x64Core$1);
  return x64Core$1.exports;
}
var libTypedarrays$1 = { exports: {} };
var libTypedarrays = libTypedarrays$1.exports;
var hasRequiredLibTypedarrays;
function requireLibTypedarrays() {
  if (hasRequiredLibTypedarrays) return libTypedarrays$1.exports;
  hasRequiredLibTypedarrays = 1;
  (function(module2, exports) {
    (function(root, factory) {
      {
        module2.exports = factory(requireCore());
      }
    })(libTypedarrays, function(CryptoJS2) {
      (function() {
        if (typeof ArrayBuffer != "function") {
          return;
        }
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var WordArray = C_lib.WordArray;
        var superInit = WordArray.init;
        var subInit = WordArray.init = function(typedArray) {
          if (typedArray instanceof ArrayBuffer) {
            typedArray = new Uint8Array(typedArray);
          }
          if (typedArray instanceof Int8Array || typeof Uint8ClampedArray !== "undefined" && typedArray instanceof Uint8ClampedArray || typedArray instanceof Int16Array || typedArray instanceof Uint16Array || typedArray instanceof Int32Array || typedArray instanceof Uint32Array || typedArray instanceof Float32Array || typedArray instanceof Float64Array) {
            typedArray = new Uint8Array(typedArray.buffer, typedArray.byteOffset, typedArray.byteLength);
          }
          if (typedArray instanceof Uint8Array) {
            var typedArrayByteLength = typedArray.byteLength;
            var words = [];
            for (var i2 = 0; i2 < typedArrayByteLength; i2++) {
              words[i2 >>> 2] |= typedArray[i2] << 24 - i2 % 4 * 8;
            }
            superInit.call(this, words, typedArrayByteLength);
          } else {
            superInit.apply(this, arguments);
          }
        };
        subInit.prototype = WordArray;
      })();
      return CryptoJS2.lib.WordArray;
    });
  })(libTypedarrays$1);
  return libTypedarrays$1.exports;
}
var encUtf16$1 = { exports: {} };
var encUtf16 = encUtf16$1.exports;
var hasRequiredEncUtf16;
function requireEncUtf16() {
  if (hasRequiredEncUtf16) return encUtf16$1.exports;
  hasRequiredEncUtf16 = 1;
  (function(module2, exports) {
    (function(root, factory) {
      {
        module2.exports = factory(requireCore());
      }
    })(encUtf16, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var WordArray = C_lib.WordArray;
        var C_enc = C2.enc;
        C_enc.Utf16 = C_enc.Utf16BE = {
          /**
           * Converts a word array to a UTF-16 BE string.
           *
           * @param {WordArray} wordArray The word array.
           *
           * @return {string} The UTF-16 BE string.
           *
           * @static
           *
           * @example
           *
           *     var utf16String = CryptoJS.enc.Utf16.stringify(wordArray);
           */
          stringify: function(wordArray) {
            var words = wordArray.words;
            var sigBytes = wordArray.sigBytes;
            var utf16Chars = [];
            for (var i2 = 0; i2 < sigBytes; i2 += 2) {
              var codePoint = words[i2 >>> 2] >>> 16 - i2 % 4 * 8 & 65535;
              utf16Chars.push(String.fromCharCode(codePoint));
            }
            return utf16Chars.join("");
          },
          /**
           * Converts a UTF-16 BE string to a word array.
           *
           * @param {string} utf16Str The UTF-16 BE string.
           *
           * @return {WordArray} The word array.
           *
           * @static
           *
           * @example
           *
           *     var wordArray = CryptoJS.enc.Utf16.parse(utf16String);
           */
          parse: function(utf16Str) {
            var utf16StrLength = utf16Str.length;
            var words = [];
            for (var i2 = 0; i2 < utf16StrLength; i2++) {
              words[i2 >>> 1] |= utf16Str.charCodeAt(i2) << 16 - i2 % 2 * 16;
            }
            return WordArray.create(words, utf16StrLength * 2);
          }
        };
        C_enc.Utf16LE = {
          /**
           * Converts a word array to a UTF-16 LE string.
           *
           * @param {WordArray} wordArray The word array.
           *
           * @return {string} The UTF-16 LE string.
           *
           * @static
           *
           * @example
           *
           *     var utf16Str = CryptoJS.enc.Utf16LE.stringify(wordArray);
           */
          stringify: function(wordArray) {
            var words = wordArray.words;
            var sigBytes = wordArray.sigBytes;
            var utf16Chars = [];
            for (var i2 = 0; i2 < sigBytes; i2 += 2) {
              var codePoint = swapEndian(words[i2 >>> 2] >>> 16 - i2 % 4 * 8 & 65535);
              utf16Chars.push(String.fromCharCode(codePoint));
            }
            return utf16Chars.join("");
          },
          /**
           * Converts a UTF-16 LE string to a word array.
           *
           * @param {string} utf16Str The UTF-16 LE string.
           *
           * @return {WordArray} The word array.
           *
           * @static
           *
           * @example
           *
           *     var wordArray = CryptoJS.enc.Utf16LE.parse(utf16Str);
           */
          parse: function(utf16Str) {
            var utf16StrLength = utf16Str.length;
            var words = [];
            for (var i2 = 0; i2 < utf16StrLength; i2++) {
              words[i2 >>> 1] |= swapEndian(utf16Str.charCodeAt(i2) << 16 - i2 % 2 * 16);
            }
            return WordArray.create(words, utf16StrLength * 2);
          }
        };
        function swapEndian(word) {
          return word << 8 & 4278255360 | word >>> 8 & 16711935;
        }
      })();
      return CryptoJS2.enc.Utf16;
    });
  })(encUtf16$1);
  return encUtf16$1.exports;
}
var encBase64$1 = { exports: {} };
var encBase64 = encBase64$1.exports;
var hasRequiredEncBase64;
function requireEncBase64() {
  if (hasRequiredEncBase64) return encBase64$1.exports;
  hasRequiredEncBase64 = 1;
  (function(module2, exports) {
    (function(root, factory) {
      {
        module2.exports = factory(requireCore());
      }
    })(encBase64, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var WordArray = C_lib.WordArray;
        var C_enc = C2.enc;
        C_enc.Base64 = {
          /**
           * Converts a word array to a Base64 string.
           *
           * @param {WordArray} wordArray The word array.
           *
           * @return {string} The Base64 string.
           *
           * @static
           *
           * @example
           *
           *     var base64String = CryptoJS.enc.Base64.stringify(wordArray);
           */
          stringify: function(wordArray) {
            var words = wordArray.words;
            var sigBytes = wordArray.sigBytes;
            var map = this._map;
            wordArray.clamp();
            var base64Chars = [];
            for (var i2 = 0; i2 < sigBytes; i2 += 3) {
              var byte1 = words[i2 >>> 2] >>> 24 - i2 % 4 * 8 & 255;
              var byte2 = words[i2 + 1 >>> 2] >>> 24 - (i2 + 1) % 4 * 8 & 255;
              var byte3 = words[i2 + 2 >>> 2] >>> 24 - (i2 + 2) % 4 * 8 & 255;
              var triplet = byte1 << 16 | byte2 << 8 | byte3;
              for (var j = 0; j < 4 && i2 + j * 0.75 < sigBytes; j++) {
                base64Chars.push(map.charAt(triplet >>> 6 * (3 - j) & 63));
              }
            }
            var paddingChar = map.charAt(64);
            if (paddingChar) {
              while (base64Chars.length % 4) {
                base64Chars.push(paddingChar);
              }
            }
            return base64Chars.join("");
          },
          /**
           * Converts a Base64 string to a word array.
           *
           * @param {string} base64Str The Base64 string.
           *
           * @return {WordArray} The word array.
           *
           * @static
           *
           * @example
           *
           *     var wordArray = CryptoJS.enc.Base64.parse(base64String);
           */
          parse: function(base64Str) {
            var base64StrLength = base64Str.length;
            var map = this._map;
            var reverseMap = this._reverseMap;
            if (!reverseMap) {
              reverseMap = this._reverseMap = [];
              for (var j = 0; j < map.length; j++) {
                reverseMap[map.charCodeAt(j)] = j;
              }
            }
            var paddingChar = map.charAt(64);
            if (paddingChar) {
              var paddingIndex = base64Str.indexOf(paddingChar);
              if (paddingIndex !== -1) {
                base64StrLength = paddingIndex;
              }
            }
            return parseLoop(base64Str, base64StrLength, reverseMap);
          },
          _map: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="
        };
        function parseLoop(base64Str, base64StrLength, reverseMap) {
          var words = [];
          var nBytes = 0;
          for (var i2 = 0; i2 < base64StrLength; i2++) {
            if (i2 % 4) {
              var bits1 = reverseMap[base64Str.charCodeAt(i2 - 1)] << i2 % 4 * 2;
              var bits2 = reverseMap[base64Str.charCodeAt(i2)] >>> 6 - i2 % 4 * 2;
              var bitsCombined = bits1 | bits2;
              words[nBytes >>> 2] |= bitsCombined << 24 - nBytes % 4 * 8;
              nBytes++;
            }
          }
          return WordArray.create(words, nBytes);
        }
      })();
      return CryptoJS2.enc.Base64;
    });
  })(encBase64$1);
  return encBase64$1.exports;
}
var encBase64url$1 = { exports: {} };
var encBase64url = encBase64url$1.exports;
var hasRequiredEncBase64url;
function requireEncBase64url() {
  if (hasRequiredEncBase64url) return encBase64url$1.exports;
  hasRequiredEncBase64url = 1;
  (function(module2, exports) {
    (function(root, factory) {
      {
        module2.exports = factory(requireCore());
      }
    })(encBase64url, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var WordArray = C_lib.WordArray;
        var C_enc = C2.enc;
        C_enc.Base64url = {
          /**
           * Converts a word array to a Base64url string.
           *
           * @param {WordArray} wordArray The word array.
           *
           * @param {boolean} urlSafe Whether to use url safe
           *
           * @return {string} The Base64url string.
           *
           * @static
           *
           * @example
           *
           *     var base64String = CryptoJS.enc.Base64url.stringify(wordArray);
           */
          stringify: function(wordArray, urlSafe) {
            if (urlSafe === void 0) {
              urlSafe = true;
            }
            var words = wordArray.words;
            var sigBytes = wordArray.sigBytes;
            var map = urlSafe ? this._safe_map : this._map;
            wordArray.clamp();
            var base64Chars = [];
            for (var i2 = 0; i2 < sigBytes; i2 += 3) {
              var byte1 = words[i2 >>> 2] >>> 24 - i2 % 4 * 8 & 255;
              var byte2 = words[i2 + 1 >>> 2] >>> 24 - (i2 + 1) % 4 * 8 & 255;
              var byte3 = words[i2 + 2 >>> 2] >>> 24 - (i2 + 2) % 4 * 8 & 255;
              var triplet = byte1 << 16 | byte2 << 8 | byte3;
              for (var j = 0; j < 4 && i2 + j * 0.75 < sigBytes; j++) {
                base64Chars.push(map.charAt(triplet >>> 6 * (3 - j) & 63));
              }
            }
            var paddingChar = map.charAt(64);
            if (paddingChar) {
              while (base64Chars.length % 4) {
                base64Chars.push(paddingChar);
              }
            }
            return base64Chars.join("");
          },
          /**
           * Converts a Base64url string to a word array.
           *
           * @param {string} base64Str The Base64url string.
           *
           * @param {boolean} urlSafe Whether to use url safe
           *
           * @return {WordArray} The word array.
           *
           * @static
           *
           * @example
           *
           *     var wordArray = CryptoJS.enc.Base64url.parse(base64String);
           */
          parse: function(base64Str, urlSafe) {
            if (urlSafe === void 0) {
              urlSafe = true;
            }
            var base64StrLength = base64Str.length;
            var map = urlSafe ? this._safe_map : this._map;
            var reverseMap = this._reverseMap;
            if (!reverseMap) {
              reverseMap = this._reverseMap = [];
              for (var j = 0; j < map.length; j++) {
                reverseMap[map.charCodeAt(j)] = j;
              }
            }
            var paddingChar = map.charAt(64);
            if (paddingChar) {
              var paddingIndex = base64Str.indexOf(paddingChar);
              if (paddingIndex !== -1) {
                base64StrLength = paddingIndex;
              }
            }
            return parseLoop(base64Str, base64StrLength, reverseMap);
          },
          _map: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
          _safe_map: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_"
        };
        function parseLoop(base64Str, base64StrLength, reverseMap) {
          var words = [];
          var nBytes = 0;
          for (var i2 = 0; i2 < base64StrLength; i2++) {
            if (i2 % 4) {
              var bits1 = reverseMap[base64Str.charCodeAt(i2 - 1)] << i2 % 4 * 2;
              var bits2 = reverseMap[base64Str.charCodeAt(i2)] >>> 6 - i2 % 4 * 2;
              var bitsCombined = bits1 | bits2;
              words[nBytes >>> 2] |= bitsCombined << 24 - nBytes % 4 * 8;
              nBytes++;
            }
          }
          return WordArray.create(words, nBytes);
        }
      })();
      return CryptoJS2.enc.Base64url;
    });
  })(encBase64url$1);
  return encBase64url$1.exports;
}
var md5$1 = { exports: {} };
var md5 = md5$1.exports;
var hasRequiredMd5;
function requireMd5() {
  if (hasRequiredMd5) return md5$1.exports;
  hasRequiredMd5 = 1;
  (function(module2, exports) {
    (function(root, factory) {
      {
        module2.exports = factory(requireCore());
      }
    })(md5, function(CryptoJS2) {
      (function(Math2) {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var WordArray = C_lib.WordArray;
        var Hasher = C_lib.Hasher;
        var C_algo = C2.algo;
        var T2 = [];
        (function() {
          for (var i2 = 0; i2 < 64; i2++) {
            T2[i2] = Math2.abs(Math2.sin(i2 + 1)) * 4294967296 | 0;
          }
        })();
        var MD5 = C_algo.MD5 = Hasher.extend({
          _doReset: function() {
            this._hash = new WordArray.init([
              1732584193,
              4023233417,
              2562383102,
              271733878
            ]);
          },
          _doProcessBlock: function(M2, offset) {
            for (var i2 = 0; i2 < 16; i2++) {
              var offset_i = offset + i2;
              var M_offset_i = M2[offset_i];
              M2[offset_i] = (M_offset_i << 8 | M_offset_i >>> 24) & 16711935 | (M_offset_i << 24 | M_offset_i >>> 8) & 4278255360;
            }
            var H = this._hash.words;
            var M_offset_0 = M2[offset + 0];
            var M_offset_1 = M2[offset + 1];
            var M_offset_2 = M2[offset + 2];
            var M_offset_3 = M2[offset + 3];
            var M_offset_4 = M2[offset + 4];
            var M_offset_5 = M2[offset + 5];
            var M_offset_6 = M2[offset + 6];
            var M_offset_7 = M2[offset + 7];
            var M_offset_8 = M2[offset + 8];
            var M_offset_9 = M2[offset + 9];
            var M_offset_10 = M2[offset + 10];
            var M_offset_11 = M2[offset + 11];
            var M_offset_12 = M2[offset + 12];
            var M_offset_13 = M2[offset + 13];
            var M_offset_14 = M2[offset + 14];
            var M_offset_15 = M2[offset + 15];
            var a2 = H[0];
            var b2 = H[1];
            var c2 = H[2];
            var d = H[3];
            a2 = FF2(a2, b2, c2, d, M_offset_0, 7, T2[0]);
            d = FF2(d, a2, b2, c2, M_offset_1, 12, T2[1]);
            c2 = FF2(c2, d, a2, b2, M_offset_2, 17, T2[2]);
            b2 = FF2(b2, c2, d, a2, M_offset_3, 22, T2[3]);
            a2 = FF2(a2, b2, c2, d, M_offset_4, 7, T2[4]);
            d = FF2(d, a2, b2, c2, M_offset_5, 12, T2[5]);
            c2 = FF2(c2, d, a2, b2, M_offset_6, 17, T2[6]);
            b2 = FF2(b2, c2, d, a2, M_offset_7, 22, T2[7]);
            a2 = FF2(a2, b2, c2, d, M_offset_8, 7, T2[8]);
            d = FF2(d, a2, b2, c2, M_offset_9, 12, T2[9]);
            c2 = FF2(c2, d, a2, b2, M_offset_10, 17, T2[10]);
            b2 = FF2(b2, c2, d, a2, M_offset_11, 22, T2[11]);
            a2 = FF2(a2, b2, c2, d, M_offset_12, 7, T2[12]);
            d = FF2(d, a2, b2, c2, M_offset_13, 12, T2[13]);
            c2 = FF2(c2, d, a2, b2, M_offset_14, 17, T2[14]);
            b2 = FF2(b2, c2, d, a2, M_offset_15, 22, T2[15]);
            a2 = GG2(a2, b2, c2, d, M_offset_1, 5, T2[16]);
            d = GG2(d, a2, b2, c2, M_offset_6, 9, T2[17]);
            c2 = GG2(c2, d, a2, b2, M_offset_11, 14, T2[18]);
            b2 = GG2(b2, c2, d, a2, M_offset_0, 20, T2[19]);
            a2 = GG2(a2, b2, c2, d, M_offset_5, 5, T2[20]);
            d = GG2(d, a2, b2, c2, M_offset_10, 9, T2[21]);
            c2 = GG2(c2, d, a2, b2, M_offset_15, 14, T2[22]);
            b2 = GG2(b2, c2, d, a2, M_offset_4, 20, T2[23]);
            a2 = GG2(a2, b2, c2, d, M_offset_9, 5, T2[24]);
            d = GG2(d, a2, b2, c2, M_offset_14, 9, T2[25]);
            c2 = GG2(c2, d, a2, b2, M_offset_3, 14, T2[26]);
            b2 = GG2(b2, c2, d, a2, M_offset_8, 20, T2[27]);
            a2 = GG2(a2, b2, c2, d, M_offset_13, 5, T2[28]);
            d = GG2(d, a2, b2, c2, M_offset_2, 9, T2[29]);
            c2 = GG2(c2, d, a2, b2, M_offset_7, 14, T2[30]);
            b2 = GG2(b2, c2, d, a2, M_offset_12, 20, T2[31]);
            a2 = HH(a2, b2, c2, d, M_offset_5, 4, T2[32]);
            d = HH(d, a2, b2, c2, M_offset_8, 11, T2[33]);
            c2 = HH(c2, d, a2, b2, M_offset_11, 16, T2[34]);
            b2 = HH(b2, c2, d, a2, M_offset_14, 23, T2[35]);
            a2 = HH(a2, b2, c2, d, M_offset_1, 4, T2[36]);
            d = HH(d, a2, b2, c2, M_offset_4, 11, T2[37]);
            c2 = HH(c2, d, a2, b2, M_offset_7, 16, T2[38]);
            b2 = HH(b2, c2, d, a2, M_offset_10, 23, T2[39]);
            a2 = HH(a2, b2, c2, d, M_offset_13, 4, T2[40]);
            d = HH(d, a2, b2, c2, M_offset_0, 11, T2[41]);
            c2 = HH(c2, d, a2, b2, M_offset_3, 16, T2[42]);
            b2 = HH(b2, c2, d, a2, M_offset_6, 23, T2[43]);
            a2 = HH(a2, b2, c2, d, M_offset_9, 4, T2[44]);
            d = HH(d, a2, b2, c2, M_offset_12, 11, T2[45]);
            c2 = HH(c2, d, a2, b2, M_offset_15, 16, T2[46]);
            b2 = HH(b2, c2, d, a2, M_offset_2, 23, T2[47]);
            a2 = II(a2, b2, c2, d, M_offset_0, 6, T2[48]);
            d = II(d, a2, b2, c2, M_offset_7, 10, T2[49]);
            c2 = II(c2, d, a2, b2, M_offset_14, 15, T2[50]);
            b2 = II(b2, c2, d, a2, M_offset_5, 21, T2[51]);
            a2 = II(a2, b2, c2, d, M_offset_12, 6, T2[52]);
            d = II(d, a2, b2, c2, M_offset_3, 10, T2[53]);
            c2 = II(c2, d, a2, b2, M_offset_10, 15, T2[54]);
            b2 = II(b2, c2, d, a2, M_offset_1, 21, T2[55]);
            a2 = II(a2, b2, c2, d, M_offset_8, 6, T2[56]);
            d = II(d, a2, b2, c2, M_offset_15, 10, T2[57]);
            c2 = II(c2, d, a2, b2, M_offset_6, 15, T2[58]);
            b2 = II(b2, c2, d, a2, M_offset_13, 21, T2[59]);
            a2 = II(a2, b2, c2, d, M_offset_4, 6, T2[60]);
            d = II(d, a2, b2, c2, M_offset_11, 10, T2[61]);
            c2 = II(c2, d, a2, b2, M_offset_2, 15, T2[62]);
            b2 = II(b2, c2, d, a2, M_offset_9, 21, T2[63]);
            H[0] = H[0] + a2 | 0;
            H[1] = H[1] + b2 | 0;
            H[2] = H[2] + c2 | 0;
            H[3] = H[3] + d | 0;
          },
          _doFinalize: function() {
            var data2 = this._data;
            var dataWords = data2.words;
            var nBitsTotal = this._nDataBytes * 8;
            var nBitsLeft = data2.sigBytes * 8;
            dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
            var nBitsTotalH = Math2.floor(nBitsTotal / 4294967296);
            var nBitsTotalL = nBitsTotal;
            dataWords[(nBitsLeft + 64 >>> 9 << 4) + 15] = (nBitsTotalH << 8 | nBitsTotalH >>> 24) & 16711935 | (nBitsTotalH << 24 | nBitsTotalH >>> 8) & 4278255360;
            dataWords[(nBitsLeft + 64 >>> 9 << 4) + 14] = (nBitsTotalL << 8 | nBitsTotalL >>> 24) & 16711935 | (nBitsTotalL << 24 | nBitsTotalL >>> 8) & 4278255360;
            data2.sigBytes = (dataWords.length + 1) * 4;
            this._process();
            var hash2 = this._hash;
            var H = hash2.words;
            for (var i2 = 0; i2 < 4; i2++) {
              var H_i = H[i2];
              H[i2] = (H_i << 8 | H_i >>> 24) & 16711935 | (H_i << 24 | H_i >>> 8) & 4278255360;
            }
            return hash2;
          },
          clone: function() {
            var clone2 = Hasher.clone.call(this);
            clone2._hash = this._hash.clone();
            return clone2;
          }
        });
        function FF2(a2, b2, c2, d, x2, s2, t2) {
          var n2 = a2 + (b2 & c2 | ~b2 & d) + x2 + t2;
          return (n2 << s2 | n2 >>> 32 - s2) + b2;
        }
        function GG2(a2, b2, c2, d, x2, s2, t2) {
          var n2 = a2 + (b2 & d | c2 & ~d) + x2 + t2;
          return (n2 << s2 | n2 >>> 32 - s2) + b2;
        }
        function HH(a2, b2, c2, d, x2, s2, t2) {
          var n2 = a2 + (b2 ^ c2 ^ d) + x2 + t2;
          return (n2 << s2 | n2 >>> 32 - s2) + b2;
        }
        function II(a2, b2, c2, d, x2, s2, t2) {
          var n2 = a2 + (c2 ^ (b2 | ~d)) + x2 + t2;
          return (n2 << s2 | n2 >>> 32 - s2) + b2;
        }
        C2.MD5 = Hasher._createHelper(MD5);
        C2.HmacMD5 = Hasher._createHmacHelper(MD5);
      })(Math);
      return CryptoJS2.MD5;
    });
  })(md5$1);
  return md5$1.exports;
}
var sha1$1 = { exports: {} };
var sha1 = sha1$1.exports;
var hasRequiredSha1;
function requireSha1() {
  if (hasRequiredSha1) return sha1$1.exports;
  hasRequiredSha1 = 1;
  (function(module2, exports) {
    (function(root, factory) {
      {
        module2.exports = factory(requireCore());
      }
    })(sha1, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var WordArray = C_lib.WordArray;
        var Hasher = C_lib.Hasher;
        var C_algo = C2.algo;
        var W = [];
        var SHA1 = C_algo.SHA1 = Hasher.extend({
          _doReset: function() {
            this._hash = new WordArray.init([
              1732584193,
              4023233417,
              2562383102,
              271733878,
              3285377520
            ]);
          },
          _doProcessBlock: function(M2, offset) {
            var H = this._hash.words;
            var a2 = H[0];
            var b2 = H[1];
            var c2 = H[2];
            var d = H[3];
            var e4 = H[4];
            for (var i2 = 0; i2 < 80; i2++) {
              if (i2 < 16) {
                W[i2] = M2[offset + i2] | 0;
              } else {
                var n2 = W[i2 - 3] ^ W[i2 - 8] ^ W[i2 - 14] ^ W[i2 - 16];
                W[i2] = n2 << 1 | n2 >>> 31;
              }
              var t2 = (a2 << 5 | a2 >>> 27) + e4 + W[i2];
              if (i2 < 20) {
                t2 += (b2 & c2 | ~b2 & d) + 1518500249;
              } else if (i2 < 40) {
                t2 += (b2 ^ c2 ^ d) + 1859775393;
              } else if (i2 < 60) {
                t2 += (b2 & c2 | b2 & d | c2 & d) - 1894007588;
              } else {
                t2 += (b2 ^ c2 ^ d) - 899497514;
              }
              e4 = d;
              d = c2;
              c2 = b2 << 30 | b2 >>> 2;
              b2 = a2;
              a2 = t2;
            }
            H[0] = H[0] + a2 | 0;
            H[1] = H[1] + b2 | 0;
            H[2] = H[2] + c2 | 0;
            H[3] = H[3] + d | 0;
            H[4] = H[4] + e4 | 0;
          },
          _doFinalize: function() {
            var data2 = this._data;
            var dataWords = data2.words;
            var nBitsTotal = this._nDataBytes * 8;
            var nBitsLeft = data2.sigBytes * 8;
            dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
            dataWords[(nBitsLeft + 64 >>> 9 << 4) + 14] = Math.floor(nBitsTotal / 4294967296);
            dataWords[(nBitsLeft + 64 >>> 9 << 4) + 15] = nBitsTotal;
            data2.sigBytes = dataWords.length * 4;
            this._process();
            return this._hash;
          },
          clone: function() {
            var clone2 = Hasher.clone.call(this);
            clone2._hash = this._hash.clone();
            return clone2;
          }
        });
        C2.SHA1 = Hasher._createHelper(SHA1);
        C2.HmacSHA1 = Hasher._createHmacHelper(SHA1);
      })();
      return CryptoJS2.SHA1;
    });
  })(sha1$1);
  return sha1$1.exports;
}
var sha256$2 = { exports: {} };
var sha256$1 = sha256$2.exports;
var hasRequiredSha256;
function requireSha256() {
  if (hasRequiredSha256) return sha256$2.exports;
  hasRequiredSha256 = 1;
  (function(module2, exports) {
    (function(root, factory) {
      {
        module2.exports = factory(requireCore());
      }
    })(sha256$1, function(CryptoJS2) {
      (function(Math2) {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var WordArray = C_lib.WordArray;
        var Hasher = C_lib.Hasher;
        var C_algo = C2.algo;
        var H = [];
        var K = [];
        (function() {
          function isPrime(n3) {
            var sqrtN = Math2.sqrt(n3);
            for (var factor = 2; factor <= sqrtN; factor++) {
              if (!(n3 % factor)) {
                return false;
              }
            }
            return true;
          }
          function getFractionalBits(n3) {
            return (n3 - (n3 | 0)) * 4294967296 | 0;
          }
          var n2 = 2;
          var nPrime = 0;
          while (nPrime < 64) {
            if (isPrime(n2)) {
              if (nPrime < 8) {
                H[nPrime] = getFractionalBits(Math2.pow(n2, 1 / 2));
              }
              K[nPrime] = getFractionalBits(Math2.pow(n2, 1 / 3));
              nPrime++;
            }
            n2++;
          }
        })();
        var W = [];
        var SHA256 = C_algo.SHA256 = Hasher.extend({
          _doReset: function() {
            this._hash = new WordArray.init(H.slice(0));
          },
          _doProcessBlock: function(M2, offset) {
            var H2 = this._hash.words;
            var a2 = H2[0];
            var b2 = H2[1];
            var c2 = H2[2];
            var d = H2[3];
            var e4 = H2[4];
            var f2 = H2[5];
            var g = H2[6];
            var h2 = H2[7];
            for (var i2 = 0; i2 < 64; i2++) {
              if (i2 < 16) {
                W[i2] = M2[offset + i2] | 0;
              } else {
                var gamma0x = W[i2 - 15];
                var gamma0 = (gamma0x << 25 | gamma0x >>> 7) ^ (gamma0x << 14 | gamma0x >>> 18) ^ gamma0x >>> 3;
                var gamma1x = W[i2 - 2];
                var gamma1 = (gamma1x << 15 | gamma1x >>> 17) ^ (gamma1x << 13 | gamma1x >>> 19) ^ gamma1x >>> 10;
                W[i2] = gamma0 + W[i2 - 7] + gamma1 + W[i2 - 16];
              }
              var ch = e4 & f2 ^ ~e4 & g;
              var maj = a2 & b2 ^ a2 & c2 ^ b2 & c2;
              var sigma0 = (a2 << 30 | a2 >>> 2) ^ (a2 << 19 | a2 >>> 13) ^ (a2 << 10 | a2 >>> 22);
              var sigma1 = (e4 << 26 | e4 >>> 6) ^ (e4 << 21 | e4 >>> 11) ^ (e4 << 7 | e4 >>> 25);
              var t1 = h2 + sigma1 + ch + K[i2] + W[i2];
              var t2 = sigma0 + maj;
              h2 = g;
              g = f2;
              f2 = e4;
              e4 = d + t1 | 0;
              d = c2;
              c2 = b2;
              b2 = a2;
              a2 = t1 + t2 | 0;
            }
            H2[0] = H2[0] + a2 | 0;
            H2[1] = H2[1] + b2 | 0;
            H2[2] = H2[2] + c2 | 0;
            H2[3] = H2[3] + d | 0;
            H2[4] = H2[4] + e4 | 0;
            H2[5] = H2[5] + f2 | 0;
            H2[6] = H2[6] + g | 0;
            H2[7] = H2[7] + h2 | 0;
          },
          _doFinalize: function() {
            var data2 = this._data;
            var dataWords = data2.words;
            var nBitsTotal = this._nDataBytes * 8;
            var nBitsLeft = data2.sigBytes * 8;
            dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
            dataWords[(nBitsLeft + 64 >>> 9 << 4) + 14] = Math2.floor(nBitsTotal / 4294967296);
            dataWords[(nBitsLeft + 64 >>> 9 << 4) + 15] = nBitsTotal;
            data2.sigBytes = dataWords.length * 4;
            this._process();
            return this._hash;
          },
          clone: function() {
            var clone2 = Hasher.clone.call(this);
            clone2._hash = this._hash.clone();
            return clone2;
          }
        });
        C2.SHA256 = Hasher._createHelper(SHA256);
        C2.HmacSHA256 = Hasher._createHmacHelper(SHA256);
      })(Math);
      return CryptoJS2.SHA256;
    });
  })(sha256$2);
  return sha256$2.exports;
}
var sha224$1 = { exports: {} };
var sha224 = sha224$1.exports;
var hasRequiredSha224;
function requireSha224() {
  if (hasRequiredSha224) return sha224$1.exports;
  hasRequiredSha224 = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireSha256());
      }
    })(sha224, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var WordArray = C_lib.WordArray;
        var C_algo = C2.algo;
        var SHA256 = C_algo.SHA256;
        var SHA224 = C_algo.SHA224 = SHA256.extend({
          _doReset: function() {
            this._hash = new WordArray.init([
              3238371032,
              914150663,
              812702999,
              4144912697,
              4290775857,
              1750603025,
              1694076839,
              3204075428
            ]);
          },
          _doFinalize: function() {
            var hash2 = SHA256._doFinalize.call(this);
            hash2.sigBytes -= 4;
            return hash2;
          }
        });
        C2.SHA224 = SHA256._createHelper(SHA224);
        C2.HmacSHA224 = SHA256._createHmacHelper(SHA224);
      })();
      return CryptoJS2.SHA224;
    });
  })(sha224$1);
  return sha224$1.exports;
}
var sha512$1 = { exports: {} };
var sha512 = sha512$1.exports;
var hasRequiredSha512;
function requireSha512() {
  if (hasRequiredSha512) return sha512$1.exports;
  hasRequiredSha512 = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireX64Core());
      }
    })(sha512, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var Hasher = C_lib.Hasher;
        var C_x64 = C2.x64;
        var X64Word = C_x64.Word;
        var X64WordArray = C_x64.WordArray;
        var C_algo = C2.algo;
        function X64Word_create() {
          return X64Word.create.apply(X64Word, arguments);
        }
        var K = [
          X64Word_create(1116352408, 3609767458),
          X64Word_create(1899447441, 602891725),
          X64Word_create(3049323471, 3964484399),
          X64Word_create(3921009573, 2173295548),
          X64Word_create(961987163, 4081628472),
          X64Word_create(1508970993, 3053834265),
          X64Word_create(2453635748, 2937671579),
          X64Word_create(2870763221, 3664609560),
          X64Word_create(3624381080, 2734883394),
          X64Word_create(310598401, 1164996542),
          X64Word_create(607225278, 1323610764),
          X64Word_create(1426881987, 3590304994),
          X64Word_create(1925078388, 4068182383),
          X64Word_create(2162078206, 991336113),
          X64Word_create(2614888103, 633803317),
          X64Word_create(3248222580, 3479774868),
          X64Word_create(3835390401, 2666613458),
          X64Word_create(4022224774, 944711139),
          X64Word_create(264347078, 2341262773),
          X64Word_create(604807628, 2007800933),
          X64Word_create(770255983, 1495990901),
          X64Word_create(1249150122, 1856431235),
          X64Word_create(1555081692, 3175218132),
          X64Word_create(1996064986, 2198950837),
          X64Word_create(2554220882, 3999719339),
          X64Word_create(2821834349, 766784016),
          X64Word_create(2952996808, 2566594879),
          X64Word_create(3210313671, 3203337956),
          X64Word_create(3336571891, 1034457026),
          X64Word_create(3584528711, 2466948901),
          X64Word_create(113926993, 3758326383),
          X64Word_create(338241895, 168717936),
          X64Word_create(666307205, 1188179964),
          X64Word_create(773529912, 1546045734),
          X64Word_create(1294757372, 1522805485),
          X64Word_create(1396182291, 2643833823),
          X64Word_create(1695183700, 2343527390),
          X64Word_create(1986661051, 1014477480),
          X64Word_create(2177026350, 1206759142),
          X64Word_create(2456956037, 344077627),
          X64Word_create(2730485921, 1290863460),
          X64Word_create(2820302411, 3158454273),
          X64Word_create(3259730800, 3505952657),
          X64Word_create(3345764771, 106217008),
          X64Word_create(3516065817, 3606008344),
          X64Word_create(3600352804, 1432725776),
          X64Word_create(4094571909, 1467031594),
          X64Word_create(275423344, 851169720),
          X64Word_create(430227734, 3100823752),
          X64Word_create(506948616, 1363258195),
          X64Word_create(659060556, 3750685593),
          X64Word_create(883997877, 3785050280),
          X64Word_create(958139571, 3318307427),
          X64Word_create(1322822218, 3812723403),
          X64Word_create(1537002063, 2003034995),
          X64Word_create(1747873779, 3602036899),
          X64Word_create(1955562222, 1575990012),
          X64Word_create(2024104815, 1125592928),
          X64Word_create(2227730452, 2716904306),
          X64Word_create(2361852424, 442776044),
          X64Word_create(2428436474, 593698344),
          X64Word_create(2756734187, 3733110249),
          X64Word_create(3204031479, 2999351573),
          X64Word_create(3329325298, 3815920427),
          X64Word_create(3391569614, 3928383900),
          X64Word_create(3515267271, 566280711),
          X64Word_create(3940187606, 3454069534),
          X64Word_create(4118630271, 4000239992),
          X64Word_create(116418474, 1914138554),
          X64Word_create(174292421, 2731055270),
          X64Word_create(289380356, 3203993006),
          X64Word_create(460393269, 320620315),
          X64Word_create(685471733, 587496836),
          X64Word_create(852142971, 1086792851),
          X64Word_create(1017036298, 365543100),
          X64Word_create(1126000580, 2618297676),
          X64Word_create(1288033470, 3409855158),
          X64Word_create(1501505948, 4234509866),
          X64Word_create(1607167915, 987167468),
          X64Word_create(1816402316, 1246189591)
        ];
        var W = [];
        (function() {
          for (var i2 = 0; i2 < 80; i2++) {
            W[i2] = X64Word_create();
          }
        })();
        var SHA512 = C_algo.SHA512 = Hasher.extend({
          _doReset: function() {
            this._hash = new X64WordArray.init([
              new X64Word.init(1779033703, 4089235720),
              new X64Word.init(3144134277, 2227873595),
              new X64Word.init(1013904242, 4271175723),
              new X64Word.init(2773480762, 1595750129),
              new X64Word.init(1359893119, 2917565137),
              new X64Word.init(2600822924, 725511199),
              new X64Word.init(528734635, 4215389547),
              new X64Word.init(1541459225, 327033209)
            ]);
          },
          _doProcessBlock: function(M2, offset) {
            var H = this._hash.words;
            var H0 = H[0];
            var H1 = H[1];
            var H2 = H[2];
            var H3 = H[3];
            var H4 = H[4];
            var H5 = H[5];
            var H6 = H[6];
            var H7 = H[7];
            var H0h = H0.high;
            var H0l = H0.low;
            var H1h = H1.high;
            var H1l = H1.low;
            var H2h = H2.high;
            var H2l = H2.low;
            var H3h = H3.high;
            var H3l = H3.low;
            var H4h = H4.high;
            var H4l = H4.low;
            var H5h = H5.high;
            var H5l = H5.low;
            var H6h = H6.high;
            var H6l = H6.low;
            var H7h = H7.high;
            var H7l = H7.low;
            var ah = H0h;
            var al = H0l;
            var bh = H1h;
            var bl = H1l;
            var ch = H2h;
            var cl = H2l;
            var dh2 = H3h;
            var dl = H3l;
            var eh = H4h;
            var el = H4l;
            var fh = H5h;
            var fl = H5l;
            var gh = H6h;
            var gl = H6l;
            var hh = H7h;
            var hl = H7l;
            for (var i2 = 0; i2 < 80; i2++) {
              var Wil;
              var Wih;
              var Wi = W[i2];
              if (i2 < 16) {
                Wih = Wi.high = M2[offset + i2 * 2] | 0;
                Wil = Wi.low = M2[offset + i2 * 2 + 1] | 0;
              } else {
                var gamma0x = W[i2 - 15];
                var gamma0xh = gamma0x.high;
                var gamma0xl = gamma0x.low;
                var gamma0h = (gamma0xh >>> 1 | gamma0xl << 31) ^ (gamma0xh >>> 8 | gamma0xl << 24) ^ gamma0xh >>> 7;
                var gamma0l = (gamma0xl >>> 1 | gamma0xh << 31) ^ (gamma0xl >>> 8 | gamma0xh << 24) ^ (gamma0xl >>> 7 | gamma0xh << 25);
                var gamma1x = W[i2 - 2];
                var gamma1xh = gamma1x.high;
                var gamma1xl = gamma1x.low;
                var gamma1h = (gamma1xh >>> 19 | gamma1xl << 13) ^ (gamma1xh << 3 | gamma1xl >>> 29) ^ gamma1xh >>> 6;
                var gamma1l = (gamma1xl >>> 19 | gamma1xh << 13) ^ (gamma1xl << 3 | gamma1xh >>> 29) ^ (gamma1xl >>> 6 | gamma1xh << 26);
                var Wi7 = W[i2 - 7];
                var Wi7h = Wi7.high;
                var Wi7l = Wi7.low;
                var Wi16 = W[i2 - 16];
                var Wi16h = Wi16.high;
                var Wi16l = Wi16.low;
                Wil = gamma0l + Wi7l;
                Wih = gamma0h + Wi7h + (Wil >>> 0 < gamma0l >>> 0 ? 1 : 0);
                Wil = Wil + gamma1l;
                Wih = Wih + gamma1h + (Wil >>> 0 < gamma1l >>> 0 ? 1 : 0);
                Wil = Wil + Wi16l;
                Wih = Wih + Wi16h + (Wil >>> 0 < Wi16l >>> 0 ? 1 : 0);
                Wi.high = Wih;
                Wi.low = Wil;
              }
              var chh = eh & fh ^ ~eh & gh;
              var chl = el & fl ^ ~el & gl;
              var majh = ah & bh ^ ah & ch ^ bh & ch;
              var majl = al & bl ^ al & cl ^ bl & cl;
              var sigma0h = (ah >>> 28 | al << 4) ^ (ah << 30 | al >>> 2) ^ (ah << 25 | al >>> 7);
              var sigma0l = (al >>> 28 | ah << 4) ^ (al << 30 | ah >>> 2) ^ (al << 25 | ah >>> 7);
              var sigma1h = (eh >>> 14 | el << 18) ^ (eh >>> 18 | el << 14) ^ (eh << 23 | el >>> 9);
              var sigma1l = (el >>> 14 | eh << 18) ^ (el >>> 18 | eh << 14) ^ (el << 23 | eh >>> 9);
              var Ki = K[i2];
              var Kih = Ki.high;
              var Kil = Ki.low;
              var t1l = hl + sigma1l;
              var t1h = hh + sigma1h + (t1l >>> 0 < hl >>> 0 ? 1 : 0);
              var t1l = t1l + chl;
              var t1h = t1h + chh + (t1l >>> 0 < chl >>> 0 ? 1 : 0);
              var t1l = t1l + Kil;
              var t1h = t1h + Kih + (t1l >>> 0 < Kil >>> 0 ? 1 : 0);
              var t1l = t1l + Wil;
              var t1h = t1h + Wih + (t1l >>> 0 < Wil >>> 0 ? 1 : 0);
              var t2l = sigma0l + majl;
              var t2h = sigma0h + majh + (t2l >>> 0 < sigma0l >>> 0 ? 1 : 0);
              hh = gh;
              hl = gl;
              gh = fh;
              gl = fl;
              fh = eh;
              fl = el;
              el = dl + t1l | 0;
              eh = dh2 + t1h + (el >>> 0 < dl >>> 0 ? 1 : 0) | 0;
              dh2 = ch;
              dl = cl;
              ch = bh;
              cl = bl;
              bh = ah;
              bl = al;
              al = t1l + t2l | 0;
              ah = t1h + t2h + (al >>> 0 < t1l >>> 0 ? 1 : 0) | 0;
            }
            H0l = H0.low = H0l + al;
            H0.high = H0h + ah + (H0l >>> 0 < al >>> 0 ? 1 : 0);
            H1l = H1.low = H1l + bl;
            H1.high = H1h + bh + (H1l >>> 0 < bl >>> 0 ? 1 : 0);
            H2l = H2.low = H2l + cl;
            H2.high = H2h + ch + (H2l >>> 0 < cl >>> 0 ? 1 : 0);
            H3l = H3.low = H3l + dl;
            H3.high = H3h + dh2 + (H3l >>> 0 < dl >>> 0 ? 1 : 0);
            H4l = H4.low = H4l + el;
            H4.high = H4h + eh + (H4l >>> 0 < el >>> 0 ? 1 : 0);
            H5l = H5.low = H5l + fl;
            H5.high = H5h + fh + (H5l >>> 0 < fl >>> 0 ? 1 : 0);
            H6l = H6.low = H6l + gl;
            H6.high = H6h + gh + (H6l >>> 0 < gl >>> 0 ? 1 : 0);
            H7l = H7.low = H7l + hl;
            H7.high = H7h + hh + (H7l >>> 0 < hl >>> 0 ? 1 : 0);
          },
          _doFinalize: function() {
            var data2 = this._data;
            var dataWords = data2.words;
            var nBitsTotal = this._nDataBytes * 8;
            var nBitsLeft = data2.sigBytes * 8;
            dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
            dataWords[(nBitsLeft + 128 >>> 10 << 5) + 30] = Math.floor(nBitsTotal / 4294967296);
            dataWords[(nBitsLeft + 128 >>> 10 << 5) + 31] = nBitsTotal;
            data2.sigBytes = dataWords.length * 4;
            this._process();
            var hash2 = this._hash.toX32();
            return hash2;
          },
          clone: function() {
            var clone2 = Hasher.clone.call(this);
            clone2._hash = this._hash.clone();
            return clone2;
          },
          blockSize: 1024 / 32
        });
        C2.SHA512 = Hasher._createHelper(SHA512);
        C2.HmacSHA512 = Hasher._createHmacHelper(SHA512);
      })();
      return CryptoJS2.SHA512;
    });
  })(sha512$1);
  return sha512$1.exports;
}
var sha384$1 = { exports: {} };
var sha384 = sha384$1.exports;
var hasRequiredSha384;
function requireSha384() {
  if (hasRequiredSha384) return sha384$1.exports;
  hasRequiredSha384 = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireX64Core(), requireSha512());
      }
    })(sha384, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_x64 = C2.x64;
        var X64Word = C_x64.Word;
        var X64WordArray = C_x64.WordArray;
        var C_algo = C2.algo;
        var SHA512 = C_algo.SHA512;
        var SHA384 = C_algo.SHA384 = SHA512.extend({
          _doReset: function() {
            this._hash = new X64WordArray.init([
              new X64Word.init(3418070365, 3238371032),
              new X64Word.init(1654270250, 914150663),
              new X64Word.init(2438529370, 812702999),
              new X64Word.init(355462360, 4144912697),
              new X64Word.init(1731405415, 4290775857),
              new X64Word.init(2394180231, 1750603025),
              new X64Word.init(3675008525, 1694076839),
              new X64Word.init(1203062813, 3204075428)
            ]);
          },
          _doFinalize: function() {
            var hash2 = SHA512._doFinalize.call(this);
            hash2.sigBytes -= 16;
            return hash2;
          }
        });
        C2.SHA384 = SHA512._createHelper(SHA384);
        C2.HmacSHA384 = SHA512._createHmacHelper(SHA384);
      })();
      return CryptoJS2.SHA384;
    });
  })(sha384$1);
  return sha384$1.exports;
}
var sha3$1 = { exports: {} };
var sha3 = sha3$1.exports;
var hasRequiredSha3;
function requireSha3() {
  if (hasRequiredSha3) return sha3$1.exports;
  hasRequiredSha3 = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireX64Core());
      }
    })(sha3, function(CryptoJS2) {
      (function(Math2) {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var WordArray = C_lib.WordArray;
        var Hasher = C_lib.Hasher;
        var C_x64 = C2.x64;
        var X64Word = C_x64.Word;
        var C_algo = C2.algo;
        var RHO_OFFSETS = [];
        var PI_INDEXES = [];
        var ROUND_CONSTANTS = [];
        (function() {
          var x2 = 1, y2 = 0;
          for (var t2 = 0; t2 < 24; t2++) {
            RHO_OFFSETS[x2 + 5 * y2] = (t2 + 1) * (t2 + 2) / 2 % 64;
            var newX = y2 % 5;
            var newY = (2 * x2 + 3 * y2) % 5;
            x2 = newX;
            y2 = newY;
          }
          for (var x2 = 0; x2 < 5; x2++) {
            for (var y2 = 0; y2 < 5; y2++) {
              PI_INDEXES[x2 + 5 * y2] = y2 + (2 * x2 + 3 * y2) % 5 * 5;
            }
          }
          var LFSR = 1;
          for (var i2 = 0; i2 < 24; i2++) {
            var roundConstantMsw = 0;
            var roundConstantLsw = 0;
            for (var j = 0; j < 7; j++) {
              if (LFSR & 1) {
                var bitPosition = (1 << j) - 1;
                if (bitPosition < 32) {
                  roundConstantLsw ^= 1 << bitPosition;
                } else {
                  roundConstantMsw ^= 1 << bitPosition - 32;
                }
              }
              if (LFSR & 128) {
                LFSR = LFSR << 1 ^ 113;
              } else {
                LFSR <<= 1;
              }
            }
            ROUND_CONSTANTS[i2] = X64Word.create(roundConstantMsw, roundConstantLsw);
          }
        })();
        var T2 = [];
        (function() {
          for (var i2 = 0; i2 < 25; i2++) {
            T2[i2] = X64Word.create();
          }
        })();
        var SHA3 = C_algo.SHA3 = Hasher.extend({
          /**
           * Configuration options.
           *
           * @property {number} outputLength
           *   The desired number of bits in the output hash.
           *   Only values permitted are: 224, 256, 384, 512.
           *   Default: 512
           */
          cfg: Hasher.cfg.extend({
            outputLength: 512
          }),
          _doReset: function() {
            var state = this._state = [];
            for (var i2 = 0; i2 < 25; i2++) {
              state[i2] = new X64Word.init();
            }
            this.blockSize = (1600 - 2 * this.cfg.outputLength) / 32;
          },
          _doProcessBlock: function(M2, offset) {
            var state = this._state;
            var nBlockSizeLanes = this.blockSize / 2;
            for (var i2 = 0; i2 < nBlockSizeLanes; i2++) {
              var M2i = M2[offset + 2 * i2];
              var M2i1 = M2[offset + 2 * i2 + 1];
              M2i = (M2i << 8 | M2i >>> 24) & 16711935 | (M2i << 24 | M2i >>> 8) & 4278255360;
              M2i1 = (M2i1 << 8 | M2i1 >>> 24) & 16711935 | (M2i1 << 24 | M2i1 >>> 8) & 4278255360;
              var lane = state[i2];
              lane.high ^= M2i1;
              lane.low ^= M2i;
            }
            for (var round2 = 0; round2 < 24; round2++) {
              for (var x2 = 0; x2 < 5; x2++) {
                var tMsw = 0, tLsw = 0;
                for (var y2 = 0; y2 < 5; y2++) {
                  var lane = state[x2 + 5 * y2];
                  tMsw ^= lane.high;
                  tLsw ^= lane.low;
                }
                var Tx = T2[x2];
                Tx.high = tMsw;
                Tx.low = tLsw;
              }
              for (var x2 = 0; x2 < 5; x2++) {
                var Tx4 = T2[(x2 + 4) % 5];
                var Tx1 = T2[(x2 + 1) % 5];
                var Tx1Msw = Tx1.high;
                var Tx1Lsw = Tx1.low;
                var tMsw = Tx4.high ^ (Tx1Msw << 1 | Tx1Lsw >>> 31);
                var tLsw = Tx4.low ^ (Tx1Lsw << 1 | Tx1Msw >>> 31);
                for (var y2 = 0; y2 < 5; y2++) {
                  var lane = state[x2 + 5 * y2];
                  lane.high ^= tMsw;
                  lane.low ^= tLsw;
                }
              }
              for (var laneIndex = 1; laneIndex < 25; laneIndex++) {
                var tMsw;
                var tLsw;
                var lane = state[laneIndex];
                var laneMsw = lane.high;
                var laneLsw = lane.low;
                var rhoOffset = RHO_OFFSETS[laneIndex];
                if (rhoOffset < 32) {
                  tMsw = laneMsw << rhoOffset | laneLsw >>> 32 - rhoOffset;
                  tLsw = laneLsw << rhoOffset | laneMsw >>> 32 - rhoOffset;
                } else {
                  tMsw = laneLsw << rhoOffset - 32 | laneMsw >>> 64 - rhoOffset;
                  tLsw = laneMsw << rhoOffset - 32 | laneLsw >>> 64 - rhoOffset;
                }
                var TPiLane = T2[PI_INDEXES[laneIndex]];
                TPiLane.high = tMsw;
                TPiLane.low = tLsw;
              }
              var T0 = T2[0];
              var state0 = state[0];
              T0.high = state0.high;
              T0.low = state0.low;
              for (var x2 = 0; x2 < 5; x2++) {
                for (var y2 = 0; y2 < 5; y2++) {
                  var laneIndex = x2 + 5 * y2;
                  var lane = state[laneIndex];
                  var TLane = T2[laneIndex];
                  var Tx1Lane = T2[(x2 + 1) % 5 + 5 * y2];
                  var Tx2Lane = T2[(x2 + 2) % 5 + 5 * y2];
                  lane.high = TLane.high ^ ~Tx1Lane.high & Tx2Lane.high;
                  lane.low = TLane.low ^ ~Tx1Lane.low & Tx2Lane.low;
                }
              }
              var lane = state[0];
              var roundConstant = ROUND_CONSTANTS[round2];
              lane.high ^= roundConstant.high;
              lane.low ^= roundConstant.low;
            }
          },
          _doFinalize: function() {
            var data2 = this._data;
            var dataWords = data2.words;
            this._nDataBytes * 8;
            var nBitsLeft = data2.sigBytes * 8;
            var blockSizeBits = this.blockSize * 32;
            dataWords[nBitsLeft >>> 5] |= 1 << 24 - nBitsLeft % 32;
            dataWords[(Math2.ceil((nBitsLeft + 1) / blockSizeBits) * blockSizeBits >>> 5) - 1] |= 128;
            data2.sigBytes = dataWords.length * 4;
            this._process();
            var state = this._state;
            var outputLengthBytes = this.cfg.outputLength / 8;
            var outputLengthLanes = outputLengthBytes / 8;
            var hashWords = [];
            for (var i2 = 0; i2 < outputLengthLanes; i2++) {
              var lane = state[i2];
              var laneMsw = lane.high;
              var laneLsw = lane.low;
              laneMsw = (laneMsw << 8 | laneMsw >>> 24) & 16711935 | (laneMsw << 24 | laneMsw >>> 8) & 4278255360;
              laneLsw = (laneLsw << 8 | laneLsw >>> 24) & 16711935 | (laneLsw << 24 | laneLsw >>> 8) & 4278255360;
              hashWords.push(laneLsw);
              hashWords.push(laneMsw);
            }
            return new WordArray.init(hashWords, outputLengthBytes);
          },
          clone: function() {
            var clone2 = Hasher.clone.call(this);
            var state = clone2._state = this._state.slice(0);
            for (var i2 = 0; i2 < 25; i2++) {
              state[i2] = state[i2].clone();
            }
            return clone2;
          }
        });
        C2.SHA3 = Hasher._createHelper(SHA3);
        C2.HmacSHA3 = Hasher._createHmacHelper(SHA3);
      })(Math);
      return CryptoJS2.SHA3;
    });
  })(sha3$1);
  return sha3$1.exports;
}
var ripemd160$1 = { exports: {} };
var ripemd160 = ripemd160$1.exports;
var hasRequiredRipemd160;
function requireRipemd160() {
  if (hasRequiredRipemd160) return ripemd160$1.exports;
  hasRequiredRipemd160 = 1;
  (function(module2, exports) {
    (function(root, factory) {
      {
        module2.exports = factory(requireCore());
      }
    })(ripemd160, function(CryptoJS2) {
      /** @preserve
      			(c) 2012 by Cédric Mesnil. All rights reserved.
      
      			Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
      
      			    - Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
      			    - Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
      
      			THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
      			*/
      (function(Math2) {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var WordArray = C_lib.WordArray;
        var Hasher = C_lib.Hasher;
        var C_algo = C2.algo;
        var _zl = WordArray.create([
          0,
          1,
          2,
          3,
          4,
          5,
          6,
          7,
          8,
          9,
          10,
          11,
          12,
          13,
          14,
          15,
          7,
          4,
          13,
          1,
          10,
          6,
          15,
          3,
          12,
          0,
          9,
          5,
          2,
          14,
          11,
          8,
          3,
          10,
          14,
          4,
          9,
          15,
          8,
          1,
          2,
          7,
          0,
          6,
          13,
          11,
          5,
          12,
          1,
          9,
          11,
          10,
          0,
          8,
          12,
          4,
          13,
          3,
          7,
          15,
          14,
          5,
          6,
          2,
          4,
          0,
          5,
          9,
          7,
          12,
          2,
          10,
          14,
          1,
          3,
          8,
          11,
          6,
          15,
          13
        ]);
        var _zr = WordArray.create([
          5,
          14,
          7,
          0,
          9,
          2,
          11,
          4,
          13,
          6,
          15,
          8,
          1,
          10,
          3,
          12,
          6,
          11,
          3,
          7,
          0,
          13,
          5,
          10,
          14,
          15,
          8,
          12,
          4,
          9,
          1,
          2,
          15,
          5,
          1,
          3,
          7,
          14,
          6,
          9,
          11,
          8,
          12,
          2,
          10,
          0,
          4,
          13,
          8,
          6,
          4,
          1,
          3,
          11,
          15,
          0,
          5,
          12,
          2,
          13,
          9,
          7,
          10,
          14,
          12,
          15,
          10,
          4,
          1,
          5,
          8,
          7,
          6,
          2,
          13,
          14,
          0,
          3,
          9,
          11
        ]);
        var _sl = WordArray.create([
          11,
          14,
          15,
          12,
          5,
          8,
          7,
          9,
          11,
          13,
          14,
          15,
          6,
          7,
          9,
          8,
          7,
          6,
          8,
          13,
          11,
          9,
          7,
          15,
          7,
          12,
          15,
          9,
          11,
          7,
          13,
          12,
          11,
          13,
          6,
          7,
          14,
          9,
          13,
          15,
          14,
          8,
          13,
          6,
          5,
          12,
          7,
          5,
          11,
          12,
          14,
          15,
          14,
          15,
          9,
          8,
          9,
          14,
          5,
          6,
          8,
          6,
          5,
          12,
          9,
          15,
          5,
          11,
          6,
          8,
          13,
          12,
          5,
          12,
          13,
          14,
          11,
          8,
          5,
          6
        ]);
        var _sr = WordArray.create([
          8,
          9,
          9,
          11,
          13,
          15,
          15,
          5,
          7,
          7,
          8,
          11,
          14,
          14,
          12,
          6,
          9,
          13,
          15,
          7,
          12,
          8,
          9,
          11,
          7,
          7,
          12,
          7,
          6,
          15,
          13,
          11,
          9,
          7,
          15,
          11,
          8,
          6,
          6,
          14,
          12,
          13,
          5,
          14,
          13,
          13,
          7,
          5,
          15,
          5,
          8,
          11,
          14,
          14,
          6,
          14,
          6,
          9,
          12,
          9,
          12,
          5,
          15,
          8,
          8,
          5,
          12,
          9,
          12,
          5,
          14,
          6,
          8,
          13,
          6,
          5,
          15,
          13,
          11,
          11
        ]);
        var _hl = WordArray.create([0, 1518500249, 1859775393, 2400959708, 2840853838]);
        var _hr = WordArray.create([1352829926, 1548603684, 1836072691, 2053994217, 0]);
        var RIPEMD160 = C_algo.RIPEMD160 = Hasher.extend({
          _doReset: function() {
            this._hash = WordArray.create([1732584193, 4023233417, 2562383102, 271733878, 3285377520]);
          },
          _doProcessBlock: function(M2, offset) {
            for (var i2 = 0; i2 < 16; i2++) {
              var offset_i = offset + i2;
              var M_offset_i = M2[offset_i];
              M2[offset_i] = (M_offset_i << 8 | M_offset_i >>> 24) & 16711935 | (M_offset_i << 24 | M_offset_i >>> 8) & 4278255360;
            }
            var H = this._hash.words;
            var hl = _hl.words;
            var hr = _hr.words;
            var zl = _zl.words;
            var zr = _zr.words;
            var sl = _sl.words;
            var sr = _sr.words;
            var al, bl, cl, dl, el;
            var ar, br, cr, dr, er;
            ar = al = H[0];
            br = bl = H[1];
            cr = cl = H[2];
            dr = dl = H[3];
            er = el = H[4];
            var t2;
            for (var i2 = 0; i2 < 80; i2 += 1) {
              t2 = al + M2[offset + zl[i2]] | 0;
              if (i2 < 16) {
                t2 += f1(bl, cl, dl) + hl[0];
              } else if (i2 < 32) {
                t2 += f2(bl, cl, dl) + hl[1];
              } else if (i2 < 48) {
                t2 += f3(bl, cl, dl) + hl[2];
              } else if (i2 < 64) {
                t2 += f4(bl, cl, dl) + hl[3];
              } else {
                t2 += f5(bl, cl, dl) + hl[4];
              }
              t2 = t2 | 0;
              t2 = rotl2(t2, sl[i2]);
              t2 = t2 + el | 0;
              al = el;
              el = dl;
              dl = rotl2(cl, 10);
              cl = bl;
              bl = t2;
              t2 = ar + M2[offset + zr[i2]] | 0;
              if (i2 < 16) {
                t2 += f5(br, cr, dr) + hr[0];
              } else if (i2 < 32) {
                t2 += f4(br, cr, dr) + hr[1];
              } else if (i2 < 48) {
                t2 += f3(br, cr, dr) + hr[2];
              } else if (i2 < 64) {
                t2 += f2(br, cr, dr) + hr[3];
              } else {
                t2 += f1(br, cr, dr) + hr[4];
              }
              t2 = t2 | 0;
              t2 = rotl2(t2, sr[i2]);
              t2 = t2 + er | 0;
              ar = er;
              er = dr;
              dr = rotl2(cr, 10);
              cr = br;
              br = t2;
            }
            t2 = H[1] + cl + dr | 0;
            H[1] = H[2] + dl + er | 0;
            H[2] = H[3] + el + ar | 0;
            H[3] = H[4] + al + br | 0;
            H[4] = H[0] + bl + cr | 0;
            H[0] = t2;
          },
          _doFinalize: function() {
            var data2 = this._data;
            var dataWords = data2.words;
            var nBitsTotal = this._nDataBytes * 8;
            var nBitsLeft = data2.sigBytes * 8;
            dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
            dataWords[(nBitsLeft + 64 >>> 9 << 4) + 14] = (nBitsTotal << 8 | nBitsTotal >>> 24) & 16711935 | (nBitsTotal << 24 | nBitsTotal >>> 8) & 4278255360;
            data2.sigBytes = (dataWords.length + 1) * 4;
            this._process();
            var hash2 = this._hash;
            var H = hash2.words;
            for (var i2 = 0; i2 < 5; i2++) {
              var H_i = H[i2];
              H[i2] = (H_i << 8 | H_i >>> 24) & 16711935 | (H_i << 24 | H_i >>> 8) & 4278255360;
            }
            return hash2;
          },
          clone: function() {
            var clone2 = Hasher.clone.call(this);
            clone2._hash = this._hash.clone();
            return clone2;
          }
        });
        function f1(x2, y2, z2) {
          return x2 ^ y2 ^ z2;
        }
        function f2(x2, y2, z2) {
          return x2 & y2 | ~x2 & z2;
        }
        function f3(x2, y2, z2) {
          return (x2 | ~y2) ^ z2;
        }
        function f4(x2, y2, z2) {
          return x2 & z2 | y2 & ~z2;
        }
        function f5(x2, y2, z2) {
          return x2 ^ (y2 | ~z2);
        }
        function rotl2(x2, n2) {
          return x2 << n2 | x2 >>> 32 - n2;
        }
        C2.RIPEMD160 = Hasher._createHelper(RIPEMD160);
        C2.HmacRIPEMD160 = Hasher._createHmacHelper(RIPEMD160);
      })();
      return CryptoJS2.RIPEMD160;
    });
  })(ripemd160$1);
  return ripemd160$1.exports;
}
var hmac$1 = { exports: {} };
var hmac = hmac$1.exports;
var hasRequiredHmac;
function requireHmac() {
  if (hasRequiredHmac) return hmac$1.exports;
  hasRequiredHmac = 1;
  (function(module2, exports) {
    (function(root, factory) {
      {
        module2.exports = factory(requireCore());
      }
    })(hmac, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var Base = C_lib.Base;
        var C_enc = C2.enc;
        var Utf8 = C_enc.Utf8;
        var C_algo = C2.algo;
        C_algo.HMAC = Base.extend({
          /**
           * Initializes a newly created HMAC.
           *
           * @param {Hasher} hasher The hash algorithm to use.
           * @param {WordArray|string} key The secret key.
           *
           * @example
           *
           *     var hmacHasher = CryptoJS.algo.HMAC.create(CryptoJS.algo.SHA256, key);
           */
          init: function(hasher, key2) {
            hasher = this._hasher = new hasher.init();
            if (typeof key2 == "string") {
              key2 = Utf8.parse(key2);
            }
            var hasherBlockSize = hasher.blockSize;
            var hasherBlockSizeBytes = hasherBlockSize * 4;
            if (key2.sigBytes > hasherBlockSizeBytes) {
              key2 = hasher.finalize(key2);
            }
            key2.clamp();
            var oKey = this._oKey = key2.clone();
            var iKey = this._iKey = key2.clone();
            var oKeyWords = oKey.words;
            var iKeyWords = iKey.words;
            for (var i2 = 0; i2 < hasherBlockSize; i2++) {
              oKeyWords[i2] ^= 1549556828;
              iKeyWords[i2] ^= 909522486;
            }
            oKey.sigBytes = iKey.sigBytes = hasherBlockSizeBytes;
            this.reset();
          },
          /**
           * Resets this HMAC to its initial state.
           *
           * @example
           *
           *     hmacHasher.reset();
           */
          reset: function() {
            var hasher = this._hasher;
            hasher.reset();
            hasher.update(this._iKey);
          },
          /**
           * Updates this HMAC with a message.
           *
           * @param {WordArray|string} messageUpdate The message to append.
           *
           * @return {HMAC} This HMAC instance.
           *
           * @example
           *
           *     hmacHasher.update('message');
           *     hmacHasher.update(wordArray);
           */
          update: function(messageUpdate) {
            this._hasher.update(messageUpdate);
            return this;
          },
          /**
           * Finalizes the HMAC computation.
           * Note that the finalize operation is effectively a destructive, read-once operation.
           *
           * @param {WordArray|string} messageUpdate (Optional) A final message update.
           *
           * @return {WordArray} The HMAC.
           *
           * @example
           *
           *     var hmac = hmacHasher.finalize();
           *     var hmac = hmacHasher.finalize('message');
           *     var hmac = hmacHasher.finalize(wordArray);
           */
          finalize: function(messageUpdate) {
            var hasher = this._hasher;
            var innerHash = hasher.finalize(messageUpdate);
            hasher.reset();
            var hmac2 = hasher.finalize(this._oKey.clone().concat(innerHash));
            return hmac2;
          }
        });
      })();
    });
  })(hmac$1);
  return hmac$1.exports;
}
var pbkdf2$1 = { exports: {} };
var pbkdf2 = pbkdf2$1.exports;
var hasRequiredPbkdf2;
function requirePbkdf2() {
  if (hasRequiredPbkdf2) return pbkdf2$1.exports;
  hasRequiredPbkdf2 = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireSha256(), requireHmac());
      }
    })(pbkdf2, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var Base = C_lib.Base;
        var WordArray = C_lib.WordArray;
        var C_algo = C2.algo;
        var SHA256 = C_algo.SHA256;
        var HMAC = C_algo.HMAC;
        var PBKDF2 = C_algo.PBKDF2 = Base.extend({
          /**
           * Configuration options.
           *
           * @property {number} keySize The key size in words to generate. Default: 4 (128 bits)
           * @property {Hasher} hasher The hasher to use. Default: SHA256
           * @property {number} iterations The number of iterations to perform. Default: 250000
           */
          cfg: Base.extend({
            keySize: 128 / 32,
            hasher: SHA256,
            iterations: 25e4
          }),
          /**
           * Initializes a newly created key derivation function.
           *
           * @param {Object} cfg (Optional) The configuration options to use for the derivation.
           *
           * @example
           *
           *     var kdf = CryptoJS.algo.PBKDF2.create();
           *     var kdf = CryptoJS.algo.PBKDF2.create({ keySize: 8 });
           *     var kdf = CryptoJS.algo.PBKDF2.create({ keySize: 8, iterations: 1000 });
           */
          init: function(cfg) {
            this.cfg = this.cfg.extend(cfg);
          },
          /**
           * Computes the Password-Based Key Derivation Function 2.
           *
           * @param {WordArray|string} password The password.
           * @param {WordArray|string} salt A salt.
           *
           * @return {WordArray} The derived key.
           *
           * @example
           *
           *     var key = kdf.compute(password, salt);
           */
          compute: function(password, salt) {
            var cfg = this.cfg;
            var hmac2 = HMAC.create(cfg.hasher, password);
            var derivedKey = WordArray.create();
            var blockIndex = WordArray.create([1]);
            var derivedKeyWords = derivedKey.words;
            var blockIndexWords = blockIndex.words;
            var keySize = cfg.keySize;
            var iterations = cfg.iterations;
            while (derivedKeyWords.length < keySize) {
              var block = hmac2.update(salt).finalize(blockIndex);
              hmac2.reset();
              var blockWords = block.words;
              var blockWordsLength = blockWords.length;
              var intermediate = block;
              for (var i2 = 1; i2 < iterations; i2++) {
                intermediate = hmac2.finalize(intermediate);
                hmac2.reset();
                var intermediateWords = intermediate.words;
                for (var j = 0; j < blockWordsLength; j++) {
                  blockWords[j] ^= intermediateWords[j];
                }
              }
              derivedKey.concat(block);
              blockIndexWords[0]++;
            }
            derivedKey.sigBytes = keySize * 4;
            return derivedKey;
          }
        });
        C2.PBKDF2 = function(password, salt, cfg) {
          return PBKDF2.create(cfg).compute(password, salt);
        };
      })();
      return CryptoJS2.PBKDF2;
    });
  })(pbkdf2$1);
  return pbkdf2$1.exports;
}
var evpkdf$1 = { exports: {} };
var evpkdf = evpkdf$1.exports;
var hasRequiredEvpkdf;
function requireEvpkdf() {
  if (hasRequiredEvpkdf) return evpkdf$1.exports;
  hasRequiredEvpkdf = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireSha1(), requireHmac());
      }
    })(evpkdf, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var Base = C_lib.Base;
        var WordArray = C_lib.WordArray;
        var C_algo = C2.algo;
        var MD5 = C_algo.MD5;
        var EvpKDF = C_algo.EvpKDF = Base.extend({
          /**
           * Configuration options.
           *
           * @property {number} keySize The key size in words to generate. Default: 4 (128 bits)
           * @property {Hasher} hasher The hash algorithm to use. Default: MD5
           * @property {number} iterations The number of iterations to perform. Default: 1
           */
          cfg: Base.extend({
            keySize: 128 / 32,
            hasher: MD5,
            iterations: 1
          }),
          /**
           * Initializes a newly created key derivation function.
           *
           * @param {Object} cfg (Optional) The configuration options to use for the derivation.
           *
           * @example
           *
           *     var kdf = CryptoJS.algo.EvpKDF.create();
           *     var kdf = CryptoJS.algo.EvpKDF.create({ keySize: 8 });
           *     var kdf = CryptoJS.algo.EvpKDF.create({ keySize: 8, iterations: 1000 });
           */
          init: function(cfg) {
            this.cfg = this.cfg.extend(cfg);
          },
          /**
           * Derives a key from a password.
           *
           * @param {WordArray|string} password The password.
           * @param {WordArray|string} salt A salt.
           *
           * @return {WordArray} The derived key.
           *
           * @example
           *
           *     var key = kdf.compute(password, salt);
           */
          compute: function(password, salt) {
            var block;
            var cfg = this.cfg;
            var hasher = cfg.hasher.create();
            var derivedKey = WordArray.create();
            var derivedKeyWords = derivedKey.words;
            var keySize = cfg.keySize;
            var iterations = cfg.iterations;
            while (derivedKeyWords.length < keySize) {
              if (block) {
                hasher.update(block);
              }
              block = hasher.update(password).finalize(salt);
              hasher.reset();
              for (var i2 = 1; i2 < iterations; i2++) {
                block = hasher.finalize(block);
                hasher.reset();
              }
              derivedKey.concat(block);
            }
            derivedKey.sigBytes = keySize * 4;
            return derivedKey;
          }
        });
        C2.EvpKDF = function(password, salt, cfg) {
          return EvpKDF.create(cfg).compute(password, salt);
        };
      })();
      return CryptoJS2.EvpKDF;
    });
  })(evpkdf$1);
  return evpkdf$1.exports;
}
var cipherCore$1 = { exports: {} };
var cipherCore = cipherCore$1.exports;
var hasRequiredCipherCore;
function requireCipherCore() {
  if (hasRequiredCipherCore) return cipherCore$1.exports;
  hasRequiredCipherCore = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireEvpkdf());
      }
    })(cipherCore, function(CryptoJS2) {
      CryptoJS2.lib.Cipher || function(undefined$1) {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var Base = C_lib.Base;
        var WordArray = C_lib.WordArray;
        var BufferedBlockAlgorithm = C_lib.BufferedBlockAlgorithm;
        var C_enc = C2.enc;
        C_enc.Utf8;
        var Base642 = C_enc.Base64;
        var C_algo = C2.algo;
        var EvpKDF = C_algo.EvpKDF;
        var Cipher = C_lib.Cipher = BufferedBlockAlgorithm.extend({
          /**
           * Configuration options.
           *
           * @property {WordArray} iv The IV to use for this operation.
           */
          cfg: Base.extend(),
          /**
           * Creates this cipher in encryption mode.
           *
           * @param {WordArray} key The key.
           * @param {Object} cfg (Optional) The configuration options to use for this operation.
           *
           * @return {Cipher} A cipher instance.
           *
           * @static
           *
           * @example
           *
           *     var cipher = CryptoJS.algo.AES.createEncryptor(keyWordArray, { iv: ivWordArray });
           */
          createEncryptor: function(key2, cfg) {
            return this.create(this._ENC_XFORM_MODE, key2, cfg);
          },
          /**
           * Creates this cipher in decryption mode.
           *
           * @param {WordArray} key The key.
           * @param {Object} cfg (Optional) The configuration options to use for this operation.
           *
           * @return {Cipher} A cipher instance.
           *
           * @static
           *
           * @example
           *
           *     var cipher = CryptoJS.algo.AES.createDecryptor(keyWordArray, { iv: ivWordArray });
           */
          createDecryptor: function(key2, cfg) {
            return this.create(this._DEC_XFORM_MODE, key2, cfg);
          },
          /**
           * Initializes a newly created cipher.
           *
           * @param {number} xformMode Either the encryption or decryption transormation mode constant.
           * @param {WordArray} key The key.
           * @param {Object} cfg (Optional) The configuration options to use for this operation.
           *
           * @example
           *
           *     var cipher = CryptoJS.algo.AES.create(CryptoJS.algo.AES._ENC_XFORM_MODE, keyWordArray, { iv: ivWordArray });
           */
          init: function(xformMode, key2, cfg) {
            this.cfg = this.cfg.extend(cfg);
            this._xformMode = xformMode;
            this._key = key2;
            this.reset();
          },
          /**
           * Resets this cipher to its initial state.
           *
           * @example
           *
           *     cipher.reset();
           */
          reset: function() {
            BufferedBlockAlgorithm.reset.call(this);
            this._doReset();
          },
          /**
           * Adds data to be encrypted or decrypted.
           *
           * @param {WordArray|string} dataUpdate The data to encrypt or decrypt.
           *
           * @return {WordArray} The data after processing.
           *
           * @example
           *
           *     var encrypted = cipher.process('data');
           *     var encrypted = cipher.process(wordArray);
           */
          process: function(dataUpdate) {
            this._append(dataUpdate);
            return this._process();
          },
          /**
           * Finalizes the encryption or decryption process.
           * Note that the finalize operation is effectively a destructive, read-once operation.
           *
           * @param {WordArray|string} dataUpdate The final data to encrypt or decrypt.
           *
           * @return {WordArray} The data after final processing.
           *
           * @example
           *
           *     var encrypted = cipher.finalize();
           *     var encrypted = cipher.finalize('data');
           *     var encrypted = cipher.finalize(wordArray);
           */
          finalize: function(dataUpdate) {
            if (dataUpdate) {
              this._append(dataUpdate);
            }
            var finalProcessedData = this._doFinalize();
            return finalProcessedData;
          },
          keySize: 128 / 32,
          ivSize: 128 / 32,
          _ENC_XFORM_MODE: 1,
          _DEC_XFORM_MODE: 2,
          /**
           * Creates shortcut functions to a cipher's object interface.
           *
           * @param {Cipher} cipher The cipher to create a helper for.
           *
           * @return {Object} An object with encrypt and decrypt shortcut functions.
           *
           * @static
           *
           * @example
           *
           *     var AES = CryptoJS.lib.Cipher._createHelper(CryptoJS.algo.AES);
           */
          _createHelper: /* @__PURE__ */ function() {
            function selectCipherStrategy(key2) {
              if (typeof key2 == "string") {
                return PasswordBasedCipher;
              } else {
                return SerializableCipher;
              }
            }
            return function(cipher2) {
              return {
                encrypt: function(message, key2, cfg) {
                  return selectCipherStrategy(key2).encrypt(cipher2, message, key2, cfg);
                },
                decrypt: function(ciphertext, key2, cfg) {
                  return selectCipherStrategy(key2).decrypt(cipher2, ciphertext, key2, cfg);
                }
              };
            };
          }()
        });
        C_lib.StreamCipher = Cipher.extend({
          _doFinalize: function() {
            var finalProcessedBlocks = this._process(true);
            return finalProcessedBlocks;
          },
          blockSize: 1
        });
        var C_mode = C2.mode = {};
        var BlockCipherMode = C_lib.BlockCipherMode = Base.extend({
          /**
           * Creates this mode for encryption.
           *
           * @param {Cipher} cipher A block cipher instance.
           * @param {Array} iv The IV words.
           *
           * @static
           *
           * @example
           *
           *     var mode = CryptoJS.mode.CBC.createEncryptor(cipher, iv.words);
           */
          createEncryptor: function(cipher2, iv) {
            return this.Encryptor.create(cipher2, iv);
          },
          /**
           * Creates this mode for decryption.
           *
           * @param {Cipher} cipher A block cipher instance.
           * @param {Array} iv The IV words.
           *
           * @static
           *
           * @example
           *
           *     var mode = CryptoJS.mode.CBC.createDecryptor(cipher, iv.words);
           */
          createDecryptor: function(cipher2, iv) {
            return this.Decryptor.create(cipher2, iv);
          },
          /**
           * Initializes a newly created mode.
           *
           * @param {Cipher} cipher A block cipher instance.
           * @param {Array} iv The IV words.
           *
           * @example
           *
           *     var mode = CryptoJS.mode.CBC.Encryptor.create(cipher, iv.words);
           */
          init: function(cipher2, iv) {
            this._cipher = cipher2;
            this._iv = iv;
          }
        });
        var CBC = C_mode.CBC = function() {
          var CBC2 = BlockCipherMode.extend();
          CBC2.Encryptor = CBC2.extend({
            /**
             * Processes the data block at offset.
             *
             * @param {Array} words The data words to operate on.
             * @param {number} offset The offset where the block starts.
             *
             * @example
             *
             *     mode.processBlock(data.words, offset);
             */
            processBlock: function(words, offset) {
              var cipher2 = this._cipher;
              var blockSize = cipher2.blockSize;
              xorBlock.call(this, words, offset, blockSize);
              cipher2.encryptBlock(words, offset);
              this._prevBlock = words.slice(offset, offset + blockSize);
            }
          });
          CBC2.Decryptor = CBC2.extend({
            /**
             * Processes the data block at offset.
             *
             * @param {Array} words The data words to operate on.
             * @param {number} offset The offset where the block starts.
             *
             * @example
             *
             *     mode.processBlock(data.words, offset);
             */
            processBlock: function(words, offset) {
              var cipher2 = this._cipher;
              var blockSize = cipher2.blockSize;
              var thisBlock = words.slice(offset, offset + blockSize);
              cipher2.decryptBlock(words, offset);
              xorBlock.call(this, words, offset, blockSize);
              this._prevBlock = thisBlock;
            }
          });
          function xorBlock(words, offset, blockSize) {
            var block;
            var iv = this._iv;
            if (iv) {
              block = iv;
              this._iv = undefined$1;
            } else {
              block = this._prevBlock;
            }
            for (var i2 = 0; i2 < blockSize; i2++) {
              words[offset + i2] ^= block[i2];
            }
          }
          return CBC2;
        }();
        var C_pad = C2.pad = {};
        var Pkcs7 = C_pad.Pkcs7 = {
          /**
           * Pads data using the algorithm defined in PKCS #5/7.
           *
           * @param {WordArray} data The data to pad.
           * @param {number} blockSize The multiple that the data should be padded to.
           *
           * @static
           *
           * @example
           *
           *     CryptoJS.pad.Pkcs7.pad(wordArray, 4);
           */
          pad: function(data2, blockSize) {
            var blockSizeBytes = blockSize * 4;
            var nPaddingBytes = blockSizeBytes - data2.sigBytes % blockSizeBytes;
            var paddingWord = nPaddingBytes << 24 | nPaddingBytes << 16 | nPaddingBytes << 8 | nPaddingBytes;
            var paddingWords = [];
            for (var i2 = 0; i2 < nPaddingBytes; i2 += 4) {
              paddingWords.push(paddingWord);
            }
            var padding = WordArray.create(paddingWords, nPaddingBytes);
            data2.concat(padding);
          },
          /**
           * Unpads data that had been padded using the algorithm defined in PKCS #5/7.
           *
           * @param {WordArray} data The data to unpad.
           *
           * @static
           *
           * @example
           *
           *     CryptoJS.pad.Pkcs7.unpad(wordArray);
           */
          unpad: function(data2) {
            var nPaddingBytes = data2.words[data2.sigBytes - 1 >>> 2] & 255;
            data2.sigBytes -= nPaddingBytes;
          }
        };
        C_lib.BlockCipher = Cipher.extend({
          /**
           * Configuration options.
           *
           * @property {Mode} mode The block mode to use. Default: CBC
           * @property {Padding} padding The padding strategy to use. Default: Pkcs7
           */
          cfg: Cipher.cfg.extend({
            mode: CBC,
            padding: Pkcs7
          }),
          reset: function() {
            var modeCreator;
            Cipher.reset.call(this);
            var cfg = this.cfg;
            var iv = cfg.iv;
            var mode = cfg.mode;
            if (this._xformMode == this._ENC_XFORM_MODE) {
              modeCreator = mode.createEncryptor;
            } else {
              modeCreator = mode.createDecryptor;
              this._minBufferSize = 1;
            }
            if (this._mode && this._mode.__creator == modeCreator) {
              this._mode.init(this, iv && iv.words);
            } else {
              this._mode = modeCreator.call(mode, this, iv && iv.words);
              this._mode.__creator = modeCreator;
            }
          },
          _doProcessBlock: function(words, offset) {
            this._mode.processBlock(words, offset);
          },
          _doFinalize: function() {
            var finalProcessedBlocks;
            var padding = this.cfg.padding;
            if (this._xformMode == this._ENC_XFORM_MODE) {
              padding.pad(this._data, this.blockSize);
              finalProcessedBlocks = this._process(true);
            } else {
              finalProcessedBlocks = this._process(true);
              padding.unpad(finalProcessedBlocks);
            }
            return finalProcessedBlocks;
          },
          blockSize: 128 / 32
        });
        var CipherParams = C_lib.CipherParams = Base.extend({
          /**
           * Initializes a newly created cipher params object.
           *
           * @param {Object} cipherParams An object with any of the possible cipher parameters.
           *
           * @example
           *
           *     var cipherParams = CryptoJS.lib.CipherParams.create({
           *         ciphertext: ciphertextWordArray,
           *         key: keyWordArray,
           *         iv: ivWordArray,
           *         salt: saltWordArray,
           *         algorithm: CryptoJS.algo.AES,
           *         mode: CryptoJS.mode.CBC,
           *         padding: CryptoJS.pad.PKCS7,
           *         blockSize: 4,
           *         formatter: CryptoJS.format.OpenSSL
           *     });
           */
          init: function(cipherParams) {
            this.mixIn(cipherParams);
          },
          /**
           * Converts this cipher params object to a string.
           *
           * @param {Format} formatter (Optional) The formatting strategy to use.
           *
           * @return {string} The stringified cipher params.
           *
           * @throws Error If neither the formatter nor the default formatter is set.
           *
           * @example
           *
           *     var string = cipherParams + '';
           *     var string = cipherParams.toString();
           *     var string = cipherParams.toString(CryptoJS.format.OpenSSL);
           */
          toString: function(formatter) {
            return (formatter || this.formatter).stringify(this);
          }
        });
        var C_format = C2.format = {};
        var OpenSSLFormatter = C_format.OpenSSL = {
          /**
           * Converts a cipher params object to an OpenSSL-compatible string.
           *
           * @param {CipherParams} cipherParams The cipher params object.
           *
           * @return {string} The OpenSSL-compatible string.
           *
           * @static
           *
           * @example
           *
           *     var openSSLString = CryptoJS.format.OpenSSL.stringify(cipherParams);
           */
          stringify: function(cipherParams) {
            var wordArray;
            var ciphertext = cipherParams.ciphertext;
            var salt = cipherParams.salt;
            if (salt) {
              wordArray = WordArray.create([1398893684, 1701076831]).concat(salt).concat(ciphertext);
            } else {
              wordArray = ciphertext;
            }
            return wordArray.toString(Base642);
          },
          /**
           * Converts an OpenSSL-compatible string to a cipher params object.
           *
           * @param {string} openSSLStr The OpenSSL-compatible string.
           *
           * @return {CipherParams} The cipher params object.
           *
           * @static
           *
           * @example
           *
           *     var cipherParams = CryptoJS.format.OpenSSL.parse(openSSLString);
           */
          parse: function(openSSLStr) {
            var salt;
            var ciphertext = Base642.parse(openSSLStr);
            var ciphertextWords = ciphertext.words;
            if (ciphertextWords[0] == 1398893684 && ciphertextWords[1] == 1701076831) {
              salt = WordArray.create(ciphertextWords.slice(2, 4));
              ciphertextWords.splice(0, 4);
              ciphertext.sigBytes -= 16;
            }
            return CipherParams.create({ ciphertext, salt });
          }
        };
        var SerializableCipher = C_lib.SerializableCipher = Base.extend({
          /**
           * Configuration options.
           *
           * @property {Formatter} format The formatting strategy to convert cipher param objects to and from a string. Default: OpenSSL
           */
          cfg: Base.extend({
            format: OpenSSLFormatter
          }),
          /**
           * Encrypts a message.
           *
           * @param {Cipher} cipher The cipher algorithm to use.
           * @param {WordArray|string} message The message to encrypt.
           * @param {WordArray} key The key.
           * @param {Object} cfg (Optional) The configuration options to use for this operation.
           *
           * @return {CipherParams} A cipher params object.
           *
           * @static
           *
           * @example
           *
           *     var ciphertextParams = CryptoJS.lib.SerializableCipher.encrypt(CryptoJS.algo.AES, message, key);
           *     var ciphertextParams = CryptoJS.lib.SerializableCipher.encrypt(CryptoJS.algo.AES, message, key, { iv: iv });
           *     var ciphertextParams = CryptoJS.lib.SerializableCipher.encrypt(CryptoJS.algo.AES, message, key, { iv: iv, format: CryptoJS.format.OpenSSL });
           */
          encrypt: function(cipher2, message, key2, cfg) {
            cfg = this.cfg.extend(cfg);
            var encryptor = cipher2.createEncryptor(key2, cfg);
            var ciphertext = encryptor.finalize(message);
            var cipherCfg = encryptor.cfg;
            return CipherParams.create({
              ciphertext,
              key: key2,
              iv: cipherCfg.iv,
              algorithm: cipher2,
              mode: cipherCfg.mode,
              padding: cipherCfg.padding,
              blockSize: cipher2.blockSize,
              formatter: cfg.format
            });
          },
          /**
           * Decrypts serialized ciphertext.
           *
           * @param {Cipher} cipher The cipher algorithm to use.
           * @param {CipherParams|string} ciphertext The ciphertext to decrypt.
           * @param {WordArray} key The key.
           * @param {Object} cfg (Optional) The configuration options to use for this operation.
           *
           * @return {WordArray} The plaintext.
           *
           * @static
           *
           * @example
           *
           *     var plaintext = CryptoJS.lib.SerializableCipher.decrypt(CryptoJS.algo.AES, formattedCiphertext, key, { iv: iv, format: CryptoJS.format.OpenSSL });
           *     var plaintext = CryptoJS.lib.SerializableCipher.decrypt(CryptoJS.algo.AES, ciphertextParams, key, { iv: iv, format: CryptoJS.format.OpenSSL });
           */
          decrypt: function(cipher2, ciphertext, key2, cfg) {
            cfg = this.cfg.extend(cfg);
            ciphertext = this._parse(ciphertext, cfg.format);
            var plaintext = cipher2.createDecryptor(key2, cfg).finalize(ciphertext.ciphertext);
            return plaintext;
          },
          /**
           * Converts serialized ciphertext to CipherParams,
           * else assumed CipherParams already and returns ciphertext unchanged.
           *
           * @param {CipherParams|string} ciphertext The ciphertext.
           * @param {Formatter} format The formatting strategy to use to parse serialized ciphertext.
           *
           * @return {CipherParams} The unserialized ciphertext.
           *
           * @static
           *
           * @example
           *
           *     var ciphertextParams = CryptoJS.lib.SerializableCipher._parse(ciphertextStringOrParams, format);
           */
          _parse: function(ciphertext, format2) {
            if (typeof ciphertext == "string") {
              return format2.parse(ciphertext, this);
            } else {
              return ciphertext;
            }
          }
        });
        var C_kdf = C2.kdf = {};
        var OpenSSLKdf = C_kdf.OpenSSL = {
          /**
           * Derives a key and IV from a password.
           *
           * @param {string} password The password to derive from.
           * @param {number} keySize The size in words of the key to generate.
           * @param {number} ivSize The size in words of the IV to generate.
           * @param {WordArray|string} salt (Optional) A 64-bit salt to use. If omitted, a salt will be generated randomly.
           *
           * @return {CipherParams} A cipher params object with the key, IV, and salt.
           *
           * @static
           *
           * @example
           *
           *     var derivedParams = CryptoJS.kdf.OpenSSL.execute('Password', 256/32, 128/32);
           *     var derivedParams = CryptoJS.kdf.OpenSSL.execute('Password', 256/32, 128/32, 'saltsalt');
           */
          execute: function(password, keySize, ivSize, salt, hasher) {
            if (!salt) {
              salt = WordArray.random(64 / 8);
            }
            if (!hasher) {
              var key2 = EvpKDF.create({ keySize: keySize + ivSize }).compute(password, salt);
            } else {
              var key2 = EvpKDF.create({ keySize: keySize + ivSize, hasher }).compute(password, salt);
            }
            var iv = WordArray.create(key2.words.slice(keySize), ivSize * 4);
            key2.sigBytes = keySize * 4;
            return CipherParams.create({ key: key2, iv, salt });
          }
        };
        var PasswordBasedCipher = C_lib.PasswordBasedCipher = SerializableCipher.extend({
          /**
           * Configuration options.
           *
           * @property {KDF} kdf The key derivation function to use to generate a key and IV from a password. Default: OpenSSL
           */
          cfg: SerializableCipher.cfg.extend({
            kdf: OpenSSLKdf
          }),
          /**
           * Encrypts a message using a password.
           *
           * @param {Cipher} cipher The cipher algorithm to use.
           * @param {WordArray|string} message The message to encrypt.
           * @param {string} password The password.
           * @param {Object} cfg (Optional) The configuration options to use for this operation.
           *
           * @return {CipherParams} A cipher params object.
           *
           * @static
           *
           * @example
           *
           *     var ciphertextParams = CryptoJS.lib.PasswordBasedCipher.encrypt(CryptoJS.algo.AES, message, 'password');
           *     var ciphertextParams = CryptoJS.lib.PasswordBasedCipher.encrypt(CryptoJS.algo.AES, message, 'password', { format: CryptoJS.format.OpenSSL });
           */
          encrypt: function(cipher2, message, password, cfg) {
            cfg = this.cfg.extend(cfg);
            var derivedParams = cfg.kdf.execute(password, cipher2.keySize, cipher2.ivSize, cfg.salt, cfg.hasher);
            cfg.iv = derivedParams.iv;
            var ciphertext = SerializableCipher.encrypt.call(this, cipher2, message, derivedParams.key, cfg);
            ciphertext.mixIn(derivedParams);
            return ciphertext;
          },
          /**
           * Decrypts serialized ciphertext using a password.
           *
           * @param {Cipher} cipher The cipher algorithm to use.
           * @param {CipherParams|string} ciphertext The ciphertext to decrypt.
           * @param {string} password The password.
           * @param {Object} cfg (Optional) The configuration options to use for this operation.
           *
           * @return {WordArray} The plaintext.
           *
           * @static
           *
           * @example
           *
           *     var plaintext = CryptoJS.lib.PasswordBasedCipher.decrypt(CryptoJS.algo.AES, formattedCiphertext, 'password', { format: CryptoJS.format.OpenSSL });
           *     var plaintext = CryptoJS.lib.PasswordBasedCipher.decrypt(CryptoJS.algo.AES, ciphertextParams, 'password', { format: CryptoJS.format.OpenSSL });
           */
          decrypt: function(cipher2, ciphertext, password, cfg) {
            cfg = this.cfg.extend(cfg);
            ciphertext = this._parse(ciphertext, cfg.format);
            var derivedParams = cfg.kdf.execute(password, cipher2.keySize, cipher2.ivSize, ciphertext.salt, cfg.hasher);
            cfg.iv = derivedParams.iv;
            var plaintext = SerializableCipher.decrypt.call(this, cipher2, ciphertext, derivedParams.key, cfg);
            return plaintext;
          }
        });
      }();
    });
  })(cipherCore$1);
  return cipherCore$1.exports;
}
var modeCfb$1 = { exports: {} };
var modeCfb = modeCfb$1.exports;
var hasRequiredModeCfb;
function requireModeCfb() {
  if (hasRequiredModeCfb) return modeCfb$1.exports;
  hasRequiredModeCfb = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireCipherCore());
      }
    })(modeCfb, function(CryptoJS2) {
      CryptoJS2.mode.CFB = function() {
        var CFB = CryptoJS2.lib.BlockCipherMode.extend();
        CFB.Encryptor = CFB.extend({
          processBlock: function(words, offset) {
            var cipher2 = this._cipher;
            var blockSize = cipher2.blockSize;
            generateKeystreamAndEncrypt.call(this, words, offset, blockSize, cipher2);
            this._prevBlock = words.slice(offset, offset + blockSize);
          }
        });
        CFB.Decryptor = CFB.extend({
          processBlock: function(words, offset) {
            var cipher2 = this._cipher;
            var blockSize = cipher2.blockSize;
            var thisBlock = words.slice(offset, offset + blockSize);
            generateKeystreamAndEncrypt.call(this, words, offset, blockSize, cipher2);
            this._prevBlock = thisBlock;
          }
        });
        function generateKeystreamAndEncrypt(words, offset, blockSize, cipher2) {
          var keystream;
          var iv = this._iv;
          if (iv) {
            keystream = iv.slice(0);
            this._iv = void 0;
          } else {
            keystream = this._prevBlock;
          }
          cipher2.encryptBlock(keystream, 0);
          for (var i2 = 0; i2 < blockSize; i2++) {
            words[offset + i2] ^= keystream[i2];
          }
        }
        return CFB;
      }();
      return CryptoJS2.mode.CFB;
    });
  })(modeCfb$1);
  return modeCfb$1.exports;
}
var modeCtr$1 = { exports: {} };
var modeCtr = modeCtr$1.exports;
var hasRequiredModeCtr;
function requireModeCtr() {
  if (hasRequiredModeCtr) return modeCtr$1.exports;
  hasRequiredModeCtr = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireCipherCore());
      }
    })(modeCtr, function(CryptoJS2) {
      CryptoJS2.mode.CTR = function() {
        var CTR = CryptoJS2.lib.BlockCipherMode.extend();
        var Encryptor = CTR.Encryptor = CTR.extend({
          processBlock: function(words, offset) {
            var cipher2 = this._cipher;
            var blockSize = cipher2.blockSize;
            var iv = this._iv;
            var counter = this._counter;
            if (iv) {
              counter = this._counter = iv.slice(0);
              this._iv = void 0;
            }
            var keystream = counter.slice(0);
            cipher2.encryptBlock(keystream, 0);
            counter[blockSize - 1] = counter[blockSize - 1] + 1 | 0;
            for (var i2 = 0; i2 < blockSize; i2++) {
              words[offset + i2] ^= keystream[i2];
            }
          }
        });
        CTR.Decryptor = Encryptor;
        return CTR;
      }();
      return CryptoJS2.mode.CTR;
    });
  })(modeCtr$1);
  return modeCtr$1.exports;
}
var modeCtrGladman$1 = { exports: {} };
var modeCtrGladman = modeCtrGladman$1.exports;
var hasRequiredModeCtrGladman;
function requireModeCtrGladman() {
  if (hasRequiredModeCtrGladman) return modeCtrGladman$1.exports;
  hasRequiredModeCtrGladman = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireCipherCore());
      }
    })(modeCtrGladman, function(CryptoJS2) {
      /** @preserve
       * Counter block mode compatible with  Dr Brian Gladman fileenc.c
       * derived from CryptoJS.mode.CTR
       * Jan Hruby jhruby.web@gmail.com
       */
      CryptoJS2.mode.CTRGladman = function() {
        var CTRGladman = CryptoJS2.lib.BlockCipherMode.extend();
        function incWord(word) {
          if ((word >> 24 & 255) === 255) {
            var b1 = word >> 16 & 255;
            var b2 = word >> 8 & 255;
            var b3 = word & 255;
            if (b1 === 255) {
              b1 = 0;
              if (b2 === 255) {
                b2 = 0;
                if (b3 === 255) {
                  b3 = 0;
                } else {
                  ++b3;
                }
              } else {
                ++b2;
              }
            } else {
              ++b1;
            }
            word = 0;
            word += b1 << 16;
            word += b2 << 8;
            word += b3;
          } else {
            word += 1 << 24;
          }
          return word;
        }
        function incCounter(counter) {
          if ((counter[0] = incWord(counter[0])) === 0) {
            counter[1] = incWord(counter[1]);
          }
          return counter;
        }
        var Encryptor = CTRGladman.Encryptor = CTRGladman.extend({
          processBlock: function(words, offset) {
            var cipher2 = this._cipher;
            var blockSize = cipher2.blockSize;
            var iv = this._iv;
            var counter = this._counter;
            if (iv) {
              counter = this._counter = iv.slice(0);
              this._iv = void 0;
            }
            incCounter(counter);
            var keystream = counter.slice(0);
            cipher2.encryptBlock(keystream, 0);
            for (var i2 = 0; i2 < blockSize; i2++) {
              words[offset + i2] ^= keystream[i2];
            }
          }
        });
        CTRGladman.Decryptor = Encryptor;
        return CTRGladman;
      }();
      return CryptoJS2.mode.CTRGladman;
    });
  })(modeCtrGladman$1);
  return modeCtrGladman$1.exports;
}
var modeOfb$1 = { exports: {} };
var modeOfb = modeOfb$1.exports;
var hasRequiredModeOfb;
function requireModeOfb() {
  if (hasRequiredModeOfb) return modeOfb$1.exports;
  hasRequiredModeOfb = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireCipherCore());
      }
    })(modeOfb, function(CryptoJS2) {
      CryptoJS2.mode.OFB = function() {
        var OFB = CryptoJS2.lib.BlockCipherMode.extend();
        var Encryptor = OFB.Encryptor = OFB.extend({
          processBlock: function(words, offset) {
            var cipher2 = this._cipher;
            var blockSize = cipher2.blockSize;
            var iv = this._iv;
            var keystream = this._keystream;
            if (iv) {
              keystream = this._keystream = iv.slice(0);
              this._iv = void 0;
            }
            cipher2.encryptBlock(keystream, 0);
            for (var i2 = 0; i2 < blockSize; i2++) {
              words[offset + i2] ^= keystream[i2];
            }
          }
        });
        OFB.Decryptor = Encryptor;
        return OFB;
      }();
      return CryptoJS2.mode.OFB;
    });
  })(modeOfb$1);
  return modeOfb$1.exports;
}
var modeEcb$1 = { exports: {} };
var modeEcb = modeEcb$1.exports;
var hasRequiredModeEcb;
function requireModeEcb() {
  if (hasRequiredModeEcb) return modeEcb$1.exports;
  hasRequiredModeEcb = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireCipherCore());
      }
    })(modeEcb, function(CryptoJS2) {
      CryptoJS2.mode.ECB = function() {
        var ECB = CryptoJS2.lib.BlockCipherMode.extend();
        ECB.Encryptor = ECB.extend({
          processBlock: function(words, offset) {
            this._cipher.encryptBlock(words, offset);
          }
        });
        ECB.Decryptor = ECB.extend({
          processBlock: function(words, offset) {
            this._cipher.decryptBlock(words, offset);
          }
        });
        return ECB;
      }();
      return CryptoJS2.mode.ECB;
    });
  })(modeEcb$1);
  return modeEcb$1.exports;
}
var padAnsix923$1 = { exports: {} };
var padAnsix923 = padAnsix923$1.exports;
var hasRequiredPadAnsix923;
function requirePadAnsix923() {
  if (hasRequiredPadAnsix923) return padAnsix923$1.exports;
  hasRequiredPadAnsix923 = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireCipherCore());
      }
    })(padAnsix923, function(CryptoJS2) {
      CryptoJS2.pad.AnsiX923 = {
        pad: function(data2, blockSize) {
          var dataSigBytes = data2.sigBytes;
          var blockSizeBytes = blockSize * 4;
          var nPaddingBytes = blockSizeBytes - dataSigBytes % blockSizeBytes;
          var lastBytePos = dataSigBytes + nPaddingBytes - 1;
          data2.clamp();
          data2.words[lastBytePos >>> 2] |= nPaddingBytes << 24 - lastBytePos % 4 * 8;
          data2.sigBytes += nPaddingBytes;
        },
        unpad: function(data2) {
          var nPaddingBytes = data2.words[data2.sigBytes - 1 >>> 2] & 255;
          data2.sigBytes -= nPaddingBytes;
        }
      };
      return CryptoJS2.pad.Ansix923;
    });
  })(padAnsix923$1);
  return padAnsix923$1.exports;
}
var padIso10126$1 = { exports: {} };
var padIso10126 = padIso10126$1.exports;
var hasRequiredPadIso10126;
function requirePadIso10126() {
  if (hasRequiredPadIso10126) return padIso10126$1.exports;
  hasRequiredPadIso10126 = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireCipherCore());
      }
    })(padIso10126, function(CryptoJS2) {
      CryptoJS2.pad.Iso10126 = {
        pad: function(data2, blockSize) {
          var blockSizeBytes = blockSize * 4;
          var nPaddingBytes = blockSizeBytes - data2.sigBytes % blockSizeBytes;
          data2.concat(CryptoJS2.lib.WordArray.random(nPaddingBytes - 1)).concat(CryptoJS2.lib.WordArray.create([nPaddingBytes << 24], 1));
        },
        unpad: function(data2) {
          var nPaddingBytes = data2.words[data2.sigBytes - 1 >>> 2] & 255;
          data2.sigBytes -= nPaddingBytes;
        }
      };
      return CryptoJS2.pad.Iso10126;
    });
  })(padIso10126$1);
  return padIso10126$1.exports;
}
var padIso97971$1 = { exports: {} };
var padIso97971 = padIso97971$1.exports;
var hasRequiredPadIso97971;
function requirePadIso97971() {
  if (hasRequiredPadIso97971) return padIso97971$1.exports;
  hasRequiredPadIso97971 = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireCipherCore());
      }
    })(padIso97971, function(CryptoJS2) {
      CryptoJS2.pad.Iso97971 = {
        pad: function(data2, blockSize) {
          data2.concat(CryptoJS2.lib.WordArray.create([2147483648], 1));
          CryptoJS2.pad.ZeroPadding.pad(data2, blockSize);
        },
        unpad: function(data2) {
          CryptoJS2.pad.ZeroPadding.unpad(data2);
          data2.sigBytes--;
        }
      };
      return CryptoJS2.pad.Iso97971;
    });
  })(padIso97971$1);
  return padIso97971$1.exports;
}
var padZeropadding$1 = { exports: {} };
var padZeropadding = padZeropadding$1.exports;
var hasRequiredPadZeropadding;
function requirePadZeropadding() {
  if (hasRequiredPadZeropadding) return padZeropadding$1.exports;
  hasRequiredPadZeropadding = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireCipherCore());
      }
    })(padZeropadding, function(CryptoJS2) {
      CryptoJS2.pad.ZeroPadding = {
        pad: function(data2, blockSize) {
          var blockSizeBytes = blockSize * 4;
          data2.clamp();
          data2.sigBytes += blockSizeBytes - (data2.sigBytes % blockSizeBytes || blockSizeBytes);
        },
        unpad: function(data2) {
          var dataWords = data2.words;
          var i2 = data2.sigBytes - 1;
          for (var i2 = data2.sigBytes - 1; i2 >= 0; i2--) {
            if (dataWords[i2 >>> 2] >>> 24 - i2 % 4 * 8 & 255) {
              data2.sigBytes = i2 + 1;
              break;
            }
          }
        }
      };
      return CryptoJS2.pad.ZeroPadding;
    });
  })(padZeropadding$1);
  return padZeropadding$1.exports;
}
var padNopadding$1 = { exports: {} };
var padNopadding = padNopadding$1.exports;
var hasRequiredPadNopadding;
function requirePadNopadding() {
  if (hasRequiredPadNopadding) return padNopadding$1.exports;
  hasRequiredPadNopadding = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireCipherCore());
      }
    })(padNopadding, function(CryptoJS2) {
      CryptoJS2.pad.NoPadding = {
        pad: function() {
        },
        unpad: function() {
        }
      };
      return CryptoJS2.pad.NoPadding;
    });
  })(padNopadding$1);
  return padNopadding$1.exports;
}
var formatHex$1 = { exports: {} };
var formatHex = formatHex$1.exports;
var hasRequiredFormatHex;
function requireFormatHex() {
  if (hasRequiredFormatHex) return formatHex$1.exports;
  hasRequiredFormatHex = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireCipherCore());
      }
    })(formatHex, function(CryptoJS2) {
      (function(undefined$1) {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var CipherParams = C_lib.CipherParams;
        var C_enc = C2.enc;
        var Hex2 = C_enc.Hex;
        var C_format = C2.format;
        C_format.Hex = {
          /**
           * Converts the ciphertext of a cipher params object to a hexadecimally encoded string.
           *
           * @param {CipherParams} cipherParams The cipher params object.
           *
           * @return {string} The hexadecimally encoded string.
           *
           * @static
           *
           * @example
           *
           *     var hexString = CryptoJS.format.Hex.stringify(cipherParams);
           */
          stringify: function(cipherParams) {
            return cipherParams.ciphertext.toString(Hex2);
          },
          /**
           * Converts a hexadecimally encoded ciphertext string to a cipher params object.
           *
           * @param {string} input The hexadecimally encoded string.
           *
           * @return {CipherParams} The cipher params object.
           *
           * @static
           *
           * @example
           *
           *     var cipherParams = CryptoJS.format.Hex.parse(hexString);
           */
          parse: function(input) {
            var ciphertext = Hex2.parse(input);
            return CipherParams.create({ ciphertext });
          }
        };
      })();
      return CryptoJS2.format.Hex;
    });
  })(formatHex$1);
  return formatHex$1.exports;
}
var aes$1 = { exports: {} };
var aes = aes$1.exports;
var hasRequiredAes;
function requireAes() {
  if (hasRequiredAes) return aes$1.exports;
  hasRequiredAes = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireEncBase64(), requireMd5(), requireEvpkdf(), requireCipherCore());
      }
    })(aes, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var BlockCipher = C_lib.BlockCipher;
        var C_algo = C2.algo;
        var SBOX = [];
        var INV_SBOX = [];
        var SUB_MIX_0 = [];
        var SUB_MIX_1 = [];
        var SUB_MIX_2 = [];
        var SUB_MIX_3 = [];
        var INV_SUB_MIX_0 = [];
        var INV_SUB_MIX_1 = [];
        var INV_SUB_MIX_2 = [];
        var INV_SUB_MIX_3 = [];
        (function() {
          var d = [];
          for (var i2 = 0; i2 < 256; i2++) {
            if (i2 < 128) {
              d[i2] = i2 << 1;
            } else {
              d[i2] = i2 << 1 ^ 283;
            }
          }
          var x2 = 0;
          var xi = 0;
          for (var i2 = 0; i2 < 256; i2++) {
            var sx = xi ^ xi << 1 ^ xi << 2 ^ xi << 3 ^ xi << 4;
            sx = sx >>> 8 ^ sx & 255 ^ 99;
            SBOX[x2] = sx;
            INV_SBOX[sx] = x2;
            var x22 = d[x2];
            var x4 = d[x22];
            var x8 = d[x4];
            var t2 = d[sx] * 257 ^ sx * 16843008;
            SUB_MIX_0[x2] = t2 << 24 | t2 >>> 8;
            SUB_MIX_1[x2] = t2 << 16 | t2 >>> 16;
            SUB_MIX_2[x2] = t2 << 8 | t2 >>> 24;
            SUB_MIX_3[x2] = t2;
            var t2 = x8 * 16843009 ^ x4 * 65537 ^ x22 * 257 ^ x2 * 16843008;
            INV_SUB_MIX_0[sx] = t2 << 24 | t2 >>> 8;
            INV_SUB_MIX_1[sx] = t2 << 16 | t2 >>> 16;
            INV_SUB_MIX_2[sx] = t2 << 8 | t2 >>> 24;
            INV_SUB_MIX_3[sx] = t2;
            if (!x2) {
              x2 = xi = 1;
            } else {
              x2 = x22 ^ d[d[d[x8 ^ x22]]];
              xi ^= d[d[xi]];
            }
          }
        })();
        var RCON = [0, 1, 2, 4, 8, 16, 32, 64, 128, 27, 54];
        var AES = C_algo.AES = BlockCipher.extend({
          _doReset: function() {
            var t2;
            if (this._nRounds && this._keyPriorReset === this._key) {
              return;
            }
            var key2 = this._keyPriorReset = this._key;
            var keyWords = key2.words;
            var keySize = key2.sigBytes / 4;
            var nRounds = this._nRounds = keySize + 6;
            var ksRows = (nRounds + 1) * 4;
            var keySchedule = this._keySchedule = [];
            for (var ksRow = 0; ksRow < ksRows; ksRow++) {
              if (ksRow < keySize) {
                keySchedule[ksRow] = keyWords[ksRow];
              } else {
                t2 = keySchedule[ksRow - 1];
                if (!(ksRow % keySize)) {
                  t2 = t2 << 8 | t2 >>> 24;
                  t2 = SBOX[t2 >>> 24] << 24 | SBOX[t2 >>> 16 & 255] << 16 | SBOX[t2 >>> 8 & 255] << 8 | SBOX[t2 & 255];
                  t2 ^= RCON[ksRow / keySize | 0] << 24;
                } else if (keySize > 6 && ksRow % keySize == 4) {
                  t2 = SBOX[t2 >>> 24] << 24 | SBOX[t2 >>> 16 & 255] << 16 | SBOX[t2 >>> 8 & 255] << 8 | SBOX[t2 & 255];
                }
                keySchedule[ksRow] = keySchedule[ksRow - keySize] ^ t2;
              }
            }
            var invKeySchedule = this._invKeySchedule = [];
            for (var invKsRow = 0; invKsRow < ksRows; invKsRow++) {
              var ksRow = ksRows - invKsRow;
              if (invKsRow % 4) {
                var t2 = keySchedule[ksRow];
              } else {
                var t2 = keySchedule[ksRow - 4];
              }
              if (invKsRow < 4 || ksRow <= 4) {
                invKeySchedule[invKsRow] = t2;
              } else {
                invKeySchedule[invKsRow] = INV_SUB_MIX_0[SBOX[t2 >>> 24]] ^ INV_SUB_MIX_1[SBOX[t2 >>> 16 & 255]] ^ INV_SUB_MIX_2[SBOX[t2 >>> 8 & 255]] ^ INV_SUB_MIX_3[SBOX[t2 & 255]];
              }
            }
          },
          encryptBlock: function(M2, offset) {
            this._doCryptBlock(M2, offset, this._keySchedule, SUB_MIX_0, SUB_MIX_1, SUB_MIX_2, SUB_MIX_3, SBOX);
          },
          decryptBlock: function(M2, offset) {
            var t2 = M2[offset + 1];
            M2[offset + 1] = M2[offset + 3];
            M2[offset + 3] = t2;
            this._doCryptBlock(M2, offset, this._invKeySchedule, INV_SUB_MIX_0, INV_SUB_MIX_1, INV_SUB_MIX_2, INV_SUB_MIX_3, INV_SBOX);
            var t2 = M2[offset + 1];
            M2[offset + 1] = M2[offset + 3];
            M2[offset + 3] = t2;
          },
          _doCryptBlock: function(M2, offset, keySchedule, SUB_MIX_02, SUB_MIX_12, SUB_MIX_22, SUB_MIX_32, SBOX2) {
            var nRounds = this._nRounds;
            var s0 = M2[offset] ^ keySchedule[0];
            var s1 = M2[offset + 1] ^ keySchedule[1];
            var s2 = M2[offset + 2] ^ keySchedule[2];
            var s3 = M2[offset + 3] ^ keySchedule[3];
            var ksRow = 4;
            for (var round2 = 1; round2 < nRounds; round2++) {
              var t0 = SUB_MIX_02[s0 >>> 24] ^ SUB_MIX_12[s1 >>> 16 & 255] ^ SUB_MIX_22[s2 >>> 8 & 255] ^ SUB_MIX_32[s3 & 255] ^ keySchedule[ksRow++];
              var t1 = SUB_MIX_02[s1 >>> 24] ^ SUB_MIX_12[s2 >>> 16 & 255] ^ SUB_MIX_22[s3 >>> 8 & 255] ^ SUB_MIX_32[s0 & 255] ^ keySchedule[ksRow++];
              var t2 = SUB_MIX_02[s2 >>> 24] ^ SUB_MIX_12[s3 >>> 16 & 255] ^ SUB_MIX_22[s0 >>> 8 & 255] ^ SUB_MIX_32[s1 & 255] ^ keySchedule[ksRow++];
              var t3 = SUB_MIX_02[s3 >>> 24] ^ SUB_MIX_12[s0 >>> 16 & 255] ^ SUB_MIX_22[s1 >>> 8 & 255] ^ SUB_MIX_32[s2 & 255] ^ keySchedule[ksRow++];
              s0 = t0;
              s1 = t1;
              s2 = t2;
              s3 = t3;
            }
            var t0 = (SBOX2[s0 >>> 24] << 24 | SBOX2[s1 >>> 16 & 255] << 16 | SBOX2[s2 >>> 8 & 255] << 8 | SBOX2[s3 & 255]) ^ keySchedule[ksRow++];
            var t1 = (SBOX2[s1 >>> 24] << 24 | SBOX2[s2 >>> 16 & 255] << 16 | SBOX2[s3 >>> 8 & 255] << 8 | SBOX2[s0 & 255]) ^ keySchedule[ksRow++];
            var t2 = (SBOX2[s2 >>> 24] << 24 | SBOX2[s3 >>> 16 & 255] << 16 | SBOX2[s0 >>> 8 & 255] << 8 | SBOX2[s1 & 255]) ^ keySchedule[ksRow++];
            var t3 = (SBOX2[s3 >>> 24] << 24 | SBOX2[s0 >>> 16 & 255] << 16 | SBOX2[s1 >>> 8 & 255] << 8 | SBOX2[s2 & 255]) ^ keySchedule[ksRow++];
            M2[offset] = t0;
            M2[offset + 1] = t1;
            M2[offset + 2] = t2;
            M2[offset + 3] = t3;
          },
          keySize: 256 / 32
        });
        C2.AES = BlockCipher._createHelper(AES);
      })();
      return CryptoJS2.AES;
    });
  })(aes$1);
  return aes$1.exports;
}
var tripledes$1 = { exports: {} };
var tripledes = tripledes$1.exports;
var hasRequiredTripledes;
function requireTripledes() {
  if (hasRequiredTripledes) return tripledes$1.exports;
  hasRequiredTripledes = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireEncBase64(), requireMd5(), requireEvpkdf(), requireCipherCore());
      }
    })(tripledes, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var WordArray = C_lib.WordArray;
        var BlockCipher = C_lib.BlockCipher;
        var C_algo = C2.algo;
        var PC1 = [
          57,
          49,
          41,
          33,
          25,
          17,
          9,
          1,
          58,
          50,
          42,
          34,
          26,
          18,
          10,
          2,
          59,
          51,
          43,
          35,
          27,
          19,
          11,
          3,
          60,
          52,
          44,
          36,
          63,
          55,
          47,
          39,
          31,
          23,
          15,
          7,
          62,
          54,
          46,
          38,
          30,
          22,
          14,
          6,
          61,
          53,
          45,
          37,
          29,
          21,
          13,
          5,
          28,
          20,
          12,
          4
        ];
        var PC2 = [
          14,
          17,
          11,
          24,
          1,
          5,
          3,
          28,
          15,
          6,
          21,
          10,
          23,
          19,
          12,
          4,
          26,
          8,
          16,
          7,
          27,
          20,
          13,
          2,
          41,
          52,
          31,
          37,
          47,
          55,
          30,
          40,
          51,
          45,
          33,
          48,
          44,
          49,
          39,
          56,
          34,
          53,
          46,
          42,
          50,
          36,
          29,
          32
        ];
        var BIT_SHIFTS = [1, 2, 4, 6, 8, 10, 12, 14, 15, 17, 19, 21, 23, 25, 27, 28];
        var SBOX_P = [
          {
            0: 8421888,
            268435456: 32768,
            536870912: 8421378,
            805306368: 2,
            1073741824: 512,
            1342177280: 8421890,
            1610612736: 8389122,
            1879048192: 8388608,
            2147483648: 514,
            2415919104: 8389120,
            2684354560: 33280,
            2952790016: 8421376,
            3221225472: 32770,
            3489660928: 8388610,
            3758096384: 0,
            4026531840: 33282,
            134217728: 0,
            402653184: 8421890,
            671088640: 33282,
            939524096: 32768,
            1207959552: 8421888,
            1476395008: 512,
            1744830464: 8421378,
            2013265920: 2,
            2281701376: 8389120,
            2550136832: 33280,
            2818572288: 8421376,
            3087007744: 8389122,
            3355443200: 8388610,
            3623878656: 32770,
            3892314112: 514,
            4160749568: 8388608,
            1: 32768,
            268435457: 2,
            536870913: 8421888,
            805306369: 8388608,
            1073741825: 8421378,
            1342177281: 33280,
            1610612737: 512,
            1879048193: 8389122,
            2147483649: 8421890,
            2415919105: 8421376,
            2684354561: 8388610,
            2952790017: 33282,
            3221225473: 514,
            3489660929: 8389120,
            3758096385: 32770,
            4026531841: 0,
            134217729: 8421890,
            402653185: 8421376,
            671088641: 8388608,
            939524097: 512,
            1207959553: 32768,
            1476395009: 8388610,
            1744830465: 2,
            2013265921: 33282,
            2281701377: 32770,
            2550136833: 8389122,
            2818572289: 514,
            3087007745: 8421888,
            3355443201: 8389120,
            3623878657: 0,
            3892314113: 33280,
            4160749569: 8421378
          },
          {
            0: 1074282512,
            16777216: 16384,
            33554432: 524288,
            50331648: 1074266128,
            67108864: 1073741840,
            83886080: 1074282496,
            100663296: 1073758208,
            117440512: 16,
            134217728: 540672,
            150994944: 1073758224,
            167772160: 1073741824,
            184549376: 540688,
            201326592: 524304,
            218103808: 0,
            234881024: 16400,
            251658240: 1074266112,
            8388608: 1073758208,
            25165824: 540688,
            41943040: 16,
            58720256: 1073758224,
            75497472: 1074282512,
            92274688: 1073741824,
            109051904: 524288,
            125829120: 1074266128,
            142606336: 524304,
            159383552: 0,
            176160768: 16384,
            192937984: 1074266112,
            209715200: 1073741840,
            226492416: 540672,
            243269632: 1074282496,
            260046848: 16400,
            268435456: 0,
            285212672: 1074266128,
            301989888: 1073758224,
            318767104: 1074282496,
            335544320: 1074266112,
            352321536: 16,
            369098752: 540688,
            385875968: 16384,
            402653184: 16400,
            419430400: 524288,
            436207616: 524304,
            452984832: 1073741840,
            469762048: 540672,
            486539264: 1073758208,
            503316480: 1073741824,
            520093696: 1074282512,
            276824064: 540688,
            293601280: 524288,
            310378496: 1074266112,
            327155712: 16384,
            343932928: 1073758208,
            360710144: 1074282512,
            377487360: 16,
            394264576: 1073741824,
            411041792: 1074282496,
            427819008: 1073741840,
            444596224: 1073758224,
            461373440: 524304,
            478150656: 0,
            494927872: 16400,
            511705088: 1074266128,
            528482304: 540672
          },
          {
            0: 260,
            1048576: 0,
            2097152: 67109120,
            3145728: 65796,
            4194304: 65540,
            5242880: 67108868,
            6291456: 67174660,
            7340032: 67174400,
            8388608: 67108864,
            9437184: 67174656,
            10485760: 65792,
            11534336: 67174404,
            12582912: 67109124,
            13631488: 65536,
            14680064: 4,
            15728640: 256,
            524288: 67174656,
            1572864: 67174404,
            2621440: 0,
            3670016: 67109120,
            4718592: 67108868,
            5767168: 65536,
            6815744: 65540,
            7864320: 260,
            8912896: 4,
            9961472: 256,
            11010048: 67174400,
            12058624: 65796,
            13107200: 65792,
            14155776: 67109124,
            15204352: 67174660,
            16252928: 67108864,
            16777216: 67174656,
            17825792: 65540,
            18874368: 65536,
            19922944: 67109120,
            20971520: 256,
            22020096: 67174660,
            23068672: 67108868,
            24117248: 0,
            25165824: 67109124,
            26214400: 67108864,
            27262976: 4,
            28311552: 65792,
            29360128: 67174400,
            30408704: 260,
            31457280: 65796,
            32505856: 67174404,
            17301504: 67108864,
            18350080: 260,
            19398656: 67174656,
            20447232: 0,
            21495808: 65540,
            22544384: 67109120,
            23592960: 256,
            24641536: 67174404,
            25690112: 65536,
            26738688: 67174660,
            27787264: 65796,
            28835840: 67108868,
            29884416: 67109124,
            30932992: 67174400,
            31981568: 4,
            33030144: 65792
          },
          {
            0: 2151682048,
            65536: 2147487808,
            131072: 4198464,
            196608: 2151677952,
            262144: 0,
            327680: 4198400,
            393216: 2147483712,
            458752: 4194368,
            524288: 2147483648,
            589824: 4194304,
            655360: 64,
            720896: 2147487744,
            786432: 2151678016,
            851968: 4160,
            917504: 4096,
            983040: 2151682112,
            32768: 2147487808,
            98304: 64,
            163840: 2151678016,
            229376: 2147487744,
            294912: 4198400,
            360448: 2151682112,
            425984: 0,
            491520: 2151677952,
            557056: 4096,
            622592: 2151682048,
            688128: 4194304,
            753664: 4160,
            819200: 2147483648,
            884736: 4194368,
            950272: 4198464,
            1015808: 2147483712,
            1048576: 4194368,
            1114112: 4198400,
            1179648: 2147483712,
            1245184: 0,
            1310720: 4160,
            1376256: 2151678016,
            1441792: 2151682048,
            1507328: 2147487808,
            1572864: 2151682112,
            1638400: 2147483648,
            1703936: 2151677952,
            1769472: 4198464,
            1835008: 2147487744,
            1900544: 4194304,
            1966080: 64,
            2031616: 4096,
            1081344: 2151677952,
            1146880: 2151682112,
            1212416: 0,
            1277952: 4198400,
            1343488: 4194368,
            1409024: 2147483648,
            1474560: 2147487808,
            1540096: 64,
            1605632: 2147483712,
            1671168: 4096,
            1736704: 2147487744,
            1802240: 2151678016,
            1867776: 4160,
            1933312: 2151682048,
            1998848: 4194304,
            2064384: 4198464
          },
          {
            0: 128,
            4096: 17039360,
            8192: 262144,
            12288: 536870912,
            16384: 537133184,
            20480: 16777344,
            24576: 553648256,
            28672: 262272,
            32768: 16777216,
            36864: 537133056,
            40960: 536871040,
            45056: 553910400,
            49152: 553910272,
            53248: 0,
            57344: 17039488,
            61440: 553648128,
            2048: 17039488,
            6144: 553648256,
            10240: 128,
            14336: 17039360,
            18432: 262144,
            22528: 537133184,
            26624: 553910272,
            30720: 536870912,
            34816: 537133056,
            38912: 0,
            43008: 553910400,
            47104: 16777344,
            51200: 536871040,
            55296: 553648128,
            59392: 16777216,
            63488: 262272,
            65536: 262144,
            69632: 128,
            73728: 536870912,
            77824: 553648256,
            81920: 16777344,
            86016: 553910272,
            90112: 537133184,
            94208: 16777216,
            98304: 553910400,
            102400: 553648128,
            106496: 17039360,
            110592: 537133056,
            114688: 262272,
            118784: 536871040,
            122880: 0,
            126976: 17039488,
            67584: 553648256,
            71680: 16777216,
            75776: 17039360,
            79872: 537133184,
            83968: 536870912,
            88064: 17039488,
            92160: 128,
            96256: 553910272,
            100352: 262272,
            104448: 553910400,
            108544: 0,
            112640: 553648128,
            116736: 16777344,
            120832: 262144,
            124928: 537133056,
            129024: 536871040
          },
          {
            0: 268435464,
            256: 8192,
            512: 270532608,
            768: 270540808,
            1024: 268443648,
            1280: 2097152,
            1536: 2097160,
            1792: 268435456,
            2048: 0,
            2304: 268443656,
            2560: 2105344,
            2816: 8,
            3072: 270532616,
            3328: 2105352,
            3584: 8200,
            3840: 270540800,
            128: 270532608,
            384: 270540808,
            640: 8,
            896: 2097152,
            1152: 2105352,
            1408: 268435464,
            1664: 268443648,
            1920: 8200,
            2176: 2097160,
            2432: 8192,
            2688: 268443656,
            2944: 270532616,
            3200: 0,
            3456: 270540800,
            3712: 2105344,
            3968: 268435456,
            4096: 268443648,
            4352: 270532616,
            4608: 270540808,
            4864: 8200,
            5120: 2097152,
            5376: 268435456,
            5632: 268435464,
            5888: 2105344,
            6144: 2105352,
            6400: 0,
            6656: 8,
            6912: 270532608,
            7168: 8192,
            7424: 268443656,
            7680: 270540800,
            7936: 2097160,
            4224: 8,
            4480: 2105344,
            4736: 2097152,
            4992: 268435464,
            5248: 268443648,
            5504: 8200,
            5760: 270540808,
            6016: 270532608,
            6272: 270540800,
            6528: 270532616,
            6784: 8192,
            7040: 2105352,
            7296: 2097160,
            7552: 0,
            7808: 268435456,
            8064: 268443656
          },
          {
            0: 1048576,
            16: 33555457,
            32: 1024,
            48: 1049601,
            64: 34604033,
            80: 0,
            96: 1,
            112: 34603009,
            128: 33555456,
            144: 1048577,
            160: 33554433,
            176: 34604032,
            192: 34603008,
            208: 1025,
            224: 1049600,
            240: 33554432,
            8: 34603009,
            24: 0,
            40: 33555457,
            56: 34604032,
            72: 1048576,
            88: 33554433,
            104: 33554432,
            120: 1025,
            136: 1049601,
            152: 33555456,
            168: 34603008,
            184: 1048577,
            200: 1024,
            216: 34604033,
            232: 1,
            248: 1049600,
            256: 33554432,
            272: 1048576,
            288: 33555457,
            304: 34603009,
            320: 1048577,
            336: 33555456,
            352: 34604032,
            368: 1049601,
            384: 1025,
            400: 34604033,
            416: 1049600,
            432: 1,
            448: 0,
            464: 34603008,
            480: 33554433,
            496: 1024,
            264: 1049600,
            280: 33555457,
            296: 34603009,
            312: 1,
            328: 33554432,
            344: 1048576,
            360: 1025,
            376: 34604032,
            392: 33554433,
            408: 34603008,
            424: 0,
            440: 34604033,
            456: 1049601,
            472: 1024,
            488: 33555456,
            504: 1048577
          },
          {
            0: 134219808,
            1: 131072,
            2: 134217728,
            3: 32,
            4: 131104,
            5: 134350880,
            6: 134350848,
            7: 2048,
            8: 134348800,
            9: 134219776,
            10: 133120,
            11: 134348832,
            12: 2080,
            13: 0,
            14: 134217760,
            15: 133152,
            2147483648: 2048,
            2147483649: 134350880,
            2147483650: 134219808,
            2147483651: 134217728,
            2147483652: 134348800,
            2147483653: 133120,
            2147483654: 133152,
            2147483655: 32,
            2147483656: 134217760,
            2147483657: 2080,
            2147483658: 131104,
            2147483659: 134350848,
            2147483660: 0,
            2147483661: 134348832,
            2147483662: 134219776,
            2147483663: 131072,
            16: 133152,
            17: 134350848,
            18: 32,
            19: 2048,
            20: 134219776,
            21: 134217760,
            22: 134348832,
            23: 131072,
            24: 0,
            25: 131104,
            26: 134348800,
            27: 134219808,
            28: 134350880,
            29: 133120,
            30: 2080,
            31: 134217728,
            2147483664: 131072,
            2147483665: 2048,
            2147483666: 134348832,
            2147483667: 133152,
            2147483668: 32,
            2147483669: 134348800,
            2147483670: 134217728,
            2147483671: 134219808,
            2147483672: 134350880,
            2147483673: 134217760,
            2147483674: 134219776,
            2147483675: 0,
            2147483676: 133120,
            2147483677: 2080,
            2147483678: 131104,
            2147483679: 134350848
          }
        ];
        var SBOX_MASK = [
          4160749569,
          528482304,
          33030144,
          2064384,
          129024,
          8064,
          504,
          2147483679
        ];
        var DES = C_algo.DES = BlockCipher.extend({
          _doReset: function() {
            var key2 = this._key;
            var keyWords = key2.words;
            var keyBits = [];
            for (var i2 = 0; i2 < 56; i2++) {
              var keyBitPos = PC1[i2] - 1;
              keyBits[i2] = keyWords[keyBitPos >>> 5] >>> 31 - keyBitPos % 32 & 1;
            }
            var subKeys = this._subKeys = [];
            for (var nSubKey = 0; nSubKey < 16; nSubKey++) {
              var subKey = subKeys[nSubKey] = [];
              var bitShift = BIT_SHIFTS[nSubKey];
              for (var i2 = 0; i2 < 24; i2++) {
                subKey[i2 / 6 | 0] |= keyBits[(PC2[i2] - 1 + bitShift) % 28] << 31 - i2 % 6;
                subKey[4 + (i2 / 6 | 0)] |= keyBits[28 + (PC2[i2 + 24] - 1 + bitShift) % 28] << 31 - i2 % 6;
              }
              subKey[0] = subKey[0] << 1 | subKey[0] >>> 31;
              for (var i2 = 1; i2 < 7; i2++) {
                subKey[i2] = subKey[i2] >>> (i2 - 1) * 4 + 3;
              }
              subKey[7] = subKey[7] << 5 | subKey[7] >>> 27;
            }
            var invSubKeys = this._invSubKeys = [];
            for (var i2 = 0; i2 < 16; i2++) {
              invSubKeys[i2] = subKeys[15 - i2];
            }
          },
          encryptBlock: function(M2, offset) {
            this._doCryptBlock(M2, offset, this._subKeys);
          },
          decryptBlock: function(M2, offset) {
            this._doCryptBlock(M2, offset, this._invSubKeys);
          },
          _doCryptBlock: function(M2, offset, subKeys) {
            this._lBlock = M2[offset];
            this._rBlock = M2[offset + 1];
            exchangeLR.call(this, 4, 252645135);
            exchangeLR.call(this, 16, 65535);
            exchangeRL.call(this, 2, 858993459);
            exchangeRL.call(this, 8, 16711935);
            exchangeLR.call(this, 1, 1431655765);
            for (var round2 = 0; round2 < 16; round2++) {
              var subKey = subKeys[round2];
              var lBlock = this._lBlock;
              var rBlock = this._rBlock;
              var f2 = 0;
              for (var i2 = 0; i2 < 8; i2++) {
                f2 |= SBOX_P[i2][((rBlock ^ subKey[i2]) & SBOX_MASK[i2]) >>> 0];
              }
              this._lBlock = rBlock;
              this._rBlock = lBlock ^ f2;
            }
            var t2 = this._lBlock;
            this._lBlock = this._rBlock;
            this._rBlock = t2;
            exchangeLR.call(this, 1, 1431655765);
            exchangeRL.call(this, 8, 16711935);
            exchangeRL.call(this, 2, 858993459);
            exchangeLR.call(this, 16, 65535);
            exchangeLR.call(this, 4, 252645135);
            M2[offset] = this._lBlock;
            M2[offset + 1] = this._rBlock;
          },
          keySize: 64 / 32,
          ivSize: 64 / 32,
          blockSize: 64 / 32
        });
        function exchangeLR(offset, mask) {
          var t2 = (this._lBlock >>> offset ^ this._rBlock) & mask;
          this._rBlock ^= t2;
          this._lBlock ^= t2 << offset;
        }
        function exchangeRL(offset, mask) {
          var t2 = (this._rBlock >>> offset ^ this._lBlock) & mask;
          this._lBlock ^= t2;
          this._rBlock ^= t2 << offset;
        }
        C2.DES = BlockCipher._createHelper(DES);
        var TripleDES = C_algo.TripleDES = BlockCipher.extend({
          _doReset: function() {
            var key2 = this._key;
            var keyWords = key2.words;
            if (keyWords.length !== 2 && keyWords.length !== 4 && keyWords.length < 6) {
              throw new Error("Invalid key length - 3DES requires the key length to be 64, 128, 192 or >192.");
            }
            var key1 = keyWords.slice(0, 2);
            var key22 = keyWords.length < 4 ? keyWords.slice(0, 2) : keyWords.slice(2, 4);
            var key3 = keyWords.length < 6 ? keyWords.slice(0, 2) : keyWords.slice(4, 6);
            this._des1 = DES.createEncryptor(WordArray.create(key1));
            this._des2 = DES.createEncryptor(WordArray.create(key22));
            this._des3 = DES.createEncryptor(WordArray.create(key3));
          },
          encryptBlock: function(M2, offset) {
            this._des1.encryptBlock(M2, offset);
            this._des2.decryptBlock(M2, offset);
            this._des3.encryptBlock(M2, offset);
          },
          decryptBlock: function(M2, offset) {
            this._des3.decryptBlock(M2, offset);
            this._des2.encryptBlock(M2, offset);
            this._des1.decryptBlock(M2, offset);
          },
          keySize: 192 / 32,
          ivSize: 64 / 32,
          blockSize: 64 / 32
        });
        C2.TripleDES = BlockCipher._createHelper(TripleDES);
      })();
      return CryptoJS2.TripleDES;
    });
  })(tripledes$1);
  return tripledes$1.exports;
}
var rc4$1 = { exports: {} };
var rc4 = rc4$1.exports;
var hasRequiredRc4;
function requireRc4() {
  if (hasRequiredRc4) return rc4$1.exports;
  hasRequiredRc4 = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireEncBase64(), requireMd5(), requireEvpkdf(), requireCipherCore());
      }
    })(rc4, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var StreamCipher = C_lib.StreamCipher;
        var C_algo = C2.algo;
        var RC4 = C_algo.RC4 = StreamCipher.extend({
          _doReset: function() {
            var key2 = this._key;
            var keyWords = key2.words;
            var keySigBytes = key2.sigBytes;
            var S2 = this._S = [];
            for (var i2 = 0; i2 < 256; i2++) {
              S2[i2] = i2;
            }
            for (var i2 = 0, j = 0; i2 < 256; i2++) {
              var keyByteIndex = i2 % keySigBytes;
              var keyByte = keyWords[keyByteIndex >>> 2] >>> 24 - keyByteIndex % 4 * 8 & 255;
              j = (j + S2[i2] + keyByte) % 256;
              var t2 = S2[i2];
              S2[i2] = S2[j];
              S2[j] = t2;
            }
            this._i = this._j = 0;
          },
          _doProcessBlock: function(M2, offset) {
            M2[offset] ^= generateKeystreamWord.call(this);
          },
          keySize: 256 / 32,
          ivSize: 0
        });
        function generateKeystreamWord() {
          var S2 = this._S;
          var i2 = this._i;
          var j = this._j;
          var keystreamWord = 0;
          for (var n2 = 0; n2 < 4; n2++) {
            i2 = (i2 + 1) % 256;
            j = (j + S2[i2]) % 256;
            var t2 = S2[i2];
            S2[i2] = S2[j];
            S2[j] = t2;
            keystreamWord |= S2[(S2[i2] + S2[j]) % 256] << 24 - n2 * 8;
          }
          this._i = i2;
          this._j = j;
          return keystreamWord;
        }
        C2.RC4 = StreamCipher._createHelper(RC4);
        var RC4Drop = C_algo.RC4Drop = RC4.extend({
          /**
           * Configuration options.
           *
           * @property {number} drop The number of keystream words to drop. Default 192
           */
          cfg: RC4.cfg.extend({
            drop: 192
          }),
          _doReset: function() {
            RC4._doReset.call(this);
            for (var i2 = this.cfg.drop; i2 > 0; i2--) {
              generateKeystreamWord.call(this);
            }
          }
        });
        C2.RC4Drop = StreamCipher._createHelper(RC4Drop);
      })();
      return CryptoJS2.RC4;
    });
  })(rc4$1);
  return rc4$1.exports;
}
var rabbit$1 = { exports: {} };
var rabbit = rabbit$1.exports;
var hasRequiredRabbit;
function requireRabbit() {
  if (hasRequiredRabbit) return rabbit$1.exports;
  hasRequiredRabbit = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireEncBase64(), requireMd5(), requireEvpkdf(), requireCipherCore());
      }
    })(rabbit, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var StreamCipher = C_lib.StreamCipher;
        var C_algo = C2.algo;
        var S2 = [];
        var C_ = [];
        var G2 = [];
        var Rabbit = C_algo.Rabbit = StreamCipher.extend({
          _doReset: function() {
            var K = this._key.words;
            var iv = this.cfg.iv;
            for (var i2 = 0; i2 < 4; i2++) {
              K[i2] = (K[i2] << 8 | K[i2] >>> 24) & 16711935 | (K[i2] << 24 | K[i2] >>> 8) & 4278255360;
            }
            var X = this._X = [
              K[0],
              K[3] << 16 | K[2] >>> 16,
              K[1],
              K[0] << 16 | K[3] >>> 16,
              K[2],
              K[1] << 16 | K[0] >>> 16,
              K[3],
              K[2] << 16 | K[1] >>> 16
            ];
            var C3 = this._C = [
              K[2] << 16 | K[2] >>> 16,
              K[0] & 4294901760 | K[1] & 65535,
              K[3] << 16 | K[3] >>> 16,
              K[1] & 4294901760 | K[2] & 65535,
              K[0] << 16 | K[0] >>> 16,
              K[2] & 4294901760 | K[3] & 65535,
              K[1] << 16 | K[1] >>> 16,
              K[3] & 4294901760 | K[0] & 65535
            ];
            this._b = 0;
            for (var i2 = 0; i2 < 4; i2++) {
              nextState.call(this);
            }
            for (var i2 = 0; i2 < 8; i2++) {
              C3[i2] ^= X[i2 + 4 & 7];
            }
            if (iv) {
              var IV = iv.words;
              var IV_0 = IV[0];
              var IV_1 = IV[1];
              var i0 = (IV_0 << 8 | IV_0 >>> 24) & 16711935 | (IV_0 << 24 | IV_0 >>> 8) & 4278255360;
              var i22 = (IV_1 << 8 | IV_1 >>> 24) & 16711935 | (IV_1 << 24 | IV_1 >>> 8) & 4278255360;
              var i1 = i0 >>> 16 | i22 & 4294901760;
              var i3 = i22 << 16 | i0 & 65535;
              C3[0] ^= i0;
              C3[1] ^= i1;
              C3[2] ^= i22;
              C3[3] ^= i3;
              C3[4] ^= i0;
              C3[5] ^= i1;
              C3[6] ^= i22;
              C3[7] ^= i3;
              for (var i2 = 0; i2 < 4; i2++) {
                nextState.call(this);
              }
            }
          },
          _doProcessBlock: function(M2, offset) {
            var X = this._X;
            nextState.call(this);
            S2[0] = X[0] ^ X[5] >>> 16 ^ X[3] << 16;
            S2[1] = X[2] ^ X[7] >>> 16 ^ X[5] << 16;
            S2[2] = X[4] ^ X[1] >>> 16 ^ X[7] << 16;
            S2[3] = X[6] ^ X[3] >>> 16 ^ X[1] << 16;
            for (var i2 = 0; i2 < 4; i2++) {
              S2[i2] = (S2[i2] << 8 | S2[i2] >>> 24) & 16711935 | (S2[i2] << 24 | S2[i2] >>> 8) & 4278255360;
              M2[offset + i2] ^= S2[i2];
            }
          },
          blockSize: 128 / 32,
          ivSize: 64 / 32
        });
        function nextState() {
          var X = this._X;
          var C3 = this._C;
          for (var i2 = 0; i2 < 8; i2++) {
            C_[i2] = C3[i2];
          }
          C3[0] = C3[0] + 1295307597 + this._b | 0;
          C3[1] = C3[1] + 3545052371 + (C3[0] >>> 0 < C_[0] >>> 0 ? 1 : 0) | 0;
          C3[2] = C3[2] + 886263092 + (C3[1] >>> 0 < C_[1] >>> 0 ? 1 : 0) | 0;
          C3[3] = C3[3] + 1295307597 + (C3[2] >>> 0 < C_[2] >>> 0 ? 1 : 0) | 0;
          C3[4] = C3[4] + 3545052371 + (C3[3] >>> 0 < C_[3] >>> 0 ? 1 : 0) | 0;
          C3[5] = C3[5] + 886263092 + (C3[4] >>> 0 < C_[4] >>> 0 ? 1 : 0) | 0;
          C3[6] = C3[6] + 1295307597 + (C3[5] >>> 0 < C_[5] >>> 0 ? 1 : 0) | 0;
          C3[7] = C3[7] + 3545052371 + (C3[6] >>> 0 < C_[6] >>> 0 ? 1 : 0) | 0;
          this._b = C3[7] >>> 0 < C_[7] >>> 0 ? 1 : 0;
          for (var i2 = 0; i2 < 8; i2++) {
            var gx = X[i2] + C3[i2];
            var ga = gx & 65535;
            var gb = gx >>> 16;
            var gh = ((ga * ga >>> 17) + ga * gb >>> 15) + gb * gb;
            var gl = ((gx & 4294901760) * gx | 0) + ((gx & 65535) * gx | 0);
            G2[i2] = gh ^ gl;
          }
          X[0] = G2[0] + (G2[7] << 16 | G2[7] >>> 16) + (G2[6] << 16 | G2[6] >>> 16) | 0;
          X[1] = G2[1] + (G2[0] << 8 | G2[0] >>> 24) + G2[7] | 0;
          X[2] = G2[2] + (G2[1] << 16 | G2[1] >>> 16) + (G2[0] << 16 | G2[0] >>> 16) | 0;
          X[3] = G2[3] + (G2[2] << 8 | G2[2] >>> 24) + G2[1] | 0;
          X[4] = G2[4] + (G2[3] << 16 | G2[3] >>> 16) + (G2[2] << 16 | G2[2] >>> 16) | 0;
          X[5] = G2[5] + (G2[4] << 8 | G2[4] >>> 24) + G2[3] | 0;
          X[6] = G2[6] + (G2[5] << 16 | G2[5] >>> 16) + (G2[4] << 16 | G2[4] >>> 16) | 0;
          X[7] = G2[7] + (G2[6] << 8 | G2[6] >>> 24) + G2[5] | 0;
        }
        C2.Rabbit = StreamCipher._createHelper(Rabbit);
      })();
      return CryptoJS2.Rabbit;
    });
  })(rabbit$1);
  return rabbit$1.exports;
}
var rabbitLegacy$1 = { exports: {} };
var rabbitLegacy = rabbitLegacy$1.exports;
var hasRequiredRabbitLegacy;
function requireRabbitLegacy() {
  if (hasRequiredRabbitLegacy) return rabbitLegacy$1.exports;
  hasRequiredRabbitLegacy = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireEncBase64(), requireMd5(), requireEvpkdf(), requireCipherCore());
      }
    })(rabbitLegacy, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var StreamCipher = C_lib.StreamCipher;
        var C_algo = C2.algo;
        var S2 = [];
        var C_ = [];
        var G2 = [];
        var RabbitLegacy = C_algo.RabbitLegacy = StreamCipher.extend({
          _doReset: function() {
            var K = this._key.words;
            var iv = this.cfg.iv;
            var X = this._X = [
              K[0],
              K[3] << 16 | K[2] >>> 16,
              K[1],
              K[0] << 16 | K[3] >>> 16,
              K[2],
              K[1] << 16 | K[0] >>> 16,
              K[3],
              K[2] << 16 | K[1] >>> 16
            ];
            var C3 = this._C = [
              K[2] << 16 | K[2] >>> 16,
              K[0] & 4294901760 | K[1] & 65535,
              K[3] << 16 | K[3] >>> 16,
              K[1] & 4294901760 | K[2] & 65535,
              K[0] << 16 | K[0] >>> 16,
              K[2] & 4294901760 | K[3] & 65535,
              K[1] << 16 | K[1] >>> 16,
              K[3] & 4294901760 | K[0] & 65535
            ];
            this._b = 0;
            for (var i2 = 0; i2 < 4; i2++) {
              nextState.call(this);
            }
            for (var i2 = 0; i2 < 8; i2++) {
              C3[i2] ^= X[i2 + 4 & 7];
            }
            if (iv) {
              var IV = iv.words;
              var IV_0 = IV[0];
              var IV_1 = IV[1];
              var i0 = (IV_0 << 8 | IV_0 >>> 24) & 16711935 | (IV_0 << 24 | IV_0 >>> 8) & 4278255360;
              var i22 = (IV_1 << 8 | IV_1 >>> 24) & 16711935 | (IV_1 << 24 | IV_1 >>> 8) & 4278255360;
              var i1 = i0 >>> 16 | i22 & 4294901760;
              var i3 = i22 << 16 | i0 & 65535;
              C3[0] ^= i0;
              C3[1] ^= i1;
              C3[2] ^= i22;
              C3[3] ^= i3;
              C3[4] ^= i0;
              C3[5] ^= i1;
              C3[6] ^= i22;
              C3[7] ^= i3;
              for (var i2 = 0; i2 < 4; i2++) {
                nextState.call(this);
              }
            }
          },
          _doProcessBlock: function(M2, offset) {
            var X = this._X;
            nextState.call(this);
            S2[0] = X[0] ^ X[5] >>> 16 ^ X[3] << 16;
            S2[1] = X[2] ^ X[7] >>> 16 ^ X[5] << 16;
            S2[2] = X[4] ^ X[1] >>> 16 ^ X[7] << 16;
            S2[3] = X[6] ^ X[3] >>> 16 ^ X[1] << 16;
            for (var i2 = 0; i2 < 4; i2++) {
              S2[i2] = (S2[i2] << 8 | S2[i2] >>> 24) & 16711935 | (S2[i2] << 24 | S2[i2] >>> 8) & 4278255360;
              M2[offset + i2] ^= S2[i2];
            }
          },
          blockSize: 128 / 32,
          ivSize: 64 / 32
        });
        function nextState() {
          var X = this._X;
          var C3 = this._C;
          for (var i2 = 0; i2 < 8; i2++) {
            C_[i2] = C3[i2];
          }
          C3[0] = C3[0] + 1295307597 + this._b | 0;
          C3[1] = C3[1] + 3545052371 + (C3[0] >>> 0 < C_[0] >>> 0 ? 1 : 0) | 0;
          C3[2] = C3[2] + 886263092 + (C3[1] >>> 0 < C_[1] >>> 0 ? 1 : 0) | 0;
          C3[3] = C3[3] + 1295307597 + (C3[2] >>> 0 < C_[2] >>> 0 ? 1 : 0) | 0;
          C3[4] = C3[4] + 3545052371 + (C3[3] >>> 0 < C_[3] >>> 0 ? 1 : 0) | 0;
          C3[5] = C3[5] + 886263092 + (C3[4] >>> 0 < C_[4] >>> 0 ? 1 : 0) | 0;
          C3[6] = C3[6] + 1295307597 + (C3[5] >>> 0 < C_[5] >>> 0 ? 1 : 0) | 0;
          C3[7] = C3[7] + 3545052371 + (C3[6] >>> 0 < C_[6] >>> 0 ? 1 : 0) | 0;
          this._b = C3[7] >>> 0 < C_[7] >>> 0 ? 1 : 0;
          for (var i2 = 0; i2 < 8; i2++) {
            var gx = X[i2] + C3[i2];
            var ga = gx & 65535;
            var gb = gx >>> 16;
            var gh = ((ga * ga >>> 17) + ga * gb >>> 15) + gb * gb;
            var gl = ((gx & 4294901760) * gx | 0) + ((gx & 65535) * gx | 0);
            G2[i2] = gh ^ gl;
          }
          X[0] = G2[0] + (G2[7] << 16 | G2[7] >>> 16) + (G2[6] << 16 | G2[6] >>> 16) | 0;
          X[1] = G2[1] + (G2[0] << 8 | G2[0] >>> 24) + G2[7] | 0;
          X[2] = G2[2] + (G2[1] << 16 | G2[1] >>> 16) + (G2[0] << 16 | G2[0] >>> 16) | 0;
          X[3] = G2[3] + (G2[2] << 8 | G2[2] >>> 24) + G2[1] | 0;
          X[4] = G2[4] + (G2[3] << 16 | G2[3] >>> 16) + (G2[2] << 16 | G2[2] >>> 16) | 0;
          X[5] = G2[5] + (G2[4] << 8 | G2[4] >>> 24) + G2[3] | 0;
          X[6] = G2[6] + (G2[5] << 16 | G2[5] >>> 16) + (G2[4] << 16 | G2[4] >>> 16) | 0;
          X[7] = G2[7] + (G2[6] << 8 | G2[6] >>> 24) + G2[5] | 0;
        }
        C2.RabbitLegacy = StreamCipher._createHelper(RabbitLegacy);
      })();
      return CryptoJS2.RabbitLegacy;
    });
  })(rabbitLegacy$1);
  return rabbitLegacy$1.exports;
}
var blowfish$1 = { exports: {} };
var blowfish = blowfish$1.exports;
var hasRequiredBlowfish;
function requireBlowfish() {
  if (hasRequiredBlowfish) return blowfish$1.exports;
  hasRequiredBlowfish = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireEncBase64(), requireMd5(), requireEvpkdf(), requireCipherCore());
      }
    })(blowfish, function(CryptoJS2) {
      (function() {
        var C2 = CryptoJS2;
        var C_lib = C2.lib;
        var BlockCipher = C_lib.BlockCipher;
        var C_algo = C2.algo;
        const N2 = 16;
        const ORIG_P = [
          608135816,
          2242054355,
          320440878,
          57701188,
          2752067618,
          698298832,
          137296536,
          3964562569,
          1160258022,
          953160567,
          3193202383,
          887688300,
          3232508343,
          3380367581,
          1065670069,
          3041331479,
          2450970073,
          2306472731
        ];
        const ORIG_S = [
          [
            3509652390,
            2564797868,
            805139163,
            3491422135,
            3101798381,
            1780907670,
            3128725573,
            4046225305,
            614570311,
            3012652279,
            134345442,
            2240740374,
            1667834072,
            1901547113,
            2757295779,
            4103290238,
            227898511,
            1921955416,
            1904987480,
            2182433518,
            2069144605,
            3260701109,
            2620446009,
            720527379,
            3318853667,
            677414384,
            3393288472,
            3101374703,
            2390351024,
            1614419982,
            1822297739,
            2954791486,
            3608508353,
            3174124327,
            2024746970,
            1432378464,
            3864339955,
            2857741204,
            1464375394,
            1676153920,
            1439316330,
            715854006,
            3033291828,
            289532110,
            2706671279,
            2087905683,
            3018724369,
            1668267050,
            732546397,
            1947742710,
            3462151702,
            2609353502,
            2950085171,
            1814351708,
            2050118529,
            680887927,
            999245976,
            1800124847,
            3300911131,
            1713906067,
            1641548236,
            4213287313,
            1216130144,
            1575780402,
            4018429277,
            3917837745,
            3693486850,
            3949271944,
            596196993,
            3549867205,
            258830323,
            2213823033,
            772490370,
            2760122372,
            1774776394,
            2652871518,
            566650946,
            4142492826,
            1728879713,
            2882767088,
            1783734482,
            3629395816,
            2517608232,
            2874225571,
            1861159788,
            326777828,
            3124490320,
            2130389656,
            2716951837,
            967770486,
            1724537150,
            2185432712,
            2364442137,
            1164943284,
            2105845187,
            998989502,
            3765401048,
            2244026483,
            1075463327,
            1455516326,
            1322494562,
            910128902,
            469688178,
            1117454909,
            936433444,
            3490320968,
            3675253459,
            1240580251,
            122909385,
            2157517691,
            634681816,
            4142456567,
            3825094682,
            3061402683,
            2540495037,
            79693498,
            3249098678,
            1084186820,
            1583128258,
            426386531,
            1761308591,
            1047286709,
            322548459,
            995290223,
            1845252383,
            2603652396,
            3431023940,
            2942221577,
            3202600964,
            3727903485,
            1712269319,
            422464435,
            3234572375,
            1170764815,
            3523960633,
            3117677531,
            1434042557,
            442511882,
            3600875718,
            1076654713,
            1738483198,
            4213154764,
            2393238008,
            3677496056,
            1014306527,
            4251020053,
            793779912,
            2902807211,
            842905082,
            4246964064,
            1395751752,
            1040244610,
            2656851899,
            3396308128,
            445077038,
            3742853595,
            3577915638,
            679411651,
            2892444358,
            2354009459,
            1767581616,
            3150600392,
            3791627101,
            3102740896,
            284835224,
            4246832056,
            1258075500,
            768725851,
            2589189241,
            3069724005,
            3532540348,
            1274779536,
            3789419226,
            2764799539,
            1660621633,
            3471099624,
            4011903706,
            913787905,
            3497959166,
            737222580,
            2514213453,
            2928710040,
            3937242737,
            1804850592,
            3499020752,
            2949064160,
            2386320175,
            2390070455,
            2415321851,
            4061277028,
            2290661394,
            2416832540,
            1336762016,
            1754252060,
            3520065937,
            3014181293,
            791618072,
            3188594551,
            3933548030,
            2332172193,
            3852520463,
            3043980520,
            413987798,
            3465142937,
            3030929376,
            4245938359,
            2093235073,
            3534596313,
            375366246,
            2157278981,
            2479649556,
            555357303,
            3870105701,
            2008414854,
            3344188149,
            4221384143,
            3956125452,
            2067696032,
            3594591187,
            2921233993,
            2428461,
            544322398,
            577241275,
            1471733935,
            610547355,
            4027169054,
            1432588573,
            1507829418,
            2025931657,
            3646575487,
            545086370,
            48609733,
            2200306550,
            1653985193,
            298326376,
            1316178497,
            3007786442,
            2064951626,
            458293330,
            2589141269,
            3591329599,
            3164325604,
            727753846,
            2179363840,
            146436021,
            1461446943,
            4069977195,
            705550613,
            3059967265,
            3887724982,
            4281599278,
            3313849956,
            1404054877,
            2845806497,
            146425753,
            1854211946
          ],
          [
            1266315497,
            3048417604,
            3681880366,
            3289982499,
            290971e4,
            1235738493,
            2632868024,
            2414719590,
            3970600049,
            1771706367,
            1449415276,
            3266420449,
            422970021,
            1963543593,
            2690192192,
            3826793022,
            1062508698,
            1531092325,
            1804592342,
            2583117782,
            2714934279,
            4024971509,
            1294809318,
            4028980673,
            1289560198,
            2221992742,
            1669523910,
            35572830,
            157838143,
            1052438473,
            1016535060,
            1802137761,
            1753167236,
            1386275462,
            3080475397,
            2857371447,
            1040679964,
            2145300060,
            2390574316,
            1461121720,
            2956646967,
            4031777805,
            4028374788,
            33600511,
            2920084762,
            1018524850,
            629373528,
            3691585981,
            3515945977,
            2091462646,
            2486323059,
            586499841,
            988145025,
            935516892,
            3367335476,
            2599673255,
            2839830854,
            265290510,
            3972581182,
            2759138881,
            3795373465,
            1005194799,
            847297441,
            406762289,
            1314163512,
            1332590856,
            1866599683,
            4127851711,
            750260880,
            613907577,
            1450815602,
            3165620655,
            3734664991,
            3650291728,
            3012275730,
            3704569646,
            1427272223,
            778793252,
            1343938022,
            2676280711,
            2052605720,
            1946737175,
            3164576444,
            3914038668,
            3967478842,
            3682934266,
            1661551462,
            3294938066,
            4011595847,
            840292616,
            3712170807,
            616741398,
            312560963,
            711312465,
            1351876610,
            322626781,
            1910503582,
            271666773,
            2175563734,
            1594956187,
            70604529,
            3617834859,
            1007753275,
            1495573769,
            4069517037,
            2549218298,
            2663038764,
            504708206,
            2263041392,
            3941167025,
            2249088522,
            1514023603,
            1998579484,
            1312622330,
            694541497,
            2582060303,
            2151582166,
            1382467621,
            776784248,
            2618340202,
            3323268794,
            2497899128,
            2784771155,
            503983604,
            4076293799,
            907881277,
            423175695,
            432175456,
            1378068232,
            4145222326,
            3954048622,
            3938656102,
            3820766613,
            2793130115,
            2977904593,
            26017576,
            3274890735,
            3194772133,
            1700274565,
            1756076034,
            4006520079,
            3677328699,
            720338349,
            1533947780,
            354530856,
            688349552,
            3973924725,
            1637815568,
            332179504,
            3949051286,
            53804574,
            2852348879,
            3044236432,
            1282449977,
            3583942155,
            3416972820,
            4006381244,
            1617046695,
            2628476075,
            3002303598,
            1686838959,
            431878346,
            2686675385,
            1700445008,
            1080580658,
            1009431731,
            832498133,
            3223435511,
            2605976345,
            2271191193,
            2516031870,
            1648197032,
            4164389018,
            2548247927,
            300782431,
            375919233,
            238389289,
            3353747414,
            2531188641,
            2019080857,
            1475708069,
            455242339,
            2609103871,
            448939670,
            3451063019,
            1395535956,
            2413381860,
            1841049896,
            1491858159,
            885456874,
            4264095073,
            4001119347,
            1565136089,
            3898914787,
            1108368660,
            540939232,
            1173283510,
            2745871338,
            3681308437,
            4207628240,
            3343053890,
            4016749493,
            1699691293,
            1103962373,
            3625875870,
            2256883143,
            3830138730,
            1031889488,
            3479347698,
            1535977030,
            4236805024,
            3251091107,
            2132092099,
            1774941330,
            1199868427,
            1452454533,
            157007616,
            2904115357,
            342012276,
            595725824,
            1480756522,
            206960106,
            497939518,
            591360097,
            863170706,
            2375253569,
            3596610801,
            1814182875,
            2094937945,
            3421402208,
            1082520231,
            3463918190,
            2785509508,
            435703966,
            3908032597,
            1641649973,
            2842273706,
            3305899714,
            1510255612,
            2148256476,
            2655287854,
            3276092548,
            4258621189,
            236887753,
            3681803219,
            274041037,
            1734335097,
            3815195456,
            3317970021,
            1899903192,
            1026095262,
            4050517792,
            356393447,
            2410691914,
            3873677099,
            3682840055
          ],
          [
            3913112168,
            2491498743,
            4132185628,
            2489919796,
            1091903735,
            1979897079,
            3170134830,
            3567386728,
            3557303409,
            857797738,
            1136121015,
            1342202287,
            507115054,
            2535736646,
            337727348,
            3213592640,
            1301675037,
            2528481711,
            1895095763,
            1721773893,
            3216771564,
            62756741,
            2142006736,
            835421444,
            2531993523,
            1442658625,
            3659876326,
            2882144922,
            676362277,
            1392781812,
            170690266,
            3921047035,
            1759253602,
            3611846912,
            1745797284,
            664899054,
            1329594018,
            3901205900,
            3045908486,
            2062866102,
            2865634940,
            3543621612,
            3464012697,
            1080764994,
            553557557,
            3656615353,
            3996768171,
            991055499,
            499776247,
            1265440854,
            648242737,
            3940784050,
            980351604,
            3713745714,
            1749149687,
            3396870395,
            4211799374,
            3640570775,
            1161844396,
            3125318951,
            1431517754,
            545492359,
            4268468663,
            3499529547,
            1437099964,
            2702547544,
            3433638243,
            2581715763,
            2787789398,
            1060185593,
            1593081372,
            2418618748,
            4260947970,
            69676912,
            2159744348,
            86519011,
            2512459080,
            3838209314,
            1220612927,
            3339683548,
            133810670,
            1090789135,
            1078426020,
            1569222167,
            845107691,
            3583754449,
            4072456591,
            1091646820,
            628848692,
            1613405280,
            3757631651,
            526609435,
            236106946,
            48312990,
            2942717905,
            3402727701,
            1797494240,
            859738849,
            992217954,
            4005476642,
            2243076622,
            3870952857,
            3732016268,
            765654824,
            3490871365,
            2511836413,
            1685915746,
            3888969200,
            1414112111,
            2273134842,
            3281911079,
            4080962846,
            172450625,
            2569994100,
            980381355,
            4109958455,
            2819808352,
            2716589560,
            2568741196,
            3681446669,
            3329971472,
            1835478071,
            660984891,
            3704678404,
            4045999559,
            3422617507,
            3040415634,
            1762651403,
            1719377915,
            3470491036,
            2693910283,
            3642056355,
            3138596744,
            1364962596,
            2073328063,
            1983633131,
            926494387,
            3423689081,
            2150032023,
            4096667949,
            1749200295,
            3328846651,
            309677260,
            2016342300,
            1779581495,
            3079819751,
            111262694,
            1274766160,
            443224088,
            298511866,
            1025883608,
            3806446537,
            1145181785,
            168956806,
            3641502830,
            3584813610,
            1689216846,
            3666258015,
            3200248200,
            1692713982,
            2646376535,
            4042768518,
            1618508792,
            1610833997,
            3523052358,
            4130873264,
            2001055236,
            3610705100,
            2202168115,
            4028541809,
            2961195399,
            1006657119,
            2006996926,
            3186142756,
            1430667929,
            3210227297,
            1314452623,
            4074634658,
            4101304120,
            2273951170,
            1399257539,
            3367210612,
            3027628629,
            1190975929,
            2062231137,
            2333990788,
            2221543033,
            2438960610,
            1181637006,
            548689776,
            2362791313,
            3372408396,
            3104550113,
            3145860560,
            296247880,
            1970579870,
            3078560182,
            3769228297,
            1714227617,
            3291629107,
            3898220290,
            166772364,
            1251581989,
            493813264,
            448347421,
            195405023,
            2709975567,
            677966185,
            3703036547,
            1463355134,
            2715995803,
            1338867538,
            1343315457,
            2802222074,
            2684532164,
            233230375,
            2599980071,
            2000651841,
            3277868038,
            1638401717,
            4028070440,
            3237316320,
            6314154,
            819756386,
            300326615,
            590932579,
            1405279636,
            3267499572,
            3150704214,
            2428286686,
            3959192993,
            3461946742,
            1862657033,
            1266418056,
            963775037,
            2089974820,
            2263052895,
            1917689273,
            448879540,
            3550394620,
            3981727096,
            150775221,
            3627908307,
            1303187396,
            508620638,
            2975983352,
            2726630617,
            1817252668,
            1876281319,
            1457606340,
            908771278,
            3720792119,
            3617206836,
            2455994898,
            1729034894,
            1080033504
          ],
          [
            976866871,
            3556439503,
            2881648439,
            1522871579,
            1555064734,
            1336096578,
            3548522304,
            2579274686,
            3574697629,
            3205460757,
            3593280638,
            3338716283,
            3079412587,
            564236357,
            2993598910,
            1781952180,
            1464380207,
            3163844217,
            3332601554,
            1699332808,
            1393555694,
            1183702653,
            3581086237,
            1288719814,
            691649499,
            2847557200,
            2895455976,
            3193889540,
            2717570544,
            1781354906,
            1676643554,
            2592534050,
            3230253752,
            1126444790,
            2770207658,
            2633158820,
            2210423226,
            2615765581,
            2414155088,
            3127139286,
            673620729,
            2805611233,
            1269405062,
            4015350505,
            3341807571,
            4149409754,
            1057255273,
            2012875353,
            2162469141,
            2276492801,
            2601117357,
            993977747,
            3918593370,
            2654263191,
            753973209,
            36408145,
            2530585658,
            25011837,
            3520020182,
            2088578344,
            530523599,
            2918365339,
            1524020338,
            1518925132,
            3760827505,
            3759777254,
            1202760957,
            3985898139,
            3906192525,
            674977740,
            4174734889,
            2031300136,
            2019492241,
            3983892565,
            4153806404,
            3822280332,
            352677332,
            2297720250,
            60907813,
            90501309,
            3286998549,
            1016092578,
            2535922412,
            2839152426,
            457141659,
            509813237,
            4120667899,
            652014361,
            1966332200,
            2975202805,
            55981186,
            2327461051,
            676427537,
            3255491064,
            2882294119,
            3433927263,
            1307055953,
            942726286,
            933058658,
            2468411793,
            3933900994,
            4215176142,
            1361170020,
            2001714738,
            2830558078,
            3274259782,
            1222529897,
            1679025792,
            2729314320,
            3714953764,
            1770335741,
            151462246,
            3013232138,
            1682292957,
            1483529935,
            471910574,
            1539241949,
            458788160,
            3436315007,
            1807016891,
            3718408830,
            978976581,
            1043663428,
            3165965781,
            1927990952,
            4200891579,
            2372276910,
            3208408903,
            3533431907,
            1412390302,
            2931980059,
            4132332400,
            1947078029,
            3881505623,
            4168226417,
            2941484381,
            1077988104,
            1320477388,
            886195818,
            18198404,
            3786409e3,
            2509781533,
            112762804,
            3463356488,
            1866414978,
            891333506,
            18488651,
            661792760,
            1628790961,
            3885187036,
            3141171499,
            876946877,
            2693282273,
            1372485963,
            791857591,
            2686433993,
            3759982718,
            3167212022,
            3472953795,
            2716379847,
            445679433,
            3561995674,
            3504004811,
            3574258232,
            54117162,
            3331405415,
            2381918588,
            3769707343,
            4154350007,
            1140177722,
            4074052095,
            668550556,
            3214352940,
            367459370,
            261225585,
            2610173221,
            4209349473,
            3468074219,
            3265815641,
            314222801,
            3066103646,
            3808782860,
            282218597,
            3406013506,
            3773591054,
            379116347,
            1285071038,
            846784868,
            2669647154,
            3771962079,
            3550491691,
            2305946142,
            453669953,
            1268987020,
            3317592352,
            3279303384,
            3744833421,
            2610507566,
            3859509063,
            266596637,
            3847019092,
            517658769,
            3462560207,
            3443424879,
            370717030,
            4247526661,
            2224018117,
            4143653529,
            4112773975,
            2788324899,
            2477274417,
            1456262402,
            2901442914,
            1517677493,
            1846949527,
            2295493580,
            3734397586,
            2176403920,
            1280348187,
            1908823572,
            3871786941,
            846861322,
            1172426758,
            3287448474,
            3383383037,
            1655181056,
            3139813346,
            901632758,
            1897031941,
            2986607138,
            3066810236,
            3447102507,
            1393639104,
            373351379,
            950779232,
            625454576,
            3124240540,
            4148612726,
            2007998917,
            544563296,
            2244738638,
            2330496472,
            2058025392,
            1291430526,
            424198748,
            50039436,
            29584100,
            3605783033,
            2429876329,
            2791104160,
            1057563949,
            3255363231,
            3075367218,
            3463963227,
            1469046755,
            985887462
          ]
        ];
        var BLOWFISH_CTX = {
          pbox: [],
          sbox: []
        };
        function F(ctx, x2) {
          let a2 = x2 >> 24 & 255;
          let b2 = x2 >> 16 & 255;
          let c2 = x2 >> 8 & 255;
          let d = x2 & 255;
          let y2 = ctx.sbox[0][a2] + ctx.sbox[1][b2];
          y2 = y2 ^ ctx.sbox[2][c2];
          y2 = y2 + ctx.sbox[3][d];
          return y2;
        }
        function BlowFish_Encrypt(ctx, left, right) {
          let Xl = left;
          let Xr = right;
          let temp;
          for (let i2 = 0; i2 < N2; ++i2) {
            Xl = Xl ^ ctx.pbox[i2];
            Xr = F(ctx, Xl) ^ Xr;
            temp = Xl;
            Xl = Xr;
            Xr = temp;
          }
          temp = Xl;
          Xl = Xr;
          Xr = temp;
          Xr = Xr ^ ctx.pbox[N2];
          Xl = Xl ^ ctx.pbox[N2 + 1];
          return { left: Xl, right: Xr };
        }
        function BlowFish_Decrypt(ctx, left, right) {
          let Xl = left;
          let Xr = right;
          let temp;
          for (let i2 = N2 + 1; i2 > 1; --i2) {
            Xl = Xl ^ ctx.pbox[i2];
            Xr = F(ctx, Xl) ^ Xr;
            temp = Xl;
            Xl = Xr;
            Xr = temp;
          }
          temp = Xl;
          Xl = Xr;
          Xr = temp;
          Xr = Xr ^ ctx.pbox[1];
          Xl = Xl ^ ctx.pbox[0];
          return { left: Xl, right: Xr };
        }
        function BlowFishInit(ctx, key2, keysize) {
          for (let Row = 0; Row < 4; Row++) {
            ctx.sbox[Row] = [];
            for (let Col = 0; Col < 256; Col++) {
              ctx.sbox[Row][Col] = ORIG_S[Row][Col];
            }
          }
          let keyIndex = 0;
          for (let index2 = 0; index2 < N2 + 2; index2++) {
            ctx.pbox[index2] = ORIG_P[index2] ^ key2[keyIndex];
            keyIndex++;
            if (keyIndex >= keysize) {
              keyIndex = 0;
            }
          }
          let Data1 = 0;
          let Data2 = 0;
          let res = 0;
          for (let i2 = 0; i2 < N2 + 2; i2 += 2) {
            res = BlowFish_Encrypt(ctx, Data1, Data2);
            Data1 = res.left;
            Data2 = res.right;
            ctx.pbox[i2] = Data1;
            ctx.pbox[i2 + 1] = Data2;
          }
          for (let i2 = 0; i2 < 4; i2++) {
            for (let j = 0; j < 256; j += 2) {
              res = BlowFish_Encrypt(ctx, Data1, Data2);
              Data1 = res.left;
              Data2 = res.right;
              ctx.sbox[i2][j] = Data1;
              ctx.sbox[i2][j + 1] = Data2;
            }
          }
          return true;
        }
        var Blowfish = C_algo.Blowfish = BlockCipher.extend({
          _doReset: function() {
            if (this._keyPriorReset === this._key) {
              return;
            }
            var key2 = this._keyPriorReset = this._key;
            var keyWords = key2.words;
            var keySize = key2.sigBytes / 4;
            BlowFishInit(BLOWFISH_CTX, keyWords, keySize);
          },
          encryptBlock: function(M2, offset) {
            var res = BlowFish_Encrypt(BLOWFISH_CTX, M2[offset], M2[offset + 1]);
            M2[offset] = res.left;
            M2[offset + 1] = res.right;
          },
          decryptBlock: function(M2, offset) {
            var res = BlowFish_Decrypt(BLOWFISH_CTX, M2[offset], M2[offset + 1]);
            M2[offset] = res.left;
            M2[offset + 1] = res.right;
          },
          blockSize: 64 / 32,
          keySize: 128 / 32,
          ivSize: 64 / 32
        });
        C2.Blowfish = BlockCipher._createHelper(Blowfish);
      })();
      return CryptoJS2.Blowfish;
    });
  })(blowfish$1);
  return blowfish$1.exports;
}
var cryptoJs = cryptoJs$1.exports;
var hasRequiredCryptoJs;
function requireCryptoJs() {
  if (hasRequiredCryptoJs) return cryptoJs$1.exports;
  hasRequiredCryptoJs = 1;
  (function(module2, exports) {
    (function(root, factory, undef) {
      {
        module2.exports = factory(requireCore(), requireX64Core(), requireLibTypedarrays(), requireEncUtf16(), requireEncBase64(), requireEncBase64url(), requireMd5(), requireSha1(), requireSha256(), requireSha224(), requireSha512(), requireSha384(), requireSha3(), requireRipemd160(), requireHmac(), requirePbkdf2(), requireEvpkdf(), requireCipherCore(), requireModeCfb(), requireModeCtr(), requireModeCtrGladman(), requireModeOfb(), requireModeEcb(), requirePadAnsix923(), requirePadIso10126(), requirePadIso97971(), requirePadZeropadding(), requirePadNopadding(), requireFormatHex(), requireAes(), requireTripledes(), requireRc4(), requireRabbit(), requireRabbitLegacy(), requireBlowfish());
      }
    })(cryptoJs, function(CryptoJS2) {
      return CryptoJS2;
    });
  })(cryptoJs$1);
  return cryptoJs$1.exports;
}
var cryptoJsExports = requireCryptoJs();
const CryptoJS = /* @__PURE__ */ getDefaultExportFromCjs$1(cryptoJsExports);
var __assign$4 = function() {
  __assign$4 = Object.assign || function __assign2(t2) {
    for (var s2, i2 = 1, n2 = arguments.length; i2 < n2; i2++) {
      s2 = arguments[i2];
      for (var p2 in s2) if (Object.prototype.hasOwnProperty.call(s2, p2)) t2[p2] = s2[p2];
    }
    return t2;
  };
  return __assign$4.apply(this, arguments);
};
function __awaiter$e(thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function(resolve2) {
      resolve2(value);
    });
  }
  return new (P || (P = Promise))(function(resolve2, reject2) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e4) {
        reject2(e4);
      }
    }
    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e4) {
        reject2(e4);
      }
    }
    function step(result) {
      result.done ? resolve2(result.value) : adopt(result.value).then(fulfilled, rejected);
    }
    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}
function __generator$e(thisArg, body) {
  var _2 = { label: 0, sent: function() {
    if (t2[0] & 1) throw t2[1];
    return t2[1];
  }, trys: [], ops: [] }, f2, y2, t2, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
  return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() {
    return this;
  }), g;
  function verb(n2) {
    return function(v2) {
      return step([n2, v2]);
    };
  }
  function step(op) {
    if (f2) throw new TypeError("Generator is already executing.");
    while (g && (g = 0, op[0] && (_2 = 0)), _2) try {
      if (f2 = 1, y2 && (t2 = op[0] & 2 ? y2["return"] : op[0] ? y2["throw"] || ((t2 = y2["return"]) && t2.call(y2), 0) : y2.next) && !(t2 = t2.call(y2, op[1])).done) return t2;
      if (y2 = 0, t2) op = [op[0] & 2, t2.value];
      switch (op[0]) {
        ca